package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdjuntarCampanhatipoprot;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.TipProtocolo;

/**
 * AdjuntarCampanhatipoprotDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarCampanhatipoprotDaoImpl implements
		AdjuntarCampanhatipoprotDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntarCampanhatipoprot> rwMap = new RowMapper<AdjuntarCampanhatipoprot>() {
		public AdjuntarCampanhatipoprot mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarCampanhatipoprot(
					resultSet.getString("TPCODIGO"),
					resultSet.getString("CMCODIGO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            Pagination
	 * @return AdjuntarCampanhatipoprot
	 */
	public AdjuntarCampanhatipoprot add(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {
		String query = "INSERT INTO ADJUNTAR_CAMPANHATIPOPROT (TPCODIGO, CMCODIGO) VALUES (?,?)";

		this.jdbcTemplate.update(query, adjuntarcampanhatipoprot.getTpcodigo(),
				adjuntarcampanhatipoprot.getCmcodigo());
		return adjuntarcampanhatipoprot;
	}

	/**
	 * Updates a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            Pagination
	 * @return AdjuntarCampanhatipoprot
	 */
	public AdjuntarCampanhatipoprot update(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {
		String query = "UPDATE ADJUNTAR_CAMPANHATIPOPROT SET  WHERE TPCODIGO=? AND CMCODIGO=?";

		this.jdbcTemplate.update(query, adjuntarcampanhatipoprot.getTpcodigo(),
				adjuntarcampanhatipoprot.getCmcodigo());
		return adjuntarcampanhatipoprot;
	}

	/**
	 * Finds a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            Pagination
	 * @return AdjuntarCampanhatipoprot
	 */
	@Transactional(readOnly = true)
	public AdjuntarCampanhatipoprot find(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {
		String query = "SELECT t1.TPCODIGO TPCODIGO, t1.CMCODIGO CMCODIGO FROM ADJUNTAR_CAMPANHATIPOPROT t1  WHERE t1.TPCODIGO = ?   AND t1.CMCODIGO = ?  ";

		List<AdjuntarCampanhatipoprot> adjuntarcampanhatipoprotList = this.jdbcTemplate
				.query(query, this.rwMap,
						adjuntarcampanhatipoprot.getTpcodigo(),
						adjuntarcampanhatipoprot.getCmcodigo());
		return (AdjuntarCampanhatipoprot) DataAccessUtils
				.uniqueResult(adjuntarcampanhatipoprotList);
	}

	/**
	 * Removes a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {
		String query = "DELETE FROM ADJUNTAR_CAMPANHATIPOPROT WHERE TPCODIGO=? AND CMCODIGO=?";
		this.jdbcTemplate.update(query, adjuntarcampanhatipoprot.getTpcodigo(),
				adjuntarcampanhatipoprot.getCmcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhatipoprot> findAll(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TPCODIGO TPCODIGO,t1.CMCODIGO CMCODIGO ");
		query.append("FROM ADJUNTAR_CAMPANHATIPOPROT t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhatipoprot);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhatipoprot>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHATIPOPROT t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhatipoprot);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipProtocolo> findAllTipProtocolo(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT   t2.TPCODIGO TPCODIGO, t2.TPNOMBRE TPNOMBRE, t2.TPESTANDAR TPESTANDAR ");
		query.append("FROM ADJUNTAR_CAMPANHATIPOPROT t1, TIP_PROTOCOLO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhatipoprot);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.TPCODIGO = t2.TPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipProtocolo>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<TipProtocolo>() {
					public TipProtocolo mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new TipProtocolo(
								resultSet.getString("TPCODIGO"), resultSet
										.getString("TPNOMBRE"), null, resultSet
										.getString("TPESTANDAR"), null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTipProtocoloCount(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHATIPOPROT t1, TIP_PROTOCOLO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhatipoprot);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.TPCODIGO = t2.TPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjuntarCampanhatipoprot table using like.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhatipoprot> findAllLike(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TPCODIGO TPCODIGO,t1.CMCODIGO CMCODIGO ");
		query.append("FROM ADJUNTAR_CAMPANHATIPOPROT t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				adjuntarcampanhatipoprot, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhatipoprot>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhatipoprot table using like.
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHATIPOPROT t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				adjuntarcampanhatipoprot, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhatipoprot entity
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhatipoprotDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhatipoprot != null
				&& adjuntarcampanhatipoprot.getTpcodigo() != null) {
			where.append(" AND t1.TPCODIGO = ?");
			params.add(adjuntarcampanhatipoprot.getTpcodigo());
		}
		if (adjuntarcampanhatipoprot != null
				&& adjuntarcampanhatipoprot.getCmcodigo() != null) {
			where.append(" AND t1.CMCODIGO = ?");
			params.add(adjuntarcampanhatipoprot.getCmcodigo());
		}

		if (adjuntarcampanhatipoprot != null
				&& adjuntarcampanhatipoprot.getTpestandar() != null
				&& adjuntarcampanhatipoprot.getTpestandar().equals(
						Y41bConstantes.VALOR_SI)) {
			where.append(" AND t2.TPESTANDAR = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		if (adjuntarcampanhatipoprot != null
				&& adjuntarcampanhatipoprot.getTpestandar() != null
				&& adjuntarcampanhatipoprot.getTpestandar().equals(
						Y41bConstantes.VALOR_NO)) {
			where.append(" AND (t2.TPESTANDAR IS NULL OR t2.TPESTANDAR = ?) ");
			params.add(Y41bConstantes.VALOR_NO);
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhatipoprot entity
	 * 
	 * @param adjuntarcampanhatipoprot
	 *            AdjuntarCampanhatipoprot Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjuntarCampanhatipoprot adjuntarcampanhatipoprot,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhatipoprotDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhatipoprot != null
				&& adjuntarcampanhatipoprot.getTpcodigo() != null) {
			where.append(" AND UPPER(t1.TPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhatipoprot.getTpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhatipoprot.getTpcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TPCODIGO IS NOT NULL");
		}
		if (adjuntarcampanhatipoprot != null
				&& adjuntarcampanhatipoprot.getCmcodigo() != null) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhatipoprot.getCmcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhatipoprot.getCmcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CMCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	public void removeAllCampanhatipoprot(Campanha campanha) {
		String query = "DELETE FROM ADJUNTAR_CAMPANHATIPOPROT WHERE CMCODIGO = ?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhatipoprot(Campanha campanha) {

		String query = "INSERT INTO ADJUNTAR_CAMPANHATIPOPROT (TPCODIGO, CMCODIGO) SELECT TPCODIGO, CMCODIGO FROM CAMPANHA_TIPOPROTOCOLO t1 WHERE CMCODIGO = ?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

}
