package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CampanhaProgramacion;

/**
 * AdjuntarCampanhaprograDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarCampanhaprograDaoImpl implements AdjuntarCampanhaprograDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntarCampanhaprogra> rwMap = new RowMapper<AdjuntarCampanhaprogra>() {
		public AdjuntarCampanhaprogra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarCampanhaprogra(resultSet.getString("PGCODIGO"),
					resultSet.getString("PGNOMBRE"),
					resultSet.getString("PGCOTPG"),
					resultSet.getString("PGCOCM"),
					resultSet.getDate("PGFEDESD"),
					resultSet.getDate("PGFEHAST"),
					resultSet.getString("PGCOOR"),
					resultSet.getString("PGINSESE"),
					resultSet.getInt("PGNUMTOMASMUESTRASSOL"),
					resultSet.getInt("PGNUMCONTROLESESTANDARSOL"),
					resultSet.getInt("PGNUMCONTROLESOTROSSOL"),
					resultSet.getInt("PGNUMINSPECADICIONALESSOL"), null);
		}
	};

	private RowMapper<AdjuntarCampanhaprogra> rwMapConCierres = new RowMapper<AdjuntarCampanhaprogra>() {
		public AdjuntarCampanhaprogra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarCampanhaprogra(
					resultSet.getString("PGCODIGO"),
					resultSet.getString("PGNOMBRE"),
					resultSet.getString("PGCOTPG"),
					resultSet.getString("PGCOCM"),
					resultSet.getDate("PGFEDESD"),
					resultSet.getDate("PGFEHAST"),
					resultSet.getString("PGCOOR"),
					resultSet.getString("PGINSESE"),
					resultSet.getInt("PGNUMTOMASMUESTRASSOL"),
					resultSet.getInt("PGNUMCONTROLESESTANDARSOL"),
					resultSet.getInt("PGNUMCONTROLESOTROSSOL"),
					resultSet.getInt("PGNUMINSPECADICIONALESSOL"),
					new CampanhaCierre(null, null, null, null, resultSet
							.getString("tyfinalizadoaraba"), null, null,
							resultSet.getString("tyfinalizadobizkaia"), null,
							null, resultSet.getString("tyfinalizadogipuzkoa"),
							null, null, resultSet.getString("tyfinalizadosscc")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return AdjuntarCampanhaprogra
	 */
	public AdjuntarCampanhaprogra add(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		String query = "INSERT INTO ADJUNTAR_CAMPANHAPROGRA (PGCODIGO, PGNOMBRE, PGCOTPG, PGCOCM, PGFEDESD, PGFEHAST, PGCOOR, PGINSESE, PGNUM_TOMAS_MUESTRAS_SOL, PGNUM_CONTROLES_ESTANDAR_SOL, PGNUM_CONTROLES_OTROS_SOL, PGNUM_INSPEC_ADICIONALES_SOL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjuntarcampanhaprogra.getPgcodigo(),
				adjuntarcampanhaprogra.getPgnombre(),
				adjuntarcampanhaprogra.getPgcotpg(),
				adjuntarcampanhaprogra.getPgcocm(),
				adjuntarcampanhaprogra.getPgfedesd(),
				adjuntarcampanhaprogra.getPgfehast(),
				adjuntarcampanhaprogra.getPgcoor(),
				adjuntarcampanhaprogra.getPginsese(),
				adjuntarcampanhaprogra.getPgnumTomasMuestrasSol(),
				adjuntarcampanhaprogra.getPgnumControlesEstandarSol(),
				adjuntarcampanhaprogra.getPgnumControlesOtrosSol(),
				adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol());
		return adjuntarcampanhaprogra;
	}

	/**
	 * Updates a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return AdjuntarCampanhaprogra
	 */
	public AdjuntarCampanhaprogra update(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		String query = "UPDATE ADJUNTAR_CAMPANHAPROGRA SET  WHERE PGCODIGO=? AND PGNOMBRE=? AND PGCOTPG=? AND PGCOCM=? AND PGFEDESD=? AND PGFEHAST=? AND PGCOOR=? AND PGINSESE=? AND PGNUM_TOMAS_MUESTRAS_SOL=? AND PGNUM_CONTROLES_ESTANDAR_SOL=? AND PGNUM_CONTROLES_OTROS_SOL=? AND PGNUM_INSPEC_ADICIONALES_SOL=?";
		this.jdbcTemplate.update(query, adjuntarcampanhaprogra.getPgcodigo(),
				adjuntarcampanhaprogra.getPgnombre(),
				adjuntarcampanhaprogra.getPgcotpg(),
				adjuntarcampanhaprogra.getPgcocm(),
				adjuntarcampanhaprogra.getPgfedesd(),
				adjuntarcampanhaprogra.getPgfehast(),
				adjuntarcampanhaprogra.getPgcoor(),
				adjuntarcampanhaprogra.getPginsese(),
				adjuntarcampanhaprogra.getPgnumTomasMuestrasSol(),
				adjuntarcampanhaprogra.getPgnumControlesEstandarSol(),
				adjuntarcampanhaprogra.getPgnumControlesOtrosSol(),
				adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol());
		return adjuntarcampanhaprogra;
	}

	/**
	 * Updates a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return AdjuntarCampanhaprogra
	 */
	public AdjuntarCampanhaprogra updateInspeccionAdicional(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		String query = "UPDATE ADJUNTAR_CAMPANHAPROGRA SET  PGNUM_INSPEC_ADICIONALES_SOL= NVL(PGNUM_INSPEC_ADICIONALES_SOL,0) + ?  WHERE PGCODIGO=? ";
		this.jdbcTemplate.update(query,
				adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol(),
				adjuntarcampanhaprogra.getPgcodigo());
		return adjuntarcampanhaprogra;
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return AdjuntarCampanhaprogra
	 */
	@Transactional(readOnly = true)
	public AdjuntarCampanhaprogra find(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		String query = "SELECT t1.PGCODIGO PGCODIGO, t1.PGNOMBRE PGNOMBRE, t1.PGCOTPG PGCOTPG, t1.PGCOCM PGCOCM, t1.PGFEDESD PGFEDESD, t1.PGFEHAST PGFEHAST, t1.PGCOOR PGCOOR, t1.PGINSESE PGINSESE, t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL, t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL, t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL, t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL FROM ADJUNTAR_CAMPANHAPROGRA t1  WHERE t1.PGCODIGO = ?  ";

		List<AdjuntarCampanhaprogra> adjuntarcampanhaprograList = this.jdbcTemplate
				.query(query, this.rwMap, adjuntarcampanhaprogra.getPgcodigo());
		return (AdjuntarCampanhaprogra) DataAccessUtils
				.uniqueResult(adjuntarcampanhaprograList);
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return AdjuntarCampanhaprogra
	 */
	@Transactional(readOnly = true)
	public AdjuntarCampanhaprogra findConCierres(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		String query = "SELECT t1.PGCODIGO PGCODIGO, t1.PGNOMBRE PGNOMBRE, t1.PGCOTPG PGCOTPG, t1.PGCOCM PGCOCM, t1.PGFEDESD PGFEDESD, t1.PGFEHAST PGFEHAST, t1.PGCOOR PGCOOR, t1.PGINSESE PGINSESE, t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL, t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL, t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL, t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL, t2.TYFINALIZADOARABA TYFINALIZADOARABA, t2.TYFINALIZADOBIZKAIA TYFINALIZADOBIZKAIA, t2.TYFINALIZADOGIPUZKOA TYFINALIZADOGIPUZKOA, t2.TYFINALIZADOSSCC TYFINALIZADOSSCC FROM CAMPANHA_PROGRAMACION t1, CAMPANHA_CIERRE t2 WHERE t1.PGCOCM = t2.TYCMCODIGO (+) AND t1.PGCODIGO = ? AND t1.PGCOCM = ?";

		List<AdjuntarCampanhaprogra> adjuntarcampanhaprograList = this.jdbcTemplate
				.query(query, this.rwMapConCierres,
						adjuntarcampanhaprogra.getPgcodigo(),
						adjuntarcampanhaprogra.getPgcocm());
		return (AdjuntarCampanhaprogra) DataAccessUtils
				.uniqueResult(adjuntarcampanhaprograList);
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	@Transactional(readOnly = true)
	public CampanhaProgramacion findLimitesCampanhaFase(
			CampanhaProgramacion campanhaprogramacion) {
		String query = "SELECT MIN(t1.PGFEDESD) FECHAINICIO, MAX(t1.PGFEHAST) FECHAFIN FROM ADJUNTAR_CAMPANHAPROGRA t1  WHERE t1.PGCOCM= ? ";

		List<CampanhaProgramacion> campanhaprogramacionList = this.jdbcTemplate
				.query(query, new RowMapper<CampanhaProgramacion>() {
					public CampanhaProgramacion mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new CampanhaProgramacion(resultSet
								.getTimestamp("FECHAINICIO"), resultSet
								.getTimestamp("FECHAFIN"));
					}
				}, campanhaprogramacion.getCampanha().getCmcodigo());
		return (CampanhaProgramacion) DataAccessUtils
				.uniqueResult(campanhaprogramacionList);
	}

	/**
	 * Removes a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		String query = "DELETE FROM ADJUNTAR_CAMPANHAPROGRA WHERE PGCODIGO=? ";
		this.jdbcTemplate.update(query, adjuntarcampanhaprogra.getPgcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhaprogra> findAll(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PGCODIGO PGCODIGO,t1.PGNOMBRE PGNOMBRE,t1.PGCOTPG PGCOTPG,t1.PGCOCM PGCOCM,t1.PGFEDESD PGFEDESD,t1.PGFEHAST PGFEHAST,t1.PGCOOR PGCOOR,t1.PGINSESE PGINSESE,t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL,t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL,t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL,t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL ");
		query.append("FROM ADJUNTAR_CAMPANHAPROGRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhaprogra);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhaprogra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPROGRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhaprogra);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhaprogra> findAllLike(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PGCODIGO PGCODIGO,t1.PGNOMBRE PGNOMBRE,t1.PGCOTPG PGCOTPG,t1.PGCOCM PGCOCM,t1.PGFEDESD PGFEDESD,t1.PGFEHAST PGFEHAST,t1.PGCOOR PGCOOR,t1.PGINSESE PGINSESE,t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL,t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL,t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL,t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL ");
		query.append("FROM ADJUNTAR_CAMPANHAPROGRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntarcampanhaprogra,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhaprogra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjuntarCampanhaprogra adjuntarcampanhaprogra,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPROGRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntarcampanhaprogra,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhaprogra entity
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhaprograDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcodigo() != null) {
			where.append(" AND t1.PGCODIGO = ?");
			params.add(adjuntarcampanhaprogra.getPgcodigo());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnombre() != null) {
			where.append(" AND t1.PGNOMBRE = ?");
			params.add(adjuntarcampanhaprogra.getPgnombre());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcotpg() != null) {
			where.append(" AND t1.PGCOTPG = ?");
			params.add(adjuntarcampanhaprogra.getPgcotpg());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcocm() != null) {
			where.append(" AND t1.PGCOCM = ?");
			params.add(adjuntarcampanhaprogra.getPgcocm());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgfedesd() != null) {
			where.append(" AND t1.PGFEDESD = ?");
			params.add(adjuntarcampanhaprogra.getPgfedesd());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgfehast() != null) {
			where.append(" AND t1.PGFEHAST = ?");
			params.add(adjuntarcampanhaprogra.getPgfehast());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcoor() != null) {
			where.append(" AND t1.PGCOOR = ?");
			params.add(adjuntarcampanhaprogra.getPgcoor());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPginsese() != null) {
			where.append(" AND t1.PGINSESE = ?");
			params.add(adjuntarcampanhaprogra.getPginsese());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumTomasMuestrasSol() != null) {
			where.append(" AND t1.PGNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumTomasMuestrasSol());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumControlesEstandarSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumControlesEstandarSol());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumControlesOtrosSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_OTROS_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumControlesOtrosSol());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol() != null) {
			where.append(" AND t1.PGNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhaprogra entity
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhaprograDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcodigo() != null) {
			where.append(" AND UPPER(t1.PGCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaprogra.getPgcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaprogra.getPgcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PGCODIGO IS NOT NULL");
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnombre() != null) {
			where.append(" AND UPPER(t1.PGNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaprogra.getPgnombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaprogra.getPgnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PGNOMBRE IS NOT NULL");
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcotpg() != null) {
			where.append(" AND UPPER(t1.PGCOTPG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaprogra.getPgcotpg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaprogra.getPgcotpg().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PGCOTPG IS NOT NULL");
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcocm() != null) {
			where.append(" AND UPPER(t1.PGCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaprogra.getPgcocm().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaprogra.getPgcocm().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PGCOCM IS NOT NULL");
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgfedesd() != null) {
			where.append(" AND t1.PGFEDESD = ?");
			params.add(adjuntarcampanhaprogra.getPgfedesd());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgfehast() != null) {
			where.append(" AND t1.PGFEHAST = ?");
			params.add(adjuntarcampanhaprogra.getPgfehast());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcoor() != null) {
			where.append(" AND UPPER(t1.PGCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaprogra.getPgcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaprogra.getPgcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PGCOOR IS NOT NULL");
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPginsese() != null) {
			where.append(" AND UPPER(t1.PGINSESE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaprogra.getPginsese().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaprogra.getPginsese().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PGINSESE IS NOT NULL");
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumTomasMuestrasSol() != null) {
			where.append(" AND t1.PGNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumTomasMuestrasSol());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumControlesEstandarSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumControlesEstandarSol());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumControlesOtrosSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_OTROS_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumControlesOtrosSol());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol() != null) {
			where.append(" AND t1.PGNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(adjuntarcampanhaprogra.getPgnumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	public void removeAllCampanhaprogra(Campanha campanha) {
		String query = "DELETE FROM ADJUNTAR_CAMPANHAPROGRA WHERE PGCOCM = ?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhaprogra(Campanha campanha) {

		String query = "INSERT INTO ADJUNTAR_CAMPANHAPROGRA (PGCODIGO, PGNOMBRE, PGCOTPG, PGCOCM, PGFEDESD, PGFEHAST, PGCOOR, PGINSESE, PGNUM_TOMAS_MUESTRAS_SOL, PGNUM_CONTROLES_ESTANDAR_SOL, PGNUM_CONTROLES_OTROS_SOL, PGNUM_INSPEC_ADICIONALES_SOL) SELECT PGCODIGO, PGNOMBRE, PGCOTPG, PGCOCM, PGFEDESD, PGFEHAST, PGCOOR, PGINSESE, PGNUM_TOMAS_MUESTRAS_SOL, PGNUM_CONTROLES_ESTANDAR_SOL, PGNUM_CONTROLES_OTROS_SOL, PGNUM_INSPEC_ADICIONALES_SOL FROM CAMPANHA_PROGRAMACION t1 WHERE PGCOCM = ?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhaprogra> findAllCampanhaProgramacionNuevas(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.PGCODIGO PGCODIGO ");
		query.append("FROM ADJUNTAR_CAMPANHAPROGRA t1 ");

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(
				" WHERE 1=1  AND t1.PGCODIGO NOT IN (SELECT tt1.PGCODIGO FROM CAMPANHA_PROGRAMACION tt1 WHERE tt1.PGCOCM = t1.PGCOCM) AND t1.PGCOCM=?");
		params.add(adjuntarcampanhaprogra.getPgcocm());
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhaprogra>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AdjuntarCampanhaprogra>() {
					public AdjuntarCampanhaprogra mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AdjuntarCampanhaprogra(resultSet
								.getString("PGCODIGO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCampanhaOrganismoCount(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPROGRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereCampanhaOrganismoMap(adjuntarcampanhaprogra);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhaprogra entity
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereCampanhaOrganismoMap(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhaprograDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcocm() != null) {
			where.append(" AND t1.PGCOCM = ?");
			params.add(adjuntarcampanhaprogra.getPgcocm());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgcoor() != null) {
			where.append(" AND t1.PGCOOR = ?");
			params.add(adjuntarcampanhaprogra.getPgcoor());
		}
		if (adjuntarcampanhaprogra != null
				&& adjuntarcampanhaprogra.getPgfedesd() != null) {
			where.append(" AND t1.PGFEDESD = ?");
			params.add(adjuntarcampanhaprogra.getPgfedesd());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
