package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProgramacion;

/**
 * AdjuntarCampanhaprograDao  
 * 
 *  
 */

public interface AdjuntarCampanhaprograDao {

	/**
	 * Inserts a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra add(AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Updates a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra update(AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Updates a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            Pagination
	 * @return AdjuntarCampanhaprogra
	 */
	public AdjuntarCampanhaprogra updateInspeccionAdicional(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra find(AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return AdjuntarCampanhaprogra
	 */
	AdjuntarCampanhaprogra findConCierres(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Finds a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion findLimitesCampanhaFase(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Deletes a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return
	 */
	void remove(AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarCampanhaprogra> findAll(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return Long
	 */
	Long findAllCount(AdjuntarCampanhaprogra adjuntarcampanhaprogra);

	/**
	 * Finds rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarCampanhaprogra> findAllLike(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table using like.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarCampanhaprogra adjuntarcampanhaprogra,
			Boolean startsWith);

	/**
	 * Removes a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	public void removeAllCampanhaprogra(Campanha campanha);

	/**
	 * Inserts a single row in the AdjuntarCampanhaprogra table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhaprogra(Campanha campanha);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarCampanhaprogra> findAllCampanhaProgramacionNuevas(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarcampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @return Long
	 */
	public Long findAllCampanhaOrganismoCount(
			AdjuntarCampanhaprogra adjuntarcampanhaprogra);
}
