package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.Producto;

/**
 * AdjuntarCampanhaproductoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarCampanhaproductoDaoImpl implements
		AdjuntarCampanhaproductoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntarCampanhaproducto> rwMap = new RowMapper<AdjuntarCampanhaproducto>() {
		public AdjuntarCampanhaproducto mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarCampanhaproducto(
					resultSet.getString("CPCODIGO"),
					resultSet.getString("CPCOCM"),
					resultSet.getString("CPCOPS"),
					resultSet.getString("CPNOPS"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            Pagination
	 * @return AdjuntarCampanhaproducto
	 */
	public AdjuntarCampanhaproducto add(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		String query = "INSERT INTO ADJUNTAR_CAMPANHAPRODUCTO (CPCODIGO, CPCOCM, CPCOPS, CPNOPS) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, adjuntarcampanhaproducto.getCpcodigo(),
				adjuntarcampanhaproducto.getCpcocm(),
				adjuntarcampanhaproducto.getCpcops(),
				adjuntarcampanhaproducto.getCpnops());
		return adjuntarcampanhaproducto;
	}

	/**
	 * Updates a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            Pagination
	 * @return AdjuntarCampanhaproducto
	 */
	public AdjuntarCampanhaproducto update(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		String query = "UPDATE ADJUNTAR_CAMPANHAPRODUCTO SET CPCOCM=?, CPCOPS=?, CPNOPS=? WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, adjuntarcampanhaproducto.getCpcocm(),
				adjuntarcampanhaproducto.getCpcops(),
				adjuntarcampanhaproducto.getCpnops(),
				adjuntarcampanhaproducto.getCpcodigo());
		return adjuntarcampanhaproducto;
	}

	/**
	 * Finds a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            Pagination
	 * @return AdjuntarCampanhaproducto
	 */
	@Transactional(readOnly = true)
	public AdjuntarCampanhaproducto find(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		String query = "SELECT t1.CPCODIGO CPCODIGO, t1.CPCOCM CPCOCM, t1.CPCOPS CPCOPS, t1.CPNOPS CPNOPS FROM ADJUNTAR_CAMPANHAPRODUCTO t1  WHERE t1.CPCODIGO = ?  ";

		List<AdjuntarCampanhaproducto> adjuntarcampanhaproductoList = this.jdbcTemplate
				.query(query, this.rwMap,
						adjuntarcampanhaproducto.getCpcodigo());
		return (AdjuntarCampanhaproducto) DataAccessUtils
				.uniqueResult(adjuntarcampanhaproductoList);
	}

	/**
	 * Removes a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		String query = "DELETE FROM ADJUNTAR_CAMPANHAPRODUCTO WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, adjuntarcampanhaproducto.getCpcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhaproducto> findAll(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPCOCM CPCOCM,t1.CPCOPS CPCOPS,t1.CPNOPS CPNOPS ");
		query.append("FROM ADJUNTAR_CAMPANHAPRODUCTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhaproducto);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhaproducto>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPRODUCTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhaproducto);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllProductoCount(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPRODUCTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereProductoMap(adjuntarcampanhaproducto);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhaproducto> findAllCampanhaproducto(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPCOCM CPCOCM,t1.CPCOPS CPCOPS,t1.CPNOPS CPNOPS, t2.PSCODIGO PSCODIGO, t2.PSNOMBRE PSNOMBRE, t2.PSNOCO PSNOCO, t2.PSDESCRI PSDESCRI, t2.PSCOSE PSCOSE, t2.PSNOMBREE PSNOMBREE, t2.PSNOMBREI PSNOMBREI, t2.PSNOMBREF PSNOMBREF, t2.PSNOMBREA PSNOMBREA, t2.PSNOCOE PSNOCOE, t2.PSNOCOI PSNOCOI, t2.PSNOCOF PSNOCOF, t2.PSNOCOA PSNOCOA, t2.PSDESCRIE PSDESCRIE, t2.PSDESCRII PSDESCRII, t2.PSDESCRIF PSDESCRIF, t2.PSDESCRIA PSDESCRIA, t2.PSSEL1 PSSEL1, t2.PSCOINC PSCOINC ");
		query.append("FROM ADJUNTAR_CAMPANHAPRODUCTO t1, PRODUCTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhaproducto);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CPCOPS = t2.PSCODIGO(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhaproducto>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AdjuntarCampanhaproducto>() {
					public AdjuntarCampanhaproducto mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AdjuntarCampanhaproducto(resultSet
								.getString("CPCODIGO"), resultSet
								.getString("CPCOCM"), resultSet
								.getString("CPCOPS"), resultSet
								.getString("CPNOPS"), new Producto(resultSet
								.getString("PSCODIGO"), resultSet
								.getString("PSNOMBRE"), resultSet
								.getString("PSNOCO"), resultSet
								.getString("PSDESCRI"), resultSet
								.getString("PSCOSE"), resultSet
								.getString("PSNOMBREE"), resultSet
								.getString("PSNOMBREI"), resultSet
								.getString("PSNOMBREF"), resultSet
								.getString("PSNOMBREA"), resultSet
								.getString("PSNOCOE"), resultSet
								.getString("PSNOCOI"), resultSet
								.getString("PSNOCOF"), resultSet
								.getString("PSNOCOA"), resultSet
								.getString("PSDESCRIE"), resultSet
								.getString("PSDESCRII"), resultSet
								.getString("PSDESCRIF"), resultSet
								.getString("PSDESCRIA"), resultSet
								.getString("PSSEL1"), resultSet
								.getString("PSCOINC"), null));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCampanhaproductoCount(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPRODUCTO t1, PRODUCTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcampanhaproducto);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CPCOPS = t2.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjuntarCampanhaproducto table using like.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarCampanhaproducto> findAllLike(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPCOCM CPCOCM,t1.CPCOPS CPCOPS,t1.CPNOPS CPNOPS ");
		query.append("FROM ADJUNTAR_CAMPANHAPRODUCTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				adjuntarcampanhaproducto, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarCampanhaproducto>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table using like.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPRODUCTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				adjuntarcampanhaproducto, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhaproducto entity
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhaproductoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcodigo() != null) {
			where.append(" AND t1.CPCODIGO = ?");
			params.add(adjuntarcampanhaproducto.getCpcodigo());
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcocm() != null) {
			where.append(" AND t1.CPCOCM = ?");
			params.add(adjuntarcampanhaproducto.getCpcocm());
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcops() != null) {
			where.append(" AND t1.CPCOPS = ?");
			params.add(adjuntarcampanhaproducto.getCpcops());
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpnops() != null) {
			where.append(" AND t1.CPNOPS = ?");
			params.add(adjuntarcampanhaproducto.getCpnops());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhaproducto entity
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereProductoMap(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhaproductoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcodigo() != null) {
			where.append(" AND t1.CPCODIGO = ?");
			params.add(adjuntarcampanhaproducto.getCpcodigo());
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcocm() != null) {
			where.append(" AND t1.CPCOCM = ?");
			params.add(adjuntarcampanhaproducto.getCpcocm());
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcops() != null) {
			where.append(" AND t1.CPCOPS = ?");
			params.add(adjuntarcampanhaproducto.getCpcops());
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpnops() != null) {
			where.append(" AND UPPER(t1.CPNOPS) = ? ");
			params.add(adjuntarcampanhaproducto.getCpnops().toUpperCase());
		} else {
			where.append(" AND t1.CPNOPS IS NULL ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarCampanhaproducto entity
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarCampanhaproductoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcodigo() != null) {
			where.append(" AND UPPER(t1.CPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaproducto.getCpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaproducto.getCpcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPCODIGO IS NOT NULL");
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcocm() != null) {
			where.append(" AND UPPER(t1.CPCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaproducto.getCpcocm().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaproducto.getCpcocm().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPCOCM IS NOT NULL");
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpcops() != null) {
			where.append(" AND UPPER(t1.CPCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaproducto.getCpcops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaproducto.getCpcops().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPCOPS IS NOT NULL");
		}
		if (adjuntarcampanhaproducto != null
				&& adjuntarcampanhaproducto.getCpnops() != null) {
			where.append(" AND UPPER(t1.CPNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcampanhaproducto.getCpnops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcampanhaproducto.getCpnops().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPNOPS IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	public void removeAllCampanhaproducto(Campanha campanha) {
		String query = "DELETE FROM ADJUNTAR_CAMPANHAPRODUCTO WHERE CPCOCM = ?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Inserts a single row in the AdjuntarCampanhaproducto table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void addCampanhaproducto(Campanha campanha) {

		String query = "INSERT INTO ADJUNTAR_CAMPANHAPRODUCTO (CPCODIGO, CPCOCM, CPCOPS, CPNOPS) SELECT CPCODIGO, CPCOCM, CPCOPS, CPNOPS FROM CAMPANHA_PROD t1 WHERE CPCOCM = ?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}
}
