package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarAlertaprogra;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * AdjuntarAlertaprograDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarAlertaprograDaoImpl implements AdjuntarAlertaprograDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntarAlertaprogra> rwMap = new RowMapper<AdjuntarAlertaprogra>() {
		public AdjuntarAlertaprogra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarAlertaprogra(
					resultSet.getString("CRCODIGO"),
					resultSet.getString("CRCOAL"),
					resultSet.getString("CRCOOR"),
					resultSet.getDate("CRFERERE"),
					resultSet.getString("CRTEINFO"),
					resultSet.getInt("CRCNACTU"),
					resultSet.getString("CRINPRSE"),
					resultSet.getString("CRCODIGODISTRIBUIDOR"),
					resultSet.getDate("CRFECHACOMUNICACION"),
					resultSet.getDate("CRFECHAPLAZO"),
					resultSet.getDate("CRFECHACIERRE"),
					new TipoCaracterAlerta(resultSet
							.getString("TipoCaracterAlertaTCACODIGO"),
							resultSet.getString("TipoCaracterAlertaTCANOMBRE"),
							resultSet.getString("TipoCaracterAlertaTCANOMBREE")),
					resultSet.getString("CRACUERDOINICIO"), resultSet
							.getString("CRINSPECCIONSOLICITADA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            Pagination
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra add(AdjuntarAlertaprogra adjuntaralertaprogra) {
		String query = "INSERT INTO ADJUNTAR_ALERTAPROGRA (CRCODIGO, CRTIPO, CRCOAL, CRCOOR, CRFERERE, CRTEINFO, CRCNACTU, CRINPRSE, CRCODIGODISTRIBUIDOR, CRFECHACOMUNICACION, CRFECHAPLAZO, CRFECHACIERRE, CRACUERDOINICIO, CRINSPECCIONSOLICITADA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getTipoCaracterAlertaTcacodigoAux = null;
		if (adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcacodigo() != null) {
			getTipoCaracterAlertaTcacodigoAux = adjuntaralertaprogra
					.getTipoCaracterAlerta().getTcacodigo();
		}
		this.jdbcTemplate.update(query, adjuntaralertaprogra.getCrcodigo(),
				getTipoCaracterAlertaTcacodigoAux,
				adjuntaralertaprogra.getCrcoal(),
				adjuntaralertaprogra.getCrcoor(),
				adjuntaralertaprogra.getCrferere(),
				adjuntaralertaprogra.getCrteinfo(),
				adjuntaralertaprogra.getCrcnactu(),
				adjuntaralertaprogra.getCrinprse(),
				adjuntaralertaprogra.getCrcodigodistribuidor(),
				adjuntaralertaprogra.getCrfechacomunicacion(),
				adjuntaralertaprogra.getCrfechaplazo(),
				adjuntaralertaprogra.getCrfechacierre(),
				adjuntaralertaprogra.getCracuerdoinicio(),
				adjuntaralertaprogra.getCrinspeccionsolicitada());
		return adjuntaralertaprogra;
	}

	/**
	 * Updates a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            Pagination
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra update(AdjuntarAlertaprogra adjuntaralertaprogra) {
		String query = "UPDATE ADJUNTAR_ALERTAPROGRA SET CRTIPO=?, CRCOAL=?, CRCOOR=?, CRFERERE=?, CRTEINFO=?, CRCNACTU=?, CRINPRSE=?, CRCODIGODISTRIBUIDOR=?, CRFECHACOMUNICACION=?, CRFECHAPLAZO=?, CRFECHACIERRE=?, CRACUERDOINICIO=?, CRINSPECCIONSOLICITADA=? WHERE CRCODIGO=?";
		Object getTipoCaracterAlertaTcacodigoAux = null;
		if (adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcacodigo() != null) {
			getTipoCaracterAlertaTcacodigoAux = adjuntaralertaprogra
					.getTipoCaracterAlerta().getTcacodigo();
		}
		this.jdbcTemplate.update(query, getTipoCaracterAlertaTcacodigoAux,
				adjuntaralertaprogra.getCrcoal(),
				adjuntaralertaprogra.getCrcoor(),
				adjuntaralertaprogra.getCrferere(),
				adjuntaralertaprogra.getCrteinfo(),
				adjuntaralertaprogra.getCrcnactu(),
				adjuntaralertaprogra.getCrinprse(),
				adjuntaralertaprogra.getCrcodigodistribuidor(),
				adjuntaralertaprogra.getCrfechacomunicacion(),
				adjuntaralertaprogra.getCrfechaplazo(),
				adjuntaralertaprogra.getCrfechacierre(),
				adjuntaralertaprogra.getCracuerdoinicio(),
				adjuntaralertaprogra.getCrinspeccionsolicitada(),
				adjuntaralertaprogra.getCrcodigo());
		return adjuntaralertaprogra;
	}

	/**
	 * Updates a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            Pagination
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra updateNumActuaciones(
			AdjuntarAlertaprogra adjuntaralertaprogra) {
		String query = "UPDATE ADJUNTAR_ALERTAPROGRA SET CRCNACTU=? WHERE CRCODIGO=?";

		this.jdbcTemplate.update(query, adjuntaralertaprogra.getCrcnactu(),
				adjuntaralertaprogra.getCrcodigo());
		return adjuntaralertaprogra;
	}

	/**
	 * Finds a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            Pagination
	 * @return AdjuntarAlertaprogra
	 */
	@Transactional(readOnly = true)
	public AdjuntarAlertaprogra find(AdjuntarAlertaprogra adjuntaralertaprogra) {
		String query = "SELECT t1.CRCODIGO CRCODIGO, t1.CRCOAL CRCOAL, t1.CRCOOR CRCOOR, t1.CRFERERE CRFERERE, t1.CRTEINFO CRTEINFO, t1.CRCNACTU CRCNACTU, t1.CRINPRSE CRINPRSE, t1.CRCODIGODISTRIBUIDOR CRCODIGODISTRIBUIDOR, t1.CRFECHACOMUNICACION CRFECHACOMUNICACION, t1.CRFECHAPLAZO CRFECHAPLAZO, t1.CRFECHACIERRE CRFECHACIERRE, t1.CRACUERDOINICIO CRACUERDOINICIO, t1.CRINSPECCIONSOLICITADA CRINSPECCIONSOLICITADA, t2.TCACODIGO TIPOCARACTERALERTATCACODIGO, t2.TCANOMBRE TIPOCARACTERALERTATCANOMBRE, t2.TCANOMBREE TIPOCARACTERALERTATCANOMBREE FROM ADJUNTAR_ALERTAPROGRA t1 , TIPO_CARACTER_ALERTA t2  WHERE t1.CRCODIGO = ?   AND t1.CRTIPO= t2.TCACODIGO(+)";

		List<AdjuntarAlertaprogra> adjuntaralertaprograList = this.jdbcTemplate
				.query(query, this.rwMap, adjuntaralertaprogra.getCrcodigo());
		return (AdjuntarAlertaprogra) DataAccessUtils
				.uniqueResult(adjuntaralertaprograList);
	}

	/**
	 * Removes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntarAlertaprogra adjuntaralertaprogra) {
		String query = "DELETE FROM ADJUNTAR_ALERTAPROGRA WHERE CRCODIGO=?";
		this.jdbcTemplate.update(query, adjuntaralertaprogra.getCrcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarAlertaprogra> findAll(
			AdjuntarAlertaprogra adjuntaralertaprogra, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CRCODIGO CRCODIGO,t1.CRCOAL CRCOAL,t1.CRCOOR CRCOOR,t1.CRFERERE CRFERERE,t1.CRTEINFO CRTEINFO,t1.CRCNACTU CRCNACTU,t1.CRINPRSE CRINPRSE,t1.CRCODIGODISTRIBUIDOR CRCODIGODISTRIBUIDOR,t1.CRFECHACOMUNICACION CRFECHACOMUNICACION,t1.CRFECHAPLAZO CRFECHAPLAZO,t1.CRFECHACIERRE CRFECHACIERRE,t1.CRACUERDOINICIO CRACUERDOINICIO, t1.CRINSPECCIONSOLICITADA CRINSPECCIONSOLICITADA,t2.TCACODIGO TIPOCARACTERALERTATCACODIGO,t2.TCANOMBRE TIPOCARACTERALERTATCANOMBRE,t2.TCANOMBREE TIPOCARACTERALERTATCANOMBREE ");
		query.append("FROM ADJUNTAR_ALERTAPROGRA t1 ,TIPO_CARACTER_ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntaralertaprogra);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRTIPO= t2.TCACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarAlertaprogra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntarAlertaprogra adjuntaralertaprogra) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_ALERTAPROGRA t1 , TIPO_CARACTER_ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntaralertaprogra);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRTIPO= t2.TCACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarAlertaprogra> findAllLike(
			AdjuntarAlertaprogra adjuntaralertaprogra, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CRCODIGO CRCODIGO,t1.CRCOAL CRCOAL,t1.CRCOOR CRCOOR,t1.CRFERERE CRFERERE,t1.CRTEINFO CRTEINFO,t1.CRCNACTU CRCNACTU,t1.CRINPRSE CRINPRSE,t1.CRCODIGODISTRIBUIDOR CRCODIGODISTRIBUIDOR,t1.CRFECHACOMUNICACION CRFECHACOMUNICACION,t1.CRFECHAPLAZO CRFECHAPLAZO,t1.CRFECHACIERRE CRFECHACIERRE,t1.CRACUERDOINICIO CRACUERDOINICIO, t1.CRINSPECCIONSOLICITADA CRINSPECCIONSOLICITADA,t2.TCACODIGO TIPOCARACTERALERTATCACODIGO,t2.TCANOMBRE TIPOCARACTERALERTATCANOMBRE,t2.TCANOMBREE TIPOCARACTERALERTATCANOMBREE ");
		query.append("FROM ADJUNTAR_ALERTAPROGRA t1 ,TIPO_CARACTER_ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntaralertaprogra,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRTIPO= t2.TCACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarAlertaprogra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjuntarAlertaprogra adjuntaralertaprogra,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_ALERTAPROGRA t1 ,TIPO_CARACTER_ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntaralertaprogra,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRTIPO= t2.TCACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarAlertaprogra entity
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdjuntarAlertaprogra adjuntaralertaprogra) {

		StringBuilder where = new StringBuilder(
				AdjuntarAlertaprograDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcodigo() != null) {
			where.append(" AND t1.CRCODIGO = ?");
			params.add(adjuntaralertaprogra.getCrcodigo());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcacodigo() != null) {
			where.append(" AND t2.TCACODIGO = ?");
			params.add(adjuntaralertaprogra.getTipoCaracterAlerta()
					.getTcacodigo());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcanombre() != null) {
			where.append(" AND t2.TCANOMBRE = ?");
			params.add(adjuntaralertaprogra.getTipoCaracterAlerta()
					.getTcanombre());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcanombree() != null) {
			where.append(" AND t2.TCANOMBREE = ?");
			params.add(adjuntaralertaprogra.getTipoCaracterAlerta()
					.getTcanombree());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcoal() != null) {
			where.append(" AND t1.CRCOAL = ?");
			params.add(adjuntaralertaprogra.getCrcoal());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcoor() != null) {
			where.append(" AND t1.CRCOOR = ?");
			params.add(adjuntaralertaprogra.getCrcoor());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrferere() != null) {
			where.append(" AND t1.CRFERERE = ?");
			params.add(adjuntaralertaprogra.getCrferere());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrteinfo() != null) {
			where.append(" AND t1.CRTEINFO = ?");
			params.add(adjuntaralertaprogra.getCrteinfo());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(adjuntaralertaprogra.getCrcnactu());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrinprse() != null) {
			where.append(" AND t1.CRINPRSE = ?");
			params.add(adjuntaralertaprogra.getCrinprse());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcodigodistribuidor() != null) {
			where.append(" AND t1.CRCODIGODISTRIBUIDOR = ?");
			params.add(adjuntaralertaprogra.getCrcodigodistribuidor());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrfechacomunicacion() != null) {
			where.append(" AND t1.CRFECHACOMUNICACION = ?");
			params.add(adjuntaralertaprogra.getCrfechacomunicacion());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrfechaplazo() != null) {
			where.append(" AND t1.CRFECHAPLAZO = ?");
			params.add(adjuntaralertaprogra.getCrfechaplazo());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrfechacierre() != null) {
			where.append(" AND t1.CRFECHACIERRE = ?");
			params.add(adjuntaralertaprogra.getCrfechacierre());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCracuerdoinicio() != null) {
			where.append(" AND t1.CRACUERDOINICIO = ?");
			params.add(adjuntaralertaprogra.getCracuerdoinicio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarAlertaprogra entity
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjuntarAlertaprogra adjuntaralertaprogra, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarAlertaprograDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcodigo() != null) {
			where.append(" AND UPPER(t1.CRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getCrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntaralertaprogra.getCrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCODIGO IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcacodigo() != null) {
			where.append(" AND t2.TCACODIGO = ?");
			params.add(adjuntaralertaprogra.getTipoCaracterAlerta()
					.getTcacodigo());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcanombre() != null) {
			where.append(" AND UPPER(t2.TCANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getTipoCaracterAlerta()
						.getTcanombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntaralertaprogra.getTipoCaracterAlerta()
								.getTcanombre().toUpperCase() + "%");
			}
			where.append(" AND t2.TCANOMBRE IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta() != null
				&& adjuntaralertaprogra.getTipoCaracterAlerta().getTcanombree() != null) {
			where.append(" AND UPPER(t2.TCANOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getTipoCaracterAlerta()
						.getTcanombree().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntaralertaprogra.getTipoCaracterAlerta()
								.getTcanombree().toUpperCase() + "%");
			}
			where.append(" AND t2.TCANOMBREE IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcoal() != null) {
			where.append(" AND UPPER(t1.CRCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getCrcoal().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntaralertaprogra.getCrcoal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCOAL IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcoor() != null) {
			where.append(" AND UPPER(t1.CRCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getCrcoor().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntaralertaprogra.getCrcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCOOR IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrferere() != null) {
			where.append(" AND t1.CRFERERE = ?");
			params.add(adjuntaralertaprogra.getCrferere());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrteinfo() != null) {
			where.append(" AND UPPER(t1.CRTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getCrteinfo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntaralertaprogra.getCrteinfo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRTEINFO IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(adjuntaralertaprogra.getCrcnactu());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrinprse() != null) {
			where.append(" AND UPPER(t1.CRINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getCrinprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntaralertaprogra.getCrinprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRINPRSE IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrcodigodistribuidor() != null) {
			where.append(" AND UPPER(t1.CRCODIGODISTRIBUIDOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntaralertaprogra.getCrcodigodistribuidor()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ adjuntaralertaprogra.getCrcodigodistribuidor()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.CRCODIGODISTRIBUIDOR IS NOT NULL");
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrfechacomunicacion() != null) {
			where.append(" AND t1.CRFECHACOMUNICACION = ?");
			params.add(adjuntaralertaprogra.getCrfechacomunicacion());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrfechaplazo() != null) {
			where.append(" AND t1.CRFECHAPLAZO = ?");
			params.add(adjuntaralertaprogra.getCrfechaplazo());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCrfechacierre() != null) {
			where.append(" AND t1.CRFECHACIERRE = ?");
			params.add(adjuntaralertaprogra.getCrfechacierre());
		}
		if (adjuntaralertaprogra != null
				&& adjuntaralertaprogra.getCracuerdoinicio() != null) {
			where.append(" AND t1.CRACUERDOINICIO = ?");
			params.add(adjuntaralertaprogra.getCracuerdoinicio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	public void removeAllAlertaprogra(Alerta alerta) {
		String query = "DELETE FROM ADJUNTAR_ALERTAPROGRA WHERE CRCOAL = ?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void addAlertaprogra(Alerta alerta) {

		String query = "INSERT INTO ADJUNTAR_ALERTAPROGRA (CRCODIGO, CRTIPO, CRCOAL, CRCOOR, CRFERERE, CRCNACTU, CRINPRSE, CRCODIGODISTRIBUIDOR, CRFECHACOMUNICACION, CRFECHAPLAZO, CRFECHACIERRE, CRACUERDOINICIO, CRINSPECCIONSOLICITADA) SELECT CRCODIGO, CRTIPO, CRCOAL, CRCOOR, CRFERERE, CRCNACTU, CRINPRSE, CRCODIGODISTRIBUIDOR, CRFECHACOMUNICACION, CRFECHAPLAZO, CRFECHACIERRE, CRACUERDOINICIO, CRINSPECCIONSOLICITADA FROM ALERTA_PROGRAMACION t1 WHERE CRCOAL = ?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarAlertaprogra> findAllAlertaProgramacionNuevas(
			AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.CRCODIGO CRCODIGO ");
		query.append("FROM ADJUNTAR_ALERTAPROGRA t1 ");

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(
				" WHERE 1=1  AND t1.CRCODIGO NOT IN (SELECT tt1.CRCODIGO FROM ALERTA_PROGRAMACION tt1 WHERE tt1.CRCOAL = t1.CRCOAL) AND t1.CRCOAL=?");
		params.add(adjuntarAlertaprogra.getCrcoal());
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarAlertaprogra>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AdjuntarAlertaprogra>() {
					public AdjuntarAlertaprogra mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AdjuntarAlertaprogra(resultSet
								.getString("CRCODIGO"));
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarAlertaprogra> findAllAlertaProgramacionExistentes(
			AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.CRCODIGO CRCODIGO ");
		query.append("FROM ADJUNTAR_ALERTAPROGRA t1 ");

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(
				" WHERE 1=1  AND t1.CRCODIGO IN (SELECT tt1.CRCODIGO FROM ALERTA_PROGRAMACION tt1 WHERE tt1.CRCOAL = t1.CRCOAL AND tt1.CRCODIGODISTRIBUIDOR IS NOT NULL) AND t1.CRCOAL=?");
		params.add(adjuntarAlertaprogra.getCrcoal());
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarAlertaprogra>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AdjuntarAlertaprogra>() {
					public AdjuntarAlertaprogra mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AdjuntarAlertaprogra(resultSet
								.getString("CRCODIGO"));
					}
				}, params.toArray());
	}
}
