package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarAlertaprogra;
import com.ejie.y41b.model.Alerta;

/**
 * AdjuntarAlertaprograDao  
 * 
 *  
 */

public interface AdjuntarAlertaprograDao {

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	AdjuntarAlertaprogra add(AdjuntarAlertaprogra adjuntaralertaprogra);

	/**
	 * Updates a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	AdjuntarAlertaprogra update(AdjuntarAlertaprogra adjuntaralertaprogra);

	/**
	 * Updates a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            Pagination
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra updateNumActuaciones(
			AdjuntarAlertaprogra adjuntaralertaprogra);

	/**
	 * Finds a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	AdjuntarAlertaprogra find(AdjuntarAlertaprogra adjuntaralertaprogra);

	/**
	 * Deletes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @return
	 */
	void remove(AdjuntarAlertaprogra adjuntaralertaprogra);

	/**
	 * Finds a List of rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarAlertaprogra> findAll(
			AdjuntarAlertaprogra adjuntaralertaprogra, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @return Long
	 */
	Long findAllCount(AdjuntarAlertaprogra adjuntaralertaprogra);

	/**
	 * Finds rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarAlertaprogra> findAllLike(
			AdjuntarAlertaprogra adjuntaralertaprogra, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntaralertaprogra
	 *            AdjuntarAlertaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarAlertaprogra adjuntaralertaprogra,
			Boolean startsWith);

	/**
	 * Removes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	public void removeAllAlertaprogra(Alerta alerta);

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void addAlertaprogra(Alerta alerta);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarAlertaprogra> findAllAlertaProgramacionNuevas(
			AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination);

	/**
	 * Finds a List of rows in the AdjuntarCampanhaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarAlertaprogra> findAllAlertaProgramacionExistentes(
			AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination);
}
