package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunInfraccHechoDenunDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjunInfraccHechoDenunDaoImpl implements AdjunInfraccHechoDenunDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjunInfraccHechoDenun> rwMap = new RowMapper<AdjunInfraccHechoDenun>() {
		public AdjunInfraccHechoDenun mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjunInfraccHechoDenun(resultSet.getString("HICODIGO"),
					resultSet.getString("HICOHD"),
					resultSet.getString("HICOTTI"),
					resultSet.getString("HIINEXII"),
					resultSet.getString("HIIFID"),
					resultSet.getString("HICOTP"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            Pagination
	 * @return AdjunInfraccHechoDenun
	 */
	public AdjunInfraccHechoDenun add(
			AdjunInfraccHechoDenun adjuninfracchechodenun) {
		String query = "INSERT INTO ADJUN_INFRACC_HECHO_DENUN (HICODIGO, HICOHD, HICOTTI, HIINEXII, HIIFID, HICOTP) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjuninfracchechodenun.getHicodigo(),
				adjuninfracchechodenun.getHicohd(),
				adjuninfracchechodenun.getHicotti(),
				adjuninfracchechodenun.getHiinexii(),
				adjuninfracchechodenun.getHiifid(),
				adjuninfracchechodenun.getHicotp());
		return adjuninfracchechodenun;
	}

	/**
	 * Updates a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            Pagination
	 * @return AdjunInfraccHechoDenun
	 */
	public AdjunInfraccHechoDenun update(
			AdjunInfraccHechoDenun adjuninfracchechodenun) {
		String query = "UPDATE ADJUN_INFRACC_HECHO_DENUN SET  WHERE HICODIGO=? AND HICOHD=? AND HICOTTI=? AND HIINEXII=? AND HICOTP=? AND HIIFID=?";
		this.jdbcTemplate.update(query, adjuninfracchechodenun.getHicodigo(),
				adjuninfracchechodenun.getHicohd(),
				adjuninfracchechodenun.getHicotti(),
				adjuninfracchechodenun.getHiinexii(),
				adjuninfracchechodenun.getHicotp(),
				adjuninfracchechodenun.getHiifid());
		return adjuninfracchechodenun;
	}

	/**
	 * Finds a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            Pagination
	 * @return AdjunInfraccHechoDenun
	 */
	@Transactional(readOnly = true)
	public AdjunInfraccHechoDenun find(
			AdjunInfraccHechoDenun adjuninfracchechodenun) {
		String query = "SELECT t1.HICODIGO HICODIGO, t1.HICOHD HICOHD, t1.HICOTTI HICOTTI, t1.HIINEXII HIINEXII, t1.HIIFID HIIFID, t1.HICOTP HICOTP FROM ADJUN_INFRACC_HECHO_DENUN t1  WHERE t1.HICODIGO = ?  ";

		List<AdjunInfraccHechoDenun> adjuninfracchechodenunList = this.jdbcTemplate
				.query(query, this.rwMap, adjuninfracchechodenun.getHicodigo());
		return (AdjunInfraccHechoDenun) DataAccessUtils
				.uniqueResult(adjuninfracchechodenunList);
	}

	/**
	 * Removes a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            Pagination
	 * @return
	 */
	public void remove(AdjunInfraccHechoDenun adjuninfracchechodenun) {
		String query = "DELETE FROM ADJUN_INFRACC_HECHO_DENUN WHERE HICODIGO=? ";
		this.jdbcTemplate.update(query, adjuninfracchechodenun.getHicodigo());
	}

	/**
	 * Removes a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllAdjuntarInfracciones(TramiteComun tramiteComun) {
		try {
			String query = "DELETE FROM ADJUN_INFRACC_HECHO_DENUN WHERE HICOHD = ?";
			this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Finds a List of rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunInfraccHechoDenun> findAll(
			AdjunInfraccHechoDenun adjuninfracchechodenun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t2.TTINOMBRE TTINOMBRE, t2.TTINOMBREE TTINOMBREE, t1.HICOTP HICOTP ");
		query.append("FROM ADJUN_INFRACC_HECHO_DENUN t1, TIP_REQ_NORMATIVO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuninfracchechodenun);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.HICOTTI =t2.TTICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunInfraccHechoDenun>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AdjunInfraccHechoDenun>() {
					public AdjunInfraccHechoDenun mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AdjunInfraccHechoDenun(resultSet
								.getString("HICODIGO"), resultSet
								.getString("HICOHD"), resultSet
								.getString("HICOTTI"), resultSet
								.getString("HIINEXII"), resultSet
								.getString("HIIFID"), resultSet
								.getString("TTINOMBRE"), resultSet
								.getString("TTINOMBREE"), resultSet
								.getString("HICOTP"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjunInfraccHechoDenun adjuninfracchechodenun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_INFRACC_HECHO_DENUN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuninfracchechodenun);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunInfraccHechoDenun> findAllLike(
			AdjunInfraccHechoDenun adjuninfracchechodenun,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t1.HICOTP HICOTP ");
		query.append("FROM ADJUN_INFRACC_HECHO_DENUN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuninfracchechodenun,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunInfraccHechoDenun>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjunInfraccHechoDenun adjuninfracchechodenun,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_INFRACC_HECHO_DENUN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuninfracchechodenun,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunInfraccHechoDenun entity
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			AdjunInfraccHechoDenun adjuninfracchechodenun) {

		StringBuilder where = new StringBuilder(
				AdjunInfraccHechoDenunDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHicodigo() != null) {
			where.append(" AND t1.HICODIGO = ?");
			params.add(adjuninfracchechodenun.getHicodigo());
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHicohd() != null) {
			where.append(" AND t1.HICOHD = ?");
			params.add(adjuninfracchechodenun.getHicohd());
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHicotti() != null) {
			where.append(" AND t1.HICOTTI = ?");
			params.add(adjuninfracchechodenun.getHicotti());
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHiinexii() != null) {
			where.append(" AND t1.HIINEXII = ?");
			params.add(adjuninfracchechodenun.getHiinexii());
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHiifid() != null) {
			where.append(" AND t1.HIIFID = ?");
			params.add(adjuninfracchechodenun.getHiifid());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunInfraccHechoDenun entity
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjunInfraccHechoDenun adjuninfracchechodenun, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjunInfraccHechoDenunDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHicodigo() != null) {
			where.append(" AND UPPER(t1.HICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfracchechodenun.getHicodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuninfracchechodenun.getHicodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HICODIGO IS NOT NULL");
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHicohd() != null) {
			where.append(" AND UPPER(t1.HICOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfracchechodenun.getHicohd().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuninfracchechodenun.getHicohd().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HICOHD IS NOT NULL");
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHicotti() != null) {
			where.append(" AND UPPER(t1.HICOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfracchechodenun.getHicotti().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuninfracchechodenun.getHicotti().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HICOTTI IS NOT NULL");
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHiinexii() != null) {
			where.append(" AND UPPER(t1.HIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfracchechodenun.getHiinexii().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuninfracchechodenun.getHiinexii().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HIINEXII IS NOT NULL");
		}
		if (adjuninfracchechodenun != null
				&& adjuninfracchechodenun.getHiifid() != null) {
			where.append(" AND UPPER(t1.HIIFID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfracchechodenun.getHiifid().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuninfracchechodenun.getHiifid().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HIIFID IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
