package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.TramiteComun;

/**
 * AdjunInfraccHechoDenunDao  
 * 
 *  
 */

public interface AdjunInfraccHechoDenunDao {

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	AdjunInfraccHechoDenun add(AdjunInfraccHechoDenun adjuninfracchechodenun);

	/**
	 * Updates a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	AdjunInfraccHechoDenun update(AdjunInfraccHechoDenun adjuninfracchechodenun);

	/**
	 * Finds a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	AdjunInfraccHechoDenun find(AdjunInfraccHechoDenun adjuninfracchechodenun);

	/**
	 * Deletes a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @return
	 */
	void remove(AdjunInfraccHechoDenun adjuninfracchechodenun);

	/**
	 * Removes a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllAdjuntarInfracciones(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunInfraccHechoDenun> findAll(
			AdjunInfraccHechoDenun adjuninfracchechodenun, Pagination pagination);

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @return Long
	 */
	Long findAllCount(AdjunInfraccHechoDenun adjuninfracchechodenun);

	/**
	 * Finds rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunInfraccHechoDenun> findAllLike(
			AdjunInfraccHechoDenun adjuninfracchechodenun,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjuninfracchechodenun
	 *            AdjunInfraccHechoDenun
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunInfraccHechoDenun adjuninfracchechodenun,
			Boolean startsWith);
}
