package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunInfraccArb;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunInfraccArbDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjunInfraccArbDaoImpl implements AdjunInfraccArbDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjunInfraccArb> rwMap = new RowMapper<AdjunInfraccArb>() {
		public AdjunInfraccArb mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjunInfraccArb(resultSet.getString("HICODIGO"),
					resultSet.getString("HICOARB"),
					resultSet.getString("HICOTTI"),
					resultSet.getString("HIINEXII"),
					resultSet.getString("HIIFID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccArb
	 *            Pagination
	 * @return AdjunInfraccArb
	 */
	public AdjunInfraccArb add(AdjunInfraccArb adjuninfraccArb) {
		String query = "INSERT INTO ADJUN_INFRACC_ARB (HICODIGO, HICOARB, HICOTTI, HIINEXII, HIIFID) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjuninfraccArb.getHicodigo(),
				adjuninfraccArb.getHicoarb(), adjuninfraccArb.getHicotti(),
				adjuninfraccArb.getHiinexii(), adjuninfraccArb.getHiifid());
		return adjuninfraccArb;
	}

	/**
	 * Updates a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccArb
	 *            Pagination
	 * @return AdjunInfraccArb
	 */
	public AdjunInfraccArb update(AdjunInfraccArb adjuninfraccArb) {
		String query = "UPDATE ADJUN_INFRACC_ARB SET  WHERE HICODIGO=? AND HICOARB=? AND HICOTTI=? AND HIINEXII=? AND HIIFID=?";
		this.jdbcTemplate.update(query, adjuninfraccArb.getHicodigo(),
				adjuninfraccArb.getHicoarb(), adjuninfraccArb.getHicotti(),
				adjuninfraccArb.getHiinexii(), adjuninfraccArb.getHiifid());
		return adjuninfraccArb;
	}

	/**
	 * Finds a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccArb
	 *            Pagination
	 * @return AdjunInfraccArb
	 */
	@Transactional(readOnly = true)
	public AdjunInfraccArb find(AdjunInfraccArb adjuninfraccArb) {
		String query = "SELECT t1.HICODIGO HICODIGO, t1.HICOARB HICOARB, t1.HICOTTI HICOTTI, t1.HIINEXII HIINEXII, t1.HIIFID HIIFID FROM ADJUN_INFRACC_ARB t1  WHERE t1.HICODIGO = ?   AND t1.HICOARB = ?   AND t1.HICOTTI = ?   AND t1.HIINEXII = ?   AND t1.HIIFID = ?  ";

		List<AdjunInfraccArb> adjuninfraccArbList = this.jdbcTemplate.query(
				query, this.rwMap, adjuninfraccArb.getHicodigo(),
				adjuninfraccArb.getHicoarb(), adjuninfraccArb.getHicotti(),
				adjuninfraccArb.getHiinexii(), adjuninfraccArb.getHiifid());
		return (AdjunInfraccArb) DataAccessUtils
				.uniqueResult(adjuninfraccArbList);
	}

	/**
	 * Removes a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccArb
	 *            Pagination
	 * @return
	 */
	public void remove(AdjunInfraccArb adjuninfraccArb) {
		String query = "DELETE FROM ADJUN_INFRACC_ARB WHERE HICODIGO=? ";
		this.jdbcTemplate.update(query, adjuninfraccArb.getHicodigo());
	}

	/**
	 * Removes a single row in the AdjunInfraccArb table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllAdjuntarInfracciones(TramiteComun tramiteComun) {
		try {
			String query = "DELETE FROM ADJUN_INFRACC_ARB WHERE HICOARB = ?";
			this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Finds a List of rows in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunInfraccArb> findAll(AdjunInfraccArb adjuninfraccArb,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOARB HICOARB,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t2.TTINOMBRE TTINOMBRE, t2.TTINOMBREE TTINOMBREE ");
		query.append("FROM ADJUN_INFRACC_ARB t1, TIP_REQ_NORMATIVO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuninfraccArb);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.HICOTTI =t2.TTICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunInfraccArb>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AdjunInfraccArb>() {
					public AdjunInfraccArb mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AdjunInfraccArb(resultSet
								.getString("HICODIGO"), resultSet
								.getString("HICOARB"), resultSet
								.getString("HICOTTI"), resultSet
								.getString("HIINEXII"), resultSet
								.getString("HIIFID"), resultSet
								.getString("TTINOMBRE"), resultSet
								.getString("TTINOMBREE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccArb
	 *            AdjunInfraccArb
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjunInfraccArb adjuninfraccArb) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuninfraccArb);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjuninfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunInfraccArb> findAllLike(AdjunInfraccArb adjuninfraccArb,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOARB HICOARB,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID ");
		query.append("FROM ADJUN_INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuninfraccArb,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunInfraccArb>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjuninfraccArb
	 *            AdjunInfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjunInfraccArb adjuninfraccArb,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuninfraccArb,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunInfraccArb entity
	 * 
	 * @param adjuninfraccArb
	 *            AdjunInfraccArb Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdjunInfraccArb adjuninfraccArb) {

		StringBuilder where = new StringBuilder(
				AdjunInfraccArbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuninfraccArb != null && adjuninfraccArb.getHicodigo() != null) {
			where.append(" AND t1.HICODIGO = ?");
			params.add(adjuninfraccArb.getHicodigo());
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHicoarb() != null) {
			where.append(" AND t1.HICOARB = ?");
			params.add(adjuninfraccArb.getHicoarb());
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHicotti() != null) {
			where.append(" AND t1.HICOTTI = ?");
			params.add(adjuninfraccArb.getHicotti());
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHiinexii() != null) {
			where.append(" AND t1.HIINEXII = ?");
			params.add(adjuninfraccArb.getHiinexii());
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHiifid() != null) {
			where.append(" AND t1.HIIFID = ?");
			params.add(adjuninfraccArb.getHiifid());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunInfraccArb entity
	 * 
	 * @param adjuninfraccArb
	 *            AdjunInfraccArb Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(AdjunInfraccArb adjuninfraccArb,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjunInfraccArbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuninfraccArb != null && adjuninfraccArb.getHicodigo() != null) {
			where.append(" AND UPPER(t1.HICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfraccArb.getHicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + adjuninfraccArb.getHicodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HICODIGO IS NOT NULL");
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHicoarb() != null) {
			where.append(" AND UPPER(t1.HICOARB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfraccArb.getHicoarb().toUpperCase() + "%");
			} else {
				params.add("%" + adjuninfraccArb.getHicoarb().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HICOARB IS NOT NULL");
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHicotti() != null) {
			where.append(" AND UPPER(t1.HICOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfraccArb.getHicotti().toUpperCase() + "%");
			} else {
				params.add("%" + adjuninfraccArb.getHicotti().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HICOTTI IS NOT NULL");
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHiinexii() != null) {
			where.append(" AND UPPER(t1.HIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfraccArb.getHiinexii().toUpperCase() + "%");
			} else {
				params.add("%" + adjuninfraccArb.getHiinexii().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HIINEXII IS NOT NULL");
		}
		if (adjuninfraccArb != null && adjuninfraccArb.getHiifid() != null) {
			where.append(" AND UPPER(t1.HIIFID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuninfraccArb.getHiifid().toUpperCase() + "%");
			} else {
				params.add("%" + adjuninfraccArb.getHiifid().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HIIFID IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
