package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.AdjunInfraccArb;
import com.ejie.y41b.model.TramiteComun;

/**
 * AdjunInfraccArbDao  
 * 
 *  
 */

public interface AdjunInfraccArbDao {

	/**
	 * Inserts a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	AdjunInfraccArb add(AdjunInfraccArb adjuninfraccarb);

	/**
	 * Updates a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	AdjunInfraccArb update(AdjunInfraccArb adjuninfraccarb);

	/**
	 * Finds a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	AdjunInfraccArb find(AdjunInfraccArb adjuninfraccarb);

	/**
	 * Deletes a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @return
	 */
	void remove(AdjunInfraccArb adjuninfraccarb);

	/**
	 * Removes a single row in the AdjunInfraccArb table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllAdjuntarInfracciones(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunInfraccArb> findAll(AdjunInfraccArb adjuninfraccarb,
			Pagination pagination);

	/**
	 * Counts rows in the AdjunInfraccArb table.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @return Long
	 */
	Long findAllCount(AdjunInfraccArb adjuninfraccarb);

	/**
	 * Finds rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunInfraccArb> findAllLike(AdjunInfraccArb adjuninfraccarb,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjuninfraccarb
	 *            AdjunInfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunInfraccArb adjuninfraccarb, Boolean startsWith);
}
