package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunDatosMailSede;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunDatosMailSedeDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjunDatosMailSedeDaoImpl implements AdjunDatosMailSedeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjunDatosMailSede> rwMap = new RowMapper<AdjunDatosMailSede>() {
		public AdjunDatosMailSede mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjunDatosMailSede(resultSet.getString("IDDATOMAIL"),
					resultSet.getString("IDDATOSEDE"),
					resultSet.getString("PCODIGO"),
					resultSet.getString("EMAIL"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getString("DESCRIPCIONE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjundatosmailsede
	 *            Pagination
	 * @return AdjunDatosMailSede
	 */
	public AdjunDatosMailSede add(AdjunDatosMailSede adjundatosmailsede) {
		String query = "INSERT INTO ADJUN_DATOS_MAIL_SEDE (ID_DATOMAIL, ID_DATOSEDE, PCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjundatosmailsede.getIdDatomail(),
				adjundatosmailsede.getIdDatosede(),
				adjundatosmailsede.getPcodigo(), adjundatosmailsede.getEmail(),
				adjundatosmailsede.getDescripcion(),
				adjundatosmailsede.getDescripcione());
		return adjundatosmailsede;
	}

	/**
	 * Updates a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjundatosmailsede
	 *            Pagination
	 * @return AdjunDatosMailSede
	 */
	public AdjunDatosMailSede update(AdjunDatosMailSede adjundatosmailsede) {
		String query = "UPDATE ADJUN_DATOS_MAIL_SEDE SET ID_DATOSEDE=?, PCODIGO=?, EMAIL=?, DESCRIPCION=?, DESCRIPCIONE=? WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, adjundatosmailsede.getIdDatosede(),
				adjundatosmailsede.getPcodigo(), adjundatosmailsede.getEmail(),
				adjundatosmailsede.getDescripcion(),
				adjundatosmailsede.getDescripcione(),
				adjundatosmailsede.getIdDatomail());
		return adjundatosmailsede;
	}

	/**
	 * Finds a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjundatosmailsede
	 *            Pagination
	 * @return AdjunDatosMailSede
	 */
	@Transactional(readOnly = true)
	public AdjunDatosMailSede find(AdjunDatosMailSede adjundatosmailsede) {
		String query = "SELECT t1.ID_DATOMAIL IDDATOMAIL, t1.ID_DATOSEDE IDDATOSEDE, t1.PCODIGO PCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM ADJUN_DATOS_MAIL_SEDE t1  WHERE t1.ID_DATOMAIL = ?  ";

		List<AdjunDatosMailSede> adjundatosmailsedeList = this.jdbcTemplate
				.query(query, this.rwMap, adjundatosmailsede.getIdDatomail());
		return (AdjunDatosMailSede) DataAccessUtils
				.uniqueResult(adjundatosmailsedeList);
	}

	/**
	 * Removes a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjundatosmailsede
	 *            Pagination
	 * @return
	 */
	public void remove(AdjunDatosMailSede adjundatosmailsede) {
		String query = "DELETE FROM ADJUN_DATOS_MAIL_SEDE WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, adjundatosmailsede.getIdDatomail());
	}

	/**
	 * Finds a List of rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunDatosMailSede> findAll(
			AdjunDatosMailSede adjundatosmailsede, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ID_DATOSEDE IDDATOSEDE,t1.PCODIGO PCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM ADJUN_DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjundatosmailsede);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunDatosMailSede>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjunDatosMailSede adjundatosmailsede) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjundatosmailsede);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjunDatosMailSede table using like.
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunDatosMailSede> findAllLike(
			AdjunDatosMailSede adjundatosmailsede, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ID_DATOSEDE IDDATOSEDE,t1.PCODIGO PCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM ADJUN_DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjundatosmailsede,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunDatosMailSede>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunDatosMailSede table using like.
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjunDatosMailSede adjundatosmailsede,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjundatosmailsede,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosMailSede entity
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdjunDatosMailSede adjundatosmailsede) {

		StringBuilder where = new StringBuilder(
				AdjunDatosMailSedeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjundatosmailsede != null
				&& adjundatosmailsede.getIdDatomail() != null) {
			where.append(" AND t1.ID_DATOMAIL = ?");
			params.add(adjundatosmailsede.getIdDatomail());
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getIdDatosede() != null) {
			where.append(" AND t1.ID_DATOSEDE = ?");
			params.add(adjundatosmailsede.getIdDatosede());
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(adjundatosmailsede.getPcodigo());
		}
		if (adjundatosmailsede != null && adjundatosmailsede.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(adjundatosmailsede.getEmail());
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(adjundatosmailsede.getDescripcion());
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getDescripcione() != null) {
			where.append(" AND t1.DESCRIPCIONE = ?");
			params.add(adjundatosmailsede.getDescripcione());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosMailSede entity
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjunDatosMailSede adjundatosmailsede, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjunDatosMailSedeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjundatosmailsede != null
				&& adjundatosmailsede.getIdDatomail() != null) {
			where.append(" AND UPPER(t1.ID_DATOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailsede.getIdDatomail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailsede.getIdDatomail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DATOMAIL IS NOT NULL");
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getIdDatosede() != null) {
			where.append(" AND UPPER(t1.ID_DATOSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailsede.getIdDatosede().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailsede.getIdDatosede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DATOSEDE IS NOT NULL");
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailsede.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + adjundatosmailsede.getPcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (adjundatosmailsede != null && adjundatosmailsede.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailsede.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + adjundatosmailsede.getEmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailsede.getDescripcion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailsede.getDescripcion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (adjundatosmailsede != null
				&& adjundatosmailsede.getDescripcione() != null) {
			where.append(" AND UPPER(t1.DESCRIPCIONE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailsede.getDescripcione().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailsede.getDescripcione().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCIONE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjunDatosMailEstablecSede table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllAdjunDatosMailEstablecSede(
			Establecimiento establecimiento) {
		try {
			String query = "DELETE FROM ADJUN_DATOS_MAIL_SEDE WHERE ID_DATOMAIL IN (SELECT t1.ID_DATOMAIL FROM DATOS_MAIL_SEDE t1  WHERE t1.ID_DATOSEDE IN (SELECT t1.ID_DATOSEDE FROM SEDE t1  WHERE t1.ESCODIGO = ? ))";
			this.jdbcTemplate.update(query, establecimiento.getEscodigo());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Removes a single row in the AdjunDatosMailEstablecSede table.
	 * 
	 * @param sedeAux
	 *            Sede
	 * @return
	 */
	public void removeAllAdjunDatosMailEstablecSede(Sede sedeAux) {
		try {
			String query = "DELETE FROM ADJUN_DATOS_MAIL_SEDE WHERE ID_DATOSEDE = ? ";
			this.jdbcTemplate.update(query, sedeAux.getIdDatosede());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Counts rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailsede
	 *            AdjunDatosMailSede
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countDescripciones(AdjunDatosMailSede adjundatosmailsede) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(*) FROM ADJUN_DATOS_MAIL_SEDE ");

		if (adjundatosmailsede != null
				&& adjundatosmailsede.getDescripcion() != null
				&& adjundatosmailsede.getDescripcione() != null) {
			where.append("AND ( UPPER(DESCRIPCION) = ? OR UPPER(DESCRIPCIONE) = ?) ");
			params.add(adjundatosmailsede.getDescripcion().toUpperCase());
			params.add(adjundatosmailsede.getDescripcione().toUpperCase());
		}

		if (adjundatosmailsede != null
				&& adjundatosmailsede.getIdDatosede() != null) {
			where.append("AND ID_DATOSEDE  = ? ");
			params.add(adjundatosmailsede.getIdDatosede());
		}

		if (adjundatosmailsede != null
				&& adjundatosmailsede.getPcodigo() != null) {
			where.append("AND UPPER(PCODIGO) = ? ");
			params.add(adjundatosmailsede.getPcodigo().toUpperCase());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

}
