package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunDatosMailEstablec;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunDatosMailEstablecDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjunDatosMailEstablecDaoImpl implements AdjunDatosMailEstablecDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjunDatosMailEstablec> rwMap = new RowMapper<AdjunDatosMailEstablec>() {
		public AdjunDatosMailEstablec mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjunDatosMailEstablec(
					resultSet.getString("IDDATOMAIL"),
					resultSet.getString("ESCODIGO"),
					resultSet.getString("EMAIL"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getString("DESCRIPCIONE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            Pagination
	 * @return AdjunDatosMailEstablec
	 */
	public AdjunDatosMailEstablec add(
			AdjunDatosMailEstablec adjundatosmailestablec) {
		String query = "INSERT INTO ADJUN_DATOS_MAIL_ESTABLEC (ID_DATOMAIL, ESCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjundatosmailestablec.getIdDatomail(),
				adjundatosmailestablec.getEscodigo(),
				adjundatosmailestablec.getEmail(),
				adjundatosmailestablec.getDescripcion(),
				adjundatosmailestablec.getDescripcione());
		return adjundatosmailestablec;
	}

	/**
	 * Updates a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            Pagination
	 * @return AdjunDatosMailEstablec
	 */
	public AdjunDatosMailEstablec update(
			AdjunDatosMailEstablec adjundatosmailestablec) {
		String query = "UPDATE ADJUN_DATOS_MAIL_ESTABLEC SET ESCODIGO=?, EMAIL=?, DESCRIPCION=?, DESCRIPCIONE=? WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, adjundatosmailestablec.getEscodigo(),
				adjundatosmailestablec.getEmail(),
				adjundatosmailestablec.getDescripcion(),
				adjundatosmailestablec.getDescripcione(),
				adjundatosmailestablec.getIdDatomail());
		return adjundatosmailestablec;
	}

	/**
	 * Finds a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            Pagination
	 * @return AdjunDatosMailEstablec
	 */
	@Transactional(readOnly = true)
	public AdjunDatosMailEstablec find(
			AdjunDatosMailEstablec adjundatosmailestablec) {
		String query = "SELECT t1.ID_DATOMAIL IDDATOMAIL, t1.ESCODIGO ESCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM ADJUN_DATOS_MAIL_ESTABLEC t1  WHERE t1.ID_DATOMAIL = ?  ";

		List<AdjunDatosMailEstablec> adjundatosmailestablecList = this.jdbcTemplate
				.query(query, this.rwMap,
						adjundatosmailestablec.getIdDatomail());
		return (AdjunDatosMailEstablec) DataAccessUtils
				.uniqueResult(adjundatosmailestablecList);
	}

	/**
	 * Removes a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            Pagination
	 * @return
	 */
	public void remove(AdjunDatosMailEstablec adjundatosmailestablec) {
		String query = "DELETE FROM ADJUN_DATOS_MAIL_ESTABLEC WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, adjundatosmailestablec.getIdDatomail());
	}

	/**
	 * Finds a List of rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunDatosMailEstablec> findAll(
			AdjunDatosMailEstablec adjundatosmailestablec, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ESCODIGO ESCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM ADJUN_DATOS_MAIL_ESTABLEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjundatosmailestablec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunDatosMailEstablec>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjunDatosMailEstablec adjundatosmailestablec) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_DATOS_MAIL_ESTABLEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjundatosmailestablec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjunDatosMailEstablec table using like.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjunDatosMailEstablec> findAllLike(
			AdjunDatosMailEstablec adjundatosmailestablec,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ESCODIGO ESCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM ADJUN_DATOS_MAIL_ESTABLEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjundatosmailestablec,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunDatosMailEstablec>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunDatosMailEstablec table using like.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjunDatosMailEstablec adjundatosmailestablec,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUN_DATOS_MAIL_ESTABLEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjundatosmailestablec,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosMailEstablec entity
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			AdjunDatosMailEstablec adjundatosmailestablec) {

		StringBuilder where = new StringBuilder(
				AdjunDatosMailEstablecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getIdDatomail() != null) {
			where.append(" AND t1.ID_DATOMAIL = ?");
			params.add(adjundatosmailestablec.getIdDatomail());
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(adjundatosmailestablec.getEscodigo());
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(adjundatosmailestablec.getEmail());
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(adjundatosmailestablec.getDescripcion());
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getDescripcione() != null) {
			where.append(" AND t1.DESCRIPCIONE = ?");
			params.add(adjundatosmailestablec.getDescripcione());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosMailEstablec entity
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjunDatosMailEstablec adjundatosmailestablec, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjunDatosMailEstablecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getIdDatomail() != null) {
			where.append(" AND UPPER(t1.ID_DATOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailestablec.getIdDatomail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailestablec.getIdDatomail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DATOMAIL IS NOT NULL");
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailestablec.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailestablec.getEscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailestablec.getEmail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjundatosmailestablec.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailestablec.getDescripcion()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ adjundatosmailestablec.getDescripcion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getDescripcione() != null) {
			where.append(" AND UPPER(t1.DESCRIPCIONE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjundatosmailestablec.getDescripcione()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ adjundatosmailestablec.getDescripcione()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCIONE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllAdjunDatosMailEstablec(Establecimiento establecimiento) {
		try {
			String query = "DELETE FROM ADJUN_DATOS_MAIL_ESTABLEC WHERE ESCODIGO=?";
			this.jdbcTemplate.update(query, establecimiento.getEscodigo());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	//
	// /**
	// * Counts rows in the AdjunDatosMailEstablec table.
	// *
	// * @param adjunDatosMailEstablec
	// * AdjunDatosMailEstablec
	// * @return Long
	// */
	// @Transactional(readOnly = true)
	// public Long countDescripciones(AdjunDatosMailEstablec
	// adjunDatosMailEstablec) {
	//
	// StringBuffer where = new StringBuffer(3000);
	// List<Object> params = new ArrayList<Object>();
	// where.append(" WHERE 1=1 AND ( UPPER(DESCRIPCION) = ? OR UPPER(DESCRIPCIONE) = ?) ");
	//
	// StringBuffer query = new StringBuffer(
	// "SELECT COUNT(*) FROM ADJUN_DATOS_MAIL_ESTABLEC ");
	//
	// params.add(adjunDatosMailEstablec.getDescripcion().toUpperCase());
	// params.add(adjunDatosMailEstablec.getDescripcione().toUpperCase());
	//
	// query.append(where);
	// return this.jdbcTemplate.queryForLong(query.toString(),
	// params.toArray());
	//
	// }

	/**
	 * Counts rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countDescripciones(AdjunDatosMailEstablec adjundatosmailestablec) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(*) FROM ADJUN_DATOS_MAIL_ESTABLEC ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapDescs(adjundatosmailestablec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosMailEstablec entity
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosMailEstablec Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapDescs(
			AdjunDatosMailEstablec adjundatosmailestablec) {

		StringBuilder where = new StringBuilder(
				AdjunDatosMailEstablecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getDescripcion() != null
				&& adjundatosmailestablec.getDescripcione() != null) {
			where.append(" AND ( UPPER(DESCRIPCION) = ? OR UPPER(DESCRIPCIONE) = ?) ");
			params.add(adjundatosmailestablec.getDescripcion().toUpperCase());
			params.add(adjundatosmailestablec.getDescripcione().toUpperCase());
		}

		if (adjundatosmailestablec != null
				&& adjundatosmailestablec.getEscodigo() != null) {
			where.append(" AND ESCODIGO = ?");
			params.add(adjundatosmailestablec.getEscodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
