package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunDatosAvisosEstablecDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjunDatosAvisosEstablecDaoImpl implements AdjunDatosAvisosEstablecDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjunDatosAvisosEstablec> rwMap = new RowMapper<AdjunDatosAvisosEstablec>() {
		public AdjunDatosAvisosEstablec mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AdjunDatosAvisosEstablec(resultSet.getString("YIIDDATOMAIL"), resultSet.getString("YIESCIF"),
					resultSet.getString("YIEMAIL"), resultSet.getString("YIPCODIGO"));
		}
	};

	private RowMapper<AdjunDatosAvisosEstablec> rwMapAll = new RowMapper<AdjunDatosAvisosEstablec>() {
		public AdjunDatosAvisosEstablec mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AdjunDatosAvisosEstablec(resultSet.getString("YIIDDATOMAIL"), resultSet.getString("YIESCIF"),
					resultSet.getString("YIEMAIL"), resultSet.getString("YIPCODIGO"), resultSet.getString("YIPNOMBRE"),
					resultSet.getString("YIPNOMBREE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	@Transactional(readOnly = true)
	public AdjunDatosAvisosEstablec find(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "SELECT t1.YIIDDATOMAIL YIIDDATOMAIL, t1.YIESCIF YIESCIF, t1.YIEMAIL YIEMAIL, t1.YIPCODIGO YIPCODIGO FROM ES_AVISOS_MULTIPLE t1  WHERE t1.YIIDDATOMAIL = ?  ";

		List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList = this.jdbcTemplate.query(query, this.rwMap,
				adjunDatosAvisosEstablec.getYiiddatomail());
		return (AdjunDatosAvisosEstablec) DataAccessUtils.uniqueResult(adjunDatosAvisosEstablecList);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosAvisosEstablec entity
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {

		StringBuilder where = new StringBuilder(AdjunDatosAvisosEstablecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiiddatomail() != null) {
			where.append(" AND t1.YIIDDATOMAIL = ?");
			params.add(adjunDatosAvisosEstablec.getYiiddatomail());
		}
		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiescif() != null) {
			where.append(" AND t1.YIESCIF = ?");
			params.add(adjunDatosAvisosEstablec.getYiescif());
		}
		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiemail() != null) {
			where.append(" AND t1.YIEMAIL = ?");
			params.add(adjunDatosAvisosEstablec.getYiemail());
		}
		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYipcodigo() != null) {
			where.append(" AND t1.YIPCODIGO = ?");
			params.add(adjunDatosAvisosEstablec.getYipcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosAvisosEstablec entity
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec, Boolean startsWith) {

		StringBuilder where = new StringBuilder(AdjunDatosAvisosEstablecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiiddatomail() != null) {
			where.append(" AND UPPER(t1.YIIDDATOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunDatosAvisosEstablec.getYiiddatomail().toUpperCase() + "%");
			} else {
				params.add("%" + adjunDatosAvisosEstablec.getYiiddatomail().toUpperCase() + "%");
			}
			where.append(" AND t1.YIIDDATOMAIL IS NOT NULL");
		}
		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiescif() != null) {
			where.append(" AND UPPER(t1.YIESCIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunDatosAvisosEstablec.getYiescif().toUpperCase() + "%");
			} else {
				params.add("%" + adjunDatosAvisosEstablec.getYiescif().toUpperCase() + "%");
			}
			where.append(" AND t1.YIESCIF IS NOT NULL");
		}
		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiemail() != null) {
			where.append(" AND UPPER(t1.YIEMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunDatosAvisosEstablec.getYiemail().toUpperCase() + "%");
			} else {
				params.add("%" + adjunDatosAvisosEstablec.getYiemail().toUpperCase() + "%");
			}
			where.append(" AND t1.YIEMAIL IS NOT NULL");
		}
		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYipcodigo() != null) {
			where.append(" AND UPPER(t1.YIPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunDatosAvisosEstablec.getYipcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + adjunDatosAvisosEstablec.getYipcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.YIPCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	//
	// /**
	// * Counts rows in the AdjunDatosAvisosEstablec table.
	// *
	// * @param adjunDatosAvisosEstablec
	// * AdjunDatosAvisosEstablec
	// * @return Long
	// */
	// @Transactional(readOnly = true)
	// public Long countDescripciones(AdjunDatosAvisosEstablec
	// adjunDatosAvisosEstablec) {
	//
	// StringBuffer where = new StringBuffer(3000);
	// List<Object> params = new ArrayList<Object>();
	// where.append(" WHERE 1=1 AND ( UPPER(DESCRIPCION) = ? OR
	// UPPER(DESCRIPCIONE) = ?) ");
	//
	// StringBuffer query = new StringBuffer(
	// "SELECT COUNT(*) FROM ES_AVISOS_MULTIPLE ");
	//
	// params.add(adjunDatosAvisosEstablec.getDescripcion().toUpperCase());
	// params.add(adjunDatosAvisosEstablec.getDescripcione().toUpperCase());
	//
	// query.append(where);
	// return this.jdbcTemplate.queryForLong(query.toString(),
	// params.toArray());
	//
	// }

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countDescripciones(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {

		StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM ES_AVISOS_MULTIPLE ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapDescs(adjunDatosAvisosEstablec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjunDatosAvisosEstablec entity
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapDescs(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {

		StringBuilder where = new StringBuilder(AdjunDatosAvisosEstablecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYipcodigo() != null) {
			where.append(" AND  UPPER(YIPCODIGO) = ? ");
			params.add(adjunDatosAvisosEstablec.getYipcodigo().toUpperCase());

		}

		if (adjunDatosAvisosEstablec != null && adjunDatosAvisosEstablec.getYiescif() != null) {
			where.append(" AND YIESCIF = ?");
			params.add(adjunDatosAvisosEstablec.getYiescif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	////////// SOBRE LA TABLA FINAL ///////
	/**
	 * Removes a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return
	 */
	public void removeAllAvisosFromFinal(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		try {
			String query = "DELETE FROM ES_AVISOS_MULTIPLE WHERE YIESCIF=?";
			this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiescif());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Inserts avisos from temp table to final table to work with them.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	public void addAllAvisosFromTempToFinal(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "INSERT INTO ES_AVISOS_MULTIPLE (YIIDDATOMAIL, YIESCIF, YIEMAIL, YIPCODIGO) "
				+ "SELECT YIIDDATOMAIL, YIESCIF, YIEMAIL, YIPCODIGO "
				+ " FROM ES_AVISOS_MULTIPLE_TEMP WHERE YIESCIF = ? ";
		this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiescif());
	}

	/**
	 * Finds a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	@Transactional(readOnly = true)
	public AdjunDatosAvisosEstablec findByCifProc(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "SELECT t1.YIIDDATOMAIL YIIDDATOMAIL, t1.YIESCIF YIESCIF, t1.YIEMAIL YIEMAIL, t1.YIPCODIGO YIPCODIGO FROM ES_AVISOS_MULTIPLE t1  WHERE t1.YIESCIF = ? AND t1.YIPCODIGO = ? ";

		List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList = this.jdbcTemplate.query(query, this.rwMap,
				adjunDatosAvisosEstablec.getYiescif(), adjunDatosAvisosEstablec.getYipcodigo());
		return (AdjunDatosAvisosEstablec) DataAccessUtils.uniqueResult(adjunDatosAvisosEstablecList);
	}

	////////// SOBRE LA TABLA TEMPORAL ///////

	/**
	 * Borra todos los avisos de la tabla temporal relativos a ese codigo
	 * establecimiento
	 * 
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	public void removeAllAvisosFromTemp(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "DELETE FROM ES_AVISOS_MULTIPLE_TEMP WHERE YIESCIF=?";
		this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiescif());
	}

	/**
	 * Inserts avisos from final table to temp table to work with them.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	public void addAllAvisosFromFinalToTemp(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "INSERT INTO ES_AVISOS_MULTIPLE_TEMP (YIIDDATOMAIL, YIESCIF, YIEMAIL, YIPCODIGO) "
				+ "SELECT YIIDDATOMAIL, YIESCIF, YIEMAIL, YIPCODIGO " + " FROM ES_AVISOS_MULTIPLE WHERE YIESCIF = ? ";
		this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiescif());
	}

	/**
	 * Finds a List of rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AdjunDatosAvisosEstablec> findAll(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.YIIDDATOMAIL YIIDDATOMAIL,t1.YIESCIF YIESCIF,t1.YIEMAIL YIEMAIL,t1.YIPCODIGO YIPCODIGO, t2.PNOMBRE YIPNOMBRE, t2.PNOMBREE YIPNOMBREE ");
		query.append("FROM ES_AVISOS_MULTIPLE_TEMP t1, TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjunDatosAvisosEstablec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t2.PCODIGO = t1.YIPCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunDatosAvisosEstablec>) this.jdbcTemplate.query(query.toString(), this.rwMapAll,
				params.toArray());
	}

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	@Transactional(readOnly = true)

	public Long findAllCount(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ES_AVISOS_MULTIPLE_TEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjunDatosAvisosEstablec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AdjunDatosAvisosEstablec> findAllLike(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.YIIDDATOMAIL YIIDDATOMAIL,t1.YIESCIF YIESCIF,t1.YIEMAIL YIEMAIL,t1.YIPCODIGO YIPCODIGO ");
		query.append("FROM ES_AVISOS_MULTIPLE_TEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjunDatosAvisosEstablec, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjunDatosAvisosEstablec>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)

	public Long findAllLikeCount(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ES_AVISOS_MULTIPLE_TEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjunDatosAvisosEstablec, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	public AdjunDatosAvisosEstablec update(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "UPDATE ES_AVISOS_MULTIPLE_TEMP SET YIESCIF=?, YIEMAIL=?, YIPCODIGO=? WHERE YIIDDATOMAIL=?";
		this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiescif(), adjunDatosAvisosEstablec.getYiemail(),
				adjunDatosAvisosEstablec.getYipcodigo(), adjunDatosAvisosEstablec.getYiiddatomail());
		return adjunDatosAvisosEstablec;
	}

	/**
	 * Inserts a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	public AdjunDatosAvisosEstablec add(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "INSERT INTO ES_AVISOS_MULTIPLE_TEMP (YIIDDATOMAIL, YIESCIF, YIEMAIL, YIPCODIGO) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiiddatomail(),
				adjunDatosAvisosEstablec.getYiescif(), adjunDatosAvisosEstablec.getYiemail(),
				adjunDatosAvisosEstablec.getYipcodigo());
		return adjunDatosAvisosEstablec;
	}

	/**
	 * Removes a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return
	 */
	public void remove(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		String query = "DELETE FROM ES_AVISOS_MULTIPLE_TEMP WHERE YIIDDATOMAIL=?";
		this.jdbcTemplate.update(query, adjunDatosAvisosEstablec.getYiiddatomail());
	}
}
