package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.Establecimiento;

/**
 * AdjunDatosAvisosEstablecDao  
 * 
 *  
 */

public interface AdjunDatosAvisosEstablecDao {

	/**
	 * Inserts a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec add(AdjunDatosAvisosEstablec adjundatosmailestablec);

	/**
	 * Updates a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec update(AdjunDatosAvisosEstablec adjundatosmailestablec);

	/**
	 * Finds a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec find(AdjunDatosAvisosEstablec adjundatosmailestablec);

	/**
	 * Deletes a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @return
	 */
	void remove(AdjunDatosAvisosEstablec adjundatosmailestablec);

	/**
	 * Finds a List of rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunDatosAvisosEstablec> findAll(AdjunDatosAvisosEstablec adjundatosmailestablec, Pagination pagination);

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	Long findAllCount(AdjunDatosAvisosEstablec adjundatosmailestablec);

	/**
	 * Finds rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunDatosAvisosEstablec> findAllLike(AdjunDatosAvisosEstablec adjundatosmailestablec, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjundatosmailestablec
	 *            AdjunDatosAvisosEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunDatosAvisosEstablec adjundatosmailestablec, Boolean startsWith);

	/**
	 * Removes a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return
	 */
	void removeAllAvisosFromFinal(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */

	Long countDescripciones(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Borra todos los avisos de ese codigo establecimiento de la tabla temporal
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 */
	void removeAllAvisosFromTemp(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Inserts Avisos from final table to temp table to work with them.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	void addAllAvisosFromFinalToTemp(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Inserts avisos from temp table to final table
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	void addAllAvisosFromTempToFinal(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Finds a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec findByCifProc(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);
}
