package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.AdhesionTele;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * AdhesionTeleDaoImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
@Repository
@Transactional
public class AdhesionTeleDaoImpl implements AdhesionTeleDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdhesionTele> rwMap = new RowMapper<AdhesionTele>() {
		public AdhesionTele mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			List<String> columnasSeleccionadas = Y41bUtils
					.cargarDatosBDVO(resultSet);
			AdhesionTele retorno = new AdhesionTele(
					(columnasSeleccionadas.contains("ADHID")) ? resultSet.getBigDecimal("ADHID")
							: null,
					(columnasSeleccionadas.contains("ADHTIPO")) ? resultSet
							.getString("ADHTIPO") : null,
					(columnasSeleccionadas.contains("ADHNIF")) ? resultSet
							.getString("ADHNIF") : null,
					(columnasSeleccionadas.contains("ADHESNOM")) ? resultSet
							.getString("ADHESNOM") : null,
					(columnasSeleccionadas.contains("ADHESNOCO")) ? resultSet
							.getString("ADHESNOCO") : null,
					(columnasSeleccionadas.contains("ADHESCOIDCO")) ? resultSet
							.getString("ADHESCOIDCO") : null,
					(columnasSeleccionadas.contains("ADHORGEMP")) ? resultSet
							.getString("ADHORGEMP") : null,
					(columnasSeleccionadas.contains("ADHESURL")) ? resultSet
							.getString("ADHESURL") : null,
					(columnasSeleccionadas.contains("ADHESNOPECO")) ? resultSet
							.getString("ADHESNOPECO") : null,
					(columnasSeleccionadas.contains("ADHESCOEM")) ? resultSet
							.getString("ADHESCOEM") : null,
					(columnasSeleccionadas.contains("ADHESNRTEL")) ? resultSet
							.getString("ADHESNRTEL") : null,
					(columnasSeleccionadas.contains("ADHESNRTEL2")) ? resultSet
							.getString("ADHESNRTEL2") : null,
					(columnasSeleccionadas.contains("ADHESEXTRANJERO")) ? resultSet
							.getString("ADHESEXTRANJERO") : null,
					(columnasSeleccionadas.contains("ADHESNOMBRECP")) ? resultSet
							.getString("ADHESNOMBRECP") : null,
					(columnasSeleccionadas.contains("ADHESPROVIN")) ? resultSet
							.getString("ADHESPROVIN") : null,
					(columnasSeleccionadas.contains("ADHESMUNICI")) ? resultSet
							.getString("ADHESMUNICI") : null,
					(columnasSeleccionadas.contains("ADHESLOCALI")) ? resultSet
							.getString("ADHESLOCALI") : null,
					(columnasSeleccionadas.contains("ADHESCALLE")) ? resultSet
							.getString("ADHESCALLE") : null,
					(columnasSeleccionadas.contains("ADHESPORTAL")) ? resultSet
							.getString("ADHESPORTAL") : null,
					(columnasSeleccionadas.contains("ADHESPISO")) ? resultSet
							.getString("ADHESPISO") : null,
					(columnasSeleccionadas.contains("ADHESDIRECNOCAPV")) ? resultSet
							.getString("ADHESDIRECNOCAPV") : null,
					(columnasSeleccionadas.contains("ADHESNOREP")) ? resultSet
							.getString("ADHESNOREP") : null,
					(columnasSeleccionadas.contains("ADHESNIFREP")) ? resultSet
							.getString("ADHESNIFREP") : null,
					(columnasSeleccionadas.contains("ADHESINTIAR")) ? resultSet
							.getString("ADHESINTIAR") : null,
					(columnasSeleccionadas.contains("ADHESMEDIA")) ? resultSet
							.getString("ADHESMEDIA") : null,
					(columnasSeleccionadas.contains("ADHINDEF")) ? resultSet
							.getString("ADHINDEF") : null,
					(columnasSeleccionadas.contains("ADHFECFIN")) ? resultSet
							.getDate("ADHFECFIN") : null,
					(columnasSeleccionadas.contains("ADHSOLTIPNOTIF")) ? resultSet
							.getString("ADHSOLTIPNOTIF") : null,
					(columnasSeleccionadas.contains("ADHSOLIDIOMA")) ? resultSet
							.getString("ADHSOLIDIOMA") : null,
					(columnasSeleccionadas.contains("ADHSOLTELEM")) ? resultSet
							.getString("ADHSOLTELEM") : null,
					(columnasSeleccionadas.contains("ADHSOLEMAIL")) ? resultSet
							.getString("ADHSOLEMAIL") : null,
					(columnasSeleccionadas.contains("ADHSOLSMS")) ? resultSet
							.getString("ADHSOLSMS") : null,
					(columnasSeleccionadas.contains("ADHSECTORID")) ? resultSet
							.getString("ADHSECTORID") : null,
					(columnasSeleccionadas.contains("ADHFECALTA")) ? resultSet
							.getDate("ADHFECALTA") : null,
					(columnasSeleccionadas.contains("ADHSOLCOOR")) ? resultSet
							.getString("ADHSOLCOOR") : null,
					(columnasSeleccionadas.contains("ADHSOLNRAN")) ? resultSet
							.getBigDecimal("ADHSOLNRAN") : null,
					(columnasSeleccionadas.contains("ADHSOLNROR")) ? resultSet
							.getBigDecimal("ADHSOLNROR") : null,
					(columnasSeleccionadas.contains("ADHSOLREGEN")) ? resultSet
							.getString("ADHSOLREGEN") : null,
					(columnasSeleccionadas.contains("ADHESPAISID")) ? resultSet
							.getString("ADHESPAISID") : null,
					(columnasSeleccionadas.contains("ADHFECREGEN")) ? resultSet
							.getDate("ADHFECREGEN") : null, null);

			// aadimos los campos de descripcin
			retorno.setSectornombre((columnasSeleccionadas.contains("SENOMBRE")) ? resultSet
					.getString("SENOMBRE") : null);

			retorno.setSectornombreeu((columnasSeleccionadas
					.contains("SENOMBREE")) ? resultSet.getString("SENOMBREE")
					: null);

			retorno.setPaisnombre((columnasSeleccionadas.contains("PAISNOMBRE")) ? resultSet
					.getString("PAISNOMBRE") : null);

			retorno.setProvinnombre((columnasSeleccionadas
					.contains("PROVINNOMBRE")) ? resultSet
					.getString("PROVINNOMBRE") : null);
			retorno.setMunicinombre((columnasSeleccionadas
					.contains("MUNICINOMBRE")) ? resultSet
					.getString("MUNICINOMBRE") : null);
			retorno.setLocalinombre((columnasSeleccionadas
					.contains("LOCALINOMBRE")) ? resultSet
					.getString("LOCALINOMBRE") : null);
			retorno.setCallenombre((columnasSeleccionadas
					.contains("CALLENOMBRE")) ? resultSet
					.getString("CALLENOMBRE") : null);

			retorno.setPortalnombre((columnasSeleccionadas
					.contains("PORTALNOMBRE")) ? resultSet
					.getString("PORTALNOMBRE") : null);

			return retorno;

		}
	};

	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA
	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public BigDecimal currentValue() {
		String query = "SELECT SEQ_L21X9SQ00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		Integer entero = this.jdbcTemplate.queryForInt(query.toString(),
				params.toArray());
		return new BigDecimal(entero);
	}

	/**
	 * Inserts a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	public AdhesionTele add(AdhesionTele adhesiontele) {
		// quitamos el ID porque usamos la secuencia en el trigger

		String query = "INSERT INTO ADHESION_TELE ( ADHTIPO, ADHNIF, ADHESNOM, ADHESNOCO, ADHESCOIDCO, ADHORGEMP, ADHESURL, ADHESNOPECO, ADHESCOEM, ADHESNRTEL, ADHESNRTEL2, ADHESEXTRANJERO, ADHESNOMBRECP, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, ADHESNOREP, ADHESNIFREP, ADHESINTIAR, ADHESMEDIA, ADHINDEF, ADHFECFIN, ADHSOLTIPNOTIF, ADHSOLIDIOMA, ADHSOLTELEM, ADHSOLEMAIL, ADHSOLSMS, ADHSECTORID, ADHFECALTA, ADHSOLCOOR, ADHSOLNRAN, ADHSOLNROR, ADHSOLREGEN,ADHESPAISID,ADHFECREGEN,ADHESCODIGO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, adhesiontele.getAdhtipo(),
				adhesiontele.getAdhnif(), adhesiontele.getAdhesnom(),
				adhesiontele.getAdhesnoco(), adhesiontele.getAdhescoidco(),
				adhesiontele.getAdhorgemp(), adhesiontele.getAdhesurl(),
				adhesiontele.getAdhesnopeco(), adhesiontele.getAdhescoem(),
				adhesiontele.getAdhesnrtel(), adhesiontele.getAdhesnrtel2(),
				adhesiontele.getAdhesextranjero(),
				adhesiontele.getAdhesnombrecp(), adhesiontele.getAdhesprovin(),
				adhesiontele.getAdhesmunici(), adhesiontele.getAdheslocali(),
				adhesiontele.getAdhescalle(), adhesiontele.getAdhesportal(),
				adhesiontele.getAdhespiso(),
				adhesiontele.getAdhesdirecnocapv(),
				adhesiontele.getAdhesnorep(), adhesiontele.getAdhesnifrep(),
				adhesiontele.getAdhesintiar(), adhesiontele.getAdhesmedia(),
				adhesiontele.getAdhindef(), adhesiontele.getAdhfecfin(),
				adhesiontele.getAdhsoltipnotif(),
				adhesiontele.getAdhsolidioma(), adhesiontele.getAdhsoltelem(),
				adhesiontele.getAdhsolemail(), adhesiontele.getAdhsolsms(),
				adhesiontele.getAdhsectorid(), adhesiontele.getAdhfecalta(),
				adhesiontele.getAdhsolcoor(), adhesiontele.getAdhsolnran(),
				adhesiontele.getAdhsolnror(), adhesiontele.getAdhsolregen(),
				adhesiontele.getAdhespaisid(), adhesiontele.getAdhfecregen(),
				adhesiontele.getAdhescodigo());
		return adhesiontele;
	}

	/**
	 * Updates a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	public AdhesionTele update(AdhesionTele adhesiontele) {
		String query = "UPDATE ADHESION_TELE SET ADHTIPO=?, ADHNIF=?, ADHESNOM=?, ADHESNOCO=?, ADHESCOIDCO=?, ADHORGEMP=?, ADHESURL=?, ADHESNOPECO=?, ADHESCOEM=?, ADHESNRTEL=?, ADHESNRTEL2=?, ADHESEXTRANJERO=?, ADHESNOMBRECP=?, ADHESPROVIN=?, ADHESMUNICI=?, ADHESLOCALI=?, ADHESCALLE=?, ADHESPORTAL=?, ADHESPISO=?, ADHESDIRECNOCAPV=?, ADHESNOREP=?, ADHESNIFREP=?, ADHESINTIAR=?, ADHESMEDIA=?, ADHINDEF=?, ADHFECFIN=?, ADHSOLTIPNOTIF=?, ADHSOLIDIOMA=?, ADHSOLTELEM=?, ADHSOLEMAIL=?, ADHSOLSMS=?, ADHSECTORID=?, ADHFECALTA=?, ADHSOLCOOR=?, ADHSOLNRAN=?, ADHSOLNROR=?, ADHSOLREGEN=?, ADHESPAISID=?, ADHFECREGEN=?, ADHESCODIGO=? WHERE ADHID=?";
		this.jdbcTemplate.update(query, adhesiontele.getAdhtipo(),
				adhesiontele.getAdhnif(), adhesiontele.getAdhesnom(),
				adhesiontele.getAdhesnoco(), adhesiontele.getAdhescoidco(),
				adhesiontele.getAdhorgemp(), adhesiontele.getAdhesurl(),
				adhesiontele.getAdhesnopeco(), adhesiontele.getAdhescoem(),
				adhesiontele.getAdhesnrtel(), adhesiontele.getAdhesnrtel2(),
				adhesiontele.getAdhesextranjero(),
				adhesiontele.getAdhesnombrecp(), adhesiontele.getAdhesprovin(),
				adhesiontele.getAdhesmunici(), adhesiontele.getAdheslocali(),
				adhesiontele.getAdhescalle(), adhesiontele.getAdhesportal(),
				adhesiontele.getAdhespiso(),
				adhesiontele.getAdhesdirecnocapv(),
				adhesiontele.getAdhesnorep(), adhesiontele.getAdhesnifrep(),
				adhesiontele.getAdhesintiar(), adhesiontele.getAdhesmedia(),
				adhesiontele.getAdhindef(), adhesiontele.getAdhfecfin(),
				adhesiontele.getAdhsoltipnotif(),
				adhesiontele.getAdhsolidioma(), adhesiontele.getAdhsoltelem(),
				adhesiontele.getAdhsolemail(), adhesiontele.getAdhsolsms(),
				adhesiontele.getAdhsectorid(), adhesiontele.getAdhfecalta(),
				adhesiontele.getAdhsolcoor(), adhesiontele.getAdhsolnran(),
				adhesiontele.getAdhsolnror(), adhesiontele.getAdhsolregen(),
				adhesiontele.getAdhespaisid(), adhesiontele.getAdhfecregen(),
				adhesiontele.getAdhescodigo(), adhesiontele.getAdhid());
		return adhesiontele;
	}

	/**
	 * Finds a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	@Transactional(readOnly = true)
	public AdhesionTele find(AdhesionTele adhesiontele) {
		String query = "SELECT t1.ADHID ADHID, t1.ADHTIPO ADHTIPO, t1.ADHNIF ADHNIF, t1.ADHESNOM ADHESNOM, t1.ADHESNOCO ADHESNOCO, t1.ADHESCOIDCO ADHESCOIDCO, t1.ADHORGEMP ADHORGEMP, t1.ADHESURL ADHESURL, t1.ADHESNOPECO ADHESNOPECO, t1.ADHESCOEM ADHESCOEM, t1.ADHESNRTEL ADHESNRTEL, t1.ADHESNRTEL2 ADHESNRTEL2, t1.ADHESEXTRANJERO ADHESEXTRANJERO, t1.ADHESNOMBRECP ADHESNOMBRECP, t1.ADHESPROVIN ADHESPROVIN, t1.ADHESMUNICI ADHESMUNICI, t1.ADHESLOCALI ADHESLOCALI, t1.ADHESCALLE ADHESCALLE, t1.ADHESPORTAL ADHESPORTAL, t1.ADHESPISO ADHESPISO, t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV, t1.ADHESNOREP ADHESNOREP, t1.ADHESNIFREP ADHESNIFREP, t1.ADHESINTIAR ADHESINTIAR, t1.ADHESMEDIA ADHESMEDIA, t1.ADHINDEF ADHINDEF, t1.ADHFECFIN ADHFECFIN, t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF, t1.ADHSOLIDIOMA ADHSOLIDIOMA, t1.ADHSOLTELEM ADHSOLTELEM, t1.ADHSOLEMAIL ADHSOLEMAIL, t1.ADHSOLSMS ADHSOLSMS, t1.ADHSECTORID ADHSECTORID, t1.ADHFECALTA ADHFECALTA, t1.ADHSOLCOOR ADHSOLCOOR, t1.ADHSOLNRAN ADHSOLNRAN, t1.ADHSOLNROR ADHSOLNROR, t1.ADHSOLREGEN ADHSOLREGEN,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN FROM ADHESION_TELE t1   WHERE t1.ADHID = ? ";

		List<AdhesionTele> adhesionteleList = this.jdbcTemplate.query(query,
				this.rwMap, adhesiontele.getAdhid());
		return (AdhesionTele) DataAccessUtils.uniqueResult(adhesionteleList);
	}

	/**
	 * Removes a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return
	 */
	public void remove(AdhesionTele adhesiontele) {
		String query = "DELETE FROM ADHESION_TELE WHERE ADHID=?";
		this.jdbcTemplate.update(query, adhesiontele.getAdhid());
	}

	/**
	 * Finds a List of rows in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdhesionTele> findAll(AdhesionTele adhesiontele,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADHID ADHID,t1.ADHTIPO ADHTIPO,t1.ADHNIF ADHNIF,t1.ADHESNOM ADHESNOM,t1.ADHESNOCO ADHESNOCO,t1.ADHESCOIDCO ADHESCOIDCO,t1.ADHORGEMP ADHORGEMP,t1.ADHESURL ADHESURL,t1.ADHESNOPECO ADHESNOPECO,t1.ADHESCOEM ADHESCOEM,t1.ADHESNRTEL ADHESNRTEL,t1.ADHESNRTEL2 ADHESNRTEL2,t1.ADHESEXTRANJERO ADHESEXTRANJERO,t1.ADHESNOMBRECP ADHESNOMBRECP,t1.ADHESPROVIN ADHESPROVIN,t1.ADHESMUNICI ADHESMUNICI,t1.ADHESLOCALI ADHESLOCALI,t1.ADHESCALLE ADHESCALLE,t1.ADHESPORTAL ADHESPORTAL,t1.ADHESPISO ADHESPISO,t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV,t1.ADHESNOREP ADHESNOREP,t1.ADHESNIFREP ADHESNIFREP,t1.ADHESINTIAR ADHESINTIAR,t1.ADHESMEDIA ADHESMEDIA,t1.ADHINDEF ADHINDEF,t1.ADHFECFIN ADHFECFIN,t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF,t1.ADHSOLIDIOMA ADHSOLIDIOMA,t1.ADHSOLTELEM ADHSOLTELEM,t1.ADHSOLEMAIL ADHSOLEMAIL,t1.ADHSOLSMS ADHSOLSMS,t1.ADHSECTORID ADHSECTORID,t1.ADHFECALTA ADHFECALTA,t1.ADHSOLCOOR ADHSOLCOOR,t1.ADHSOLNRAN ADHSOLNRAN,t1.ADHSOLNROR ADHSOLNROR,t1.ADHSOLREGEN ADHSOLREGEN ,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN, t2.XBID DOCADHTELEXBID,t2.XBADHID DOCADHTELEXBADHID,t2.XBNOFILE DOCADHTELEXBNOFILE,t2.XBDATAFILE DOCADHTELEXBDATAFILE,t2.XBSIZEFILE DOCADHTELEXBSIZEFILE,t2.XBTEDESFILE DOCADHTELEXBTEDESFILE,t2.XBORIGEN DOCADHTELEXBORIGEN,t2.XBFECHA DOCADHTELEXBFECHA,t2.XBCONTENTTYPEFILE DOCADHTELEXBCONTENTTYPEFILE,t2.XBIDDOCUMENTUM DOCADHTELEXBIDDOCUMENTUM,t2.XBFECHAAPORTACION DOCADHTELEXBFECHAAPORTACION,t2.XBFECHAENTRADA DOCADHTELEXBFECHAENTRADA,t2.XBNUMREGISTROENTRADA DOCADHTELEXBNUMREGISTROENTRADA ");
		query.append("FROM ADHESION_TELE t1 ,DOCADHTELE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adhesiontele);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ADHID= t2.XBADHID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdhesionTele>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdhesionTele adhesiontele) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADHESION_TELE t1 , DOCADHTELE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adhesiontele);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ADHID= t2.XBADHID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdhesionTele table using like.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdhesionTele> findAllLike(AdhesionTele adhesiontele,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADHID ADHID,t1.ADHTIPO ADHTIPO,t1.ADHNIF ADHNIF,t1.ADHESNOM ADHESNOM,t1.ADHESNOCO ADHESNOCO,t1.ADHESCOIDCO ADHESCOIDCO,t1.ADHORGEMP ADHORGEMP,t1.ADHESURL ADHESURL,t1.ADHESNOPECO ADHESNOPECO,t1.ADHESCOEM ADHESCOEM,t1.ADHESNRTEL ADHESNRTEL,t1.ADHESNRTEL2 ADHESNRTEL2,t1.ADHESEXTRANJERO ADHESEXTRANJERO,t1.ADHESNOMBRECP ADHESNOMBRECP,t1.ADHESPROVIN ADHESPROVIN,t1.ADHESMUNICI ADHESMUNICI,t1.ADHESLOCALI ADHESLOCALI,t1.ADHESCALLE ADHESCALLE,t1.ADHESPORTAL ADHESPORTAL,t1.ADHESPISO ADHESPISO,t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV,t1.ADHESNOREP ADHESNOREP,t1.ADHESNIFREP ADHESNIFREP,t1.ADHESINTIAR ADHESINTIAR,t1.ADHESMEDIA ADHESMEDIA,t1.ADHINDEF ADHINDEF,t1.ADHFECFIN ADHFECFIN,t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF,t1.ADHSOLIDIOMA ADHSOLIDIOMA,t1.ADHSOLTELEM ADHSOLTELEM,t1.ADHSOLEMAIL ADHSOLEMAIL,t1.ADHSOLSMS ADHSOLSMS,t1.ADHSECTORID ADHSECTORID,t1.ADHFECALTA ADHFECALTA,t1.ADHSOLCOOR ADHSOLCOOR,t1.ADHSOLNRAN ADHSOLNRAN,t1.ADHSOLNROR ADHSOLNROR,t1.ADHSOLREGEN ADHSOLREGEN,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN ");
		query.append("FROM ADHESION_TELE t1  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adhesiontele,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdhesionTele>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdhesionTele table using like.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdhesionTele adhesiontele, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADHESION_TELE t1  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adhesiontele,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdhesionTele entity
	 * 
	 * @param adhesiontele
	 *            AdhesionTele Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdhesionTele adhesiontele) {

		StringBuilder where = new StringBuilder(
				AdhesionTeleDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adhesiontele != null && adhesiontele.getAdhid() != null) {
			where.append(" AND t1.ADHID = ?");
			params.add(adhesiontele.getAdhid());
		}
		if (adhesiontele != null && adhesiontele.getAdhtipo() != null) {
			where.append(" AND t1.ADHTIPO = ?");
			params.add(adhesiontele.getAdhtipo());
		}
		if (adhesiontele != null && adhesiontele.getAdhnif() != null) {
			where.append(" AND t1.ADHNIF = ?");
			params.add(adhesiontele.getAdhnif());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnom() != null) {
			where.append(" AND t1.ADHESNOM = ?");
			params.add(adhesiontele.getAdhesnom());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnoco() != null) {
			where.append(" AND t1.ADHESNOCO = ?");
			params.add(adhesiontele.getAdhesnoco());
		}
		if (adhesiontele != null && adhesiontele.getAdhescoidco() != null) {
			where.append(" AND t1.ADHESCOIDCO = ?");
			params.add(adhesiontele.getAdhescoidco());
		}
		if (adhesiontele != null && adhesiontele.getAdhorgemp() != null) {
			where.append(" AND t1.ADHORGEMP = ?");
			params.add(adhesiontele.getAdhorgemp());
		}
		if (adhesiontele != null && adhesiontele.getAdhesurl() != null) {
			where.append(" AND t1.ADHESURL = ?");
			params.add(adhesiontele.getAdhesurl());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnopeco() != null) {
			where.append(" AND t1.ADHESNOPECO = ?");
			params.add(adhesiontele.getAdhesnopeco());
		}
		if (adhesiontele != null && adhesiontele.getAdhescoem() != null) {
			where.append(" AND t1.ADHESCOEM = ?");
			params.add(adhesiontele.getAdhescoem());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnrtel() != null) {
			where.append(" AND t1.ADHESNRTEL = ?");
			params.add(adhesiontele.getAdhesnrtel());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnrtel2() != null) {
			where.append(" AND t1.ADHESNRTEL2 = ?");
			params.add(adhesiontele.getAdhesnrtel2());
		}
		if (adhesiontele != null && adhesiontele.getAdhesextranjero() != null) {
			where.append(" AND t1.ADHESEXTRANJERO = ?");
			params.add(adhesiontele.getAdhesextranjero());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnombrecp() != null) {
			where.append(" AND t1.ADHESNOMBRECP = ?");
			params.add(adhesiontele.getAdhesnombrecp());
		}
		if (adhesiontele != null && adhesiontele.getAdhesprovin() != null) {
			where.append(" AND t1.ADHESPROVIN = ?");
			params.add(adhesiontele.getAdhesprovin());
		}
		if (adhesiontele != null && adhesiontele.getAdhesmunici() != null) {
			where.append(" AND t1.ADHESMUNICI = ?");
			params.add(adhesiontele.getAdhesmunici());
		}
		if (adhesiontele != null && adhesiontele.getAdheslocali() != null) {
			where.append(" AND t1.ADHESLOCALI = ?");
			params.add(adhesiontele.getAdheslocali());
		}
		if (adhesiontele != null && adhesiontele.getAdhescalle() != null) {
			where.append(" AND t1.ADHESCALLE = ?");
			params.add(adhesiontele.getAdhescalle());
		}
		if (adhesiontele != null && adhesiontele.getAdhesportal() != null) {
			where.append(" AND t1.ADHESPORTAL = ?");
			params.add(adhesiontele.getAdhesportal());
		}
		if (adhesiontele != null && adhesiontele.getAdhespiso() != null) {
			where.append(" AND t1.ADHESPISO = ?");
			params.add(adhesiontele.getAdhespiso());
		}
		if (adhesiontele != null && adhesiontele.getAdhesdirecnocapv() != null) {
			where.append(" AND t1.ADHESDIRECNOCAPV = ?");
			params.add(adhesiontele.getAdhesdirecnocapv());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnorep() != null) {
			where.append(" AND t1.ADHESNOREP = ?");
			params.add(adhesiontele.getAdhesnorep());
		}
		if (adhesiontele != null && adhesiontele.getAdhesnifrep() != null) {
			where.append(" AND t1.ADHESNIFREP = ?");
			params.add(adhesiontele.getAdhesnifrep());
		}
		if (adhesiontele != null && adhesiontele.getAdhesintiar() != null) {
			where.append(" AND t1.ADHESINTIAR = ?");
			params.add(adhesiontele.getAdhesintiar());
		}
		if (adhesiontele != null && adhesiontele.getAdhesmedia() != null) {
			where.append(" AND t1.ADHESMEDIA = ?");
			params.add(adhesiontele.getAdhesmedia());
		}
		if (adhesiontele != null && adhesiontele.getAdhindef() != null) {
			where.append(" AND t1.ADHINDEF = ?");
			params.add(adhesiontele.getAdhindef());
		}
		if (adhesiontele != null && adhesiontele.getAdhfecfin() != null) {
			where.append(" AND t1.ADHFECFIN = ?");
			params.add(adhesiontele.getAdhfecfin());
		}
		if (adhesiontele != null && adhesiontele.getAdhsoltipnotif() != null) {
			where.append(" AND t1.ADHSOLTIPNOTIF = ?");
			params.add(adhesiontele.getAdhsoltipnotif());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolidioma() != null) {
			where.append(" AND t1.ADHSOLIDIOMA = ?");
			params.add(adhesiontele.getAdhsolidioma());
		}
		if (adhesiontele != null && adhesiontele.getAdhsoltelem() != null) {
			where.append(" AND t1.ADHSOLTELEM = ?");
			params.add(adhesiontele.getAdhsoltelem());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolemail() != null) {
			where.append(" AND t1.ADHSOLEMAIL = ?");
			params.add(adhesiontele.getAdhsolemail());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolsms() != null) {
			where.append(" AND t1.ADHSOLSMS = ?");
			params.add(adhesiontele.getAdhsolsms());
		}
		if (adhesiontele != null && adhesiontele.getAdhsectorid() != null) {
			where.append(" AND t1.ADHSECTORID = ?");
			params.add(adhesiontele.getAdhsectorid());
		}
		if (adhesiontele != null && adhesiontele.getAdhfecalta() != null) {
			where.append(" AND t1.ADHFECALTA = ?");
			params.add(adhesiontele.getAdhfecalta());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolcoor() != null) {
			where.append(" AND t1.ADHSOLCOOR = ?");
			params.add(adhesiontele.getAdhsolcoor());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolnran() != null) {
			where.append(" AND t1.ADHSOLNRAN = ?");
			params.add(adhesiontele.getAdhsolnran());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolnror() != null) {
			where.append(" AND t1.ADHSOLNROR = ?");
			params.add(adhesiontele.getAdhsolnror());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolregen() != null) {
			where.append(" AND t1.ADHSOLREGEN = ?");
			params.add(adhesiontele.getAdhsolregen());
		}
		if (adhesiontele != null && adhesiontele.getAdhespaisid() != null) {
			where.append(" AND t1.ADHESPAISID = ?");
			params.add(adhesiontele.getAdhespaisid());
		}
		if (adhesiontele != null && adhesiontele.getAdhfecregen() != null) {
			where.append(" AND t1.ADHFECREGEN = ?");
			params.add(adhesiontele.getAdhfecregen());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdhesionTele entity
	 * 
	 * @param adhesiontele
	 *            AdhesionTele Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(AdhesionTele adhesiontele,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdhesionTeleDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adhesiontele != null && adhesiontele.getAdhid() != null) {
			where.append(" AND t1.ADHID = ?");
			params.add(adhesiontele.getAdhid());
		}
		if (adhesiontele != null && adhesiontele.getAdhtipo() != null) {
			where.append(" AND UPPER(t1.ADHTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhtipo().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhtipo().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHTIPO IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhnif() != null) {
			where.append(" AND UPPER(t1.ADHNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhnif().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHNIF IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnom() != null) {
			where.append(" AND UPPER(t1.ADHESNOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnom().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnom().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNOM IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnoco() != null) {
			where.append(" AND UPPER(t1.ADHESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnoco().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNOCO IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhescoidco() != null) {
			where.append(" AND UPPER(t1.ADHESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhescoidco().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhescoidco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESCOIDCO IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhorgemp() != null) {
			where.append(" AND UPPER(t1.ADHORGEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhorgemp().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhorgemp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHORGEMP IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesurl() != null) {
			where.append(" AND UPPER(t1.ADHESURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesurl().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesurl().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESURL IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnopeco() != null) {
			where.append(" AND UPPER(t1.ADHESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnopeco().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnopeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNOPECO IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhescoem() != null) {
			where.append(" AND UPPER(t1.ADHESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhescoem().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhescoem().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESCOEM IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnrtel() != null) {
			where.append(" AND UPPER(t1.ADHESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNRTEL IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnrtel2() != null) {
			where.append(" AND UPPER(t1.ADHESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNRTEL2 IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesextranjero() != null) {
			where.append(" AND UPPER(t1.ADHESEXTRANJERO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesextranjero().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adhesiontele.getAdhesextranjero().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESEXTRANJERO IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnombrecp() != null) {
			where.append(" AND UPPER(t1.ADHESNOMBRECP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnombrecp().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnombrecp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNOMBRECP IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesprovin() != null) {
			where.append(" AND UPPER(t1.ADHESPROVIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesprovin().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesprovin().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESPROVIN IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesmunici() != null) {
			where.append(" AND UPPER(t1.ADHESMUNICI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesmunici().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesmunici().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESMUNICI IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdheslocali() != null) {
			where.append(" AND UPPER(t1.ADHESLOCALI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdheslocali().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdheslocali().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESLOCALI IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhescalle() != null) {
			where.append(" AND UPPER(t1.ADHESCALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhescalle().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhescalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESCALLE IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesportal() != null) {
			where.append(" AND UPPER(t1.ADHESPORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesportal().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesportal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESPORTAL IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhespiso() != null) {
			where.append(" AND UPPER(t1.ADHESPISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhespiso().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhespiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESPISO IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesdirecnocapv() != null) {
			where.append(" AND UPPER(t1.ADHESDIRECNOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesdirecnocapv().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adhesiontele.getAdhesdirecnocapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESDIRECNOCAPV IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnorep() != null) {
			where.append(" AND UPPER(t1.ADHESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnorep().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnorep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNOREP IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesnifrep() != null) {
			where.append(" AND UPPER(t1.ADHESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesnifrep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESNIFREP IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesintiar() != null) {
			where.append(" AND UPPER(t1.ADHESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesintiar().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesintiar().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESINTIAR IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhesmedia() != null) {
			where.append(" AND UPPER(t1.ADHESMEDIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhesmedia().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhesmedia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHESMEDIA IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhindef() != null) {
			where.append(" AND UPPER(t1.ADHINDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhindef().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhindef().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHINDEF IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhfecfin() != null) {
			where.append(" AND t1.ADHFECFIN = ?");
			params.add(adhesiontele.getAdhfecfin());
		}
		if (adhesiontele != null && adhesiontele.getAdhsoltipnotif() != null) {
			where.append(" AND UPPER(t1.ADHSOLTIPNOTIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsoltipnotif().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsoltipnotif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLTIPNOTIF IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhsolidioma() != null) {
			where.append(" AND UPPER(t1.ADHSOLIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsolidioma().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsolidioma().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLIDIOMA IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhsoltelem() != null) {
			where.append(" AND UPPER(t1.ADHSOLTELEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsoltelem().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsoltelem().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLTELEM IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhsolemail() != null) {
			where.append(" AND UPPER(t1.ADHSOLEMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsolemail().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsolemail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLEMAIL IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhsolsms() != null) {
			where.append(" AND UPPER(t1.ADHSOLSMS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsolsms().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsolsms().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLSMS IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhsectorid() != null) {
			where.append(" AND UPPER(t1.ADHSECTORID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsectorid().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsectorid().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSECTORID IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhfecalta() != null) {
			where.append(" AND t1.ADHFECALTA = ?");
			params.add(adhesiontele.getAdhfecalta());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolcoor() != null) {
			where.append(" AND UPPER(t1.ADHSOLCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsolcoor().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsolcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLCOOR IS NOT NULL");
		}
		if (adhesiontele != null && adhesiontele.getAdhsolnran() != null) {
			where.append(" AND t1.ADHSOLNRAN = ?");
			params.add(adhesiontele.getAdhsolnran());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolnror() != null) {
			where.append(" AND t1.ADHSOLNROR = ?");
			params.add(adhesiontele.getAdhsolnror());
		}
		if (adhesiontele != null && adhesiontele.getAdhsolregen() != null) {
			where.append(" AND UPPER(t1.ADHSOLREGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adhesiontele.getAdhsolregen().toUpperCase() + "%");
			} else {
				params.add("%" + adhesiontele.getAdhsolregen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ADHSOLREGEN IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	@Transactional(readOnly = true)
	public AdhesionTele findSolicitud(AdhesionTele adhesiontele) {
		String query = "SELECT t1.ADHID ADHID, t1.ADHTIPO ADHTIPO, t1.ADHNIF ADHNIF, t1.ADHESNOM ADHESNOM, t1.ADHESNOCO ADHESNOCO, t1.ADHESCOIDCO ADHESCOIDCO, t1.ADHORGEMP ADHORGEMP, t1.ADHESURL ADHESURL, t1.ADHESNOPECO ADHESNOPECO, t1.ADHESCOEM ADHESCOEM, t1.ADHESNRTEL ADHESNRTEL, t1.ADHESNRTEL2 ADHESNRTEL2, t1.ADHESEXTRANJERO ADHESEXTRANJERO, t1.ADHESNOMBRECP ADHESNOMBRECP, t1.ADHESPROVIN ADHESPROVIN, t1.ADHESMUNICI ADHESMUNICI, t1.ADHESLOCALI ADHESLOCALI, t1.ADHESCALLE ADHESCALLE, t1.ADHESPORTAL ADHESPORTAL, t1.ADHESPISO ADHESPISO, t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV, t1.ADHESNOREP ADHESNOREP, t1.ADHESNIFREP ADHESNIFREP, t1.ADHESINTIAR ADHESINTIAR, t1.ADHESMEDIA ADHESMEDIA, t1.ADHINDEF ADHINDEF, t1.ADHFECFIN ADHFECFIN, t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF, t1.ADHSOLIDIOMA ADHSOLIDIOMA, t1.ADHSOLTELEM ADHSOLTELEM, t1.ADHSOLEMAIL ADHSOLEMAIL, t1.ADHSOLSMS ADHSOLSMS, t1.ADHSECTORID ADHSECTORID, t1.ADHFECALTA ADHFECALTA, t1.ADHSOLCOOR ADHSOLCOOR, t1.ADHSOLNRAN ADHSOLNRAN, t1.ADHSOLNROR ADHSOLNROR, t1.ADHSOLREGEN ADHSOLREGEN, t1.ADHESPAISID ADHESPAISID, t1.ADHFECREGEN ADHFECREGEN, t3.SENOMBRE SENOMBRE, t3.SENOMBREE SENOMBREE, T17_PAIS.DS_O PAISNOMBRE, T17_PROVINCIA.DS_O PROVINNOMBRE, T17_MUNICIPIO.DS_O MUNICINOMBRE, T17_LOCALIDAD.DS_O LOCALINOMBRE, T17_CALLE.DS_O CALLENOMBRE, T17_PORTAL.NUMERO PORTALNOMBRE FROM ADHESION_TELE t1  LEFT OUTER JOIN SECTOR t3 ON t1.ADHSECTORID=t3.SECODIGO LEFT OUTER JOIN T17_PAIS ON t1.ADHESPAISID=T17_PAIS.ID LEFT OUTER JOIN T17_PROVINCIA ON t1.ADHESPROVIN=T17_PROVINCIA.ID LEFT OUTER JOIN T17_MUNICIPIO ON T17_MUNICIPIO.PROVINCIA_ID=t1.ADHESPROVIN AND T17_MUNICIPIO.ID=t1.ADHESMUNICI LEFT OUTER JOIN T17_LOCALIDAD ON T17_LOCALIDAD.ID=t1.ADHESLOCALI AND T17_LOCALIDAD.PROVINCIA_ID=t1.ADHESPROVIN AND T17_LOCALIDAD.MUNICIPIO_ID=t1.ADHESMUNICI LEFT OUTER JOIN T17_CALLE ON T17_CALLE.ID=t1.ADHESCALLE AND T17_CALLE.PROVINCIA_ID=t1.ADHESPROVIN AND T17_CALLE.MUNICIPIO_ID=t1.ADHESMUNICI LEFT OUTER JOIN T17_PORTAL ON T17_PORTAL.ID=t1.ADHESPORTAL AND T17_PORTAL.CALLE_ID=t1.ADHESCALLE AND T17_PORTAL.LOCALIDAD_ID=t1.ADHESLOCALI WHERE t1.ADHID = ?";

		List<AdhesionTele> adhesionteleList = this.jdbcTemplate.query(query,
				this.rwMap, adhesiontele.getAdhid());
		return (AdhesionTele) DataAccessUtils.uniqueResult(adhesionteleList);
	}

	/**
	 * Updates a single row in the Docadhtele table.
	 * 
	 * @param adhesionTele
	 *            AdhesionTele
	 * @return AdhesionTele
	 */
	public AdhesionTele updateNumRegistroEntrada(AdhesionTele adhesionTele) {
		String query = "UPDATE ADHESION_TELE SET ADHSOLREGEN=? WHERE ADHID=?";
		this.jdbcTemplate.update(query, adhesionTele.getAdhsolregen(),
				adhesionTele.getAdhid());
		return adhesionTele;
	}

	/**
	 * Finds a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	@Transactional(readOnly = true)
	public AdhesionTele findPorRegistroEntrada(AdhesionTele adhesiontele) {
		String query = "SELECT t1.ADHID ADHID, t1.ADHTIPO ADHTIPO, t1.ADHNIF ADHNIF, t1.ADHESNOM ADHESNOM, t1.ADHESNOCO ADHESNOCO, t1.ADHESCOIDCO ADHESCOIDCO, t1.ADHORGEMP ADHORGEMP, t1.ADHESURL ADHESURL, t1.ADHESNOPECO ADHESNOPECO, t1.ADHESCOEM ADHESCOEM, t1.ADHESNRTEL ADHESNRTEL, t1.ADHESNRTEL2 ADHESNRTEL2, t1.ADHESEXTRANJERO ADHESEXTRANJERO, t1.ADHESNOMBRECP ADHESNOMBRECP, t1.ADHESPROVIN ADHESPROVIN, t1.ADHESMUNICI ADHESMUNICI, t1.ADHESLOCALI ADHESLOCALI, t1.ADHESCALLE ADHESCALLE, t1.ADHESPORTAL ADHESPORTAL, t1.ADHESPISO ADHESPISO, t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV, t1.ADHESNOREP ADHESNOREP, t1.ADHESNIFREP ADHESNIFREP, t1.ADHESINTIAR ADHESINTIAR, t1.ADHESMEDIA ADHESMEDIA, t1.ADHINDEF ADHINDEF, t1.ADHFECFIN ADHFECFIN, t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF, t1.ADHSOLIDIOMA ADHSOLIDIOMA, t1.ADHSOLTELEM ADHSOLTELEM, t1.ADHSOLEMAIL ADHSOLEMAIL, t1.ADHSOLSMS ADHSOLSMS, t1.ADHSECTORID ADHSECTORID, t1.ADHFECALTA ADHFECALTA, t1.ADHSOLCOOR ADHSOLCOOR, t1.ADHSOLNRAN ADHSOLNRAN, t1.ADHSOLNROR ADHSOLNROR, t1.ADHSOLREGEN ADHSOLREGEN,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN FROM ADHESION_TELE t1   WHERE t1.ADHSOLREGEN = ? ";

		List<AdhesionTele> adhesionteleList = this.jdbcTemplate.query(query,
				this.rwMap, adhesiontele.getAdhsolregen());
		return (AdhesionTele) DataAccessUtils.uniqueResult(adhesionteleList);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * @return
	 */
	public void removeTelematicosAntiguas() {

		String query = "DELETE FROM ADHESION_TELE WHERE ADHESION_TELE.ADHFECALTA+8<SYSDATE AND ADHESION_TELE.ADHSOLREGEN IS NULL ";

		this.jdbcTemplate.update(query);

	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
