package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.AdhesionTele;

/**
 * AdhesionTeleDao  
 * 
 *  
 */

public interface AdhesionTeleDao {

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return BigDecimal
	 */
	BigDecimal currentValue();

	/**
	 * Inserts a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @return AdhesionTele
	 */
	AdhesionTele add(AdhesionTele adhesiontele);

	/**
	 * Updates a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @return AdhesionTele
	 */
	AdhesionTele update(AdhesionTele adhesiontele);

	/**
	 * Finds a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @return AdhesionTele
	 */
	AdhesionTele find(AdhesionTele adhesiontele);

	/**
	 * Deletes a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @return
	 */
	void remove(AdhesionTele adhesiontele);

	/**
	 * Finds a List of rows in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdhesionTele> findAll(AdhesionTele adhesiontele, Pagination pagination);

	/**
	 * Counts rows in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @return Long
	 */
	Long findAllCount(AdhesionTele adhesiontele);

	/**
	 * Finds rows in the AdhesionTele table using like.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdhesionTele> findAllLike(AdhesionTele adhesiontele,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdhesionTele table using like.
	 * 
	 * @param adhesiontele
	 *            AdhesionTele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdhesionTele adhesiontele, Boolean startsWith);

	/**
	 * Finds a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	@Transactional(readOnly = true)
	AdhesionTele findSolicitud(AdhesionTele adhesiontele);

	/**
	 * Updates a single row in the Docadhtele table.
	 * 
	 * @param adhesionTele
	 *            AdhesionTele
	 * @return AdhesionTele
	 */
	AdhesionTele updateNumRegistroEntrada(AdhesionTele adhesionTele);

	/**
	 * Finds a single row in the AdhesionTele table.
	 * 
	 * @param adhesiontele
	 *            Pagination
	 * @return AdhesionTele
	 */
	AdhesionTele findPorRegistroEntrada(AdhesionTele adhesiontele);

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * 
	 */
	void removeTelematicosAntiguas();

}
