package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.FiltroInspeccion;
import com.ejie.y41b.model.InspeccionEnvios;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.ProductosCampanhaActuacion;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ActuacionDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ActuacionDaoImpl implements ActuacionDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Actuacion> rwMapSimple = new RowMapper<Actuacion>() {
		public Actuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Actuacion actuacion = new Actuacion(resultSet.getString("ATCOAC"), resultSet.getString("ATCODIGO"),
					resultSet.getBigDecimal("ATNROR"), resultSet.getString("ATCOTTA"), resultSet.getString("ATCOTMA"),
					resultSet.getString("ATCOES"), resultSet.getString("ATCOAV"), resultSet.getString("ATCOSE"),
					resultSet.getString("ATCOPS"), resultSet.getString("ATNOPRSE"), resultSet.getString("ATNOMAPS"),
					resultSet.getString("ATNOMOPS"), resultSet.getString("ATNRLOPS"), resultSet.getDate("ATFEDUMI"),
					resultSet.getString("ATINPRSE"), resultSet.getBigDecimal("ATCAUNEP"),
					resultSet.getString("ATTEINFO"), resultSet.getString("ATCOTP"), resultSet.getString("ATCOCM"),
					resultSet.getString("ATCOHD"), resultSet.getString("ATCOAT"), resultSet.getString("ATCOAL"),
					resultSet.getString("ATCOHDDENUNCIA"), resultSet.getString("ATCODIGOBARRAS"),
					resultSet.getString("FCODIGOACTUAL"), resultSet.getString("TRCODIGOACTUAL"),
					resultSet.getString("TRPOSIBLECODIGO"), resultSet.getDate("ATFECHACIERRE"),
					resultSet.getString("ISKONTSUMOBIDE"), resultSet.getString("ATIDCOMUNICACIONSOIVRE"),
					resultSet.getBigDecimal("ATUEXISTENTES"), resultSet.getBigDecimal("ATUINMOVILIZADAS"),
					resultSet.getBigDecimal("ATUDESTRUIDAS"), resultSet.getBigDecimal("ATUDEVOLUCIONORIGEN"),
					resultSet.getBigDecimal("ATULIBRECOMERCIALIZACION"), resultSet.getBigDecimal("ATUOTROS"),
					resultSet.getBigDecimal("ATUTOMAMUESTRAS"), resultSet.getBigDecimal("ATURECUPERADAS"),
					resultSet.getBigDecimal("ATUPENDIENTES"), resultSet.getString("ATCOPSNOM"),
					resultSet.getDate("ATFEFIN"), resultSet.getString("ATCOPG"), resultSet.getString("ATTIPO"),
					resultSet.getString("ATADICIONAL"), resultSet.getString("ATCOCR"),
					resultSet.getString("ATFORMANOTIFESTABLECIMIENTORE"),
					resultSet.getString("ATFORMANOTIFESTABLECIMIENTOVI"), null, null, null,
					new Actdec(resultSet.getString("ADCODIGO"), resultSet.getString("ADCOAT"),
							resultSet.getString("ADCOOR"), resultSet.getString("ADCOTTD"), resultSet.getDate("ADFEDE"),
							resultSet.getDate("ADFECODE")),
					resultSet.getString("ATACUERDOINICIO"), resultSet.getString("ATENPLATEA"),
					resultSet.getString("ATPARTICIPACIONRESPONSABLE"), resultSet.getString("ATDESTNOTIFICAVISITADO"),
					resultSet.getString("ATDESTNOTIFICARESPONSABLE"));
			actuacion.setAtonline(resultSet.getString("ATONLINE"));
			return actuacion;
		}
	};

	private RowMapper<Actuacion> rwMap = new RowMapper<Actuacion>() {
		public Actuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Actuacion actuacion = new Actuacion(resultSet.getString("ATCOAC"), resultSet.getString("ATCODIGO"),
					resultSet.getBigDecimal("ATNROR"), resultSet.getString("ATCOTTA"), resultSet.getString("ATCOTMA"),
					resultSet.getString("ATCOES"), resultSet.getString("ATCOAV"), resultSet.getString("ATCOSE"),
					resultSet.getString("ATCOPS"), resultSet.getString("ATNOPRSE"), resultSet.getString("ATNOMAPS"),
					resultSet.getString("ATNOMOPS"), resultSet.getString("ATNRLOPS"), resultSet.getDate("ATFEDUMI"),
					resultSet.getString("ATINPRSE"), resultSet.getBigDecimal("ATCAUNEP"),
					resultSet.getString("ATTEINFO"), resultSet.getString("ATCOTP"), resultSet.getString("ATCOCM"),
					resultSet.getString("ATCOHD"), resultSet.getString("ATCOAT"), resultSet.getString("ATCOAL"),
					resultSet.getString("ATCOHDDENUNCIA"), resultSet.getString("ATCODIGOBARRAS"),
					resultSet.getString("FCODIGOACTUAL"), resultSet.getString("TRCODIGOACTUAL"),
					resultSet.getString("TRPOSIBLECODIGO"), resultSet.getDate("ATFECHACIERRE"),
					resultSet.getString("ISKONTSUMOBIDE"), resultSet.getString("ATIDCOMUNICACIONSOIVRE"),
					resultSet.getBigDecimal("ATUEXISTENTES"), resultSet.getBigDecimal("ATUINMOVILIZADAS"),
					resultSet.getBigDecimal("ATUDESTRUIDAS"), resultSet.getBigDecimal("ATUDEVOLUCIONORIGEN"),
					resultSet.getBigDecimal("ATULIBRECOMERCIALIZACION"), resultSet.getBigDecimal("ATUOTROS"),
					resultSet.getBigDecimal("ATUTOMAMUESTRAS"), resultSet.getBigDecimal("ATURECUPERADAS"),
					resultSet.getBigDecimal("ATUPENDIENTES"), resultSet.getString("ATCOPSNOM"),
					resultSet.getDate("ATFEFIN"), resultSet.getString("ATCOPG"), resultSet.getString("ATTIPO"),
					resultSet.getString("ATADICIONAL"), resultSet.getString("ATCOCR"),
					resultSet.getString("ATFORMANOTIFESTABLECIMIENTORE"),
					resultSet.getString("ATFORMANOTIFESTABLECIMIENTOVI"),
					new Acta(resultSet.getString("ActaACCODIGO"), resultSet.getString("ActaACCOOR"),
							resultSet.getString("ActaACCOMO"), resultSet.getString("ActaACNROR"),
							resultSet.getBigDecimal("ActaACNRAN"), resultSet.getString("ActaACCOINUN"),
							resultSet.getString("ActaACCOINDO"), resultSet.getDate("ActaACFELE"),
							resultSet.getDate("ActaACFERE"), resultSet.getString("ActaACCOES"),
							resultSet.getString("ActaACCOAV"), resultSet.getString("ActaACCOSE"),
							resultSet.getDate("ActaACFEEX"), resultSet.getString("ActaACINRE"),
							resultSet.getString("ActaACNOCO"), resultSet.getString("ActaACDNICO"),
							resultSet.getString("ActaACCOCO"), resultSet.getString("ActaACDIRCO"),
							resultSet.getString("ActaACCOLOCO"), resultSet.getString("ActaACNRCPCO"),
							resultSet.getString("ActaACNRTFCO"), resultSet.getString("ActaACCOTD"),
							resultSet.getString("ActaACNORAPAISID"), resultSet.getString("ActaACNORAPAISNOMBRE"),
							resultSet.getString("ActaACNORAPROVINCIAID"), resultSet.getString("ActaACNOMBREPROVINCIA"),
							resultSet.getString("ActaACNORAMUNICIPIOID"), resultSet.getString("ActaACNOMBREMUNICIPIO"),
							resultSet.getString("ActaACNORALOCALIDADID"), resultSet.getString("ActaACNOMBRELOCALIDAD"),
							resultSet.getString("ActaACNORACALLEID"), resultSet.getString("ActaACNOMBRECALLE"),
							resultSet.getString("ActaACNORACPID"), resultSet.getString("ActaACNOMBRECP"),
							resultSet.getString("ActaACNORAPORTALID"), resultSet.getString("ActaACNOMBREPORTAL"),
							resultSet.getString("ActaACNOMBREPISO"), resultSet.getString("ActaACDIRECCIONNOCAPV"),
							resultSet.getString("ActaACAPE1CO"), resultSet.getString("ActaACAPE2CO"),
							resultSet.getString("ActaACCODEXPEDIENTEORIGEN"), resultSet.getString("ActaACCOORORIGEN"),
							null, null, null, null, null, null, null, null),
					null,
					new Establecimiento(resultSet.getString("ATCOES"), resultSet.getString("ESNOMBRE"), null, null),
					new Actdec(resultSet.getString("ADCODIGO"), resultSet.getString("ADCOAT"),
							resultSet.getString("ADCOOR"), resultSet.getString("ADCOTTD"), resultSet.getDate("ADFEDE"),
							resultSet.getDate("ADFECODE")),
					resultSet.getString("ATACUERDOINICIO"), resultSet.getString("ATENPLATEA"),
					resultSet.getString("ATPARTICIPACIONRESPONSABLE"), resultSet.getString("ATDESTNOTIFICAVISITADO"),
					resultSet.getString("ATDESTNOTIFICARESPONSABLE"));

			actuacion.getActa().setActiororigen(resultSet.getString("ACTIORORIGEN"));
			actuacion.setAtonline(resultSet.getString("ATONLINE"));

			return actuacion;
		}
	};

	private RowMapper<InspeccionEnvios> rwMapEnvios = new RowMapper<InspeccionEnvios>() {
		public InspeccionEnvios mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			InspeccionEnvios inspeccionEnvios = new InspeccionEnvios();
			inspeccionEnvios.setFechaenvio(resultSet.getDate("FECHAENVIO"));
			inspeccionEnvios.setFecharegistro(resultSet.getDate("FECHAREGISTRO"));
			inspeccionEnvios.setFechaacuse(resultSet.getDate("FECHAACUSE"));
			inspeccionEnvios.setTicodigo(resultSet.getString("TICODIGO"));
			inspeccionEnvios.setTrcodigo(resultSet.getString("TRCODIGO"));
			inspeccionEnvios.setNombretramite(resultSet.getString("NOMBRETRAMITE"));
			inspeccionEnvios.setNombretramitee(resultSet.getString("NOMBRETRAMITEE"));
			inspeccionEnvios.setTiponotificacionplatea(resultSet.getString("TIPONOTIFICACIONPLATEA"));
			inspeccionEnvios.setEstado(resultSet.getString("ESTADO"));
			inspeccionEnvios.setDestinatario(resultSet.getString("DESTINATARIO"));
			inspeccionEnvios.setTipoenvio(resultSet.getString("TIPOENVIO"));
			inspeccionEnvios.setTienvrem(resultSet.getString("ENVIOREMESA"));
			inspeccionEnvios.setTicodrem(resultSet.getString("TICODREM"));
			inspeccionEnvios.setRmestado(resultSet.getString("ESTADOREMESA"));
			inspeccionEnvios.setTiacusereintentado(resultSet.getString("TIACUSEREINTENTADO"));
			return inspeccionEnvios;
		}
	};

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionEnviosCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append(
				" FROM	TRAMITE_INSPECCION t1, TRAMITE_INSPECCION t2, TRAMITE t3, TRAMITE tt3, INTERVINIENTES t4, INTERVINIENTES tt4, REMESA t5, REMESA tt5 ");

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 " + "AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) " + "AND t1.TICOTEE= t3.TRCODIGO "
				+ "AND t2.TICOTEE= tt3.TRCODIGO(+) " + "AND t1.TIIDDESTINATARIO=t4.IDINTERVINIENTE(+) "
				+ "AND t2.TIIDDESTINATARIO=tt4.IDINTERVINIENTE(+) " + "AND t1.TICODREM=t5.RMCODIGO(+) "
				+ "AND t2.TICODREM=tt5.RMCODIGO(+) "
				// TODO: comprobar que K20 (el q est en solicitudes) == IN24
				+ "AND (t1.TICOTEE='IN24' OR t1.TICOTEE='IN23') "
				+ "AND ((t1.TICOTEE='IN23') OR ( t1.TICOTEE!='IN23' AND t1.TIFECHAFIN is not null)) "
				+ "AND t1.TIATCODIGO = ? ");

		params.add(actuacion.getAtcodigo());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InspeccionEnvios> findAllSolicitudEnvios(Actuacion actuacion, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT DECODE(t1.TICOTEE,'IN23',t2.TIFECHAFIN,t1.TIFECHAFIN) FECHAENVIO, DECODE(t1.TICOTEE,'IN23',t2.TIFECHAREGISTROSALIDA,t1.TIFECHAREGISTROSALIDA) FECHAREGISTRO, DECODE(t1.TICOTEE,'IN23', t1.TIACUSERECIBO) FECHAACUSE,t1.TIACUSEREINTENTADO "
						+ ", DECODE(t1.TICOTEE,'IN23',t2.TICODIGO,t1.TICODIGO) TICODIGO "
						+ ", DECODE(t1.TICOTEE,'IN23',tt3.TRCODIGO,t3.TRCODIGO) TRCODIGO "
						+ ", DECODE(t1.TICOTEE,'IN23',tt3.TRNOMBRE,t3.TRNOMBRE) NOMBRETRAMITE, DECODE(t1.TICOTEE,'IN23',tt3.TRNOMBREE,t3.TRNOMBREE) NOMBRETRAMITEE"
						+ ", DECODE(t1.TICOTEE,'IN23',t2.TITIPONOTIFICACIONPLATEA,t1.TITIPONOTIFICACIONPLATEA) TIPONOTIFICACIONPLATEA"
						+ ", DECODE(t1.TIFECHAFIN,null,'E',DECODE(t1.TIACUSERECIBORECIBIDO,'A','R','R','R','N','N')) ESTADO, DECODE(t1.TICOTEE,'IN23',tt4.NOMBRE || ' ' || tt4.APELLIDO1 || ' ' || tt4.APELLIDO2,t4.NOMBRE || ' ' || t4.APELLIDO1 || ' ' || t4.APELLIDO2) DESTINATARIO"
						+ ", DECODE(t1.TICOTEE,'IN23',t2.TITIPONOTIFICACION, t1.TITIPOCOMUNICACION)  TIPOENVIO "
						+ ", DECODE(t1.TICOTEE,'IN23',t2.TIENVREM, t1.TIENVREM)  ENVIOREMESA "
						+ ", DECODE(t1.TICOTEE,'IN23',t2.TICODREM, t1.TICODREM)  TICODREM "
						+ ", DECODE(t1.TICOTEE,'IN23',tt5.RMESTADO, t5.RMESTADO)  ESTADOREMESA ");

		query.append(
				" FROM	TRAMITE_INSPECCION t1, TRAMITE_INSPECCION t2, TRAMITE t3, TRAMITE tt3, INTERVINIENTES t4, INTERVINIENTES tt4, REMESA t5, REMESA tt5 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 " + "AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) " + "AND t1.TICOTEE= t3.TRCODIGO "
				+ "AND t2.TICOTEE= tt3.TRCODIGO(+) " + "AND t1.TIIDDESTINATARIO=t4.IDINTERVINIENTE(+) "
				+ "AND t2.TIIDDESTINATARIO=tt4.IDINTERVINIENTE(+) " + "AND t1.TICODREM=t5.RMCODIGO(+) "
				+ "AND t2.TICODREM=tt5.RMCODIGO(+) "
				// TODO: comprobar que K20 (el q est en solicitudes) == IN24
				+ "AND (t1.TICOTEE='IN24' OR t1.TICOTEE='IN23') "
				+ "AND ((t1.TICOTEE='IN23') OR ( t1.TICOTEE!='IN23' AND t1.TIFECHAFIN is not null)) "
				+ "AND t1.TIATCODIGO = ? ");
		params.add(actuacion.getAtcodigo());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InspeccionEnvios>) this.jdbcTemplate.query(query.toString(), this.rwMapEnvios, params.toArray());
	}

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion add(Actuacion actuacion) {

		String query = "INSERT INTO ACTUACION (ATCODIGO, ATCOAC, ATNROR, ATCOTTA, ATCOTMA, ATCOES, ATCOAV, ATCOSE, ATCOPS, ATNOPRSE, ATNOMAPS, ATNOMOPS, ATNRLOPS, ATFEDUMI, ATINPRSE, ATCAUNEP, ATTEINFO, ATCOTP, ATCOCM, ATCOHD, ATCOAT, ATCOAL, ATCODIGOBARRAS, FCODIGOACTUAL, TRCODIGOACTUAL, TRPOSIBLECODIGO, ATFECHACIERRE, ISKONTSUMOBIDE, ATIDCOMUNICACIONSOIVRE, ATUEXISTENTES, ATUINMOVILIZADAS, ATUDESTRUIDAS, ATUDEVOLUCIONORIGEN, ATULIBRECOMERCIALIZACION, ATUOTROS, ATUTOMAMUESTRAS, ATURECUPERADAS,ATUPENDIENTES, ATCOPSNOM,atfefin,atcopg,attipo,atadicional,atcocr,atformanotifestablecimientore,atformanotifestablecimientovi,atidiomaestablecimientovi,atacuerdoinicio,ATCOHDDENUNCIA, ATDESTNOTIFICAVISITADO, ATDESTNOTIFICARESPONSABLE, ATONLINE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, actuacion.getAtcodigo(), actuacion.getAtcoac(), actuacion.getAtnror(),
				actuacion.getAtcotta(), actuacion.getAtcotma(), actuacion.getAtcoes(), actuacion.getAtcoav(),
				actuacion.getAtcose(), actuacion.getAtcops(), actuacion.getAtnoprse(), actuacion.getAtnomaps(),
				actuacion.getAtnomops(), actuacion.getAtnrlops(), actuacion.getAtfedumi(), actuacion.getAtinprse(),
				actuacion.getAtcaunep(), actuacion.getAtteinfo(), actuacion.getAtcotp(), actuacion.getAtcocm(),
				actuacion.getAtcohd(), actuacion.getAtcoat(), actuacion.getAtcoal(), actuacion.getAtcodigobarras(),
				actuacion.getFcodigoactual(), actuacion.getTrcodigoactual(), actuacion.getTrposiblecodigo(),
				actuacion.getAtfechacierre(), actuacion.getIskontsumobide(), actuacion.getAtidcomunicacionsoivre(),
				actuacion.getAtuexistentes(), actuacion.getAtuinmovilizadas(), actuacion.getAtudestruidas(),
				actuacion.getAtudevolucionorigen(), actuacion.getAtulibrecomercializacion(), actuacion.getAtuotros(),
				actuacion.getAtutomamuestras(), actuacion.getAturecuperadas(), actuacion.getAtupendientes(),
				actuacion.getAtcopsnom(), actuacion.getAtfefin(), actuacion.getAtcopg(), actuacion.getAttipo(),
				actuacion.getAtadicional(), actuacion.getAtcocr(), actuacion.getAtformanotifestablecimientore(),
				actuacion.getAtformanotifestablecimientovi(), actuacion.getAtidiomaestablecimientovi(),
				actuacion.getAtacuerdoinicio(), actuacion.getAtcohddenuncia(), actuacion.getAtdestnotificavisitado(),
				actuacion.getAtdestnotificaresponsable(), actuacion.getAtonline());

		return actuacion;
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion addMasiva(Actuacion actuacion) {

		String query = "INSERT INTO ACTUACION (ATCODIGO, ATCOAC, ATNROR, ATCOES, ATCOPS, ATNOPRSE, ATNOMAPS, ATNOMOPS, ATNRLOPS, ATFEDUMI, ATCOCM, ATCOHD, ATCOAL, ATCODIGOBARRAS, ISKONTSUMOBIDE, ATIDCOMUNICACIONSOIVRE, ATCOPG,ATTIPO,ATADICIONAL,ATCOCR,ATFORMANOTIFESTABLECIMIENTORE,ATFORMANOTIFESTABLECIMIENTOVI,ATIDIOMAESTABLECIMIENTOVI,ATACUERDOINICIO,ATCOHDDENUNCIA, ATDESTNOTIFICAVISITADO, ATDESTNOTIFICARESPONSABLE, ATINSPECCIONSOLICITADA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, actuacion.getAtcodigo(), actuacion.getAtcoac(), actuacion.getAtnror(),
				actuacion.getAtcoes(), actuacion.getAtcops(), actuacion.getAtnoprse(), actuacion.getAtnomaps(),
				actuacion.getAtnomops(), actuacion.getAtnrlops(), actuacion.getAtfedumi(), actuacion.getAtcocm(),
				actuacion.getAtcohd(), actuacion.getAtcoal(), actuacion.getAtcodigobarras(),
				actuacion.getIskontsumobide(), actuacion.getAtidcomunicacionsoivre(), actuacion.getAtcopg(),
				actuacion.getAttipo(), actuacion.getAtadicional(), actuacion.getAtcocr(),
				actuacion.getAtformanotifestablecimientore(), actuacion.getAtformanotifestablecimientovi(),
				actuacion.getAtidiomaestablecimientovi(), actuacion.getAtacuerdoinicio(), actuacion.getAtcohddenuncia(),
				actuacion.getAtdestnotificavisitado(), actuacion.getAtdestnotificaresponsable(),
				actuacion.getAtinspeccionsolicitada());

		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion update(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOAC=?, ATNROR=?, ATCOTTA=?, ATCOTMA=?, ATCOES=?, ATCOAV=?, ATCOSE=?, ATCOPS=?, ATNOPRSE=?, ATNOMAPS=?, ATNOMOPS=?, ATNRLOPS=?, ATFEDUMI=?, ATINPRSE=?, ATCAUNEP=?, ATTEINFO=?, ATCOTP=?, ATCOCM=?, ATCOHD=?, ATCOAT=?, ATCOAL=?, ATCODIGOBARRAS=?, FCODIGOACTUAL=?, TRCODIGOACTUAL=?, TRPOSIBLECODIGO=?, ATFECHACIERRE=?, ISKONTSUMOBIDE=?, ATIDCOMUNICACIONSOIVRE=?, ATUEXISTENTES=?, ATUINMOVILIZADAS=?, ATUDESTRUIDAS=?, ATUDEVOLUCIONORIGEN=?, ATULIBRECOMERCIALIZACION=?, ATUOTROS=? ,ATUTOMAMUESTRAS=?, ATURECUPERADAS = ?,ATUPENDIENTES = ?, ATCOPSNOM=?, ATFORMANOTIFESTABLECIMIENTORE=?, ATFORMANOTIFESTABLECIMIENTOVI=?, ATIDIOMAESTABLECIMIENTOVI=?, ATDESTNOTIFICAVISITADO=?, ATDESTNOTIFICARESPONSABLE=?, ATONLINE=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtcoac(), actuacion.getAtnror(), actuacion.getAtcotta(),
				actuacion.getAtcotma(), actuacion.getAtcoes(), actuacion.getAtcoav(), actuacion.getAtcose(),
				actuacion.getAtcops(), actuacion.getAtnoprse(), actuacion.getAtnomaps(), actuacion.getAtnomops(),
				actuacion.getAtnrlops(), actuacion.getAtfedumi(), actuacion.getAtinprse(), actuacion.getAtcaunep(),
				actuacion.getAtteinfo(), actuacion.getAtcotp(), actuacion.getAtcocm(), actuacion.getAtcohd(),
				actuacion.getAtcoat(), actuacion.getAtcoal(), actuacion.getAtcodigobarras(),
				actuacion.getFcodigoactual(), actuacion.getTrcodigoactual(), actuacion.getTrposiblecodigo(),
				actuacion.getAtfechacierre(), actuacion.getIskontsumobide(), actuacion.getAtidcomunicacionsoivre(),
				actuacion.getAtuexistentes(), actuacion.getAtuinmovilizadas(), actuacion.getAtudestruidas(),
				actuacion.getAtudevolucionorigen(), actuacion.getAtulibrecomercializacion(), actuacion.getAtuotros(),
				actuacion.getAtutomamuestras(), actuacion.getAturecuperadas(), actuacion.getAtupendientes(),
				actuacion.getAtcopsnom(), actuacion.getAtformanotifestablecimientore(),
				actuacion.getAtformanotifestablecimientovi(), actuacion.getAtidiomaestablecimientovi(),
				actuacion.getAtdestnotificavisitado(), actuacion.getAtdestnotificaresponsable(),
				actuacion.getAtonline(), actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateFechaProtocolo(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATFEPROTOCOLO=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtfeprotocolo(), actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateFechaCierre(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATFECHACIERRE=SYSDATE WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateATIDPARTICIPACIONVISITADO(Intervinientes intervinientes) {
		String query = "UPDATE ACTUACION SET ATIDPARTICIPACIONVISITADO=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, intervinientes.getNif(), intervinientes.getIdExpediente());
		return intervinientes;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateATIDPARTICIPACIONRESPONSABLE(Intervinientes intervinientes) {
		String query = "UPDATE ACTUACION SET ATIDPARTICIPACIONRESPONSABLE=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, intervinientes.getNif(), intervinientes.getIdExpediente());
		return intervinientes;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateFechaCierreReabrirExpediente(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATFECHACIERRE=null WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion find(Actuacion actuacion) {
		String query = "SELECT t1.ATCODIGO ATCODIGO, t1.ATCOAC ATCOAC, t1.ATNROR ATNROR, t1.ATCOTTA ATCOTTA, t1.ATCOTMA ATCOTMA, t1.ATCOES ATCOES, t1.ATCOAV ATCOAV, t1.ATCOSE ATCOSE, t1.ATCOPS ATCOPS, t1.ATNOPRSE ATNOPRSE, t1.ATNOMAPS ATNOMAPS, t1.ATNOMOPS ATNOMOPS, t1.ATNRLOPS ATNRLOPS, t1.ATFEDUMI ATFEDUMI, t1.ATINPRSE ATINPRSE, t1.ATCAUNEP ATCAUNEP, t1.ATTEINFO ATTEINFO, t1.ATCOTP ATCOTP, t1.ATCOCM ATCOCM, t1.ATCOHD ATCOHD, t1.ATCOAT ATCOAT, t1.ATCOAL ATCOAL, t1.ATCOHDDENUNCIA ATCOHDDENUNCIA, t1.ATCODIGOBARRAS ATCODIGOBARRAS, t1.FCODIGOACTUAL FCODIGOACTUAL, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t1.TRPOSIBLECODIGO TRPOSIBLECODIGO, t1.ATFECHACIERRE ATFECHACIERRE, t1.ISKONTSUMOBIDE ISKONTSUMOBIDE, t1.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t1.ATUEXISTENTES ATUEXISTENTES, t1.ATUINMOVILIZADAS ATUINMOVILIZADAS, t1.ATUDESTRUIDAS ATUDESTRUIDAS, t1.ATUDEVOLUCIONORIGEN ATUDEVOLUCIONORIGEN, t1.ATULIBRECOMERCIALIZACION ATULIBRECOMERCIALIZACION, t1.ATUOTROS ATUOTROS,t1.ATUTOMAMUESTRAS ATUTOMAMUESTRAS, t1.ATURECUPERADAS ATURECUPERADAS,t1.ATUPENDIENTES ATUPENDIENTES, t1.ATCOPSNOM ATCOPSNOM, t1.ATFEFIN ATFEFIN, t1.ATCOPG ATCOPG, t1.ATTIPO ATTIPO, t1.ATADICIONAL ATADICIONAL, t1.ATCOCR ATCOCR, t1.ATFORMANOTIFESTABLECIMIENTORE ATFORMANOTIFESTABLECIMIENTORE, t1.ATFORMANOTIFESTABLECIMIENTOVI ATFORMANOTIFESTABLECIMIENTOVI, t1.ATACUERDOINICIO ATACUERDOINICIO, t1.ATENPLATEA ATENPLATEA, t1.ATPARTICIPACIONRESPONSABLE ATPARTICIPACIONRESPONSABLE, t1.ATDESTNOTIFICAVISITADO ATDESTNOTIFICAVISITADO, t1.ATDESTNOTIFICARESPONSABLE ATDESTNOTIFICARESPONSABLE, t1.ATONLINE ATONLINE, t2.ACCODIGO ACTAACCODIGO, t2.ACTIORORIGEN ACTIORORIGEN, t2.ACCOOR ACTAACCOOR, t2.ACNROR ACTAACNROR, t2.ACNRAN ACTAACNRAN, t2.ACCOMO ACTAACCOMO, t2.ACCOINUN ACTAACCOINUN, t2.ACCOINDO ACTAACCOINDO, t2.ACFELE ACTAACFELE, t2.ACFERE ACTAACFERE, t2.ACCOES ACTAACCOES, t2.ACCOAV ACTAACCOAV, t2.ACCOSE ACTAACCOSE, t2.ACFEEX ACTAACFEEX, t2.ACINRE ACTAACINRE, t2.ACNOCO ACTAACNOCO, t2.ACDNICO ACTAACDNICO, t2.ACCOCO ACTAACCOCO, t2.ACDIRCO ACTAACDIRCO, t2.ACCOLOCO ACTAACCOLOCO, t2.ACNRCPCO ACTAACNRCPCO, t2.ACNRTFCO ACTAACNRTFCO, t2.ACCOTD ACTAACCOTD, t2.ACNORA_PAIS_ID ACTAACNORAPAISID, t2.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE, t2.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID, t2.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA, t2.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID, t2.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO, t2.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID, t2.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD, t2.ACNORA_CALLE_ID ACTAACNORACALLEID, t2.ACNOMBRE_CALLE ACTAACNOMBRECALLE, t2.ACNORA_CP_ID ACTAACNORACPID, t2.ACNOMBRE_CP ACTAACNOMBRECP, t2.ACNORA_PORTAL_ID ACTAACNORAPORTALID, t2.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL, t2.ACNOMBRE_PISO ACTAACNOMBREPISO, t2.ACDIRECCION_NOCAPV ACTAACDIRECCIONNOCAPV, t2.ACAPE1CO ACTAACAPE1CO, t2.ACAPE2CO ACTAACAPE2CO, t2.ACCODEXPEDIENTEORIGEN ACTAACCODEXPEDIENTEORIGEN, t2.ACCOORORIGEN ACTAACCOORORIGEN, t3.ESNOMBRE ESNOMBRE, t4.ADCODIGO ADCODIGO, t4.ADCOAT ADCOAT, t4.ADCOOR ADCOOR, t4.ADCOTTD ADCOTTD, t4.ADFEDE ADFEDE, t4.ADFECODE ADFECODE FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3, ACTDEC t4  WHERE t1.ATCODIGO = ? AND t1.ATCOAC= t2.ACCODIGO(+) AND t1.ATCOES = t3.ESCODIGO(+) AND t1.ATCODIGO = t4.ADCOAT(+)";

		List<Actuacion> actuacionList = this.jdbcTemplate.query(query, this.rwMap, actuacion.getAtcodigo());
		return (Actuacion) DataAccessUtils.uniqueResult(actuacionList);
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion findByActa(Actuacion actuacion) {
		String query = "SELECT t1.ATCODIGO ATCODIGO, t1.ATCOAC ATCOAC, t1.ATNROR ATNROR, t1.ATCOTTA ATCOTTA, t1.ATCOTMA ATCOTMA, t1.ATCOES ATCOES, t1.ATCOAV ATCOAV, t1.ATCOSE ATCOSE, t1.ATCOPS ATCOPS, t1.ATNOPRSE ATNOPRSE, t1.ATNOMAPS ATNOMAPS, t1.ATNOMOPS ATNOMOPS, t1.ATNRLOPS ATNRLOPS, t1.ATFEDUMI ATFEDUMI, t1.ATINPRSE ATINPRSE, t1.ATCAUNEP ATCAUNEP, t1.ATTEINFO ATTEINFO, t1.ATCOTP ATCOTP, t1.ATCOCM ATCOCM, t1.ATCOHD ATCOHD, t1.ATCOAT ATCOAT, t1.ATCOAL ATCOAL, t1.ATCOHDDENUNCIA ATCOHDDENUNCIA, t1.ATCODIGOBARRAS ATCODIGOBARRAS, t1.FCODIGOACTUAL FCODIGOACTUAL, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t1.TRPOSIBLECODIGO TRPOSIBLECODIGO, t1.ATFECHACIERRE ATFECHACIERRE, t1.ISKONTSUMOBIDE ISKONTSUMOBIDE, t1.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t1.ATUEXISTENTES ATUEXISTENTES, t1.ATUINMOVILIZADAS ATUINMOVILIZADAS, t1.ATUDESTRUIDAS ATUDESTRUIDAS, t1.ATUDEVOLUCIONORIGEN ATUDEVOLUCIONORIGEN, t1.ATULIBRECOMERCIALIZACION ATULIBRECOMERCIALIZACION, t1.ATUOTROS ATUOTROS,t1.ATUTOMAMUESTRAS ATUTOMAMUESTRAS, t1.ATURECUPERADAS ATURECUPERADAS,t1.ATUPENDIENTES ATUPENDIENTES, t1.ATCOPSNOM ATCOPSNOM, t1.ATFEFIN ATFEFIN, t1.ATCOPG ATCOPG, t1.ATTIPO ATTIPO, t1.ATADICIONAL ATADICIONAL, t1.ATCOCR ATCOCR, t1.ATFORMANOTIFESTABLECIMIENTORE ATFORMANOTIFESTABLECIMIENTORE, t1.ATFORMANOTIFESTABLECIMIENTOVI ATFORMANOTIFESTABLECIMIENTOVI, t1.ATACUERDOINICIO ATACUERDOINICIO, t1.ATENPLATEA ATENPLATEA, t1.ATPARTICIPACIONRESPONSABLE ATPARTICIPACIONRESPONSABLE, t1.ATDESTNOTIFICAVISITADO ATDESTNOTIFICAVISITADO, t1.ATDESTNOTIFICARESPONSABLE ATDESTNOTIFICARESPONSABLE, t1.ATONLINE ATONLINE, t2.ADCODIGO ADCODIGO, t2.ADCOAT ADCOAT, t2.ADCOOR ADCOOR, t2.ADCOTTD ADCOTTD, t2.ADFEDE ADFEDE, t2.ADFECODE ADFECODE FROM ACTUACION t1, ACTDEC t2 WHERE t1.ATCODIGO = t2.ADCOAT(+) AND t1.ATCODIGO = ?  ";

		List<Actuacion> actuacionList = this.jdbcTemplate.query(query, this.rwMapSimple, actuacion.getAtcodigo());
		return (Actuacion) DataAccessUtils.uniqueResult(actuacionList);
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateEstablecimiento(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOES=? WHERE ATCODIGO=?";

		Object getEstablecimientoEscodigoAux = null;
		if (actuacion.getEstablecimiento() != null && actuacion.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = actuacion.getEstablecimiento().getEscodigo();
		}

		this.jdbcTemplate.update(query, getEstablecimientoEscodigoAux, actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateEnPLATEA(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATENPLATEA=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI, actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateATPARTICIPACIONRESPONSABLE(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATPARTICIPACIONRESPONSABLE=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI, actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateIsTOMAMUESTRAS(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATISTOMAMUESTRAS =? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI, actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateIsCONTROLESTANDAR(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATISCONTROLESTANDAR =? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI, actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateIsCONTROLOTROS(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATISCONTROLOTROS=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI, actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateRelacionConAlerta(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOALRELACIONADA=?, ATCOCRRELACIONADA=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtcoalrelacionada(), actuacion.getAtcocrrelacionada(),
				actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateRelacionConCampana(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOCMRELACIONADA=?, ATCOPGRELACIONADA=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtcocmrelacionada(), actuacion.getAtcopgrelacionada(),
				actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Removes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return
	 */
	public void remove(Actuacion actuacion) {
		String query = "DELETE FROM ACTUACION WHERE ATCODIGO=?";
		this.jdbcTemplate.update(query, actuacion.getAtcodigo());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAll(Actuacion actuacion, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ATCODIGO ATCODIGO,t1.ATCOAC ATCOAC,t1.ATNROR ATNROR,t1.ATCOTTA ATCOTTA,t1.ATCOTMA ATCOTMA,t1.ATCOES ATCOES,t1.ATCOAV ATCOAV,t1.ATCOSE ATCOSE,t1.ATCOPS ATCOPS,t1.ATNOPRSE ATNOPRSE,t1.ATNOMAPS ATNOMAPS,t1.ATNOMOPS ATNOMOPS,t1.ATNRLOPS ATNRLOPS,t1.ATFEDUMI ATFEDUMI,t1.ATINPRSE ATINPRSE,t1.ATCAUNEP ATCAUNEP,t1.ATTEINFO ATTEINFO,t1.ATCOTP ATCOTP,t1.ATCOCM ATCOCM,t1.ATCOHD ATCOHD,t1.ATCOAT ATCOAT,t1.ATCOAL ATCOAL,t1.ATCOHDDENUNCIA ATCOHDDENUNCIA,t1.ATCODIGOBARRAS ATCODIGOBARRAS,t1.FCODIGOACTUAL FCODIGOACTUAL,t1.TRCODIGOACTUAL TRCODIGOACTUAL,t1.TRPOSIBLECODIGO TRPOSIBLECODIGO,t1.ATFECHACIERRE ATFECHACIERRE,t1.ISKONTSUMOBIDE ISKONTSUMOBIDE,t1.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE,t1.ATUEXISTENTES ATUEXISTENTES,t1.ATUINMOVILIZADAS ATUINMOVILIZADAS,t1.ATUDESTRUIDAS ATUDESTRUIDAS,t1.ATUDEVOLUCIONORIGEN ATUDEVOLUCIONORIGEN,t1.ATULIBRECOMERCIALIZACION ATULIBRECOMERCIALIZACION, t1.ATUOTROS ATUOTROS,t1.ATUTOMAMUESTRAS ATUTOMAMUESTRAS, t1.ATURECUPERADAS ATURECUPERADAS,t1.ATUPENDIENTES ATUPENDIENTES,t1.ATCOPSNOM ATCOPSNOM, t1.ATFEFIN ATFEFIN, t1.ATCOPG ATCOPG, t1.ATTIPO ATTIPO, t1.ATADICIONAL ATADICIONAL, t1.ATCOCR ATCOCR, t1.ATFORMANOTIFESTABLECIMIENTORE ATFORMANOTIFESTABLECIMIENTORE, t1.ATFORMANOTIFESTABLECIMIENTOVI ATFORMANOTIFESTABLECIMIENTOVI, t1.ATACUERDOINICIO ATACUERDOINICIO, t1.ATENPLATEA ATENPLATEA, t1.ATPARTICIPACIONRESPONSABLE ATPARTICIPACIONRESPONSABLE, t1.ATDESTNOTIFICAVISITADO ATDESTNOTIFICAVISITADO, t1.ATDESTNOTIFICARESPONSABLE ATDESTNOTIFICARESPONSABLE, t1.ATONLINE ATONLINE,t2.ACCODIGO ACTAACCODIGO, t2.ACTIORORIGEN ACTIORORIGEN,t2.ACCOOR ACTAACCOOR,t2.ACNROR ACTAACNROR,t2.ACNRAN ACTAACNRAN, t2.ACCOMO ACTAACCOMO, t2.ACCOINUN ACTAACCOINUN,t2.ACCOINDO ACTAACCOINDO,t2.ACFELE ACTAACFELE,t2.ACFERE ACTAACFERE,t2.ACCOES ACTAACCOES,t2.ACCOAV ACTAACCOAV,t2.ACCOSE ACTAACCOSE,t2.ACFEEX ACTAACFEEX,t2.ACINRE ACTAACINRE,t2.ACNOCO ACTAACNOCO,t2.ACDNICO ACTAACDNICO,t2.ACCOCO ACTAACCOCO,t2.ACDIRCO ACTAACDIRCO,t2.ACCOLOCO ACTAACCOLOCO,t2.ACNRCPCO ACTAACNRCPCO,t2.ACNRTFCO ACTAACNRTFCO,t2.ACCOTD ACTAACCOTD,t2.ACNORA_PAIS_ID ACTAACNORAPAISID,t2.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE,t2.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID,t2.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA,t2.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID,t2.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO,t2.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID,t2.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD,t2.ACNORA_CALLE_ID ACTAACNORACALLEID,t2.ACNOMBRE_CALLE ACTAACNOMBRECALLE,t2.ACNORA_CP_ID ACTAACNORACPID,t2.ACNOMBRE_CP ACTAACNOMBRECP,t2.ACNORA_PORTAL_ID ACTAACNORAPORTALID,t2.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL,t2.ACNOMBRE_PISO ACTAACNOMBREPISO,t2.ACDIRECCION_NOCAPV ACTAACDIRECCIONNOCAPV,t2.ACAPE1CO ACTAACAPE1CO,t2.ACAPE2CO ACTAACAPE2CO,t2.ACCODEXPEDIENTEORIGEN ACTAACCODEXPEDIENTEORIGEN,t2.ACCOORORIGEN ACTAACCOORORIGEN, t3.ESNOMBRE ESNOMBRE, t4.ADCODIGO ADCODIGO, t4.ADCOAT ADCOAT, t4.ADCOOR ADCOOR, t4.ADCOTTD ADCOTTD, t4.ADFEDE ADFEDE, t4.ADFECODE ADFECODE ");
		query.append("FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3, ACTDEC t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actuacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) AND t1.ATCOES = t3.ESCODIGO (+) AND t1.ATCODIGO = t4.ADCOAT(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 , ACTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ProductosCampanhaActuacion> findAllProductosCampanha(Actuacion actuacion, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ATCOPS ATCOPS,t1.ATNOPRSE ATNOPRSE,t1.ATNOMAPS ATNOMAPS,t1.ATNOMOPS ATNOMOPS,t1.ATNRLOPS ATNRLOPS,t1.ATFEDUMI ATFEDUMI,t1.ATCODIGOBARRAS ATCODIGOBARRAS, t1.ATTIPO ATTIPO, t2.ESCODIGO ESCODIGO, t2.NOMBRE ESNOMBRE, t2.NIF ESNIF, t2.ESNOCO ESNOCO, t2.NOMBRE_PROVINCIA ESNOMBREPROVINCIA,t2.NOMBRE_MUNICIPIO ESNOMBREMUNICIPIO ");
		query.append("FROM ACTUACION t1, INTERVINIENTES t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereProductosCampanhaMap(actuacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ATCODIGO= t2.HDCODIGO(+) AND t2.TIPO_INTERVINIENTE(+)='V' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ProductosCampanhaActuacion>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<ProductosCampanhaActuacion>() {
					public ProductosCampanhaActuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new ProductosCampanhaActuacion(resultSet.getString("ATCOPS"),
								resultSet.getString("ATNOPRSE"), resultSet.getString("ATNOMAPS"),
								resultSet.getString("ATNOMOPS"), resultSet.getString("ATNRLOPS"),
								resultSet.getDate("ATFEDUMI"), resultSet.getString("ATCODIGOBARRAS"),
								resultSet.getString("ATTIPO"), resultSet.getString("ESCODIGO"),
								resultSet.getString("ESNOMBRE"), resultSet.getString("ESNIF"),
								resultSet.getString("ESNOCO"), resultSet.getString("ESNOMBREPROVINCIA"),
								resultSet.getString("ESNOMBREMUNICIPIO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllProductosCampanhaCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1, INTERVINIENTES t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereProductosCampanhaMap(actuacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ATCODIGO= t2.HDCODIGO(+) AND t2.TIPO_INTERVINIENTE(+)='V' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereProductosCampanhaMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND t1.ATCOCM = ?");
		params.add(actuacion.getAtcocm());

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAllLike(Actuacion actuacion, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ATCODIGO ATCODIGO,t1.ATCOAC ATCOAC,t1.ATNROR ATNROR,t1.ATCOTTA ATCOTTA,t1.ATCOTMA ATCOTMA,t1.ATCOES ATCOES,t1.ATCOAV ATCOAV,t1.ATCOSE ATCOSE,t1.ATCOPS ATCOPS,t1.ATNOPRSE ATNOPRSE,t1.ATNOMAPS ATNOMAPS,t1.ATNOMOPS ATNOMOPS,t1.ATNRLOPS ATNRLOPS,t1.ATFEDUMI ATFEDUMI,t1.ATINPRSE ATINPRSE,t1.ATCAUNEP ATCAUNEP,t1.ATTEINFO ATTEINFO,t1.ATCOTP ATCOTP,t1.ATCOCM ATCOCM,t1.ATCOHD ATCOHD,t1.ATCOAT ATCOAT,t1.ATCOAL ATCOAL,t1.ATCOHDDENUNCIA ATCOHDDENUNCIA,t1.ATCODIGOBARRAS ATCODIGOBARRAS,t1.FCODIGOACTUAL FCODIGOACTUAL,t1.TRCODIGOACTUAL TRCODIGOACTUAL,t1.TRPOSIBLECODIGO TRPOSIBLECODIGO,t1.ATFECHACIERRE ATFECHACIERRE,t1.ISKONTSUMOBIDE ISKONTSUMOBIDE,t1.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE,t1.ATUEXISTENTES ATUEXISTENTES,t1.ATUINMOVILIZADAS ATUINMOVILIZADAS,t1.ATUDESTRUIDAS ATUDESTRUIDAS,t1.ATUDEVOLUCIONORIGEN ATUDEVOLUCIONORIGEN,t1.ATULIBRECOMERCIALIZACION ATULIBRECOMERCIALIZACION, t1.ATUOTROS ATUOTROS,t1.ATUTOMAMUESTRAS ATUTOMAMUESTRAS, t1.ATURECUPERADAS ATURECUPERADAS,t1.ATUPENDIENTES ATUPENDIENTES,t1.ATCOPSNOM ATCOPSNOM, t1.ATFEFIN ATFEFIN, t1.ATCOPG ATCOPG, t1.ATTIPO ATTIPO, t1.ATADICIONAL ATADICIONAL, t1.ATCOCR ATCOCR, t1.ATFORMANOTIFESTABLECIMIENTORE ATFORMANOTIFESTABLECIMIENTORE, t1.ATFORMANOTIFESTABLECIMIENTOVI ATFORMANOTIFESTABLECIMIENTOVI, t1.ATACUERDOINICIO ATACUERDOINICIO, t1.ATENPLATEA ATENPLATEA, t1.ATPARTICIPACIONRESPONSABLE ATPARTICIPACIONRESPONSABLE, t1.ATDESTNOTIFICAVISITADO ATDESTNOTIFICAVISITADO, t1.ATDESTNOTIFICARESPONSABLE ATDESTNOTIFICARESPONSABLE, t1.ATONLINE ATONLINE,t2.ACCODIGO ACTAACCODIGO, t2.ACTIORORIGEN ACTIORORIGEN,t2.ACCOOR ACTAACCOOR,t2.ACNROR ACTAACNROR,t2.ACNRAN ACTAACNRAN, t2.ACCOMO ACTAACCOMO, t2.ACCOINUN ACTAACCOINUN,t2.ACCOINDO ACTAACCOINDO,t2.ACFELE ACTAACFELE,t2.ACFERE ACTAACFERE,t2.ACCOES ACTAACCOES,t2.ACCOAV ACTAACCOAV,t2.ACCOSE ACTAACCOSE,t2.ACFEEX ACTAACFEEX,t2.ACINRE ACTAACINRE,t2.ACNOCO ACTAACNOCO,t2.ACDNICO ACTAACDNICO,t2.ACCOCO ACTAACCOCO,t2.ACDIRCO ACTAACDIRCO,t2.ACCOLOCO ACTAACCOLOCO,t2.ACNRCPCO ACTAACNRCPCO,t2.ACNRTFCO ACTAACNRTFCO,t2.ACCOTD ACTAACCOTD,t2.ACNORA_PAIS_ID ACTAACNORAPAISID,t2.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE,t2.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID,t2.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA,t2.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID,t2.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO,t2.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID,t2.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD,t2.ACNORA_CALLE_ID ACTAACNORACALLEID,t2.ACNOMBRE_CALLE ACTAACNOMBRECALLE,t2.ACNORA_CP_ID ACTAACNORACPID,t2.ACNOMBRE_CP ACTAACNOMBRECP,t2.ACNORA_PORTAL_ID ACTAACNORAPORTALID,t2.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL,t2.ACNOMBRE_PISO ACTAACNOMBREPISO,t2.ACDIRECCION_NOCAPV ACTAACDIRECCIONNOCAPV,t2.ACAPE1CO ACTAACAPE1CO,t2.ACAPE2CO ACTAACAPE2CO,t2.ACCODEXPEDIENTEORIGEN ACTAACCODEXPEDIENTEORIGEN,t2.ACCOORORIGEN ACTAACCOORORIGEN, t3.ESNOMBRE ESNOMBRE, t4.ADCODIGO ADCODIGO, t4.ADCOAT ADCOAT, t4.ADCOOR ADCOOR, t4.ADCOTTD ADCOTTD, t4.ADFEDE ADFEDE, t4.ADFECODE ADFECODE ");
		query.append("FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3, ACTDEC t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actuacion, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) AND t1.ATCOES = t3.ESCODIGO (+) AND t1.ATCODIGO = t4.ADCOAT(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Actuacion actuacion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 ,ACTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actuacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAllActuacionEstablecimiento(Actuacion actuacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ATCOES= t2.ESCODIGO(+)");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ATCODIGO ATCODIGO " + "FROM ACTUACION t1 ,ESTABLECIMIENTO t2 ");

		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(actuacion.getEstablecimiento().getEscodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(), new RowMapper<Actuacion>() {
			public Actuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(resultSet.getString("ATCODIGO"));
				actuacion.setEstablecimiento(new Establecimiento());
				return actuacion;
			}
		}, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAtcodigo() != null) {
			where.append(" AND t1.ATCODIGO = ?");
			params.add(actuacion.getAtcodigo());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccodigo() != null) {
			where.append(" AND t2.ACCODIGO = ?");
			params.add(actuacion.getActa().getAccodigo());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoor() != null) {
			where.append(" AND t2.ACCOOR = ?");
			params.add(actuacion.getActa().getAccoor());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnror() != null) {
			where.append(" AND t2.ACNROR = ?");
			params.add(actuacion.getActa().getAcnror());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnran() != null) {
			where.append(" AND t2.ACNRAN = ?");
			params.add(actuacion.getActa().getAcnran());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoinun() != null) {
			where.append(" AND t2.ACCOINUN = ?");
			params.add(actuacion.getActa().getAccoinun());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoindo() != null) {
			where.append(" AND t2.ACCOINDO = ?");
			params.add(actuacion.getActa().getAccoindo());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcfele() != null) {
			where.append(" AND t2.ACFELE = ?");
			params.add(actuacion.getActa().getAcfele());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcfere() != null) {
			where.append(" AND t2.ACFERE = ?");
			params.add(actuacion.getActa().getAcfere());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoes() != null) {
			where.append(" AND t2.ACCOES = ?");
			params.add(actuacion.getActa().getAccoes());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoav() != null) {
			where.append(" AND t2.ACCOAV = ?");
			params.add(actuacion.getActa().getAccoav());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccose() != null) {
			where.append(" AND t2.ACCOSE = ?");
			params.add(actuacion.getActa().getAccose());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcfeex() != null) {
			where.append(" AND t2.ACFEEX = ?");
			params.add(actuacion.getActa().getAcfeex());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcinre() != null) {
			where.append(" AND t2.ACINRE = ?");
			params.add(actuacion.getActa().getAcinre());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoco() != null) {
			where.append(" AND t2.ACNOCO = ?");
			params.add(actuacion.getActa().getAcnoco());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcdnico() != null) {
			where.append(" AND t2.ACDNICO = ?");
			params.add(actuacion.getActa().getAcdnico());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoco() != null) {
			where.append(" AND t2.ACCOCO = ?");
			params.add(actuacion.getActa().getAccoco());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcdirco() != null) {
			where.append(" AND t2.ACDIRCO = ?");
			params.add(actuacion.getActa().getAcdirco());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoloco() != null) {
			where.append(" AND t2.ACCOLOCO = ?");
			params.add(actuacion.getActa().getAccoloco());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnrcpco() != null) {
			where.append(" AND t2.ACNRCPCO = ?");
			params.add(actuacion.getActa().getAcnrcpco());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnrtfco() != null) {
			where.append(" AND t2.ACNRTFCO = ?");
			params.add(actuacion.getActa().getAcnrtfco());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccotd() != null) {
			where.append(" AND t2.ACCOTD = ?");
			params.add(actuacion.getActa().getAccotd());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraPaisId() != null) {
			where.append(" AND t2.ACNORA_PAIS_ID = ?");
			params.add(actuacion.getActa().getAcnoraPaisId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND t2.ACNORA_PAIS_NOMBRE = ?");
			params.add(actuacion.getActa().getAcnoraPaisNombre());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND t2.ACNORA_PROVINCIA_ID = ?");
			params.add(actuacion.getActa().getAcnoraProvinciaId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreProvincia() != null) {
			where.append(" AND t2.ACNOMBRE_PROVINCIA = ?");
			params.add(actuacion.getActa().getAcnombreProvincia());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND t2.ACNORA_MUNICIPIO_ID = ?");
			params.add(actuacion.getActa().getAcnoraMunicipioId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND t2.ACNOMBRE_MUNICIPIO = ?");
			params.add(actuacion.getActa().getAcnombreMunicipio());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND t2.ACNORA_LOCALIDAD_ID = ?");
			params.add(actuacion.getActa().getAcnoraLocalidadId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND t2.ACNOMBRE_LOCALIDAD = ?");
			params.add(actuacion.getActa().getAcnombreLocalidad());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraCalleId() != null) {
			where.append(" AND t2.ACNORA_CALLE_ID = ?");
			params.add(actuacion.getActa().getAcnoraCalleId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreCalle() != null) {
			where.append(" AND t2.ACNOMBRE_CALLE = ?");
			params.add(actuacion.getActa().getAcnombreCalle());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraCpId() != null) {
			where.append(" AND t2.ACNORA_CP_ID = ?");
			params.add(actuacion.getActa().getAcnoraCpId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreCp() != null) {
			where.append(" AND t2.ACNOMBRE_CP = ?");
			params.add(actuacion.getActa().getAcnombreCp());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraPortalId() != null) {
			where.append(" AND t2.ACNORA_PORTAL_ID = ?");
			params.add(actuacion.getActa().getAcnoraPortalId());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombrePortal() != null) {
			where.append(" AND t2.ACNOMBRE_PORTAL = ?");
			params.add(actuacion.getActa().getAcnombrePortal());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombrePiso() != null) {
			where.append(" AND t2.ACNOMBRE_PISO = ?");
			params.add(actuacion.getActa().getAcnombrePiso());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcdireccionNocapv() != null) {
			where.append(" AND t2.ACDIRECCION_NOCAPV = ?");
			params.add(actuacion.getActa().getAcdireccionNocapv());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcape1co() != null) {
			where.append(" AND t2.ACAPE1CO = ?");
			params.add(actuacion.getActa().getAcape1co());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcape2co() != null) {
			where.append(" AND t2.ACAPE2CO = ?");
			params.add(actuacion.getActa().getAcape2co());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccodexpedienteorigen() != null) {
			where.append(" AND t2.ACCODEXPEDIENTEORIGEN = ?");
			params.add(actuacion.getActa().getAccodexpedienteorigen());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoororigen() != null) {
			where.append(" AND t2.ACCOORORIGEN = ?");
			params.add(actuacion.getActa().getAccoororigen());
		}
		if (actuacion != null && actuacion.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(actuacion.getAtnror());
		}
		if (actuacion != null && actuacion.getAtcotta() != null) {
			where.append(" AND t1.ATCOTTA = ?");
			params.add(actuacion.getAtcotta());
		}
		if (actuacion != null && actuacion.getAtcotma() != null) {
			where.append(" AND t1.ATCOTMA = ?");
			params.add(actuacion.getAtcotma());
		}
		if (actuacion != null && actuacion.getAtcoes() != null) {
			where.append(" AND t1.ATCOES = ?");
			params.add(actuacion.getAtcoes());
		}
		if (actuacion != null && actuacion.getAtcoav() != null) {
			where.append(" AND t1.ATCOAV = ?");
			params.add(actuacion.getAtcoav());
		}
		if (actuacion != null && actuacion.getAtcose() != null) {
			where.append(" AND t1.ATCOSE = ?");
			params.add(actuacion.getAtcose());
		}
		if (actuacion != null && actuacion.getAtcops() != null) {
			where.append(" AND t1.ATCOPS = ?");
			params.add(actuacion.getAtcops());
		}
		if (actuacion != null && actuacion.getAtnoprse() != null) {
			where.append(" AND t1.ATNOPRSE = ?");
			params.add(actuacion.getAtnoprse());
		}
		if (actuacion != null && actuacion.getAtnomaps() != null) {
			where.append(" AND t1.ATNOMAPS = ?");
			params.add(actuacion.getAtnomaps());
		}
		if (actuacion != null && actuacion.getAtnomops() != null) {
			where.append(" AND t1.ATNOMOPS = ?");
			params.add(actuacion.getAtnomops());
		}
		if (actuacion != null && actuacion.getAtnrlops() != null) {
			where.append(" AND t1.ATNRLOPS = ?");
			params.add(actuacion.getAtnrlops());
		}
		if (actuacion != null && actuacion.getAtfedumi() != null) {
			where.append(" AND t1.ATFEDUMI = ?");
			params.add(actuacion.getAtfedumi());
		}
		if (actuacion != null && actuacion.getAtinprse() != null) {
			where.append(" AND t1.ATINPRSE = ?");
			params.add(actuacion.getAtinprse());
		}
		if (actuacion != null && actuacion.getAtcaunep() != null) {
			where.append(" AND t1.ATCAUNEP = ?");
			params.add(actuacion.getAtcaunep());
		}
		if (actuacion != null && actuacion.getAtteinfo() != null) {
			where.append(" AND t1.ATTEINFO = ?");
			params.add(actuacion.getAtteinfo());
		}
		if (actuacion != null && actuacion.getAtcotp() != null) {
			where.append(" AND t1.ATCOTP = ?");
			params.add(actuacion.getAtcotp());
		}
		if (actuacion != null && actuacion.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(actuacion.getAtcocm());
		}
		if (actuacion != null && actuacion.getAtcohd() != null) {
			where.append(" AND t1.ATCOHD = ?");
			params.add(actuacion.getAtcohd());
		}
		if (actuacion != null && actuacion.getAtcoat() != null) {
			where.append(" AND t1.ATCOAT = ?");
			params.add(actuacion.getAtcoat());
		}
		if (actuacion != null && actuacion.getAtcoal() != null) {
			where.append(" AND t1.ATCOAL = ?");
			params.add(actuacion.getAtcoal());
		}
		if (actuacion != null && actuacion.getAtcodigobarras() != null) {
			where.append(" AND t1.ATCODIGOBARRAS = ?");
			params.add(actuacion.getAtcodigobarras());
		}
		if (actuacion != null && actuacion.getFcodigoactual() != null) {
			where.append(" AND t1.FCODIGOACTUAL = ?");
			params.add(actuacion.getFcodigoactual());
		}
		if (actuacion != null && actuacion.getTrcodigoactual() != null) {
			where.append(" AND t1.TRCODIGOACTUAL = ?");
			params.add(actuacion.getTrcodigoactual());
		}
		if (actuacion != null && actuacion.getTrposiblecodigo() != null) {
			where.append(" AND t1.TRPOSIBLECODIGO = ?");
			params.add(actuacion.getTrposiblecodigo());
		}
		if (actuacion != null && actuacion.getAtfechacierre() != null) {
			where.append(" AND t1.ATFECHACIERRE = ?");
			params.add(actuacion.getAtfechacierre());
		}
		if (actuacion != null && actuacion.getIskontsumobide() != null) {
			where.append(" AND t1.ISKONTSUMOBIDE = ?");
			params.add(actuacion.getIskontsumobide());
		}
		if (actuacion != null && actuacion.getAtidcomunicacionsoivre() != null) {
			where.append(" AND t1.ATIDCOMUNICACIONSOIVRE = ?");
			params.add(actuacion.getAtidcomunicacionsoivre());
		}
		if (actuacion != null && actuacion.getAtuexistentes() != null) {
			where.append(" AND t1.ATUEXISTENTES = ?");
			params.add(actuacion.getAtuexistentes());
		}
		if (actuacion != null && actuacion.getAtuinmovilizadas() != null) {
			where.append(" AND t1.ATUINMOVILIZADAS = ?");
			params.add(actuacion.getAtuinmovilizadas());
		}
		if (actuacion != null && actuacion.getAtudestruidas() != null) {
			where.append(" AND t1.ATUDESTRUIDAS = ?");
			params.add(actuacion.getAtudestruidas());
		}
		if (actuacion != null && actuacion.getAtudevolucionorigen() != null) {
			where.append(" AND t1.ATUDEVOLUCIONORIGEN = ?");
			params.add(actuacion.getAtudevolucionorigen());
		}
		if (actuacion != null && actuacion.getAtulibrecomercializacion() != null) {
			where.append(" AND t1.ATULIBRECOMERCIALIZACION = ?");
			params.add(actuacion.getAtulibrecomercializacion());
		}

		if (actuacion != null && actuacion.getAtcopg() != null) {
			where.append(" AND t1.ATCOPG = ?");
			params.add(actuacion.getAtcopg());
		}

		if (actuacion != null && actuacion.getAtcocr() != null) {
			where.append(" AND t1.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Actuacion actuacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAtcodigo() != null) {
			where.append(" AND UPPER(t1.ATCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCODIGO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccodigo() != null) {
			where.append(" AND t2.ACCODIGO = ?");
			params.add(actuacion.getActa().getAccodigo());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoor() != null) {
			where.append(" AND UPPER(t2.ACCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoor().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoor().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOOR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnror() != null) {
			where.append(" AND UPPER(t2.ACNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnror().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnror().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNROR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnran() != null) {
			where.append(" AND t2.ACNRAN = ?");
			params.add(actuacion.getActa().getAcnran());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoinun() != null) {
			where.append(" AND UPPER(t2.ACCOINUN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoinun().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoinun().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOINUN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoindo() != null) {
			where.append(" AND UPPER(t2.ACCOINDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoindo().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoindo().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOINDO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcfele() != null) {
			where.append(" AND t2.ACFELE = ?");
			params.add(actuacion.getActa().getAcfele());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcfere() != null) {
			where.append(" AND t2.ACFERE = ?");
			params.add(actuacion.getActa().getAcfere());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoes() != null) {
			where.append(" AND UPPER(t2.ACCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoes().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoes().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOES IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoav() != null) {
			where.append(" AND UPPER(t2.ACCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoav().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoav().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOAV IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccose() != null) {
			where.append(" AND UPPER(t2.ACCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccose().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccose().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcfeex() != null) {
			where.append(" AND t2.ACFEEX = ?");
			params.add(actuacion.getActa().getAcfeex());
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcinre() != null) {
			where.append(" AND UPPER(t2.ACINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcinre().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcinre().toUpperCase() + "%");
			}
			where.append(" AND t2.ACINRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoco() != null) {
			where.append(" AND UPPER(t2.ACNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoco().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcdnico() != null) {
			where.append(" AND UPPER(t2.ACDNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcdnico().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcdnico().toUpperCase() + "%");
			}
			where.append(" AND t2.ACDNICO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoco() != null) {
			where.append(" AND UPPER(t2.ACCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoco().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcdirco() != null) {
			where.append(" AND UPPER(t2.ACDIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcdirco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcdirco().toUpperCase() + "%");
			}
			where.append(" AND t2.ACDIRCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoloco() != null) {
			where.append(" AND UPPER(t2.ACCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoloco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoloco().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOLOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnrcpco() != null) {
			where.append(" AND UPPER(t2.ACNRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnrcpco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnrcpco().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNRCPCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnrtfco() != null) {
			where.append(" AND UPPER(t2.ACNRTFCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnrtfco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnrtfco().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNRTFCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccotd() != null) {
			where.append(" AND UPPER(t2.ACCOTD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccotd().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccotd().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOTD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraPaisId() != null) {
			where.append(" AND UPPER(t2.ACNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_PAIS_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND UPPER(t2.ACNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.ACNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreProvincia() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.ACNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.ACNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraCalleId() != null) {
			where.append(" AND UPPER(t2.ACNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_CALLE_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreCalle() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_CALLE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraCpId() != null) {
			where.append(" AND UPPER(t2.ACNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_CP_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombreCp() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_CP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnoraPortalId() != null) {
			where.append(" AND UPPER(t2.ACNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_PORTAL_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombrePortal() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_PORTAL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcnombrePiso() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_PISO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcdireccionNocapv() != null) {
			where.append(" AND UPPER(t2.ACDIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcdireccionNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcdireccionNocapv().toUpperCase() + "%");
			}
			where.append(" AND t2.ACDIRECCION_NOCAPV IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcape1co() != null) {
			where.append(" AND UPPER(t2.ACAPE1CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcape1co().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcape1co().toUpperCase() + "%");
			}
			where.append(" AND t2.ACAPE1CO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAcape2co() != null) {
			where.append(" AND UPPER(t2.ACAPE2CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcape2co().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcape2co().toUpperCase() + "%");
			}
			where.append(" AND t2.ACAPE2CO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccodexpedienteorigen() != null) {
			where.append(" AND UPPER(t2.ACCODEXPEDIENTEORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccodexpedienteorigen().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccodexpedienteorigen().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCODEXPEDIENTEORIGEN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null && actuacion.getActa().getAccoororigen() != null) {
			where.append(" AND UPPER(t2.ACCOORORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoororigen().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoororigen().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOORORIGEN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(actuacion.getAtnror());
		}
		if (actuacion != null && actuacion.getAtcotta() != null) {
			where.append(" AND UPPER(t1.ATCOTTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcotta().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcotta().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOTTA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcotma() != null) {
			where.append(" AND UPPER(t1.ATCOTMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcotma().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcotma().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOTMA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcoes() != null) {
			where.append(" AND UPPER(t1.ATCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcoes().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcoes().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOES IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcoav() != null) {
			where.append(" AND UPPER(t1.ATCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcoav().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcoav().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOAV IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcose() != null) {
			where.append(" AND UPPER(t1.ATCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcose().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcose().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcops() != null) {
			where.append(" AND UPPER(t1.ATCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcops().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcops().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnoprse() != null) {
			where.append(" AND UPPER(t1.ATNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnoprse().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnoprse().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNOPRSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnomaps() != null) {
			where.append(" AND UPPER(t1.ATNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnomaps().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNOMAPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnomops() != null) {
			where.append(" AND UPPER(t1.ATNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnomops().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnomops().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNOMOPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnrlops() != null) {
			where.append(" AND UPPER(t1.ATNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnrlops().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNRLOPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtfedumi() != null) {
			where.append(" AND t1.ATFEDUMI = ?");
			params.add(actuacion.getAtfedumi());
		}
		if (actuacion != null && actuacion.getAtinprse() != null) {
			where.append(" AND UPPER(t1.ATINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtinprse().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtinprse().toUpperCase() + "%");
			}
			where.append(" AND t1.ATINPRSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcaunep() != null) {
			where.append(" AND t1.ATCAUNEP = ?");
			params.add(actuacion.getAtcaunep());
		}
		if (actuacion != null && actuacion.getAtteinfo() != null) {
			where.append(" AND UPPER(t1.ATTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtteinfo().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtteinfo().toUpperCase() + "%");
			}
			where.append(" AND t1.ATTEINFO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcotp() != null) {
			where.append(" AND UPPER(t1.ATCOTP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcotp().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcotp().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOTP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcocm() != null) {
			where.append(" AND UPPER(t1.ATCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcocm().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcocm().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOCM IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcohd() != null) {
			where.append(" AND UPPER(t1.ATCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcohd().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcohd().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOHD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcoat() != null) {
			where.append(" AND UPPER(t1.ATCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcoat().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcoat().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOAT IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcoal() != null) {
			where.append(" AND UPPER(t1.ATCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcoal().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcoal().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOAL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcodigobarras() != null) {
			where.append(" AND UPPER(t1.ATCODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcodigobarras().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcodigobarras().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCODIGOBARRAS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getFcodigoactual() != null) {
			where.append(" AND UPPER(t1.FCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getFcodigoactual().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getFcodigoactual().toUpperCase() + "%");
			}
			where.append(" AND t1.FCODIGOACTUAL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTrcodigoactual() != null) {
			where.append(" AND UPPER(t1.TRCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTrcodigoactual().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getTrcodigoactual().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGOACTUAL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTrposiblecodigo() != null) {
			where.append(" AND UPPER(t1.TRPOSIBLECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTrposiblecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getTrposiblecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRPOSIBLECODIGO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtfechacierre() != null) {
			where.append(" AND t1.ATFECHACIERRE = ?");
			params.add(actuacion.getAtfechacierre());
		}
		if (actuacion != null && actuacion.getIskontsumobide() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMOBIDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getIskontsumobide().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getIskontsumobide().toUpperCase() + "%");
			}
			where.append(" AND t1.ISKONTSUMOBIDE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtidcomunicacionsoivre() != null) {
			where.append(" AND UPPER(t1.ATIDCOMUNICACIONSOIVRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtidcomunicacionsoivre().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtidcomunicacionsoivre().toUpperCase() + "%");
			}
			where.append(" AND t1.ATIDCOMUNICACIONSOIVRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtuexistentes() != null) {
			where.append(" AND t1.ATUEXISTENTES = ?");
			params.add(actuacion.getAtuexistentes());
		}
		if (actuacion != null && actuacion.getAtuinmovilizadas() != null) {
			where.append(" AND t1.ATUINMOVILIZADAS = ?");
			params.add(actuacion.getAtuinmovilizadas());
		}
		if (actuacion != null && actuacion.getAtudestruidas() != null) {
			where.append(" AND t1.ATUDESTRUIDAS = ?");
			params.add(actuacion.getAtudestruidas());
		}
		if (actuacion != null && actuacion.getAtudevolucionorigen() != null) {
			where.append(" AND t1.ATUDEVOLUCIONORIGEN = ?");
			params.add(actuacion.getAtudevolucionorigen());
		}
		if (actuacion != null && actuacion.getAtulibrecomercializacion() != null) {
			where.append(" AND t1.ATULIBRECOMERCIALIZACION = ?");
			params.add(actuacion.getAtulibrecomercializacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionesRealizadasCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 , ACTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereInspeccionesRealizadasMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereInspeccionesRealizadasMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAttipo() != null) {
			if (actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS)) {
				where.append(" AND t1.ATISTOMAMUESTRAS = ?");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)) {
				where.append(" AND t1.ATISCONTROLESTANDAR = ?");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS)) {
				where.append(" AND t1.ATISCONTROLOTROS = ?");
				params.add(Y41bConstantes.VALOR_SI);
			}
		}
		if (actuacion != null && actuacion.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(actuacion.getAtcocm());
		}
		if (actuacion != null && actuacion.getAtcopg() != null) {
			where.append(" AND t1.ATCOPG = ?");
			params.add(actuacion.getAtcopg());
		}
		if (actuacion != null && actuacion.getAtcocmrelacionada() != null) {
			where.append(" AND t1.ATCOCMRELACIONADA = ?");
			params.add(actuacion.getAtcocmrelacionada());
		}
		if (actuacion != null && actuacion.getAtcopgrelacionada() != null) {
			where.append(" AND t1.ATCOPGRELACIONADA = ?");
			params.add(actuacion.getAtcopgrelacionada());
		}
		if (actuacion != null && actuacion.getAtcoal() != null) {
			where.append(" AND (t1.ATCOAL = ?");
			params.add(actuacion.getAtcoal());
			where.append(" OR t1.ATCOALRELACIONADA = ?) ");
			params.add(actuacion.getAtcoal());
		}
		if (actuacion != null && actuacion.getAtcocr() != null) {
			where.append(" AND (t1.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
			where.append(" OR t1.ATCOCRRELACIONADA = ?) ");
			params.add(actuacion.getAtcocr());
		}

		// Solo para alertas (ya que existe un contador realizadas y en curso)
		if (actuacion != null && actuacion.getAtcoal() != null) {
			where.append(" AND t1.ATFEFIN IS NOT NULL ");
		}

		if (actuacion != null && actuacion.getAttodas() == null) {
			if (actuacion != null && actuacion.getAtadicional() != null) {
				where.append(" AND t1.ATADICIONAL = ?");
				params.add(actuacion.getAtadicional());
				where.append(" AND t1.ATFEFIN IS NOT NULL ");
			} else {
				where.append(" AND t1.ATADICIONAL IS NULL ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionesEnCursoCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 , ACTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereInspeccionesEnCursoMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionesPendientesCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 , ACTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereInspeccionesPendientesMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ATCOAC= t2.ACCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereInspeccionesPendientesMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAttipo() != null) {
			where.append(" AND t1.ATTIPO = ?");
			params.add(actuacion.getAttipo());
		}
		if (actuacion != null && actuacion.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(actuacion.getAtcocm());
		}
		if (actuacion != null && actuacion.getAtcopg() != null) {
			where.append(" AND t1.ATCOPG = ?");
			params.add(actuacion.getAtcopg());
		}
		if (actuacion != null && actuacion.getAtcoal() != null) {
			where.append(" AND (t1.ATCOAL = ?");
			params.add(actuacion.getAtcoal());
			where.append(" OR t1.ATCOALRELACIONADA = ?) ");
			params.add(actuacion.getAtcoal());
		}
		if (actuacion != null && actuacion.getAtcocr() != null) {
			where.append(" AND (t1.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
			where.append(" OR t1.ATCOCRRELACIONADA = ?) ");
			params.add(actuacion.getAtcocr());
		}

		where.append(" AND t1.ATFEFIN IS NULL ");

		if (actuacion != null && actuacion.getAttodas() == null) {
			if (actuacion != null && actuacion.getAtadicional() != null) {
				where.append(" AND t1.ATADICIONAL = ?");
				params.add(actuacion.getAtadicional());
			} else {
				where.append(" AND t1.ATADICIONAL IS NULL ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereInspeccionesEnCursoMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAttipo() != null) {
			where.append(" AND t1.ATTIPO = ?");
			params.add(actuacion.getAttipo());
		}
		if (actuacion != null && actuacion.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(actuacion.getAtcocm());
		}
		if (actuacion != null && actuacion.getAtcopg() != null) {
			where.append(" AND t1.ATCOPG = ?");
			params.add(actuacion.getAtcopg());
		}
		if (actuacion != null && actuacion.getAtcoal() != null) {
			where.append(" AND (t1.ATCOAL = ?");
			params.add(actuacion.getAtcoal());
			where.append(" OR t1.ATCOALRELACIONADA = ?) ");
			params.add(actuacion.getAtcoal());
		}
		if (actuacion != null && actuacion.getAtcocr() != null) {
			where.append(" AND (t1.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
			where.append(" OR t1.ATCOCRRELACIONADA = ?) ");
			params.add(actuacion.getAtcocr());
		}

		where.append(" AND t1.ATENPLATEA = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		where.append(" AND t1.ATFEFIN IS NULL ");

		if (actuacion != null && actuacion.getAttodas() == null) {
			if (actuacion != null && actuacion.getAtadicional() != null) {
				where.append(" AND t1.ATADICIONAL = ?");
				params.add(actuacion.getAtadicional());
			} else {
				where.append(" AND t1.ATADICIONAL IS NULL ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionesRealizadasResultadoCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereInspeccionesRealizadasResultadoMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereInspeccionesRealizadasResultadoMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(actuacion.getAtcocm());
		}

		where.append(" AND t1.ATFEFIN IS NOT NULL ");

		// Las positivas deben ser las que tienen infraccin
		// Las negativas son en las que no hay infraccin
		if (actuacion != null && actuacion.getAtpositivas() != null
				&& actuacion.getAtpositivas().equals(Y41bConstantes.VALOR_NO)) {
			where.append(" AND (SELECT COUNT(1) FROM ACTA_INFRACCION tt1 WHERE tt1.AICOAT=t1.ATCODIGO)=0 ");
		} else if (actuacion != null && actuacion.getAtpositivas() != null
				&& actuacion.getAtpositivas().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND (SELECT COUNT(1) FROM ACTA_INFRACCION tt1 WHERE tt1.AICOAT=t1.ATCODIGO)>0 ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionesAbiertasPlateaCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTUACION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereInspeccionesAbiertasPlateaMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereInspeccionesAbiertasPlateaMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getAtcopg() != null) {
			where.append(" AND t1.ATCOPG = ?");
			params.add(actuacion.getAtcopg());
		}

		if (actuacion != null && actuacion.getAtcocr() != null) {
			where.append(" AND t1.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
		}

		if (actuacion != null && actuacion.getAtidcomunicacionsoivre() != null) {
			where.append(" AND t1.ATIDCOMUNICACIONSOIVRE = ?");
			params.add(actuacion.getAtidcomunicacionsoivre());
		}

		where.append(" AND t1.ATENPLATEA IS NOT NULL ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion findNumProductosActuacion(Actuacion actuacion) {
		StringBuilder query = new StringBuilder(
				"SELECT NVL(SUM(t1.ATUINMOVILIZADAS),0) ATUINMOVILIZADAS,NVL(SUM(t1.ATUDESTRUIDAS),0) ATUDESTRUIDAS,NVL(SUM(t1.ATUDEVOLUCIONORIGEN),0) ATUDEVOLUCIONORIGEN,NVL(SUM(t1.ATULIBRECOMERCIALIZACION),0) ATULIBRECOMERCIALIZACION,NVL(SUM(t1.ATUOTROS),0) ATUOTROS,NVL(SUM(t1.ATUTOMAMUESTRAS),0) ATUTOMAMUESTRAS,NVL(SUM(t1.ATURECUPERADAS),0) ATURECUPERADAS, NVL(SUM(t1.ATUPENDIENTES),0) ATUPENDIENTES FROM ACTUACION t1  WHERE 1=1 AND (t1.ATCOAL = ? OR t1.ATCOALRELACIONADA = ?) AND t1.ATADICIONAL IS NULL ");

		List<Object> params = new ArrayList<Object>();

		params.add(actuacion.getAtcoal());
		params.add(actuacion.getAtcoal());

		if (actuacion != null && actuacion.getAtcocr() != null) {
			query.append(" AND (t1.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
			query.append(" OR t1.ATCOCRRELACIONADA = ?) ");
			params.add(actuacion.getAtcocr());
		}

		List<Actuacion> actuacionList = this.jdbcTemplate.query(query.toString(), new RowMapper<Actuacion>() {
			public Actuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Actuacion(resultSet.getBigDecimal("ATUINMOVILIZADAS"),
						resultSet.getBigDecimal("ATUDESTRUIDAS"), resultSet.getBigDecimal("ATUDEVOLUCIONORIGEN"),
						resultSet.getBigDecimal("ATULIBRECOMERCIALIZACION"), resultSet.getBigDecimal("ATUOTROS"),
						resultSet.getBigDecimal("ATUTOMAMUESTRAS"), resultSet.getBigDecimal("ATURECUPERADAS"),
						resultSet.getBigDecimal("ATUPENDIENTES"));
			}
		}, params.toArray());
		return (Actuacion) DataAccessUtils.uniqueResult(actuacionList);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateUltimoTramiteGenerico(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET TRCODIGOACTUAL=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getTrcodigoactual(), actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateUltimoTramiteConFase(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET FCODIGOACTUAL=?,TRCODIGOACTUAL=?,TRPOSIBLECODIGO=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getFcodigoactual(), actuacion.getTrcodigoactual(),
				actuacion.getTrposiblecodigo(), actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateUltimoTramiteConFaseGenerico(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET FCODIGOACTUAL=?,TRCODIGOACTUAL=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getFcodigoactual(), actuacion.getTrcodigoactual(),
				actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion findOrigenInspeccionPorIdTramite(TramiteInspeccion tramiteInspeccion) {

		StringBuilder query = new StringBuilder(
				"SELECT t2.ATCODIGO ATCODIGO, t2.ATCOCM ATCOCM, t2.ATCOAL ATCOAL, t3.ALNROR || '-' || t3.ALNRAN ATALERTA, t2.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t7.V6CODIGO V6CODIGO, t4.HDTIPODENUNCIANTE, t5.DECOOR  || '-' || t5.DENROR  || '-' || t5.DENRAN  || '-' || t4.HDNROR ATSOLICITUD, t6.ACTIORORIGEN ACTIORORIGEN ");
		query.append(
				"FROM TRAMITE_INSPECCION t1, ACTUACION t2, ALERTA t3, HECHO_DENUNCIADO t4, DENUNCIA t5, ACTA t6, COMUNICACION_SOIVRE t7 ");
		query.append(
				"WHERE t1.TIATCODIGO = t2.ATCODIGO AND t2.ATCOAL = t3.ALCODIGO(+) AND t6.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOHD = t4.HDCODIGO(+) AND t4.HDCODE = t5.DECODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t7.IDCOMUNICACIONSOIVRE(+) AND t1.TICODIGO = ?");

		return this.jdbcTemplate.queryForObject(query.toString(), new RowMapper<Actuacion>() {
			public Actuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				Actuacion actuacion = new Actuacion();

				actuacion.setAtcodigo(resultSet.getString("ATCODIGO"));
				actuacion.setAtcocm(resultSet.getString("ATCOCM"));

				actuacion.setAtcoal(resultSet.getString("ATCOAL"));

				String atAlerta = resultSet.getString("ATALERTA");
				if (!"".equals(atAlerta.replaceAll("-", ""))) {
					actuacion.setAtalerta(atAlerta);
				}

				actuacion.setV6codigo(resultSet.getString("V6CODIGO"));

				actuacion.setAtidcomunicacionsoivre(resultSet.getString("ATIDCOMUNICACIONSOIVRE"));

				String atSolicitud = resultSet.getString("ATSOLICITUD");
				if (!"".equals(atSolicitud.replaceAll("-", ""))) {
					actuacion.setAtsolicitud(atSolicitud);
				}
				actuacion.setAthdtipodenunciante(resultSet.getString("HDTIPODENUNCIANTE"));

				Acta acta = new Acta();
				acta.setActiororigen(resultSet.getString("ACTIORORIGEN"));

				actuacion.setActa(acta);

				return actuacion;
			}
		}, tramiteInspeccion.getTicodigo());
	}

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion findOrigenInspeccionPorIdExpediente(TramiteInspeccion tramiteInspeccion) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ATCODIGO ATCODIGO, t1.ATCOCM ATCOCM, t1.ATCOAL ATCOAL, t2.ALNROR || '-' || t2.ALNRAN ATALERTA, t1.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t5.V6CODIGO V6CODIGO, t1.ATCOHD ATCOHD, t3.HDTIPODENUNCIANTE, t4.DECOOR  || '-' || t4.DENROR  || '-' || t4.DENRAN  || '-' || t3.HDNROR ATSOLICITUD, t6.ACTIORORIGEN ACTIORORIGEN ");
		query.append(
				"FROM ACTUACION t1, ALERTA t2, HECHO_DENUNCIADO t3, DENUNCIA t4, COMUNICACION_SOIVRE t5, ACTA t6 ");
		query.append(
				"WHERE t6.ACCODIGO = t1.ATCOAC(+) AND t1.ATCOAL = t2.ALCODIGO(+) AND t1.ATCOHD = t3.HDCODIGO(+) AND t3.HDCODE = t4.DECODIGO(+) AND t1.ATIDCOMUNICACIONSOIVRE = t5.IDCOMUNICACIONSOIVRE(+) AND t1.ATCODIGO = ?");

		return this.jdbcTemplate.queryForObject(query.toString(), new RowMapper<Actuacion>() {
			public Actuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				Actuacion actuacion = new Actuacion();

				actuacion.setAtcodigo(resultSet.getString("ATCODIGO"));
				actuacion.setAtcocm(resultSet.getString("ATCOCM"));

				actuacion.setAtcoal(resultSet.getString("ATCOAL"));

				String atAlerta = resultSet.getString("ATALERTA");
				if (!"".equals(atAlerta.replaceAll("-", ""))) {
					actuacion.setAtalerta(atAlerta);
				}

				actuacion.setV6codigo(resultSet.getString("V6CODIGO"));

				actuacion.setAtidcomunicacionsoivre(resultSet.getString("ATIDCOMUNICACIONSOIVRE"));

				String atSolicitud = resultSet.getString("ATSOLICITUD");
				if (!"".equals(atSolicitud.replaceAll("-", ""))) {
					actuacion.setAtsolicitud(atSolicitud);
				}

				actuacion.setAthdtipodenunciante(resultSet.getString("HDTIPODENUNCIANTE"));

				Acta acta = new Acta();
				acta.setActiororigen(resultSet.getString("ACTIORORIGEN"));

				actuacion.setActa(acta);

				return actuacion;
			}
		}, tramiteInspeccion.getTiatcodigo());
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateTramiteCambioInstructor(Actuacion actuacion) {
		String query = "UPDATE ACTA SET ACCOMO = ? WHERE ACCODIGO = (SELECT ATCOAC FROM ACTUACION WHERE ATCODIGO = ?)";

		this.jdbcTemplate.update(query, actuacion.getActa().getAccomo(), actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FiltroInspeccion> findAllInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1   AND t4.ATCOAC = t1.ACCODIGO AND t1.ACCOMO = t8.MOCODIGO(+) AND t4.ATCODIGO = t9.ADCOAT ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.ACCOOR ACCOOR, t1.ACNRAN ACNRAN, t1.ACNROR ACNROR, t1.ACFERE ACFERE,t4.ATNROR ATNROR, t4.ATCODIGO ATCODIGO,  t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t4.ATFECHACIERRE ATFECHACIERRE "
						+ "FROM ACTA t1, ACTUACION t4, CENSO_MONITOR t8, ACTDEC t9 ");

		where.append(" and t4.ATCODIGO <> '").append(atcodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t4.ATCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}

		// organismo
		if (filtroInspeccion != null && filtroInspeccion.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			params.add("%" + filtroInspeccion.getAccoor().toUpperCase() + "%");
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}

		// anyo
		if (filtroInspeccion != null && filtroInspeccion.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ? ");
			params.add(filtroInspeccion.getAcnran());
		}

		// correlativo
		if (filtroInspeccion != null && filtroInspeccion.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ? ");
			params.add(filtroInspeccion.getAcnror());
		}
		// fecha presentacion desde
		if (filtroInspeccion != null && filtroInspeccion.getAcfereDesde() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(filtroInspeccion.getAcfereDesde());
		}
		// fecha presentacion hasta
		if (filtroInspeccion != null && filtroInspeccion.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(filtroInspeccion.getAcfereHasta());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<FiltroInspeccion>) this.jdbcTemplate.query(query.toString(), new RowMapper<FiltroInspeccion>() {
			public FiltroInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new FiltroInspeccion(resultSet.getString("ATCODIGO"), resultSet.getString("ACCOOR"),
						resultSet.getBigDecimal("ACNRAN"), resultSet.getString("ACNROR"),
						resultSet.getBigDecimal("ATNROR"), resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("ACFERE"),
						resultSet.getDate("ATFECHACIERRE"));
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1   AND t4.ATCOAC = t1.ACCODIGO AND t1.ACCOMO = t8.MOCODIGO(+) AND t4.ATCODIGO = t9.ADCOAT ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.ATCODIGO) FROM ACTA t1, ACTUACION t4, CENSO_MONITOR t8, ACTDEC t9 ");

		where.append(" and t4.ATCODIGO <> '").append(atcodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t4.ATCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		// organismo
		if (filtroInspeccion != null && filtroInspeccion.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			params.add("%" + filtroInspeccion.getAccoor().toUpperCase() + "%");
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}

		// anyo
		if (filtroInspeccion != null && filtroInspeccion.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ? ");
			params.add(filtroInspeccion.getAcnran());
		}

		// correlativo
		if (filtroInspeccion != null && filtroInspeccion.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ? ");
			params.add(filtroInspeccion.getAcnror());
		}
		// fecha presentacion desde
		if (filtroInspeccion != null && filtroInspeccion.getAcfereDesde() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(filtroInspeccion.getAcfereDesde());
		}
		// fecha presentacion hasta
		if (filtroInspeccion != null && filtroInspeccion.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(filtroInspeccion.getAcfereHasta());
		}

		// // Decision
		// if (filtroInspeccion != null
		// && filtroInspeccion.getDecodigo() != null) {
		// where.append(" AND t9.HCCOTTD = ? ");
		// params.add(filtroInspeccion.getDecodigo());
		// }

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con las posibles inspecciones a relacionar con una
	 * sanción.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FiltroInspeccion> findAllInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion,
			String atcodigo, String relacionados, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1   AND t4.ATCOAC = t1.ACCODIGO AND t1.ACCOMO = t8.MOCODIGO(+) AND t4.ATCODIGO = t9.ADCOAT ");

		StringBuffer query = new StringBuffer(
				"SELECT distinct t1.ACCOOR ACCOOR, t1.ACNRAN ACNRAN, t1.ACNROR ACNROR, t1.ACFERE ACFERE, t4.ATNROR ATNROR, t4.ATCODIGO ATCODIGO,  t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t4.ATFECHACIERRE "
						+ "FROM ACTA t1, ACTUACION t4, CENSO_MONITOR t8, ACTDEC t9 ");

		where.append(" and t4.ATCODIGO <> ? ");
		params.add(atcodigo);
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append(" AND t4.ATCODIGO <> ? ");
				params.add(arrayValores[i]);
			}
		}

		// organismo
		if (filtroInspeccion != null && filtroInspeccion.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			params.add("%" + filtroInspeccion.getAccoor().toUpperCase() + "%");
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}

		// anyo
		if (filtroInspeccion != null && filtroInspeccion.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ? ");
			params.add(filtroInspeccion.getAcnran());
		}

		// correlativo
		if (filtroInspeccion != null && filtroInspeccion.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ? ");
			params.add(filtroInspeccion.getAcnror());
		}
		// fecha presentacion desde
		if (filtroInspeccion != null && filtroInspeccion.getAcfereDesde() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(filtroInspeccion.getAcfereDesde());
		}
		// fecha presentacion hasta
		if (filtroInspeccion != null && filtroInspeccion.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(filtroInspeccion.getAcfereHasta());
		}
		// NIF Sancionado para acumulacion desde la ficha del sancionador
		if (filtroInspeccion != null && !Y41bUtils.esNullOCadenaVacia(filtroInspeccion.getEsnif())) {
			// 0170995: Acumulacin de expedientes en SAncionador
			// comentamos la siguiente linea y hacemos que busque en
			// intervinientes cualquiera de los dos tipos
			// where.append(" AND t3.ESNIF = ?");
			where.append(
					" AND t4.ATCODIGO IN (SELECT HDCODIGO FROM INTERVINIENTES WHERE NIF = ? AND TIPO_INTERVINIENTE IN (?,?))");
			params.add(filtroInspeccion.getEsnif());
			params.add(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);
			params.add(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);
			// 0170995: Acumulacin de expedientes en SAncionador

		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<FiltroInspeccion>) this.jdbcTemplate.query(query.toString(), new RowMapper<FiltroInspeccion>() {
			public FiltroInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new FiltroInspeccion(resultSet.getString("ATCODIGO"), resultSet.getString("ACCOOR"),
						resultSet.getBigDecimal("ACNRAN"), resultSet.getString("ACNROR"),
						resultSet.getBigDecimal("ATNROR"), resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("ACFERE"),
						resultSet.getDate("ATFECHACIERRE"));
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1   AND t4.ATCOAC = t1.ACCODIGO AND t1.ACCOMO = t8.MOCODIGO(+) AND t4.ATCODIGO = t9.ADCOAT ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t4.ATCODIGO) FROM ACTA t1, ACTUACION t4, CENSO_MONITOR t8, ACTDEC t9 ");

		where.append(" and t4.ATCODIGO <> ? ");
		params.add(atcodigo);
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append(" AND t4.ATCODIGO <> ? ");
				params.add(arrayValores[i]);
			}
		}

		// organismo
		if (filtroInspeccion != null && filtroInspeccion.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			params.add("%" + filtroInspeccion.getAccoor().toUpperCase() + "%");
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}

		// anyo
		if (filtroInspeccion != null && filtroInspeccion.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ? ");
			params.add(filtroInspeccion.getAcnran());
		}

		// correlativo
		if (filtroInspeccion != null && filtroInspeccion.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ? ");
			params.add(filtroInspeccion.getAcnror());
		}
		// fecha presentacion desde
		if (filtroInspeccion != null && filtroInspeccion.getAcfereDesde() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(filtroInspeccion.getAcfereDesde());
		}
		// fecha presentacion hasta
		if (filtroInspeccion != null && filtroInspeccion.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(filtroInspeccion.getAcfereHasta());
		}
		// NIF Sancionado para acumulacion desde la ficha del sancionador
		if (filtroInspeccion != null && !Y41bUtils.esNullOCadenaVacia(filtroInspeccion.getEsnif())) {
			// 0170995: Acumulacin de expedientes en SAncionador
			// comentamos la siguiente linea y hacemos que busque en
			// intervinientes cualquiera de los dos tipos
			// where.append(" AND t3.ESNIF = ?");
			where.append(
					" AND t4.ATCODIGO IN (SELECT HDCODIGO FROM INTERVINIENTES WHERE NIF = ? AND TIPO_INTERVINIENTE IN (?,?))");
			params.add(filtroInspeccion.getEsnif());
			params.add(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);
			params.add(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);
			// 0170995: Acumulacin de expedientes en SAncionador

		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateFechaFin(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATFEFIN=? WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtfefin(), actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion marcarInspeccionParaTablet(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATATABLET='S' WHERE ATCODIGO=?";

		this.jdbcTemplate.update(query, actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
