package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.FiltroInspeccion;
import com.ejie.y41b.model.InspeccionEnvios;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.ProductosCampanhaActuacion;
import com.ejie.y41b.model.TramiteInspeccion;

/**
 * ActuacionDao  
 * 
 *  
 */

public interface ActuacionDao {

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInspeccionEnviosCount(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InspeccionEnvios> findAllSolicitudEnvios(Actuacion actuacion, Pagination pagination);

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion add(Actuacion actuacion);

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion addMasiva(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion update(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateFechaProtocolo(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateIsTOMAMUESTRAS(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateEnPLATEA(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateATPARTICIPACIONRESPONSABLE(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateIsCONTROLESTANDAR(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateIsCONTROLOTROS(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateRelacionConAlerta(Actuacion actuacion);

	/**
	 * Update a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateRelacionConCampana(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateFechaCierre(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateFechaCierreReabrirExpediente(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion updateUltimoTramiteConFaseGenerico(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateATIDPARTICIPACIONVISITADO(Intervinientes intervinientes);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateATIDPARTICIPACIONRESPONSABLE(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion find(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion findByActa(Actuacion actuacion);

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	void remove(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAll(Actuacion actuacion, Pagination pagination);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	Actuacion updateEstablecimiento(Actuacion actuacion);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllCount(Actuacion actuacion);

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Actuacion> findAllLike(Actuacion actuacion, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAllActuacionEstablecimiento(Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Actuacion actuacion, Boolean startsWith);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllInspeccionesRealizadasCount(Actuacion actuacion);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllInspeccionesEnCursoCount(Actuacion actuacion);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllInspeccionesPendientesCount(Actuacion actuacion);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllInspeccionesRealizadasResultadoCount(Actuacion actuacion);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllInspeccionesAbiertasPlateaCount(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion findNumProductosActuacion(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ProductosCampanhaActuacion> findAllProductosCampanha(Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllProductosCampanhaCount(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion updateUltimoTramiteGenerico(Actuacion actuacion);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion updateUltimoTramiteConFase(Actuacion actuacion);

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	Actuacion findOrigenInspeccionPorIdTramite(TramiteInspeccion tramiteInspeccion);

	/**
	 * Extrae el origen de una inspeccion segun su id de expediente.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	Actuacion findOrigenInspeccionPorIdExpediente(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	Actuacion updateTramiteCambioInstructor(Actuacion actuacion);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FiltroInspeccion> findAllInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados, Pagination pagination);

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados);

	/**
	 * Devuelve una lista con las posibles inspecciones a relacionar con una
	 * sanción.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FiltroInspeccion> findAllInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion,
			String atcodigo, String relacionados, Pagination pagination);

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateFechaFin(Actuacion actuacion);

	/**
	 * Updates a single row in the InspeccionDetalle table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion marcarInspeccionParaTablet(Actuacion actuacion);

}
