package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actdec;

/**
 * ActdecDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ActdecDaoImpl implements ActdecDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Actdec> rwMap = new RowMapper<Actdec>() {
		public Actdec mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Actdec(resultSet.getString("ADCODIGO"),
					resultSet.getString("ADCOAT"),
					resultSet.getString("ADCOOR"),
					resultSet.getString("ADCOTTD"),
					resultSet.getDate("ADFEDE"), resultSet.getDate("ADFECODE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	public Actdec add(Actdec actdec) {
		String query = "INSERT INTO ACTDEC (ADCODIGO, ADCOAT, ADCOOR, ADCOTTD, ADFEDE, ADFECODE) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, actdec.getAdcodigo(),
				actdec.getAdcoat(), actdec.getAdcoor(), actdec.getAdcottd(),
				actdec.getAdfede(), actdec.getAdfecode());
		return actdec;
	}

	/**
	 * Updates a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	public Actdec update(Actdec actdec) {
		String query = "UPDATE ACTDEC SET ADCOAT=?, ADCOOR=?, ADCOTTD=?, ADFEDE=?, ADFECODE=? WHERE ADCODIGO=?";
		this.jdbcTemplate.update(query, actdec.getAdcoat(), actdec.getAdcoor(),
				actdec.getAdcottd(), actdec.getAdfede(), actdec.getAdfecode(),
				actdec.getAdcodigo());
		return actdec;
	}

	/**
	 * Updates a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	public Actdec updateDecision(Actdec actdec) {
		String query = "UPDATE ACTDEC SET ADCOTTD=?, ADFEDE=? WHERE ADCODIGO=?";
		this.jdbcTemplate.update(query, actdec.getAdcottd(),
				actdec.getAdfede(), actdec.getAdcodigo());
		return actdec;
	}

	/**
	 * Updates a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	public Actdec updateOrganismoTraslado(Actdec actdec) {
		String query = "UPDATE ACTDEC SET ADCOOR=? WHERE ADCODIGO=?";
		this.jdbcTemplate.update(query, actdec.getAdcoor(),
				actdec.getAdcodigo());
		return actdec;
	}

	/**
	 * Finds a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	@Transactional(readOnly = true)
	public Actdec find(Actdec actdec) {
		String query = "SELECT t1.ADCODIGO ADCODIGO, t1.ADCOAT ADCOAT, t1.ADCOOR ADCOOR, t1.ADCOTTD ADCOTTD, t1.ADFEDE ADFEDE, t1.ADFECODE ADFECODE FROM ACTDEC t1  WHERE t1.ADCODIGO = ?  ";

		List<Actdec> actdecList = this.jdbcTemplate.query(query, this.rwMap,
				actdec.getAdcodigo());
		return (Actdec) DataAccessUtils.uniqueResult(actdecList);
	}

	/**
	 * Finds a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	@Transactional(readOnly = true)
	public Actdec findDecisionInspeccion(Actdec actdec) {
		String query = "SELECT t1.ADCODIGO ADCODIGO, t1.ADCOAT ADCOAT, t1.ADCOOR ADCOOR, t1.ADCOTTD ADCOTTD, t1.ADFEDE ADFEDE, t1.ADFECODE ADFECODE FROM ACTDEC t1  WHERE t1.ADCOAT = ?  ";

		List<Actdec> actdecList = this.jdbcTemplate.query(query, this.rwMap,
				actdec.getAdcoat());
		return (Actdec) DataAccessUtils.uniqueResult(actdecList);
	}

	/**
	 * Removes a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return
	 */
	public void remove(Actdec actdec) {
		String query = "DELETE FROM ACTDEC WHERE ADCODIGO=?";
		this.jdbcTemplate.update(query, actdec.getAdcodigo());
	}

	/**
	 * Removes all decision of the Inspeccion.
	 * 
	 * @param actdec
	 *            Actdec
	 */
	public void removeDecisionInspeccion(Actdec actdec) {
		String query = "DELETE  FROM ACTDEC WHERE ADCOAT=?";
		this.jdbcTemplate.update(query, actdec.getAdcoat());
	}

	/**
	 * Finds a List of rows in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actdec> findAll(Actdec actdec, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADCODIGO ADCODIGO,t1.ADCOAT ADCOAT,t1.ADCOOR ADCOOR,t1.ADCOTTD ADCOTTD,t1.ADFEDE ADFEDE,t1.ADFECODE ADFECODE ");
		query.append("FROM ACTDEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actdec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actdec>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Actdec actdec) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTDEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actdec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Actdec table using like.
	 * 
	 * @param actdec
	 *            Actdec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actdec> findAllLike(Actdec actdec, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADCODIGO ADCODIGO,t1.ADCOAT ADCOAT,t1.ADCOOR ADCOOR,t1.ADCOTTD ADCOTTD,t1.ADFEDE ADFEDE,t1.ADFECODE ADFECODE ");
		query.append("FROM ACTDEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actdec, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actdec>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actdec table using like.
	 * 
	 * @param actdec
	 *            Actdec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Actdec actdec, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTDEC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actdec, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actdec entity
	 * 
	 * @param actdec
	 *            Actdec Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Actdec actdec) {

		StringBuilder where = new StringBuilder(
				ActdecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actdec != null && actdec.getAdcodigo() != null) {
			where.append(" AND t1.ADCODIGO = ?");
			params.add(actdec.getAdcodigo());
		}
		if (actdec != null && actdec.getAdcoat() != null) {
			where.append(" AND t1.ADCOAT = ?");
			params.add(actdec.getAdcoat());
		}
		if (actdec != null && actdec.getAdcoor() != null) {
			where.append(" AND t1.ADCOOR = ?");
			params.add(actdec.getAdcoor());
		}
		if (actdec != null && actdec.getAdcottd() != null) {
			where.append(" AND t1.ADCOTTD = ?");
			params.add(actdec.getAdcottd());
		}
		if (actdec != null && actdec.getAdfede() != null) {
			where.append(" AND t1.ADFEDE = ?");
			params.add(actdec.getAdfede());
		}
		if (actdec != null && actdec.getAdfecode() != null) {
			where.append(" AND t1.ADFECODE = ?");
			params.add(actdec.getAdfecode());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actdec entity
	 * 
	 * @param actdec
	 *            Actdec Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Actdec actdec, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ActdecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actdec != null && actdec.getAdcodigo() != null) {
			where.append(" AND UPPER(t1.ADCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actdec.getAdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actdec.getAdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ADCODIGO IS NOT NULL");
		}
		if (actdec != null && actdec.getAdcoat() != null) {
			where.append(" AND UPPER(t1.ADCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actdec.getAdcoat().toUpperCase() + "%");
			} else {
				params.add("%" + actdec.getAdcoat().toUpperCase() + "%");
			}
			where.append(" AND t1.ADCOAT IS NOT NULL");
		}
		if (actdec != null && actdec.getAdcoor() != null) {
			where.append(" AND UPPER(t1.ADCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actdec.getAdcoor().toUpperCase() + "%");
			} else {
				params.add("%" + actdec.getAdcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ADCOOR IS NOT NULL");
		}
		if (actdec != null && actdec.getAdcottd() != null) {
			where.append(" AND UPPER(t1.ADCOTTD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actdec.getAdcottd().toUpperCase() + "%");
			} else {
				params.add("%" + actdec.getAdcottd().toUpperCase() + "%");
			}
			where.append(" AND t1.ADCOTTD IS NOT NULL");
		}
		if (actdec != null && actdec.getAdfede() != null) {
			where.append(" AND t1.ADFEDE = ?");
			params.add(actdec.getAdfede());
		}
		if (actdec != null && actdec.getAdfecode() != null) {
			where.append(" AND t1.ADFECODE = ?");
			params.add(actdec.getAdfecode());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
