package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actdec;

/**
 * ActdecDao  
 * 
 *  
 */

public interface ActdecDao {

	/**
	 * Inserts a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	Actdec add(Actdec actdec);

	/**
	 * Updates a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	Actdec update(Actdec actdec);

	/**
	 * Updates a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	public Actdec updateDecision(Actdec actdec);

	/**
	 * Updates a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	public Actdec updateOrganismoTraslado(Actdec actdec);

	/**
	 * Finds a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	Actdec find(Actdec actdec);

	/**
	 * Finds a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Pagination
	 * @return Actdec
	 */
	public Actdec findDecisionInspeccion(Actdec actdec);

	/**
	 * Deletes a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return
	 */
	void remove(Actdec actdec);

	/**
	 * Removes all decision of the Inspeccion.
	 * 
	 * @param actdec
	 *            Actdec
	 */
	public void removeDecisionInspeccion(Actdec actdec);

	/**
	 * Finds a List of rows in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actdec> findAll(Actdec actdec, Pagination pagination);

	/**
	 * Counts rows in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Long
	 */
	Long findAllCount(Actdec actdec);

	/**
	 * Finds rows in the Actdec table using like.
	 * 
	 * @param actdec
	 *            Actdec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Actdec> findAllLike(Actdec actdec, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Actdec table using like.
	 * 
	 * @param actdec
	 *            Actdec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Actdec actdec, Boolean startsWith);
}
