package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.ActaNueva;

/**
 * ActaNuevaDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ActaNuevaDaoImpl implements ActaNuevaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ActaNueva> rwMap = new RowMapper<ActaNueva>() {
		public ActaNueva mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ActaNueva(resultSet.getString("ANCODIGO"), resultSet.getString("ANCODINS"),
					resultSet.getString("ANCODAC"), resultSet.getDate("ANFECHA"), resultSet.getString("ANHORAINI"),
					resultSet.getString("ANHORAFIN"), resultSet.getString("ANESTADO"), resultSet.getString("ANTIPO"),
					resultSet.getString("ANDNICO"), resultSet.getString("ANNOMBRECO"),
					resultSet.getString("ANNORACPID"), resultSet.getString("ANNOMBRECP"),
					resultSet.getString("ANNORAPROVINCIAID"), resultSet.getString("ANNOMBREPROVINCIA"),
					resultSet.getString("ANNORAMUNICIPIOID"), resultSet.getString("ANNOMBREMUNICIPIO"),
					resultSet.getString("ANNORALOCALIDADID"), resultSet.getString("ANNOMBRELOCALIDAD"),
					resultSet.getString("ANNORACALLEID"), resultSet.getString("ANNOMBRECALLE"),
					resultSet.getString("ANNORAPORTALID"), resultSet.getString("ANNOMBREPORTAL"),
					resultSet.getString("ANNOMBREPISO"), resultSet.getString("ANTELEFONOCO"),
					resultSet.getString("ANCONDICIONCO"), resultSet.getString("ANREQRESUMEN"),
					resultSet.getString("ANINFRESUMEN"), resultSet.getString("ANINFPROPUESTA"),
					resultSet.getLong("ANANIOMU"), resultSet.getLong("ANNUMEROMU"),
					resultSet.getString("ANESPEFIFICMU"), resultSet.getString("ANCODCARACTERMU"),
					resultSet.getString("ANCODUNIDADESMU"), resultSet.getBigDecimal("ANUNIDADESOTROSMU"),
					resultSet.getBigDecimal("ANEJEMPLARESUNIDADMU"), resultSet.getBigDecimal("ANIMPORTEMU"),
					resultSet.getString("ANDEPOSITOMU"), resultSet.getBigDecimal("ANNUMEROLABSMU"),
					resultSet.getBigDecimal("ANUNIDADESINMOV"), resultSet.getBigDecimal("ANUNIDADESDESINMOV"),
					resultSet.getBigDecimal("ANUNIDADESDESTRUIDAS"), resultSet.getBigDecimal("ANUNIDADESDEVUELTAS"),
					resultSet.getBigDecimal("ANUNIDADESRECU"), resultSet.getString("ANDESTINOINMOV"),
					resultSet.getString("ANLUGARINMOV"),

					resultSet.getBigDecimal("ATUEXISTENTES"), resultSet.getBigDecimal("ATUINMOVILIZADAS"),
					resultSet.getBigDecimal("ATUDESTRUIDAS"), resultSet.getBigDecimal("ATUDEVOLUCIONORIGEN"),
					resultSet.getBigDecimal("ATULIBRECOMERCIALIZACION"), resultSet.getBigDecimal("ATUOTROS"),
					resultSet.getBigDecimal("ATUTOMAMUESTRAS"),

					resultSet.getDate("ANFECHAINMOV"), null, resultSet.getString("ANPROCEEDINGSIDPLATEA"),
					resultSet.getString("ANLIGADOPROTOCOLO"), resultSet.getString("ANREINICIADA"),
					resultSet.getBigDecimal("ANUNIDADESREVISADAS"), resultSet.getString("ANELIMINADAMICARPETA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	public ActaNueva add(ActaNueva actanueva) {
		String query = "INSERT INTO ACTA_NUEVA (ANCODIGO, ANCODINS, ANCODAC, ANFECHA, ANHORAINI, ANHORAFIN, ANTIPO, ANDNICO, ANNOMBRECO, ANNORA_CP_ID, ANNOMBRE_CP, ANNORA_PROVINCIA_ID, ANNOMBRE_PROVINCIA, ANNORA_MUNICIPIO_ID, ANNOMBRE_MUNICIPIO, ANNORA_LOCALIDAD_ID, ANNOMBRE_LOCALIDAD, ANNORA_CALLE_ID, ANNOMBRE_CALLE, ANNORA_PORTAL_ID, ANNOMBRE_PORTAL, ANNOMBRE_PISO, ANTELEFONOCO, ANCONDICIONCO, ANREQRESUMEN, ANINFRESUMEN, ANINFPROPUESTA, ANANIOMU, ANNUMEROMU, ANESPEFIFICMU, ANCODCARACTERMU, ANCODUNIDADESMU, ANUNIDADESOTROSMU, ANEJEMPLARESUNIDADMU, ANIMPORTEMU, ANDEPOSITOMU, ANNUMEROLABSMU, ANUNIDADESINMOV,ANUNIDADESRECU, ANUNIDADESDESINMOV, ANUNIDADESDESTRUIDAS, ANUNIDADESDEVUELTAS, ANDESTINOINMOV, ANLUGARINMOV, ANFECHAINMOV, ANLIGADOPROTOCOLO, ANUNIDADESREVISADAS, ANELIMINADAMICARPETA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, actanueva.getAncodigo(), actanueva.getAncodins(), actanueva.getAncodac(),
				actanueva.getAnfecha(), actanueva.getAnhoraini(), actanueva.getAnhorafin(), actanueva.getAntipo(),
				actanueva.getAndnico(), actanueva.getAnnombreco(), actanueva.getAnnoraCpId(), actanueva.getAnnombreCp(),
				actanueva.getAnnoraProvinciaId(), actanueva.getAnnombreProvincia(), actanueva.getAnnoraMunicipioId(),
				actanueva.getAnnombreMunicipio(), actanueva.getAnnoraLocalidadId(), actanueva.getAnnombreLocalidad(),
				actanueva.getAnnoraCalleId(), actanueva.getAnnombreCalle(), actanueva.getAnnoraPortalId(),
				actanueva.getAnnombrePortal(), actanueva.getAnnombrePiso(), actanueva.getAntelefonoco(),
				actanueva.getAncondicionco(), actanueva.getAnreqresumen(), actanueva.getAninfresumen(),
				actanueva.getAninfpropuesta(), actanueva.getAnaniomu(), actanueva.getAnnumeromu(),
				actanueva.getAnespefificmu(), actanueva.getAncodcaractermu(), actanueva.getAncodunidadesmu(),
				actanueva.getAnunidadesotrosmu(), actanueva.getAnejemplaresunidadmu(), actanueva.getAnimportemu(),
				actanueva.getAndepositomu(), actanueva.getAnnumerolabsmu(), actanueva.getAnunidadesinmov(),
				actanueva.getAnunidadesrecuperadas(), actanueva.getAnunidadesdesinmov(),
				actanueva.getAnunidadesdestruidas(), actanueva.getAnunidadesdevueltas(), actanueva.getAndestinoinmov(),
				actanueva.getAnlugarinmov(), actanueva.getAnfechainmov(), actanueva.getAnligadoprotocolo(),
				actanueva.getAnunidadesrevisadas(), actanueva.getAneliminadamicarpeta());
		return actanueva;
	}

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	public ActaNueva update(ActaNueva actanueva) {
		String query = "UPDATE ACTA_NUEVA SET ANCODINS=?, ANCODAC=?, ANFECHA=?, ANHORAINI=?, ANHORAFIN=?, ANTIPO=?, ANDNICO=?, ANNOMBRECO=?, ANNORA_CP_ID=?, ANNOMBRE_CP=?, ANNORA_PROVINCIA_ID=?, ANNOMBRE_PROVINCIA=?, ANNORA_MUNICIPIO_ID=?, ANNOMBRE_MUNICIPIO=?, ANNORA_LOCALIDAD_ID=?, ANNOMBRE_LOCALIDAD=?, ANNORA_CALLE_ID=?, ANNOMBRE_CALLE=?, ANNORA_PORTAL_ID=?, ANNOMBRE_PORTAL=?, ANNOMBRE_PISO=?, ANTELEFONOCO=?, ANCONDICIONCO=?, ANREQRESUMEN=?, ANINFRESUMEN=?, ANINFPROPUESTA=?, ANANIOMU=?, ANNUMEROMU=?, ANESPEFIFICMU=?, ANCODCARACTERMU=?, ANCODUNIDADESMU=?, ANUNIDADESOTROSMU=?, ANEJEMPLARESUNIDADMU=?, ANIMPORTEMU=?, ANDEPOSITOMU=?, ANNUMEROLABSMU=?, ANUNIDADESINMOV=?,ANUNIDADESRECU=?, ANUNIDADESDESINMOV=?, ANUNIDADESDESTRUIDAS=?, ANUNIDADESDEVUELTAS=?, ANDESTINOINMOV=?, ANLUGARINMOV=?, ANFECHAINMOV=?, ANLIGADOPROTOCOLO=?, ANUNIDADESREVISADAS=?, ANELIMINADAMICARPETA=? WHERE ANCODIGO=?";
		this.jdbcTemplate.update(query, actanueva.getAncodins(), actanueva.getAncodac(), actanueva.getAnfecha(),
				actanueva.getAnhoraini(), actanueva.getAnhorafin(), actanueva.getAntipo(), actanueva.getAndnico(),
				actanueva.getAnnombreco(), actanueva.getAnnoraCpId(), actanueva.getAnnombreCp(),
				actanueva.getAnnoraProvinciaId(), actanueva.getAnnombreProvincia(), actanueva.getAnnoraMunicipioId(),
				actanueva.getAnnombreMunicipio(), actanueva.getAnnoraLocalidadId(), actanueva.getAnnombreLocalidad(),
				actanueva.getAnnoraCalleId(), actanueva.getAnnombreCalle(), actanueva.getAnnoraPortalId(),
				actanueva.getAnnombrePortal(), actanueva.getAnnombrePiso(), actanueva.getAntelefonoco(),
				actanueva.getAncondicionco(), actanueva.getAnreqresumen(), actanueva.getAninfresumen(),
				actanueva.getAninfpropuesta(), actanueva.getAnaniomu(), actanueva.getAnnumeromu(),
				actanueva.getAnespefificmu(), actanueva.getAncodcaractermu(), actanueva.getAncodunidadesmu(),
				actanueva.getAnunidadesotrosmu(), actanueva.getAnejemplaresunidadmu(), actanueva.getAnimportemu(),
				actanueva.getAndepositomu(), actanueva.getAnnumerolabsmu(), actanueva.getAnunidadesinmov(),
				actanueva.getAnunidadesrecuperadas(), actanueva.getAnunidadesdesinmov(),
				actanueva.getAnunidadesdestruidas(), actanueva.getAnunidadesdevueltas(), actanueva.getAndestinoinmov(),
				actanueva.getAnlugarinmov(), actanueva.getAnfechainmov(), actanueva.getAnligadoprotocolo(),
				actanueva.getAnunidadesrevisadas(), actanueva.getAneliminadamicarpeta(), actanueva.getAncodigo());
		return actanueva;
	}

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateProceedingsIdPlatea(ActaNueva actanueva) {
		String query = "UPDATE ACTA_NUEVA SET ANPROCEEDINGSIDPLATEA=? WHERE ANCODIGO=?";

		this.jdbcTemplate.update(query, actanueva.getAnproceedingsidplatea(), actanueva.getAncodigo());
		return actanueva;
	}

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateReiniciada(ActaNueva actanueva) {
		String query = "UPDATE ACTA_NUEVA SET ANREINICIADA=? WHERE ANCODIGO=?";

		this.jdbcTemplate.update(query, actanueva.getAnreiniciada(), actanueva.getAncodigo());
		return actanueva;
	}

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateEliminadaMiCarpeta(ActaNueva actanueva) {
		String query = "UPDATE ACTA_NUEVA SET ANELIMINADAMICARPETA=? WHERE ANCODIGO=?";

		this.jdbcTemplate.update(query, actanueva.getAneliminadamicarpeta(), actanueva.getAncodigo());
		return actanueva;
	}

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateCodigoActa(ActaNueva actanueva) {
		String query = "UPDATE ACTA_NUEVA SET ANCODAC=? WHERE ANCODIGO=?";

		this.jdbcTemplate.update(query, actanueva.getAncodac(), actanueva.getAncodigo());
		return actanueva;
	}

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	@Transactional(readOnly = true)
	public ActaNueva find(ActaNueva actanueva) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC, t1.ANFECHA ANFECHA, t1.ANHORAINI ANHORAINI, t1.ANHORAFIN ANHORAFIN, t1.ANTIPO ANTIPO, t1.ANDNICO ANDNICO, t1.ANNOMBRECO ANNOMBRECO, t1.ANNORA_CP_ID ANNORACPID, t1.ANNOMBRE_CP ANNOMBRECP, t1.ANNORA_PROVINCIA_ID ANNORAPROVINCIAID, t1.ANNOMBRE_PROVINCIA ANNOMBREPROVINCIA, t1.ANNORA_MUNICIPIO_ID ANNORAMUNICIPIOID, t1.ANNOMBRE_MUNICIPIO ANNOMBREMUNICIPIO, t1.ANNORA_LOCALIDAD_ID ANNORALOCALIDADID, t1.ANNOMBRE_LOCALIDAD ANNOMBRELOCALIDAD, t1.ANNORA_CALLE_ID ANNORACALLEID, t1.ANNOMBRE_CALLE ANNOMBRECALLE, t1.ANNORA_PORTAL_ID ANNORAPORTALID, t1.ANNOMBRE_PORTAL ANNOMBREPORTAL, t1.ANNOMBRE_PISO ANNOMBREPISO, t1.ANTELEFONOCO ANTELEFONOCO, t1.ANCONDICIONCO ANCONDICIONCO, t1.ANREQRESUMEN ANREQRESUMEN, t1.ANINFRESUMEN ANINFRESUMEN, t1.ANINFPROPUESTA ANINFPROPUESTA, t1.ANANIOMU ANANIOMU, t1.ANNUMEROMU ANNUMEROMU, t1.ANESPEFIFICMU ANESPEFIFICMU, t1.ANCODCARACTERMU ANCODCARACTERMU, t1.ANCODUNIDADESMU ANCODUNIDADESMU, t1.ANUNIDADESOTROSMU ANUNIDADESOTROSMU, t1.ANEJEMPLARESUNIDADMU ANEJEMPLARESUNIDADMU, t1.ANIMPORTEMU ANIMPORTEMU, t1.ANDEPOSITOMU ANDEPOSITOMU, t1.ANNUMEROLABSMU ANNUMEROLABSMU, t1.ANUNIDADESINMOV ANUNIDADESINMOV, t1.ANUNIDADESDESINMOV ANUNIDADESDESINMOV, t1.ANUNIDADESDESTRUIDAS ANUNIDADESDESTRUIDAS, t1.ANUNIDADESDEVUELTAS ANUNIDADESDEVUELTAS, t1.ANUNIDADESRECU ANUNIDADESRECU, t1.ANDESTINOINMOV ANDESTINOINMOV, t1.ANLUGARINMOV ANLUGARINMOV, t1.ANFECHAINMOV ANFECHAINMOV, NVL(t4.ATUEXISTENTES,0) ATUEXISTENTES, NVL(t4.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t4.ATUDESTRUIDAS,0) ATUDESTRUIDAS, NVL(t4.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t4.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t4.ATUOTROS,0) ATUOTROS, NVL(t4.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 THEN 'T' ELSE 'E' END) ANESTADO, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA, t1.ANLIGADOPROTOCOLO ANLIGADOPROTOCOLO, t1.ANREINICIADA ANREINICIADA, t1.ANUNIDADESREVISADAS ANUNIDADESREVISADAS, t1.ANELIMINADAMICARPETA ANELIMINADAMICARPETA ");
		query.append(" FROM ACTA_NUEVA t1, ACTUACION t4 ");
		query.append(" WHERE t1.ANCODINS = t4.ATCODIGO (+) AND t1.ANCODIGO = ? ");

		List<ActaNueva> actanuevaList = this.jdbcTemplate.query(query.toString(), this.rwMap, actanueva.getAncodigo());
		return (ActaNueva) DataAccessUtils.uniqueResult(actanuevaList);
	}

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * 
	 * @return ActaNueva
	 */
	@Transactional(readOnly = true)
	public ActaNueva findUltimoActaTramitadaLigadaAProtocolo(ActaNueva actanueva) {
		try {
			String query = "SELECT * FROM (SELECT t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC "
					+ "FROM ACTA_NUEVA t1 "
					+ "WHERE t1.ANCODINS=? AND t1.ANLIGADOPROTOCOLO = ? AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 ORDER BY t1.ANFECHA DESC) WHERE 1=1 AND ROWNUM=1 ";
			return (ActaNueva) this.jdbcTemplate.queryForObject(query, new RowMapper<ActaNueva>() {
				public ActaNueva mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new ActaNueva(resultSet.getString("ANCODINS"), resultSet.getString("ANCODINS"),
							resultSet.getString("ANCODAC"));
				}
			}, actanueva.getAncodins(), Y41bConstantes.VALOR_SI);
		} catch (EmptyResultDataAccessException e) {
			return new ActaNueva();
		}
	}

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	@Transactional(readOnly = true)
	public ActaNueva findByAncodac(ActaNueva actanueva) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC, t1.ANFECHA ANFECHA, t1.ANHORAINI ANHORAINI, t1.ANHORAFIN ANHORAFIN, t1.ANTIPO ANTIPO, t1.ANDNICO ANDNICO, t1.ANNOMBRECO ANNOMBRECO, t1.ANNORA_CP_ID ANNORACPID, t1.ANNOMBRE_CP ANNOMBRECP, t1.ANNORA_PROVINCIA_ID ANNORAPROVINCIAID, t1.ANNOMBRE_PROVINCIA ANNOMBREPROVINCIA, t1.ANNORA_MUNICIPIO_ID ANNORAMUNICIPIOID, t1.ANNOMBRE_MUNICIPIO ANNOMBREMUNICIPIO, t1.ANNORA_LOCALIDAD_ID ANNORALOCALIDADID, t1.ANNOMBRE_LOCALIDAD ANNOMBRELOCALIDAD, t1.ANNORA_CALLE_ID ANNORACALLEID, t1.ANNOMBRE_CALLE ANNOMBRECALLE, t1.ANNORA_PORTAL_ID ANNORAPORTALID, t1.ANNOMBRE_PORTAL ANNOMBREPORTAL, t1.ANNOMBRE_PISO ANNOMBREPISO, t1.ANTELEFONOCO ANTELEFONOCO, t1.ANCONDICIONCO ANCONDICIONCO, t1.ANREQRESUMEN ANREQRESUMEN, t1.ANINFRESUMEN ANINFRESUMEN, t1.ANINFPROPUESTA ANINFPROPUESTA, t1.ANANIOMU ANANIOMU, t1.ANNUMEROMU ANNUMEROMU, t1.ANESPEFIFICMU ANESPEFIFICMU, t1.ANCODCARACTERMU ANCODCARACTERMU, t1.ANCODUNIDADESMU ANCODUNIDADESMU, t1.ANUNIDADESOTROSMU ANUNIDADESOTROSMU, t1.ANEJEMPLARESUNIDADMU ANEJEMPLARESUNIDADMU, t1.ANIMPORTEMU ANIMPORTEMU, t1.ANDEPOSITOMU ANDEPOSITOMU, t1.ANNUMEROLABSMU ANNUMEROLABSMU, t1.ANUNIDADESINMOV ANUNIDADESINMOV, t1.ANUNIDADESDESINMOV ANUNIDADESDESINMOV, t1.ANUNIDADESDESTRUIDAS ANUNIDADESDESTRUIDAS, t1.ANUNIDADESDEVUELTAS ANUNIDADESDEVUELTAS, t1.ANUNIDADESRECU ANUNIDADESRECU, t1.ANDESTINOINMOV ANDESTINOINMOV, t1.ANLUGARINMOV ANLUGARINMOV, t1.ANFECHAINMOV ANFECHAINMOV, NVL(t4.ATUEXISTENTES,0) ATUEXISTENTES, NVL(t4.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t4.ATUDESTRUIDAS,0) ATUDESTRUIDAS, NVL(t4.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t4.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t4.ATUOTROS,0) ATUOTROS, NVL(t4.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 THEN 'T' ELSE 'E' END) ANESTADO, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA, t1.ANLIGADOPROTOCOLO ANLIGADOPROTOCOLO, t1.ANREINICIADA ANREINICIADA, t1.ANUNIDADESREVISADAS ANUNIDADESREVISADAS, t1.ANELIMINADAMICARPETA ANELIMINADAMICARPETA ");
		query.append(" FROM ACTA_NUEVA t1, ACTUACION t4 ");
		query.append(" WHERE t1.ANCODINS = t4.ATCODIGO (+) AND t1.ANCODAC = ? AND ROWNUM=1 ");

		List<ActaNueva> actanuevaList = this.jdbcTemplate.query(query.toString(), this.rwMap, actanueva.getAncodac());
		return (ActaNueva) DataAccessUtils.uniqueResult(actanuevaList);
	}

	/**
	 * Finds an Num Muestra
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findNumMuestra(ActaNueva actanueva) {

		String query = "SELECT NVL(MAX(ABS(ANNUMEROMU)),0)+1 ANNUMEROMU FROM ACTA_NUEVA WHERE ANANIOMU = ? ";

		return this.jdbcTemplate.queryForObject(query, String.class, new Object[] { actanueva.getAnaniomu() });
	}

	/**
	 * Finds an Cod Acta
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findCodActa(ActaNueva actanueva) {

		String query = "SELECT 'IO'||LPAD((NVL(max(SUBSTR(ANCODAC,3)),0)+1),6,'0') ANCODAC FROM ACTA_NUEVA WHERE ANCODAC LIKE 'IO%'";

		return this.jdbcTemplate.queryForObject(query, String.class, new Object[] {});
	}

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	@Transactional(readOnly = true)
	public ActaNueva findProceedingsIdPlatea(ActaNueva actanueva) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANCODIGO ANCODIGO, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA ");
		query.append(" FROM ACTA_NUEVA t1 ");
		query.append(" WHERE 1=1 AND t1.ANCODIGO = ? ");

		List<ActaNueva> actanuevaList = this.jdbcTemplate.query(query.toString(), new RowMapper<ActaNueva>() {
			public ActaNueva mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new ActaNueva(resultSet.getString("ANCODIGO"), resultSet.getString("ANPROCEEDINGSIDPLATEA"));
			}
		}, actanueva.getAncodigo());
		return (ActaNueva) DataAccessUtils.uniqueResult(actanuevaList);
	}

	/**
	 * Removes a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return
	 */
	public void remove(ActaNueva actanueva) {
		String query = "DELETE FROM ACTA_NUEVA WHERE ANCODIGO=?";
		this.jdbcTemplate.update(query, actanueva.getAncodigo());
	}

	/**
	 * Removes a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return
	 */
	public void removeAllActasInspeccion(ActaNueva actanueva) {
		String query = "DELETE FROM ACTA_NUEVA WHERE ANCODINS=?";
		this.jdbcTemplate.update(query, actanueva.getAncodins());
	}

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaNueva> findAll(ActaNueva actanueva, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC, t1.ANFECHA ANFECHA, t1.ANHORAINI ANHORAINI, t1.ANHORAFIN ANHORAFIN, t1.ANTIPO ANTIPO, t1.ANDNICO ANDNICO, t1.ANNOMBRECO ANNOMBRECO, t1.ANNORA_CP_ID ANNORACPID, t1.ANNOMBRE_CP ANNOMBRECP, t1.ANNORA_PROVINCIA_ID ANNORAPROVINCIAID, t1.ANNOMBRE_PROVINCIA ANNOMBREPROVINCIA, t1.ANNORA_MUNICIPIO_ID ANNORAMUNICIPIOID, t1.ANNOMBRE_MUNICIPIO ANNOMBREMUNICIPIO, t1.ANNORA_LOCALIDAD_ID ANNORALOCALIDADID, t1.ANNOMBRE_LOCALIDAD ANNOMBRELOCALIDAD, t1.ANNORA_CALLE_ID ANNORACALLEID, t1.ANNOMBRE_CALLE ANNOMBRECALLE, t1.ANNORA_PORTAL_ID ANNORAPORTALID, t1.ANNOMBRE_PORTAL ANNOMBREPORTAL, t1.ANNOMBRE_PISO ANNOMBREPISO, t1.ANTELEFONOCO ANTELEFONOCO, t1.ANCONDICIONCO ANCONDICIONCO, t1.ANREQRESUMEN ANREQRESUMEN, t1.ANINFRESUMEN ANINFRESUMEN, t1.ANINFPROPUESTA ANINFPROPUESTA, t1.ANANIOMU ANANIOMU, t1.ANNUMEROMU ANNUMEROMU, t1.ANESPEFIFICMU ANESPEFIFICMU, t1.ANCODCARACTERMU ANCODCARACTERMU, t1.ANCODUNIDADESMU ANCODUNIDADESMU, t1.ANUNIDADESOTROSMU ANUNIDADESOTROSMU, t1.ANEJEMPLARESUNIDADMU ANEJEMPLARESUNIDADMU, t1.ANIMPORTEMU ANIMPORTEMU, t1.ANDEPOSITOMU ANDEPOSITOMU, t1.ANNUMEROLABSMU ANNUMEROLABSMU, t1.ANUNIDADESINMOV ANUNIDADESINMOV, t1.ANUNIDADESDESINMOV ANUNIDADESDESINMOV, t1.ANUNIDADESDESTRUIDAS ANUNIDADESDESTRUIDAS, t1.ANUNIDADESDEVUELTAS ANUNIDADESDEVUELTAS,t1.ANUNIDADESRECU ANUNIDADESRECU, t1.ANDESTINOINMOV ANDESTINOINMOV, t1.ANLUGARINMOV ANLUGARINMOV, t1.ANFECHAINMOV ANFECHAINMOV, NVL(t4.ATUEXISTENTES,0) ATUEXISTENTES, NVL(t4.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t4.ATUDESTRUIDAS,0) ATUDESTRUIDAS, NVL(t4.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t4.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t4.ATUOTROS,0) ATUOTROS, NVL(t4.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 THEN 'T' ELSE 'E' END) ANESTADO, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA, t1.ANLIGADOPROTOCOLO ANLIGADOPROTOCOLO, t1.ANREINICIADA ANREINICIADA, t1.ANUNIDADESREVISADAS ANUNIDADESREVISADAS, t1.ANELIMINADAMICARPETA ANELIMINADAMICARPETA ");
		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actanueva);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ActaNueva>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaNueva> findAllActaTramitada(ActaNueva actanueva, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC, t1.ANFECHA ANFECHA, t1.ANHORAINI ANHORAINI, t1.ANHORAFIN ANHORAFIN, t1.ANTIPO ANTIPO, t1.ANDNICO ANDNICO, t1.ANNOMBRECO ANNOMBRECO, t1.ANNORA_CP_ID ANNORACPID, t1.ANNOMBRE_CP ANNOMBRECP, t1.ANNORA_PROVINCIA_ID ANNORAPROVINCIAID, t1.ANNOMBRE_PROVINCIA ANNOMBREPROVINCIA, t1.ANNORA_MUNICIPIO_ID ANNORAMUNICIPIOID, t1.ANNOMBRE_MUNICIPIO ANNOMBREMUNICIPIO, t1.ANNORA_LOCALIDAD_ID ANNORALOCALIDADID, t1.ANNOMBRE_LOCALIDAD ANNOMBRELOCALIDAD, t1.ANNORA_CALLE_ID ANNORACALLEID, t1.ANNOMBRE_CALLE ANNOMBRECALLE, t1.ANNORA_PORTAL_ID ANNORAPORTALID, t1.ANNOMBRE_PORTAL ANNOMBREPORTAL, t1.ANNOMBRE_PISO ANNOMBREPISO, t1.ANTELEFONOCO ANTELEFONOCO, t1.ANCONDICIONCO ANCONDICIONCO, t1.ANREQRESUMEN ANREQRESUMEN, t1.ANINFRESUMEN ANINFRESUMEN, t1.ANINFPROPUESTA ANINFPROPUESTA, t1.ANANIOMU ANANIOMU, t1.ANNUMEROMU ANNUMEROMU, t1.ANESPEFIFICMU ANESPEFIFICMU, t1.ANCODCARACTERMU ANCODCARACTERMU, t1.ANCODUNIDADESMU ANCODUNIDADESMU, t1.ANUNIDADESOTROSMU ANUNIDADESOTROSMU, t1.ANEJEMPLARESUNIDADMU ANEJEMPLARESUNIDADMU, t1.ANIMPORTEMU ANIMPORTEMU, t1.ANDEPOSITOMU ANDEPOSITOMU, t1.ANNUMEROLABSMU ANNUMEROLABSMU, t1.ANUNIDADESINMOV ANUNIDADESINMOV, t1.ANUNIDADESDESINMOV ANUNIDADESDESINMOV, t1.ANUNIDADESDESTRUIDAS ANUNIDADESDESTRUIDAS, t1.ANUNIDADESDEVUELTAS ANUNIDADESDEVUELTAS,t1.ANUNIDADESRECU ANUNIDADESRECU, t1.ANDESTINOINMOV ANDESTINOINMOV, t1.ANLUGARINMOV ANLUGARINMOV, t1.ANFECHAINMOV ANFECHAINMOV, NVL(t4.ATUEXISTENTES,0) ATUEXISTENTES, NVL(t4.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t4.ATUDESTRUIDAS,0) ATUDESTRUIDAS, NVL(t4.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t4.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t4.ATUOTROS,0) ATUOTROS, NVL(t4.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 THEN 'T' ELSE 'E' END) ANESTADO, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA, t1.ANLIGADOPROTOCOLO ANLIGADOPROTOCOLO, t1.ANREINICIADA ANREINICIADA, t1.ANUNIDADESREVISADAS ANUNIDADESREVISADAS, t1.ANELIMINADAMICARPETA ANELIMINADAMICARPETA ");
		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actanueva);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ActaNueva>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllActaInmovilizacionTramitadaCount(ActaNueva actanueva) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");

		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 ");

		List<Object> params = new ArrayList<Object>();
		where.append(" AND UPPER(t1.ANTIPO) like ? ESCAPE  '\\'");
		params.add("%" + Y41bConstantes.ACTA_NUEVA_TIPO_INMOVILIZACION_CAUTELAR + "%");
		where.append(" AND t1.ANTIPO IS NOT NULL");

		where.append(" AND t1.ANCODINS = ?");
		params.add(actanueva.getAncodins());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ActaNueva actanueva) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");

		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actanueva);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllActaInfraccionProtocoloTramitadaCount(ActaNueva actanueva) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActaInfraccionProtocoloTramitadaMap(actanueva);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the ActaNueva table using like.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaNueva> findAllLike(ActaNueva actanueva, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC, t1.ANFECHA ANFECHA, t1.ANHORAINI ANHORAINI, t1.ANHORAFIN ANHORAFIN, t1.ANTIPO ANTIPO, t1.ANDNICO ANDNICO, t1.ANNOMBRECO ANNOMBRECO, t1.ANNORA_CP_ID ANNORACPID, t1.ANNOMBRE_CP ANNOMBRECP, t1.ANNORA_PROVINCIA_ID ANNORAPROVINCIAID, t1.ANNOMBRE_PROVINCIA ANNOMBREPROVINCIA, t1.ANNORA_MUNICIPIO_ID ANNORAMUNICIPIOID, t1.ANNOMBRE_MUNICIPIO ANNOMBREMUNICIPIO, t1.ANNORA_LOCALIDAD_ID ANNORALOCALIDADID, t1.ANNOMBRE_LOCALIDAD ANNOMBRELOCALIDAD, t1.ANNORA_CALLE_ID ANNORACALLEID, t1.ANNOMBRE_CALLE ANNOMBRECALLE, t1.ANNORA_PORTAL_ID ANNORAPORTALID, t1.ANNOMBRE_PORTAL ANNOMBREPORTAL, t1.ANNOMBRE_PISO ANNOMBREPISO, t1.ANTELEFONOCO ANTELEFONOCO, t1.ANCONDICIONCO ANCONDICIONCO, t1.ANREQRESUMEN ANREQRESUMEN, t1.ANINFRESUMEN ANINFRESUMEN, t1.ANINFPROPUESTA ANINFPROPUESTA, t1.ANANIOMU ANANIOMU, t1.ANNUMEROMU ANNUMEROMU, t1.ANESPEFIFICMU ANESPEFIFICMU, t1.ANCODCARACTERMU ANCODCARACTERMU, t1.ANCODUNIDADESMU ANCODUNIDADESMU, t1.ANUNIDADESOTROSMU ANUNIDADESOTROSMU, t1.ANEJEMPLARESUNIDADMU ANEJEMPLARESUNIDADMU, t1.ANIMPORTEMU ANIMPORTEMU, t1.ANDEPOSITOMU ANDEPOSITOMU, t1.ANNUMEROLABSMU ANNUMEROLABSMU, t1.ANUNIDADESINMOV ANUNIDADESINMOV, t1.ANUNIDADESDESINMOV ANUNIDADESDESINMOV, t1.ANUNIDADESDESTRUIDAS ANUNIDADESDESTRUIDAS, t1.ANUNIDADESDEVUELTAS ANUNIDADESDEVUELTAS,t1.ANUNIDADESRECU ANUNIDADESRECU, t1.ANDESTINOINMOV ANDESTINOINMOV, t1.ANLUGARINMOV ANLUGARINMOV, t1.ANFECHAINMOV ANFECHAINMOV, (CASE WHEN (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 THEN 'T' ELSE 'E' END) ANESTADO,NVL(t4.ATUEXISTENTES,0) ATUEXISTENTES, NVL(t4.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t4.ATUDESTRUIDAS,0) ATUDESTRUIDAS, NVL(t4.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t4.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t4.ATUOTROS,0) ATUOTROS, NVL(t4.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA, t1.ANLIGADOPROTOCOLO ANLIGADOPROTOCOLO, t1.ANREINICIADA ANREINICIADA, t1.ANUNIDADESREVISADAS ANUNIDADESREVISADAS, t1.ANELIMINADAMICARPETA ANELIMINADAMICARPETA ");
		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actanueva, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ActaNueva>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaNueva> findAllActaInfraccionTramitada(ActaNueva actanueva, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANCODIGO ANCODIGO, t1.ANCODINS ANCODINS, t1.ANCODAC ANCODAC, t1.ANFECHA ANFECHA, t1.ANHORAINI ANHORAINI, t1.ANHORAFIN ANHORAFIN, t1.ANTIPO ANTIPO, t1.ANDNICO ANDNICO, t1.ANNOMBRECO ANNOMBRECO, t1.ANNORA_CP_ID ANNORACPID, t1.ANNOMBRE_CP ANNOMBRECP, t1.ANNORA_PROVINCIA_ID ANNORAPROVINCIAID, t1.ANNOMBRE_PROVINCIA ANNOMBREPROVINCIA, t1.ANNORA_MUNICIPIO_ID ANNORAMUNICIPIOID, t1.ANNOMBRE_MUNICIPIO ANNOMBREMUNICIPIO, t1.ANNORA_LOCALIDAD_ID ANNORALOCALIDADID, t1.ANNOMBRE_LOCALIDAD ANNOMBRELOCALIDAD, t1.ANNORA_CALLE_ID ANNORACALLEID, t1.ANNOMBRE_CALLE ANNOMBRECALLE, t1.ANNORA_PORTAL_ID ANNORAPORTALID, t1.ANNOMBRE_PORTAL ANNOMBREPORTAL, t1.ANNOMBRE_PISO ANNOMBREPISO, t1.ANTELEFONOCO ANTELEFONOCO, t1.ANCONDICIONCO ANCONDICIONCO, t1.ANREQRESUMEN ANREQRESUMEN, t1.ANINFRESUMEN ANINFRESUMEN, t1.ANINFPROPUESTA ANINFPROPUESTA, t1.ANANIOMU ANANIOMU, t1.ANNUMEROMU ANNUMEROMU, t1.ANESPEFIFICMU ANESPEFIFICMU, t1.ANCODCARACTERMU ANCODCARACTERMU, t1.ANCODUNIDADESMU ANCODUNIDADESMU, t1.ANUNIDADESOTROSMU ANUNIDADESOTROSMU, t1.ANEJEMPLARESUNIDADMU ANEJEMPLARESUNIDADMU, t1.ANIMPORTEMU ANIMPORTEMU, t1.ANDEPOSITOMU ANDEPOSITOMU, t1.ANNUMEROLABSMU ANNUMEROLABSMU, t1.ANUNIDADESINMOV ANUNIDADESINMOV, t1.ANUNIDADESDESINMOV ANUNIDADESDESINMOV, t1.ANUNIDADESDESTRUIDAS ANUNIDADESDESTRUIDAS, t1.ANUNIDADESDEVUELTAS ANUNIDADESDEVUELTAS,t1.ANUNIDADESRECU ANUNIDADESRECU, t1.ANDESTINOINMOV ANDESTINOINMOV, t1.ANLUGARINMOV ANLUGARINMOV, t1.ANFECHAINMOV ANFECHAINMOV, (CASE WHEN (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0 THEN 'T' ELSE 'E' END) ANESTADO,NVL(t4.ATUEXISTENTES,0) ATUEXISTENTES, NVL(t4.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t4.ATUDESTRUIDAS,0) ATUDESTRUIDAS, NVL(t4.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t4.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t4.ATUOTROS,0) ATUOTROS, NVL(t4.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, t1.ANPROCEEDINGSIDPLATEA ANPROCEEDINGSIDPLATEA, t1.ANLIGADOPROTOCOLO ANLIGADOPROTOCOLO, t1.ANREINICIADA ANREINICIADA, t1.ANUNIDADESREVISADAS ANUNIDADESREVISADAS, t1.ANELIMINADAMICARPETA ANELIMINADAMICARPETA ");
		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActaInfraccionProtocoloTramitadaMap(actanueva);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO ) > 0  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ActaNueva>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ActaNueva table using like.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ActaNueva actanueva, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append("FROM ACTA_NUEVA t1, ACTUACION t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actanueva, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ANCODINS = t4.ATCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ActaNueva entity
	 * 
	 * @param actanueva
	 *            ActaNueva Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ActaNueva actanueva) {

		StringBuilder where = new StringBuilder(ActaNuevaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actanueva != null && actanueva.getAncodigo() != null) {
			where.append(" AND t1.ANCODIGO = ?");
			params.add(actanueva.getAncodigo());
		}
		if (actanueva != null && actanueva.getAncodins() != null) {
			where.append(" AND t1.ANCODINS = ?");
			params.add(actanueva.getAncodins());
		}
		if (actanueva != null && actanueva.getAncodac() != null) {
			where.append(" AND t1.ANCODAC = ?");
			params.add(actanueva.getAncodac());
		}
		if (actanueva != null && actanueva.getAnfecha() != null) {
			where.append(" AND t1.ANFECHA = ?");
			params.add(actanueva.getAnfecha());
		}
		if (actanueva != null && actanueva.getAnhoraini() != null) {
			where.append(" AND t1.ANHORAINI = ?");
			params.add(actanueva.getAnhoraini());
		}
		if (actanueva != null && actanueva.getAnhorafin() != null) {
			where.append(" AND t1.ANHORAFIN = ?");
			params.add(actanueva.getAnhorafin());
		}
		if (actanueva != null && actanueva.getAntipo() != null) {
			where.append(" AND t1.ANTIPO = ?");
			params.add(actanueva.getAntipo());
		}
		if (actanueva != null && actanueva.getAndnico() != null) {
			where.append(" AND t1.ANDNICO = ?");
			params.add(actanueva.getAndnico());
		}
		if (actanueva != null && actanueva.getAnnombreco() != null) {
			where.append(" AND t1.ANNOMBRECO = ?");
			params.add(actanueva.getAnnombreco());
		}
		if (actanueva != null && actanueva.getAnnoraCpId() != null) {
			where.append(" AND t1.ANNORA_CP_ID = ?");
			params.add(actanueva.getAnnoraCpId());
		}
		if (actanueva != null && actanueva.getAnnombreCp() != null) {
			where.append(" AND t1.ANNOMBRE_CP = ?");
			params.add(actanueva.getAnnombreCp());
		}
		if (actanueva != null && actanueva.getAnnoraProvinciaId() != null) {
			where.append(" AND t1.ANNORA_PROVINCIA_ID = ?");
			params.add(actanueva.getAnnoraProvinciaId());
		}
		if (actanueva != null && actanueva.getAnnombreProvincia() != null) {
			where.append(" AND t1.ANNOMBRE_PROVINCIA = ?");
			params.add(actanueva.getAnnombreProvincia());
		}
		if (actanueva != null && actanueva.getAnnoraMunicipioId() != null) {
			where.append(" AND t1.ANNORA_MUNICIPIO_ID = ?");
			params.add(actanueva.getAnnoraMunicipioId());
		}
		if (actanueva != null && actanueva.getAnnombreMunicipio() != null) {
			where.append(" AND t1.ANNOMBRE_MUNICIPIO = ?");
			params.add(actanueva.getAnnombreMunicipio());
		}
		if (actanueva != null && actanueva.getAnnoraLocalidadId() != null) {
			where.append(" AND t1.ANNORA_LOCALIDAD_ID = ?");
			params.add(actanueva.getAnnoraLocalidadId());
		}
		if (actanueva != null && actanueva.getAnnombreLocalidad() != null) {
			where.append(" AND t1.ANNOMBRE_LOCALIDAD = ?");
			params.add(actanueva.getAnnombreLocalidad());
		}
		if (actanueva != null && actanueva.getAnnoraCalleId() != null) {
			where.append(" AND t1.ANNORA_CALLE_ID = ?");
			params.add(actanueva.getAnnoraCalleId());
		}
		if (actanueva != null && actanueva.getAnnombreCalle() != null) {
			where.append(" AND t1.ANNOMBRE_CALLE = ?");
			params.add(actanueva.getAnnombreCalle());
		}
		if (actanueva != null && actanueva.getAnnoraPortalId() != null) {
			where.append(" AND t1.ANNORA_PORTAL_ID = ?");
			params.add(actanueva.getAnnoraPortalId());
		}
		if (actanueva != null && actanueva.getAnnombrePortal() != null) {
			where.append(" AND t1.ANNOMBRE_PORTAL = ?");
			params.add(actanueva.getAnnombrePortal());
		}
		if (actanueva != null && actanueva.getAntelefonoco() != null) {
			where.append(" AND t1.ANTELEFONOCO = ?");
			params.add(actanueva.getAntelefonoco());
		}
		if (actanueva != null && actanueva.getAncondicionco() != null) {
			where.append(" AND t1.ANCONDICIONCO = ?");
			params.add(actanueva.getAncondicionco());
		}
		if (actanueva != null && actanueva.getAnreqresumen() != null) {
			where.append(" AND t1.ANREQRESUMEN = ?");
			params.add(actanueva.getAnreqresumen());
		}
		if (actanueva != null && actanueva.getAninfresumen() != null) {
			where.append(" AND t1.ANINFRESUMEN = ?");
			params.add(actanueva.getAninfresumen());
		}
		if (actanueva != null && actanueva.getAninfpropuesta() != null) {
			where.append(" AND t1.ANINFPROPUESTA = ?");
			params.add(actanueva.getAninfpropuesta());
		}
		if (actanueva != null && actanueva.getAnaniomu() != null) {
			where.append(" AND t1.ANANIOMU = ?");
			params.add(actanueva.getAnaniomu());
		}
		if (actanueva != null && actanueva.getAnnumeromu() != null) {
			where.append(" AND t1.ANNUMEROMU = ?");
			params.add(actanueva.getAnnumeromu());
		}
		if (actanueva != null && actanueva.getAnespefificmu() != null) {
			where.append(" AND t1.ANESPEFIFICMU = ?");
			params.add(actanueva.getAnespefificmu());
		}
		if (actanueva != null && actanueva.getAncodcaractermu() != null) {
			where.append(" AND t1.ANCODCARACTERMU = ?");
			params.add(actanueva.getAncodcaractermu());
		}
		if (actanueva != null && actanueva.getAncodunidadesmu() != null) {
			where.append(" AND t1.ANCODUNIDADESMU = ?");
			params.add(actanueva.getAncodunidadesmu());
		}
		if (actanueva != null && actanueva.getAnunidadesotrosmu() != null) {
			where.append(" AND t1.ANUNIDADESOTROSMU = ?");
			params.add(actanueva.getAnunidadesotrosmu());
		}
		if (actanueva != null && actanueva.getAnejemplaresunidadmu() != null) {
			where.append(" AND t1.ANEJEMPLARESUNIDADMU = ?");
			params.add(actanueva.getAnejemplaresunidadmu());
		}
		if (actanueva != null && actanueva.getAnimportemu() != null) {
			where.append(" AND t1.ANIMPORTEMU = ?");
			params.add(actanueva.getAnimportemu());
		}
		if (actanueva != null && actanueva.getAndepositomu() != null) {
			where.append(" AND t1.ANDEPOSITOMU = ?");
			params.add(actanueva.getAndepositomu());
		}
		if (actanueva != null && actanueva.getAnnumerolabsmu() != null) {
			where.append(" AND t1.ANNUMEROLABSMU = ?");
			params.add(actanueva.getAnnumerolabsmu());
		}
		if (actanueva != null && actanueva.getAnunidadesinmov() != null) {
			where.append(" AND t1.ANUNIDADESINMOV = ?");
			params.add(actanueva.getAnunidadesinmov());
		}
		if (actanueva != null && actanueva.getAnunidadesdesinmov() != null) {
			where.append(" AND t1.ANUNIDADESDESINMOV = ?");
			params.add(actanueva.getAnunidadesdesinmov());
		}
		if (actanueva != null && actanueva.getAnunidadesdestruidas() != null) {
			where.append(" AND t1.ANUNIDADESDESTRUIDAS = ?");
			params.add(actanueva.getAnunidadesdestruidas());
		}
		if (actanueva != null && actanueva.getAnunidadesdevueltas() != null) {
			where.append(" AND t1.ANUNIDADESDEVUELTAS = ?");
			params.add(actanueva.getAnunidadesdevueltas());
		}
		if (actanueva != null && actanueva.getAndestinoinmov() != null) {
			where.append(" AND t1.ANDESTINOINMOV = ?");
			params.add(actanueva.getAndestinoinmov());
		}
		if (actanueva != null && actanueva.getAnlugarinmov() != null) {
			where.append(" AND t1.ANLUGARINMOV = ?");
			params.add(actanueva.getAnlugarinmov());
		}
		if (actanueva != null && actanueva.getAnfechainmov() != null) {
			where.append(" AND t1.ANFECHAINMOV = ?");
			params.add(actanueva.getAnfechainmov());
		}
		// if (actanueva != null
		// && actanueva.getDocumentoHecho() != null
		// && actanueva.getDocumentoHecho().getTipoDocumento() != null
		// && actanueva.getDocumentoHecho().getTipoDocumento()
		// .getIdTipodoc() != null) {
		// where.append(" AND t3.ID_TIPODOC = ?");
		// params.add(actanueva.getDocumentoHecho().getTipoDocumento()
		// .getIdTipodoc());
		// }
		// if (actanueva != null
		// && actanueva.getDocumentoHecho() != null
		// && actanueva.getDocumentoHecho().getTipoDocumento() != null
		// && actanueva.getDocumentoHecho().getTipoDocumento()
		// .getTdnombre() != null) {
		// where.append(" AND t3.TDNOMBRE = ?");
		// params.add(actanueva.getDocumentoHecho().getTipoDocumento()
		// .getTdnombre());
		// }
		// if (actanueva != null
		// && actanueva.getDocumentoHecho() != null
		// && actanueva.getDocumentoHecho().getTipoDocumento() != null
		// && actanueva.getDocumentoHecho().getTipoDocumento()
		// .getTdnombree() != null) {
		// where.append(" AND t3.TDNOMBREE = ?");
		// params.add(actanueva.getDocumentoHecho().getTipoDocumento()
		// .getTdnombree());
		// }

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ActaNueva entity
	 * 
	 * @param actanueva
	 *            ActaNueva Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereActaInfraccionProtocoloTramitadaMap(ActaNueva actanueva) {

		StringBuilder where = new StringBuilder(ActaNuevaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actanueva != null && actanueva.getAncodins() != null) {
			where.append(" AND t1.ANCODINS = ?");
			params.add(actanueva.getAncodins());
		}

		if (actanueva != null && actanueva.getAntipo() != null) {
			where.append(" AND UPPER(t1.ANTIPO) like ? ESCAPE  '\\'");
			params.add("%" + actanueva.getAntipo().toUpperCase() + "%");
			where.append(" AND t1.ANTIPO IS NOT NULL");
		}

		if (actanueva != null && actanueva.getAnligadoprotocolo() != null) {
			where.append(" AND t1.ANLIGADOPROTOCOLO = ?");
			params.add(actanueva.getAnligadoprotocolo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ActaNueva entity
	 * 
	 * @param actanueva
	 *            ActaNueva Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(ActaNueva actanueva, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ActaNuevaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actanueva != null && actanueva.getAntipos() != null) {
			where.append(" AND ti.ANTIPO IN ( ");
			for (String tipo : actanueva.getAntipos()) {
				where.append(" ?  ,");
				params.add(tipo);
			}
			where.deleteCharAt(where.length() - 1);
			where.append(")");

		}

		if (actanueva != null && actanueva.getAncodigo() != null) {
			where.append(" AND UPPER(t1.ANCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAncodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAncodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCODIGO IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAncodins() != null) {
			where.append(" AND UPPER(t1.ANCODINS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAncodins().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAncodins().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCODINS IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAncodac() != null) {
			where.append(" AND UPPER(t1.ANCODAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAncodac().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAncodac().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCODAC IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnfecha() != null) {
			where.append(" AND t1.ANFECHA = ?");
			params.add(actanueva.getAnfecha());
		}
		if (actanueva != null && actanueva.getAnhoraini() != null) {
			where.append(" AND UPPER(t1.ANHORAINI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnhoraini().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnhoraini().toUpperCase() + "%");
			}
			where.append(" AND t1.ANHORAINI IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnhorafin() != null) {
			where.append(" AND UPPER(t1.ANHORAFIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnhorafin().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnhorafin().toUpperCase() + "%");
			}
			where.append(" AND t1.ANHORAFIN IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAntipo() != null) {
			where.append(" AND UPPER(t1.ANTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAntipo().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAntipo().toUpperCase() + "%");
			}
			where.append(" AND t1.ANTIPO IS NOT NULL");
		}

		if (actanueva != null && actanueva.getAnestado() != null && actanueva.getAnestado().equalsIgnoreCase("T")) {
			where.append(" AND 1 <= (SELECT COUNT(1) FROM TRAMITE_INSPECCION WHERE TIACCODIGO = t1.ANCODIGO )");
		}

		if (actanueva != null && actanueva.getAndnico() != null) {
			where.append(" AND UPPER(t1.ANDNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAndnico().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAndnico().toUpperCase() + "%");
			}
			where.append(" AND t1.ANDNICO IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombreco() != null) {
			where.append(" AND UPPER(t1.ANNOMBRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombreco().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombreco().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRECO IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnoraCpId() != null) {
			where.append(" AND UPPER(t1.ANNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNORA_CP_ID IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombreCp() != null) {
			where.append(" AND UPPER(t1.ANNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRE_CP IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.ANNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombreProvincia() != null) {
			where.append(" AND UPPER(t1.ANNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.ANNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.ANNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.ANNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.ANNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnoraCalleId() != null) {
			where.append(" AND UPPER(t1.ANNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNORA_CALLE_ID IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombreCalle() != null) {
			where.append(" AND UPPER(t1.ANNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRE_CALLE IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnoraPortalId() != null) {
			where.append(" AND UPPER(t1.ANNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNORA_PORTAL_ID IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnombrePortal() != null) {
			where.append(" AND UPPER(t1.ANNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNOMBRE_PORTAL IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAntelefonoco() != null) {
			where.append(" AND UPPER(t1.ANTELEFONOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAntelefonoco().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAntelefonoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ANTELEFONOCO IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAncondicionco() != null) {
			where.append(" AND UPPER(t1.ANCONDICIONCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAncondicionco().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAncondicionco().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCONDICIONCO IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnreqresumen() != null) {
			where.append(" AND UPPER(t1.ANREQRESUMEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnreqresumen().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnreqresumen().toUpperCase() + "%");
			}
			where.append(" AND t1.ANREQRESUMEN IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAninfresumen() != null) {
			where.append(" AND UPPER(t1.ANINFRESUMEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAninfresumen().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAninfresumen().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINFRESUMEN IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAninfpropuesta() != null) {
			where.append(" AND UPPER(t1.ANINFPROPUESTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAninfpropuesta().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAninfpropuesta().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINFPROPUESTA IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnaniomu() != null) {
			where.append(" AND t1.ANANIOMU = ?");
			params.add(actanueva.getAnaniomu());
		}
		if (actanueva != null && actanueva.getAnnumeromu() != null) {
			where.append(" AND t1.ANNUMEROMU = ?");
			params.add(actanueva.getAnnumeromu());
		}
		if (actanueva != null && actanueva.getAnespefificmu() != null) {
			where.append(" AND UPPER(t1.ANESPEFIFICMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnespefificmu().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnespefificmu().toUpperCase() + "%");
			}
			where.append(" AND t1.ANESPEFIFICMU IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAncodcaractermu() != null) {
			where.append(" AND UPPER(t1.ANCODCARACTERMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAncodcaractermu().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAncodcaractermu().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCODCARACTERMU IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAncodunidadesmu() != null) {
			where.append(" AND UPPER(t1.ANCODUNIDADESMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAncodunidadesmu().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAncodunidadesmu().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCODUNIDADESMU IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnunidadesotrosmu() != null) {
			where.append(" AND t1.ANUNIDADESOTROSMU = ?");
			params.add(actanueva.getAnunidadesotrosmu());
		}
		if (actanueva != null && actanueva.getAnejemplaresunidadmu() != null) {
			where.append(" AND t1.ANEJEMPLARESUNIDADMU = ?");
			params.add(actanueva.getAnejemplaresunidadmu());
		}
		if (actanueva != null && actanueva.getAnimportemu() != null) {
			where.append(" AND t1.ANIMPORTEMU = ?");
			params.add(actanueva.getAnimportemu());
		}
		if (actanueva != null && actanueva.getAndepositomu() != null) {
			where.append(" AND UPPER(t1.ANDEPOSITOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAndepositomu().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAndepositomu().toUpperCase() + "%");
			}
			where.append(" AND t1.ANDEPOSITOMU IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnnumerolabsmu() != null) {
			where.append(" AND t1.ANNUMEROLABSMU = ?");
			params.add(actanueva.getAnnumerolabsmu());
		}
		if (actanueva != null && actanueva.getAnunidadesinmov() != null) {
			where.append(" AND t1.ANUNIDADESINMOV = ?");
			params.add(actanueva.getAnunidadesinmov());
		}
		if (actanueva != null && actanueva.getAnunidadesdesinmov() != null) {
			where.append(" AND t1.ANUNIDADESDESINMOV = ?");
			params.add(actanueva.getAnunidadesdesinmov());
		}
		if (actanueva != null && actanueva.getAnunidadesdestruidas() != null) {
			where.append(" AND t1.ANUNIDADESDESTRUIDAS = ?");
			params.add(actanueva.getAnunidadesdestruidas());
		}
		if (actanueva != null && actanueva.getAnunidadesdevueltas() != null) {
			where.append(" AND t1.ANUNIDADESDEVUELTAS = ?");
			params.add(actanueva.getAnunidadesdevueltas());
		}
		if (actanueva != null && actanueva.getAndestinoinmov() != null) {
			where.append(" AND UPPER(t1.ANDESTINOINMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAndestinoinmov().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAndestinoinmov().toUpperCase() + "%");
			}
			where.append(" AND t1.ANDESTINOINMOV IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnlugarinmov() != null) {
			where.append(" AND UPPER(t1.ANLUGARINMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getAnlugarinmov().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getAnlugarinmov().toUpperCase() + "%");
			}
			where.append(" AND t1.ANLUGARINMOV IS NOT NULL");
		}
		if (actanueva != null && actanueva.getAnfechainmov() != null) {
			where.append(" AND t1.ANFECHAINMOV = ?");
			params.add(actanueva.getAnfechainmov());
		}
		if (actanueva != null && actanueva.getDocumentoHecho() != null
				&& actanueva.getDocumentoHecho().getTipoDocumento() != null
				&& actanueva.getDocumentoHecho().getTipoDocumento().getIdTipodoc() != null) {
			where.append(" AND UPPER(t1.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getDocumentoHecho().getTipoDocumento().getIdTipodoc().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getDocumentoHecho().getTipoDocumento().getIdTipodoc().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_TIPODOC IS NOT NULL");
		}
		if (actanueva != null && actanueva.getDocumentoHecho() != null
				&& actanueva.getDocumentoHecho().getTipoDocumento() != null
				&& actanueva.getDocumentoHecho().getTipoDocumento().getTdnombre() != null) {
			where.append(" AND UPPER(t1.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getDocumentoHecho().getTipoDocumento().getTdnombre().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getDocumentoHecho().getTipoDocumento().getTdnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TDNOMBRE IS NOT NULL");
		}
		if (actanueva != null && actanueva.getDocumentoHecho() != null
				&& actanueva.getDocumentoHecho().getTipoDocumento() != null
				&& actanueva.getDocumentoHecho().getTipoDocumento().getTdnombree() != null) {
			where.append(" AND UPPER(t1.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actanueva.getDocumentoHecho().getTipoDocumento().getTdnombree().toUpperCase() + "%");
			} else {
				params.add("%" + actanueva.getDocumentoHecho().getTipoDocumento().getTdnombree().toUpperCase() + "%");
			}
			where.append(" AND t1.TDNOMBREE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
