package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ActaNueva;

/**
 * ActaNuevaDao  
 * 
 *  
 */

public interface ActaNuevaDao {

	/**
	 * Inserts a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva add(ActaNueva actanueva);

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva update(ActaNueva actanueva);

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateProceedingsIdPlatea(ActaNueva actanueva);

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateReiniciada(ActaNueva actanueva);

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateEliminadaMiCarpeta(ActaNueva actanueva);

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva updateCodigoActa(ActaNueva actanueva);

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva find(ActaNueva actanueva);

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * 
	 * @return ActaNueva
	 */
	public ActaNueva findUltimoActaTramitadaLigadaAProtocolo(ActaNueva actanueva);

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	public ActaNueva findByAncodac(ActaNueva actanueva);

	/**
	 * Finds an Num Muestra
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return String
	 */
	public String findNumMuestra(ActaNueva actanueva);

	/**
	 * Finds an Cod Acta
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return String
	 */
	public String findCodActa(ActaNueva actanueva);

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return ActaNueva
	 */
	public ActaNueva findProceedingsIdPlatea(ActaNueva actanueva);

	/**
	 * Deletes a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return
	 */
	void remove(ActaNueva actanueva);

	/**
	 * Removes a single row in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            Pagination
	 * @return
	 */
	public void removeAllActasInspeccion(ActaNueva actanueva);

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ActaNueva> findAll(ActaNueva actanueva, Pagination pagination);

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaNueva> findAllActaTramitada(ActaNueva actanueva, Pagination pagination);

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return Long
	 */
	Long findAllCount(ActaNueva actanueva);

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return Long
	 */
	public Long findAllActaInmovilizacionTramitadaCount(ActaNueva actanueva);

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @return Long
	 */
	public Long findAllActaInfraccionProtocoloTramitadaCount(ActaNueva actanueva);

	/**
	 * Finds rows in the ActaNueva table using like.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ActaNueva> findAllLike(ActaNueva actanueva, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the ActaNueva table.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaNueva> findAllActaInfraccionTramitada(ActaNueva actanueva, Pagination pagination);

	/**
	 * Counts rows in the ActaNueva table using like.
	 * 
	 * @param actanueva
	 *            ActaNueva
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(ActaNueva actanueva, Boolean startsWith);
}
