package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.TramiteComun;

/**
 * ActaInfraccionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ActaInfraccionDaoImpl implements ActaInfraccionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ActaInfraccion> rwMap = new RowMapper<ActaInfraccion>() {
		public ActaInfraccion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ActaInfraccion(resultSet.getString("AICODIGO"),
					resultSet.getString("AICOAT"),
					resultSet.getString("AICOTTI"),
					resultSet.getString("AIINEXII"),
					resultSet.getString("AICOTP"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	public ActaInfraccion add(ActaInfraccion actainfraccion) {
		String query = "INSERT INTO ACTA_INFRACCION (AICODIGO, AICOAT, AICOTTI, AIINEXII, AICOTP) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, actainfraccion.getAicodigo(),
				actainfraccion.getAicoat(), actainfraccion.getAicotti(),
				actainfraccion.getAiinexii(), actainfraccion.getAicotp());
		return actainfraccion;
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	public ActaInfraccion update(ActaInfraccion actainfraccion) {
		String query = "UPDATE ACTA_INFRACCION SET AICOAT=?, AICOTTI=?, AIINEXII=? WHERE AICODIGO=?";
		this.jdbcTemplate.update(query, actainfraccion.getAicoat(),
				actainfraccion.getAicotti(), actainfraccion.getAiinexii(),
				actainfraccion.getAicodigo());
		return actainfraccion;
	}

	/**
	 * Finds a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	@Transactional(readOnly = true)
	public ActaInfraccion find(ActaInfraccion actainfraccion) {
		try {
			String query = "SELECT t1.AICODIGO AICODIGO, t1.AICOAT AICOAT, t1.AICOTTI AICOTTI, t1.AIINEXII AIINEXII, t1.AICOTP AICOTP FROM ACTA_INFRACCION t1  WHERE t1.AICODIGO = ?  ";

			List<ActaInfraccion> actainfraccionList = this.jdbcTemplate.query(
					query, this.rwMap, actainfraccion.getAicodigo());
			return (ActaInfraccion) DataAccessUtils
					.uniqueResult(actainfraccionList);
		} catch (EmptyResultDataAccessException e) {
			return new ActaInfraccion();
		}
	}

	/**
	 * Finds a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	@Transactional(readOnly = true)
	public ActaInfraccion findInfraccionProtocolo(ActaInfraccion actainfraccion) {
		try {
			String query = "SELECT t1.AICODIGO AICODIGO, t1.AICOAT AICOAT, t1.AICOTTI AICOTTI, t1.AIINEXII AIINEXII, t1.AICOTP AICOTP FROM ACTA_INFRACCION t1  WHERE t1.AICOAT = ? AND  t1.AICOTTI = ? AND ROWNUM=1";

			List<ActaInfraccion> actainfraccionList = this.jdbcTemplate.query(
					query, this.rwMap, actainfraccion.getAicoat(),
					actainfraccion.getAicotti());
			return (ActaInfraccion) DataAccessUtils
					.uniqueResult(actainfraccionList);
		} catch (EmptyResultDataAccessException e) {
			return new ActaInfraccion();
		}
	}

	/**
	 * Removes a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return
	 */
	public void remove(ActaInfraccion actainfraccion) {
		String query = "DELETE FROM ACTA_INFRACCION WHERE AICODIGO=?";
		this.jdbcTemplate.update(query, actainfraccion.getAicodigo());
	}

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfracciones(TramiteComun tramiteComun) {
		String query = "DELETE  FROM ACTA_INFRACCION " + " WHERE AICOAT=?";

		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfraccionesByProtocolo(TramiteComun tramiteComun,
			String tipProtocolo) {
		String query = "DELETE  FROM ACTA_INFRACCION WHERE AICOAT=? and AICOTP=?";

		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente(),
				tipProtocolo);
	}

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaInfraccion> findAll(ActaInfraccion actainfraccion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.AICODIGO AICODIGO,t1.AICOAT AICOAT,t1.AICOTTI AICOTTI,t1.AIINEXII AIINEXII, t1.AICOTP AICOTP ");
		query.append("FROM ACTA_INFRACCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actainfraccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ActaInfraccion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ActaInfraccion actainfraccion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTA_INFRACCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actainfraccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ActaInfraccion table using like.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaInfraccion> findAllLike(ActaInfraccion actainfraccion,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.AICODIGO AICODIGO,t1.AICOAT AICOAT,t1.AICOTTI AICOTTI,t1.AIINEXII AIINEXII, t1.AICOTP AICOTP ");
		query.append("FROM ACTA_INFRACCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actainfraccion,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ActaInfraccion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ActaInfraccion table using like.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ActaInfraccion actainfraccion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTA_INFRACCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actainfraccion,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ActaInfraccion entity
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ActaInfraccion actainfraccion) {

		StringBuilder where = new StringBuilder(
				ActaInfraccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actainfraccion != null && actainfraccion.getAicodigo() != null) {
			where.append(" AND t1.AICODIGO = ?");
			params.add(actainfraccion.getAicodigo());
		}
		if (actainfraccion != null && actainfraccion.getAicoat() != null) {
			where.append(" AND t1.AICOAT = ?");
			params.add(actainfraccion.getAicoat());
		}
		if (actainfraccion != null && actainfraccion.getAicotti() != null) {
			where.append(" AND t1.AICOTTI = ?");
			params.add(actainfraccion.getAicotti());
		}
		if (actainfraccion != null && actainfraccion.getAiinexii() != null) {
			where.append(" AND t1.AIINEXII = ?");
			params.add(actainfraccion.getAiinexii());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ActaInfraccion entity
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(ActaInfraccion actainfraccion,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ActaInfraccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actainfraccion != null && actainfraccion.getAicodigo() != null) {
			where.append(" AND UPPER(t1.AICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getAicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actainfraccion.getAicodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AICODIGO IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getAicoat() != null) {
			where.append(" AND UPPER(t1.AICOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getAicoat().toUpperCase() + "%");
			} else {
				params.add("%" + actainfraccion.getAicoat().toUpperCase() + "%");
			}
			where.append(" AND t1.AICOAT IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getAicotti() != null) {
			where.append(" AND UPPER(t1.AICOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getAicotti().toUpperCase() + "%");
			} else {
				params.add("%" + actainfraccion.getAicotti().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AICOTTI IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getAiinexii() != null) {
			where.append(" AND UPPER(t1.AIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getAiinexii().toUpperCase() + "%");
			} else {
				params.add("%" + actainfraccion.getAiinexii().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AIINEXII IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
