package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.TramiteComun;

/**
 * ActaInfraccionDao  
 * 
 *  
 */

public interface ActaInfraccionDao {

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfraccionesByProtocolo(TramiteComun tramiteComun,
			String tipProtocolo);

	/**
	 * Inserts a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	ActaInfraccion add(ActaInfraccion actainfraccion);

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	ActaInfraccion update(ActaInfraccion actainfraccion);

	/**
	 * Finds a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	ActaInfraccion find(ActaInfraccion actainfraccion);

	/**
	 * Finds a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	public ActaInfraccion findInfraccionProtocolo(ActaInfraccion actainfraccion);

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return
	 */
	void remove(ActaInfraccion actainfraccion);

	/**
	 * Deletes a single row in the ActaInfraccion table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfracciones(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ActaInfraccion> findAll(ActaInfraccion actainfraccion,
			Pagination pagination);

	/**
	 * Counts rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return Long
	 */
	Long findAllCount(ActaInfraccion actainfraccion);

	/**
	 * Finds rows in the ActaInfraccion table using like.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ActaInfraccion> findAllLike(ActaInfraccion actainfraccion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the ActaInfraccion table using like.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(ActaInfraccion actainfraccion, Boolean startsWith);
}
