package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.DetalleConstatacion;
import com.ejie.y41b.model.DetalleDocumentos;
import com.ejie.y41b.model.DetalleInfraccion;
import com.ejie.y41b.model.DetalleMuestra;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionMovilidad;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.ProtocoloInspeccion;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.Tramite;

/**
 * ActaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ActaDaoImpl implements ActaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Acta> rwMap = new RowMapper<Acta>() {
		public Acta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Acta(resultSet.getString("ACCODIGO"), resultSet.getString("ACCOOR"),
					resultSet.getString("ACCOMO"), resultSet.getString("ACNROR"), resultSet.getBigDecimal("ACNRAN"),
					resultSet.getString("ACCOINUN"), resultSet.getString("ACCOINDO"), resultSet.getDate("ACFELE"),
					resultSet.getDate("ACFERE"), resultSet.getString("ACCOES"), resultSet.getString("ACCOAV"),
					resultSet.getString("ACCOSE"), resultSet.getDate("ACFEEX"), resultSet.getString("ACINRE"),
					resultSet.getString("ACNOCO"), resultSet.getString("ACDNICO"), resultSet.getString("ACCOCO"),
					resultSet.getString("ACDIRCO"), resultSet.getString("ACCOLOCO"), resultSet.getString("ACNRCPCO"),
					resultSet.getString("ACNRTFCO"), resultSet.getString("ACCOTD"), resultSet.getString("ACNORAPAISID"),
					resultSet.getString("ACNORAPAISNOMBRE"), resultSet.getString("ACNORAPROVINCIAID"),
					resultSet.getString("ACNOMBREPROVINCIA"), resultSet.getString("ACNORAMUNICIPIOID"),
					resultSet.getString("ACNOMBREMUNICIPIO"), resultSet.getString("ACNORALOCALIDADID"),
					resultSet.getString("ACNOMBRELOCALIDAD"), resultSet.getString("ACNORACALLEID"),
					resultSet.getString("ACNOMBRECALLE"), resultSet.getString("ACNORACPID"),
					resultSet.getString("ACNOMBRECP"), resultSet.getString("ACNORAPORTALID"),
					resultSet.getString("ACNOMBREPORTAL"), resultSet.getString("ACNOMBREPISO"),
					resultSet.getString("ACDIRECCIONNOCAPV"), resultSet.getString("ACAPE1CO"),
					resultSet.getString("ACAPE2CO"), resultSet.getString("ACCODEXPEDIENTEORIGEN"),
					resultSet.getString("ACCOORORIGEN"), null, null, null, null, null, null, null, null);
		}
	};

	private RowMapper<BusquedaInspeccion> rwMapBusquedaInspeccion = new RowMapper<BusquedaInspeccion>() {
		public BusquedaInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			BusquedaInspeccion busquedaInspeccion = new BusquedaInspeccion();

			busquedaInspeccion.setIskontsumobide(resultSet.getString("iskontsumobide"));
			busquedaInspeccion.setAtnror(resultSet.getString("atnror"));
			busquedaInspeccion.setAtcodigo(resultSet.getString("atcodigo"));
			busquedaInspeccion.setAccodigo(resultSet.getString("accodigo"));
			busquedaInspeccion.setAccoor(resultSet.getString("accoor"));
			busquedaInspeccion.setAcnror(resultSet.getString("acnror"));
			busquedaInspeccion.setAcnran(resultSet.getString("acnran"));
			busquedaInspeccion.setAcfere(resultSet.getString("acfere"));
			busquedaInspeccion.setMonombre(resultSet.getString("monombre"));
			busquedaInspeccion.setAtnoprse(resultSet.getString("atnoprse"));
			busquedaInspeccion.setAtnomaps(resultSet.getString("atnomaps"));
			busquedaInspeccion.setAtnomops(resultSet.getString("atnomops"));
			busquedaInspeccion.setAtnrlops(resultSet.getString("atnrlops"));

			busquedaInspeccion.setAttipo(resultSet.getString("ATTIPO"));

			busquedaInspeccion.setAtcocm(resultSet.getString("atcocm"));
			busquedaInspeccion.setAtcohd(resultSet.getString("atcohd"));
			busquedaInspeccion.setAtcohddenuncia(resultSet.getString("ATCOHDDENUNCIA"));
			busquedaInspeccion.setAtcoal(resultSet.getString("atcoal"));
			busquedaInspeccion.setAtidcomunicacionsoivre(resultSet.getString("atidcomunicacionsoivre"));

			busquedaInspeccion.setHdnror(resultSet.getString("hdnror"));
			busquedaInspeccion.setDecoor(resultSet.getString("decoor"));
			busquedaInspeccion.setDenran(resultSet.getString("denran"));
			busquedaInspeccion.setDenror(resultSet.getString("denror"));
			busquedaInspeccion.setV6codigo(resultSet.getString("v6codigo"));
			busquedaInspeccion.setAlnror(resultSet.getString("alnror"));
			busquedaInspeccion.setAlnran(resultSet.getString("alnran"));

			busquedaInspeccion.setDenombre(resultSet.getString("denombre"));
			busquedaInspeccion.setDenombree(resultSet.getString("denombree"));

			busquedaInspeccion.setFnombre(resultSet.getString("fnombre"));
			busquedaInspeccion.setFnombree(resultSet.getString("fnombree"));

			busquedaInspeccion.setTrnombre(resultSet.getString("trnombre"));
			busquedaInspeccion.setTrnombree(resultSet.getString("trnombree"));

			busquedaInspeccion.setTrnombre(resultSet.getString("trnombre"));
			busquedaInspeccion.setTrnombree(resultSet.getString("trnombree"));

			busquedaInspeccion.setRpnombre(resultSet.getString("rpnombre"));
			busquedaInspeccion.setRpnoco(resultSet.getString("rpnoco"));
			busquedaInspeccion.setEsnombre(resultSet.getString("esnombre"));
			busquedaInspeccion.setEsnoco(resultSet.getString("esnoco"));

			busquedaInspeccion.setAtcoes(resultSet.getString("atcoes"));
			busquedaInspeccion.setAccoes(resultSet.getString("accoes"));

			busquedaInspeccion.setEsmunicipio(resultSet.getString("esmunicipio"));

			busquedaInspeccion.setActiororigen(resultSet.getString("ACTIORORIGEN"));

			busquedaInspeccion.setAtuinmovilizadas(resultSet.getBigDecimal("ATUINMOVILIZADAS"));
			busquedaInspeccion.setAtudestruidas(resultSet.getBigDecimal("ATUDESTRUIDAS"));
			busquedaInspeccion.setAtudevolucionorigen(resultSet.getBigDecimal("ATUDEVOLUCIONORIGEN"));
			busquedaInspeccion.setAtulibrecomercializacion(resultSet.getBigDecimal("ATULIBRECOMERCIALIZACION"));
			busquedaInspeccion.setAtuotros(resultSet.getBigDecimal("ATUOTROS"));
			busquedaInspeccion.setAtutomamuestras(resultSet.getBigDecimal("ATUTOMAMUESTRAS"));

			busquedaInspeccion.setNumProdsEncontrados(resultSet.getBigDecimal("NUMPRODSENCONTRADOS"));

			busquedaInspeccion.setAtadicional(resultSet.getString("ATADICIONAL"));

			return busquedaInspeccion;
		}
	};

	private RowMapper<BusquedaInspeccion> rwMapBusquedaInspeccionBandeja = new RowMapper<BusquedaInspeccion>() {
		public BusquedaInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			BusquedaInspeccion busquedaInspeccion = new BusquedaInspeccion();

			busquedaInspeccion.setAccodigo(resultSet.getString("accodigo"));
			busquedaInspeccion.setAtcodigo(resultSet.getString("atcodigo"));
			busquedaInspeccion.setIskontsumobide(resultSet.getString("iskontsumobide"));
			busquedaInspeccion.setAdcoor(resultSet.getString("adcoor"));
			busquedaInspeccion.setAcnror(resultSet.getString("acnror"));
			busquedaInspeccion.setAcnran(resultSet.getString("acnran"));

			busquedaInspeccion.setAtcocm(resultSet.getString("atcocm"));
			busquedaInspeccion.setV6codigo(resultSet.getString("v6codigo"));

			busquedaInspeccion.setDecoor(resultSet.getString("decoor"));
			busquedaInspeccion.setDenror(resultSet.getString("denror"));
			busquedaInspeccion.setDenran(resultSet.getString("denran"));

			busquedaInspeccion.setAlnror(resultSet.getString("alnror"));
			busquedaInspeccion.setAlnran(resultSet.getString("alnran"));

			busquedaInspeccion.setAtnoprse(resultSet.getString("atnoprse"));
			busquedaInspeccion.setAtnomaps(resultSet.getString("atnomaps"));
			busquedaInspeccion.setAtnomops(resultSet.getString("atnomops"));
			busquedaInspeccion.setAtnrlops(resultSet.getString("atnrlops"));

			busquedaInspeccion.setEsnombre(resultSet.getString("esnombre"));
			busquedaInspeccion.setMonombre(resultSet.getString("monombre"));

			busquedaInspeccion.setAcfere(resultSet.getString("acfere"));
			busquedaInspeccion.setAtfefin(resultSet.getString("atfefin"));

			return busquedaInspeccion;
		}
	};

	private RowMapper<Acta> rwMapVisita = new RowMapper<Acta>() {
		public Acta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(resultSet.getString("ESNIF"));
			establecimiento.setEsnombre(resultSet.getString("ESNOMBRE"));
			establecimiento.setEsnoco(resultSet.getString("ESNOCO"));
			establecimiento.setEsnombreCalle(resultSet.getString("ESNOMBRE_CALLE"));
			establecimiento.setEsnolo(resultSet.getString("ESNOMBRE_LOCALIDAD"));
			establecimiento.setEsnombreMunicipio(resultSet.getString("ESNOMBRE_MUNICIPIO"));

			establecimiento.setEsnoco(resultSet.getString("ESNOCO"));

			return new Acta(resultSet.getString("ACCODIGO"), resultSet.getString("ACCOMO"),
					resultSet.getString("ACCOOR"), resultSet.getString("ACNROR"), resultSet.getBigDecimal("ACNRAN"),
					resultSet.getString("ACCOINUN"), resultSet.getString("ACCOINDO"), resultSet.getDate("ACFELE"),
					resultSet.getDate("ACFERE"), resultSet.getString("ACCOES"), resultSet.getString("ACCOAV"),
					resultSet.getString("ACCOSE"), resultSet.getDate("ACFEEX"), resultSet.getString("ACINRE"),
					resultSet.getString("ACNOCO"), resultSet.getString("ACDNICO"), resultSet.getString("ACCOCO"),
					resultSet.getString("ACDIRCO"), resultSet.getString("ACCOLOCO"), resultSet.getString("ACNRCPCO"),
					resultSet.getString("ACNRTFCO"), resultSet.getString("ACCOTD"), resultSet.getString("ACNORAPAISID"),
					resultSet.getString("ACNORAPAISNOMBRE"), resultSet.getString("ACNORAPROVINCIAID"),
					resultSet.getString("ACNOMBREPROVINCIA"), resultSet.getString("ACNORAMUNICIPIOID"),
					resultSet.getString("ACNOMBREMUNICIPIO"), resultSet.getString("ACNORALOCALIDADID"),
					resultSet.getString("ACNOMBRELOCALIDAD"), resultSet.getString("ACNORACALLEID"),
					resultSet.getString("ACNOMBRECALLE"), resultSet.getString("ACNORACPID"),
					resultSet.getString("ACNOMBRECP"), resultSet.getString("ACNORAPORTALID"),
					resultSet.getString("ACNOMBREPORTAL"), resultSet.getString("ACNOMBREPISO"),
					resultSet.getString("ACDIRECCIONNOCAPV"), resultSet.getString("ACAPE1CO"),
					resultSet.getString("ACAPE2CO"), resultSet.getString("ACCODEXPEDIENTEORIGEN"),
					resultSet.getString("ACCOORORIGEN"), establecimiento, null, null, null,
					resultSet.getString("SENOMBRE"), resultSet.getString("AVNOMBRE"), resultSet.getString("MONOMBRE1"),
					resultSet.getString("MONOMBRE2"));
		}
	};

	private RowMapper<Acta> rwMapActuacion = new RowMapper<Acta>() {
		public Acta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(resultSet.getString("ESNIF"));
			establecimiento.setEsnombre(resultSet.getString("ESNOMBRE"));
			establecimiento.setEsnoco(resultSet.getString("ESNOCO"));
			establecimiento.setEsnodir(resultSet.getString("ESNODIR"));
			establecimiento.setEsnolo(resultSet.getString("ESNOMBRE_LOCALIDAD"));
			establecimiento.setEsnomu(resultSet.getString("ESNOMBRE_MUNICIPIO"));
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcotma(resultSet.getString("ATCOTMA"));
			actuacion.setAtnror(resultSet.getBigDecimal("ATNROR"));
			actuacion.setAtcotta(resultSet.getString("ATCOTTA"));
			actuacion.setAtcoav(resultSet.getString("ATCOAV"));
			actuacion.setAtcose(resultSet.getString("ATCOSE"));
			actuacion.setAtfedumi(resultSet.getDate("ATFEDUMI"));

			// producto
			actuacion.setAtnoprse(resultSet.getString("ATNOPRSE"));
			actuacion.setAtnomaps(resultSet.getString("ATNOMAPS"));
			actuacion.setAtnomops(resultSet.getString("ATNOMOPS"));
			actuacion.setAtnrlops(resultSet.getString("ATNRLOPS"));
			actuacion.setAtcops(resultSet.getString("ATCOPS"));
			actuacion.setAtfedumi(resultSet.getDate("ATFEDUMI"));
			actuacion.setPsnombre(resultSet.getString("PSNOMBRE"));

			return new Acta(resultSet.getString("ACCODIGO"), resultSet.getString("ACCOMO"),
					resultSet.getString("ACCOOR"), resultSet.getString("ACNROR"), resultSet.getBigDecimal("ACNRAN"),
					resultSet.getString("ACCOINUN"), resultSet.getString("ACCOINDO"), resultSet.getDate("ACFELE"),
					resultSet.getDate("ACFERE"), resultSet.getString("ACCOES"), resultSet.getString("ACCOAV"),
					resultSet.getString("ACCOSE"), resultSet.getDate("ACFEEX"), resultSet.getString("ACINRE"),
					resultSet.getString("ACNOCO"), resultSet.getString("ACDNICO"), resultSet.getString("ACCOCO"),
					resultSet.getString("ACDIRCO"), resultSet.getString("ACCOLOCO"), resultSet.getString("ACNRCPCO"),
					resultSet.getString("ACNRTFCO"), resultSet.getString("ACCOTD"), resultSet.getString("ACNORAPAISID"),
					resultSet.getString("ACNORAPAISNOMBRE"), resultSet.getString("ACNORAPROVINCIAID"),
					resultSet.getString("ACNOMBREPROVINCIA"), resultSet.getString("ACNORAMUNICIPIOID"),
					resultSet.getString("ACNOMBREMUNICIPIO"), resultSet.getString("ACNORALOCALIDADID"),
					resultSet.getString("ACNOMBRELOCALIDAD"), resultSet.getString("ACNORACALLEID"),
					resultSet.getString("ACNOMBRECALLE"), resultSet.getString("ACNORACPID"),
					resultSet.getString("ACNOMBRECP"), resultSet.getString("ACNORAPORTALID"),
					resultSet.getString("ACNOMBREPORTAL"), resultSet.getString("ACNOMBREPISO"),
					resultSet.getString("ACDIRECCIONNOCAPV"), resultSet.getString("ACAPE1CO"),
					resultSet.getString("ACAPE2CO"), resultSet.getString("ACCODEXPEDIENTEORIGEN"),
					resultSet.getString("ACCOORORIGEN"), establecimiento, null, actuacion, null,
					resultSet.getString("SENOMBRE"), resultSet.getString("AVNOMBRE"), null, null);
		}
	};

	private RowMapper<DetalleConstatacion> rwMapConstatacion = new RowMapper<DetalleConstatacion>() {
		public DetalleConstatacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			DetalleConstatacion detalleConstatacion = new DetalleConstatacion();
			detalleConstatacion.setTticodigo(resultSet.getString("TTICODIGO"));
			detalleConstatacion.setTtinombre(resultSet.getString("TTINOMBRE"));
			detalleConstatacion.setAiinexii(resultSet.getString("AIINEXII"));
			return detalleConstatacion;
		}
	};

	private RowMapper<DetalleProtocolo> rwMapProtocolo = new RowMapper<DetalleProtocolo>() {
		public DetalleProtocolo mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DetalleProtocolo detalleProtocolo = new DetalleProtocolo();
			detalleProtocolo.setPtcoretp(resultSet.getString("PTCORETP"));
			detalleProtocolo.setTrrees(resultSet.getString("TRREES"));
			detalleProtocolo.setTrnrtipp(resultSet.getLong("TRNRTIPP"));
			detalleProtocolo.setTrdetipp(resultSet.getString("TRDETIPP"));
			detalleProtocolo.setAtcotp(resultSet.getString("TPNOMBRE"));
			try {
				detalleProtocolo.setPtcotr(resultSet.getString("PTCOTR"));
			} catch (Exception e) {

			}

			return detalleProtocolo;
		}
	};

	private RowMapper<DetalleDocumentos> rwMapDocumentos = new RowMapper<DetalleDocumentos>() {
		public DetalleDocumentos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			DetalleDocumentos detalleDocumentos = new DetalleDocumentos();
			detalleDocumentos.setZrobjeto(resultSet.getString("ZROBJETO"));
			detalleDocumentos.setZrdescri(resultSet.getString("ZRDESCRI"));

			return detalleDocumentos;
		}
	};

	private RowMapper<DetalleMuestra> rwMapMuestra = new RowMapper<DetalleMuestra>() {
		public DetalleMuestra mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DetalleMuestra detalleMuestra = new DetalleMuestra();
			detalleMuestra.setAnmrmu(resultSet.getString("ANNRMU"));
			detalleMuestra.setAnnran(resultSet.getString("ANNRAN"));
			detalleMuestra.setTomnombre(resultSet.getString("TOMNOMBRE"));
			detalleMuestra.setAnteestm(resultSet.getString("ANTEESTM"));
			detalleMuestra.setAncaptpm(resultSet.getString("ANCAPTPM"));
			detalleMuestra.setTctnombre(resultSet.getString("TCTNOMBRE"));
			detalleMuestra.setTdmnombre(resultSet.getString("TDMNOMBRE"));

			return detalleMuestra;
		}
	};

	private RowMapper<TipProtocolo> rwMapProtocoloInspeccion = new RowMapper<TipProtocolo>() {
		public TipProtocolo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipProtocolo(resultSet.getString("TPCODIGO"), resultSet.getString("TPNOMBRE"),
					resultSet.getString("TPCOTMO"), resultSet.getString("TPESTANDAR"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta add(Acta acta) {
		String query = "INSERT INTO ACTA (ACCODIGO, ACCOOR, ACNROR, ACNRAN, ACCOINUN, ACCOINDO, ACFELE, ACFERE, ACCOES, ACCOAV, ACCOSE, ACFEEX, ACINRE, ACNOCO, ACDNICO, ACCOCO, ACDIRCO, ACCOLOCO, ACNRCPCO, ACNRTFCO, ACCOTD, ACNORA_PAIS_ID, ACNORA_PAIS_NOMBRE, ACNORA_PROVINCIA_ID, ACNOMBRE_PROVINCIA, ACNORA_MUNICIPIO_ID, ACNOMBRE_MUNICIPIO, ACNORA_LOCALIDAD_ID, ACNOMBRE_LOCALIDAD, ACNORA_CALLE_ID, ACNOMBRE_CALLE, ACNORA_CP_ID, ACNOMBRE_CP, ACNORA_PORTAL_ID, ACNOMBRE_PORTAL, ACNOMBRE_PISO, ACDIRECCION_NOCAPV, ACAPE1CO, ACAPE2CO, ACCODEXPEDIENTEORIGEN, ACCOORORIGEN, ACTIORORIGEN, ACINCUMPLIMIENTO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, acta.getAccodigo(), acta.getAccoor(), acta.getAcnror(), acta.getAcnran(),
				acta.getAccoinun(), acta.getAccoindo(), acta.getAcfele(), acta.getAcfere(), acta.getAccoes(),
				acta.getAccoav(), acta.getAccose(), acta.getAcfeex(), acta.getAcinre(), acta.getAcnoco(),
				acta.getAcdnico(), acta.getAccoco(), acta.getAcdirco(), acta.getAccoloco(), acta.getAcnrcpco(),
				acta.getAcnrtfco(), acta.getAccotd(), acta.getAcnoraPaisId(), acta.getAcnoraPaisNombre(),
				acta.getAcnoraProvinciaId(), acta.getAcnombreProvincia(), acta.getAcnoraMunicipioId(),
				acta.getAcnombreMunicipio(), acta.getAcnoraLocalidadId(), acta.getAcnombreLocalidad(),
				acta.getAcnoraCalleId(), acta.getAcnombreCalle(), acta.getAcnoraCpId(), acta.getAcnombreCp(),
				acta.getAcnoraPortalId(), acta.getAcnombrePortal(), acta.getAcnombrePiso(), acta.getAcdireccionNocapv(),
				acta.getAcape1co(), acta.getAcape2co(), acta.getAccodexpedienteorigen(), acta.getAccoororigen(),
				acta.getActiororigen(), acta.getAcincumplimiento());
		return acta;
	}

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta addMasiva(Acta acta) {
		String query = "INSERT INTO ACTA (ACCODIGO, ACCOOR, ACNROR, ACNRAN, ACFERE, ACCOES) VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, acta.getAccodigo(), acta.getAccoor(), acta.getAcnror(), acta.getAcnran(),
				acta.getAcfere(), acta.getAccoes());
		return acta;
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta update(Acta acta) {
		String query = "UPDATE ACTA SET ACCOOR=?, ACNROR=?, ACNRAN=?, ACCOINUN=?, ACCOINDO=?, ACFELE=?, ACFERE=?, ACCOES=?, ACCOAV=?, ACCOSE=?, ACFEEX=?, ACINRE=?, ACNOCO=?, ACDNICO=?, ACCOCO=?, ACDIRCO=?, ACCOLOCO=?, ACNRCPCO=?, ACNRTFCO=?, ACCOTD=?, ACNORA_PAIS_ID=?, ACNORA_PAIS_NOMBRE=?, ACNORA_PROVINCIA_ID=?, ACNOMBRE_PROVINCIA=?, ACNORA_MUNICIPIO_ID=?, ACNOMBRE_MUNICIPIO=?, ACNORA_LOCALIDAD_ID=?, ACNOMBRE_LOCALIDAD=?, ACNORA_CALLE_ID=?, ACNOMBRE_CALLE=?, ACNORA_CP_ID=?, ACNOMBRE_CP=?, ACNORA_PORTAL_ID=?, ACNOMBRE_PORTAL=?, ACNOMBRE_PISO=?, ACDIRECCION_NOCAPV=?, ACAPE1CO=?, ACAPE2CO=?, ACCODEXPEDIENTEORIGEN=?, ACCOORORIGEN=?, ACTIORORIGEN=?, ACINCUMPLIMIENTO=? WHERE ACCODIGO=?";
		this.jdbcTemplate.update(query, acta.getAccoor(), acta.getAcnror(), acta.getAcnran(), acta.getAccoinun(),
				acta.getAccoindo(), acta.getAcfele(), acta.getAcfere(), acta.getAccoes(), acta.getAccoav(),
				acta.getAccose(), acta.getAcfeex(), acta.getAcinre(), acta.getAcnoco(), acta.getAcdnico(),
				acta.getAccoco(), acta.getAcdirco(), acta.getAccoloco(), acta.getAcnrcpco(), acta.getAcnrtfco(),
				acta.getAccotd(), acta.getAcnoraPaisId(), acta.getAcnoraPaisNombre(), acta.getAcnoraProvinciaId(),
				acta.getAcnombreProvincia(), acta.getAcnoraMunicipioId(), acta.getAcnombreMunicipio(),
				acta.getAcnoraLocalidadId(), acta.getAcnombreLocalidad(), acta.getAcnoraCalleId(),
				acta.getAcnombreCalle(), acta.getAcnoraCpId(), acta.getAcnombreCp(), acta.getAcnoraPortalId(),
				acta.getAcnombrePortal(), acta.getAcnombrePiso(), acta.getAcdireccionNocapv(), acta.getAcape1co(),
				acta.getAcape2co(), acta.getAccodexpedienteorigen(), acta.getAccoororigen(), acta.getActiororigen(),
				acta.getAcincumplimiento(), acta.getAccodigo());
		return acta;
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta updateNumExpediente(Acta acta) {
		String query = "UPDATE ACTA SET ACNROR=? WHERE ACCODIGO=?";
		this.jdbcTemplate.update(query, acta.getAcnror(), acta.getAccodigo());
		return acta;
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	@Transactional(readOnly = true)
	public Acta findVisita(Actuacion actuacion) {

		String query = "SELECT mo1.MONOMBRE MONOMBRE1,mo2.MONOMBRE MONOMBRE2, se.SENOMBRE SENOMBRE, av.AVNOMBRE, ev.ESNOCO ESNOCO,ev.ESNIF ESNIF, ev.ESNOMBRE ESNOMBRE, ev.ESNODIR ESNOMBRE_CALLE, ev.ESNOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, ev.ESNOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t1.ACCODIGO ACCODIGO, t1.ACCOMO ACCOMO, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ACCOINUN ACCOINUN, t1.ACCOINDO ACCOINDO, t1.ACFELE ACFELE, t1.ACFERE ACFERE, t1.ACCOES ACCOES, t1.ACCOAV ACCOAV, t1.ACCOSE ACCOSE, t1.ACFEEX ACFEEX, t1.ACINRE ACINRE, t1.ACNOCO ACNOCO, t1.ACDNICO ACDNICO, t1.ACCOCO ACCOCO, t1.ACDIRCO ACDIRCO, t1.ACCOLOCO ACCOLOCO, t1.ACNRCPCO ACNRCPCO, t1.ACNRTFCO ACNRTFCO, decode(t1.ACCOTD,'I','INFORME','A','ACTA') ACCOTD, t1.ACNORA_PAIS_ID ACNORAPAISID, t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE, t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID, t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA, t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID, t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO, t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID, t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD, t1.ACNORA_CALLE_ID ACNORACALLEID, t1.ACNOMBRE_CALLE ACNOMBRECALLE, t1.ACNORA_CP_ID ACNORACPID, t1.ACNOMBRE_CP ACNOMBRECP, t1.ACNORA_PORTAL_ID ACNORAPORTALID, t1.ACNOMBRE_PORTAL ACNOMBREPORTAL, t1.ACNOMBRE_PISO ACNOMBREPISO, t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV, t1.ACAPE1CO ACAPE1CO, t1.ACAPE2CO ACAPE2CO, t1.ACCODEXPEDIENTEORIGEN ACCODEXPEDIENTEORIGEN, t1.ACCOORORIGEN ACCOORORIGEN "
				+ "FROM ACTA t1, ACTUACION at,  " + "ESTABLECIMIENTO ev,  " + "SECTOR se,   " + "ACTIVIDAD av,   "
				+ "MONITOR mo1,   " + "MONITOR mo2   "
				+ "WHERE at.ATCODIGO = ? and t1.ACCOSE=se.SECODIGO(+) and t1.ACCOAV=av.AVCODIGO(+) and t1.ACCOINUN=mo1.MOCODIGO(+) and t1.ACCOINDO=mo2.MOCODIGO(+) and at.ATCOES = ev.ESCODIGO(+) and t1.ACCODIGO=at.ATCOAC(+) ";

		List<Acta> actaList = this.jdbcTemplate.query(query, this.rwMapVisita, actuacion.getAtcodigo());
		return (Acta) DataAccessUtils.uniqueResult(actaList);
	}

	@Override
	public DetalleMuestra findMuestra(Actuacion actuacion) {
		String query = "SELECT ANNRMU, ANNRAN, TOMNOMBRE, ANTEESTM, ANCAPTPM, TCTNOMBRE, TDMNOMBRE "
				+ "FROM ACTA t1, ACTUACION at,  " + "ANALISIS an,  " + "TIP_DEPO_MUESTRA tdm,  "
				+ "TIP_CARAC_MUESTRA tcm,  " + "ORI_PROD_ALERTA opa  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and an.ANCOAT= at.ATCODIGO(+) and an.ANCOTDM=tdm.TDMCODIGO and an.ANCOTCT=tcm.TCTCODIGO  and an.ANCOTOM = opa.TOMCODIGO ";

		List<DetalleMuestra> detalleList = this.jdbcTemplate.query(query, this.rwMapMuestra, actuacion.getAtcodigo());
		return (DetalleMuestra) DataAccessUtils.uniqueResult(detalleList);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	@Transactional(readOnly = true)
	public Acta findActuacion(Actuacion actuacion) {

		String query = "SELECT se.SENOMBRE SENOMBRE, av.AVNOMBRE,pr.PSNOMBRE PSNOMBRE, at.ATFEDUMI ATFEDUMI, at.ATCOPS ATCOPS,at.ATNRLOPS ATNRLOPS,at.ATNOMOPS ATNOMOPS,at.ATNOMAPS ATNOMAPS,at.ATNOPRSE ATNOPRSE,at.ATFEDUMI ATFEDUMI, at.ATCOSE ATCOSE, at.ATCOAV ATCOAV,tta.TTANOMBRE ATCOTTA, at.ATNROR ATNROR, tma.TMANOMBRE ATCOTMA, er.ESNIF ESNIF, er.ESNOMBRE ESNOMBRE, er.ESNODIR ESNODIR , er.ESNOCO ESNOCO, er.ESNOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, er.ESNOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO,pr.PSNOMBRE PSNOMBRE, at.ATFEDUMI ATFEDUMI,at.atcops atcops,at.ATNRLOPS ATNRLOPS, at.ATNOMOPS ATNOMOPS,at.ATNOMAPS ATNOMAPS, at.ATNOPRSE ATNOPRSE, t1.ACCODIGO ACCODIGO, t1.ACCOMO ACCOMO, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ACCOINUN ACCOINUN, t1.ACCOINDO ACCOINDO, t1.ACFELE ACFELE, t1.ACFERE ACFERE, t1.ACCOES ACCOES, t1.ACCOAV ACCOAV, t1.ACCOSE ACCOSE, t1.ACFEEX ACFEEX, t1.ACINRE ACINRE, t1.ACNOCO ACNOCO, t1.ACDNICO ACDNICO, t1.ACCOCO ACCOCO, t1.ACDIRCO ACDIRCO, t1.ACCOLOCO ACCOLOCO, t1.ACNRCPCO ACNRCPCO, t1.ACNRTFCO ACNRTFCO, t1.ACCOTD ACCOTD, t1.ACNORA_PAIS_ID ACNORAPAISID, t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE, t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID, t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA, t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID, t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO, t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID, t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD, t1.ACNORA_CALLE_ID ACNORACALLEID, t1.ACNOMBRE_CALLE ACNOMBRECALLE, t1.ACNORA_CP_ID ACNORACPID, t1.ACNOMBRE_CP ACNOMBRECP, t1.ACNORA_PORTAL_ID ACNORAPORTALID, t1.ACNOMBRE_PORTAL ACNOMBREPORTAL, t1.ACNOMBRE_PISO ACNOMBREPISO, t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV, t1.ACAPE1CO ACAPE1CO, t1.ACAPE2CO ACAPE2CO, t1.ACCODEXPEDIENTEORIGEN ACCODEXPEDIENTEORIGEN, t1.ACCOORORIGEN ACCOORORIGEN "
				+ "FROM ACTA t1, ACTUACION at,  " + "ESTABLECIMIENTO er,  " + "PRODUCTO pr,  " + "SECTOR se,  "
				+ "ACTIVIDAD av,  " + "TIPMOT_ACTUACION tma,  " + "TIP_ACTUACION tta  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and at.ATCOES = er.ESCODIGO(+) and at.ATCOPS = pr.PSCODIGO(+) and t1.ACCOSE=se.SECODIGO(+) and t1.ACCOAV=av.AVCODIGO(+) and at.ATCOTMA = tma.TMACODIGO(+) and at.ATCOTTA = tta.TTACODIGO(+) ";

		List<Acta> actaList = this.jdbcTemplate.query(query, this.rwMapActuacion, actuacion.getAtcodigo());
		return (Acta) DataAccessUtils.uniqueResult(actaList);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	@Transactional(readOnly = true)
	public List<DetalleConstatacion> findConstatacion(Actuacion actuacion, Pagination pagination) {

		StringBuilder query = new StringBuilder("SELECT TTICODIGO,TTINOMBRE,AIINEXII " + "FROM ACTA t1,ACTUACION at,  "
				+ "ACTA_INFRACCION ai,  " + "TIP_REQ_NORMATIVO trn  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and at.ATCODIGO = ai.AICOAT and trn.TTICODIGO = ai.AICOTTI (+)");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapConstatacion, actuacion.getAtcodigo());

	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findConstatacionCount(Actuacion actuacion) {

		String query = "SELECT count(8) " + "FROM ACTA t1, ACTUACION at, " + "ACTA_INFRACCION ai,  "
				+ "TIP_REQ_NORMATIVO trn  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and at.ATCODIGO = ai.AICOAT and trn.TTICODIGO = ai.AICOTTI (+) ";

		return this.jdbcTemplate.queryForLong(query, actuacion.getAtcodigo());
	}

	/**
	 * Finds a in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */

	@Transactional(readOnly = true)
	public List<DetalleProtocolo> findProtocolo(Actuacion actuacion, Pagination pagination) {

		StringBuilder query = new StringBuilder("SELECT PTCORETP,TRNRTIPP,TRREES, TRDETIPP,TPNOMBRE "
				+ "FROM ACTA t1, ACTUACION at,  " + "PROTOCOLO pr,  " + "TIP_PREG_PROTOC tpp,  " + "TIP_PROTOCOLO tp  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and  at.ATCODIGO = pr.PTCOAT and pr.ptcotr = tpp.trcodigo and at.atcotp = tp.TPCODIGO ");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapProtocolo, actuacion.getAtcodigo());

	}

	/**
	 * Finds a documentos in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleDocumentos>
	 */

	@Transactional(readOnly = true)
	public List<DetalleDocumentos> findDocumentos(Actuacion actuacion, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT ZROBJETO, ZRDESCRI " + "FROM ACTA t1, ACTUACION at,  " + "ENLACESDOCUMENTO ed  "
						+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and  t1.ACCODIGO = ed.ZRVCAMPO ");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapDocumentos, actuacion.getAtcodigo());

	}

	/**
	 * Finds a in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */

	@Transactional(readOnly = true)
	public List<DetalleProtocolo> findProtocolo(Actuacion actuacion, TipProtocolo tipProtocolo, Pagination pagination) {

		StringBuilder query = new StringBuilder("SELECT PTCORETP,TRNRTIPP,TRREES, TRDETIPP,TPNOMBRE,PTCOTR "
				+ "FROM TIP_PREG_PROTOC tpp,  " + "PROTOCOLO pr,  " + "TIP_PROTOCOLO tp  "
				+ "WHERE pr.PTCOAT = ?  and pr.ptcotr = tpp.trcodigo and tp.tpcodigo = tpp.trcotp ");

		List<Object> params = new ArrayList<Object>();
		params.add(actuacion.getAtcodigo());

		if (tipProtocolo != null && tipProtocolo.getTpcodigo() != null && !tipProtocolo.getTpcodigo().equals("")) {
			query.append(" and tp.TPCODIGO= ?");
			params.add(tipProtocolo.getTpcodigo());
		}

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapProtocolo, params.toArray());

	}

	/**
	 * Finds a in the Protocolo Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List<DetalleProtocolo>
	 */

	@Transactional(readOnly = true)
	public DetalleProtocolo findRespuestaPreguntaProtocolo(Actuacion actuacion, TipPregProtoc tipPregProtoc) {

		StringBuilder query = new StringBuilder("SELECT PTCORETP,TRNRTIPP,TRREES, TRDETIPP,TPNOMBRE,PTCOTR "
				+ "FROM TIP_PREG_PROTOC tpp,  " + "PROTOCOLO pr,  " + "TIP_PROTOCOLO tp  "
				+ "WHERE pr.PTCOAT = ?  and pr.ptcotr = tpp.trcodigo and tp.tpcodigo = tpp.trcotp and pr.PTCOTR = ? ");

		List<Object> params = new ArrayList<Object>();
		params.add(actuacion.getAtcodigo());
		params.add(tipPregProtoc.getTrcodigo());

		List<DetalleProtocolo> detalleProtocoloList = this.jdbcTemplate.query(query.toString(), this.rwMapProtocolo,
				params.toArray());

		return (DetalleProtocolo) DataAccessUtils.uniqueResult(detalleProtocoloList);
	}

	/**
	 * Finds a num of documentos in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findDocumentosCount(Actuacion actuacion) {

		String query = "SELECT count(8) " + "FROM ACTA t1, ACTUACION at,  " + "ENLACESDOCUMENTO ed  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and  at.ATCODIGO = ed.ZRVCAMPO ";

		return this.jdbcTemplate.queryForLong(query, actuacion.getAtcodigo());

	}

	/**
	 * Finds a num of protocol in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findProtocoloCount(Actuacion actuacion) {

		String query = "SELECT count(8) " + "FROM ACTA t1, ACTUACION at, " + "PROTOCOLO pr,  "
				+ "TIP_PREG_PROTOC tpp,  " + "TIP_PROTOCOLO tp  "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO (+) and at.ATCODIGO = pr.PTCOAT and pr.ptcotr = tpp.trcodigo and at.atcotp = tp.TPCODIGO "
				+ "ORDER BY TRNRTIPP ASC";

		return this.jdbcTemplate.queryForLong(query, actuacion.getAtcodigo());

	}

	/**
	 * Finds numero de expediente.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findNumExpediente(Actuacion actuacion) {

		String query = "SELECT  accoor || '-' || acnror || '-' || acnran || '-' || atnror "
				+ "FROM ACTA t1, ACTUACION at " + "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO (+) ";

		return this.jdbcTemplate.queryForObject(query, new Object[] { actuacion.getAtcodigo() }, String.class);

	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	@Transactional(readOnly = true)
	public List<DetalleInfraccion> findInfracciones(Actuacion actuacion, Pagination pagination) {

		StringBuilder query = new StringBuilder("SELECT distinct TTICODIGO,TTINOMBRE,TTINOMBREE,TTINOMBREI "
				+ "FROM ACTA t1, ACTUACION at,  " + "ACTA_INFRACCION ai,  " + "TIP_REQ_NORMATIVO trn "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and at.ATCODIGO = ai.AICOAT and ai.aicotti=trn.tticodigo");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), new RowMapper<DetalleInfraccion>() {
			public DetalleInfraccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				DetalleInfraccion detalleInfraccion = new DetalleInfraccion();
				detalleInfraccion.setTticodigo(resultSet.getString("tticodigo"));
				detalleInfraccion.setTtinombre(resultSet.getString("ttinombre"));
				detalleInfraccion.setTtinombree(resultSet.getString("ttinombree"));
				detalleInfraccion.setTtinombrei(resultSet.getString("ttinombrei"));

				return detalleInfraccion;
			}
		}, actuacion.getAtcodigo());

	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findInfraccionesCount(Actuacion actuacion) {

		StringBuilder query = new StringBuilder(" SELECT COUNT(*) FROM (SELECT distinct TTICODIGO,TTINOMBRE "
				+ "FROM ACTA t1, ACTUACION at,  " + "ACTA_INFRACCION ai,  " + "TIP_REQ_NORMATIVO trn "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and at.ATCODIGO = ai.AICOAT and ai.aicotti=trn.tticodigo)");

		return this.jdbcTemplate.queryForLong(query.toString(), actuacion.getAtcodigo());
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findInfraccionesProtocoloCount(Actuacion actuacion) {

		StringBuilder query = new StringBuilder(" SELECT COUNT(*) FROM (SELECT distinct TTICODIGO,TTINOMBRE "
				+ "FROM ACTA t1, ACTUACION at,  " + "ACTA_INFRACCION ai,  " + "TIP_REQ_NORMATIVO trn "
				+ "WHERE at.ATCODIGO = ? and at.ATCOAC=t1.ACCODIGO(+) and at.ATCODIGO = ai.AICOAT and ai.aicotti=trn.tticodigo and ai.aicotp is not null)");

		return this.jdbcTemplate.queryForLong(query.toString(), actuacion.getAtcodigo());
	}

	/**
	 * Removes a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return
	 */
	public void remove(Acta acta) {
		String query = "DELETE FROM ACTA WHERE ACCODIGO=?";
		this.jdbcTemplate.update(query, acta.getAccodigo());
	}

	/**
	 * Removes a single row in the Acta table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return
	 */
	public void removeActaExpediente(InspeccionDetalle inspeccionDetalle) {
		String query = "DELETE  FROM ACTA WHERE ACCODIGO =  ? ";
		this.jdbcTemplate.update(query, inspeccionDetalle.getAccodigo());
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	@Transactional(readOnly = true)
	public Acta find(Acta acta) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ACCODIGO ACCODIGO,t1.ACCOMO ACCOMO,t1.ACCOOR ACCOOR,t1.ACNROR ACNROR,t1.ACNRAN ACNRAN,t2.ATNROR ATNROR,t1.ACCOINUN ACCOINUN,t1.ACCOINDO ACCOINDO,t1.ACFELE ACFELE,t1.ACFERE ACFERE,t1.ACCOES ACCOES,t1.ACCOAV ACCOAV,t1.ACCOSE ACCOSE,t1.ACFEEX ACFEEX,t1.ACINRE ACINRE,t1.ACNOCO ACNOCO,t1.ACDNICO ACDNICO,t1.ACCOCO ACCOCO,t1.ACDIRCO ACDIRCO,t1.ACCOLOCO ACCOLOCO,t1.ACNRCPCO ACNRCPCO,t1.ACNRTFCO ACNRTFCO,t1.ACCOTD ACCOTD,t1.ACNORA_PAIS_ID ACNORAPAISID,t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE,t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID,t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA,t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID,t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO,t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID,t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD,t1.ACNORA_CALLE_ID ACNORACALLEID,t1.ACNOMBRE_CALLE ACNOMBRECALLE,t1.ACNORA_CP_ID ACNORACPID,t1.ACNOMBRE_CP ACNOMBRECP,t1.ACNORA_PORTAL_ID ACNORAPORTALID,t1.ACNOMBRE_PORTAL ACNOMBREPORTAL,t1.ACNOMBRE_PISO ACNOMBREPISO,t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV,t1.ACAPE1CO ACAPE1CO,t1.ACAPE2CO ACAPE2CO,t1.ACCODEXPEDIENTEORIGEN ACCODEXPEDIENTEORIGEN,t1.ACCOORORIGEN ACCOORORIGEN ");
		query.append("FROM ACTA t1, ACTUACION t2 WHERE t1.ACCODIGO = t2.ATCOAC AND t1.ACCODIGO = ?");

		List<Acta> actaList = this.jdbcTemplate.query(query.toString(), this.rwMap, acta.getAccodigo());
		return (Acta) DataAccessUtils.uniqueResult(actaList);
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Acta> findAll(Acta acta, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ACCODIGO ACCODIGO,t1.ACCOMO ACCOMO,t1.ACCOOR ACCOOR,t1.ACNROR ACNROR,t1.ACNRAN ACNRAN,t1.ACCOINUN ACCOINUN,t1.ACCOINDO ACCOINDO,t1.ACFELE ACFELE,t1.ACFERE ACFERE,t1.ACCOES ACCOES,t1.ACCOAV ACCOAV,t1.ACCOSE ACCOSE,t1.ACFEEX ACFEEX,t1.ACINRE ACINRE,t1.ACNOCO ACNOCO,t1.ACDNICO ACDNICO,t1.ACCOCO ACCOCO,t1.ACDIRCO ACDIRCO,t1.ACCOLOCO ACCOLOCO,t1.ACNRCPCO ACNRCPCO,t1.ACNRTFCO ACNRTFCO,t1.ACCOTD ACCOTD,t1.ACNORA_PAIS_ID ACNORAPAISID,t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE,t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID,t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA,t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID,t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO,t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID,t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD,t1.ACNORA_CALLE_ID ACNORACALLEID,t1.ACNOMBRE_CALLE ACNOMBRECALLE,t1.ACNORA_CP_ID ACNORACPID,t1.ACNOMBRE_CP ACNOMBRECP,t1.ACNORA_PORTAL_ID ACNORAPORTALID,t1.ACNOMBRE_PORTAL ACNOMBREPORTAL,t1.ACNOMBRE_PISO ACNOMBREPISO,t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV,t1.ACAPE1CO ACAPE1CO,t1.ACAPE2CO ACAPE2CO,t1.ACCODEXPEDIENTEORIGEN ACCODEXPEDIENTEORIGEN,t1.ACCOORORIGEN ACCOORORIGEN ");
		query.append("FROM ACTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(acta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Acta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta updateEstablecimiento(Acta acta) {
		String query = "UPDATE ACTA SET ACCOES=? WHERE ACCODIGO=?";

		Object getEstablecimientoEscodigoAux = null;
		if (acta.getEstablecimiento() != null && acta.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = acta.getEstablecimiento().getEscodigo();
		}
		this.jdbcTemplate.update(query, getEstablecimientoEscodigoAux, acta.getAccodigo());
		return acta;
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Acta acta) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ACTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(acta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Acta> findAllLike(Acta acta, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ACCODIGO ACCODIGO,t1.ACCOMO ACCOMO,t1.ACCOOR ACCOOR,t1.ACNROR ACNROR,t1.ACNRAN ACNRAN,t1.ACCOINUN ACCOINUN,t1.ACCOINDO ACCOINDO,t1.ACFELE ACFELE,t1.ACFERE ACFERE,t1.ACCOES ACCOES,t1.ACCOAV ACCOAV,t1.ACCOSE ACCOSE,t1.ACFEEX ACFEEX,t1.ACINRE ACINRE,t1.ACNOCO ACNOCO,t1.ACDNICO ACDNICO,t1.ACCOCO ACCOCO,t1.ACDIRCO ACDIRCO,t1.ACCOLOCO ACCOLOCO,t1.ACNRCPCO ACNRCPCO,t1.ACNRTFCO ACNRTFCO,t1.ACCOTD ACCOTD,t1.ACNORA_PAIS_ID ACNORAPAISID,t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE,t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID,t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA,t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID,t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO,t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID,t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD,t1.ACNORA_CALLE_ID ACNORACALLEID,t1.ACNOMBRE_CALLE ACNOMBRECALLE,t1.ACNORA_CP_ID ACNORACPID,t1.ACNOMBRE_CP ACNOMBRECP,t1.ACNORA_PORTAL_ID ACNORAPORTALID,t1.ACNOMBRE_PORTAL ACNOMBREPORTAL,t1.ACNOMBRE_PISO ACNOMBREPISO,t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV,t1.ACAPE1CO ACAPE1CO,t1.ACAPE2CO ACAPE2CO,t1.ACCODEXPEDIENTEORIGEN ACCODEXPEDIENTEORIGEN,t1.ACCOORORIGEN ACCOORORIGEN ");
		query.append("FROM ACTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(acta, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Acta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BusquedaInspeccion> findAllActaLike(Acta acta, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t2.ISKONTSUMOBIDE ISKONTSUMOBIDE, t2.ATNROR ATNROR, t1.ACCODIGO ACCODIGO, t1.ACTIORORIGEN ACTIORORIGEN, t2.ATCODIGO ATCODIGO, t2.ATTIPO ATTIPO, t7.HDNROR HDNROR, t10.DECOOR DECOOR, t10.DENRAN DENRAN, t10.DENROR DENROR, t9.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t9.V6CODIGO V6CODIGO, t8.ALNROR ALNROR, t8.ALNRAN ALNRAN, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, TO_CHAR(t1.ACFERE,'DD/MM/YYYY') ACFERE, t6.MONOMBRE MONOMBRE, t2.ATNOPRSE ATNOPRSE, t2.ATNOMAPS ATNOMAPS, t2.ATNOMOPS ATNOMOPS, t2.ATNRLOPS ATNRLOPS, t2.ATCOCM ATCOCM, t2.ATCOHD ATCOHD, t2.ATCOHDDENUNCIA ATCOHDDENUNCIA, t2.ATCOAL ATCOAL, t2.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t11.FNOMBRE FNOMBRE, t11.FNOMBREE FNOMBREE, t13.DENOMBRE DENOMBRE, t13.DENOMBREE DENOMBREE, t14.TRNOMBRE TRNOMBRE, t14.TRNOMBREE TRNOMBREE, t15.NOMBRE RPNOMBRE, t15.ESNOCO RPNOCO, t16.NOMBRE ESNOMBRE, t16.NOMBRE_MUNICIPIO ESMUNICIPIO, t16.ESNOCO ESNOCO, t1.ACCOES, t2.ATCOES, NVL(t2.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t2.ATUDESTRUIDAS,0) ATUDESTRUIDAS,NVL(t2.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t2.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t2.ATUOTROS,0) ATUOTROS, NVL(t2.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN t2.ATCOCM is not null THEN t2.ATCOCM WHEN t2.ATCOAL is not null THEN (SELECT ALNROR || '-' || ALNRAN FROM ALERTA t1a WHERE t2.ATCOAL = t1a.ALCODIGO) WHEN t2.ATIDCOMUNICACIONSOIVRE is not null THEN (SELECT V6CODIGO FROM COMUNICACION_SOIVRE t2a WHERE t2.ATIDCOMUNICACIONSOIVRE = t2a.IDCOMUNICACIONSOIVRE) WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is not null THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t2.ATCOHD = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is null THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t2.ATCOHD = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) ELSE null END) ORIGEN, (CASE WHEN t2.ATCOCM is not null THEN 'C' WHEN t2.ATCOAL is not null THEN 'A' WHEN t2.ATIDCOMUNICACIONSOIVRE is not null THEN 'S' WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is not null THEN 'D' WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is null THEN 'E' WHEN t1.ACTIORORIGEN = 'C' THEN 'X' WHEN t1.ACTIORORIGEN = 'N' THEN 'N' ELSE 'O' END) TIPOORIGEN, (NVL(t2.ATUINMOVILIZADAS,0) + NVL(t2.ATURECUPERADAS,0)) NUMPRODSENCONTRADOS, t2.ATADICIONAL ATADICIONAL ");
		query.append(
				"FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14, INTERVINIENTES t15, INTERVINIENTES t16 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActaLikeMap(acta);
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t1.ACCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t7.HDCODE = t10.DECODIGO (+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) AND t15.TIPO_INTERVINIENTE(+) = 'R' AND t2.ATCODIGO = t15.HDCODIGO(+) AND t16.TIPO_INTERVINIENTE(+) = 'V' AND t2.ATCODIGO = t16.HDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BusquedaInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMapBusquedaInspeccion,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BusquedaInspeccion> findAllInspeccionesAbiertasInstructor(Acta acta, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t2.ISKONTSUMOBIDE ISKONTSUMOBIDE, t2.ATNROR ATNROR, t1.ACCODIGO ACCODIGO, t1.ACTIORORIGEN ACTIORORIGEN, t2.ATCODIGO ATCODIGO, t2.ATTIPO ATTIPO, t7.HDNROR HDNROR, t10.DECOOR DECOOR, t10.DENRAN DENRAN, t10.DENROR DENROR, t9.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t9.V6CODIGO V6CODIGO, t8.ALNROR ALNROR, t8.ALNRAN ALNRAN, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, TO_CHAR(t1.ACFERE,'DD/MM/YYYY') ACFERE, t6.MONOMBRE MONOMBRE, t2.ATNOPRSE ATNOPRSE, t2.ATNOMAPS ATNOMAPS, t2.ATNOMOPS ATNOMOPS, t2.ATNRLOPS ATNRLOPS, t2.ATCOCM ATCOCM, t2.ATCOHD ATCOHD, t2.ATCOHDDENUNCIA ATCOHDDENUNCIA, t2.ATCOAL ATCOAL, t2.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t11.FNOMBRE FNOMBRE, t11.FNOMBREE FNOMBREE, t13.DENOMBRE DENOMBRE, t13.DENOMBREE DENOMBREE, t14.TRNOMBRE TRNOMBRE, t14.TRNOMBREE TRNOMBREE, t15.NOMBRE RPNOMBRE, t15.ESNOCO RPNOCO, t16.NOMBRE ESNOMBRE, t16.NOMBRE_MUNICIPIO ESMUNICIPIO, t16.ESNOCO ESNOCO, t1.ACCOES, t2.ATCOES, NVL(t2.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t2.ATUDESTRUIDAS,0) ATUDESTRUIDAS,NVL(t2.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t2.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t2.ATUOTROS,0) ATUOTROS, NVL(t2.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN t2.ATCOCM is not null THEN t2.ATCOCM WHEN t2.ATCOAL is not null THEN (SELECT ALNROR || '-' || ALNRAN FROM ALERTA t1a WHERE t2.ATCOAL = t1a.ALCODIGO) WHEN t2.ATIDCOMUNICACIONSOIVRE is not null THEN (SELECT V6CODIGO FROM COMUNICACION_SOIVRE t2a WHERE t2.ATIDCOMUNICACIONSOIVRE = t2a.IDCOMUNICACIONSOIVRE) WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is not null THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t2.ATCOHD = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is null THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t2.ATCOHD = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) ELSE null END) ORIGEN, (CASE WHEN t2.ATCOCM is not null THEN 'C' WHEN t2.ATCOAL is not null THEN 'A' WHEN t2.ATIDCOMUNICACIONSOIVRE is not null THEN 'S' WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is not null THEN 'D' WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is null THEN 'E' WHEN t1.ACTIORORIGEN = 'C' THEN 'X' WHEN t1.ACTIORORIGEN = 'N' THEN 'N' ELSE 'O' END) TIPOORIGEN, (NVL(t2.ATUINMOVILIZADAS,0) + NVL(t2.ATURECUPERADAS,0)) NUMPRODSENCONTRADOS, t2.ATADICIONAL ATADICIONAL ");
		query.append(
				"FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14, INTERVINIENTES t15, INTERVINIENTES t16 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t1.ACCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t7.HDCODE = t10.DECODIGO (+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) AND t15.TIPO_INTERVINIENTE(+) = 'R' AND t2.ATCODIGO = t15.HDCODIGO(+) AND t16.TIPO_INTERVINIENTE(+) = 'V' AND t2.ATCODIGO = t16.HDCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();

		where.append(" AND t1.ACCOMO = ? ");
		params.add(acta.getAccomo());

		where.append(" AND t2.ATFECHACIERRE IS NULL ");

		// organismo seleccionado
		where.append(" AND t12.ADCOOR = ? ");
		params.add(acta.getAccoor());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BusquedaInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMapBusquedaInspeccion,
				params.toArray());
	}

	/**
	 * Finds an inspection.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return List
	 */
	@Transactional(readOnly = true)
	public InspeccionDetalle findInspeccion(Actuacion actuacion) {
		StringBuilder query = new StringBuilder(
				"SELECT ATCODIGO, ATACUERDOINICIO, ATTIPO, ATONLINE, atnror,atcopsnom,atfefin,atformanotifestablecimientovi,atidiomaestablecimientovi,atformanotifestablecimientore, EV.IDINTERVINIENTE IDINTERVINIENTEV, ev.escodigo escodigov, ER.IDINTERVINIENTE IDINTERVINIENTER, er.escodigo escodigor, at.atcops atcops, er.nif nifr,er.nombre nombrer, er.esnoco esnocor,er.senombre senombrer,er.NOMBRE_PROVINCIA NOMBRE_PROVINCIAR,er.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIOR,er.DIRECCION_NOCAPV DIRECCION_NOCAPVR, er.COEM COEMR, er.NRTEL NRTELR, er.INADAR ESINADARR,ev.nif nifv,ev.nombre nombrev, ev.esnoco esnocov, ev.esteurl esteurlv,ev.senombre senombrev,ev.NOMBRE_PROVINCIA NOMBRE_PROVINCIAV,ev.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIOV,ev.DIRECCION_NOCAPV DIRECCION_NOCAPVV, ev.COEM COEMV, ev.NRTEL NRTELV, ev.INADAR ESINADARV,t1.accodigo,t1.accoor, t1.acnror, t1.acnran, t1.acfere,at.atfedumi,atnoprse,atnomaps,atnomops,atnrlops,atcodigobarras,NVL(atuexistentes,0) atuexistentes,NVL(atuinmovilizadas,0) atuinmovilizadas,NVL(atudestruidas,0) atudestruidas,NVL(atudevolucionorigen,0) atudevolucionorigen,NVL(atulibrecomercializacion,0) atulibrecomercializacion,NVL(atuotros,0) atuotros,NVL(atutomamuestras,0) atutomamuestras,NVL(aturecuperadas,0) aturecuperadas,NVL(atupendientes,0) atupendientes,ce.monombre, at.atcocm, at.atcoal, at.atidcomunicacionsoivre, at.atcohd, at.atcohddenuncia, al.ALNROR, al.ALNRAN, cs.V6CODIGO, cm.CMONLINE, de.decoor, de.DENROR, de.DENRAN, hd.HDNROR, t1.ACCODEXPEDIENTEORIGEN, t1.ACCOORORIGEN, t1.ACTIORORIGEN, t1.ACINCUMPLIMIENTO, CE.MOCODIGO, tr.TRNOMBRE, tr.TRNOMBREE, at.TRPOSIBLECODIGO, at.ATFECHACIERRE, ad.ADCOOR, at.ISKONTSUMOBIDE, at.ATENPLATEA, at.ATPARTICIPACIONRESPONSABLE, at.ATDESTNOTIFICAVISITADO, at.ATDESTNOTIFICARESPONSABLE, at.ATFEPROTOCOLO, at.ATADICIONAL,at.ATCOPG, at.ATCOCR, at.ATINSPECCIONSOLICITADA, at.ATIDPARTICIPACIONVISITADO, at.ATIDPARTICIPACIONRESPONSABLE,at.ATATABLET,at.ATISTABLET "
						+ " FROM ACTA t1 JOIN ACTUACION at on t1.ACCODIGO = at.ATCOAC "
						+ " JOIN ACTDEC ad on at.ATCODIGO = ad.ADCOAT "
						+ " LEFT JOIN INTERVINIENTES ev on at.atcodigo = EV.HDCODIGO AND ev.tipo_interviniente ='V' "
						+ " LEFT JOIN INTERVINIENTES er on at.atcodigo = ER.HDCODIGO AND er.TIPO_INTERVINIENTE = 'R' "
						+ " LEFT JOIN censo_monitor ce ON t1.accomo = ce.mocodigo "
						+ " LEFT JOIN CAMPANHA cm ON at.ATCOCM = cm.CMCODIGO "
						+ " LEFT JOIN ALERTA al ON at.ATCOAL = al.ALCODIGO "
						+ " LEFT JOIN COMUNICACION_SOIVRE cs ON at.ATIDCOMUNICACIONSOIVRE = cs.IDCOMUNICACIONSOIVRE "
						+ " LEFT JOIN HECHO_DENUNCIADO hd ON at.ATCOHD = hd.HDCODIGO "
						+ " LEFT JOIN DENUNCIA de ON hd.HDCODE = de.DECODIGO "
						+ " LEFT JOIN TRAMITE tr ON at.TRCODIGOACTUAL = tr.TRCODIGO "
						+ " LEFT JOIN HECDEN he ON at.ATCOHD = he.HDCODIGO " + " WHERE at.ATCODIGO = ?");

		return this.jdbcTemplate.query(query.toString(), new RowMapper<InspeccionDetalle>() {
			public InspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
				inspeccionDetalle.setAtcodigo(resultSet.getString("ATCODIGO"));
				inspeccionDetalle.setAtacuerdoinicio(resultSet.getString("ATACUERDOINICIO"));
				inspeccionDetalle.setAtnror(resultSet.getString("atnror"));
				inspeccionDetalle.setAtcopsnom(resultSet.getString("atcopsnom"));
				inspeccionDetalle
						.setAtformanotifestablecimientore(resultSet.getString("atformanotifestablecimientore"));
				inspeccionDetalle
						.setAtformanotifestablecimientovi(resultSet.getString("atformanotifestablecimientovi"));
				inspeccionDetalle.setAtidiomaestablecimientovi(resultSet.getString("atidiomaestablecimientovi"));
				inspeccionDetalle.setAccodigo(resultSet.getString("ACCODIGO"));
				inspeccionDetalle.setAccoor(resultSet.getString("ACCOOR"));
				inspeccionDetalle.setAcnran(resultSet.getBigDecimal("ACNRAN"));
				inspeccionDetalle.setAcnror(resultSet.getString("ACNROR"));
				inspeccionDetalle.setAcfere(resultSet.getDate("Acfere"));
				inspeccionDetalle.setAtcops(resultSet.getString("ATCOPS"));
				inspeccionDetalle.setAtnoprse(resultSet.getString("Atnoprse"));
				inspeccionDetalle.setAtnomaps(resultSet.getString("atnomaps"));
				inspeccionDetalle.setAtnomops(resultSet.getString("atnomops"));
				inspeccionDetalle.setAtnrlops(resultSet.getString("atnrlops"));
				inspeccionDetalle.setAtcodigobarras(resultSet.getString("atcodigobarras"));
				inspeccionDetalle.setAtfedumi(resultSet.getDate("atfedumi"));
				inspeccionDetalle.setAtfefin(resultSet.getDate("atfefin"));
				inspeccionDetalle.setAtuexistentes(resultSet.getBigDecimal("atuexistentes"));
				inspeccionDetalle.setAtuinmovilizadas(resultSet.getBigDecimal("atuinmovilizadas"));
				inspeccionDetalle.setAtudestruidas(resultSet.getBigDecimal("atudestruidas"));
				inspeccionDetalle.setAtudevolucionorigen(resultSet.getBigDecimal("atudevolucionorigen"));
				inspeccionDetalle.setAtulibrecomercializacion(resultSet.getBigDecimal("atulibrecomercializacion"));
				inspeccionDetalle.setAtuotros(resultSet.getBigDecimal("atuotros"));
				inspeccionDetalle.setAtutomamuestras(resultSet.getBigDecimal("atutomamuestras"));
				inspeccionDetalle.setAturecuperadas(resultSet.getBigDecimal("aturecuperadas"));
				inspeccionDetalle.setAtupendientes(resultSet.getBigDecimal("atupendientes"));

				Intervinientes intervinienteR = new Intervinientes();
				intervinienteR.setIdinterviniente(resultSet.getString("IDINTERVINIENTER"));

				intervinienteR.setEscodigo(resultSet.getString("escodigor"));

				intervinienteR.setNif(resultSet.getString("nifr"));
				intervinienteR.setNombre(resultSet.getString("nombrer"));
				intervinienteR.setEsnoco(resultSet.getString("esnocor"));
				intervinienteR.setSenombre(resultSet.getString("senombrer"));
				intervinienteR.setNombreProvincia(resultSet.getString("NOMBRE_PROVINCIAR"));
				intervinienteR.setNombreMunicipio(resultSet.getString("NOMBRE_MUNICIPIOR"));
				intervinienteR.setDireccionNocapv(resultSet.getString("DIRECCION_NOCAPVR"));

				intervinienteR.setCoem(resultSet.getString("COEMR"));
				intervinienteR.setNrtel(resultSet.getString("NRTELR"));

				intervinienteR.setInadar(resultSet.getString("ESINADARR"));

				Intervinientes intervinienteV = new Intervinientes();
				intervinienteV.setIdinterviniente(resultSet.getString("IDINTERVINIENTEV"));
				intervinienteV.setEscodigo(resultSet.getString("escodigov"));
				intervinienteV.setNif(resultSet.getString("nifv"));
				intervinienteV.setNombre(resultSet.getString("nombrev"));
				intervinienteV.setEsnoco(resultSet.getString("esnocov"));
				intervinienteV.setEsteurl(resultSet.getString("esteurlv"));
				intervinienteV.setSenombre(resultSet.getString("senombrev"));
				intervinienteV.setNombreProvincia(resultSet.getString("NOMBRE_PROVINCIAV"));
				intervinienteV.setNombreMunicipio(resultSet.getString("NOMBRE_MUNICIPIOV"));
				intervinienteV.setDireccionNocapv(resultSet.getString("DIRECCION_NOCAPVV"));

				intervinienteV.setCoem(resultSet.getString("COEMV"));
				intervinienteV.setNrtel(resultSet.getString("NRTELV"));

				intervinienteV.setInadar(resultSet.getString("ESINADARV"));

				inspeccionDetalle.setEstablecimientoR(intervinienteR);
				inspeccionDetalle.setEstablecimientoV(intervinienteV);

				inspeccionDetalle.setMonombre(resultSet.getString("MONOMBRE"));

				inspeccionDetalle.setAtcocm(resultSet.getString("ATCOCM"));
				inspeccionDetalle.setCmonline(resultSet.getString("CMONLINE"));

				inspeccionDetalle.setAttipo(resultSet.getString("ATTIPO"));
				inspeccionDetalle.setAtcopg(resultSet.getString("ATCOPG"));
				inspeccionDetalle.setAtcoal(resultSet.getString("ATCOAL"));
				inspeccionDetalle.setAtcocr(resultSet.getString("ATCOCR"));
				inspeccionDetalle.setAtidcomunicacionsoivre(resultSet.getString("ATIDCOMUNICACIONSOIVRE"));
				inspeccionDetalle.setAtcohd(resultSet.getString("ATCOHD"));
				inspeccionDetalle.setAtcohddenuncia(resultSet.getString("ATCOHDDENUNCIA"));

				inspeccionDetalle.setAlnror(resultSet.getString("ALNROR"));
				inspeccionDetalle.setAlnran(resultSet.getString("ALNRAN"));
				inspeccionDetalle.setV6codigo(resultSet.getString("V6CODIGO"));

				inspeccionDetalle.setDecoor(resultSet.getString("decoor"));
				inspeccionDetalle.setDenror(resultSet.getString("DENROR"));
				inspeccionDetalle.setDenran(resultSet.getString("DENRAN"));
				inspeccionDetalle.setHdnror(resultSet.getString("HDNROR"));

				inspeccionDetalle.setAccodexpedienteorigen(resultSet.getString("ACCODEXPEDIENTEORIGEN"));
				inspeccionDetalle.setAccoororigen(resultSet.getString("ACCOORORIGEN"));
				inspeccionDetalle.setActiororigen(resultSet.getString("ACTIORORIGEN"));
				inspeccionDetalle.setAcincumplimiento(resultSet.getString("ACINCUMPLIMIENTO"));
				inspeccionDetalle.setMocodigo(resultSet.getString("MOCODIGO"));

				inspeccionDetalle.setTrnombre(resultSet.getString("TRNOMBRE"));
				inspeccionDetalle.setTrnombree(resultSet.getString("TRNOMBREE"));

				inspeccionDetalle.setTrPosibleCodigo(resultSet.getString("TRPOSIBLECODIGO"));

				inspeccionDetalle.setAtfechacierre(resultSet.getDate("ATFECHACIERRE"));

				inspeccionDetalle.setAdcoor(resultSet.getString("ADCOOR"));

				inspeccionDetalle.setIskontsumobide(resultSet.getString("ISKONTSUMOBIDE"));

				inspeccionDetalle.setAtenplatea(resultSet.getString("ATENPLATEA"));

				inspeccionDetalle.setAtparticipacionresponsable(resultSet.getString("ATPARTICIPACIONRESPONSABLE"));

				inspeccionDetalle.setAtdestnotificavisitado(resultSet.getString("ATDESTNOTIFICAVISITADO"));

				inspeccionDetalle.setAtdestnotificaresponsable(resultSet.getString("ATDESTNOTIFICARESPONSABLE"));

				inspeccionDetalle.setAtfeprotocolo(resultSet.getDate("ATFEPROTOCOLO"));

				inspeccionDetalle.setAtadicional(resultSet.getString("ATADICIONAL"));

				inspeccionDetalle.setAtinspeccionsolicitada(resultSet.getString("ATINSPECCIONSOLICITADA"));

				inspeccionDetalle.setAtidparticipacionvisitado(resultSet.getString("ATIDPARTICIPACIONVISITADO"));

				inspeccionDetalle.setAtidparticipacionresponsable(resultSet.getString("ATIDPARTICIPACIONRESPONSABLE"));

				inspeccionDetalle.setAtatablet(resultSet.getString("ATATABLET"));
				inspeccionDetalle.setAtistablet(resultSet.getString("ATISTABLET"));

				inspeccionDetalle.setAtonline(resultSet.getString("ATONLINE"));

				return inspeccionDetalle;
			}
		}, actuacion.getAtcodigo()).get(0);
	}

	/**
	 * Finds an inspection By Numero Expediente.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return List
	 */
	@Transactional(readOnly = true)
	public InspeccionDetalle findInspeccionByNumeroExpediente(InspeccionDetalle inspeccionDetalle) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT ATCODIGO, atnror,atcopsnom,atfefin,atformanotifestablecimientovi,atidiomaestablecimientovi,atformanotifestablecimientore, ATIDPARTICIPACIONVISITADO, ATIDPARTICIPACIONRESPONSABLE, ev.escodigo escodigov, er.escodigo escodigor, at.atcops atcops, er.nif nifr,er.nombre nombrer,er.senombre senombrer,er.NOMBRE_PROVINCIA NOMBRE_PROVINCIAR,er.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIOR,er.DIRECCION_NOCAPV DIRECCION_NOCAPVR,ev.nif nifv,ev.nombre nombrev,ev.senombre senombrev,ev.NOMBRE_PROVINCIA NOMBRE_PROVINCIAV,ev.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIOV,ev.DIRECCION_NOCAPV DIRECCION_NOCAPVV,t1.accodigo,t1.accoor, t1.acnror, t1.acnran, t1.acfere,at.atfedumi,atnoprse,atnomaps,atnomops,atnrlops,atcodigobarras,NVL(atuexistentes,0) atuexistentes,NVL(atuinmovilizadas,0) atuinmovilizadas,NVL(atudestruidas,0) atudestruidas,NVL(atudevolucionorigen,0) atudevolucionorigen,NVL(atulibrecomercializacion,0) atulibrecomercializacion,NVL(atuotros,0) atuotros,NVL(aturecuperadas,0) aturecuperadas,NVL(atupendientes,0) atupendientes,ce.monombre, at.atcocm, at.atcoal, at.atidcomunicacionsoivre, at.atcohd, al.ALNROR, al.ALNRAN, cs.V6CODIGO, de.decoor, de.DENROR, de.DENRAN, hd.HDNROR, t1.ACCODEXPEDIENTEORIGEN, t1.ACCOORORIGEN, t1.ACTIORORIGEN, t1.ACINCUMPLIMIENTO, MOCODIGO, tr.TRNOMBRE, tr.TRNOMBREE "
							+ " FROM ACTA t1 JOIN ACTUACION at on t1.ACCODIGO = at.ATCOAC "
							+ " LEFT JOIN INTERVINIENTES ev on at.atcodigo = EV.HDCODIGO AND ev.tipo_interviniente ='V' "
							+ " LEFT JOIN INTERVINIENTES er on at.atcodigo = ER.HDCODIGO AND er.TIPO_INTERVINIENTE = 'R' "
							+ " LEFT JOIN censo_monitor ce ON t1.accomo = ce.mocodigo "
							+ " LEFT JOIN ALERTA al ON at.ATCOAL = al.ALCODIGO "
							+ " LEFT JOIN COMUNICACION_SOIVRE cs ON at.ATIDCOMUNICACIONSOIVRE = cs.IDCOMUNICACIONSOIVRE "
							+ " LEFT JOIN HECHO_DENUNCIADO hd ON at.ATCOHD = hd.HDCODIGO "
							+ " LEFT JOIN DENUNCIA de ON hd.HDCODE = de.DECODIGO "
							+ " LEFT JOIN TRAMITE tr ON at.TRCODIGOACTUAL = tr.TRCODIGO "
							+ " LEFT JOIN HECDEN he ON at.ATCOHD = he.HDCODIGO "
							+ " WHERE t1.ACCOOR=? AND t1.ACNRAN=? AND t1.ACNROR=? AND at.ATNROR=? AND ROWNUM = 1 ");

			return this.jdbcTemplate.queryForObject(query.toString(), new RowMapper<InspeccionDetalle>() {
				public InspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

					InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
					inspeccionDetalle.setAtcodigo(resultSet.getString("ATCODIGO"));
					inspeccionDetalle.setAtnror(resultSet.getString("atnror"));
					inspeccionDetalle.setAtcopsnom(resultSet.getString("atcopsnom"));
					inspeccionDetalle
							.setAtformanotifestablecimientore(resultSet.getString("atformanotifestablecimientore"));
					inspeccionDetalle
							.setAtformanotifestablecimientovi(resultSet.getString("atformanotifestablecimientovi"));
					inspeccionDetalle.setAtidiomaestablecimientovi(resultSet.getString("atidiomaestablecimientovi"));
					inspeccionDetalle.setAccodigo(resultSet.getString("ACCODIGO"));
					inspeccionDetalle.setAccoor(resultSet.getString("ACCOOR"));
					inspeccionDetalle.setAcnran(resultSet.getBigDecimal("ACNRAN"));
					inspeccionDetalle.setAcnror(resultSet.getString("ACNROR"));
					inspeccionDetalle.setAcfere(resultSet.getDate("Acfere"));

					inspeccionDetalle.setAtcops(resultSet.getString("ATCOPS"));
					inspeccionDetalle.setAtnoprse(resultSet.getString("Atnoprse"));
					inspeccionDetalle.setAtnomaps(resultSet.getString("atnomaps"));
					inspeccionDetalle.setAtnomops(resultSet.getString("atnomops"));
					inspeccionDetalle.setAtnrlops(resultSet.getString("atnrlops"));
					inspeccionDetalle.setAtcodigobarras(resultSet.getString("atcodigobarras"));
					inspeccionDetalle.setAtfedumi(resultSet.getDate("atfedumi"));
					inspeccionDetalle.setAtfefin(resultSet.getDate("atfefin"));
					inspeccionDetalle.setAtuexistentes(resultSet.getBigDecimal("atuexistentes"));
					inspeccionDetalle.setAtuinmovilizadas(resultSet.getBigDecimal("atuinmovilizadas"));
					inspeccionDetalle.setAtudestruidas(resultSet.getBigDecimal("atudestruidas"));
					inspeccionDetalle.setAtudevolucionorigen(resultSet.getBigDecimal("atudevolucionorigen"));
					inspeccionDetalle.setAtulibrecomercializacion(resultSet.getBigDecimal("atulibrecomercializacion"));
					inspeccionDetalle.setAtuotros(resultSet.getBigDecimal("atuotros"));
					inspeccionDetalle.setAturecuperadas(resultSet.getBigDecimal("aturecuperadas"));
					inspeccionDetalle.setAtupendientes(resultSet.getBigDecimal("atupendientes"));

					Intervinientes intervinienteR = new Intervinientes();
					intervinienteR.setEscodigo(resultSet.getString("escodigor"));

					intervinienteR.setNif(resultSet.getString("nifr"));
					intervinienteR.setNombre(resultSet.getString("nombrer"));
					intervinienteR.setSenombre(resultSet.getString("senombrer"));
					intervinienteR.setNombreProvincia(resultSet.getString("NOMBRE_PROVINCIAR"));
					intervinienteR.setNombreMunicipio(resultSet.getString("NOMBRE_MUNICIPIOR"));
					intervinienteR.setDireccionNocapv(resultSet.getString("DIRECCION_NOCAPVR"));

					Intervinientes intervinienteV = new Intervinientes();
					intervinienteV.setEscodigo(resultSet.getString("escodigov"));
					intervinienteV.setNif(resultSet.getString("nifv"));
					intervinienteV.setNombre(resultSet.getString("nombrev"));
					intervinienteV.setSenombre(resultSet.getString("senombrev"));
					intervinienteV.setNombreProvincia(resultSet.getString("NOMBRE_PROVINCIAV"));
					intervinienteV.setNombreMunicipio(resultSet.getString("NOMBRE_MUNICIPIOV"));
					intervinienteV.setDireccionNocapv(resultSet.getString("DIRECCION_NOCAPVV"));

					inspeccionDetalle.setEstablecimientoR(intervinienteR);
					inspeccionDetalle.setEstablecimientoV(intervinienteV);

					inspeccionDetalle.setMonombre(resultSet.getString("MONOMBRE"));

					inspeccionDetalle.setAtcocm(resultSet.getString("ATCOCM"));
					inspeccionDetalle.setAtcoal(resultSet.getString("ATCOAL"));
					inspeccionDetalle.setAtidcomunicacionsoivre(resultSet.getString("ATIDCOMUNICACIONSOIVRE"));
					inspeccionDetalle.setAtcohd(resultSet.getString("ATCOHD"));

					inspeccionDetalle.setAlnror(resultSet.getString("ALNROR"));
					inspeccionDetalle.setAlnran(resultSet.getString("ALNRAN"));
					inspeccionDetalle.setV6codigo(resultSet.getString("V6CODIGO"));

					inspeccionDetalle.setDecoor(resultSet.getString("decoor"));
					inspeccionDetalle.setDenror(resultSet.getString("DENROR"));
					inspeccionDetalle.setDenran(resultSet.getString("DENRAN"));
					inspeccionDetalle.setHdnror(resultSet.getString("HDNROR"));

					inspeccionDetalle.setAccodexpedienteorigen(resultSet.getString("ACCODEXPEDIENTEORIGEN"));
					inspeccionDetalle.setAccoororigen(resultSet.getString("ACCOORORIGEN"));
					inspeccionDetalle.setActiororigen(resultSet.getString("ACTIORORIGEN"));
					inspeccionDetalle.setAcincumplimiento(resultSet.getString("ACINCUMPLIMIENTO"));
					inspeccionDetalle.setMocodigo(resultSet.getString("MOCODIGO"));

					inspeccionDetalle.setTrnombre(resultSet.getString("TRNOMBRE"));
					inspeccionDetalle.setTrnombree(resultSet.getString("TRNOMBREE"));

					inspeccionDetalle.setAtidparticipacionvisitado(resultSet.getString("ATIDPARTICIPACIONVISITADO"));

					inspeccionDetalle
							.setAtidparticipacionresponsable(resultSet.getString("ATIDPARTICIPACIONRESPONSABLE"));

					return inspeccionDetalle;
				}
			}, inspeccionDetalle.getAccoor(), inspeccionDetalle.getAcnran(), inspeccionDetalle.getAcnror(),
					inspeccionDetalle.getAtnror());
		} catch (EmptyResultDataAccessException e) {
			return new InspeccionDetalle();
		}
	}

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Acta acta, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append(
				"FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14, INTERVINIENTES t15, INTERVINIENTES t16 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActaLikeMap(acta);
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t1.ACCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t7.HDCODE = t10.DECODIGO (+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) AND t15.TIPO_INTERVINIENTE(+) = 'R' AND t2.ATCODIGO = t15.HDCODIGO(+) AND t16.TIPO_INTERVINIENTE(+) = 'V' AND t2.ATCODIGO = t16.HDCODIGO(+) ");

		where.append(mapaWhere.get("query"));

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Acta> findAllActaEstablecimiento(Acta acta, Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ACCOES= t2.ESCODIGO(+) 	");

		StringBuffer query = new StringBuffer("SELECT  t1.ACCODIGO ACCODIGO " + "FROM ACTA t1,ESTABLECIMIENTO t2 ");

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(acta.getEstablecimiento().getEscodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Acta>) this.jdbcTemplate.query(query.toString(), new RowMapper<Acta>() {
			public Acta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Acta(resultSet.getString("ACCODIGO"), null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						new Establecimiento(), new Establecimiento(), new Actuacion(), null, null, null, null, null);
			}
		}, params.toArray());
	}

	/**
	 * Finds an Acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findNumActa(Acta acta) {
		String query = "SELECT NVL(MAX(ABS(ACNROR)),0)+1 ACNROR FROM ACTA WHERE ACCOOR = ? AND ACNRAN = ? AND REGEXP_LIKE (ACNROR,'^[[:digit:]]+$') ";

		return this.jdbcTemplate.queryForObject(query, String.class,
				new Object[] { acta.getAccoor(), acta.getAcnran() });
	}

	/**
	 * Finds a single row in the Tramite Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Tramite
	 */
	@Transactional(readOnly = true)
	public Tramite findUltimoTramite(Actuacion actuacion) {

		StringBuilder query = new StringBuilder(
				"SELECT TRCODIGO, TRNOMBRE, TRNOMBREE FROM (SELECT t2.TRCODIGO TRCODIGO, t2.TRNOMBRE TRNOMBRE, t2.TRNOMBREE TRNOMBREE ");
		query.append("FROM TRAMITE_INSPECCION t1, TRAMITE t2 ");
		query.append(
				"WHERE t1.TICOTEE = t2.TRCODIGO AND t1.TIATCODIGO = ? ORDER BY TIFECHAINICIO DESC) WHERE ROWNUM = 1");
		Object resul = this.jdbcTemplate.queryForObject(query.toString(), new RowMapper<Tramite>() {
			public Tramite mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Tramite(resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
						resultSet.getString("TRNOMBREE"));
			}
		}, actuacion.getAtcodigo());
		return (Tramite) resul;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Acta entity
	 * 
	 * @param acta
	 *            Acta Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Acta acta) {

		StringBuilder where = new StringBuilder(ActaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (acta != null && acta.getAccodigo() != null) {
			where.append(" AND t1.ACCODIGO = ?");
			params.add(acta.getAccodigo());
		}
		if (acta != null && acta.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) = ?");
			params.add(acta.getAccoor().toUpperCase());
		}
		if (acta != null && acta.getAcnror() != null) {
			where.append(" AND UPPER(t1.ACNROR) = ?");
			params.add(acta.getAcnror().toUpperCase());
		}
		if (acta != null && acta.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(acta.getAcnran());
		}
		if (acta != null && acta.getAccoinun() != null) {
			where.append(" AND UPPER(t1.ACCOINUN) = ?");
			params.add(acta.getAccoinun().toUpperCase());
		}
		if (acta != null && acta.getAccoindo() != null) {
			where.append(" AND UPPER(t1.ACCOINDO) = ?");
			params.add(acta.getAccoindo().toUpperCase());
		}
		if (acta != null && acta.getAcfele() != null) {
			where.append(" AND t1.ACFELE = ?");
			params.add(acta.getAcfele());
		}
		if (acta != null && acta.getAcfere() != null) {
			where.append(" AND t1.ACFERE = ?");
			params.add(acta.getAcfere());
		}
		if (acta != null && acta.getAcfereDesde() != null && acta.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(acta.getAcfereDesde());
			where.append(" AND t1.ACFERE <= ?");
			params.add(acta.getAcfereHasta());
		}
		if (acta != null && acta.getAcfereDesde() == null && acta.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(acta.getAcfereHasta());
		}
		if (acta != null && acta.getAcfereDesde() != null && acta.getAcfereHasta() == null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(acta.getAcfereDesde());
		}
		if (acta != null && acta.getAccoes() != null) {
			where.append(" AND UPPER(t1.ACCOES) = ?");
			params.add(acta.getAccoes().toUpperCase());
		}
		if (acta != null && acta.getAccoav() != null) {
			where.append(" AND UPPER(t1.ACCOAV) = ?");
			params.add(acta.getAccoav().toUpperCase());
		}
		if (acta != null && acta.getAccose() != null) {
			where.append(" AND UPPER(t1.ACCOSE) = ?");
			params.add(acta.getAccose().toUpperCase());
		}
		if (acta != null && acta.getAcfeex() != null) {
			where.append(" AND t1.ACFEEX = ?");
			params.add(acta.getAcfeex());
		}
		if (acta != null && acta.getAcinre() != null) {
			where.append(" AND UPPER(t1.ACINRE) = ?");
			params.add(acta.getAcinre().toUpperCase());
		}
		if (acta != null && acta.getAcnoco() != null) {
			where.append(" AND UPPER(t1.ACNOCO) = ?");
			params.add(acta.getAcnoco().toUpperCase());
		}
		if (acta != null && acta.getAcdnico() != null) {
			where.append(" AND UPPER(t1.ACDNICO) = ?");
			params.add(acta.getAcdnico().toUpperCase());
		}
		if (acta != null && acta.getAccoco() != null) {
			where.append(" AND UPPER(t1.ACCOCO) = ?");
			params.add(acta.getAccoco().toUpperCase());
		}
		if (acta != null && acta.getAcdirco() != null) {
			where.append(" AND UPPER(t1.ACDIRCO) = ?");
			params.add(acta.getAcdirco().toUpperCase());
		}
		if (acta != null && acta.getAccoloco() != null) {
			where.append(" AND UPPER(t1.ACCOLOCO) = ?");
			params.add(acta.getAccoloco().toUpperCase());
		}
		if (acta != null && acta.getAcnrcpco() != null) {
			where.append(" AND UPPER(t1.ACNRCPCO) = ?");
			params.add(acta.getAcnrcpco().toUpperCase());
		}
		if (acta != null && acta.getAcnrtfco() != null) {
			where.append(" AND UPPER(t1.ACNRTFCO) = ?");
			params.add(acta.getAcnrtfco().toUpperCase());
		}
		if (acta != null && acta.getAccotd() != null) {
			where.append(" AND UPPER(t1.ACCOTD) = ?");
			params.add(acta.getAccotd().toUpperCase());
		}
		if (acta != null && acta.getAcnoraPaisId() != null) {
			where.append(" AND t1.ACNORA_PAIS_ID = ?");
			params.add(acta.getAcnoraPaisId());
		}
		if (acta != null && acta.getAcnoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.ACNORA_PAIS_NOMBRE) = ?");
			params.add(acta.getAcnoraPaisNombre().toUpperCase());
		}
		if (acta != null && acta.getAcnoraProvinciaId() != null) {
			where.append(" AND t1.ACNORA_PROVINCIA_ID = ?");
			params.add(acta.getAcnoraProvinciaId());
		}
		if (acta != null && acta.getAcnombreProvincia() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PROVINCIA) = ?");
			params.add(acta.getAcnombreProvincia().toUpperCase());
		}
		if (acta != null && acta.getAcnoraMunicipioId() != null) {
			where.append(" AND t1.ACNORA_MUNICIPIO_ID = ?");
			params.add(acta.getAcnoraMunicipioId());
		}
		if (acta != null && acta.getAcnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_MUNICIPIO) = ?");
			params.add(acta.getAcnombreMunicipio().toUpperCase());
		}
		if (acta != null && acta.getAcnoraLocalidadId() != null) {
			where.append(" AND t1.ACNORA_LOCALIDAD_ID = ?");
			params.add(acta.getAcnoraLocalidadId());
		}
		if (acta != null && acta.getAcnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_LOCALIDAD) = ?");
			params.add(acta.getAcnombreLocalidad().toUpperCase());
		}
		if (acta != null && acta.getAcnoraCalleId() != null) {
			where.append(" AND t1.ACNORA_CALLE_ID = ?");
			params.add(acta.getAcnoraCalleId());
		}
		if (acta != null && acta.getAcnombreCalle() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_CALLE) = ?");
			params.add(acta.getAcnombreCalle().toUpperCase());
		}
		if (acta != null && acta.getAcnoraCpId() != null) {
			where.append(" AND t1.ACNORA_CP_ID = ?");
			params.add(acta.getAcnoraCpId());
		}
		if (acta != null && acta.getAcnombreCp() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_CP) = ?");
			params.add(acta.getAcnombreCp().toUpperCase());
		}
		if (acta != null && acta.getAcnoraPortalId() != null) {
			where.append(" AND t1.ACNORA_PORTAL_ID = ?");
			params.add(acta.getAcnoraPortalId());
		}
		if (acta != null && acta.getAcnombrePortal() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PORTAL) = ?");
			params.add(acta.getAcnombrePortal().toUpperCase());
		}
		if (acta != null && acta.getAcnombrePiso() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PISO) = ?");
			params.add(acta.getAcnombrePiso().toUpperCase());
		}
		if (acta != null && acta.getAcdireccionNocapv() != null) {
			where.append(" AND UPPER(t1.ACDIRECCION_NOCAPV) = ?");
			params.add(acta.getAcdireccionNocapv().toUpperCase());
		}
		if (acta != null && acta.getAcape1co() != null) {
			where.append(" AND UPPER(t1.ACAPE1CO) = ?");
			params.add(acta.getAcape1co().toUpperCase());
		}
		if (acta != null && acta.getAcape2co() != null) {
			where.append(" AND UPPER(t1.ACAPE2CO) = ?");
			params.add(acta.getAcape2co().toUpperCase());
		}
		if (acta != null && acta.getAccodexpedienteorigen() != null) {
			where.append(" AND UPPER(t1.ACCODEXPEDIENTEORIGEN) = ?");
			params.add(acta.getAccodexpedienteorigen().toUpperCase());
		}
		if (acta != null && acta.getAccoororigen() != null) {
			where.append(" AND UPPER(t1.ACCOORORIGEN) = ?");
			params.add(acta.getAccoororigen().toUpperCase());
		}
		if (acta != null && acta.getActiororigen() != null) {
			where.append(" AND UPPER(t1.ACTIORORIGEN) = ?");
			params.add(acta.getActiororigen().toUpperCase());
		}
		if (acta != null && acta.getAcincumplimiento() != null) {
			where.append(" AND UPPER(t1.ACINCUMPLIMIENTO) = ?");
			params.add(acta.getAcincumplimiento().toUpperCase());
		}
		if (acta != null && acta.getAccomo() != null) {
			where.append(" AND t1.ACCOMO = ?");
			params.add(acta.getAccomo());
		}

		// Tramite
		if (acta != null && acta.getTrcodigo() != null) {
			where.append(
					" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND TICOTEE = ?) ");
			params.add(acta.getTrcodigo());

			if (acta != null && acta.getIndUltimoTramite() != null
					&& acta.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(" AND t2.TRCODIGOACTUAL = ? ");
				params.add(acta.getTrcodigo());
			}
		}

		// Decision
		if (acta != null && acta.getDecodigo() != null) {
			where.append(
					" AND (EXISTS (SELECT t1.DECODIGO DECODIGO FROM DECISION t1, ACTDEC tt2 WHERE 1=1 AND t1.DECODIGO=tt2.ADCOTTD AND tt2.ADCOAT=t2.ATCODIGO AND t1.DENOMBRE = (SELECT t1.DENOMBRE DENOMBRE FROM DECISION t1 WHERE t1.DECODIGO=?)) ");
			params.add(acta.getDecodigo());

			where.append(
					" OR EXISTS (SELECT tt2.ADCOTTD HCCOTTD FROM ACTDEC tt2 WHERE 1=1 AND tt2.ADCOAT=t2.ATCODIGO AND tt2.ADCOTTD IN (SELECT t1.DECODIGOL21 FROM CORRESPONDENCIA_DECISION_L21 t1 WHERE t1.DECODIGOY41B=?))) ");
			params.add(acta.getDecodigo());
		}

		// Tramitador
		if (acta != null && acta.getMocodigoTramitador() != null) {

			if (acta != null && acta.getIndUltimoTramite() != null
					&& acta.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(
						" AND t2.TRCODIGOACTUAL IN (SELECT TICOTEE FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TICOMOASIGNADO = ?  AND TIFECHAFIN = (SELECT MAX(TIFECHAFIN) FROM TRAMITE_INSPECCION tr2 WHERE tr2.TIATCODIGO=t2.ATCODIGO ) ) ");
				params.add(acta.getMocodigoTramitador());
			} else {
				where.append(
						" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TICOMOASIGNADO = ?) ");
				params.add(acta.getMocodigoTramitador());
			}
		}

		// fecha decision desde
		if (acta != null && acta.getEhfechafinDecisionDesde() != null) {
			where.append(" AND t12.ADFEDE >= ?");
			params.add(acta.getEhfechafinDecisionDesde());
		}

		// fecha decision hasta
		if (acta != null && acta.getEhfechafinDecisionHasta() != null) {
			where.append(" AND t12.ADFEDE <= ?");
			params.add(acta.getEhfechafinDecisionHasta());
		}

		// Incluir expedientes cerrados
		if ((acta != null && acta.getIndIncluirCerrados() == null)
				|| (acta != null && acta.getIndIncluirCerrados() != null
						&& !acta.getIndIncluirCerrados().equals(Y41bConstantes.VALOR_SI))) {
			where.append(" AND t2.ATFECHACIERRE IS NULL ");
		}

		// Con acuse de recibo pendientes
		if (acta != null && acta.getIndPendienteAcuse() != null
				&& acta.getIndPendienteAcuse().equals(Y41bConstantes.VALOR_SI)) {
			// query solicitudes
			where.append(
					" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TICOTEE = ? AND tr1.TIFECHAFIN IS NULL) ");
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO);
		}

		// Con decision pendiente
		if (acta != null && acta.getIndPendienteDecision() != null
				&& acta.getIndPendienteDecision().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND (t12.ADCOTTD IS NULL ");

			where.append(" OR t12.ADCOTTD=?) ");
			params.add(Y41bConstantes.DECISION_SINDECISION);
		}

		// Con pendiente firma
		if (acta != null && acta.getIndPendienteFirma() != null
				&& acta.getIndPendienteFirma().equals(Y41bConstantes.VALOR_SI)) {
			// query solicitudes
			where.append(
					" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TIESTADOTRAMITE = ?) ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
		}

		// Establecimiento responsable
		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnif() != null) {
			where.append(" AND UPPER(t3.ESNIF) = ? ");
			params.add(acta.getEstablecimientoResponsable().getEsnif().toUpperCase());
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnombre() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE) like ? ESCAPE  '\\'");
			params.add(acta.getEstablecimientoResponsable().getEsnombre().toUpperCase());
			where.append(" AND t3.ESNOMBRE IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraProvinciaId() != null) {
			where.append(" AND t3.ESNORA_PROVINCIA_ID = ? ");
			params.add(acta.getEstablecimientoResponsable().getEsnoraProvinciaId());

		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraMunicipioId() != null) {
			where.append(" AND t3.ESNORA_MUNICIPIO_ID = ? ");
			params.add(acta.getEstablecimientoResponsable().getEsnoraMunicipioId());

		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraPaisId() != null) {
			where.append(" AND t3.ESNORA_PAIS_ID = ? ");
			params.add(acta.getEstablecimientoResponsable().getEsnoraPaisId());

		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnodir() != null) {
			where.append(" AND UPPER(t3.ESNODIR) like ? ESCAPE  '\\'");
			params.add(acta.getEstablecimientoResponsable().getEsnodir().toUpperCase());

			where.append(" AND t3.ESNODIR IS NOT NULL");
		}

		// Establecimiento
		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t4.ESNIF) = ? ");
			params.add(acta.getEstablecimiento().getEsnif().toUpperCase());
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(t4.ESNOMBRE) like ? ESCAPE  '\\'");
			params.add(acta.getEstablecimiento().getEsnombre().toUpperCase());
			where.append(" AND t4.ESNOMBRE IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t4.ESNORA_PROVINCIA_ID = ? ");
			params.add(acta.getEstablecimiento().getEsnoraProvinciaId());
		}

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t4.ESNORA_MUNICIPIO_ID = ? ");
			params.add(acta.getEstablecimiento().getEsnoraMunicipioId());
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t4.ESNORA_PAIS_ID = ? ");
			params.add(acta.getEstablecimiento().getEsnoraPaisId());
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(t4.ESNODIR) like ? ESCAPE  '\\'");
			params.add(acta.getEstablecimiento().getEsnodir().toUpperCase());
			where.append(" AND t4.ESNODIR IS NOT NULL");
		}

		// producto
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtcops() != null) {
			where.append(" AND t2.ATCOPS = ? ");
			params.add(acta.getActuacion().getAtcops());
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtnoprse() != null) {
			where.append(" AND UPPER(t2.ATNOPRSE) like ? ESCAPE  '\\'");
			params.add(acta.getActuacion().getAtnoprse().toUpperCase());
			where.append(" AND t2.ATNOPRSE IS NOT NULL");
		}

		// es inspeccion nueva
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getIskontsumobide() != null) {
			where.append(" AND t2.ISKONTSUMOBIDE = ?");
			params.add(acta.getActuacion().getIskontsumobide());
		}

		// actuacion campaa
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtcocm() != null) {
			where.append(" AND UPPER(t2.ATCOCM) = ?");
			params.add(acta.getActuacion().getAtcocm().toUpperCase());
		}

		// actuacion alerta
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAlnror() != null) {
			where.append(" AND UPPER(t8.ALNROR) = ?");
			params.add(acta.getActuacion().getAlnror().toUpperCase());
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAlnran() != null) {
			where.append(" AND t8.ALNRAN = ?");
			params.add(acta.getActuacion().getAlnran());
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getActdec() != null
				&& acta.getActuacion().getActdec().getAdcoor() != null) {
			where.append(" AND UPPER(t12.ADCOOR) = ?");
			params.add(acta.getActuacion().getActdec().getAdcoor().toUpperCase());
		}

		// actuacion denuncia (solicitud empresas)
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDecoor() != null) {
			where.append(" AND UPPER(t10.decoor) = ?");
			params.add(acta.getActuacion().getDecoor().toUpperCase());
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDenror() != null) {
			where.append(" AND t10.denror = ?");
			params.add(acta.getActuacion().getDenror());
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDenran() != null) {
			where.append(" AND t10.denran = ?");
			params.add(acta.getActuacion().getDenran());
		}

		// actuacion comunicacion soivre
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getV6codigo() != null) {
			where.append(" AND t9.V6CODIGO = ?");
			params.add(acta.getActuacion().getV6codigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Acta entity
	 * 
	 * @param acta
	 *            Acta Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Acta acta, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ActaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (acta != null && acta.getAccodigo() != null) {
			where.append(" AND UPPER(t1.ACCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCODIGO IS NOT NULL");
		}
		if (acta != null && acta.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoor().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}
		if (acta != null && acta.getAcnror() != null) {
			where.append(" AND UPPER(t1.ACNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnror().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnror().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNROR IS NOT NULL");
		}
		if (acta != null && acta.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(acta.getAcnran());
		}
		if (acta != null && acta.getAccoinun() != null) {
			where.append(" AND UPPER(t1.ACCOINUN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoinun().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoinun().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOINUN IS NOT NULL");
		}
		if (acta != null && acta.getAccoindo() != null) {
			where.append(" AND UPPER(t1.ACCOINDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoindo().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoindo().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOINDO IS NOT NULL");
		}
		if (acta != null && acta.getAcfele() != null) {
			where.append(" AND t1.ACFELE = ?");
			params.add(acta.getAcfele());
		}
		if (acta != null && acta.getAcfere() != null) {
			where.append(" AND t1.ACFERE = ?");
			params.add(acta.getAcfere());
		}

		if (acta != null && acta.getAcfereDesde() != null && acta.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(acta.getAcfereDesde());
			where.append(" AND t1.ACFERE <= ?");
			params.add(acta.getAcfereHasta());

		} else if (acta != null && acta.getAcfereDesde() != null && acta.getAcfereHasta() == null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(acta.getAcfereDesde());

		} else if (acta != null && acta.getAcfereHasta() != null && acta.getAcfereDesde() == null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(acta.getAcfereHasta());
		}

		if (acta != null && acta.getAccoes() != null) {
			where.append(" AND UPPER(t1.ACCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoes().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoes().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOES IS NOT NULL");
		}
		if (acta != null && acta.getAccoav() != null) {
			where.append(" AND UPPER(t1.ACCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoav().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoav().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOAV IS NOT NULL");
		}
		if (acta != null && acta.getAccose() != null) {
			where.append(" AND UPPER(t1.ACCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccose().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccose().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOSE IS NOT NULL");
		}
		if (acta != null && acta.getAcfeex() != null) {
			where.append(" AND t1.ACFEEX = ?");
			params.add(acta.getAcfeex());
		}
		if (acta != null && acta.getAcinre() != null) {
			where.append(" AND UPPER(t1.ACINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcinre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcinre().toUpperCase() + "%");
			}
			where.append(" AND t1.ACINRE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoco() != null) {
			where.append(" AND UPPER(t1.ACNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcdnico() != null) {
			where.append(" AND UPPER(t1.ACDNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcdnico().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcdnico().toUpperCase() + "%");
			}
			where.append(" AND t1.ACDNICO IS NOT NULL");
		}
		if (acta != null && acta.getAccoco() != null) {
			where.append(" AND UPPER(t1.ACCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcdirco() != null) {
			where.append(" AND UPPER(t1.ACDIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcdirco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcdirco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACDIRCO IS NOT NULL");
		}
		if (acta != null && acta.getAccoloco() != null) {
			where.append(" AND UPPER(t1.ACCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoloco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoloco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOLOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnrcpco() != null) {
			where.append(" AND UPPER(t1.ACNRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnrcpco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnrcpco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNRCPCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnrtfco() != null) {
			where.append(" AND UPPER(t1.ACNRTFCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnrtfco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnrtfco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNRTFCO IS NOT NULL");
		}
		if (acta != null && acta.getAccotd() != null) {
			where.append(" AND UPPER(t1.ACCOTD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccotd().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccotd().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOTD IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPaisId() != null) {
			where.append(" AND UPPER(t1.ACNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PAIS_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.ACNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.ACNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreProvincia() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.ACNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.ACNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraCalleId() != null) {
			where.append(" AND UPPER(t1.ACNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_CALLE_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreCalle() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_CALLE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraCpId() != null) {
			where.append(" AND UPPER(t1.ACNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_CP_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreCp() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_CP IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPortalId() != null) {
			where.append(" AND UPPER(t1.ACNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PORTAL_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombrePortal() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_PORTAL IS NOT NULL");
		}
		if (acta != null && acta.getAcnombrePiso() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_PISO IS NOT NULL");
		}
		if (acta != null && acta.getAcdireccionNocapv() != null) {
			where.append(" AND UPPER(t1.ACDIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcdireccionNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcdireccionNocapv().toUpperCase() + "%");
			}
			where.append(" AND t1.ACDIRECCION_NOCAPV IS NOT NULL");
		}
		if (acta != null && acta.getAcape1co() != null) {
			where.append(" AND UPPER(t1.ACAPE1CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcape1co().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcape1co().toUpperCase() + "%");
			}
			where.append(" AND t1.ACAPE1CO IS NOT NULL");
		}
		if (acta != null && acta.getAcape2co() != null) {
			where.append(" AND UPPER(t1.ACAPE2CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcape2co().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcape2co().toUpperCase() + "%");
			}
			where.append(" AND t1.ACAPE2CO IS NOT NULL");
		}
		if (acta != null && acta.getAccodexpedienteorigen() != null) {
			where.append(" AND UPPER(t1.ACCODEXPEDIENTEORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccodexpedienteorigen().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccodexpedienteorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCODEXPEDIENTEORIGEN IS NOT NULL");
		}
		if (acta != null && acta.getAccoororigen() != null) {
			where.append(" AND UPPER(t1.ACCOORORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoororigen().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoororigen().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOORORIGEN IS NOT NULL");
		}
		if (acta != null && acta.getActiororigen() != null) {
			where.append(" AND UPPER(t1.ACTIORORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getActiororigen().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getActiororigen().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIORORIGEN IS NOT NULL");
		}
		if (acta != null && acta.getAcincumplimiento() != null) {
			where.append(" AND UPPER(t1.ACINCUMPLIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcincumplimiento().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcincumplimiento().toUpperCase() + "%");
			}
			where.append(" AND t1.ACINCUMPLIMIENTO IS NOT NULL");
		}

		// Establecimiento responsable

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnif() != null) {
			where.append(" AND UPPER(er.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimientoResponsable().getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimientoResponsable().getEsnif().toUpperCase() + "%");
			}
			where.append(" AND er.ESNIF IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnombre() != null) {
			where.append(" AND UPPER(er.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimientoResponsable().getEsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimientoResponsable().getEsnombre().toUpperCase() + "%");
			}
			where.append(" AND er.ESNOMBRE IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(er.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimientoResponsable().getEsnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimientoResponsable().getEsnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND er.ESNORA_PROVINCIA_ID IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(er.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimientoResponsable().getEsnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimientoResponsable().getEsnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND er.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnodir() != null) {
			where.append(" AND UPPER(er.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimientoResponsable().getEsnodir().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimientoResponsable().getEsnodir().toUpperCase() + "%");
			}
			where.append(" AND er.ESNODIR IS NOT NULL");
		}

		// Establecimiento

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(ev.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsnif().toUpperCase() + "%");
			}
			where.append(" AND ev.ESNIF IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(ev.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsnombre().toUpperCase() + "%");
			}
			where.append(" AND ev.ESNOMBRE IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(ev.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND ev.ESNORA_PROVINCIA_ID IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(ev.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND ev.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(ev.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnodir().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsnodir().toUpperCase() + "%");
			}
			where.append(" AND ev.ESNODIR IS NOT NULL");
		}

		// producto

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtcops() != null) {
			where.append(" AND UPPER(at.ATCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getActuacion().getAtcops().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getActuacion().getAtcops().toUpperCase() + "%");
			}
			where.append(" AND at.ATCOPS IS NOT NULL");
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtnoprse() != null) {
			where.append(" AND UPPER(at.atnoprse) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getActuacion().getAtnoprse().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getActuacion().getAtnoprse().toUpperCase() + "%");
			}
			where.append(" AND at.atnoprse IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Acta entity
	 * 
	 * @param acta
	 *            Acta Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereActaLikeMap(Acta acta) {

		StringBuilder where = new StringBuilder(ActaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (acta != null && acta.getAccodigo() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCODIGO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccodigo().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCODIGO IS NOT NULL");
		}
		if (acta != null && acta.getAccoor() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOOR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoor().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}
		if (acta != null && acta.getAccoorganismoorigen() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOORORIGEN),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoorganismoorigen().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOORORIGEN IS NOT NULL");
		}
		if (acta != null && acta.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ?");
			params.add(acta.getAcnror());
		}
		if (acta != null && acta.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(acta.getAcnran());
		}
		if (acta != null && acta.getAccoinun() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOINUN),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoinun().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOINUN IS NOT NULL");
		}
		if (acta != null && acta.getAccoindo() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOINDO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoindo().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOINDO IS NOT NULL");
		}
		if (acta != null && acta.getAcfele() != null) {
			where.append(" AND t1.ACFELE = ?");
			params.add(acta.getAcfele());
		}

		if (acta != null && acta.getAcfereDesde() != null && acta.getAcfereHasta() == null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(acta.getAcfereDesde());

		} else if (acta != null && acta.getAcfereDesde() == null && acta.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE <= ?");
			params.add(acta.getAcfereHasta());

		} else if (acta != null && acta.getAcfereDesde() != null && acta.getAcfereHasta() != null) {
			where.append(" AND t1.ACFERE >= ?");
			params.add(acta.getAcfereDesde());
			where.append(" AND t1.ACFERE < ?");
			Date dayAfter = new Date(acta.getAcfereHasta().getTime() + TimeUnit.DAYS.toMillis(1));
			params.add(dayAfter);
		}

		if (acta != null && acta.getAccoes() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOES),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoes().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOES IS NOT NULL");
		}
		if (acta != null && acta.getAccoav() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOAV),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoav().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOAV IS NOT NULL");
		}
		if (acta != null && acta.getAccose() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOSE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccose().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOSE IS NOT NULL");
		}
		if (acta != null && acta.getAcfeex() != null) {
			where.append(" AND t1.ACFEEX = ?");
			params.add(acta.getAcfeex());
		}
		if (acta != null && acta.getAcinre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACINRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcinre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACINRE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcdnico() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACDNICO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcdnico().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACDNICO IS NOT NULL");
		}
		if (acta != null && acta.getAccoco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcdirco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACDIRCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcdirco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACDIRCO IS NOT NULL");
		}
		if (acta != null && acta.getAccoloco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOLOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccoloco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOLOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnrcpco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNRCPCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnrcpco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNRCPCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnrtfco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNRTFCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnrtfco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNRTFCO IS NOT NULL");
		}
		if (acta != null && acta.getAccotd() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOTD),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccotd().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOTD IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPaisId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraPaisId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_PAIS_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPaisNombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_PAIS_NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraPaisNombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraProvinciaId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraProvinciaId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreProvincia() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_PROVINCIA),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombreProvincia().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraMunicipioId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraMunicipioId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreMunicipio() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_MUNICIPIO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombreMunicipio().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraLocalidadId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_LOCALIDAD_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraLocalidadId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreLocalidad() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_LOCALIDAD),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombreLocalidad().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraCalleId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_CALLE_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraCalleId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_CALLE_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreCalle() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_CALLE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombreCalle().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_CALLE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraCpId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_CP_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraCpId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_CP_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreCp() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_CP),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombreCp().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_CP IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPortalId() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNORA_PORTAL_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnoraPortalId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNORA_PORTAL_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombrePortal() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_PORTAL),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombrePortal().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_PORTAL IS NOT NULL");
		}
		if (acta != null && acta.getAcnombrePiso() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACNOMBRE_PISO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACNOMBRE_PISO IS NOT NULL");
		}
		if (acta != null && acta.getAcdireccionNocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcdireccionNocapv().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACDIRECCION_NOCAPV IS NOT NULL");
		}
		if (acta != null && acta.getAcape1co() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACAPE1CO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcape1co().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACAPE1CO IS NOT NULL");
		}
		if (acta != null && acta.getAcape2co() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACAPE2CO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAcape2co().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACAPE2CO IS NOT NULL");
		}
		if (acta != null && acta.getAccodexpedienteorigen() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCODEXPEDIENTEORIGEN),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccodexpedienteorigen().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCODEXPEDIENTEORIGEN IS NOT NULL");
		}

		if (acta != null && acta.getAccomo() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ACCOMO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getAccomo().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ACCOMO IS NOT NULL");
		}

		// Tramite
		if (acta != null && acta.getTrcodigo() != null) {
			where.append(
					" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND TICOTEE = ?) ");
			params.add(acta.getTrcodigo());

			if (acta != null && acta.getIndUltimoTramite() != null
					&& acta.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(" AND t2.TRCODIGOACTUAL = ? ");
				params.add(acta.getTrcodigo());
			}
		}

		// Decision
		if (acta != null && acta.getDecodigo() != null) {
			where.append(
					" AND (EXISTS (SELECT t1.DECODIGO DECODIGO FROM DECISION t1, ACTDEC tt2 WHERE 1=1 AND t1.DECODIGO=tt2.ADCOTTD AND tt2.ADCOAT=t2.ATCODIGO AND (t1.DECODIGO = ? OR t1.DECODIGO IN (SELECT DECODIGOL21 FROM CORRESPONDENCIA_DECISION_L21 WHERE DECODIGOY41B=?)))) ");
			params.add(acta.getDecodigo());
			params.add(acta.getDecodigo());
		}

		// Tramitador
		if (acta != null && acta.getMocodigoTramitador() != null) {

			if (acta != null && acta.getIndUltimoTramite() != null
					&& acta.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(
						" AND t2.TRCODIGOACTUAL IN (SELECT TICOTEE FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TICOMOASIGNADO = ?  AND TIFECHAFIN = (SELECT MAX(TIFECHAFIN) FROM TRAMITE_INSPECCION tr2 WHERE tr2.TIATCODIGO=t2.ATCODIGO ) ) ");
				params.add(acta.getMocodigoTramitador());
			} else {
				where.append(
						" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TICOMOASIGNADO = ?) ");
				params.add(acta.getMocodigoTramitador());
			}
		}

		// fecha decision desde
		if (acta != null && acta.getEhfechafinDecisionDesde() != null) {
			where.append(" AND t12.ADFEDE >= ?");
			params.add(acta.getEhfechafinDecisionDesde());
		}

		// fecha decision hasta
		if (acta != null && acta.getEhfechafinDecisionHasta() != null) {
			where.append(" AND t12.ADFEDE <= ?");
			params.add(acta.getEhfechafinDecisionHasta());
		}

		// Incluir expedientes cerrados
		if ((acta != null && acta.getIndIncluirCerrados() == null)
				|| (acta != null && acta.getIndIncluirCerrados() != null
						&& !acta.getIndIncluirCerrados().equals(Y41bConstantes.VALOR_SI))) {
			where.append(" AND t2.ATFECHACIERRE IS NULL ");
		}

		// Con acuse de recibo pendientes
		if (acta != null && acta.getIndPendienteAcuse() != null
				&& acta.getIndPendienteAcuse().equals(Y41bConstantes.VALOR_SI)) {
			// query solicitudes
			where.append(
					" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TICOTEE = ? AND tr1.TIFECHAFIN IS NULL) ");
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO);
		}

		// Con decision pendiente
		if (acta != null && acta.getIndPendienteDecision() != null
				&& acta.getIndPendienteDecision().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND (t12.ADCOTTD IS NULL ");

			where.append(" AND t2.ISKONTSUMOBIDE=?) ");
			params.add(Y41bConstantes.VALOR_SI);

			// where.append(" OR t12.ADCOTTD=?) ");
			// params.add(Y41bConstantes.DECISION_SINDECISION);
		}

		// Con pendiente firma
		if (acta != null && acta.getIndPendienteFirma() != null
				&& acta.getIndPendienteFirma().equals(Y41bConstantes.VALOR_SI)) {
			// query solicitudes
			where.append(
					" AND EXISTS (SELECT TIATCODIGO FROM TRAMITE_INSPECCION tr1 WHERE tr1.TIATCODIGO=t2.ATCODIGO AND tr1.TIESTADOTRAMITE = ?) ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
		}

		// Establecimiento responsable

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnif() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnif().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNIF IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t15.NIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnif().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NIF IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t3.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNOCO IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.ESNOCO IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnodir() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNODIR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnodir().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNODIR IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t15.NOMBRE_CALLE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnodir().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NOMBRE_CALLE IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraMunicipioId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add(
					"%" + acta.getEstablecimientoResponsable().getEsnoraMunicipioId().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_MUNICIPIO_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add(
					"%" + acta.getEstablecimientoResponsable().getEsnoraMunicipioId().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_MUNICIPIO_ID IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraProvinciaId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add(
					"%" + acta.getEstablecimientoResponsable().getEsnoraProvinciaId().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_PROVINCIA_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add(
					"%" + acta.getEstablecimientoResponsable().getEsnoraProvinciaId().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_PROVINCIA_ID IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimientoResponsable() != null
				&& acta.getEstablecimientoResponsable().getEsnoraPaisId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnoraPaisId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_PAIS_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimientoResponsable().getEsnoraPaisId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_PAIS_ID IS NOT NULL))");
		}

		// producto
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtcops() != null) {

			where.append(" AND TRANSLATE(UPPER(t2.ATCOPS),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getAtcops().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t2.ATCOPS IS NOT NULL");
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtnoprse() != null) {

			where.append(" AND TRANSLATE(UPPER(t2.ATNOPRSE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getAtnoprse().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t2.ATNOPRSE IS NOT NULL");
		}

		// es inspeccion nueva
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getIskontsumobide() != null) {

			where.append(" AND TRANSLATE(UPPER(t2.ISKONTSUMOBIDE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getIskontsumobide().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t2.ISKONTSUMOBIDE IS NOT NULL");
		}

		// -----------------------------------------------------------------------------------------------

		if (acta != null && acta.getAccoororigen() != null) {
			if ("1".equals(acta.getAccoororigen())) {
				where.append(" AND t2.ATCOCM IS NOT NULL");

			} else if ("2".equals(acta.getAccoororigen())) {
				where.append(" AND t2.ATCOAL IS NOT NULL");

			} else if ("3".equals(acta.getAccoororigen())) {
				where.append(" AND t2.ATIDCOMUNICACIONSOIVRE IS NOT NULL");

			} else if ("4".equals(acta.getAccoororigen())) {
				where.append(" AND t2.ATCOHD IS NOT NULL AND t2.ATCOHDDENUNCIA IS NULL");

			} else if ("5".equals(acta.getAccoororigen())) {
				where.append(" AND t2.ATCOHD IS NOT NULL AND t2.ATCOHDDENUNCIA IS NOT NULL");

			} else if ("6".equals(acta.getAccoororigen())) {
				where.append(
						" AND t2.ATCOCM IS NULL AND t2.ATCOAL IS NULL AND t2.ATIDCOMUNICACIONSOIVRE IS NULL AND t2.ATCOHD IS NULL AND t1.ACTIORORIGEN IS NULL ");
			} else if ("7".equals(acta.getAccoororigen())) {
				where.append(" AND t1.ACTIORORIGEN = ? ");
				params.add(Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA);
			} else if ("8".equals(acta.getAccoororigen())) {
				where.append(" AND t1.ACTIORORIGEN = ? ");
				params.add(Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES);
			}
		}

		// actuacion campaa para la busqueda de inspecciones
		if (acta != null && acta.getActuacion().getAtfinalizadas() == null) {
			if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtcocm() != null) {

				where.append(" AND ((TRANSLATE(UPPER(t2.ATCOCM),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%" + acta.getActuacion().getAtcocm().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
				where.append(" AND t2.ATCOCM IS NOT NULL) ");
				where.append(" OR (TRANSLATE(UPPER(t2.ATCOCMRELACIONADA),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%" + acta.getActuacion().getAtcocm().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
				where.append(" AND t2.ATCOCMRELACIONADA IS NOT NULL)) ");
			}
		}

		// actuacion campaa para la consulta de inspecciones de la campaa
		if (acta != null && acta.getActuacion().getAtfinalizadas() != null) {
			if (acta != null && acta.getActuacion().getAtcocm() != null) {
				where.append(" AND (t2.ATCOCM = ?");
				params.add(acta.getActuacion().getAtcocm());
				where.append(" OR t2.ATCOCMRELACIONADA = ?) ");
				params.add(acta.getActuacion().getAtcocm());
			}
		}

		// programacion campaa
		if (acta != null && acta.getActuacion().getAtcopg() != null) {
			where.append(" AND (t2.ATCOPG = ?");
			params.add(acta.getActuacion().getAtcopg());
			where.append(" OR t2.ATCOPGRELACIONADA = ?) ");
			params.add(acta.getActuacion().getAtcopg());
		}

		// actuacion alerta
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAlnror() != null) {

			where.append(" AND TRANSLATE(UPPER(t8.ALNROR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getAlnror().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t8.ALNROR IS NOT NULL");
		}

		// actuacion alerta

		if (acta != null && acta.getActuacion().getAtcoal() != null) {
			where.append(" AND (t2.ATCOAL = ?");
			params.add(acta.getActuacion().getAtcoal());
			where.append(" OR t2.ATCOALRELACIONADA = ?) ");
			params.add(acta.getActuacion().getAtcoal());
		}

		// programacion alerta
		if (acta != null && acta.getActuacion().getAtcocr() != null) {
			where.append(" AND (t2.ATCOCR = ?");
			params.add(acta.getActuacion().getAtcocr());
			where.append(" OR t2.ATCOCRRELACIONADA = ?) ");
			params.add(acta.getActuacion().getAtcocr());
		}

		if (acta != null && acta.getActuacion().getAtfinalizadas() != null) {
			where.append(" AND t2.ATFEFIN IS NOT NULL");
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAlnran() != null) {

			where.append(" AND TRANSLATE(UPPER(t8.ALNRAN),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getAlnran().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t8.ALNRAN IS NOT NULL");
		}

		// actuacion soivre
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getAtidcomunicacionsoivre() != null) {

			where.append(" AND TRANSLATE(UPPER(t3.ATIDCOMUNICACIONSOIVRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getAtidcomunicacionsoivre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ATIDCOMUNICACIONSOIVRE IS NOT NULL");
		}

		// actuacion solicitudes / denuncias
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDecoor() != null) {

			where.append(" AND TRANSLATE(UPPER(t10.DECOOR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getDecoor().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
		}
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDenror() != null) {

			where.append(" AND TRANSLATE(UPPER(t10.DENROR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getDenror().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
		}
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDenran() != null) {

			where.append(" AND TRANSLATE(UPPER(t10.DENRAN),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getDenran().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
		}

		// -----------------------------------------------------------------------------------------------

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getActdec() != null
				&& acta.getActuacion().getActdec().getAdcoor() != null) {

			where.append(" AND TRANSLATE(UPPER(t12.ADCOOR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getActdec().getAdcoor().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t12.ADCOOR IS NOT NULL");
		}

		// Establecimiento
		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnif().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNIF IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t16.NIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnif().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NIF IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t4.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNOCO IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.ESNOCO IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNODIR),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnodir().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNODIR IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t16.NOMBRE_CALLE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnodir().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NOMBRE_CALLE IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnoraMunicipioId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_MUNICIPIO_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnoraMunicipioId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_MUNICIPIO_ID IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnoraProvinciaId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_PROVINCIA_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnoraProvinciaId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_PROVINCIA_ID IS NOT NULL))");
		}

		if (acta != null && acta.getEstablecimiento() != null && acta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnoraPaisId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_PAIS_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getEstablecimiento().getEsnoraPaisId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_PAIS_ID IS NOT NULL))");
		}

		// actuacion denuncia (solicitud empresas)
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDecoor() != null) {
			where.append(" AND TRANSLATE(UPPER(t10.decoor),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getDecoor().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t10.decoor IS NOT NULL");
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDenror() != null) {
			where.append(" AND TRANSLATE(UPPER(t10.denror),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getDenror().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t10.denror IS NOT NULL");
		}

		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getDenran() != null) {
			where.append(" AND TRANSLATE(UPPER(t10.denran),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getDenran().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t10.denran IS NOT NULL");
		}

		// actuacion comunicacion soivre
		if (acta != null && acta.getActuacion() != null && acta.getActuacion().getV6codigo() != null) {
			where.append(" AND TRANSLATE(UPPER(t9.V6CODIGO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + acta.getActuacion().getV6codigo().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t9.V6CODIGO IS NOT NULL");
		}

		// tipo inspeccion
		if (acta != null && acta.getActuacion().getAttipo() != null) {
			where.append(" AND t2.ATTIPO = ?");
			params.add(acta.getActuacion().getAttipo());
		}

		// Codigo acta
		if (acta != null && acta.getAncodac() != null) {
			where.append(
					" AND EXISTS (SELECT ANCODIGO FROM ACTA_NUEVA tr1 WHERE tr1.ANCODINS=t2.ATCODIGO AND TRANSLATE(UPPER(tr1.ANCODAC),'','AEIOU') like ? ESCAPE  '\\' AND tr1.ANCODAC IS NOT NULL ) ");
			params.add("%" + acta.getAncodac().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Recupera la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllBandejaInspecciones(Acta filterActa, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.ACCODIGO ACCODIGO, t2.ATCODIGO ATCODIGO, t2.ISKONTSUMOBIDE ISKONTSUMOBIDE, t12.ADCOOR ADCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t2.ATCOCM ATCOCM, t9.V6CODIGO V6CODIGO, t10.DECOOR DECOOR, t10.DENROR DENROR, t10.DENRAN DENRAN, t8.ALNROR ALNROR, t8.ALNRAN ALNRAN, t2.ATNOPRSE ATNOPRSE, t2.ATNOMAPS ATNOMAPS, t2.ATNOMOPS ATNOMOPS, t2.ATNRLOPS ATNRLOPS, t3.ESNOMBRE ESNOMBRE, t6.MONOMBRE MONOMBRE, TO_CHAR(t1.ACFERE,'DD/MM/YYYY') ACFERE, TO_CHAR(t2.ATFEFIN,'DD/MM/YYYY') ATFEFIN ");

		query.append(
				"FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(filterActa);
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t2.ATCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t2.ATCOHD = t10.DECODIGO(+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BusquedaInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMapBusquedaInspeccionBandeja,
				params.toArray());
	}

	/**
	 * Recupera el count de la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaInspeccionesCount(Acta filterActa) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(filterActa);
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t2.ATCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t2.ATCOHD = t10.DECODIGO(+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	public Acta updateInspector(Acta acta) {
		String query = "UPDATE ACTA SET ACCOMO=? WHERE ACCODIGO=?";
		this.jdbcTemplate.update(query, acta.getAccomo(), acta.getAccodigo());
		return acta;
	}

	/**
	 * Recupera el siguiente acnror a utilizar al generar un nuevo expediente de
	 * inspecciones.
	 * 
	 * @param acta
	 *            Acta
	 * @return int
	 */
	public int getNextAcnror(Acta acta) {
		StringBuilder query = new StringBuilder(
				"SELECT NVL(MAX(ABS(ACNROR)),0)+1 ACNROR FROM ACTA WHERE ACCOOR = ? AND ACNRAN = ? AND REGEXP_LIKE(ACNROR,'^[0-9]+$') AND LPAD(ACNROR, 12)<LPAD('10000', 12)");
		return this.jdbcTemplate.queryForInt(query.toString(), acta.getAccoor(), acta.getAcnran());
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BusquedaInspeccion> findAllActaLikeBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t2.ISKONTSUMOBIDE ISKONTSUMOBIDE, t2.ATNROR ATNROR, t1.ACCODIGO ACCODIGO, t1.ACTIORORIGEN ACTIORORIGEN, t2.ATCODIGO ATCODIGO, t2.ATTIPO ATTIPO, t7.HDNROR HDNROR, t10.DECOOR DECOOR, t10.DENRAN DENRAN, t10.DENROR DENROR, t9.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t9.V6CODIGO V6CODIGO, t8.ALNROR ALNROR, t8.ALNRAN ALNRAN, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, TO_CHAR(t1.ACFERE,'DD/MM/YYYY') ACFERE, t6.MONOMBRE MONOMBRE, t2.ATNOPRSE ATNOPRSE, t2.ATNOMAPS ATNOMAPS, t2.ATNOMOPS ATNOMOPS, t2.ATNRLOPS ATNRLOPS, t2.ATCOCM ATCOCM, t2.ATCOHD ATCOHD, t2.ATCOHDDENUNCIA ATCOHDDENUNCIA, t2.ATCOAL ATCOAL, t2.ATIDCOMUNICACIONSOIVRE ATIDCOMUNICACIONSOIVRE, t11.FNOMBRE FNOMBRE, t11.FNOMBREE FNOMBREE, t13.DENOMBRE DENOMBRE, t13.DENOMBREE DENOMBREE, t14.TRNOMBRE TRNOMBRE, t14.TRNOMBREE TRNOMBREE, t15.NOMBRE RPNOMBRE, t15.ESNOCO RPNOCO, t16.NOMBRE ESNOMBRE, t16.NOMBRE_MUNICIPIO ESMUNICIPIO, t16.ESNOCO ESNOCO, t1.ACCOES, t2.ATCOES, NVL(t2.ATUINMOVILIZADAS,0) ATUINMOVILIZADAS, NVL(t2.ATUDESTRUIDAS,0) ATUDESTRUIDAS,NVL(t2.ATUDEVOLUCIONORIGEN,0) ATUDEVOLUCIONORIGEN, NVL(t2.ATULIBRECOMERCIALIZACION,0) ATULIBRECOMERCIALIZACION, NVL(t2.ATUOTROS,0) ATUOTROS, NVL(t2.ATUTOMAMUESTRAS,0) ATUTOMAMUESTRAS, (CASE WHEN t2.ATCOCM is not null THEN t2.ATCOCM WHEN t2.ATCOAL is not null THEN (SELECT ALNROR || '-' || ALNRAN FROM ALERTA t1a WHERE t2.ATCOAL = t1a.ALCODIGO) WHEN t2.ATIDCOMUNICACIONSOIVRE is not null THEN (SELECT V6CODIGO FROM COMUNICACION_SOIVRE t2a WHERE t2.ATIDCOMUNICACIONSOIVRE = t2a.IDCOMUNICACIONSOIVRE) WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is not null THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t2.ATCOHD = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is null THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t2.ATCOHD = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) ELSE null END) ORIGEN, (CASE WHEN t2.ATCOCM is not null THEN 'C' WHEN t2.ATCOAL is not null THEN 'A' WHEN t2.ATIDCOMUNICACIONSOIVRE is not null THEN 'S' WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is not null THEN 'D' WHEN t2.ATCOHD is not null AND t2.ATCOHDDENUNCIA is null THEN 'E' WHEN t1.ACTIORORIGEN = 'C' THEN 'X' WHEN t1.ACTIORORIGEN = 'N' THEN 'N' ELSE 'O' END) TIPOORIGEN, (NVL(t2.ATUINMOVILIZADAS,0) + NVL(t2.ATURECUPERADAS,0)) NUMPRODSENCONTRADOS, t2.ATADICIONAL ATADICIONAL ");
		query.append(
				"FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14, INTERVINIENTES t15, INTERVINIENTES t16 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActaLikeBusquedaCombinadaMap(busquedaCombinada);
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t1.ACCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t7.HDCODE = t10.DECODIGO (+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) AND t15.TIPO_INTERVINIENTE(+) = 'R' AND t2.ATCODIGO = t15.HDCODIGO(+) AND t16.TIPO_INTERVINIENTE(+) = 'V' AND t2.ATCODIGO = t16.HDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BusquedaInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMapBusquedaInspeccion,
				params.toArray());
	}

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append(
				"FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3, ESTABLECIMIENTO t4, PRODUCTO t5, MONITOR t6, HECDEN t7, ALERTA t8, COMUNICACION_SOIVRE t9, DENUNCIA t10, FASE t11, ACTDEC t12, DECISION t13, TRAMITE t14, INTERVINIENTES t15, INTERVINIENTES t16 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActaLikeBusquedaCombinadaMap(busquedaCombinada);
		StringBuilder where = new StringBuilder(
				"WHERE t1.ACCODIGO = t2.ATCOAC(+) AND t2.ATCOES = t3.ESCODIGO(+) AND t1.ACCOES = t4.ESCODIGO(+) AND t2.ATCOPS = t5.PSCODIGO(+) AND t1.ACCOMO = t6.MOCODIGO(+) AND t2.ATCOHD = t7.HDCODIGO(+) AND t2.ATCOAL = t8.ALCODIGO(+) AND t2.ATIDCOMUNICACIONSOIVRE = t9.IDCOMUNICACIONSOIVRE(+) AND t7.HDCODE = t10.DECODIGO (+) AND t2.ATCOAC = t11.FCODIGO(+) AND t2.ATCODIGO = t12.ADCOAT(+) AND t12.ADCOTTD = t13.DECODIGO(+) AND t2.TRCODIGOACTUAL = t14.TRCODIGO (+) AND t15.TIPO_INTERVINIENTE(+) = 'R' AND t2.ATCODIGO = t15.HDCODIGO(+) AND t16.TIPO_INTERVINIENTE(+) = 'V' AND t2.ATCODIGO = t16.HDCODIGO(+) ");

		where.append(mapaWhere.get("query"));

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Acta entity
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereActaLikeBusquedaCombinadaMap(BusquedaCombinada busquedaCombinada) {

		StringBuilder where = new StringBuilder(ActaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// Establecimiento responsable
		if (busquedaCombinada != null && busquedaCombinada.getDtcodigo() != null) {
			where.append(" AND t2.ATCOES = ? ");
			params.add(busquedaCombinada.getDtcodigo());
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtnif() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnif().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNIF IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t15.NIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnif().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NIF IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t3.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNOCO IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.ESNOCO IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtextranjero() != null
				&& busquedaCombinada.getDtestado() == null) {
			where.append(" AND ((t3.ESEXTRANJERO = ?)");
			params.add(Y41bConstantes.SI);
			where.append(" OR (t15.EXTRANJERO = ?)) ");
			params.add(Y41bConstantes.SI);
		}
		if (busquedaCombinada != null && busquedaCombinada.getDtestado() != null
				&& busquedaCombinada.getDtextranjero() == null) {
			where.append(" AND ((t3.ESEXTRANJERO = ?)");
			params.add(Y41bConstantes.NO);
			where.append(" OR (t15.EXTRANJERO = ?)) ");
			params.add(Y41bConstantes.NO);
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtnoraProvinciaId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraProvinciaId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_PROVINCIA_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraProvinciaId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_PROVINCIA_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtnoraMunicipioId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraMunicipioId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_MUNICIPIO_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraMunicipioId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_MUNICIPIO_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtnoraLocalidadId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_LOCALIDAD_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraLocalidadId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_LOCALIDAD_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_LOCALIDAD_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraLocalidadId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_LOCALIDAD_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtnoraPaisId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESNORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraPaisId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESNORA_PAIS_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t15.NORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtnoraPaisId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t15.NORA_PAIS_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtdireccion_nocapv() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t3.ESDIRECCION_NOCAPV IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t15.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");

			where.append(" AND t15.DIRECCION_NOCAPV IS NOT NULL))");

		}

		// Establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEscodigo() != null) {
			where.append(" AND t1.ACCOES = ? ");
			params.add(busquedaCombinada.getEscodigo());
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnif() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnif().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNIF IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t16.NIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnif().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NIF IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNOMBRE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NOMBRE IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnoco() != null) {

			where.append(" AND ((TRANSLATE(UPPER(t4.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNOCO IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.ESNOCO IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsextranjero() != null
				&& busquedaCombinada.getEsestado() == null) {
			where.append(" AND ((t4.ESEXTRANJERO = ?) ");
			params.add(Y41bConstantes.SI);
			where.append(" OR (t16.EXTRANJERO = ?))");
			params.add(Y41bConstantes.SI);
		}
		if (busquedaCombinada != null && busquedaCombinada.getEsestado() != null
				&& busquedaCombinada.getEsextranjero() == null) {
			where.append(" AND ((t4.ESEXTRANJERO = ?) ");
			params.add(Y41bConstantes.NO);
			where.append(" OR (t16.EXTRANJERO = ?))");
			params.add(Y41bConstantes.NO);
		}

		// Provincia establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraProvinciaId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraProvinciaId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraProvinciaId());
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnoraProvinciaId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraProvinciaId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_PROVINCIA_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_PROVINCIA_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraProvinciaId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_PROVINCIA_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnoraMunicipioId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraMunicipioId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_MUNICIPIO_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_MUNICIPIO_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraMunicipioId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_MUNICIPIO_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnoraLocalidadId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_LOCALIDAD_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraLocalidadId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_LOCALIDAD_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_LOCALIDAD_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraLocalidadId().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_LOCALIDAD_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsnoraPaisId() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESNORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraPaisId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESNORA_PAIS_ID IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t16.NORA_PAIS_ID),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsnoraPaisId().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t16.NORA_PAIS_ID IS NOT NULL))");
		}

		if (busquedaCombinada != null && busquedaCombinada.getEsdireccion_nocapv() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t4.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t4.ESDIRECCION_NOCAPV IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t16.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
					.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");

			where.append(" AND t16.DIRECCION_NOCAPV IS NOT NULL)) ");

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds rows in the ProtocoloInspeccion table using like.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipProtocolo> findAllProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TPCODIGO= t2.TPCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.TPCODIGO TPCODIGO,t1.TPNOMBRE TPNOMBRE,t1.TPCOTMO TPCOTMO, t1.TPESTANDAR TPESTANDAR "
						+ "FROM TIP_PROTOCOLO t1 ,PROTOCOLO_INSPECCION t2 ");

		if (protocoloInspeccion != null && protocoloInspeccion.getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ? ");
			params.add(protocoloInspeccion.getTpcodigo());
		}

		if (protocoloInspeccion != null && protocoloInspeccion.getAtcodigo() != null) {
			where.append(" AND t2.ATCODIGO = ? ");
			params.add(protocoloInspeccion.getAtcodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TipProtocolo>) this.jdbcTemplate.query(query.toString(), rwMapProtocoloInspeccion,
				params.toArray());
	}

	/**
	 * Counts rows in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllProtocoloInspeccionCount(ProtocoloInspeccion protocoloInspeccion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TPCODIGO= t2.TPCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t1.TPCODIGO) FROM  TIP_PROTOCOLO t1   ,  PROTOCOLO_INSPECCION t2  ");

		if (protocoloInspeccion != null && protocoloInspeccion.getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ? ");
			params.add(protocoloInspeccion.getTpcodigo());
		}

		if (protocoloInspeccion != null && protocoloInspeccion.getAtcodigo() != null) {
			where.append(" AND t2.ATCODIGO = ? ");
			params.add(protocoloInspeccion.getAtcodigo());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return ProtocoloInspeccion
	 */
	public ProtocoloInspeccion addProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion) {
		String query = "INSERT INTO PROTOCOLO_INSPECCION (TPCODIGO, ATCODIGO) VALUES (?,?)";

		this.jdbcTemplate.update(query, protocoloInspeccion.getTpcodigo(), protocoloInspeccion.getAtcodigo());
		return protocoloInspeccion;
	}

	/**
	 * Removes a single row in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 */
	public void removeProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion) {
		String query = "DELETE FROM PROTOCOLO_INSPECCION WHERE TPCODIGO=? AND ATCODIGO=?";
		this.jdbcTemplate.update(query, protocoloInspeccion.getTpcodigo(), protocoloInspeccion.getAtcodigo());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds an inspection.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return List
	 */
	@Transactional(readOnly = true)
	public InspeccionMovilidad findInspeccionMovilidad(Actuacion actuacion) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.Y7CODINSPECCION Y7CODINSPECCION,t1.Y7EVNOMBRE Y7EVNOMBRE,t1.Y7EVNIF Y7EVNIF,t1.Y7EVRAZON Y7EVRAZON,t1.Y7EVTELEFONO Y7EVTELEFONO,t1.Y7EVFAX Y7EVFAX,t1.Y7EVEMAIL Y7EVEMAIL,t1.Y7EVSECTOR Y7EVSECTOR,t1.Y7EVPROVINCIANBES Y7EVPROVINCIANBES,t1.Y7EVPROVINCIANBEU Y7EVPROVINCIANBEU,t1.Y7EVMUNICIPIONBES Y7EVMUNICIPIONBES,t1.Y7EVMUNICIPIONBEU Y7EVMUNICIPIONBEU,t1.Y7EVDIRECCION Y7EVDIRECCION,t1.Y7EVCP Y7EVCP,t1.Y7ERNOMBRE Y7ERNOMBRE,t1.Y7ERNIF Y7ERNIF,t1.Y7ERRAZON Y7ERRAZON,t1.Y7ERTELEFONO Y7ERTELEFONO,t1.Y7ERFAX Y7ERFAX,t1.Y7EREMAIL Y7EREMAIL,t1.Y7ERSECTOR Y7ERSECTOR,t1.Y7ERPROVINCIANBES Y7ERPROVINCIANBES,t1.Y7ERPROVINCIANBEU Y7ERPROVINCIANBEU,t1.Y7ERMUNICIPIONBES Y7ERMUNICIPIONBES,t1.Y7ERMUNICIPIONBEU Y7ERMUNICIPIONBEU,t1.Y7ERDIRECCION Y7ERDIRECCION,t1.Y7ERCP Y7ERCP,t1.Y7PRCODIGO Y7PRCODIGO,t1.Y7PRCODIGOBARRAS Y7PRCODIGOBARRAS,t1.Y7PRFECHACADUCIDAD Y7PRFECHACADUCIDAD,t1.Y7PRLOTE Y7PRLOTE,t1.Y7PRMARCA Y7PRMARCA,t1.Y7PRMODELO Y7PRMODELO,t1.Y7PRNOMBREES Y7PRNOMBREES,t1.Y7PRNOMBREEU Y7PRNOMBREEU,t1.Y7NOMBREPRODUCTO Y7NOMBREPRODUCTO "
						+ " FROM INSPECCION_MOVILIDAD t1  WHERE t1.Y7CODINSPECCION = ?");

		return this.jdbcTemplate.query(query.toString(), new RowMapper<InspeccionMovilidad>() {
			public InspeccionMovilidad mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				InspeccionMovilidad inspeccionMovilidad = new InspeccionMovilidad();
				inspeccionMovilidad.setCodInspeccion(resultSet.getString("Y7CODINSPECCION"));

				inspeccionMovilidad.setEvNombre(resultSet.getString("Y7EVNOMBRE"));
				inspeccionMovilidad.setEvNif(resultSet.getString("Y7EVNIF"));
				inspeccionMovilidad.setEvRazon(resultSet.getString("Y7EVRAZON"));
				inspeccionMovilidad.setEvTelefono(resultSet.getString("Y7EVTELEFONO"));
				inspeccionMovilidad.setEvFax(resultSet.getString("Y7EVFAX"));
				inspeccionMovilidad.setEvEmail(resultSet.getString("Y7EVEMAIL"));
				inspeccionMovilidad.setEvSector(resultSet.getString("Y7EVSECTOR"));
				inspeccionMovilidad.setEvProvinciaEs(resultSet.getString("Y7EVPROVINCIANBES"));
				inspeccionMovilidad.setEvProvinciaEu(resultSet.getString("Y7EVPROVINCIANBEU"));
				inspeccionMovilidad.setEvMunicipioEs(resultSet.getString("Y7EVMUNICIPIONBES"));
				inspeccionMovilidad.setEvMunicipioEu(resultSet.getString("Y7EVMUNICIPIONBEU"));
				inspeccionMovilidad.setEvDireccion(resultSet.getString("Y7EVDIRECCION"));
				inspeccionMovilidad.setEvCP(resultSet.getString("Y7EVCP"));

				inspeccionMovilidad.setErNombre(resultSet.getString("Y7ERNOMBRE"));
				inspeccionMovilidad.setErNif(resultSet.getString("Y7ERNIF"));
				inspeccionMovilidad.setErRazon(resultSet.getString("Y7ERRAZON"));
				inspeccionMovilidad.setErTelefono(resultSet.getString("Y7ERTELEFONO"));
				inspeccionMovilidad.setErFax(resultSet.getString("Y7ERFAX"));
				inspeccionMovilidad.setErEmail(resultSet.getString("Y7EREMAIL"));
				inspeccionMovilidad.setErSector(resultSet.getString("Y7ERSECTOR"));
				inspeccionMovilidad.setErProvinciaEs(resultSet.getString("Y7ERPROVINCIANBES"));
				inspeccionMovilidad.setErProvinciaEu(resultSet.getString("Y7ERPROVINCIANBEU"));
				inspeccionMovilidad.setErMunicipioEs(resultSet.getString("Y7ERMUNICIPIONBES"));
				inspeccionMovilidad.setErMunicipioEu(resultSet.getString("Y7ERMUNICIPIONBEU"));
				inspeccionMovilidad.setErDireccion(resultSet.getString("Y7ERDIRECCION"));
				inspeccionMovilidad.setErCP(resultSet.getString("Y7ERCP"));

				inspeccionMovilidad.setPrCodigo(resultSet.getString("Y7PRCODIGO"));
				inspeccionMovilidad.setPrCodigoBarras(resultSet.getString("Y7PRCODIGOBARRAS"));
				inspeccionMovilidad.setPrFechaCaducidad(resultSet.getDate("Y7PRFECHACADUCIDAD"));
				inspeccionMovilidad.setPrLote(resultSet.getString("Y7PRLOTE"));
				inspeccionMovilidad.setPrMarca(resultSet.getString("Y7PRMARCA"));
				inspeccionMovilidad.setPrModelo(resultSet.getString("Y7PRMODELO"));
				inspeccionMovilidad.setPrNombreEs(resultSet.getString("Y7PRNOMBREES"));
				inspeccionMovilidad.setPrNombreEu(resultSet.getString("Y7PRNOMBREEU"));
				inspeccionMovilidad.setPrNombreProducto(resultSet.getString("Y7NOMBREPRODUCTO"));

				return inspeccionMovilidad;
			}
		}, actuacion.getAtcodigo()).get(0);
	}
}
