package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DetalleConstatacion;
import com.ejie.y41b.model.DetalleDocumentos;
import com.ejie.y41b.model.DetalleInfraccion;
import com.ejie.y41b.model.DetalleMuestra;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionMovilidad;
import com.ejie.y41b.model.ProtocoloInspeccion;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.Tramite;

/**
 * ActaDao  
 * 
 *  
 */

public interface ActaDao {

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	Acta add(Acta acta);

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta addMasiva(Acta acta);

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	Acta update(Acta acta);

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta updateNumExpediente(Acta acta);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	Acta findVisita(Actuacion actuacion);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	Acta findActuacion(Actuacion actuacion);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	List<DetalleInfraccion> findInfracciones(Actuacion actuacion, Pagination pagination);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findInfraccionesCount(Actuacion actuacion);

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findInfraccionesProtocoloCount(Actuacion actuacion);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	List<DetalleConstatacion> findConstatacion(Actuacion actuacion, Pagination pagination);

	/**
	 * Finds a protocolo in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */
	List<DetalleProtocolo> findProtocolo(Actuacion actuacion, Pagination pagination);

	/**
	 * Finds a protocolo in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */
	List<DetalleProtocolo> findProtocolo(Actuacion actuacion, TipProtocolo tipProtocolo, Pagination pagination);

	/**
	 * Finds a in the Protocolo Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List<DetalleProtocolo>
	 */
	public DetalleProtocolo findRespuestaPreguntaProtocolo(Actuacion actuacion, TipPregProtoc tipPregProtoc);

	/**
	 * Finds a documentos in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */
	List<DetalleDocumentos> findDocumentos(Actuacion actuacion, Pagination pagination);

	/**
	 * Deletes a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return
	 */
	void remove(Acta acta);

	/**
	 * Removes a single row in the Acta table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return
	 */
	void removeActaExpediente(InspeccionDetalle inspeccionDetalle);

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	Acta updateEstablecimiento(Acta acta);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	Acta find(Acta acta);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Acta> findAll(Acta acta, Pagination pagination);

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	Long findAllCount(Acta acta);

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Acta> findAllLike(Acta acta, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BusquedaInspeccion> findAllActaLike(Acta acta, Pagination pagination);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Acta> findAllActaEstablecimiento(Acta acta, Pagination pagination);

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Acta acta, Boolean startsWith);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findConstatacionCount(Actuacion actuacion);

	/**
	 * Finds a num of protocol in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findProtocoloCount(Actuacion actuacion);

	/**
	 * Finds a num of documentos in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findDocumentosCount(Actuacion actuacion);

	/**
	 * Finds a Muestra.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return List
	 */
	DetalleMuestra findMuestra(Actuacion actuacion);

	/**
	 * Finds an Acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return String
	 */
	String findNumActa(Acta acta);

	/**
	 * Finds an inspection.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return List
	 */
	InspeccionDetalle findInspeccion(Actuacion actuacion);

	/**
	 * Finds an inspection By Numero Expediente.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return List
	 */
	public InspeccionDetalle findInspeccionByNumeroExpediente(InspeccionDetalle inspeccionDetalle);

	/**
	 * Finds numero de expediente.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	String findNumExpediente(Actuacion actuacion);

	/**
	 * Recupera la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllBandejaInspecciones(Acta filterActa, Pagination pagination);

	/**
	 * Recupera el count de la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @return Long
	 */
	public Long findAllBandejaInspeccionesCount(Acta filterActa);

	/**
	 * Finds a single row in the Tramite Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Tramite
	 */
	public Tramite findUltimoTramite(Actuacion actuacion);

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	Acta updateInspector(Acta acta);

	/**
	 * Recupera el siguiente acnror a utilizar al generar un nuevo expediente de
	 * inspecciones.
	 * 
	 * @param acta
	 *            Acta
	 * @return int
	 */
	int getNextAcnror(Acta acta);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllActaLikeBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination);

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllInspeccionesAbiertasInstructor(Acta acta, Pagination pagination);

	/**
	 * Finds rows in the ProtocoloInspeccion table using like.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAllProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion,
			Pagination pagination);

	/**
	 * Counts rows in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return Long
	 */
	public Long findAllProtocoloInspeccionCount(ProtocoloInspeccion protocoloInspeccion);

	/**
	 * Inserts a single row in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return ProtocoloInspeccion
	 */
	public ProtocoloInspeccion addProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion);

	/**
	 * Removes a single row in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 */
	public void removeProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion);

	/**
	 * Finds an inspection in the temp table
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return InspeccionMovilidad
	 */
	public InspeccionMovilidad findInspeccionMovilidad(Actuacion actuacion);

}
