package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * AaccDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccEuskadiSedeDaoImpl implements AaccEuskadiSedeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AaccEuskadiSede> rwMap = new RowMapper<AaccEuskadiSede>() {
		public AaccEuskadiSede mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AaccEuskadiSede(resultSet.getString("IDOTRASEDE"), resultSet.getString("CODORG"),
					resultSet.getString("ISNACIONAL"), resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"), resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"), resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"), resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"), resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"), resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"), resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"), resultSet.getString("COMPLEDIREC"), resultSet.getString("EMAIL"),
					resultSet.getString("TELEFONO"), resultSet.getString("SERVPRESENCIAL"),
					resultSet.getString("SERVTELEMATICA"), resultSet.getString("SERVTELEFONO"),
					resultSet.getString("SERVURL"), resultSet.getDate("FECULTMOD"), resultSet.getString("USUULTMOD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AaccEuskadiSede TEMP table.
	 *
	 * @param aaccEuskadiSede
	 *            Pagination
	 * @return AaccEuskadiSede
	 */
	public AaccEuskadiSede addTemp(AaccEuskadiSede aaccEuskadiSede) {
		String query = "INSERT INTO AACCEUSKADI_OTRASSEDES_TEMP (ID_OTRASEDE, COD_ORG, ISNACIONAL, NORA_PAIS_ID, NOMBRE_PAIS, NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, "
				+ "NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD, NORA_CALLE_ID, NOMBRE_CALLE, NORA_PORTAL_ID, NOMBRE_PORTAL, NORA_CP_ID, NOMBRE_CP, COMPLE_DIREC, "
				+ "EMAIL, TELEFONO, SERV_PRESENCIAL, SERV_TELEMATICA, SERV_TELEFONO, SERV_URL, FECULTMOD, USUULTMOD) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiSede.getIdSede(), aaccEuskadiSede.getCodOrg(),
				aaccEuskadiSede.getIsNacional(), aaccEuskadiSede.getNoraPaisId(), aaccEuskadiSede.getNombrePais(),
				aaccEuskadiSede.getNoraProvinciaId(), aaccEuskadiSede.getNombreProvincia(),
				aaccEuskadiSede.getNoraMunicipioId(), aaccEuskadiSede.getNombreMunicipio(),
				aaccEuskadiSede.getNoraLocalidadId(), aaccEuskadiSede.getNombreLocalidad(),
				aaccEuskadiSede.getNoraCalleId(), aaccEuskadiSede.getNombreCalle(), aaccEuskadiSede.getNoraPortalId(),
				aaccEuskadiSede.getNombrePortal(), aaccEuskadiSede.getNoraCpId(), aaccEuskadiSede.getNombreCP(),
				aaccEuskadiSede.getCompleDirec(), aaccEuskadiSede.getEmail(), aaccEuskadiSede.getTelefono(),
				aaccEuskadiSede.getServPresencial(), aaccEuskadiSede.getServTelematica(),
				aaccEuskadiSede.getServTelefono(), aaccEuskadiSede.getServUrl(), aaccEuskadiSede.getFecUltMod(),
				aaccEuskadiSede.getUsuUltMod());
		return aaccEuskadiSede;
	}

	/**
	 * Updates a single row in the AaccEuskadiSede table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	public AaccEuskadiSede update(AaccEuskadiSede aaccEuskadiSede) {
		String query = "UPDATE AACCEUSKADI_OTRASSEDES_TEMP SET COD_ORG=?, ISNACIONAL=?, NORA_PAIS_ID=?, NOMBRE_PAIS=?, NORA_PROVINCIA_ID=?, NOMBRE_PROVINCIA=?, "
				+ "NORA_MUNICIPIO_ID=?, NOMBRE_MUNICIPIO=?,	NORA_LOCALIDAD_ID=?, NOMBRE_LOCALIDAD=?, NORA_CALLE_ID=?, NOMBRE_CALLE=?, NORA_PORTAL_ID=?, NOMBRE_PORTAL=?, "
				+ "NORA_CP_ID=?, NOMBRE_CP=?,	COMPLE_DIREC=?, EMAIL=?, TELEFONO=?, SERV_PRESENCIAL=?, SERV_TELEMATICA=?, SERV_TELEFONO=?, SERV_URL=?, FECULTMOD=?, USUULTMOD=? "
				+ "WHERE ID_OTRASEDE=?";
		this.jdbcTemplate.update(query, aaccEuskadiSede.getCodOrg(), aaccEuskadiSede.getIsNacional(),
				aaccEuskadiSede.getNoraPaisId(), aaccEuskadiSede.getNombrePais(), aaccEuskadiSede.getNoraProvinciaId(),
				aaccEuskadiSede.getNombreProvincia(), aaccEuskadiSede.getNoraMunicipioId(),
				aaccEuskadiSede.getNombreMunicipio(), aaccEuskadiSede.getNoraLocalidadId(),
				aaccEuskadiSede.getNombreLocalidad(), aaccEuskadiSede.getNoraCalleId(),
				aaccEuskadiSede.getNombreCalle(), aaccEuskadiSede.getNoraPortalId(), aaccEuskadiSede.getNombrePortal(),
				aaccEuskadiSede.getNoraCpId(), aaccEuskadiSede.getNombreCP(), aaccEuskadiSede.getCompleDirec(),
				aaccEuskadiSede.getEmail(), aaccEuskadiSede.getTelefono(), aaccEuskadiSede.getServPresencial(),
				aaccEuskadiSede.getServTelematica(), aaccEuskadiSede.getServTelefono(), aaccEuskadiSede.getServUrl(),
				aaccEuskadiSede.getFecUltMod(), aaccEuskadiSede.getUsuUltMod(), aaccEuskadiSede.getIdSede());
		return aaccEuskadiSede;
	}

	/**
	 * Inserts a single row in the AaccEuskadiSede FINAL table.
	 *
	 * @param aaccEuskadiSede
	 *            Pagination
	 * @return AaccEuskadiSede
	 */
	public AaccEuskadiSede addFinal(AaccEuskadiSede aaccEuskadiSede) {
		String query = "INSERT INTO AACCEUSKADI_OTRASSEDES (ID_OTRASEDE, COD_ORG, ISNACIONAL, NORA_PAIS_ID, NOMBRE_PAIS, NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, "
				+ "NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD, NORA_CALLE_ID, NOMBRE_CALLE, NORA_PORTAL_ID, NOMBRE_PORTAL, NORA_CP_ID, NOMBRE_CP, COMPLE_DIREC, "
				+ "EMAIL, TELEFONO, SERV_PRESENCIAL, SERV_TELEMATICA, SERV_TELEFONO, SERV_URL, FECULTMOD, USUULTMOD) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiSede.getIdSede(), aaccEuskadiSede.getCodOrg(),
				aaccEuskadiSede.getIsNacional(), aaccEuskadiSede.getNoraPaisId(), aaccEuskadiSede.getNombrePais(),
				aaccEuskadiSede.getNoraProvinciaId(), aaccEuskadiSede.getNombreProvincia(),
				aaccEuskadiSede.getNoraMunicipioId(), aaccEuskadiSede.getNombreMunicipio(),
				aaccEuskadiSede.getNoraLocalidadId(), aaccEuskadiSede.getNombreLocalidad(),
				aaccEuskadiSede.getNoraCalleId(), aaccEuskadiSede.getNombreCalle(), aaccEuskadiSede.getNoraPortalId(),
				aaccEuskadiSede.getNombrePortal(), aaccEuskadiSede.getNoraCpId(), aaccEuskadiSede.getNombreCP(),
				aaccEuskadiSede.getCompleDirec(), aaccEuskadiSede.getEmail(), aaccEuskadiSede.getTelefono(),
				aaccEuskadiSede.getServPresencial(), aaccEuskadiSede.getServTelematica(),
				aaccEuskadiSede.getServTelefono(), aaccEuskadiSede.getServUrl(), aaccEuskadiSede.getFecUltMod(),
				aaccEuskadiSede.getUsuUltMod());
		return aaccEuskadiSede;
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadiSede> findAll(AaccEuskadiSede aaccEuskadiSede, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_OTRASEDE IDOTRASEDE, t1.COD_ORG CODORG, t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID , "
						+ "t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.COMPLE_DIREC COMPLEDIREC, "
						+ "t1.EMAIL EMAIL, t1.TELEFONO TELEFONO, t1.SERV_PRESENCIAL SERVPRESENCIAL, t1.SERV_TELEMATICA SERVTELEMATICA, t1.SERV_TELEFONO SERVTELEFONO, t1.SERV_URL SERVURL, t1.FECULTMOD FECULTMOD, t1.USUULTMOD USUULTMOD ");
		query.append(" FROM AACCEUSKADI_OTRASSEDES_TEMP t1");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG = ? ");
		params.add(aaccEuskadiSede.getCodOrg());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiSede>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadiSede> findAllFinal(AaccEuskadiSede aaccEuskadiSede, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_OTRASEDE IDOTRASEDE, t1.COD_ORG CODORG, t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID , "
						+ "t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.COMPLE_DIREC COMPLEDIREC, "
						+ "t1.EMAIL EMAIL, t1.TELEFONO TELEFONO, t1.SERV_PRESENCIAL SERVPRESENCIAL, t1.SERV_TELEMATICA SERVTELEMATICA, t1.SERV_TELEFONO SERVTELEFONO, t1.SERV_URL SERVURL, t1.FECULTMOD FECULTMOD, t1.USUULTMOD USUULTMOD ");
		query.append(" FROM AACCEUSKADI_OTRASSEDES t1");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG = ? ");
		params.add(aaccEuskadiSede.getCodOrg());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiSede>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AaccEuskadiSede aaccEuskadiSede) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct COD_ORG) FROM AACCEUSKADI_OTRASSEDES_TEMP t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG = ? ");
		params.add(aaccEuskadiSede.getCodOrg());
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void remove(AaccEuskadiSede aaccEuskadiSede) {
		String query = "DELETE FROM AACCEUSKADI_OTRASSEDES_TEMP WHERE ID_OTRASEDE=?";
		this.jdbcTemplate.update(query, aaccEuskadiSede.getIdSede());
	}

	/**
	 * Removes all rows in the AACCEUSKADI_OTRASSEDES table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiSede aaccEuskadiSede) {
		String query = "DELETE FROM AACCEUSKADI_OTRASSEDES WHERE COD_ORG=?";
		this.jdbcTemplate.update(query, aaccEuskadiSede.getCodOrg());
	}

	/**
	 * Removes all rows in the AACCEUSKADI_OTRASSEDES_TEMP table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiSede aaccEuskadiSede) {
		String query = "DELETE FROM AACCEUSKADI_OTRASSEDES_TEMP WHERE COD_ORG=?";
		this.jdbcTemplate.update(query, aaccEuskadiSede.getCodOrg());
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public AaccEuskadiSede findSede(AaccEuskadiSede aaccEuskadiSede) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_OTRASEDE IDOTRASEDE, t1.COD_ORG CODORG, t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID , "
						+ "t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.COMPLE_DIREC COMPLEDIREC, "
						+ "t1.EMAIL EMAIL, t1.TELEFONO TELEFONO, t1.SERV_PRESENCIAL SERVPRESENCIAL, t1.SERV_TELEMATICA SERVTELEMATICA, t1.SERV_TELEFONO SERVTELEFONO, t1.SERV_URL SERVURL, t1.FECULTMOD FECULTMOD, t1.USUULTMOD USUULTMOD ");
		query.append(" FROM AACCEUSKADI_OTRASSEDES_TEMP t1");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.ID_OTRASEDE = ? ");
		params.add(aaccEuskadiSede.getIdSede());
		query.append(where);

		return (AaccEuskadiSede) this.jdbcTemplate.queryForObject(query.toString(), this.rwMap, params.toArray());

	}
}
