package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Denuncia;

/**
 * AaccDao  
 * 
 *  
 */

public interface AaccEuskadiSedeDao {

	/**
	 * Inserts a single row in the Aacc table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	AaccEuskadiSede addTemp(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Updates a single row in the AaccEuskadiSede table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	AaccEuskadiSede update(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Finds a List of rows in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiSede> findAll(AaccEuskadiSede aaccEuskadiSede, Pagination pagination);

	/**
	 * Finds a List of rows in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiSede> findAllFinal(AaccEuskadiSede aaccEuskadiSede, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Deletes a single row in the AaccEuskadiSede table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return
	 */
	void remove(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Inserts a single row in the AaccEuskadiSede Final table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	AaccEuskadiSede addFinal(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Removes all rows in the AACCEUSKADI_OTRASSEDES table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Removes all rows in the AACCEUSKADI_OTRASSEDES_TEMP table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiSede aaccEuskadiSede);

	/**
	 * Finds a row in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * 
	 * @return AaccEuskadiSede
	 */
	public AaccEuskadiSede findSede(AaccEuskadiSede aaccEuskadiSede);

}
