package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AaccEuskadiOrganoGestor;

/**
 * AaccEuskadiOrganoGestorDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccEuskadiOrganoGestorDaoImpl implements AaccEuskadiOrganoGestorDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AaccEuskadiOrganoGestor> rwMap = new RowMapper<AaccEuskadiOrganoGestor>() {
		public AaccEuskadiOrganoGestor mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AaccEuskadiOrganoGestor(resultSet.getString("OGID"), resultSet.getString("OGNOMBRE"),
					resultSet.getString("OGAPELLIDO1"), resultSet.getString("OGAPELLIDO2"),
					resultSet.getString("OGCARGO"), resultSet.getString("OGCODORG"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the AaccEuskadiOrganoGestor table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadiOrganoGestor> findAll(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.OG_ID OGID, t1.OG_NOMBRE OGNOMBRE, t1.OG_APELLIDO_1 OGAPELLIDO1 "
						+ ", t1.OG_APELLIDO_2 OGAPELLIDO2, t1.OG_CARGO OGCARGO, t1.OG_COD_ORG OGCODORG ");

		query.append(" FROM AACCEUSKADI_ORGANO_GESTOR_TEMP t1, ORGANISMO_AACCEUSKADI t2 , AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.OG_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.OG_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.OG_COD_ORG = ? ");
		params.add(aaccEuskadiOrganoGestor.getOgCodOrg());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiOrganoGestor>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadiOrganoGestor table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return Long
	 */
	@Transactional(readOnly = true)

	public Long findAllCount(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct COD_ORG) ");
		query.append(" FROM AACCEUSKADI_ORGANO_GESTOR_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.OG_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.OG_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.OG_COD_ORG = ? ");
		params.add(aaccEuskadiOrganoGestor.getOgCodOrg());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the AaccEuskadiOrganoGestor TEMP table.
	 *
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return AaccEuskadiOrganoGestor
	 */
	public AaccEuskadiOrganoGestor addTemp(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {

		String query = "INSERT INTO AACCEUSKADI_ORGANO_GESTOR_TEMP (OG_ID, OG_NOMBRE, OG_APELLIDO_1, OG_APELLIDO_2, OG_CARGO, OG_COD_ORG) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiOrganoGestor.getOgId(), aaccEuskadiOrganoGestor.getOgNombre(),
				aaccEuskadiOrganoGestor.getOgApellido1(), aaccEuskadiOrganoGestor.getOgApellido2(),
				aaccEuskadiOrganoGestor.getOgCargo(), aaccEuskadiOrganoGestor.getOgCodOrg());
		return aaccEuskadiOrganoGestor;
	}

	/**
	 * Removes a single row in the AaccEuskadiOrganoGestor table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void remove(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		String query = "DELETE FROM AACCEUSKADI_ORGANO_GESTOR_TEMP WHERE OG_ID=?";
		this.jdbcTemplate.update(query, aaccEuskadiOrganoGestor.getOgId());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_ORGANO_GESTOR_TEMP table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		String query = "DELETE FROM AACCEUSKADI_ORGANO_GESTOR_TEMP WHERE OG_COD_ORG=?";
		this.jdbcTemplate.update(query, aaccEuskadiOrganoGestor.getOgCodOrg());
	}

	/**
	 * Finds a List of rows in the AaccEuskadiOrganoGestor table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadiOrganoGestor> findAllFinal(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.OG_ID OGID, t1.OG_NOMBRE OGNOMBRE, t1.OG_APELLIDO_1 OGAPELLIDO1 "
						+ ", t1.OG_APELLIDO_2 OGAPELLIDO2, t1.OG_CARGO OGCARGO, t1.OG_COD_ORG OGCODORG ");

		query.append(" FROM AACCEUSKADI_ORGANO_GESTOR t1, ORGANISMO_AACCEUSKADI t2 , AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.OG_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.OG_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.OG_COD_ORG = ? ");
		params.add(aaccEuskadiOrganoGestor.getOgCodOrg());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiOrganoGestor>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadiOrganoGestor table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return Long
	 */
	@Transactional(readOnly = true)

	public Long findAllFinalCount(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct COD_ORG) ");
		query.append(" FROM AACCEUSKADI_ORGANO_GESTOR t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.OG_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.OG_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.OG_COD_ORG = ? ");
		params.add(aaccEuskadiOrganoGestor.getOgCodOrg());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_ORGANO_GESTOR table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		String query = "DELETE FROM AACCEUSKADI_ORGANO_GESTOR WHERE OG_COD_ORG=?";
		this.jdbcTemplate.update(query, aaccEuskadiOrganoGestor.getOgCodOrg());
	}

	/**
	 * Inserts a single row in the AaccEuskadiOrganoGestor FINAL table.
	 *
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return AaccEuskadiOrganoGestor
	 */
	public AaccEuskadiOrganoGestor addFinal(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {

		String query = "INSERT INTO AACCEUSKADI_ORGANO_GESTOR (OG_ID, OG_NOMBRE, OG_APELLIDO_1, OG_APELLIDO_2, OG_CARGO, OG_COD_ORG) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiOrganoGestor.getOgId(), aaccEuskadiOrganoGestor.getOgNombre(),
				aaccEuskadiOrganoGestor.getOgApellido1(), aaccEuskadiOrganoGestor.getOgApellido2(),
				aaccEuskadiOrganoGestor.getOgCargo(), aaccEuskadiOrganoGestor.getOgCodOrg());
		return aaccEuskadiOrganoGestor;
	}
}
