package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AaccDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccEuskadiFederacionDaoImpl implements AaccEuskadiFederacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AaccEuskadiFederacion> rwMap = new RowMapper<AaccEuskadiFederacion>() {
		public AaccEuskadiFederacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AaccEuskadiFederacion(resultSet.getString("IDFEDERACION"),
					resultSet.getString("CODORGFEDERACION"), resultSet.getString("CODORGASOCOCOOP"),
					resultSet.getString("CIF"), resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
					resultSet.getString("EMAIL"), resultSet.getString("TELEFONO"), resultSet.getString("ISNACIONAL"),
					resultSet.getString("NORAPAISID"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
					resultSet.getString("COMPLEDIREC"), resultSet.getString("TIPOORG"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	// /**
	// * Inserts rows in the AaccEuskadiFederacion table.
	// *
	// * @param codOrgFederacion
	// * String
	// * @param codOrgAsocOCop
	// * String
	// * @return void
	// */
	// public void addMiembroFederacion(String codOrgFederacion, String
	// codOrgAsocOCop) {
	// String query = "INSERT INTO AACCEUSKADI_FEDERACION_TEMP (ID_FEDERACION,
	// COD_ORG_FEDERACION, COD_ORG_ASOCOCOOP) VALUES (?,?,?)";
	// this.jdbcTemplate.update(query,
	// Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
	// codOrgFederacion, codOrgAsocOCop);
	// }

	/**
	 * Inserts rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return AaccEuskadiFederacion
	 */
	public AaccEuskadiFederacion addTemp(AaccEuskadiFederacion aaccEuskadiFederacion) {
		String query = "INSERT INTO AACCEUSKADI_FEDERACION_TEMP (ID_FEDERACION, COD_ORG_FEDERACION, COD_ORG_ASOCOCOOP) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
				aaccEuskadiFederacion.getCodOrgFederacion(), aaccEuskadiFederacion.getCodOrgAsocOCoop());
		return aaccEuskadiFederacion;
	}

	/**
	 * Inserts a single row in the aaccEuskadiFederacion FINAL table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return AaccEuskadiFederacion
	 */
	public AaccEuskadiFederacion addFinal(AaccEuskadiFederacion aaccEuskadiFederacion) {
		String query = "INSERT INTO AACCEUSKADI_FEDERACION (ID_FEDERACION, COD_ORG_FEDERACION, COD_ORG_ASOCOCOOP) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiFederacion.getIdFederacion(),
				aaccEuskadiFederacion.getCodOrgFederacion(), aaccEuskadiFederacion.getCodOrgAsocOCoop());
		return aaccEuskadiFederacion;
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AaccEuskadiFederacion> findAll(AaccEuskadiFederacion aaccEuskadiFederacion, Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.ID_FEDERACION IDFEDERACION, t1.COD_ORG_FEDERACION CODORGFEDERACION, t1.COD_ORG_ASOCOCOOP CODORGASOCOCOOP "
						+ ", t2.CIF CIF, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.EMAIL EMAIL, t2.TELEFONO TELEFONO "
						+ ", t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS, t2.NORA_PROVINCIA_ID NORAPROVINCIAID, t2.NOMBRE_PROVINCIA NOMBREPROVINCIA "
						+ ", t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID NORALOCALIDADID, t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD "
						+ ", t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE ,t2.NORA_PORTAL_ID NORAPORTALID , t2.NOMBRE_PORTAL NOMBREPORTAL  "
						+ ", t2.NORA_CP_ID NORACPID, t2.NOMBRE_CP NOMBRECP, t2.COMPLE_DIREC COMPLEDIREC, t3.AETIPOORG TIPOORG");

		query.append(" FROM AACCEUSKADI_FEDERACION_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgFederacion());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiFederacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AaccEuskadiFederacion> findAllFinal(AaccEuskadiFederacion aaccEuskadiFederacion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.ID_FEDERACION IDFEDERACION, t1.COD_ORG_FEDERACION CODORGFEDERACION, t1.COD_ORG_ASOCOCOOP CODORGASOCOCOOP "
						+ ", t2.CIF CIF, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.EMAIL EMAIL, t2.TELEFONO TELEFONO "
						+ ", t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS, t2.NORA_PROVINCIA_ID NORAPROVINCIAID, t2.NOMBRE_PROVINCIA NOMBREPROVINCIA "
						+ ", t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID NORALOCALIDADID, t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD "
						+ ", t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE ,t2.NORA_PORTAL_ID NORAPORTALID , t2.NOMBRE_PORTAL NOMBREPORTAL  "
						+ ", t2.NORA_CP_ID NORACPID, t2.NOMBRE_CP NOMBRECP, t2.COMPLE_DIREC COMPLEDIREC, t3.AETIPOORG TIPOORG");

		query.append(" FROM AACCEUSKADI_FEDERACION t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgFederacion());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiFederacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AaccEuskadiFederacion aaccEuskadiFederacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct COD_ORG) FROM AACCEUSKADI_FEDERACION_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgFederacion());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long existeCount(AaccEuskadiFederacion aaccEuskadiFederacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct COD_ORG) FROM AACCEUSKADI_FEDERACION_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgFederacion());

		where.append(" AND t1.COD_ORG_ASOCOCOOP = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgAsocOCoop());
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void remove(AaccEuskadiFederacion aaccEuskadiFederacion) {
		String query = "DELETE FROM AACCEUSKADI_FEDERACION_TEMP WHERE ID_FEDERACION=?";
		this.jdbcTemplate.update(query, aaccEuskadiFederacion.getIdFederacion());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_FEDERACION table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiFederacion aaccEuskadiFederacion) {
		String query = "DELETE FROM AACCEUSKADI_FEDERACION WHERE COD_ORG_FEDERACION=?";
		this.jdbcTemplate.update(query, aaccEuskadiFederacion.getCodOrgFederacion());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_FEDERACION_TEMP table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiFederacion aaccEuskadiFederacion) {
		String query = "DELETE FROM AACCEUSKADI_FEDERACION_TEMP WHERE COD_ORG_FEDERACION=?";
		this.jdbcTemplate.update(query, aaccEuskadiFederacion.getCodOrgFederacion());
	}

	/**
	 * Busca todas las federaciones a las que pertenece la asociacion o
	 * cooperativa
	 * 
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AaccEuskadiFederacion> findAllFederaciones(AaccEuskadiFederacion aaccEuskadiFederacion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.ID_FEDERACION IDFEDERACION, t1.COD_ORG_FEDERACION CODORGFEDERACION, t1.COD_ORG_ASOCOCOOP CODORGASOCOCOOP "
						+ ", t2.CIF CIF, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.EMAIL EMAIL, t2.TELEFONO TELEFONO "
						+ ", t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS, t2.NORA_PROVINCIA_ID NORAPROVINCIAID, t2.NOMBRE_PROVINCIA NOMBREPROVINCIA "
						+ ", t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID NORALOCALIDADID, t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD "
						+ ", t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE ,t2.NORA_PORTAL_ID NORAPORTALID , t2.NOMBRE_PORTAL NOMBREPORTAL  "
						+ ", t2.NORA_CP_ID NORACPID, t2.NOMBRE_CP NOMBRECP, t2.COMPLE_DIREC COMPLEDIREC, t3.AETIPOORG TIPOORG");

		query.append(" FROM AACCEUSKADI_FEDERACION t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_FEDERACION=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_FEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_ASOCOCOOP = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgAsocOCoop());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiFederacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Cuenta todas las federaciones a las que pertenece la asociacion o
	 * cooperativa en la tabla final
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllFederacionesCount(AaccEuskadiFederacion aaccEuskadiFederacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct COD_ORG_FEDERACION) ");
		query.append(" FROM AACCEUSKADI_FEDERACION t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");
		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_ASOCOCOOP=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_ASOCOCOOP = ? ");
		params.add(aaccEuskadiFederacion.getCodOrgAsocOCoop());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_FEDERACION table.
	 * 
	 * @param codOrgAsocOCoop
	 *            String
	 * @return
	 */
	public void removeFromFederacionesFinalByCodAsoocOCoop(String codOrgAsocOCoop) {
		String query = "DELETE FROM AACCEUSKADI_FEDERACION WHERE COD_ORG_ASOCOCOOP=?";
		this.jdbcTemplate.update(query, codOrgAsocOCoop);
	}

}
