package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * AaccDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccEuskadiDaoImpl implements AaccEuskadiDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AaccEuskadi> rwMap = new RowMapper<AaccEuskadi>() {
		public AaccEuskadi mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AaccEuskadi(resultSet.getString("AENUMREGISTRO"), resultSet.getString("AECODIGO"),
					resultSet.getString("AETIPOORG"), resultSet.getString("AESERVPRESENCIAL"),
					resultSet.getString("AESERVTELEMATICA"), resultSet.getString("AESERVTELEFONO"),
					resultSet.getString("AESERVURL"), resultSet.getDate("AEFECHAALTA"),
					resultSet.getDate("AEFECHABAJA"), resultSet.getDate("AEFECHAULTMOD"),
					resultSet.getString("USUULTMODNB"), resultSet.getString("AENATURALEZAFEDERACION"),
					resultSet.getString("AETOTALSOCIOS"), resultSet.getString("AEAMBITOFUNCIONAL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AaccEuskadi table.
	 *
	 * @param AaccEuskadi
	 *            aaccEuskadi
	 * @return AaccEuskadi
	 */
	public AaccEuskadi add(AaccEuskadi aaccEuskadi) {
		String query = "INSERT INTO AACCEUSKADI (AENUMREGISTRO, AECODIGO, AETIPOORG, AESERVPRESENCIAL, AESERVTELEMATICA, AESERVTELEFONO, AESERVURL, AEFECHAALTA, AEFECHABAJA, AEFECHAULTMOD, USUULTMOD, AENATURALEZAFEDERACION, AETOTALSOCIOS, AEAMBITOFUNCIONAL) VALUES (?,?,?,?,?,?,?,SYSDATE,?,SYSDATE,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadi.getAeNumRegistro(), aaccEuskadi.getAeCodigo(),
				aaccEuskadi.getAeTipoOrg(), aaccEuskadi.getAeServPresencial(), aaccEuskadi.getAeServTelematica(),
				aaccEuskadi.getAeServTelefono(), aaccEuskadi.getAeServUrl(), aaccEuskadi.getAeFechaBaja(),
				aaccEuskadi.getAeUsuUltMod(), aaccEuskadi.getAeNaturalezaFederacion(), aaccEuskadi.getAeTotalSocios(),
				aaccEuskadi.getAeAmbitoFuncional());
		return aaccEuskadi;
	}

	/**
	 * Updates a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            Pagination
	 * @return AaccEuskadi
	 */
	public AaccEuskadi update(AaccEuskadi aaccEuskadi) {
		String query = "UPDATE AACCEUSKADI SET AETIPOORG=?, AESERVPRESENCIAL=?, AESERVTELEMATICA=?, AESERVTELEFONO=?, AESERVURL=?, AEFECHAULTMOD=SYSDATE, USUULTMOD=?, AENATURALEZAFEDERACION =?, AETOTALSOCIOS =?, AEAMBITOFUNCIONAL =? WHERE AECODIGO=?";
		this.jdbcTemplate.update(query, aaccEuskadi.getAeTipoOrg(), aaccEuskadi.getAeServPresencial(),
				aaccEuskadi.getAeServTelematica(), aaccEuskadi.getAeServTelefono(), aaccEuskadi.getAeServUrl(),
				aaccEuskadi.getAeUsuUltMod(), aaccEuskadi.getAeNaturalezaFederacion(), aaccEuskadi.getAeTotalSocios(),
				aaccEuskadi.getAeAmbitoFuncional(), aaccEuskadi.getAeCodigo());
		return aaccEuskadi;
	}

	/**
	 * Finds a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	@Transactional(readOnly = true)
	public AaccEuskadi find(AaccEuskadi aaccEuskadi) {
		String query = "SELECT t1.AENUMREGISTRO AENUMREGISTRO, t1.AECODIGO AECODIGO, t1.AETIPOORG AETIPOORG, t1.AESERVPRESENCIAL AESERVPRESENCIAL, t1.AESERVTELEMATICA AESERVTELEMATICA, "
				+ "t1.AESERVTELEFONO AESERVTELEFONO, t1.AESERVURL AESERVURL, t1.AEFECHAALTA AEFECHAALTA, t1.AEFECHABAJA AEFECHABAJA, t1.AEFECHAULTMOD AEFECHAULTMOD, t2.MONOMBRE USUULTMODNB, t1.AENATURALEZAFEDERACION AENATURALEZAFEDERACION, t1.AETOTALSOCIOS AETOTALSOCIOS, t1.AEAMBITOFUNCIONAL AEAMBITOFUNCIONAL "
				+ "FROM AACCEUSKADI t1,CENSO_MONITOR t2 WHERE t1.USUULTMOD=t2.MOCODIGO(+) AND t1.AECODIGO = ? ";

		List<AaccEuskadi> aaccEuskadiList = this.jdbcTemplate.query(query, this.rwMap, aaccEuskadi.getAeCodigo());
		return (AaccEuskadi) DataAccessUtils.uniqueResult(aaccEuskadiList);
	}

	/**
	 * Removes a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return
	 */
	public void remove(AaccEuskadi aaccEuskadi) {
		String query = "UPDATE AACCEUSKADI SET AEFECHABAJA=SYSDATE WHERE AECODIGO =? ";
		this.jdbcTemplate.update(query, aaccEuskadi.getAeCodigo());
	}

	// /**
	// * Finds a List of rows in the Aacc table.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @return List
	// */
	// @Transactional(readOnly = true)
	// public List<Aacc> findAll(Aacc aacc, Pagination pagination) {
	// StringBuilder query = new StringBuilder(
	// "SELECT t1.CCCODIGO CCCODIGO,t1.CCTESI CCTESI,t1.CCINFEDE CCINFEDE,
	// t1.CCCOCC CCCOCC, t1.CCFEAD CCFEAD,t1.CCNOREP CCNOREP,t1.CCNIREP
	// CCNIREP,t1.CCNOCARE CCNOCARE,t1.CCCOJA CCCOJA,t1.CCFEADFIN
	// CCFEADFIN,t1.CCFECALTA CCFECALTA,t1.CCUSUALTA CCUSUALTA,t1.CCFECMOD
	// CCFECMOD,t1.CCUSUMOD CCUSUMOD ");
	// query.append("FROM AACC t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereMap(aacc);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// if (pagination != null) {
	// query = pagination.getPaginationQuery(query);
	// }
	//
	// return (List<Aacc>) this.jdbcTemplate.query(query.toString(), this.rwMap,
	// params.toArray());
	// }
	//
	/**
	 * Counts rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AaccEuskadi aaccEuskadi) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AACCEUSKADI t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aaccEuskadi);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	//
	// /**
	// * Finds rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @param startsWith
	// * Boolean
	// * @return List
	// */
	// @Transactional(readOnly = true)
	// public List<Aacc> findAllLike(Aacc aacc, Pagination pagination, Boolean
	// startsWith) {
	// StringBuilder query = new StringBuilder(
	// "SELECT t1.CCCODIGO CCCODIGO,t1.CCTESI CCTESI,t1.CCINFEDE CCINFEDE,
	// t1.CCCOCC CCCOCC, t1.CCFEAD CCFEAD,t1.CCNOREP CCNOREP,t1.CCNIREP
	// CCNIREP,t1.CCNOCARE CCNOCARE,t1.CCCOJA CCCOJA,t1.CCFEADFIN
	// CCFEADFIN,t1.CCFECALTA CCFECALTA,t1.CCUSUALTA CCUSUALTA,t1.CCFECMOD
	// CCFECMOD,t1.CCUSUMOD CCUSUMOD,t2.CCCODIGO AACCCCCODIGO,t2.CCTESI
	// AACCCCTESI,t2.CCINFEDE AACCCCINFEDE,t2.CCFEAD AACCCCFEAD,t2.CCNOREP
	// AACCCCNOREP,t2.CCNIREP AACCCCNIREP,t2.CCNOCARE AACCCCNOCARE,t2.CCCOJA
	// AACCCCCOJA,t2.CCFEADFIN AACCCCFEADFIN,t2.CCFECALTA
	// AACCCCFECALTA,t2.CCUSUALTA AACCCCUSUALTA,t2.CCFECMOD
	// AACCCCFECMOD,t2.CCUSUMOD AACCCCUSUMOD,t2.CCCOCC AACCCCCOCC ");
	// query.append("FROM AACC t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereLikeMap(aacc, startsWith);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// if (pagination != null) {
	// query = pagination.getPaginationQuery(query);
	// }
	//
	// return (List<Aacc>) this.jdbcTemplate.query(query.toString(), this.rwMap,
	// params.toArray());
	// }
	//
	// /**
	// * Counts rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param startsWith
	// * Boolean
	// * @return Long
	// */
	// @Transactional(readOnly = true)
	// public Long findAllLikeCount(Aacc aacc, Boolean startsWith) {
	// StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AACC t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereLikeMap(aacc, startsWith);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// return this.jdbcTemplate.queryForLong(query.toString(),
	// params.toArray());
	// }

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aacc entity
	 *
	 * @param aacc
	 *            Aacc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AaccEuskadi aaccEuskadi) {

		StringBuilder where = new StringBuilder(AaccEuskadiDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// aacceuskadi
		if (aaccEuskadi != null && aaccEuskadi.getAeCodigo() != null) {
			where.append(" AND t1.AECODIGO = ?");
			params.add(aaccEuskadi.getAeCodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;

	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aacc entity
	 *
	 * @param aacc
	 *            Aacc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereBusquedaMap(AaccEuskadi aaccEuskadi) {

		StringBuilder where = new StringBuilder(AaccEuskadiDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// aacceuskadi
		if (aaccEuskadi != null && aaccEuskadi.getNumRegistro() != null) {
			where.append(" AND t1.AENUMREGISTRO = ?");
			params.add(aaccEuskadi.getNumRegistro());
		}

		if (aaccEuskadi != null
				&& (aaccEuskadi.getCheckAsociacion() != null || aaccEuskadi.getCheckCooperativa() != null
						|| aaccEuskadi.getCheckFederacion() != null || aaccEuskadi.getCheckConfederacion() != null)) {
			String tipos = "";
			where.append(" AND t1.AETIPOORG IN (");

			if (aaccEuskadi != null && aaccEuskadi.getCheckAsociacion() != null
					&& aaccEuskadi.getCheckAsociacion().equalsIgnoreCase(Y41bConstantes.SI)) {

				tipos = "?";
				params.add(Y41bConstantes.TIPO_ORG_ASOCIACION);
			}
			if (aaccEuskadi != null && aaccEuskadi.getCheckCooperativa() != null
					&& aaccEuskadi.getCheckCooperativa().equalsIgnoreCase(Y41bConstantes.SI)) {
				tipos = tipos + ("".equals(tipos) ? "?" : ",?");
				params.add(Y41bConstantes.TIPO_ORG_COOPERATIVA);
			}
			if (aaccEuskadi != null && aaccEuskadi.getCheckFederacion() != null
					&& aaccEuskadi.getCheckFederacion().equalsIgnoreCase(Y41bConstantes.SI)) {
				tipos = tipos + ("".equals(tipos) ? "?" : ",?");
				params.add(Y41bConstantes.TIPO_ORG_FEDERACION);
			}
			if (aaccEuskadi != null && aaccEuskadi.getCheckConfederacion() != null
					&& aaccEuskadi.getCheckConfederacion().equalsIgnoreCase(Y41bConstantes.SI)) {
				tipos = tipos + ("".equals(tipos) ? "?" : ",?");
				params.add(Y41bConstantes.TIPO_ORG_CONFEDERACION);
			}

			where.append(tipos);
			where.append(" ) ");
		}

		// if (aaccEuskadi != null && aaccEuskadi.getCheckBaja() != null
		// && aaccEuskadi.getCheckBaja().equalsIgnoreCase(Y41bConstantes.SI)) {
		// where.append(" AND t2.ACTIVA IS NOT NULL");
		// } else {
		// where.append(" AND t2.ACTIVA = ?");
		// params.add(Y41bConstantes.VALOR_SI);
		// }
		if (aaccEuskadi != null && aaccEuskadi.getCheckBaja() != null
				&& aaccEuskadi.getCheckBaja().equalsIgnoreCase(Y41bConstantes.SI)) {

		} else {
			where.append(" AND t1.AEFECHABAJA IS NULL");
		}
		if (aaccEuskadi != null && aaccEuskadi.getNif() != null) {

			where.append(" AND UPPER(t2.CIF) like ? ESCAPE  '\\'");

			params.add("%" + aaccEuskadi.getNif().toUpperCase() + "%");

			where.append(" AND t2.CIF IS NOT NULL");
		}

		if (aaccEuskadi != null && aaccEuskadi.getNombreEs() != null) {

			where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");

			params.add("%" + aaccEuskadi.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");

			where.append(" AND t2.NOMBRE_ES IS NOT NULL");
		}
		if (aaccEuskadi != null && aaccEuskadi.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");

			params.add("%" + aaccEuskadi.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");

			where.append(" AND t2.NOMBRE_EU IS NOT NULL");
		}

		if (aaccEuskadi != null && aaccEuskadi.getProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(aaccEuskadi.getProvinciaId());
		}

		if (aaccEuskadi != null && aaccEuskadi.getMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(aaccEuskadi.getMunicipioId());
		}

		if (aaccEuskadi != null && aaccEuskadi.getLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(aaccEuskadi.getLocalidadId());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	//
	// // CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	//
	// /**
	// * Returns a map with the needed value to create the conditions to filter
	// by
	// * the Aacc entity
	// *
	// * @param aacc
	// * Aacc Bean with the criteria values to filter by.
	// * @param startsWith
	// * Boolean
	// * @return Map created with two keys key query stores the sql query syntax
	// * key params stores the parameter values to be used in the
	// * condition sentence.
	// */
	// // CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	// private Map<String, ?> getWhereLikeMap(Aacc aacc, Boolean startsWith) {
	//
	// StringBuilder where = new
	// StringBuilder(AaccEuskadiDaoImpl.STRING_BUILDER_INIT);
	// List<Object> params = new ArrayList<Object>();
	//
	// if (aacc != null && aacc.getCccodigo() != null) {
	// where.append(" AND UPPER(t1.CCCODIGO) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCccodigo().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCccodigo().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCCODIGO IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCccocc() != null) {
	// where.append(" AND UPPER(t1.CCCOCC) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCccocc().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCccocc().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCCOCC IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCctesi() != null) {
	// where.append(" AND UPPER(t1.CCTESI) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCctesi().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCctesi().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCTESI IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCcinfede() != null) {
	// where.append(" AND UPPER(t1.CCINFEDE) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCcinfede().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCcinfede().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCINFEDE IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCcfead() != null) {
	// where.append(" AND t1.CCFEAD = ?");
	// params.add(aacc.getCcfead());
	// }
	// if (aacc != null && aacc.getCcnorep() != null) {
	// where.append(" AND UPPER(t1.CCNOREP) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCcnorep().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCcnorep().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCNOREP IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCcnirep() != null) {
	// where.append(" AND UPPER(t1.CCNIREP) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCcnirep().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCcnirep().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCNIREP IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCcnocare() != null) {
	// where.append(" AND UPPER(t1.CCNOCARE) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCcnocare().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCcnocare().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCNOCARE IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCccoja() != null) {
	// where.append(" AND UPPER(t1.CCCOJA) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCccoja().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCccoja().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCCOJA IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCcfeadfin() != null) {
	// where.append(" AND t1.CCFEADFIN = ?");
	// params.add(aacc.getCcfeadfin());
	// }
	// if (aacc != null && aacc.getCcfecalta() != null) {
	// where.append(" AND t1.CCFECALTA = ?");
	// params.add(aacc.getCcfecalta());
	// }
	// if (aacc != null && aacc.getCcusualta() != null) {
	// where.append(" AND UPPER(t1.CCUSUALTA) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCcusualta().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCcusualta().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCUSUALTA IS NOT NULL");
	// }
	// if (aacc != null && aacc.getCcfecmod() != null) {
	// where.append(" AND t1.CCFECMOD = ?");
	// params.add(aacc.getCcfecmod());
	// }
	// if (aacc != null && aacc.getCcusumod() != null) {
	// where.append(" AND UPPER(t1.CCUSUMOD) like ? ESCAPE '\\'");
	// if (startsWith) {
	// params.add(aacc.getCcusumod().toUpperCase() + "%");
	// } else {
	// params.add("%" + aacc.getCcusumod().toUpperCase() + "%");
	// }
	// where.append(" AND t1.CCUSUMOD IS NOT NULL");
	// }
	//
	// Map<String, Object> mapWhere = new HashMap<String, Object>();
	// mapWhere.put("query", where);
	// mapWhere.put("params", params);
	//
	// return mapWhere;
	// }

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<AaccEuskadi> rwMapBusqueda = new RowMapper<AaccEuskadi>() {
		public AaccEuskadi mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			AaccEuskadi aaccEuskadi = new AaccEuskadi(resultSet.getString("AENUMREGISTRO"),
					resultSet.getString("AETIPOORG"), resultSet.getDate("AEFECHABAJA"), resultSet.getString("AEACTIVA"),
					resultSet.getString("AECODIGO"), resultSet.getString("AENIF"), resultSet.getString("AENOMBREES"),
					resultSet.getString("AENOMBREEU"), resultSet.getString("AETERRITORIO"),
					resultSet.getString("AEMUNICIPIO"), resultSet.getString("AEDIRECCION"),
					resultSet.getString("AEPORTAL"), resultSet.getString("AECOMPLEDIREC"),
					resultSet.getString("AENATURALEZAFEDERACION"));
			// Organismo organismo = new Organismo();
			// organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			// organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			// organismo.setNombreMunicipio(resultSet.getString("OrganismoNOMBREMUNICIPIO"));
			// organismo.setDireccion(resultSet.getString("OrganismoDIRECCION"));
			// aaccEuskadi.setOrganismo(organismo);
			return aaccEuskadi;
		}
	};

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadi> findAllBusqueda(AaccEuskadi aaccEuskadi, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.AENUMREGISTRO AENUMREGISTRO,t1.AETIPOORG AETIPOORG, t1.AEFECHABAJA AEFECHABAJA ");
		query.append(
				" , t2.ACTIVA AEACTIVA, t2.COD_ORG AECODIGO, t2.CIF AENIF, t2.NOMBRE_ES AENOMBREES, t2.NOMBRE_EU AENOMBREEU, t2.NOMBRE_PROVINCIA AETERRITORIO, t2.NOMBRE_MUNICIPIO AEMUNICIPIO,t2.NOMBRE_CALLE AEDIRECCION, t2.NOMBRE_PORTAL AEPORTAL, t2.COMPLE_DIREC AECOMPLEDIREC, t1.AENATURALEZAFEDERACION  AENATURALEZAFEDERACION ");

		query.append(" FROM AACCEUSKADI t1, ORGANISMO_AACCEUSKADI t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereBusquedaMap(aaccEuskadi);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.AECODIGO=t2.COD_ORG(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadi>) this.jdbcTemplate.query(query.toString(), this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBusquedaCount(AaccEuskadi aaccEuskadi) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct AENUMREGISTRO) FROM AACCEUSKADI t1, ORGANISMO_AACCEUSKADI t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereBusquedaMap(aaccEuskadi);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.AECODIGO=t2.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadi> findAllAsocCoop(AaccEuskadi aaccEuskadi, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.AENUMREGISTRO AENUMREGISTRO,t1.AETIPOORG AETIPOORG, t1.AEFECHABAJA AEFECHABAJA ");
		query.append(
				" , t2.ACTIVA AEACTIVA, t2.COD_ORG AECODIGO, t2.CIF AENIF, t2.NOMBRE_ES AENOMBREES, t2.NOMBRE_EU AENOMBREEU, t2.NOMBRE_PROVINCIA AETERRITORIO, t2.NOMBRE_MUNICIPIO AEMUNICIPIO,t2.NOMBRE_CALLE AEDIRECCION, t2.NOMBRE_PORTAL AEPORTAL, t2.COMPLE_DIREC AECOMPLEDIREC, t1.AENATURALEZAFEDERACION AENATURALEZAFEDERACION ");

		query.append(" FROM AACCEUSKADI t1, ORGANISMO_AACCEUSKADI t2 ");

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		where.append(" AND t1.AECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.AEFECHABAJA IS NULL");

		if (aaccEuskadi.getAeTipoOrg() != null && aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("A")) {
			where.append(" AND t1.AETIPOORG = ? ");
			params.add(Y41bConstantes.TIPO_ORG_ASOCIACION);
		} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("C")) {
			where.append(" AND t1.AETIPOORG = ? ");
			params.add(Y41bConstantes.TIPO_ORG_COOPERATIVA);
		}

		where.append(" AND t1.AECODIGO != ? ");
		params.add(aaccEuskadi.getAeCodigo());

		query.append(where);

		return (List<AaccEuskadi>) this.jdbcTemplate.query(query.toString(), this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllAsocCoopCount(AaccEuskadi aaccEuskadi) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct AENUMREGISTRO) FROM AACCEUSKADI t1, ORGANISMO_AACCEUSKADI t2 ");

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		where.append(" AND t1.AECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.AEFECHABAJA IS NULL");

		if (aaccEuskadi.getAeTipoOrg() != null && aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("A")) {
			where.append(" AND t1.AETIPOORG = ? ");
			params.add(Y41bConstantes.TIPO_ORG_ASOCIACION);
		} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("C")) {
			where.append(" AND t1.AETIPOORG = ? ");
			params.add(Y41bConstantes.TIPO_ORG_COOPERATIVA);
		}
		where.append(" AND t1.AECODIGO != ? ");
		params.add(aaccEuskadi.getAeCodigo());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	//
	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadi> findAllFederaciones(AaccEuskadi aaccEuskadi, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.AENUMREGISTRO AENUMREGISTRO,t1.AETIPOORG AETIPOORG, t1.AEFECHABAJA AEFECHABAJA ");
		query.append(
				" , t2.ACTIVA AEACTIVA, t2.COD_ORG AECODIGO, t2.CIF AENIF, t2.NOMBRE_ES AENOMBREES, t2.NOMBRE_EU AENOMBREEU, t2.NOMBRE_PROVINCIA AETERRITORIO, t2.NOMBRE_MUNICIPIO AEMUNICIPIO,t2.NOMBRE_CALLE AEDIRECCION, t2.NOMBRE_PORTAL AEPORTAL, t2.COMPLE_DIREC AECOMPLEDIREC, t1.AENATURALEZAFEDERACION  AENATURALEZAFEDERACION ");

		query.append(" FROM AACCEUSKADI t1, ORGANISMO_AACCEUSKADI t2 ");

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		where.append(" AND t1.AECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.AEFECHABAJA IS NULL");
		where.append(" AND t1.AETIPOORG IN (?) ");
		params.add(Y41bConstantes.TIPO_ORG_FEDERACION);

		where.append(" AND t1.AENATURALEZAFEDERACION = ? ");
		params.add(aaccEuskadi.getAeNaturalezaFederacion());

		where.append(" AND t1.AECODIGO != ? ");
		params.add(aaccEuskadi.getAeCodigo());

		query.append(where);

		return (List<AaccEuskadi>) this.jdbcTemplate.query(query.toString(), this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllFederacionesCount(AaccEuskadi aaccEuskadi) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct AENUMREGISTRO) FROM AACCEUSKADI t1, ORGANISMO_AACCEUSKADI t2 ");

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		where.append(" AND t1.AECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.AEFECHABAJA IS NULL");
		where.append(" AND t1.AETIPOORG IN (?) ");
		params.add(Y41bConstantes.TIPO_ORG_FEDERACION);

		where.append(" AND t1.AENATURALEZAFEDERACION = ? ");
		params.add(aaccEuskadi.getAeNaturalezaFederacion());

		where.append(" AND t1.AECODIGO != ? ");
		params.add(aaccEuskadi.getAeCodigo());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Get a New num registro (AaccEuskadi).
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewNumRegistro() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT SEQ_L21Y8T00.NEXTVAL FROM  DUAL");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
