package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.AaccEuskadi;

/**
 * AaccEuskadiDao  
 * 
 *  
 */

public interface AaccEuskadiDao {

	/**
	 * Inserts a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	AaccEuskadi add(AaccEuskadi aaccEuskadi);

	/**
	 * Updates a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	AaccEuskadi update(AaccEuskadi aaccEuskadi);

	/**
	 * Finds a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	AaccEuskadi find(AaccEuskadi aaccEuskadi);

	/**
	 * Deletes a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return
	 */
	void remove(AaccEuskadi aaccEuskadi);

	// /**
	// * Finds a List of rows in the Aacc table.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @return List
	// */
	// List<Aacc> findAll(Aacc aacc, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllCount(AaccEuskadi aaccEuskadi);

	// /**
	// * Finds rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @param startsWith
	// * Boolean
	// * @return List
	// */
	// List<Aacc> findAllLike(Aacc aacc, Pagination pagination, Boolean
	// startsWith);
	//
	// /**
	// * Counts rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param startsWith
	// * Boolean
	// * @return Long
	// */
	// Long findAllLikeCount(Aacc aacc, Boolean startsWith);
	//
	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AaccEuskadi> findAllBusqueda(AaccEuskadi aaccEuskadi, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllBusquedaCount(AaccEuskadi aaccEuskadi);

	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AaccEuskadi> findAllAsocCoop(AaccEuskadi aaccEuskadi, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllAsocCoopCount(AaccEuskadi aaccEuskadi);

	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AaccEuskadi> findAllFederaciones(AaccEuskadi aaccEuskadi, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllFederacionesCount(AaccEuskadi aaccEuskadi);

	/**
	 * Get a New num registro (AaccEuskadi).
	 * 
	 * @return Long
	 */
	public Long getNewNumRegistro();
}
