package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AaccEuskadiCuota;

/**
 * AaccEuskadiCuotaDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccEuskadiCuotaDaoImpl implements AaccEuskadiCuotaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AaccEuskadiCuota> rwMap = new RowMapper<AaccEuskadiCuota>() {
		public AaccEuskadiCuota mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AaccEuskadiCuota(resultSet.getString("CUID"), resultSet.getString("CUCONCEPTO"),
					resultSet.getString("CUCUOTA"), resultSet.getString("CUNUMSOCIOS"),
					resultSet.getString("CUCODORG"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the AaccEuskadiCuota table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadiCuota> findAll(AaccEuskadiCuota aaccEuskadiCuota, Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.CU_ID CUID, t1.CU_CONCEPTO CUCONCEPTO, t1.CU_CUOTA CUCUOTA "
						+ ", t1.CU_NUM_SOCIOS CUNUMSOCIOS, t1.CU_COD_ORG CUCODORG ");

		query.append(" FROM AACCEUSKADI_CUOTAS_TEMP t1, ORGANISMO_AACCEUSKADI t2 , AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.CU_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.CU_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.CU_COD_ORG = ? ");
		params.add(aaccEuskadiCuota.getCuCodOrg());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiCuota>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadiCuota table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return Long
	 */
	@Transactional(readOnly = true)

	public Long findAllCount(AaccEuskadiCuota aaccEuskadiCuota) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct COD_ORG) ");
		query.append(" FROM AACCEUSKADI_CUOTAS_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.CU_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.CU_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.CU_COD_ORG = ? ");
		params.add(aaccEuskadiCuota.getCuCodOrg());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the AaccEuskadiCuota TEMP table.
	 *
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return AaccEuskadiCuota
	 */
	public AaccEuskadiCuota addTemp(AaccEuskadiCuota aaccEuskadiCuota) {

		String query = "INSERT INTO AACCEUSKADI_CUOTAS_TEMP (CU_ID, CU_CONCEPTO, CU_CUOTA, CU_NUM_SOCIOS, CU_COD_ORG) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiCuota.getCuId(), aaccEuskadiCuota.getCuConcepto(),
				aaccEuskadiCuota.getCuCuota(), aaccEuskadiCuota.getCuNumSocios(), aaccEuskadiCuota.getCuCodOrg());
		return aaccEuskadiCuota;
	}

	/**
	 * Removes a single row in the AaccEuskadiCuota table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void remove(AaccEuskadiCuota aaccEuskadiCuota) {
		String query = "DELETE FROM AACCEUSKADI_CUOTAS_TEMP WHERE CU_ID=?";
		this.jdbcTemplate.update(query, aaccEuskadiCuota.getCuId());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_CUOTAS_TEMP table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiCuota aaccEuskadiCuota) {
		String query = "DELETE FROM AACCEUSKADI_CUOTAS_TEMP WHERE CU_COD_ORG=?";
		this.jdbcTemplate.update(query, aaccEuskadiCuota.getCuCodOrg());
	}

	/**
	 * Finds a List of rows in the AaccEuskadiCuota table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AaccEuskadiCuota> findAllFinal(AaccEuskadiCuota aaccEuskadiCuota, Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.CU_ID CUID, t1.CU_CONCEPTO CUCONCEPTO, t1.CU_CUOTA CUCUOTA "
						+ ", t1.CU_NUM_SOCIOS CUNUMSOCIOS, t1.CU_COD_ORG CUCODORG ");

		query.append(" FROM AACCEUSKADI_CUOTAS t1, ORGANISMO_AACCEUSKADI t2 , AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.CU_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.CU_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.CU_COD_ORG = ? ");
		params.add(aaccEuskadiCuota.getCuCodOrg());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiCuota>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadiCuota table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return Long
	 */
	@Transactional(readOnly = true)

	public Long findAllFinalCount(AaccEuskadiCuota aaccEuskadiCuota) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct COD_ORG) ");
		query.append(" FROM AACCEUSKADI_CUOTAS t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append("AND t1.CU_COD_ORG=t2.COD_ORG(+) ");
		where.append("AND t1.CU_COD_ORG=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.CU_COD_ORG = ? ");
		params.add(aaccEuskadiCuota.getCuCodOrg());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_CUOTAS table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiCuota aaccEuskadiCuota) {
		String query = "DELETE FROM AACCEUSKADI_CUOTAS WHERE CU_COD_ORG=?";
		this.jdbcTemplate.update(query, aaccEuskadiCuota.getCuCodOrg());
	}

	/**
	 * Inserts a single row in the AaccEuskadiCuota TEMP table.
	 *
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return AaccEuskadiCuota
	 */
	public AaccEuskadiCuota addFinal(AaccEuskadiCuota aaccEuskadiCuota) {

		String query = "INSERT INTO AACCEUSKADI_CUOTAS (CU_ID, CU_CONCEPTO, CU_CUOTA, CU_NUM_SOCIOS, CU_COD_ORG) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiCuota.getCuId(), aaccEuskadiCuota.getCuConcepto(),
				aaccEuskadiCuota.getCuCuota(), aaccEuskadiCuota.getCuNumSocios(), aaccEuskadiCuota.getCuCodOrg());
		return aaccEuskadiCuota;
	}
}
