package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AaccEuskadiConfederacion;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AaccDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccEuskadiConfederacionDaoImpl implements AaccEuskadiConfederacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AaccEuskadiConfederacion> rwMap = new RowMapper<AaccEuskadiConfederacion>() {
		public AaccEuskadiConfederacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AaccEuskadiConfederacion(resultSet.getString("IDCONFEDERACION"),
					resultSet.getString("CODORGCONFEDERACION"), resultSet.getString("CODORGFEDERACION"),
					resultSet.getString("CIF"), resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
					resultSet.getString("EMAIL"), resultSet.getString("TELEFONO"), resultSet.getString("ISNACIONAL"),
					resultSet.getString("NORAPAISID"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
					resultSet.getString("COMPLEDIREC"), resultSet.getString("NATURALEZAFEDERACION"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return AaccEuskadiConfederacion
	 */
	public AaccEuskadiConfederacion addTemp(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		String query = "INSERT INTO AACCEUSKADI_CONFEDERACION_TEMP (ID_CONFEDERACION, COD_ORG_CONFEDERACION, COD_ORG_FEDERACION) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
				aaccEuskadiConfederacion.getCodOrgConfederacion(), aaccEuskadiConfederacion.getCodOrgFederacion());
		return aaccEuskadiConfederacion;
	}

	/**
	 * Inserts a single row in the aaccEuskadiConfederacion FINAL table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return AaccEuskadiConfederacion
	 */
	public AaccEuskadiConfederacion addFinal(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		String query = "INSERT INTO AACCEUSKADI_CONFEDERACION (ID_CONFEDERACION, COD_ORG_CONFEDERACION, COD_ORG_FEDERACION) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, aaccEuskadiConfederacion.getIdConfederacion(),
				aaccEuskadiConfederacion.getCodOrgConfederacion(), aaccEuskadiConfederacion.getCodOrgFederacion());
		return aaccEuskadiConfederacion;
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AaccEuskadiConfederacion> findAll(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.ID_CONFEDERACION IDCONFEDERACION, t1.COD_ORG_CONFEDERACION CODORGCONFEDERACION, t1.COD_ORG_FEDERACION CODORGFEDERACION "
						+ ", t2.CIF CIF, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.EMAIL EMAIL, t2.TELEFONO TELEFONO "
						+ ", t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS, t2.NORA_PROVINCIA_ID NORAPROVINCIAID, t2.NOMBRE_PROVINCIA NOMBREPROVINCIA "
						+ ", t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID NORALOCALIDADID, t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD "
						+ ", t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE ,t2.NORA_PORTAL_ID NORAPORTALID , t2.NOMBRE_PORTAL NOMBREPORTAL  "
						+ ", t2.NORA_CP_ID NORACPID, t2.NOMBRE_CP NOMBRECP, t2.COMPLE_DIREC COMPLEDIREC, t3.AENATURALEZAFEDERACION NATURALEZAFEDERACION ");

		query.append(" FROM AACCEUSKADI_CONFEDERACION_TEMP t1, ORGANISMO_AACCEUSKADI t2 , AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.COD_ORG_FEDERACION=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_FEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_CONFEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgConfederacion());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiConfederacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AaccEuskadiConfederacion> findAllFinal(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.ID_CONFEDERACION IDCONFEDERACION, t1.COD_ORG_CONFEDERACION CODORGCONFEDERACION, t1.COD_ORG_FEDERACION CODORGFEDERACION "
						+ ", t2.CIF CIF, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.EMAIL EMAIL, t2.TELEFONO TELEFONO "
						+ ", t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS, t2.NORA_PROVINCIA_ID NORAPROVINCIAID, t2.NOMBRE_PROVINCIA NOMBREPROVINCIA "
						+ ", t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID NORALOCALIDADID, t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD "
						+ ", t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE ,t2.NORA_PORTAL_ID NORAPORTALID , t2.NOMBRE_PORTAL NOMBREPORTAL  "
						+ ", t2.NORA_CP_ID NORACPID, t2.NOMBRE_CP NOMBRECP, t2.COMPLE_DIREC COMPLEDIREC, t3.AENATURALEZAFEDERACION NATURALEZAFEDERACION ");

		query.append(" FROM AACCEUSKADI_CONFEDERACION t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.COD_ORG_FEDERACION=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_FEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_CONFEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgConfederacion());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiConfederacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct COD_ORG) FROM AACCEUSKADI_CONFEDERACION_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder("  WHERE 1=1 AND t1.COD_ORG_FEDERACION=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_FEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_CONFEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgConfederacion());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long existeCount(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct COD_ORG) FROM AACCEUSKADI_CONFEDERACION_TEMP t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder("  WHERE 1=1 AND t1.COD_ORG_FEDERACION=t2.COD_ORG(+) ");
		where.append("AND t1.COD_ORG_FEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_CONFEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgConfederacion());

		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgFederacion());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void remove(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		String query = "DELETE FROM AACCEUSKADI_CONFEDERACION_TEMP WHERE ID_CONFEDERACION=?";
		this.jdbcTemplate.update(query, aaccEuskadiConfederacion.getIdConfederacion());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_CONFEDERACION table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		String query = "DELETE FROM AACCEUSKADI_CONFEDERACION WHERE COD_ORG_CONFEDERACION=?";
		this.jdbcTemplate.update(query, aaccEuskadiConfederacion.getCodOrgConfederacion());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_CONFEDERACION_TEMP table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		String query = "DELETE FROM AACCEUSKADI_CONFEDERACION_TEMP WHERE COD_ORG_CONFEDERACION=?";
		this.jdbcTemplate.update(query, aaccEuskadiConfederacion.getCodOrgConfederacion());
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)

	public List<AaccEuskadiConfederacion> findAllConfederaciones(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(

				"SELECT t1.ID_CONFEDERACION IDCONFEDERACION, t1.COD_ORG_CONFEDERACION CODORGCONFEDERACION, t1.COD_ORG_FEDERACION CODORGFEDERACION "
						+ ", t2.CIF CIF, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.EMAIL EMAIL, t2.TELEFONO TELEFONO "
						+ ", t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS, t2.NORA_PROVINCIA_ID NORAPROVINCIAID, t2.NOMBRE_PROVINCIA NOMBREPROVINCIA "
						+ ", t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID NORALOCALIDADID, t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD "
						+ ", t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE ,t2.NORA_PORTAL_ID NORAPORTALID , t2.NOMBRE_PORTAL NOMBREPORTAL  "
						+ ", t2.NORA_CP_ID NORACPID, t2.NOMBRE_CP NOMBRECP, t2.COMPLE_DIREC COMPLEDIREC, t3.AENATURALEZAFEDERACION NATURALEZAFEDERACION ");

		query.append(" FROM AACCEUSKADI_CONFEDERACION t1, ORGANISMO_AACCEUSKADI t2 , AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_CONFEDERACION=t2.COD_ORG(+)  ");
		where.append("AND t1.COD_ORG_CONFEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgFederacion());
		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AaccEuskadiConfederacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllConfederacionesCount(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct COD_ORG) FROM AACCEUSKADI_CONFEDERACION t1, ORGANISMO_AACCEUSKADI t2, AACCEUSKADI t3 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append("AND t1.COD_ORG_CONFEDERACION=t2.COD_ORG(+)  ");
		where.append("AND t1.COD_ORG_CONFEDERACION=t3.AECODIGO(+) ");
		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.COD_ORG_FEDERACION = ? ");
		params.add(aaccEuskadiConfederacion.getCodOrgFederacion());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the AACCEUSKADI_CONFEDERACION table.
	 * 
	 * @param codOrg
	 *            String
	 * @return
	 */
	public void removeFromConfederacionesFinalByCodFederacion(String codOrgFederacion) {
		String query = "DELETE FROM AACCEUSKADI_CONFEDERACION WHERE COD_ORG_FEDERACION=?";
		this.jdbcTemplate.update(query, codOrgFederacion);
	}
}
