package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AaccEuskadiConfederacion;
import com.ejie.y41b.model.AaccEuskadiFederacion;

/**
 * AaccDao  
 * 
 *  
 */

public interface AaccEuskadiConfederacionDao {

	/**
	 * Inserts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return AaccEuskadiConfederacion
	 */
	public AaccEuskadiConfederacion addTemp(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Finds a List of rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiConfederacion> findAll(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination);

	/**
	 * Finds a List of rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiConfederacion> findAllFinal(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long existeCount(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Deletes a single row in the AaccEuskadiConfederacion table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return
	 */
	void remove(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Inserts a single row in the AaccEuskadiConfederacion Final table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return AaccEuskadiConfederacion
	 */
	AaccEuskadiConfederacion addFinal(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Removes all rows in the AACCEUSKADI_CONFEDERACION table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return
	 */
	public void removeAllFinal(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Removes all rows in the AACCEUSKADI_CONFEDERACION_TEMP table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return
	 */
	public void removeAllTemp(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long findAllConfederacionesCount(AaccEuskadiConfederacion aaccEuskadiConfederacion);

	/**
	 * Finds a List of rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiConfederacion> findAllConfederaciones(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination);

	/**
	 * Removes a single row in the AACCEUSKADI_CONFEDERACION table.
	 * 
	 * @param codOrgFederacion
	 *            String
	 * @return
	 */
	public void removeFromConfederacionesFinalByCodFederacion(String codOrgFederacion);

}
