package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * AaccDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AaccDaoImpl implements AaccDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aacc> rwMap = new RowMapper<Aacc>() {
		public Aacc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aacc(resultSet.getString("CCCODIGO"),
					resultSet.getString("CCTESI"),
					resultSet.getString("CCINFEDE"),
					resultSet.getString("CCCOCC"), resultSet.getDate("CCFEAD"),
					resultSet.getString("CCNOREP"),
					resultSet.getString("CCNIREP"),
					resultSet.getString("CCNOCARE"),
					resultSet.getString("CCCOJA"),
					resultSet.getDate("CCFEADFIN"),
					resultSet.getDate("CCFECALTA"),
					resultSet.getString("CCUSUALTA"),
					resultSet.getDate("CCFECMOD"),
					resultSet.getString("CCUSUMOD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Pagination
	 * @return Aacc
	 */
	public Aacc add(Aacc aacc) {
		String query = "INSERT INTO AACC (CCCODIGO, CCTESI, CCINFEDE, CCCOCC, CCFEAD, CCNOREP, CCNIREP, CCNOCARE, CCCOJA, CCFEADFIN, CCFECALTA, CCUSUALTA, CCFECMOD, CCUSUMOD) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aacc.getCccodigo(), aacc.getCctesi(),
				aacc.getCcinfede(), aacc.getCccocc(), aacc.getCcfead(),
				aacc.getCcnorep(), aacc.getCcnirep(), aacc.getCcnocare(),
				aacc.getCccoja(), aacc.getCcfeadfin(), aacc.getCcfecalta(),
				aacc.getCcusualta(), aacc.getCcfecmod(), aacc.getCcusumod());
		return aacc;
	}

	/**
	 * Updates a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Pagination
	 * @return Aacc
	 */
	public Aacc update(Aacc aacc) {
		// String query =
		// "UPDATE AACC SET CCCOCC=?, CCTESI=?, CCINFEDE=?, CCFEAD=?, CCNOREP=?, CCNIREP=?, CCNOCARE=?, CCCOJA=?, CCFEADFIN=?, CCFECALTA=?, CCUSUALTA=?, CCFECMOD=?, CCUSUMOD=? WHERE CCCODIGO=?";
		String query = "UPDATE AACC SET CCTESI=?, CCNOREP=?, CCNIREP=?, CCFEAD=?, CCFEADFIN=? WHERE CCCODIGO=?";
		this.jdbcTemplate.update(query, aacc.getCctesi(), aacc.getCcnorep(),
				aacc.getCcnirep(), aacc.getCcfead(), aacc.getCcfeadfin(),
				aacc.getCccodigo());
		return aacc;
	}

	/**
	 * Finds a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Pagination
	 * @return Aacc
	 */
	@Transactional(readOnly = true)
	public Aacc find(Aacc aacc) {
		String query = "SELECT t1.CCCODIGO CCCODIGO, t1.CCTESI CCTESI, t1.CCINFEDE CCINFEDE, t1.CCCOCC CCCOCC, t1.CCFEAD CCFEAD, t1.CCNOREP CCNOREP, t1.CCNIREP CCNIREP, t1.CCNOCARE CCNOCARE, t1.CCCOJA CCCOJA, t1.CCFEADFIN CCFEADFIN, t1.CCFECALTA CCFECALTA, t1.CCUSUALTA CCUSUALTA, t1.CCFECMOD CCFECMOD, t2.USUARIOXLNET CCUSUMOD FROM AACC t1,CENSO_MONITOR t2 WHERE t1.CCUSUMOD=t2.MOCODIGO(+) AND t1.CCCODIGO = ? ";

		List<Aacc> aaccList = this.jdbcTemplate.query(query, this.rwMap,
				aacc.getCccodigo());
		return (Aacc) DataAccessUtils.uniqueResult(aaccList);
	}

	/**
	 * Removes a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Pagination
	 * @return
	 */
	public void remove(Aacc aacc) {
		String query = "DELETE FROM AACC WHERE CCCODIGO=?";
		this.jdbcTemplate.update(query, aacc.getCccodigo());
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aacc> findAll(Aacc aacc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CCCODIGO CCCODIGO,t1.CCTESI CCTESI,t1.CCINFEDE CCINFEDE, t1.CCCOCC CCCOCC, t1.CCFEAD CCFEAD,t1.CCNOREP CCNOREP,t1.CCNIREP CCNIREP,t1.CCNOCARE CCNOCARE,t1.CCCOJA CCCOJA,t1.CCFEADFIN CCFEADFIN,t1.CCFECALTA CCFECALTA,t1.CCUSUALTA CCUSUALTA,t1.CCFECMOD CCFECMOD,t1.CCUSUMOD CCUSUMOD ");
		query.append("FROM AACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aacc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aacc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aacc aacc) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aacc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Aacc table using like.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aacc> findAllLike(Aacc aacc, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CCCODIGO CCCODIGO,t1.CCTESI CCTESI,t1.CCINFEDE CCINFEDE, t1.CCCOCC CCCOCC, t1.CCFEAD CCFEAD,t1.CCNOREP CCNOREP,t1.CCNIREP CCNIREP,t1.CCNOCARE CCNOCARE,t1.CCCOJA CCCOJA,t1.CCFEADFIN CCFEADFIN,t1.CCFECALTA CCFECALTA,t1.CCUSUALTA CCUSUALTA,t1.CCFECMOD CCFECMOD,t1.CCUSUMOD CCUSUMOD,t2.CCCODIGO AACCCCCODIGO,t2.CCTESI AACCCCTESI,t2.CCINFEDE AACCCCINFEDE,t2.CCFEAD AACCCCFEAD,t2.CCNOREP AACCCCNOREP,t2.CCNIREP AACCCCNIREP,t2.CCNOCARE AACCCCNOCARE,t2.CCCOJA AACCCCCOJA,t2.CCFEADFIN AACCCCFEADFIN,t2.CCFECALTA AACCCCFECALTA,t2.CCUSUALTA AACCCCUSUALTA,t2.CCFECMOD AACCCCFECMOD,t2.CCUSUMOD AACCCCUSUMOD,t2.CCCOCC AACCCCCOCC ");
		query.append("FROM AACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aacc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aacc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aacc table using like.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aacc aacc, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aacc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aacc entity
	 * 
	 * @param aacc
	 *            Aacc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aacc aacc) {

		StringBuilder where = new StringBuilder(AaccDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aacc != null && !Y41bUtils.esNullOCadenaVacia(aacc.getCccodigo())) {
			where.append(" AND TRANSLATE(UPPER(t1.CCCODIGO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ aacc.getCccodigo().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.CCCODIGO IS NOT NULL");
		}
		if (aacc != null && !Y41bUtils.esNullOCadenaVacia(aacc.getCctesi())) {
			where.append(" AND TRANSLATE(UPPER(t1.CCTESI),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ aacc.getCctesi().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.CCTESI IS NOT NULL");
		}
		// Organismo
		if (aacc != null && aacc.getOrganismo() != null) {
			if (!Y41bUtils
					.esNullOCadenaVacia(aacc.getOrganismo().getNombreEs())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ aacc.getOrganismo().getNombreEs().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
				where.append(" AND t2.NOMBRE_ES IS NOT NULL");
			}
			if (!Y41bUtils
					.esNullOCadenaVacia(aacc.getOrganismo().getNombreEu())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ aacc.getOrganismo().getNombreEu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
				where.append(" AND t2.NOMBRE_EU IS NOT NULL");
			}
			if (!Y41bUtils.esNullOCadenaVacia(aacc.getOrganismo()
					.getNoraProvinciaId())) {
				where.append(" AND t2.NORA_PROVINCIA_ID = ?");
				params.add(aacc.getOrganismo().getNoraProvinciaId());
			}
			if (!Y41bUtils.esNullOCadenaVacia(aacc.getOrganismo()
					.getNoraMunicipioId())) {
				where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
				params.add(aacc.getOrganismo().getNoraMunicipioId());
			}
			if (!Y41bUtils.esNullOCadenaVacia(aacc.getOrganismo()
					.getNoraLocalidadId())) {
				where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
				params.add(aacc.getOrganismo().getNoraLocalidadId());
			}
		}
		// Territorio de actuacion
		if (aacc != null
				&& (!Y41bUtils.esNullOCadenaVacia(aacc.getCcThActAraba())
						|| !Y41bUtils.esNullOCadenaVacia(aacc
								.getCcThActBizkaia()) || !Y41bUtils
						.esNullOCadenaVacia(aacc.getCcThActGipuzkoa()))) {
			where.append(" AND ( ");
			if (aacc != null
					&& !Y41bUtils.esNullOCadenaVacia(aacc.getCcThActAraba())) {
				where.append(" t4.M7COTA1 = ? ");
				params.add(aacc.getCcThActAraba());
			}
			if (aacc != null
					&& !Y41bUtils.esNullOCadenaVacia(aacc.getCcThActBizkaia())) {
				if (aacc != null
						&& !Y41bUtils
								.esNullOCadenaVacia(aacc.getCcThActAraba())) {
					where.append(" OR ");
				}
				where.append(" t4.M7COTA1 = ? ");
				params.add(aacc.getCcThActBizkaia());
			}
			if (aacc != null
					&& !Y41bUtils.esNullOCadenaVacia(aacc.getCcThActGipuzkoa())) {
				if (aacc != null
						&& (!Y41bUtils.esNullOCadenaVacia(aacc
								.getCcThActAraba()) || !Y41bUtils
								.esNullOCadenaVacia(aacc.getCcThActBizkaia()))) {
					where.append(" OR ");
				}
				where.append(" t4.M7COTA1 = ? ");
				params.add(aacc.getCcThActGipuzkoa());
			}
			where.append(" ) ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aacc entity
	 * 
	 * @param aacc
	 *            Aacc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Aacc aacc, Boolean startsWith) {

		StringBuilder where = new StringBuilder(AaccDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aacc != null && aacc.getCccodigo() != null) {
			where.append(" AND UPPER(t1.CCCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCccodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CCCODIGO IS NOT NULL");
		}
		if (aacc != null && aacc.getCccocc() != null) {
			where.append(" AND UPPER(t1.CCCOCC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCccocc().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCccocc().toUpperCase() + "%");
			}
			where.append(" AND t1.CCCOCC IS NOT NULL");
		}
		if (aacc != null && aacc.getCctesi() != null) {
			where.append(" AND UPPER(t1.CCTESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCctesi().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCctesi().toUpperCase() + "%");
			}
			where.append(" AND t1.CCTESI IS NOT NULL");
		}
		if (aacc != null && aacc.getCcinfede() != null) {
			where.append(" AND UPPER(t1.CCINFEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCcinfede().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCcinfede().toUpperCase() + "%");
			}
			where.append(" AND t1.CCINFEDE IS NOT NULL");
		}
		if (aacc != null && aacc.getCcfead() != null) {
			where.append(" AND t1.CCFEAD = ?");
			params.add(aacc.getCcfead());
		}
		if (aacc != null && aacc.getCcnorep() != null) {
			where.append(" AND UPPER(t1.CCNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCcnorep().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCcnorep().toUpperCase() + "%");
			}
			where.append(" AND t1.CCNOREP IS NOT NULL");
		}
		if (aacc != null && aacc.getCcnirep() != null) {
			where.append(" AND UPPER(t1.CCNIREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCcnirep().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCcnirep().toUpperCase() + "%");
			}
			where.append(" AND t1.CCNIREP IS NOT NULL");
		}
		if (aacc != null && aacc.getCcnocare() != null) {
			where.append(" AND UPPER(t1.CCNOCARE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCcnocare().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCcnocare().toUpperCase() + "%");
			}
			where.append(" AND t1.CCNOCARE IS NOT NULL");
		}
		if (aacc != null && aacc.getCccoja() != null) {
			where.append(" AND UPPER(t1.CCCOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCccoja().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCccoja().toUpperCase() + "%");
			}
			where.append(" AND t1.CCCOJA IS NOT NULL");
		}
		if (aacc != null && aacc.getCcfeadfin() != null) {
			where.append(" AND t1.CCFEADFIN = ?");
			params.add(aacc.getCcfeadfin());
		}
		if (aacc != null && aacc.getCcfecalta() != null) {
			where.append(" AND t1.CCFECALTA = ?");
			params.add(aacc.getCcfecalta());
		}
		if (aacc != null && aacc.getCcusualta() != null) {
			where.append(" AND UPPER(t1.CCUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCcusualta().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCcusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.CCUSUALTA IS NOT NULL");
		}
		if (aacc != null && aacc.getCcfecmod() != null) {
			where.append(" AND t1.CCFECMOD = ?");
			params.add(aacc.getCcfecmod());
		}
		if (aacc != null && aacc.getCcusumod() != null) {
			where.append(" AND UPPER(t1.CCUSUMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aacc.getCcusumod().toUpperCase() + "%");
			} else {
				params.add("%" + aacc.getCcusumod().toUpperCase() + "%");
			}
			where.append(" AND t1.CCUSUMOD IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<Aacc> rwMapBusqueda = new RowMapper<Aacc>() {
		public Aacc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Aacc aacc = new Aacc(resultSet.getString("CCCODIGO"),
					resultSet.getString("CCTESI"), null, null,
					resultSet.getDate("CCFEAD"),
					resultSet.getString("CCNOREP"),
					resultSet.getString("CCNIREP"), null, null,
					resultSet.getDate("CCFEADFIN"),
					resultSet.getDate("CCFECALTA"),
					resultSet.getString("CCUSUALTA"),
					resultSet.getDate("CCFECMOD"),
					resultSet.getString("CCUSUMOD"));
			Organismo organismo = new Organismo();
			organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			organismo.setNombreMunicipio(resultSet
					.getString("OrganismoNOMBREMUNICIPIO"));
			aacc.setOrganismo(organismo);
			aacc.setCcadherido(resultSet.getString("CCADHERIDO"));
			return aacc;
		}
	};

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aacc> findAllBusqueda(Aacc aacc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.CCCODIGO CCCODIGO,t1.CCTESI CCTESI,t1.CCINFEDE CCINFEDE, t1.CCCOCC CCCOCC, t1.CCFEAD CCFEAD,t1.CCNOREP CCNOREP,t1.CCNIREP CCNIREP,t1.CCNOCARE CCNOCARE,t1.CCCOJA CCCOJA,t1.CCFEADFIN CCFEADFIN,t1.CCFECALTA CCFECALTA,t1.CCUSUALTA CCUSUALTA,t1.CCFECMOD CCFECMOD,t1.CCUSUMOD CCUSUMOD ");
		query.append(" , t2.NOMBRE_ES OrganismoNOMBREES, t2.NOMBRE_EU OrganismoNOMBREEU, t2.NOMBRE_MUNICIPIO OrganismoNOMBREMUNICIPIO, CASE WHEN t1.CCFEAD IS NULL OR t1.CCFEAD>SYSDATE THEN 'N' ");
		query.append(" WHEN t1.CCFEAD IS NOT NULL AND t1.CCFEAD<SYSDATE AND t1.CCFEADFIN IS NOT NULL AND t1.CCFEADFIN<SYSDATE THEN 'B' ");
		query.append(" ELSE 'A' END ccadherido ");
		query.append(" FROM AACC t1, ORGANISMO t2, CCTA1 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aacc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CCCODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.CCCODIGO=t4.M7COCC(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aacc>) this.jdbcTemplate.query(query.toString(),
				this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBusquedaCount(Aacc aacc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct cccodigo) FROM AACC t1, ORGANISMO t2, CCTA1 t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aacc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CCCODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.CCCODIGO=t4.M7COCC(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
