package com.ejie.y41b.converter;

import com.ejie.x38.util.DateTimeManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.converter.Converter;

public class Y41bDateConverter implements Converter<String, Date> {
	public Date convert(String strFecha) {
		try {
			if (strFecha == null || strFecha.equals("")) {
				return null;
			} else {
				Locale locale = LocaleContextHolder.getLocale();
				SimpleDateFormat format = (strFecha.length() > 10) ? DateTimeManager
						.getTimestampFormat(locale) : DateTimeManager
						.getDateTimeFormat(locale);
				return format.parse(strFecha);
			}
		} catch (ParseException ex) {
			ex.printStackTrace();
			throw new IllegalArgumentException();
		}
	}
}
