package com.ejie.y41b.control.exception;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

public class Y41bFileExceedsFileSizeLimitHandler implements
		HandlerExceptionResolver {
	@Autowired
	private Y41bUDAErrorManager errorManager;

	public ModelAndView resolveException(HttpServletRequest request,
			HttpServletResponse response, Object handler, Exception ex) {
		if (ex instanceof MaxUploadSizeExceededException) {
			try {
				Y41bUDAException e = new Y41bUDAException(
						"error.maxFileSizeError", true, new Exception());

				response.setStatus(422);

				Writer w = null;
				w = response.getWriter();
				w.write(errorManager.process(e, request));
				w.flush();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return null;
	}
}
