package com.ejie.y41b.control;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import com.ejie.x38.util.DateTimeManager;

/**
 * 
 * Used to serialize Java.util.Date, which is not a common JSON type, so we have
 * to create a custom serialize method;.
 * 
 *  
 * 
 */
@Component
public class Y41bJsonDateTimeSerializer extends JsonSerializer<Date> {

	public static final SimpleDateFormat DDMMYYYY_HHMM_DATE_FORMAT = new SimpleDateFormat(
			"dd/MM/yyyy HH:mm");
	public static final SimpleDateFormat YYYYMMDD_HHMM_DATE_FORMAT = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm");

	@Override
	public void serialize(Date date, JsonGenerator gen,
			SerializerProvider provider) throws IOException,
			JsonProcessingException {

		Locale locale = LocaleContextHolder.getLocale();

		SimpleDateFormat dateFormat = getTimestampFormat(locale);

		String formattedDate = dateFormat.format(date);

		if (formattedDate != null && formattedDate.contains("00:00")) {
			SimpleDateFormat dateFormatSinHora = DateTimeManager
					.getDateTimeFormat(locale);

			formattedDate = dateFormatSinHora.format(date);
		}
		gen.writeString(formattedDate);
	}

	public static SimpleDateFormat getTimestampFormat(Locale locale) {
		if (locale.getLanguage().equals("eu"))
			return YYYYMMDD_HHMM_DATE_FORMAT;
		if ((locale.getLanguage().equals("fr"))
				|| (locale.getLanguage().equals("es"))
				|| (locale.getLanguage().equals("en"))) {
			return DDMMYYYY_HHMM_DATE_FORMAT;
		}
		return DDMMYYYY_HHMM_DATE_FORMAT;
	}
}