package com.ejie.y41b.contextprovider;

import org.springframework.context.ApplicationContext;

/**
 * provee el contexto de aplicacion. Es accesible desde cualquier clase
 * 
 *  
 * 
 */
public class AppContext {
	private static ApplicationContext ctx;

	/**
	 * Constructor privado, dado que la clase es estatica
	 */
	private AppContext() {

	}

	/**
	 * Obtiene el contexto de aplicación
	 * 
	 * @return e lcontexto
	 */
	public static ApplicationContext getContext() {
		return AppContext.ctx;
	}

	/**
	 * Establece el contexto de aplicacion
	 * 
	 * @param ctx
	 *            el contexto de aplicaicon
	 */
	public static void setContext(ApplicationContext ctx) {
		AppContext.ctx = ctx;
	}

}
