package com.ejie.y41b.constantes;

import java.math.BigDecimal;

/**
 * Fichero de constantes de la aplicacion
 * 
 *  
 */
public class Y41bConstantes {

	/**
	 * Constructor privado"
	 */
	private Y41bConstantes() {
	};

	public static final String COD_APLICACION = "y41b";
	public static final String COD_APLICACION_HSHF = "R02G";

	public static final String CONFIG_PATH = "/y41b/y41b.properties";

	public static final String SESSIONCENSOMONITORCONNECTED = "SESSIONCENSOMONITORCONNECTED";

	public static final String SESSIONFULLNAMECENSOMONITORCONNECTED = "SESSIONFULLNAMECENSOMONITORCONNECTED";

	public static final String SESSIONLOGINERROR = "SESSIONLOGINERROR";

	public static final String ROLE_XLNET_APLICACION = "Y41B-IN-0001";

	public static final String CODIGO_USUARIO_Y41R_CENSO_MONITOR = "ZZX";

	public static final String CODIGO_USUARIO_SYS_CENSO_MONITOR = "SYS";

	/**
	 * Codigo Organismo LAKUA
	 */
	public static final String CODIGO_ORGANISMO_LAKUA = "01A106";

	public static final String CODIGO_ORGANISMO_BIZKAIA = "48A001";
	public static final String CODIGO_ORGANISMO_ARABA = "01A001";
	public static final String CODIGO_ORGANISMO_GIPUZKOA = "20A001";

	public static final String CODIGO_ORGANISMO_SSCC_CONTROLMERCADO = "01A101";

	public static final String CODIGO_PROVINCIA_ARABA = "01";

	public static final String CODIGO_PROVINCIA_GIPUZKOA = "20";

	public static final String CODIGO_PROVINCIA_BIZKAIA = "48";

	public static final String CODIGO_PROVINCIA_OTROS = "00";

	// Extensiones
	public static final String EXTENSION_ZIP = ".zip";

	public static final String EXTENSION_SOLICITUD = ".html";

	public static final String EXTENSION_DOC = ".doc";

	public static final String EXTENSION_DOCX = ".docx";

	public static final String EXTENSION_XLS = ".xls";

	public static final String EXTENSION_XLSX = ".xlsx";

	public static final String EXTENSION_RTF = ".rtf";

	public static final String EXTENSION_TXT = ".txt";

	public static final String EXTENSION_PDF = ".pdf";

	public static final String EXTENSION_BMP = ".bmp";

	public static final String EXTENSION_HTML = ".html";

	public static final String EXTENSION_JPG = ".jpg";

	public static final String EXTENSION_MPP = ".mpp";

	public static final String EXTENSION_ODG = ".odg";

	public static final String EXTENSION_ODP = ".odp";

	public static final String EXTENSION_ODS = ".ods";

	public static final String EXTENSION_ODT = ".odt";

	public static final String EXTENSION_PNG = ".png";

	public static final String EXTENSION_PPTX = ".pptx";

	public static final String EXTENSION_PPT = ".ppt";

	public static final String EXTENSION_TIF = ".tif";

	// Content Type
	public static final String CONTENT_TYPE_ZIP = "application/zip";

	public static final String CONTENT_TYPE_PDF = "application/pdf";

	public static final String CONTENT_TYPE_MSWORD = "application/msword";

	public static final String CONTENT_TYPE_MSWORDX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

	public static final String CONTENT_TYPE_RTF = "application/rtf";

	public static final String CONTENT_TYPE_MSEXCEL = "application/vnd.ms-excel";

	public static final String CONTENT_TYPE_MSEXCELX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

	public static final String CONTENT_TYPE_TXT = "text/plain";

	public static final String CONTENT_TYPE_PNG = "image/png";

	public static final String CONTENT_TYPE_BMP = "image/bmp";

	public static final String CONTENT_TYPE_HTML = "text/html";

	public static final String CONTENT_TYPE_JPEG = "image/jpeg";

	public static final String CONTENT_TYPE_MSPROJECT = "application/vnd.ms-project";

	public static final String CONTENT_TYPE_ODGRAPHICS = "application/vnd.oasis.opendocument.graphics";

	public static final String CONTENT_TYPE_ODPRESENTATION = "application/vnd.oasis.opendocument.presentation";

	public static final String CONTENT_TYPE_ODSPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";

	public static final String CONTENT_TYPE_ODTEXT = "application/vnd.oasis.opendocument.text";

	public static final String CONTENT_TYPE_CONTENT_TYPE_OFFICEDPRESENTATION = "application/vnd.openxmlformats-officedocument.presentationml.presentation";

	public static final String CONTENT_TYPE_MSPOWERPOINT = "application/vnd.ms-powerpoint";

	public static final String CONTENT_TYPE_TIFF = "image/tiff";

	// SLEEP en Localizador
	public static final int SLEEP_LOCALIZADOR = 30000;

	// Numeros mágicos
	public static final int NUM_0x7F = 0x7F;

	public static final int NUM_0 = 0;

	public static final int NUM_1 = 1;

	public static final int NUM_2 = 2;

	public static final int NUM_3 = 3;

	public static final int NUM_4 = 4;

	public static final int NUM_5 = 5;

	public static final int NUM_6 = 6;

	public static final int NUM_7 = 7;

	public static final int NUM_8 = 8;

	public static final int NUM_9 = 9;

	public static final int NUM_10 = 10;

	public static final int NUM_11 = 11;

	public static final int NUM_12 = 12;

	public static final int NUM_13 = 13;

	public static final int NUM_14 = 15;

	public static final int NUM_15 = 15;

	public static final int NUM_16 = 16;

	public static final int NUM_19 = 19;

	public static final int NUM_20 = 20;

	public static final int NUM_21 = 21;

	public static final int NUM_24 = 24;

	public static final int NUM_25 = 25;

	public static final int NUM_30 = 30;

	public static final int NUM_40 = 40;

	public static final int NUM_50 = 50;

	public static final int NUM_60 = 60;

	public static final int NUM_70 = 70;

	public static final int NUM_80 = 80;

	public static final int NUM_97 = 97;

	public static final int NUM_100 = 100;

	public static final int NUM_128 = 128;

	public static final int NUM_200 = 200;

	public static final int NUM_255 = 255;

	public static final int NUM_300 = 300;
	public static final int NUM_500 = 500;
	public static final int NUM_520 = 520;

	public static final int NUM_1000 = 1000;

	public static final int NUM_1024 = 1024;

	public static final int NUM_2000 = 2000;

	public static final int NUM_3000 = 3000;

	public static final int NUM_4000 = 4000;
	public static final int NUM_60000 = 60000;

	/**
	 * Constantes ordenacion consulta.
	 */
	public static final String ORDENACION_ASC = "ASC";

	public static final String ORDENACION_DESC = "DESC";

	/**
	 * Modo de la pantalla
	 */
	public static final String MODO_POPUP_ALTA = "POPUP_ALTA";

	public static final String MODO_POPUP_MODIFICACION = "POPUP_MODIFICACION";

	public static final String MODO_APORTACION_DOCUMENTOS = "APORTACION_DOCUMENTOS";

	public static final String MODO_POPUP_SELECCION = "POPUP_SELECCION";

	/**
	 * Perfiles
	 */
	public static final String PERFIL_SINACCESO_MANTENIMIENTO = "Y41B-GU-XXXX";

	public static final String PERFIL_CONSULTA_MANTENIMIENTO = "Y41B-GU-0000";

	public static final String PERFIL_ADMINISTRADOR_MANTENIMIENTO = "Y41B-GU-0005";

	public static final String PERFIL_SINACCESO_PROCEDIMIENTO = "Y41B-GU-YYYY";

	public static final String PERFIL_ADMINISTRATIVO = "Y41B-GU-0001";

	public static final String PERFIL_INSTRUCTOR = "Y41B-GU-0002";

	public static final String PERFIL_COORDINADOR = "Y41B-GU-0003";

	public static final String PERFIL_DIRECTOR = "Y41B-GU-0004";

	public static final String PERFIL_SUPERVISOR = "Y41B-GU-0006";

	public static final String PERFIL_CONSULTAS = "Y41B-GU-0008";

	public static final String PERFIL_TECNICO_CONTROL_MERCADO = "Y41B-GU-0003B";

	public static final String PERFIL_FIRMA_ARBITRO = "FIRMA_ARBITRO";

	/**
	 * Bandejas escritorio
	 */
	public static final String BANDEJA_SOLICITUDES_ADMINISTRATIVOS = "1";
	public static final String BANDEJA_EXPNUEVOS_PENDDECISION = "2";
	public static final String BANDEJA_TRAMITES_PENDIENTES = "3";
	public static final String BANDEJA_TRAMITES_PENDIENTES_OTROS = "4";
	public static final String BANDEJA_ESTADOOFICINA_NUEVOS_PENDDECISION = "5";
	public static final String BANDEJA_ESTADOOFICINA_TRAMITES_PENDIENTES = "6";
	public static final String BANDEJA_CONSULTAS_PENDIENTES = "7";
	public static final String BANDEJA_PROPUESTAS_SANCIONADOR = "8";
	public static final String BANDEJA_SANCIONADORES = "9";
	public static final String BANDEJA_FIRMA = "10";
	public static final String BANDEJA_ARBITRAJES = "11";
	public static final String BANDEJA_PROPUESTAS_ARBITRAJE = "12";
	public static final String BANDEJA_ADHESIONES = "13";

	public static final String BANDEJA_CAMPANASSSCC = "14";
	public static final String BANDEJA_CAMPANAS = "15";
	public static final String BANDEJA_REDESALERTA = "16";
	public static final String BANDEJA_COMUNICACIONESSOIVRE = "17";
	public static final String BANDEJA_PROPUESTAINSPECCION = "18";
	public static final String BANDEJA_INSPECCIONES = "19";

	/**
	 * Nombres ficheros excel
	 */
	public static final String EXCEL_BUSQUEDA_CONSULTAS = "consultas";

	public static final String EXCEL_BUSQUEDA_CAMPANHAS = "campa\u00F1as";

	public static final String EXCEL_BUSQUEDA_ALERTAS = "alertas";

	public static final String EXCEL_BUSQUEDA_COMUNICACIONESSOIVRE = "comunicacionesSoivre";

	public static final String EXCEL_BUSQUEDA_SOLICITUDES = "solicitudes";

	public static final String EXCEL_BUSQUEDA_INSPECCIONES = "inspecciones";

	public static final String EXCEL_BUSQUEDA_CONSUMIDORES = "consumidores";

	public static final String EXCEL_BUSQUEDA_ESTABLECIMIENTOS = "establecimientos";

	public static final String EXCEL_BUSQUEDA_SANCIONES = "sanciones";

	public static final String EXCEL_BUSQUEDA_ARBITRAJE = "arbitrajes";

	public static final String EXCEL_OTROS_INGRESOS = "otros_ingresos";

	public static final String EXCEL_VIA_APREMIO = "via_apremio";

	public static final String EXCEL_BANDEJA_CONSULTAS = "bandeja_consultas";
	public static final String EXCEL_BANDEJA_SOLICITUDES = "bandeja_solicitudes";
	public static final String EXCEL_BANDEJA_FIRMA = "bandeja_firma";
	public static final String EXCEL_BANDEJA_SANPROP = "bandeja_propuesta_sancionador";
	public static final String EXCEL_BANDEJA_ARBPROP = "bandeja_propuesta_arbitraje";
	public static final String EXCEL_BUSQUEDA_BANDSANCIONES = "bandejaSanciones";
	public static final String EXCEL_BUSQUEDA_BANDCAMPANHAS = "bandejaCampaas";
	public static final String EXCEL_BUSQUEDA_BANDCAMPANHASSSCC = "bandejaCampaasSSCC";
	public static final String EXCEL_BUSQUEDA_BANDALERTAS = "bandejaAlertas";
	public static final String EXCEL_BUSQUEDA_BANDCOMUNICACIONESSOIVRE = "bandejaComunicacionesSoivre";
	public static final String EXCEL_BUSQUEDA_BANDPROPUESTASINSPECCIONES = "bandejaPropuestasInspecciones";
	public static final String EXCEL_BUSQUEDA_BANDINSPECCIONES = "bandejaInspecciones";
	public static final String EXCEL_BUSQUEDA_BANDARBITRAJES = "bandejaArbitrajes";
	public static final String EXCEL_BUSQUEDA_BANDADHESIONES = "bandejaAdhesiones";

	public static final String EXCEL_BANDEJA_SOLICITUDES_ADMINISTRATIVO = "bandeja_solicitudes_administrativo";
	public static final String EXCEL_BANDEJA_SOLICITUDES_ENYPD = "bandeja_solicitudes_enypd";
	public static final String EXCEL_BANDEJA_SOLICITUDES_ECTP = "bandeja_solicitudes_ectp";
	public static final String EXCEL_BANDEJA_SOLICITUDES_ECTPO = "bandeja_solicitudes_ectpo";

	public static final String EXCEL_OOEE = "ooee";
	public static final String EXCEL_AACC = "aacc";
	public static final String EXCEL_ARBITRO = "arbitro";
	public static final String EXCEL_PERITO = "perito";
	public static final String EXCEL_JJAA = "jjaa";
	public static final String EXCEL_TCLUGAUD = "tclugaud";

	public static final String EXCEL_EMPRESAS_ADHERIDAS = "empadh";

	public static final String EXCEL_REMESAS = "remesas";
	public static final String EXCEL_AACCEUSKADI = "aaccEuskadi";
	/**
	 * Tipos de procedimiento
	 */
	public static final String CTE_TIPO_PROC = "CTE_TIPO_PROC";

	public static final String TIPO_PROC_SOLICITUDES = "SOL";

	public static final String TIPO_PROC_SANCIONES = "SAN";

	public static final String TIPO_PROC_ARBITRAJE = "ARB";

	public static final String TIPO_PROC_INSPECCIONES = "INS";

	public static final String TIPO_PROC_REMESAS = "REM";
	public static final String TIPO_PROC_REMESAS_AA66 = "REM_AA66";

	public static final String TIPO_PROC_ADHESIONES_ALTA = "ADA";
	public static final String TIPO_PROC_ADHESIONES_MOD = "ADM";
	public static final String TIPO_PROC_ADHESIONES_BAJA = "ADB";
	public static final String TIPO_PROC_ESTABLECIMIENTO = "EST";

	public static final String PREFIJO_ADHESIONES_ALTA = "ADA";
	public static final String PREFIJO_ADHESIONES_BAJA = "ADB";
	public static final String PREFIJO_ADHESIONES_MOD = "ADM";

	/**
	 * Fese tramites
	 */
	public static final String FASE_REGISTRO = "01";

	public static final String FASE_REQUERIMIENTO = "02";

	public static final String FASE_SUBSANACION = "03";

	public static final String FASE_MEDIACION = "04";

	public static final String FASE_CONCILIACION = "05";

	public static final String FASE_INSPECCION = "06";

	public static final String FASE_TRASLADO = "07";

	public static final String FASE_RESOLUCION = "08";

	public static final String FASE_RECURSO = "09";

	public static final String FASE_CIERRE = "10";

	public static final String FASE_ALEGACIONES = "36";

	/**
	 * Tipos de destinos
	 */
	public static final String DESTINO_LABORATORIO = "lab";
	public static final String DESTINO_DESTRUCCION = "des";
	public static final String DESTINO_DEVOLUCION = "dev";
	public static final String DESTINO_LIBRE_COMERCIALIZACION = "lib";
	public static final String DESTINO_OTROS = "otr";

	/**
	 * Tramites de inspecciones
	 */
	public static final String TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE = "IN01";
	public static final String TRAMITE_INSPECCIONES_REGISTRO_INSPECCION = "IN02";
	public static final String TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO = "IN03";
	public static final String TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA = "IN04";
	public static final String TRAMITE_INSPECCIONES_REQUERIMIENTO_POR_ESCRITO = "IN05";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO = "IN06";
	public static final String TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO = "IN07";
	public static final String TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA = "IN08";
	public static final String TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA = "IN09";
	public static final String TRAMITE_INSPECCIONES_REGISTRO_DECISION = "IN10";
	public static final String TRAMITE_INSPECCIONES_REMISION_MUESTRAS_AL_LABORATORIO = "IN11";
	public static final String TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS = "IN12";
	public static final String TRAMITE_INSPECCIONES_DESINMOVILIZACION = "IN13";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION = "IN14";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION = "IN15";
	public static final String TRAMITE_INSPECCIONES_EMISION_DE_INFORME = "IN16";
	public static final String TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE = "IN17";
	public static final String TRAMITE_INSPECCIONES_INFORME_VALORACION = "IN18";
	public static final String TRAMITE_INSPECCIONES_ACEPTACION_INFORME_VALORACION = "IN19";
	public static final String TRAMITE_INSPECCIONES_SOLICITUD_AMPLIACION_DE_INSPECCION = "IN20";
	public static final String TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION = "IN21";
	public static final String TRAMITE_INSPECCIONES_NOTIFICACION = "IN22";
	public static final String TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO = "IN23";
	public static final String TRAMITE_INSPECCIONES_COMUNICACION = "IN24";
	public static final String TRAMITE_INSPECCIONES_GENERICO = "IN25";
	public static final String TRAMITE_INSPECCIONES_ELABORACION_DOCUMENTACION_PARA_PUBLICACION_BOPV_BOE = "IN26";
	public static final String TRAMITE_INSPECCIONES_INFORMACION_PUBLICACION_BOPV_BOE = "IN27";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_RECURSO = "IN28";
	public static final String TRAMITE_INSPECCIONES_ELABORACION_INFORME_PARA_ASESORIA = "IN29";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_ORDEN_DEL_CONSEJERO = "IN30";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES = "IN31";
	public static final String TRAMITE_INSPECCIONES_TRASLADO_KONBIDE = "IN32";
	public static final String TRAMITE_INSPECCIONES_REQUERIMIENTO_ACREDITACION_REPRESENTACION = "IN33";
	public static final String TRAMITE_INSPECCIONES_RECEPCION_ACREDITACION_REPRESENTACION = "IN34";
	public static final String TRAMITE_INSPECCIONES_ORDEN_SERVICIO = "IN35";
	public static final String TRAMITE_INSPECCIONES_GENERICO_FIRMA = "IN36";
	public static final String TRAMITE_INSPECCIONES_ENVIAR_MUESTRA_EMPRESA = "IN37";
	public static final String TRAMITE_INSPECCIONES_COMUNICAR_NUEVO_DISTRIBUIDOR = "IN38";
	public static final String TRAMITE_INSPECCIONES_ANULACION_PROPUESTA_INSPECCION = "IN39";
	public static final String TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_CAMPANA = "IN40";
	public static final String TRAMITE_INSPECCIONES_ARCHIVO_AIP = "IN41";

	/**
	 * Tramites de solicitudes
	 */
	public static final String TRAMITE_REGISTRO_SOLICITUD = "K01";

	public static final String TRAMITE_ASIGNACION_INSTRUCTOR = "K02";

	public static final String TRAMITE_REQUERIMIENTO_INFORMACION = "K03";

	public static final String TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION = "K03-1";

	public static final String TRAMITE_REQUERIMIENTO_SUBSANACION = "K04";

	public static final String TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION = "K04-1";

	public static final String TRAMITE_REQUERIMIENTO_ALEGACION = "K06";

	public static final String TRAMITE_ALEGACION = "K07";

	public static final String TRAMITE_MEDIACION_TELEFONICA = "K08";

	public static final String TRAMITE_MEDIACION_PRESENCIAL = "K09";

	public static final String TRAMITE_CONCILIACION_ENTRE_PARTES = "K10";

	public static final String TRAMITE_SOLICITUD_INSPECCION = "K11";

	public static final String TRAMITE_RECEPCION_INSPECCION = "K11-1";

	public static final String TRAMITE_TRASLADO_RED_CIAC = "K12";

	public static final String TRAMITE_TRASLADO_KONBIDE = "K12-1";

	public static final String TRAMITE_RECEPCION_TRASLADO = "K13";

	public static final String TRAMITE_REGISTRO_DECISION = "K14";

	public static final String TRAMITE_RECEPCION_RECURSO = "K15";

	public static final String TRAMITE_ELABORACION_INFORME_ASESORIA = "K16";

	public static final String TRAMITE_RECEPCION_ORDEN_CONSEJERO = "K17";

	public static final String TRAMITE_CIERRE_EXPEDIENTE = "K19";

	public static final String TRAMITE_COMUNICACION = "K20";

	public static final String TRAMITE_NOTIFICACION = "K21";

	// Realmente no es un tramite, es para el tipo de remesas notificacion
	// electronica (AA66)
	public static final String TRAMITE_NOTIFICACION_ELECTRONICA = "K21-66";

	public static final String TRAMITE_ELABORACION_BOPV_AYUNTA = "K22-1";

	public static final String TRAMITE_BOPV_AYTO = "K22";

	public static final String TRAMITE_ACUSE_RECIBO = "K23";

	public static final String TRAMITE_ADJUNTAR_DOCUMENTACION = "K24";

	public static final String TRAMITE_GENERICO = "K25";

	public static final String TRAMITE_SOLICITUD_COLABORACION = "K50";

	public static final String TRAMITE_RESPUESTA_COLABORACION = "K51";

	public static final String TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION = "K43-1";

	public static final String TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION = "K43-2";

	public static final String TRAMITE_ANULACION_PROPUESTA_SANCION = "K120";

	public static final String TRAMITE_SEGUNDA_MEDIACION = "K121";

	public static final String TRAMITE_RESPUESTA_SEGUNDA_MEDIACION = "K122";

	public static final String TRAMITE_RESPUESTA_AMPLIACION_PLAZO = "K123";

	public static final String TRAMITE_ENVIAR_SALIDA_SIR = "K125";

	/**
	 * Fese tramites SANCIONES
	 */

	public static final String FASE_REGISTRO_SANCION = "11";

	public static final String FASE_INICIO_SANCION = "12";

	public static final String FASE_PRUEBAS_SANCION = "13";

	public static final String FASE_PROPUESTA_RESOLUCION_SANCION = "14";

	public static final String FASE_RESOLUCION_SANCION = "15";

	public static final String FASE_RECURSO_SANCION = "16";

	public static final String FASE_CIERRE_SANCION = "17";

	/**
	 * Tramites de SANCIONES
	 */
	public static final String TRAMITE_SANCIONES_GENERICO = "K37";

	public static final String TRAMITE_SANCIONES_APORTACIONDOCUMENTACION = "K42";

	public static final String TRAMITE_SANCIONES_ACUERDOINCOACION = "K27";

	public static final String TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA = "K39";

	public static final String TRAMITE_SANCIONES_ACUERDOAMPLIACIONPLAZOALEGACIONES = "K40";

	public static final String TRAMITE_SANCIONES_REQUERIMIENTOACREDITACIONREPRESENTACION = "K43";

	public static final String TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION = "K113";

	public static final String TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA = "K28";

	public static final String TRAMITE_SANCIONES_PROPUESTARESOLUCION = "K29";

	public static final String TRAMITE_SANCIONES_RESOLUCION = "K30";

	public static final String TRAMITE_SANCIONES_RESOLUCIONRECURSOPRUEBA = "K44";

	public static final String TRAMITE_SANCIONES_NOTIFICACION = "K34";

	public static final String TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA = "K31";

	public static final String TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA = "K45";

	public static final String TRAMITE_SANCIONES_LIQUIDACION = "K41";

	public static final String TRAMITE_SANCIONES_COMUNICACION = "K35";

	public static final String TRAMITE_SANCIONES_CIERRE = "K33";

	public static final String TRAMITE_SANCIONES_ACUSERECIBO = "K38";

	public static final String TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA = "K32";

	public static final String TRAMITE_SANCIONES_APERTURA = "K26";

	public static final String TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO = "K46";

	public static final String TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA = "K47";

	public static final String TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION = "K48";

	public static final String TRAMITE_SANCIONES_PAGO = "K49";

	// EVOLUTIVO 0135083 2.4
	public static final String TRAMITE_SANCIONES_REQUERIMIENTOINFORMACION = "K116";

	public static final String TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOINFORMACION = "K117";
	//
	public static final String TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO = "K124";

	/**
	 * Tramites de REMESAS
	 */
	public static final String TRAMITE_REMESA_CARATULA = "R01";

	public static final String TRAMITE_REMESA_ACUSE_NOTIFICACIONES = "R02";

	public static final String TRAMITE_REMESA_LISTADO_NOTIFICACIONES = "R03";

	/* TRAMITES NO GENERABLES */

	public static final String TRAMITES_SANCIONES_NOGENERABLES = "'K38', 'K26', 'K33', 'K47', 'K39', 'K49', 'K113'";

	/**
	 * Estado tramite
	 */
	public static final String ESTADO_TRAMITE_PENDIENTEFIRMA = "P";

	public static final String ESTADO_TRAMITE_PENDIENTELOCALIZACION = "I";

	public static final String ESTADO_TRAMITE_LOCALIZADO = "L";

	public static final String ESTADO_TRAMITE_ERRORLOCALIZACION = "R";

	public static final String ESTADO_TRAMITE_ENTRAMITACION = "E";

	public static final String ESTADO_TRAMITE_FIRMADO = "F";

	public static final String ESTADO_TRAMITE_TRAMITADO = "T";

	public static final String ESTADO_TRAMITE_FIRMADENEGADA = "D";

	/**
	 * Estado documento
	 */
	public static final String ESTADO_DOCUMENTO_PENDIENTEFIRMA = "P";

	public static final String ESTADO_DOCUMENTO_FIRMADO = "F";

	public static final String ESTADO_DOCUMENTO_FIRMADENEGADA = "D";

	/**
	 * Respuesta solicitud de colaboracin
	 */
	public static final String RESPUESTA_RESPONDIDO = "R";

	public static final String RESPUESTA_SIN_RESPUESTA = "S";

	/**
	 * Respuesta traslado
	 */
	public static final String RESPUESTA_TRASLADO_ACEPTADO = "A";

	public static final String RESPUESTA_TRASLADO_DENEGADO = "D";

	/**
	 * Situacion Acuse Recibo
	 */
	public static final String SITUACION_ACUSERECIBO_ACEPTADO = "A";

	public static final String SITUACION_ACUSERECIBO_RECHAZADO = "R";

	public static final String SITUACION_ACUSERECIBO_NOENTREGADO = "N";

	/**
	 * Tipos de intervinientes
	 */
	public static final String TIPO_INTERVINIENTESOL_INTERESADO = "I";

	public static final String TIPO_INTERVINIENTESOL_DEMANDADO = "D";

	public static final String TIPO_INTERVINIENTESOL_ADMINISTRACION = "A";

	public static final String TIPO_INTERVINIENTESOL_CONSUMIDOR = "C";

	public static final String TIPO_INTERVINIENTESOL_ESTABLECIMIENTO = "E";

	public static final String TIPO_INTERVINIENTESOL_OTROS = "O";

	public static final String TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE = "Q";

	public static final String TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO = "P";

	public static final String TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO = "S";

	public static final String TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO = "T";

	public static final String TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_ANTERIOR = "U";

	public static final String TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_ANTERIOR = "V";

	public static final String TIPO_INTERVINIENTE_DISTRIBUIDOR = "F";

	public static final String TIPO_INTERVINIENTE_IMPORTADOR = "M";

	public static final String TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO = "V";

	public static final String TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE = "R";

	public static final String TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO = "B";

	public static final String TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO = "S";

	public static final String TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_ANTERIOR = "U";

	public static final String TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE = "X";

	public static final String TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO = "Y";

	public static final String TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_ANTERIOR = "Z";

	public static final String TIPO_INTERVINIENTE_ESTABLECIMIENT_ADMINISTRACION = "A";

	public static final String TIPO_INTERVINIENTE_ESTABLECIMIENT_OTROS = "O";

	public static final String TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR = "W";

	public static final String TIPO_INTERVINIENTE_LABORATORIO = "L";

	/**
	 * Tipos de intervinientes
	 */
	// public static final String TIPO_INTERVINIENTESAN_INTERESADO = "I";
	// public static final String TIPO_INTERVINIENTESAN_DEMANDADO = "E";
	// public static final String TIPO_INTERVINIENTESAN_ADMINISTRACION = "A";

	public static final String TIPO_INTERVINIENTE_INTERESADO = "I";

	public static final String TIPO_INTERVINIENTE_SANCIONADO = "E";

	public static final String TIPO_INTERVINIENTE_OTRO = "O";

	public static final String TIPO_INTERVINIENTESAN_CONSUMIDOR = "C";

	public static final String TIPO_INTERVINIENTESAN_ESTABLECIMIENTO = "F";

	public static final String TIPO_INTERVINIENTESAN_OTROS = "O";

	public static final String TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN = "Y";

	public static final String TIPO_INTERVINIENTESAN_OTROS_ORIGEN = "Z";

	public static final String TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO = "R";
	public static final String TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO = "T";
	public static final String TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_ANTERIOR = "V";

	/**
	 * Tipos de posibles intervinientes
	 */
	public static final String TIPO_POSIBLEINTERVINIENTESOL_CONSUMIDOR = "C";

	public static final String TIPO_POSIBLEINTERVINIENTESOL_ESTABLECIMIENTO = "E";

	public static final String TIPO_POSIBLEINTERVINIENTESOL_OTROS = "O";

	/**
	 * Código de idioma castellano.
	 */
	public static final String CASTELLANO = "es";

	public static final String CASTELLANO_CENSO = "C";
	public static final String EUSKERA_CENSO = "V";

	/**
	 * Cdigo de idioma euskera.
	 */
	public static final String EUSKERA = "eu";

	public static final String SI = "S";

	public static final String NO = "N";

	public static final String SI_COMPLETO = "Si";

	public static final String NO_COMPLETO = "No";

	public static final String CERO = "0";

	public static final String VACIO = "";

	/**
	 * Constante para controlar si es la primera vez que el usuario entra en la
	 * aplicación.
	 */
	public static final String PRIMERA_VEZ = "S";

	/**
	 * Tamaño de las PK de las tablas de BBDD
	 */
	public static final int PK_SIZE = 20;

	/**
	 * Tamaño de campos de texto
	 */
	public static final int MINLENGTH_OBJECT_NAME = 0;

	public static final int MAXLENGTH_OBJECT_NAME = 255;

	public static final int BUFFER_50 = 50;

	public static final int BUFFER_100 = 100;

	public static final int BUFFER_200 = 200;

	public static final int BUFFER_250 = 250;

	public static final int BUFFER_300 = 300;

	public static final int BUFFER_3000 = 3000;

	/* NODO RAIZ */
	public static final String NODO_RAIZ = "G_ROOT";

	/* GRUPO NEUTRO - ORGANISMOS SIN GRUPO FIJO */
	public static final String GRUPO_RAIZ_ID = "ROOT";

	/**
	 * Sector de establecimiento Primario
	 */
	public static final String SECTOR_ESTABLECIMIENTO_PRIMARIO = "P";

	/**
	 * Elemento seleccionable
	 */
	public static final String ELEMENTO_SELECCIONABLE = "E";

	/**
	 * RADIOS
	 */
	public static final String SITUACION_TODAS = "";

	public static final String SITUACION_PENDIENTES = "P";

	public static final String SITUACION_RESUELTAS = "R";

	public static final String SEXO_HOMBRE = "H";

	public static final String SEXO_MUJER = "M";

	public static final String VALOR_SI = "S";

	public static final String VALOR_NO = "N";

	public static final String NULL = "null";

	public static final String HABITUALES = "S";

	public static final String ESTABLECIMIENTOS = "S";

	public static final String ACTIVIDAD_SECTOR_INDICADOR = "P";

	/**
	 * Tipos de forma presentacion consultas
	 */
	public static final String FORMA_PRESENTACION_PRESENCIAL = "P";

	public static final String FORMA_PRESENTACION_WEB = "I";

	public static final String FORMA_PRESENTACION_FAX = "F";

	/**
	 * FORMATO FECHAS CON HORA
	 */
	public static final String FORMATO_FECHAHORALARGA_ES = "dd/MM/yyyy HH:mm:ss";

	public static final String FORMATO_FECHAHORA_TOOLKIT = "dd-MM-yyyy HH:mm:ss";

	public static final String FORMATO_FECHA_TOOLKIT = "dd-MM-yyyy";

	public static final String FORMATO_FECHAHORA_SIR = "yyyyMMddHHmmss";

	public static final String FORMATO_FECHAHORA_ES = "dd/MM/yyyy HH:mm";

	public static final String FORMATO_FECHAHORA_EU = "yyyy/MM/dd HH:mm";

	public static final String FORMATO_HORA = "HH:mm:ss";

	public static final String FORMATO_ANYO = "yyyy";

	public static final String FORMATO_FULL_FECHA_ES = "EEEE, dd 'de' MMMM 'de' yyyy";

	public static final String FORMATO_FULL_FECHA_EU = "EEEE, yyyy'ko' MMMM'ren' d'a'";

	public static final String FORMATO_FULL_FECHA_ESSINDIA = "dd 'de' MMMM 'de' yyyy";

	public static final String FORMATO_FULL_FECHA_EUSINDIA = "yyyy'ko' MMMM'ren' d'a'";

	public static final String FORMATO_FULL_FECHA_EUSINDIASINA = "yyyy'ko' MMMM'ren' d";

	public static final String FORMATO_FECHA_ES = "dd/MM/yyyy";

	public static final String FORMATO_FECHA_EU = "yyyy/MM/dd";

	public static final String FORMATO_FECHA_SEPARADOR = "/";

	public static final int NUM_CARACTERES_FECHA = 11;

	/**
	 * Tipo de origen de documentos Consulta
	 */
	public static final String ORIGEN_APORTADO_CIUDADANO = "CO";

	public static final String ORIGEN_APORTADO_ADMINISTRACION = "A";

	/**
	 * Tipo de documento Consulta
	 */
	public static final String TIPO_DOCUMENTO_CONSULTA_CONSULTA = "C";

	public static final String TIPO_DOCUMENTO_CONSULTA_RESPUESTA = "R";

	public static final BigDecimal NUM_CERO = new BigDecimal(0);

	/**
	 * Tipo de respuesta de consulta EMAIL
	 */
	public static final String TIPO_RESPUESTA_CONSULTA_EMAIL = "EML";

	/**
	 * Comunicacion
	 */
	public static final String COMUNICACION_LEIDA = "CL";

	public static final String COMUNICACION_NO_LEIDA = "CN";

	public static final int TIPO_COMUNICACION_NO_REPLY = 6;

	/**
	 * Solicitudes - Indicador de gestion
	 */
	public static final String SOLICITUDES_MIGESTION = "M";

	public static final String SOLICITUDES_TODAS = "T";

	public static final String SOLICITUDES_RECIBIDAS = "R";

	public static final String SOLICITUDES_TRASLADADAS = "E";

	public static final String SOLICITUDES_ARBITRAJE = "A";

	/**
	 * Solicitudes - Estado de la solicitud
	 */
	public static final String SOLICITUD_ESTADO_ARBITRAJE = "A";

	public static final String SOLICITUD_ESTADO_TRASLADADO = "T";

	public static final String SOLICITUD_ESTADO_COMUNICADO = "C";

	public static final String SOLICITUD_ESTADO_MIGESTION = "PR";

	/**
	 * Mediacion Solicitud
	 */
	public static final String SOLICITUD_MEDIACION = "M";

	public static final String SOLICITUD_ARBITRAJE = "A";

	/**
	 * Codigos de tramites de solicitudes
	 */
	public static final String TRAMITE_SOLICITUD_REGISTRO_SOLICITUD = "1";

	public static final String TRAMITE_SOLICITUD_REQUERIR_SUBSANACION = "3";

	public static final String TRAMITE_SOLICITUD_SOLICITUD_ALEGACION = "4";

	public static final String TRAMITE_SOLICITUD_COMUNICACION_ALEGACIONES = "7";

	public static final String TRAMITE_SOLICITUD_RECEPCION_ALEGACIONES = "6";

	public static final String TRAMITE_SOLICITUD_REGISTRO_DECISION = "13";

	public static final String TRAMITE_SOLICITUD_EMAIL = "15";

	public static final String TRAMITE_SOLICITUD_TRASLADO_SOLICITUD = "16";

	public static final String TRAMITE_SOLICITUD_INSPECCION_PRESENCIAL = "11";

	/**
	 * Codigos de decisiones de solicitudes
	 */
	public static final String DECISION_SINDECISION = "SIND";

	public static final String DECISION_APERCIBIMIENTO_DENUNCIA = "K1-1";

	public static final String DECISION_APERCIBIMIENTO_QUEJA = "K1-2";

	public static final String DECISION_APERCIBIMIENTO_RECLAMACION = "K1-3";

	public static final String DECISION_AVENENCIA_DENUNCIA = "K2-1";

	public static final String DECISION_AVENENCIA_QUEJA = "K2-2";

	public static final String DECISION_AVENENCIA_RECLAMACION = "K2-3";

	public static final String DECISION_AVENENCIA_PARCIAL_DENUNCIA = "K3-1";

	public static final String DECISION_AVENENCIA_PARCIAL_QUEJA = "K3-2";

	public static final String DECISION_AVENENCIA_PARCIAL_RECLAMACION = "K3-3";

	public static final String DECISION_DESISTIMIENTO_DENUNCIA = "K4-1";

	public static final String DECISION_DESISTIMIENTO_QUEJA = "K4-2";

	public static final String DECISION_DESISTIMIENTO_RECLAMACION = "K4-3";

	public static final String DECISION_INADMISION_ARREPENTIM_COMPRA_DENUNCIA = "K5-1";

	public static final String DECISION_INADMISION_ARREPENTIM_COMPRA_QUEJA = "K5-2";

	public static final String DECISION_INADMISION_ARREPENTIM_COMPRA_RECLAMACION = "K5-3";

	public static final String DECISION_INADMISION_DANOS_DENUNCIA = "K6-1";

	public static final String DECISION_INADMISION_DANOS_QUEJA = "K6-2";

	public static final String DECISION_INADMISION_DANOS_RECLAMACION = "K6-3";

	public static final String DECISION_INADMISION_NO_CONSUMO_DENUNCIA = "K7-1";

	public static final String DECISION_INADMISION_NO_CONSUMO_QUEJA = "K7-2";

	public static final String DECISION_INADMISION_NO_CONSUMO_RECLAMACION = "K7-3";

	public static final String DECISION_INADMISION_NO_GARANTIA_DENUNCIA = "K8-1";

	public static final String DECISION_INADMISION_NO_GARANTIA_QUEJA = "K8-2";

	public static final String DECISION_INADMISION_NO_GARANTIA_RECLAMACION = "K8-3";

	public static final String DECISION_INADMISION_OPCION_REPARACION_DENUNCIA = "K9-1";

	public static final String DECISION_INADMISION_OPCION_REPARACION_QUEJA = "K9-2";

	public static final String DECISION_INADMISION_OPCION_REPARACION_RECLAMACION = "K9-3";

	public static final String DECISION_INHIBICION_AESA_DENUNCIA = "KA-1";

	public static final String DECISION_INHIBICION_AESA_QUEJA = "KA-2";

	public static final String DECISION_INHIBICION_AESA_RECLAMACION = "KA-3";

	public static final String DECISION_INHIBICION_OTROS_DENUNCIA = "KB-1";

	public static final String DECISION_INHIBICION_OTROS_QUEJA = "KB-2";

	public static final String DECISION_INHIBICION_OTROS_RECLAMACION = "KB-3";

	public static final String DECISION_INHIBICION_SEGUROS_DENUNCIA = "KC-1";

	public static final String DECISION_INHIBICION_SEGUROS_QUEJA = "KC-2";

	public static final String DECISION_INHIBICION_SEGUROS_RECLAMACION = "KC-3";

	public static final String DECISION_INHIBICION_TRANSPORTE_DENUNCIA = "KD-1";

	public static final String DECISION_INHIBICION_TRANSPORTE_QUEJA = "KD-2";

	public static final String DECISION_INHIBICION_TRANSPORTE_RECLAMACION = "KD-3";

	public static final String DECISION_NO_AVENENCIA_DENUNCIA = "KE-1";

	public static final String DECISION_NO_AVENENCIA_QUEJA = "KE-2";

	public static final String DECISION_NO_AVENENCIA_RECLAMACION = "KE-3";

	public static final String DECISION_PROPUESTA_SAN_DENUNCIA = "KF-1";

	public static final String DECISION_PROPUESTA_SAN_QUEJA = "KF-2";

	public static final String DECISION_PROPUESTA_SAN_RECLAMACION = "KF-3";

	public static final String DECISION_NO_LOCALIZADO_DENUNCIA = "KG-1";

	public static final String DECISION_NO_LOCALIZADO_QUEJA = "KG-2";

	public static final String DECISION_NO_LOCALIZADO_RECLAMACION = "KG-3";

	public static final String DECISION_NO_SUBSANACION_DENUNCIA = "KH-1";

	public static final String DECISION_NO_SUBSANACION_QUEJA = "KH-2";

	public static final String DECISION_NO_SUBSANACION_RECLAMACION = "KH-3";

	public static final String DECISION_PROPUESTA_ARBITRAJE_DENUNCIA = "KI-1";

	public static final String DECISION_PROPUESTA_ARBITRAJE_QUEJA = "KI-2";

	public static final String DECISION_PROPUESTA_ARBITRAJE_RECLAMACION = "KI-3";

	public static final String DECISION_RECLAMANTE_NO_ALEGACIONES_DENUNCIA = "KJ-1";

	public static final String DECISION_RECLAMANTE_NO_ALEGACIONES_QUEJA = "KJ-2";

	public static final String DECISION_RECLAMANTE_NO_ALEGACIONES_RECLAMACION = "KJ-3";

	public static final String DECISION_SIN_INFRACCION_DENUNCIA = "KK-1";

	public static final String DECISION_SIN_INFRACCION_QUEJA = "KK-2";

	public static final String DECISION_SIN_INFRACCION_RECLAMACION = "KK-3";

	public static final String DECISION_TRASLADO_DENUNCIA = "KL-1";

	public static final String DECISION_TRASLADO_QUEJA = "KL-2";

	public static final String DECISION_TRASLADO_RECLAMACION = "KL-3";

	public static final String DECISION_ERROR_DENUNCIA = "KER1";

	public static final String DECISION_ERROR_QUEJA = "KER2";

	public static final String DECISION_ERROR_RECLAMACION = "KER3";

	public static final String DECISION_ARCHIVO_QUEJA = "KM-1";

	public static final String DECISION_INCLUSION_RED_ALERTA = "KN-1";

	public static final String DECISION_INHIBICION_BANCA = "KR-1";

	public static final String DECISION_INADMISION_TIQUE = "KO-1";

	public static final String DECISION_INADMISION_RECLAMACION_DUPLICADA = "KP-1";

	public static final String DECISION_INADMISION_GENERAL = "KQ-1";

	public static final String DECISION_SANCION_CADUCIDAD = "SA1";

	public static final String DECISION_SANCION_SANCION = "SA2";

	public static final String DECISION_SANCION_SOBRESEIMIENTO = "SA3";

	public static final String DECISION_SANCION_ERROR = "SA4";

	public static final String DECISION_INSPECCIONES_TRASLADO = "IN1";
	public static final String DECISION_INSPECCIONES_SIN_INFRACCION = "IN2";
	public static final String DECISION_INSPECCIONES_INCLUSION_EN_RED_DE_ALERTA = "IN3";
	public static final String DECISION_INSPECCIONES_CON_APERCIBIMIENTO = "IN4";
	public static final String DECISION_INSPECCIONES_CON_PROPUESTA_DE_SANCION = "IN5";
	public static final String DECISION_INSPECCIONES_ARCHIVO_AIP = "IN6";
	public static final String DECISION_INSPECCIONES_COMUNICACION_EXTERNA = "182";

	public static final String DECISION_ARCHIVO_DENUNCIA = "102";

	/**
	 * Tipo de origen de documentos Solicitud
	 */
	public static final String ORIGEN_SOL_APORTADO_RECLAMANTE = "CO";

	public static final String ORIGEN_SOL_APORTADO_RECLAMADO = "ES";

	public static final String ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE = "RC";

	public static final String ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO = "RE";

	public static final String ORIGEN_SOL_APORTADO_ADMINISTRACION = "A";

	public static final String ORIGEN_SOL_APORTADO_OTROS = "O";

	/**
	 * Tipo de destino de documentos Resolucion/Decision
	 */
	public static final String DESTINO_RESOL_RECLAMANTE = "CO";

	public static final String DESTINO_RESOL_RECLAMADO = "ES";

	public static final String DESTINO_RESOL_OTROS = "O";

	public static final String DESTINO_RESOL_ESTABLECIMIENTOVISITADO = "EV";

	public static final String DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE = "ER";

	/**
	 * Tipo de destino de documentos Traslado RedCiac
	 */
	public static final String DESTINO_TRASLADOCIAC_RECLAMANTE = "CO";

	public static final String DESTINO_TRASLADOCIAC_OFICINA = "OF";

	/**
	 * Tipo de origen de Alegacion
	 */
	public static final String ORIGEN_ALEGACION_RECLAMANTE = "C";

	public static final String ORIGEN_ALEGACION_RECLAMADO = "R";

	/**
	 * Tipo de destino requerimiento
	 */
	public static final String DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO = "V";

	public static final String DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE = "R";

	/**
	 * Tipo de respuesta de recepcion de acreditacion de representacion
	 */
	public static final String RESPUESTA_ACREDITACION_VALIDO = "V";

	public static final String RESPUESTA_ACREDITACION_NO_VALIDO = "N";

	/**
	 * Tipo de respuesta de recepcion de alegaciones
	 */
	public static final String RESPUESTA_ALEGACION_NO_ACEPTA = "N";

	public static final String RESPUESTA_ALEGACION_NO_RESPONDE = "R";

	/**
	 * Tipo de origen de recepcion de acreditacion de representacion
	 */
	// ESTOS 4 LOS HAN CREADO PERO NO SE ESTAN UTILIZANDO EN NINGUN SITIO, POR
	// ESO TAMPOCO EXISTEN LOS EQUIVALENTES EN ARBITRAJE Y SANCIONES
	public static final String ORIGEN_SOL_ACREDITACION_RECLAMANTE = "R";

	public static final String ORIGEN_SOL_ACREDITACION_RECLAMADO = "S";

	public static final String ORIGEN_SOL_ACREDITACION_REPRESENTANTE_RECLAMANTE = "RC";

	public static final String ORIGEN_SOL_ACREDITACION_REPRESENTANTE_RECLAMADO = "RE";

	/**
	 * Tipo de origen y destino de documentos Inspecciones
	 */
	public static final String ORIGEN_INS_APORTADO_VISITADO = "V";

	public static final String ORIGEN_INS_APORTADO_RESPONSABLE = "R";

	public static final String ORIGEN_INS_APORTADO_ADMINISTRACION = "A";

	public static final String ORIGEN_INS_APORTADO_OTROS = "O";

	public static final String ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO = "RV";

	public static final String ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE = "RR";

	public static final String DESTINO_INS_APORTADO_RECLAMANTE = "CO";

	public static final String DESTINO_INS_APORTADO_RECLAMADO = "ES";

	public static final String TIPO_INTERVINIENTE_INS_RESPONSABLE = "R";

	public static final String TIPO_INTERVINIENTE_INS_VISITADO = "V";

	public static final String TIPO_INTERVINIENTE_INS_ADMINISTRACION = "A";

	/**
	 * Nombre Plantilla Tramite Hecho
	 */
	public static final String NOMBRE_PLANTILLA_XML_TRAMITE_CASTELLANO = "tramitehecho.xml";

	/**
	 * Nombre Plantilla Decision Hecho
	 */
	public static final String NOMBRE_PLANTILLA_XML_DECISION_CASTELLANO = "tramitedecision.xml";

	/**
	 * Nombre Plantilla Tramite Inspeccion
	 */
	public static final String NOMBRE_PLANTILLA_INSPECCIONES_XML_TRAMITE_CASTELLANO = "tramiteinspeccion.xml";

	/**
	 * Nombre Plantilla Tramite Inspeccion
	 */
	public static final String NOMBRE_PLANTILLA_INSPECCIONES_XML_DECISION_CASTELLANO = "tramiteinspecciondecision.xml";

	/**
	 * Nombre Plantilla Inspecciones
	 */
	public static final String NOMBRE_PLANTILLA_XML_INSPECCIONES_CASTELLANO = "cartasinspecciones.xml";

	/**
	 * Nombre Plantilla Informe cierre campanha
	 */
	public static final String NOMBRE_PLANTILLA_DOC_INFORME_CIERRE_CAMPANHA = "InformeCierreCampaa.rtf";

	/**
	 * Tipo de transmision
	 */
	public static final String TIPO_TRANSMISION_TRASLADO = "T";

	public static final String TIPO_TRANSMISION_COMUNICACION = "C";

	public static final String TIPO_TRANSMISION_INHIBICION = "I";

	/**
	 * Consumidores
	 */
	public static final String NIF = "1";

	public static final String NIE = "2";

	public static final String IDENEXTRANJERA = "3";

	/**
	 * Establecimientos
	 */
	public static final String CIF = "1";

	public static final String OTROS = "2";

	/**
	 * Codigos de grupos de organismos para KontsumoNet
	 */
	public static final String COD_GRUPO_ADMINISTRACION_AUTONOMICA = "G_A";

	public static final String COD_GRUPO_ASOCIACION_CONSUMIDORES = "G_C";

	public static final String COD_GRUPO_JUNTAS_ARBITRALES = "G_J";

	public static final String COD_GRUPO_ADMINISTRACION_LOCAL = "G_L";

	/**
	 * Inspecciones Campañas/Alertas/Denuncias
	 */
	public static final String TIPO_CAMPAHNA = "C";

	public static final String TIPO_ALERTA = "A";

	public static final String TIPO_DENUNCIA = "D";

	/**
	 * Situacion Inspecciones Campaas/Alertas/Denuncias
	 */
	public static final String CAMPAHNA_SIN_ACTUACION = "S";

	public static final String CAMPAHNA_CON_ACTUACION = "C";

	public static final String CAMPAHNA_FINALIZADA = "F";

	/**
	 * Plantillas Word Ficha Consultas
	 */
	public static final String NOMBRE_PLANTILLA_CONSULTAS_FICHA_RTF = "consulta-2012.rtf";

	public static final String NOMBRE_PLANTILLA_CONSULTAS_FICHA_XML = "consulta-2012.xml";

	/**
	 * Plantillas Word Ficha Solicitudes
	 */
	public static final String NOMBRE_PLANTILLA_SOLICITUDES_ETIQUETA_RTF = "etiqueta-2015.rtf";

	public static final String NOMBRE_PLANTILLA_SOLICITUDES_ETIQUETA_XML = "etiqueta-2015.xml";

	/**
	 * Plantillas Word Ficha Sanciones
	 */
	public static final String NOMBRE_PLANTILLA_SANCIONES_ETIQUETA_RTF = "etiqueta-san-2015.rtf";

	public static final String NOMBRE_PLANTILLA_SANCIONES_ETIQUETA_XML = "etiqueta-san-2015.xml";

	/**
	 * Plantillas Word Ficha Arbitraje
	 */
	public static final String NOMBRE_PLANTILLA_ARBITRAJE_ETIQUETA_RTF = "etiqueta-arb-2017.rtf";

	public static final String NOMBRE_PLANTILLA_ARBITRAJE_ETIQUETA_XML = "etiqueta-arb-2017.xml";

	public static final String NOMBRE_PLANTILLA_ARBITRAJE_ESTABLECIMIENTO_PEGATINA_RTF = "pegatinaEst-arb.rtf";

	public static final String NOMBRE_PLANTILLA_ARBITRAJE_ESTABLECIMIENTO_PEGATINA_XML = "pegatinaEst-arb.xml";

	/**
	 * Plantillas Word Ficha Solicitudes
	 */
	public static final String NOMBRE_PLANTILLA_SOLICITUDES_FICHA_RTF = "solicitud-2012.rtf";

	public static final String NOMBRE_PLANTILLA_SOLICITUDES_FICHA_XML = "solicitud-2012.xml";

	/**
	 * Plantillas Word Ficha Solicitudes
	 */
	public static final String NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_RTF = "solicitud-reducida-2012.rtf";

	public static final String NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_XML = "solicitud-reducida-2012.xml";

	public static final String NOMBRE_PLANTILLA_TRASLADO_RTF = "COMUNICACION TRASLADO RED CIAC - CONS.rtf";

	/**
	 * Plantillas Word Informe Cierre Campanha
	 */
	public static final String NOMBRE_PLANTILLA_INFORME_CIERRE_CAMPANHA_RTF = "campanha_cierre.rtf";

	public static final String NOMBRE_PLANTILLA_INFORME_CIERRE_CAMPANHA_XML = "campanha_cierre.xml";

	/**
	 * Plantillas Word Publicacion Notificacion
	 */
	public static final String NOMBRE_PLANTILLA_PUBLICACION_NOTIFICACION_RTF = "notificationdocument.rtf";

	public static final String NOMBRE_PLANTILLA_PUBLICACION_NOTIFICACION_XML = "notificationdocument.xml";

	/**
	 * Plantillas Word Protocolo
	 */
	public static final String NOMBRE_PLANTILLA_PROTOCOLO_RTF = "protocolo.rtf";

	public static final String NOMBRE_PLANTILLA_PROTOCOLO_CON_INFRACCION_RTF = "protocoloConInfraccion.rtf";

	public static final String NOMBRE_PLANTILLA_PROTOCOLO_XML = "protocolo.xml";

	/**
	 * Plantillas Word Ficha Solicitudes
	 */
	public static final String NOMBRE_PLANTILLA_SOLICITUDES_INICIO_CONS_RTF = "INICIO - CONS.rtf";

	/**
	 * Plantillas Word Etiqueta Inspecciones
	 */
	public static final String NOMBRE_PLANTILLA_INSPECCIONES_ETIQUETA_RTF = "etiqueta-ins.rtf";

	public static final String NOMBRE_PLANTILLA_INSPECCIONES_ETIQUETA_XML = "etiqueta-ins.xml";

	/**
	 * Plantillas Word Etiqueta Control Mercado
	 */
	public static final String NOMBRE_PLANTILLA_CONTROL_MERCADO_CAMPANAS_ETIQUETA_RTF = "etiqueta-campana.rtf";

	public static final String NOMBRE_PLANTILLA_CONTROL_MERCADO_ALERTAS_ETIQUETA_RTF = "etiqueta-alerta.rtf";

	public static final String NOMBRE_PLANTILLA_CONTROL_MERCADO_SOIVRE_ETIQUETA_RTF = "etiqueta-soivre.rtf";

	public static final String NOMBRE_PLANTILLA_CONTROL_MERCADO_ETIQUETA_XML = "etiqueta-cm.xml";

	/**
	 * Plantillas Word Ficha Establecimiento
	 */
	public static final String NOMBRE_PLANTILLA_ESTABLECIMIENTO_FICHA_RTF = "establecimiento.rtf";

	public static final String NOMBRE_PLANTILLA_ESTABLECIMIENTO_FICHA_XML = "establecimiento.xml";

	/**
	 * Plantillas Word Acta Inspeccion Web
	 */
	public static final String NOMBRE_PLANTILLA_ACTA_INSPECCION_WEB_RTF = "ACTA_INSPECCION_WEB.rtf";

	public static final String NOMBRE_PLANTILLA_ACTA_INSPECCION_WEB_XML = "ACTA_INSPECCION_WEB.xml";

	/**
	 * Origen Documentos Acta - Estado de la solicitud
	 */
	public static final String ESTABLECIMIENTO_VISITADO = "V";

	public static final String GENERADO_ADMINISTRACION = "A";

	public static final String ESTABLECIMIENTO_RESPONSABLE = "R";

	/**
	 * Estadisticas de kontsumonet
	 */
	public static final String ESTADISTICAS_KONTSUMONET_CONSULTAS = "C";

	public static final String ESTADISTICAS_KONTSUMONET_SOLICITUDES = "S";

	public static final String ESTADISTICAS_KONTSUMONET_COMUNICACIONES = "M";

	public static final String EXCEL_ESTADISTICASKONTMUNET = "Estadisticas Kontsumonet";

	/**
	 * Estadisticas de consultas
	 */
	public static final String ESTADISTICAS_CONSULTAS_FORMA_PRESENTACION = "COE01";

	public static final String ESTADISTICAS_CONSULTAS_MOTIVOS_PRODUCTOS = "COE03";

	public static final String ESTADISTICAS_CONSULTAS_PRODUCTOS = "COE04";

	public static final String ESTADISTICAS_CONSULTAS_SEXO_EDAD = "COE05";

	public static final String ESTADISTICAS_CONSULTAS_PROMEDIO_TIEMPO_RESPONDER_CONSULTA = "COE06";

	public static final String ESTADISTICAS_CONSULTAS_TIEMPO_ATENCION_CONSULTAS_PRESENCIALES = "COE07";

	public static final String ESTADISTICAS_CONSULTAS_TIEMPO_RESPUESTA_CONSULTAS_WEB_FAX = "COE08";

	/**
	 * Listados de consultas
	 */
	public static final String LISTADOS_CONSULTAS_RELACION_CONSULTAS = "COR01";

	public static final String LISTADOS_CONSULTAS_RELACION_CONSULTAS_ABREVIADA = "COR02";

	/**
	 * Estadisticas de solicitudes
	 */
	public static final String ESTADISTICAS_SOLICITUDES_DECISIONES_LOCALIDAD_ESTABLECIMIENTO = "DEE01";

	public static final String ESTADISTICAS_SOLICITUDES_DECISIONES_LOCALIDAD_CONSUMIDOR = "DEE01b";

	public static final String ESTADISTICAS_SOLICITUDES_SECTORES_LOCALIDAD_ESTABLECIMIENTO = "DEE02";

	public static final String ESTADISTICAS_SOLICITUDES_MOTIVOS = "DEE03";

	public static final String ESTADISTICAS_SOLICITUDES_DECISIONES = "DEE04";

	public static final String ESTADISTICAS_SOLICITUDES_FORMA_PRESENTACION_LOCALIDAD_CONSUMIDOR = "DEE05";

	public static final String ESTADISTICAS_SOLICITUDES_SECTORES_LOCALIDAD_CONSUMIDOR = "DEE06";

	public static final String ESTADISTICAS_SOLICITUDES_SEXO_EDAD = "DEE07";

	public static final String ESTADISTICAS_SOLICITUDES_PROMEDIO_TIEMPO_RESOLVER_SOLICITUD = "DEE09";

	public static final String ESTADISTICAS_SOLICITUDES_PRODUCTOS_LOCALIDAD_ESTABLECIMIENTO = "DEEP1";

	public static final String ESTADISTICAS_SOLICITUDES_PRODUCTOS_LOCALIDAD_CONSUMIDOR = "DEEP1b";

	/**
	 * Listados de solicitudes
	 */
	public static final String LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_PRODUCTO_MOTIVO = "DER01";

	public static final String LISTADOS_SOLICITUDES_RELACION_ESTABLECIMIENTOS = "DER03";

	public static final String LISTADOS_SOLICITUDES_RELACION_PRODUCTOS = "DER04";

	public static final String LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_SIN_DECISION = "DER05";

	public static final String LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_CON_DECISION = "DER08";

	public static final String LISTADOS_SOLICITUDES_RELACION_ESTADO_EXPEDIENTES_CURSO = "DER09";

	public static final String LISTADOS_SOLICITUDES_RELACION_TIEMPO_TRAMITACION = "DER11";

	// Tipo solicitud
	public static final String TIPO_MEDIACION_TELEFONICA = "T";

	public static final String TIPO_MEDIACION_PRESENCIAL = "P";

	// Tipo solicitud
	public static final String TIPO_SOLICITUD_DENUNCIA = "D";

	public static final String TIPO_SOLICITUD_QUEJA = "Q";

	public static final String TIPO_SOLICITUD_RECLAMACION = "R";

	public static final String TIPO_SOLICITUD_DENUNCIA_EMPRESAS = "E";

	// Forma presentacion Solicitudes
	public static final String FORMA_PRESENTACION_SOLICITUD_WEB = "W";
	public static final String FORMA_PRESENTACION_SOLICITUD_WEB_POR_APP = "A";
	public static final String FORMA_PRESENTACION_WEB_SINCERTIFICADO = "Z";
	public static final String FORMA_PRESENTACION_PERSONAL = "P";
	public static final String FORMA_PRESENTACION_SIR = "S";

	/* CAPV */
	public static final String CAPV = "16";

	/**
	 * Tipos de espera
	 */
	public static final String TIPO_ESPERA_REQUERIMIENTO = "1";

	public static final String TIPO_ESPERA_RECURSO = "2";

	// DIAS ESPERA
	public static final int ESPERA_DIAS_NOTIFICACION = 10;

	public static final int ESPERA_DIAS_ALEGACION = 15;

	public static final int ESPERA_DIAS_REQUERIMIENTO_INFORMACION = 15;

	public static final int ESPERA_DIAS_CIERRE_EXPEDIENTE = 60;

	// ESPERA DESCRIPCION
	public static final String ESPERA_DESC_ACTO_NOTIF_ES = "Acto de notificacion de espera";

	public static final String ESPERA_DESC_ACTO_NOTIF_EU = "Itxaronaldiaren jakinarazpen-egintza";

	// HISTORICO DESCRIPCION
	public static final String HISTORICO_DESC_ACTO_NOTIF_ES = "Acto de notificacion de historico";

	public static final String HISTORICO_DESC_ACTO_NOTIF_EU = "Historikoaren jakinarazpen-egintza";

	// TIPOS DE TAREA DE ESPERA
	public static final String TIPO_TAREA_CREAR_ESPERA = "CREARESPERA";

	public static final String TIPO_TAREA_MATAR_ESPERA = "MATARESPERA";

	// PLATEA
	public static final String TIPO_ESPERA_SAVE_OR_UPDATE_NT = "saveOrUpdateProceedingsNT";

	public static final String TIPO_HISTORICO_SAVE_OR_UPDATE_NT = "saveOrUpdateProceedingsNT";

	public static final String TIPO_HISTORICO_DELETE_NT = "deleteProceedingsNT";

	/**
	 * Tipos documentales usados en PLATEA en diferentes acciones telematicas
	 */
	public static final String TIPO_DOC_INFORME = "ejgv_d_informe";

	public static final String TIPO_DOC_ALEGACION = "ejgv_d_alegacion";

	public static final String TIPO_DOC_ACTA = "ejgv_d_acta";

	public static final String TIPO_DOC_ACTA_INSP = "ejgv_d_acta_insp";

	public static final String TIPO_DOC_RESOLUCION = "ejgv_d_resolucion";

	public static final String TIPO_DOC_ARCHIVO_GENERICO = "ejgv_d_archivo";

	public static final String TIPO_DOC_RECURSO = "ejgv_d_recurso";

	public static final String TIPO_DOC_RESPUESTA_MEDIACION = "ejgv_d_respuestamediacion";

	// Nuevos detectados ini
	public static final String TIPO_DOC_SOLICITUD = "ejgv_d_solicitud";

	public static final String TIPO_DOC_COMUNICACION = "ejgv_d_comunicacion";

	public static final String TIPO_DOC_REQUERIMIENTO = "ejgv_d_requerimiento";

	public static final String TIPO_DOC_ACUSE_RECIBO = "ejgv_d_acuserecibo";

	public static final String TIPO_DOC_NOTIFICACION = "ejgv_d_notificacion";

	public static final String TIPO_DOC_SENTENCIA = "ejgv_d_sentencia";

	public static final String TIPO_DOC_BOLETIN = "ejgv_d_boletin";

	public static final String TIPO_DOC_SUBSANACION = "ejgv_d_requsubs";

	public static final String TIPO_DOC_LIQUIDACION = "ejgv_d_liquidacion";

	public static final String TIPO_DOC_ORDEN = "ejgv_d_ordenadministrativa";

	public static final String TIPO_DOC_ACREDITACION_REPRESENTACION = "ejgv_d_escritura_apod";

	public static final String TIPO_DOC_FACTURA = "ejgv_d_factura";

	public static final String TIPO_DOC_AIP = "ejgv_d_acuerdo_inicunproc";

	public static final String TIPO_DOC_CERTIFICADO = "ejgv_d_certificado";

	public static final String TIPO_DOC_JUSTIFICANTE = "ejgv_d_justificante";

	public static final String TIPO_DOC_SOLICITUD_AMPLIACION_PLAZO = "ejgv_d_solicitud.0.ampliacion_plazo";

	public static final String TIPO_DOC_ACUERDO_AMPLIACION_PLAZO = "ejgv_d_acuerdo_amplplaz";

	// 0150948 2.1
	public static final String TIPO_DOC_RECHAZO_ARBITRAJE = "ejgv_d_consentimiento";
	// 2.1 0150948
	// Nuevos detectados fin

	public static final String TIPO_DOC_SUFIJOTIPOSUBTIPO = ".0.0";

	public static final String EJGV_TIPO_BOLETIN_BOPV = "BOPV";

	// TIPOS DOCUMENTALES QUE NO ESTAN EN PLATEA,
	// ... pero cuando haya que subirlos a DOKUSI,
	// ... se tipificaran como archivo generico 'ejgv_d_archivo' (u otro)
	// REVISAR LA CLASE Y41bDokusiServiceImpl (metodo registrarDocumentoDokusi)

	// 86178: [SOLICITUDES] - Nuevos tramites - Solicitud de colaboracin...
	public static final String TIPO_DOC_RESP_SOL_COLABORACION = "ejgv_d_respsolcolaboracion";

	public static final String TIPO_DOC_SOL_ARBITRAJE = "ejgv_d_solicitudarbitraje";

	public static final String TIPO_DOC_INS_INFORME_INSPECCION = "ejgv_d_informeinspeccion";

	public static final String TIPO_DOC_EST_RESOLUCION_INSCRIP = "ejgv_d_resolucion_inscrip";

	/**
	 * FIN Tipos documentales
	 */

	/**
	 * Identificativos de los procedimientos de PLATEA
	 */
	public static final String ID_PROCEDIMIENTO_SOLICITUDES = "Y41B_RECLAMACION";
	public static final String ID_PROCEDIMIENTO_SANCIONES = "Y41B_SANCIONES";
	public static final String ID_PROCEDIMIENTO_INSPECCIONES = "Y41B_INSPECCIONES";
	public static final String ID_PROCEDIMIENTO_ESTABLECIMIENTOS = "Y41B_ESTABLECIMIENTOS";

	public static final String CABECERA_XML_ISO = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";

	public static final String CABECERA_XSL_SOLICITUD = "<?xml-stylesheet href=\"solicitud.xsl\" type=\"text/xsl\"?>";

	public static final String SUBMISSIONTYPE_SOLICITUD_PRESENCIAL = "0";

	public static final String SUBMISSIONTYPE_SOLICITUD = "1";

	public static final String SUBMISSIONTYPE_APORTARDOC = "2";

	public static final int INITIATIONTYPE_OFICIO_INICIATIVA_PROPIA = 2;

	public static final String MESSAGECONTROL = "MESSAGECONTROL";

	public static final String CERTIFIEDVALIDATIONMODE = "CERTIFIEDVALIDATIONMODE";

	public static final String ASYNC = "ASYNC";

	public static final String APPLICATION = "APPLICATION";

	public static final String APPLICANT = "APPLICANT";

	public static final String FISICA = "1";

	public static final String JURIDICA = "2";

	public static final String TITULAR = "1";

	public static final String REPRESENTANTE = "2";

	public static final String INTERESADO = "3";

	public static final String AFFECTED = "AFFECTED";
	public static final String AFECTED = "AFECTED";

	public static final String SOURCE_NAME_SOLICITUD = "Solicitud.html";
	public static final String SOURCE_NAME_SOLICITUD_EUS = "Eskaera.html";

	public static final String ELECTRONICO = "1";

	public static final String POSTAL = "2";

	public static final String ORIGIN_RDE = "RDE";

	public static final int DOS = 2;

	public static final int TRES = 3;

	public static final int MIL = 1000;

	public static final int CHANNELTYPE = 1;

	public static final int CHANNELTYPE_NOTIF_EMAIL = 1;

	public static final int CHANNELTYPE_NOTIF_SMS = 2;

	public static final String PERSONTYPE = "1";

	public static final String HOLDERSHIP_TITULAR = "1";

	public static final String HOLDERSHIP_REPRESENTANTE = "2";

	public static final int CONTACTTYPE = 1;

	public static final String PREFIJO_CAMPO_OCULTO = "<oculto>";

	public static final String DATACONTROL1_TYPE = "MESSAGECONTROL";

	public static final String DATACONTROL1_VALUE = "N";// No telematico N.

	// Telematico S
	public static final String DATACONTROL2_TYPE = "CERTIFIEDVALIDATIONMODE";

	public static final String DATACONTROL2_VALUE = "SYNC";

	// RoleId de solicitud. En v2.0 era EJGV_APPLICATION
	public static final String EJGV_APPLICATION = "ejgv_d_solicitud.0.0";

	// Documentos adjuntados - texto plano
	public static final String DOCUMENTOS_AGIRIAK = "Documentos / Agiriak";

	public static final String DOCUMENTOS_AGIRIAK_SUB = "------------------------";

	public static final String DOCUMENTOS_TIPO = "- Tipo documento / Dokumentu-mota";

	public static final String DOCUMENTOS_NOMBRE = "- Nombre del documento / Dokumentuaren izena";

	public static final String DOCUMENTOS_DOCUMENTO = "- Documento / Dokumentua";

	public static final String LITERAL_PROCEEDINGSID_PRESENCIAL = "solicitud";

	public static final String LITERAL_PROCEEDINGSID_APORTACION = "aportacion";

	public static final String LITERAL_PROCEEDINGSID_TELEMATICO = "solicitud";

	public static final String LITERAL_PROCEEDINGSID_OFICIO = "solicitud";

	public static final String LITERAL_PROCEEDINGSID_APERTURA = "Apertura";

	public static final String LITERAL_PROCEEDINGSID_APERTURA_RECLAMADO = "Apertura";

	public static final String LITERAL_PROCEEDINGSID_CIERRE = "cerrarExpediente";

	public static final String LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES = "Presentacin de solicitud presencial";

	public static final String LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_EU = "Eskaeren aurkezpen presentziala";

	public static final String LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_ES = "Presentacin de solicitud telemtica";

	public static final String LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_EU = "Eskaeren aurkezpen telematikoa";

	public static final String LITERAL_APORTACION_DOCUMENTACION_ES = "Aportacin de Documentacin";

	public static final String LITERAL_APORTACION_DOCUMENTACION_EU = "Agiri Ekarpena";

	public static final String LITERAL_REQUERIMIENTO_SUBSANACION_CONSUMIDOR_ES = "Requerimiento subsanacin de documentacin al reclamante";

	public static final String LITERAL_REQUERIMIENTO_SUBSANACION_CONSUMIDOR_EU = "Erreklamatzaileari dokumentazioa zuzentzeko egindako eskaera";

	public static final String LITERAL_DECISION_ES = "Registro de decisin";

	public static final String LITERAL_DECISION_EU = "Erabaki-erregistroa";

	public static final String LITERAL_COMUNICACION_ES = "Comunicacin";

	public static final String LITERAL_COMUNICACION_EU = "Komunikazioa";

	public static final String LITERAL_NOTIFICACION_ES = "Notificacin";

	public static final String LITERAL_NOTIFICACION_EU = "Jakinarazpena";

	public static final String LITERAL_ACTA_ES = "Acta";

	public static final String LITERAL_ACTA_EU = "Akta";

	public static final String LITERAL_SOLICITUD_ES = "Solicitud";

	public static final String LITERAL_SOLICITUD_EU = "Eskaera";

	public static final String LITERAL_SITUACION_ACUSERECIBO_ACEPTADO_ES = "Aceptado";

	public static final String LITERAL_SITUACION_ACUSERECIBO_ACEPTADO_EU = "Onartua";

	public static final String LITERAL_SITUACION_ACUSERECIBO_RECHAZADO_ES = "Rechazado";

	public static final String LITERAL_SITUACION_ACUSERECIBO_RECHAZADO_EU = "Baztertua";

	public static final String LITERAL_SITUACION_ACUSERECIBO_NOENTREGADO_ES = "No entregado";

	public static final String LITERAL_SITUACION_ACUSERECIBO_NOENTREGADO_EU = "Ez entregatua";

	public static final String LITERAL_APERTURA_PRESENCIAL_ES = "Apertura del expediente Presencial";

	public static final String LITERAL_APERTURA_PRESENCIAL_EU = "Ireki espedientea";

	public static final String LITERAL_APERTURA_TELEMATICO_ES = "Apertura del expediente Telemtico";

	public static final String LITERAL_APERTURA_TELEMATICO_EU = "Ireki espedientea";

	public static final String LITERAL_APERTURA_OFICIO_ES = "Apertura del expediente de oficio";

	public static final String LITERAL_APERTURA_OFICIO_EU = "Ireki espedientea";

	public static final String LITERAL_CIERRE_ES = "Cierre del Expediente";

	public static final String LITERAL_CIERRE_EU = "Espedientea Ixtea";

	public static final String LITERAL_CIERREARCHIVO_ES = "Cierre y Archivo";

	public static final String LITERAL_CIERREARCHIVO_EU = "Ixtea eta Artxibatzea";

	public static final String LITERAL_GOBIERNO_VASCO_ES = "Gobierno Vasco";

	public static final String LITERAL_GOBIERNO_VASCO_EU = "Eusko Jaurlaritza";

	public static final String LITERAL_KONTSUMOBIDE_ES = "Kontsumobide-Instituto Vasco de Consumo";

	public static final String LITERAL_KONTSUMOBIDE_EU = "Kontsumobide-Kontsumoko Euskal Institutua";

	public static final String LITERAL_ACUERDOINCOACION_ES = "Acuerdo de incoacin";
	public static final String LITERAL_ACUERDOINCOACION_EU = "Hasteko akordioa";

	public static final String LITERAL_RECURSOALZADA_ES = "Recepcin del recurso de alzada";
	public static final String LITERAL_RECURSOALZADA_EU = "Gora jotzeko errekurtsoa jasotzea";

	public static final String LITERAL_RECURSOEXTRAORDINARIO_ES = "Recepcin recurso extraordinario de revisin";
	public static final String LITERAL_RECURSOEXTRAORDINARIO_EU = "Berrikusteko errekurtso berezia jasotzea";

	public static final String LITERAL_ORDENCONSEJERO_ES = "Recepcin de orden de consejero";
	public static final String LITERAL_ORDENCONSEJERO_EU = "Sailburuaren agindua jasotzea";

	public static final String LITERAL_SOLICITUD_REDUCCION_ES = "Recepcin solicitud reduccin";
	public static final String LITERAL_SOLICITUD_REDUCCION_EU = "Murrizketa eskaera jasotzea";

	public static final String LITERAL_LIQUIDACION_ES = "Emisin de liquidacin";
	public static final String LITERAL_LIQUIDACION_EU = "Likidazioa";

	/* Constantes de TIPOS DE NOTIFICACIONES */
	public static final String LITERAL_ALEGACION_ES = "Alegacin";
	public static final String LITERAL_ALEGACION_EU = "Alegazioa";

	public static final String LITERAL_RESOLUCION_ES = "Resolucin";
	public static final String LITERAL_RESOLUCION_EU = "Ebazpena";

	public static final String LITERAL_RECURSO_ES = "Recurso";
	public static final String LITERAL_RECURSO_EU = "Errekurtsoa";

	public static final String LITERAL_REQUERIMIENTO_ES = "Requerimiento";
	public static final String LITERAL_REQUERIMIENTO_EU = "Errekerimendua";

	public static final String LITERAL_SUBSANACION_ES = "Subsanacin";
	public static final String LITERAL_SUBSANACION_EU = "Zuzendu";

	public static final String LITERAL_PROPUESTARESOLUCION_ES = "Propuesta de resolucin";
	public static final String LITERAL_PROPUESTARESOLUCION_EU = "Ebazpen-proposamena";

	public static final String LITERAL_RESOLUCIONRECURSOACEPTDEN_ES = "Resolucin al recurso de aceptacin o denegacin de la prueba";
	public static final String LITERAL_RESOLUCIONRECURSOACEPTDEN_EU = "Froga onartu edo ezeztatzeko errekurtsorako ebazpena";

	public static final String LITERAL_RESOLUCIONSOLICITUD_ES = "Resolucin a solicitud de prueba";
	public static final String LITERAL_RESOLUCIONSOLICITUD_EU = "Froga-eskarirako ebazpena";

	public static final String LITERAL_INCOACION_ES = "Incoacin";
	public static final String LITERAL_INCOACION_EU = "Hastea";

	public static final String LITERAL_RESOLUCIONCOMPLEMENTARIA_ES = "Resolucin complementaria";
	public static final String LITERAL_RESOLUCIONCOMPLEMENTARIA_EU = "Ebazpen osagarria";

	public static final String LITERAL_ACUERDOAMPLIACIONPLAZOALEG_ES = "Acuerdo de ampliacin de plazo de presentacin de alegaciones";
	public static final String LITERAL_ACUERDOAMPLIACIONPLAZOALEG_EU = "Alegazioak aurkezteko epea handitzeko akordioa";

	public static final String LITERAL_REQUERIMIENTOACREDREPR_ES = "Requerimiento de acreditacin de representacin";
	public static final String LITERAL_REQUERIMIENTOACREDREPR_EU = "Ordezkaritza-egiaztapena eskatzea";

	public static final String LITERAL_RESOLUCIONFRACCIONAMIENTO_ES = "Resolucin de fraccionamiento";
	public static final String LITERAL_RESOLUCIONFRACCIONAMIENTO_EU = "Zatiketa-ebazpena";

	public static final String LITERAL_RESOLUCIONRECURSOALZADA_ES = "Resolucin recurso de alzada";
	public static final String LITERAL_RESOLUCIONRECURSOALZADA_EU = "Gora jotzeko errekurtsoaren ebazpena";

	public static final String LITERAL_LIQUIDACIONPAGOVOLUNTARIO_ES = "Liquidacin en pago voluntario";
	public static final String LITERAL_LIQUIDACIONPAGOVOLUNTARIO_EU = "Likidazioa borondatezko ordainketa bidez";

	public static final String LITERAL_ACUSENOENTREGADOBOE_ES = "No entregado - Publicado BOE";
	public static final String LITERAL_ACUSENOENTREGADOBOE_EU = "Entregatu gabea- BOEn argitaratua";

	public static final String LITERAL_CONVENIO_ARBITRAL_ES = "Convenio arbitral";
	public static final String LITERAL_CONVENIO_ARBITRAL_EU = "Arbitraje-hitzarmena";

	public static final String LITERAL_DESIGNACION_COLEGIO_ES = "Designacin colegio arbitral";
	public static final String LITERAL_DESIGNACION_COLEGIO_EU = "Izendatu arbitraje-elkargoa";
	public static final String LITERAL_AUDIENCIA_ES = "Audiencia";
	public static final String LITERAL_AUDIENCIA_EU = "Audientzia";
	public static final String LITERAL_2AUDIENCIA_ES = "2 audiencia";
	public static final String LITERAL_2AUDIENCIA_EU = "2. audientzia";
	public static final String LITERAL_CITACION_AUDIENCIA_ES = "Citacin audiencia";
	public static final String LITERAL_CITACION_AUDIENCIA_EU = "Zitazioa audientziarako";
	public static final String LITERAL_SUSPENSION_AUDIENCIA_ES = "Suspensin audiencia";
	public static final String LITERAL_SUSPENSION_AUDIENCIA_EU = "Audientzia atzeratzea";
	public static final String LITERAL_CITACION_A_PRUEBA_ES = "Citacin a prueba";
	public static final String LITERAL_CITACION_A_PRUEBA_EU = "Zitazioa probarako";
	public static final String LITERAL_CITACION_2AUDIENCIA_ES = "Citacin 2 audiencia";
	public static final String LITERAL_CITACION_2AUDIENCIA_EU = "Zitazioa 2. audientziarako";
	public static final String LITERAL_LAUDO_ES = "Laudo";
	public static final String LITERAL_LAUDO_EU = "Laudoa";
	public static final String LITERAL_ACLARACION_ES = "Aclaracin";
	public static final String LITERAL_ACLARACION_EU = "Argibidea";
	public static final String LITERAL_RECEPCION_SOLICITUD_ACLARACION_ES = "Recepcin solicitud acalaracin";
	public static final String LITERAL_RECEPCION_SOLICITUD_ACLARACION_EU = "Argitzeko eskabidea jaso";
	public static final String LITERAL_PAGO_PERICIAL_ES = "Pago pericial";
	public static final String LITERAL_PAGO_PERICIAL_EU = "Aditua ordaintzea";
	public static final String LITERAL_RECEPCION_INFORME_PERICIAL_ES = "Recepcin informe pericial";
	public static final String LITERAL_RECEPCION_INFORME_PERICIAL_EU = "Peritu txostena jaso";
	public static final String LITERAL_RECEPCION_ALEGACIONES_ES = "Recepcin alegaciones";
	public static final String LITERAL_RECEPCION_ALEGACIONES_EU = "Alegazioak jaso";
	public static final String LITERAL_RESULTADO_ANALISIS_ES = "Resultado anlisis";
	public static final String LITERAL_RESULTADO_ANALISIS_EU = "Azterketaren emaitza";

	/* Constantes de DOKUSI */
	public static final String DOCUMENT_TYPE_PRE = "PRE";

	public static final String NATURALEZA_PAPEL = "PAPEL";

	public static final String NATURALEZA_DIGITALIZADO = "DIGITALIZADO";

	public static final String NATURALEZA_ELECTRONICO = "ELECTRONICO";

	public static final String CODE_ELECTRONICDDOCUMENT = "electronicDocument";

	public static final String ORIGEN_CIUDADANIA = "CIUDADANIA";

	public static final String ORIGEN_ADMINISTRACION = "ADMINISTRACION";

	public static final String ORIGEN_ORGANISMO_EXTERNO = "ORGANISMO_EXTERNO";

	public static final String ACL_NOMBRE = "ejgv_acl_d_Y41B_001";

	public static final String DOCUMENTO_ENTRADA = "E";

	public static final String DOCUMENTO_SALIDA = "S";

	public static final String FILTROSANCIONES_EXPEDIENTE_ABIERTO = "A";

	public static final String FILTROSANCIONES_EXPEDIENTE_CERRADO = "C";

	public static final String FILTROSANCIONES_EXPEDIENTE_TODOS = "T";

	public static final String TIPO_PROCEDIMIENTO = "CODPROCEDIMIENTO";

	/*
	 * SANCIONES
	 */
	public static final String SESSION_NUMEXP = "SESSION_NUMEXP_SANCIONES";

	public static final String SAN_CALIFICACION_LEVE = "L";

	public static final String SAN_CALIFICACION_GRAVE = "G";

	public static final String SAN_CALIFICACION_MUYGRAVE = "M";

	public static final String SAN_LIQUIDACION_PAGADO = "P";

	public static final String SAN_LIQUIDACION_NOPAGADO = "N";

	public static final String SAN_LIQUIDACION_PAGADOPARCIALMENTE = "A";

	public static final String SAN_TIPO_PRUEBA_TESTIFICAL = "T";

	public static final String SAN_TIPO_PRUEBA_DOCUMENTAL = "D";

	public static final String SAN_TIPO_PRUEBA_PERICIAL = "P";

	public static final String SAN_PRUEBA_RESULTADO_ACEPTADA = "A";

	public static final String SAN_PRUEBA_RESULTADO_RECHAZADA = "R";

	public static final String SAN_ESTADO_ENVIO_NO_ENTREGADO = "N";

	public static final String SAN_ESTADO_ENVIO_ENVIADO = "E";

	public static final String SAN_ESTADO_ENVIO_ERROR = "X";

	public static final String SAN_ESTADO_ENVIO_RECOGIDO = "R";

	public static final String SAN_TIPORESOLUCION_VALORANTIGUOMULTA = "MU";

	public static final String SAN_TIPORESOLUCION_VALORANTIGUOOBRESEIMIENTO = "SO";

	public static final String SAN_TIPORESOLUCION_VALORANTIGUOCADUCIDAD = "CA";

	public static final String SAN_TIPORESOLUCION_VALORANTIGUOARCHIVO = "AR";

	public static final String SEPARADOR_COD_COMPLETO_EXP = "-";

	/* TIPOS DE COMUNICACION */
	public static final String TIPO_COMUNICACION_TELEMATICA = "T";

	public static final String TIPO_COMUNICACION_CORREOELECTRONICO = "E";

	public static final String TIPO_COMUNICACION_CORREOORDINARIO = "C";

	/* TIPOS DE NOTIFICACION */
	public static final String TIPO_NOTIFICACION_TELEMATICA = "T";

	public static final String TIPO_NOTIFICACION_ORDINARIA = "C";

	/* NOTIFICACIONES (PLATEA) */
	public static final String NOTIFICACION_SUBSANACION = "REQ_SUB";

	public static final String NOTIFICACION_ALEGACION = "REQ_ALEG";

	public static final String NOTIFICACION_REQUERIMIENTO = "REQUERIMIENTO";

	public static final String NOTIFICACION_RESOLUCION = "RESOL";

	public static final String NOTIFICACION_RESOLUCION_RECURSO = "RESOL_RECUR";

	public static final String NOTIFICACION_RECURSO = "r02d8C8C89BDCADD6B18A58B16FA23EF2865004CB872";

	public static final String NOTIFICACION_DESISTIMIENTO = "r02d1F337460E1F40617B2D000E3C8EA08914BA01AFA";

	public static final String NOTIFICACION_ACEPTACION_RENUNCIA = "ACEPT";

	public static final String NOTIFICACION_COMUNICACION = "COMUNICATION";

	public static final String NOTIFICACION_PROPUESTA_RESOLUCION = "PROP_RESOL";

	public static final String NOTIFICACION_RESOL_COMPLEMENTARIA = "RESOL_COMP";

	public static final String NOTIFICACION_SOL_INCOACION = "INCO";

	public static final String NOTIFICACION_RESOLUCIONRECURSOACEPTDEN = "PRUEBAS";

	public static final String NOTIFICACION_DESC_COMUNICACION = "COMUNICACION";

	public static final String NOTIFICACION_SAN_REQUERIMIENTOINFO = "REQUERIMIENTOINFORMACION";

	public static final String TIPO_FIRMA_ENVELOPED = "enveloped";

	public static final String TIPO_FIRMA_DETACHED = "detached";

	/* ETIQUETAS XMLNS */
	public static final String ETIQUETA_DESCRIPTION_INI_XMLNS = "<description xmlns=\"com/ejie/r02k/xml\">";

	/* LOCALIZADOR */
	public static final String PDFA = "pdfa";

	public static final String PDF = "pdf";

	/* VERSION DOCUMENTO */
	public static final String VERSION_MAYOR = "MAYOR";

	/* METADATOS */
	public static final String METADATO_KEYWORDS = "keywords";

	public static final String METADATO_TITLE = "title";

	/* FICHAS DE TRAMITES DE SANCIONES */

	/*
	 * TRAMITE PUBLICACION AYUNTA BOPV
	 */
	public static final String MODOTRAMITES_TRAMITE_K39 = "modoSANInformacionPublicacionBOPVAyunta";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K39_idTramite = "tramiteSANInformacionPublicacionBOPVAyunta";

	/*
	 * TRAMITE AMPLIACIÓN PLAZO ALEGACIONES
	 */
	public static final String MODOTRAMITES_TRAMITE_K40 = "modoSANAmpliacionPlazoAlegaciones";

	/*
	 * TRAMITE LIQUIDACION
	 */
	public static final String MODOTRAMITES_TRAMITE_K41 = "modoSANLiquidacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K40_idTramite = "tramiteSANAmpliacionPlazoAlegaciones";

	/*
	 * TRAMITE ACUERDO INCOACCIÓN
	 */

	public static final String MODOTRAMITES_TRAMITE_K27 = "modoSANAcuerdoIncoacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K27_idTramite = "tramiteSANAcuerdoIncoacion";

	/*
	 * TRAMITE ACUERDO INCOACCIÓN
	 */

	public static final String MODOTRAMITES_TRAMITE_K43_K114 = "modoRequerimientoAcreditacionRepresentacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K43_K114_idTramite = "tramiteRequerimientoAcreditacionRepresentacion";

	/*
	 * TRAMITE ACUERDO INCOACCIÓN
	 */

	public static final String MODOTRAMITES_TRAMITE_K113_K115 = "modoRecepcionRequerimientoAcreditacionRepresentacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K113_K115_idTramite = "tramiteRecepcionRequerimientoAcreditacionRepresentacion";

	/*
	 * TRAMITE RESOLUCIÓN A SOLICITUD DE PRUEBA
	 */

	public static final String MODOTRAMITES_TRAMITE_K28 = "modoSANResolucionSolicitudPrueba";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K28_idTramite = "tramiteSANResolucionSolicitudPrueba";

	/*
	 * TRAMITE RESOLUCIÓN A SOLICITUD DE PRUEBA
	 */

	public static final String MODOTRAMITES_TRAMITE_K29 = "modoSANPropuestaResolucion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K29_idTramite = "tramiteSANPropuestaResolucion";

	/*
	 * TRAMITE RESOLUCIÓN A SOLICITUD DE PRUEBA
	 */

	public static final String MODOTRAMITES_TRAMITE_K30 = "modoSANResolucion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K30_idTramite = "tramiteSANResolucion";

	/*
	 * TRAMITE RESOLUCIÓN AL RECURSO DE PRUEBA
	 */
	public static final String MODOTRAMITES_TRAMITE_K44 = "modoSANResolucionRecursoPrueba";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K44_idTramite = "tramiteSANResolucionRecursoPrueba";

	/*
	 * TRAMITE RESOLUCIÓN AL RECURSO DE PRUEBA
	 */
	public static final String MODOTRAMITES_TRAMITE_K34 = "modoNotificacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K34_idTramite = "tramiteNotificacion";

	/*
	 * TRAMITE RESOLUCIÓN COMPLEMENTARIA
	 */
	public static final String MODOTRAMITES_TRAMITE_K31 = "modoSANResolucionComplementaria";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K31_idTramite = "tramiteSANResolucionComplementaria";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K41_idTramite = "tramiteSANLiquidacion";

	/*
	 * TRAMITE RESOLUCIÓN COMPLEMENTARIA
	 */
	public static final String MODOTRAMITES_TRAMITE_K45 = "modoSANRecepcionRecursoAlzada";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K45_idTramite = "tramiteSANRecepcionRecursoAlzada";

	/*
	 * TRAMITE SOLICITUD REDUCCION
	 */
	public static final String MODOTRAMITES_TRAMITE_K48 = "modoSANRecepcionSolicitudReduccion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K48_idTramite = "tramiteSANRecepcionSolicitudReduccion";

	/*
	 * TRAMITE SOLICITUD REDUCCION
	 */
	public static final String MODOTRAMITES_TRAMITE_K49 = "modoSANPago";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K49_idTramite = "tramiteSANPago";

	// EVOLUTIVO 0135083 2.4
	/*
	 * TRAMITE REQUERIMIENTO INFROMACION
	 */

	public static final String MODOTRAMITES_TRAMITE_K116 = "modoSANRequerimientoInformacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K116_idTramite = "tramiteSANRequerimientoInformacion";

	/*
	 * TRAMITE RECEPCION REQUERIMIENTO INFROMACION
	 */

	public static final String MODOTRAMITES_TRAMITE_K117 = "modoSANRecepcionRequerimientoInformacion";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K117_idTramite = "tramiteSANRecepcionRequerimientoInformacion";

	/*
	 * TRAMITE RECURSO EXTRAORDINARIO
	 */

	public static final String MODOTRAMITES_TRAMITE_K124 = "modoSANRecepcionRecursoExtraordinario";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K124_idTramite = "tramiteSANRecepcionRecursoExtraordinario";

	// EVOLUTIVO 0135083 2.4
	/* amaia */

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA = "E";

	public static final String TIPO_DOCUMENTO_SANCIONES_SALIDA = "S";

	/* sara */

	public static final String ORIGEN_SAN_APORTADO_RECLAMANTE = "CO";// Consumidor
																		// origen

	public static final String ORIGEN_SAN_APORTADO_RECLAMANTE2 = "C";// Consumidor

	public static final String ORIGEN_SAN_APORTADO_RECLAMADO = "ES";

	public static final String ORIGEN_SAN_APORTADO_OTROS = "O";

	public static final String ORIGEN_SAN_APORTADO_ADMINISTRACION = "A";

	public static final String ORIGEN_SAN_APORTADO_ESTABLECIMIENTO = "F";

	public static final String ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO = "RE";

	public static final String DESDE_INICIO = "INICIO";

	public static final String DESDE_BUSQUEDA = "BUSQUEDA";

	public static final String DESDE_DETALLE = "DETALLE";

	public static final String DESDE_COMBINADA = "COMBINADA";

	public static final String DESDE_BANDEJA = "BANDEJA";

	public static final String DESDE_ASIENTO_REGISTRAL = "ASIENTO_REGISTRAL";

	public static final String DESDE_PAGOS_ARBITROS = "PAGOS_ARBITROS";

	/*
	 * TRAMITE APERTURA
	 */
	public static final String MODOTRAMITES_TRAMITE_K26 = "modoSANApertura";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K26_idTramite = "tramiteSANApertura";

	/*
	 * TRAMITE ELABORACION INFORME ASESORIA
	 */
	public static final String MODOTRAMITES_TRAMITE_K32 = "modoSANElaboracionInformeAsesoria";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K32_idTramite = "tramiteSANElaboracionInformeAsesoria";

	/*
	 * PASARELA PAGOS
	 */
	public static final String PASARELA_CANAL_NOTIFICACION_POSTAL = "P";

	public static final String PASARELA_CANAL_NOTIFICACION_TELEMATICO = "T";

	/*
	 * TRAMITE RECEPCION ORDEN CONSEJERO
	 */
	public static final String MODOTRAMITES_TRAMITE_K46 = "modoSANRecepcionOrdenConsejero";

	/*
	 * tiene que existir en el tiles
	 */
	public static final String MODOTRAMITES_TRAMITE_K46_idTramite = "tramiteSANRecepcionOrdenConsejero";

	public static final int SAN_ESTIMACION_TOTAL = 1;

	public static final int SAN_ESTIMACION_PARCIAL = 2;

	public static final int SAN_DESESTIMACION = 3;

	public static final String DNI_ORGANISMO_ASESORIA = "56123664F";

	public static final String OPERACION_SIPCA_EMISION = "01";

	public static final String OPERACION_SIPCA_ANULACION = "03";

	public static final String OPERACION_SIPCA_DEVOLUCION = "04";

	public static final String OPERACION_SIPCA_MODIFICACION = "05";

	public static final String OPERACION_SIPCA_COBRO = "06";

	public static final String OPERACION_SIPCA_ANULACION_COBRO = "07";

	public static final String OPERACION_SIPCA_ANULACIONSIPCA = "08";

	public static final String OPERACION_SIPCA_RECHAZOOCE = "09";

	public static final String OPERACION_SIPCA_FRACCIONAMIENTO = "10";

	public static final String OPERACION_SIPCA_COBRO_ERRONEO = "12";

	public static final String OPERACION_SIPCA_COBRO_NO_IDENTIFICADO = "13";

	public static final String OPERACION_SIPCA_APROBACION_OCE = "14";

	public static final String OPERACION_SIPCA_COBRO_ERRONEO_DEVUELTO = "15";

	public static final String OPERACION_SIPCA_ANULACION_FRACCIONAMIENTO = "16";

	public static final String OPERACION_SIPCA_INFO_EJECUTIVO = "17";

	public static final String OPERACION_SIPCA_PASOVIAAPREMIO = "18";

	public static final String OPERACION_ANULACION_PASOVIAAPREMIO = "19";

	public static final String OPERACION_ANULACION_DEUDA_VIAAPREMIO = "25";

	public static final String OPERACION_APROBACION_ANULACION_DEUDA_VIAAPREMIO = "29";

	public static final String OPERACION_SIPCA_PAGO_DEVOLUCION = "31";

	public static final String PERIODO_EJECUTIVO = "E";

	public static final String PERIODO_VOLUNTARIO = "V";

	public static final String SENTIDO_OPERACION_SALIDA = "0";

	public static final String SENTIDO_OPERACION_ENTRADA = "1";

	public static final String ESTADO_MOVIMIENTO_PDTE_ENVIO = "P";

	public static final String ESTADO_MOVIMIENTO_RECIBIDO = "R";

	public static final String ESTADO_MOVIMIENTO_ENVIADO = "E";

	public static final String CONCEPTOPAGO_SIPCA_DEVENGOCOBRO = "4008";/*
																		 * NO
																		 * FIRME
																		 */

	public static final String CONCEPTOPAGO_SIPCA_DEVENGOEMISION = "4009"; /* FIRME */

	/**
	 * Nombre Plantilla Tramite Sancion
	 */
	public static final String NOMBRE_PLANTILLA_XML_TRAMITE_SAN_CASTELLANO = "tramitesancion.xml";

	/**
	 * Tipo documental platea
	 */
	public static final String TIPO_DOC_SAN_SOLICITUD_AMP_PLAZO = "8";

	public static final String TIPO_DOC_SAN_INFORME_RECURSO_ALZADA = "15";

	public static final String TIPO_DOC_SAN_PROPUESTA_RESOLUCION = "16";

	public static final String TIPO_DOC_SAN_RESOLUCION_EXP_SANC = "17";

	public static final String TIPO_DOC_SAN_ACUERDO_INCOACION = "18";

	public static final String TIPO_DOC_SAN_REQ_ACREDITA = "19";

	public static final String TIPO_DOC_SAN_RESOLUCION_SOL_PRUEBA = "20";

	public static final String TIPO_DOC_SAN_RESOLUCION_RECURSO_PRUEBA = "21";

	public static final String TIPO_DOC_SAN_RESOLUCION_COMPLEMENTARIA = "22";

	public static final String TIPO_DOC_SAN_LIQUIDACION = "23";

	public static final String TIPO_DOC_SAN_ACUERDO_AMP_PLAZO = "24";

	public static final String TIPO_DOC_SAN_NOTIFICACION = "26";

	public static final String TIPO_DOC_SAN_COMUNICACION = "27";

	public static final String TIPO_DOC_SAN_ACUSE = "3";

	public static final String TIPO_DOC_SAN_ACREDITACION_REPRESENTACION = "19";

	public static final String TIPO_DOC_OTROS = "31";

	// EVOLUTIVO 0135083 2.5 NUEVA CONSTANTE PARA NUEVO TIPO DE APORTE
	// REQUERIMIENTO
	public static final String TIPO_DOC_SAN_REQ_ENTRADA = "34";

	public static final String COD_PAIS_ESTADO = "108";

	/**
	 * Liquidacion Pasarela
	 */
	public static final String TIPO_CONCEPTO_PAGO_SANCIONES = "S";

	public static final String FORMATO_PASARELA = "507";

	public static final String FORMATO_FECHA_PASARELA = "ddMMyy";

	public static final String FORMATO_FECHA_BASE_PASARELA = "yyyyMMdd";

	public static final String RESPONSABLE_APLICACION = "Ejie";

	public static final String PAGO_LIQUIDACION = "01";

	public static final String COD_APLICACION_PASARELA = "y41b";

	// En la carta de pago aparece 9050794 pero los ultimos 2 digitos no se
	// admiten al recuperar la carta de pago
	public static final String CPR = "90507";

	// Concepto pago SIPCA de reintegro subvencion
	public static final String CONCEPTOPAGO_SIPCA_REINTEGRO_SUBVENCION = "3007";
	// Codigo subvencion para reintegro subvencion
	public static final String CODIGO_SUBVENCION_REINTEGRO_SUBVENCION = "IKUS";
	// Codigo causa reintegro para reintegro subvencion
	public static final String CAUSA_REINTEGRO_REINTEGRO_SUBVENCION = "30";

	public static final String ESTADO_PAGO_PP = "PP";
	public static final String ESTADO_PAGO_PENDIENTE_ENVIO = "PE";
	public static final String ESTADO_PAGO_PENDIENTE_INGRESO = "IP";
	public static final String ESTADO_PAGO_PENDIENTE_PAGO = "PP";

	/* PARA EL FRACCIONAMIENTO */

	public static final String ESTADO_PAGO_ANULADO_FRACCIONAMIENTO = "AF";

	public static final String ESTADO_PAGO_SOLICITUD_FRACCIONAMIENTO = "FP";

	public static final String ESTADO_PAGO_PAGADO_DEFINITIVO = "DD";

	public static final String ESTADO_PAGO_PAGADO_PROVISIONAL = "DP";

	public static final String ESTADO_PAGO_PAGADO = "GA";

	public static final String ESTADO_PAGO_PAGADO_APREMIO = "PG";

	public static final String ESTADO_PAGO_PASE_APREMIO = "PV";

	public static final String ESTADO_PAGO_APREMIO = "VA";

	public static final String ESTADO_PAGO_PENDIENTE_ANULAR_APREMIO = "PS";

	public static final String ESTADO_PAGO_ANULADO_VENCIMIENTO = "AS";

	public static final String ESTADO_PAGO_SOBRESEIMIENTO = "SO";

	public static final String ESTADO_PAGO_IMPAGADO = "IM";

	public static final String ESTADO_PAGO_ANULADO = "AN";

	/* PARAMETRO PARA VALIDAR FIRMANTE EN BANDEJA FIRMA */
	public static final String VALIDAR_FIRMANTE_BANDEJA_FIRMA = "VALIDAR_FIRMANTE_BANDEJA_FIRMA";

	public static final String CONTROL_LOCALIZACION_DOCUMENTOS = "CONTROL_LOCALIZACION_DOCUMENTOS";

	/* AVISOS DE LA BANDEJA DE SOLICITUDES */
	public static final String TIPO_AVISO_SOLICITUDES_NOTIFICACION_SIN_ACUSE = "TIPO_AVISO_SOLICITUDES_NOTIFICACION_SIN_ACUSE";

	public static final String TIPO_AVISO_SOLICITUDES_REGISTRO_ALEGACION = "TIPO_AVISO_SOLICITUDES_REGISTRO_ALEGACION";

	public static final String TIPO_AVISO_SOLICITUDES_REQUERIMIENTO_INFORMACION = "TIPO_AVISO_SOLICITUDES_REQUERIMIENTO_INFORMACION";

	public static final String TIPO_AVISO_SOLICITUDES_CIERRE_EXPEDIENTE = "TIPO_AVISO_SOLICITUDES_CIERRE_EXPEDIENTE";

	/* AVISOS DE LA BANDEJA DE SANCIONES */
	public static final String TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL = "TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL";

	public static final String TIPO_AVISO_SANCIONES_APERTURA_RESOL = "TIPO_AVISO_SANCIONES_APERTURA_RESOL";

	public static final String TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC = "TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC";

	public static final String TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA = "TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA";

	public static final String TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL = "TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL";

	public static final String TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION = "TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION";

	public static final String TIPO_AVISO_SANCIONES_REMISION_ASESORI = "TIPO_AVISO_SANCIONES_REMISION_ASESORI";

	public static final String TIPO_AVISO_SANCIONES_PRESCRIPCION = "TIPO_AVISO_SANCIONES_PRESCRIPCION";

	public static final String SANCIONES_PRESCRIPCION_LEVE = "SANCIONES_PRESCRIPCION_LEVE";

	public static final String SANCIONES_PRESCRIPCION_GRAVE = "SANCIONES_PRESCRIPCION_GRAVE";

	public static final String SANCIONES_PRESCRIPCION_MUYGRAVE = "SANCIONES_PRESCRIPCION_MUYGRAVE";

	/* AVISOS DE LA BANDEJA DE SOLICITUDES */
	public static final String TIPO_AVISO_INSPECCIONES_NOTIFICACION_SIN_ACUSE = "TIPO_AVISO_INSPECCIONES_NOTIFICACION_SIN_ACUSE";

	public static final String TIPO_AVISO_INSPECCIONES_RECEPCION_ALEGACIONES = "TIPO_AVISO_INSPECCIONES_RECEPCION_ALEGACIONES";

	public static final String TIPO_AVISO_INSPECCIONES_RECEPCION_REQUERIMIENTO = "TIPO_AVISO_INSPECCIONES_RECEPCION_REQUERIMIENTO";

	public static final String TIPO_AVISO_INSPECCIONES_CIERRE_EXPEDIENTE = "TIPO_AVISO_INSPECCIONES_CIERRE_EXPEDIENTE";

	/* PARAMETRO DE FECHA DE FIN PREVISTA */
	// public static final String PARAMETRO_SANCIONES_DIRECTOR_KONTSUMOBIDE =
	// "DIRECTOR_KONTSUMOBIDE";

	public static final String PARAMETRO_SANCIONES_FECHAFINPREVISTA = "FECHA_FIN_PREVISTA";

	public static final String PARAMETRO_SANCIONES_ID_ORGANISMO_ASESORIA = "ID_ORGANISMO_ASESORIA";

	public static final String PARAMETRO_SANCIONES_DECISION_SOLICITUD = "CODIGO_DECISION_APERTURA_SANCION_BASE_SOLICITUD";

	public static final String PARAMETRO_IMPORTE_SANCION_LEVE = "IMPORTE_SANCION_LEVE";

	public static final String PARAMETRO_IMPORTE_SANCION_GRAVE = "IMPORTE_SANCION_GRAVE";

	public static final String PARAMETRO_IMPORTE_SANCION_MUYGRAVE = "IMPORTE_SANCION_MUYGRAVE";

	/* PARAMETROS DE PRESCRIPCION DEL EXPEDIENTE SANCIONADOR */
	public static final String PARAMETRO_SANCIONES_PRESCRIPCION_LEVE = "PARAMETRO_SANCIONES_PRESCRIPCION_LEVE";

	public static final String PARAMETRO_SANCIONES_PRESCRIPCION_GRAVE = "PARAMETRO_SANCIONES_PRESCRIPCION_GRAVE";

	public static final String PARAMETRO_SANCIONES_PRESCRIPCION_MUYGRAVE = "PARAMETRO_SANCIONES_PRESCRIPCION_MUYGRAVE";

	public static final String PARAMETRO_SANCIONES_FECHA_RESOLUCION_INSTRUCTOR = "PARAMETRO_SANCIONES_FECRESINS_";

	public static final String PARAMETRO_AA66_ULTIMA_EJECUCION_JMS = "AA66_ULTIMA_EJECUCION_JMS";

	public static final String PARAMETRO_CONTROLMERCADO_FROMGENERICO = "CONTROLMERCADO_FROMGENERICO_EMAIL";

	public static final String PARAMETRO_CONTROLMERCADO_TOGENERICO = "CONTROLMERCADO_TOGENERICO_EMAIL";

	public static final String PARAMETRO_MB_MAX_REMESA = "MB_MAX_REMESA";

	public static final int TIPO_AVISO_SANCIONES_NUMERODIASANTES = 5;

	/* TIPOS DE DOCUMENTOS DE SANCIONES */
	public static final String TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION = "ACUERDOINCOACION";

	public static final String TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA = "RESOL_RECUR";

	public static final String TIPO_NOTIFICACION_SANCIONES_RESOLUCION = "RESOL";

	public static final String TIPO_NOTIFICACION_SANCIONES_PROPUESTA_RESOLUCION = "PROP_RESOL";

	public static final String TIPO_NOTIFICACION_SANCIONES_RESOLUCIONCOMPLEMENTARIA = "RESOL_COMP";

	public static final String TIPO_NOTIFICACION_SANCIONES_RESOLUCION_SOLICITUD_PRUEBA = "RESOLUCIONALEGACION";

	public static final String TIPO_NOTIFICACION_SANCIONES_ELABORACION_DOCUMENTACION_BOPV = "CONSULTAOTRASADMINS";

	public static final String TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO = "REQUERIMIENTO";

	public static final String TIPO_NOTIFICACION_SANCIONES_ACUERDO_AMPLIACIONPLAZOALEGACIONES = "NOTIFACUERDO";

	public static final String TIPO_NOTIFICACION_SANCIONES_RESOLUCIONFRACCIONAMIENTO = "RESPALEGACIONES";

	public static final String TIPO_NOTIFICACION_SANCIONES_OTROS = "OTROS";
	// EVOLUTIVO 0135083 2.4
	public static final String TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTOINFORMACION = "REQUERIMIENTOINFORMACION";
	// EVOLUTIVO 0135083 2.4
	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUDPRUEBA = "4";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO = "2";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSOEXTRAORDINARIO = "35";

	// public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_TABLON_AYTO =
	// "6";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_ORDEN_CONSEJERO = "5";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_AMPLIACION_PLAZO_ALEGACIONES = "8";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_ACREDITACION_REPRESENTACION = "14";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_ACUERDO_INCOACION = "28";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_PROPUESTA_RESOLUCION = "29";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_APORTACIONDOCUMENTACION = "31";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD = "33";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO_ACEPTACION_DENEGACION = "13";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_EXPEDIENTE_JUZGADO = "12";

	public static final String TIPO_DOCUMENTO_SANCIONES_SOLICITUD_FRACCIONAMIENTO = "11";

	public static final String TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_REDUCCION = "32";

	public static final String IDENTITY = "W43sIdentity";

	public static final String SIGNATURETYPE_XADES = "xades";

	/**
	 * Fases de las Campañas
	 */
	public static final String FASE_CAMPANHA_INACTIVA = "I";

	public static final String FASE_CAMPANHA_BORRADOR = "B";

	public static final String FASE_CAMPANHA_VALIDACION = "V";

	public static final String FASE_CAMPANHA_EJECUCION = "E";

	public static final String FASE_CAMPANHA_ANALISIS = "A";

	public static final String FASE_CAMPANHA_CIERRE = "C";

	/**
	 * Informe final
	 */
	public static final String CAMPANHA_INFORME_VACIO = "V";

	public static final String CAMPANHA_INFORME_SEMICOMPLETO = "S";

	public static final String CAMPANHA_INFORME_COMPLETO = "C";

	/**
	 * Alertas
	 */
	public static final String ORGANISMO_SSCC = "SSCC";

	public static final String CREACION_ALERTA = "Creacin de la alerta";

	public static final String ENVIO_PROGRAMACION = "Envo de la programacin de alerta a SSTT";

	public static final String FIN_ACTUACIONES_ALERTA_ORGANICO = "Fin de actuaciones de la alerta en orgnico";

	public static final String RECALIFICACION_ALERTA = "Recalificacin de la red de alerta";

	public static final String ANULACION_ALERTA = "Anulacin de la red de alerta";

	public static final String CIERRE_ALERTA = "Cierre de la alerta en Kontsumobide";

	public static final String REAPERTURA_ALERTA = "Reapertura de la alerta en Kontsumobide";

	/**
	 * Comunicaciones Soivre
	 */
	public static final String FECHA_ENTRADA_COMUNICACION_SOIVRE = "Fecha de entrada";

	public static final String FECHA_ENVIO_SSTT_COMUNICACION_SOIVRE = "Fecha de envo a SSTT";

	public static final String FECHA_PRIMER_CONTACTO_COMUNICACION_SOIVRE = "Fecha de primer contacto/actuacin de la inspeccin ante la empresa";

	public static final String FECHA_FIN_INSPECCION_COMUNICACION_SOIVRE = "Fecha fin de inspeccin";

	public static final String FECHA_RESPUESTA_INSPECCION_COMUNICACION_SOIVRE = "Fecha respuesta a AECOSAN/SOIVRE";

	public static final String SOIVRE_TIPO_SUBSANABLES = "S";

	public static final String SOIVRE_TIPO_RECHAZOS = "D";

	public static final String SOIVRE_TIPO_ALERTA = "A";

	public static final String SOIVRE_TIPO_INFORMATIVA = "I";

	/**
	 * Origen del detalle de Campanhas, Alertas y Comunicaciones Soivre
	 */
	public static final String VIENE_DE_BANDEJAS = "bandejas";

	public static final String VIENE_DE_BUSQUEDA = "busqueda";

	/*
	 * PLANTILLAS SANCIONES
	 */
	public static final String GRUPO_CONTACTO_AYUNTAMIENTO = "G_1200";

	public static final String OFICINA_KONTSUMOBIDE_ALAVA = "E_1";

	public static final String OFICINA_KONTSUMOBIDE_BIZKAIA = "E_241";

	public static final String OFICINA_KONTSUMOBIDE_GIPUZKOA = "E_102";

	public static final String OFICINA_CENTRAL = "01A106";

	/*
	 * LOCALIZACION
	 */
	public static final String NORA_LOCALIZACION_TODOS = "T";

	public static final String NORA_LOCALIZACION_ESTADO = "E";

	public static final String NORA_LOCALIZACION_EXTRANJERO = "X";

	/*
	 * PLANTILLAS DECISION - TRAMITE INHIBICION TRASPORTE
	 */
	/*
	 * public static final String IT_20_48_Linea1 =
	 * "EUSKADIKO GARRAIO JUNTA ARBITRALA";
	 * 
	 * public static final String IT_20_48_Linea2 =
	 * "JUNTA ARBITRAL DE TRANSPORTE DEL PAS VASCO";
	 * 
	 * public static final String IT_20_48_Linea3 = "Elcano, 10";
	 * 
	 * public static final String IT_20_48_Linea4 = "48011 BILBAO";
	 * 
	 * public static final String IT_20_48_Linea5 = "Tel.: 944 509 325 / 465";
	 * 
	 * public static final String IT_20_48_Linea6 =
	 * "junta_arbitral.bizkaia@seap.minhap.es";
	 * 
	 * public static final String IT_01_Linea1 =
	 * "ARABAKO GARRAIO JUNTA ARBITRALA";
	 * 
	 * public static final String IT_01_Linea2 =
	 * "JUNTA ARBITRAL DE TRANSPORTE DE ALAVA";
	 * 
	 * public static final String IT_01_Linea3 =
	 * "Plaza de la Provincia 4 interior bajo";
	 * 
	 * public static final String IT_01_Linea4 = "01001 VITORIA-GASTEIZ";
	 * 
	 * public static final String IT_01_Linea5 = "Tel: 945 18 18 18. Ext 2173";
	 * 
	 * public static final String IT_01_Linea6 = " ";
	 */

	// busca en la tabla de parametros con este id
	public static final String IT_01_Linea1 = "IT_01_Linea1";
	public static final String IT_01_Linea2 = "IT_01_Linea2";
	public static final String IT_01_Linea3 = "IT_01_Linea3";
	public static final String IT_01_Linea4 = "IT_01_Linea4";
	public static final String IT_01_Linea5 = "IT_01_Linea5";
	public static final String IT_01_Linea6 = "IT_01_Linea6";

	public static final String IT_20_Linea1 = "IT_20_Linea1";
	public static final String IT_20_Linea2 = "IT_20_Linea2";
	public static final String IT_20_Linea3 = "IT_20_Linea3";
	public static final String IT_20_Linea4 = "IT_20_Linea4";
	public static final String IT_20_Linea5 = "IT_20_Linea5";
	public static final String IT_20_Linea6 = "IT_20_Linea6";

	public static final String IT_48_Linea1 = "IT_48_Linea1";
	public static final String IT_48_Linea2 = "IT_48_Linea2";
	public static final String IT_48_Linea3 = "IT_48_Linea3";
	public static final String IT_48_Linea4 = "IT_48_Linea4";
	public static final String IT_48_Linea5 = "IT_48_Linea5";
	public static final String IT_48_Linea6 = "IT_48_Linea6";

	/*
	 * PLANTILLAS DECISION - TRAMITE NO AVENENCIA-CONS
	 */
	public static final String NOAVECONS_CAS = ".- Que puede someter a Arbitraje de Consumo la cuestin objeto de reclamacin ante la Junta Arbitral de Consumo del Pas Vasco (c/Santiago 11 01002 Vitoria-Gasteiz www.kontsumobide.net). Se adjunta hoja de solicitud de arbitraje";

	public static final String NOAVECONS_EUS = ".- Kontsumo Arbitrajearen menpe jar dezakezula erreklamazio hau eragin duen arazoa Euskadiko Kontsumo Junta Arbitralaren aurrean (k/Santiago 11 01002 Vitoria-Gasteiz www.kontsumo.net). Honekin batera doa Arbitraje Eskabidearen orria";

	/*
	 * FRACCIONAMIENTO
	 */
	public static final String CABECERA_LIQUIDACION_TIPO_REGISTRO = "01";

	public static final String CABECERA_LIQUIDACION_ESTIMACION_RESOLUCION = "1";

	public static final String CABECERA_LIQUIDACION_CODIGO_CAUSA = "2";

	public static final String CABECERA_LIQUIDACION_TIPO_DE_PAGO = "1";

	public static final String CABECERA_LIQUIDACION_TIPO_NOTIFICACION = "02";

	public static final String CABECERA_LIQUIDACION_ORGANO_RESPONSABLE_RESOLUCION = "02";

	/* TRAMITE RESOLUCION COMPLEMENTARIA */

	public static final String TIPO_PROPUESTA_PAGO_APLAZAMIENTO = "A";

	public static final String TIPO_PROPUESTA_PAGO_FRACCIONAMIENTO = "F";

	public static final int CIEN = 100;

	/**
	 * Estado remesa
	 */
	public static final String ESTADO_REMESA_PENDIENTE = "P";

	public static final String ESTADO_REMESA_EMITIDA = "E";

	public static final String ESTADO_REMESA_GENERADA = "G";

	public static final String ESTADO_REMESA_ERRONEA = "X";

	public static final String ESTADO_REMESA_CERRADA = "C";

	public static final String ESTADO_REMESA_ELIMINACION_ERRONEA = "Y";

	public static final String ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS = "Z";

	/**
	 * Operaciones remesa
	 */
	public static final String OPERACION_REMESA = "OPERACION_REMESA";

	public static final String CODIGO_REMESA = "CODIGO_REMESA";

	public static final String OPERACION_REMESA_GENERAR_REMESA = "1";

	public static final String OPERACION_REMESA_ACTUALIZAR_ESTADO_TODAS_REMESAS = "2";

	public static final String OPERACION_REMESA_ACTUALIZAR_ESTADO_UNA_REMESA = "3";

	public static final String OPERACION_REMESA_ACTUALIZAR_MISGESTIONES = "4";

	/**
	 * WIDTH COMBOS PLANTILLA
	 */
	public static final String WIDTH_COMBOS_PLANTILLA = "440";

	/* TIPO INFRACCION SANCIONES */
	public static final String TIPO_INFRACCION_SANCIONES_MATERIA = "M";
	public static final String TIPO_INFRACCION_SANCIONES_ARTICULO = "A";

	public static final String TIPO_SAN_EXPREL_ORIGEN = "S";
	public static final String TIPO_SAN_EXPREL_ACUMULADO = "A";
	public static final String TIPO_SAN_EXPREL_OTROS = "N";

	// MAIL ORIGEN
	public static final String ID_MAIL_ORIGEN_RESPONSABLE = "R";
	public static final String ID_MAIL_ORIGEN_GENERICO = "G";
	public static final String ID_MAIL_ORIGEN_CONTROL_MERCADO = "C";

	// DESCRIPCION MAIL ORIGEN
	public static final String MAIL_ORIGEN_RESPONSABLE_DESCRIPCION = "Responsable expediente";
	public static final String MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE = "Espedientearen arduraduna";

	public static final String MAIL_ORIGEN_GENERICO_DESCRIPCION = "Genrico";
	public static final String MAIL_ORIGEN_GENERICO_DESCRIPCIONE = "Orokorra";

	public static final String MAIL_ORIGEN_CONTROL_MERCADO_DESCRIPCION = "Control de mercado";
	public static final String MAIL_ORIGEN_CONTROL_MERCADO_DESCRIPCIONE = "Merkatuaren kontrola";

	// MAIL ESTABLECIMIENTO
	public static final String ID_MAIL_ESTABLECIMIENTO_PRINCIPAL = "P";

	// DESCRIPCION MAIL ESTABLECIMIENTO
	public static final String MAIL_ESTABLECIMIENTO_DESCRIPCION = " Principal";
	public static final String MAIL_ESTABLECIMIENTO_DESCRIPCIONE = " Nagusia";

	// PREFIJO FICHERO ENVIO SIPCA
	public static final String PREFIJO_FICHERO_ENVIO_SIPCA = "fn77a101";
	public static final String PREFIJO_FICHERO_RECEPCION_SIPCA = "fn77a211";
	public static final String ESTADO_PAGO_ERRORFICHERO = "EF";
	public static final String ESTADO_PAGO_ERROR = "EP";
	/**
	 * Registro Presencial
	 */
	public static final String UNIDAD_ORGANICA_ARABA = "2174";
	public static final String UNIDAD_ORGANICA_GIPUZKOA = "2175";
	public static final String UNIDAD_ORGANICA_BIZKAIA = "2176";

	public static final String UNIDAD_ORGANICA_ARBITRAJE = "2174";

	public static final String UNIDAD_ORGANICA_CONTROLMERCADO = "2174";

	/**
	 * Otros ingresos
	 */

	public static final String SANCIONES = "S";

	public static final String CLASE_HOJAS_RECLAMACIONES = "2";
	public static final String CLASE_INTERESES = "3";
	public static final String CLASE_OTROS_INGRESOS = "4";
	public static final String ID_ORGANISMO_SERVICIO_CENTRAL_PUBLICACIONES = "ID_ORGANISMO_SERVICIO_CENTRAL_PUBLICACIONES";

	public static final String ARABA = "01";
	public static final String GIPUZKOA = "20";
	public static final String BIZKAIA = "48";

	/**
	 * Tramite generico de reapertura expediente
	 */
	public static final String NOMBRE_TRAMITE_GENERICO_REAPERTURA = "Apertura expediente";

	/**
	 * LITERAL PIF
	 */
	public static final String PIF_LITERAL_GENERAL = "error.pif.invocation";

	/**
	 * Remesas
	 */
	public static final String INTEGRACION_CON_AA66 = "INTEGRACION_CON_AA66_NOTIF_ELECTR";
	public static final String AA66_CONTROL_GENERACION_REMESA = "AA66_CONTROL_GENERACION_REMESA";
	public static final String AA66_NMAX_ENVIOS = "AA66_NUMERO_MAX_ENVIOS";
	public static final String COD_TIPO_REMESA_DIARIA = "D";
	public static final String AA66_COD_SITUACION_SIN_ACTUALIZAR_CORREOS = "00";

	public static final String AA66_DIAS_DE_ESPERA_CONSULTA = "AA66_DIAS_DE_ESPERA_CONSULTA";

	// Errores controlados que devuelve el WS de AA66
	public static final String AA66_WS_ERROR_PREPARAR_NO_EXISTE = "ERROR_PREPARAR_01";
	public static final String AA66_WS_ERROR_PREPARAR_CERRADA = "ERROR_PREPARAR_03";
	public static final String AA66_WS_ERROR_NO_HAY_PDF = "ERROR_PDF_03";
	public static final String AA66_WS_ERROR_ELIMINAR_ENVIO_NO_EXISTE = "ERROR_ELIMINAR_01";
	public static final String AA66_WS_ERROR_ELIMINAR_ENVIO = "ERROR_ELIMINAR_03";
	public static final int AA66_SLEEP = 5000;

	/**
	 * Envios Por Remesa
	 */
	public static final String AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS = "R";
	public static final String AA66_ENVIO_SITUACION_ERROR = "X";

	/**
	 * Documento adjuntado a la remesa
	 */
	public static final String PRUEBA_ENTREGA_ENVIO = "Prueba Entrega Envio";

	/**
	 * Justificante acuse
	 */
	public static final String JUSTIFICANTE_NOTIFICACION_ELECTRONICA = "Justificante de notificacin electrnica";

	/**
	 * busqueda remesas
	 */
	public static final String REMESAS_BUSQUEDA_ESTADOENVIO_SINACTUALIZAR = "SA";
	public static final String REMESAS_BUSQUEDA_ESTADOENVIO_SINESTADO = "SE";
	public static final String REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE = "N";
	public static final String REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOS = "R";
	public static final String REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE = "S";
	public static final String REMESAS_BUSQUEDA_ESTADOENVIO_ERRONEO = "X";

	/**
	 * situacion correos
	 */
	public static final String REMESAS_SITUACIONCORREOS_OTROS = "OTROS";

	/**
	 * situacion acuse
	 */
	public static final String REMESAS_SITUACIONACUSE_SINSITUACION = "SS";

	/**
	 * ARBITRAJE
	 */
	public static final String CENSO_ARB_OOEE = "ooee";
	public static final String CENSO_ARB_AACC = "aacc";
	public static final String CENSO_ARB_ARBITRO = "arbitro";
	public static final String CENSO_ARB_EMPPER = "empper";
	public static final String CENSO_ARB_JJAA = "jjaa";
	public static final String CENSO_ARB_ADHERIDO = "A";
	public static final String CENSO_ARB_TIPOARBITROC = "C";
	public static final String CENSO_ARB_TIPOARBITROE = "E";
	public static final String CENSO_ARB_TIPOARBITROP = "P";
	public static final String CENSO_ARB_TCLUGAUD = "tclugaud";
	public static final String CENSO_ARB_ARBITRO_DIR_CEN = "C";
	public static final String CENSO_ARB_ARBITRO_DIR_DOM = "D";
	public static final String CENSO_ARB_ARBITRO_DIR_DOM2 = "A";

	public static final String SESSION_NUMEXP_ARB = "SESSION_NUMEXP_ARBITRAJE";
	public static final String SEPARADOR_COD_COMPLETO_ARB = "-";
	public static final String SEPARADOR_COD_COMPLETO_ARB_ADO = "/";

	/**
	 * Tipos de intervinientes
	 */
	public static final String TIPO_INTERVINIENTEARB_RECLAMANTE = "I";
	public static final String TIPO_INTERVINIENTEARB_RECLAMADO = "E";
	public static final String TIPO_INTERVINIENTEARB_SECRETARIO = "S";
	public static final String TIPO_INTERVINIENTEARB_ARBITRO = "B";
	public static final String TIPO_INTERVINIENTEARB_CONSUMIDOR = "C";
	public static final String TIPO_INTERVINIENTEARB_ESTABLECIMIENTO = "F";
	public static final String TIPO_INTERVINIENTEARB_PERITO = "P";
	public static final String TIPO_INTERVINIENTEARB_OTROS = "O";
	public static final String TIPO_INTERVINIENTEARB_TODOS = "T";
	public static final String TIPO_INTERVINIENTEARB_ADMINISTRACION = "A";
	public static final String TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE = "U";
	public static final String TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO = "V";
	public static final String TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO = "W";
	public static final String TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO = "X";
	public static final String TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_ANTERIOR = "Y";
	public static final String TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_ANTERIOR = "Z";

	/**
	 * Fese tramites ARBITRAJE
	 */

	public static final String FASE_REGISTRO_ARBITRAJE = "18";

	public static final String FASE_INICIO_ARBITRAJE = "19";

	public static final String FASE_ANALISIS_ARBITRAJE = "20";

	public static final String FASE_CONVENIO_ARBITRAJE = "21";

	public static final String FASE_COLEGIO_ARBITRAJE = "22";

	public static final String FASE_AUDIENCIA_ARBITRAJE = "23";

	public static final String FASE_RESOLUCION_ARBITRAJE = "24";

	public static final String FASE_CIERRE_ARBITRAJE = "25";

	/**
	 * Trmites de ARBITRAJE
	 */
	public static final String TRAMITE_ARBITRAJE_GENERICO = "K84";

	public static final String TRAMITE_ARBITRAJE_COMUNICACION = "K78";

	public static final String TRAMITE_ARBITRAJE_NOTIFICACION = "K77";

	public static final String TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION = "K82";

	public static final String TRAMITE_ARBITRAJE_CIERRE = "K76";
	public static final String TRAMITE_ARBITRAJE_ACUSERECIBO = "K79";
	public static final String TRAMITE_ARBITRAJE_APERTURA = "K91";
	public static final String TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE = "K80";
	public static final String TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE = "K81";
	public static final String TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE = "K52";
	public static final String TRAMITE_ARBITRAJE_SUBSANACION = "K53";
	public static final String TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION = "K54";
	public static final String TRAMITE_ARBITRAJE_ANALISIS_EMPRESA = "K55";
	public static final String TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM = "K56";
	public static final String TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA = "K57";
	public static final String TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE = "K58";
	public static final String TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL = "K59";
	public static final String TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO = "K60";
	public static final String TRAMITE_ARBITRAJE_CITACION_AUDIENCIA = "K61";
	public static final String TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA = "K62";
	public static final String TRAMITE_ARBITRAJE_AUDIENCIA = "K63";
	public static final String TRAMITE_ARBITRAJE_CITACION_A_PRUEBA = "K64";
	public static final String TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL = "K65";
	public static final String TRAMITE_ARBITRAJE_PAGO_PERICIAL = "K66";
	public static final String TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA = "K67";
	public static final String TRAMITE_ARBITRAJE_2AUDIENCIA = "K68";
	public static final String TRAMITE_ARBITRAJE_RESOLUCION = "K69";
	public static final String TRAMITE_ARBITRAJE_LAUDO = "K70";
	public static final String TRAMITE_ARBITRAJE_PAGO_LAUDO = "K71";
	public static final String TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION = "K72";
	public static final String TRAMITE_ARBITRAJE_ACLARACION = "K73";
	public static final String TRAMITE_ARBITRAJE_PROPUESTA_SANCIONADOR = "K74";
	public static final String TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE = "K75";
	public static final String TRAMITE_ARBITRAJE_MEDIACION = "K83";
	public static final String TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES = "K85";
	public static final String TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA = "K86";
	public static final String TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA_CONTRATO = "K87";
	public static final String TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION = "K114";
	public static final String TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION = "K115";
	public static final String TRAMITE_ARBITRAJE_COMUNICAARBITROS = "K118";
	public static final String TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO = "K119";

	public static final String TRAMITES_ARBITRAJE_NOGENERABLES = "'K76', 'K79', 'K91', 'K80', 'K81', 'K115', 'K75'";

	public static final String TRAMITE_ARB_COPIA_EXPEDIENTE_EJECUCION = "E";

	public static final String TRAMITE_ARB_COPIA_EXPEDIENTE_ANULACION = "A";

	public static final String SAINEFIN_D = "D";

	public static final String SAINEFIN_T = "T";

	public static final String ACLARACION = "A";
	public static final String SOLICITUD_ACLARACION = "S";

	public static final String SOL_ACLARACION_TIPO_ACLARACION = "A";
	public static final String SOL_ACLARACION_TIPO_CORRECCION = "C";
	public static final String SOL_ACLARACION_VALORACION_INFUNDADA = "I";
	public static final String SOL_ACLARACION_VALORACION_FUNDADA = "F";

	public static final String ESTADO_ACUSE_ACEPTADO = "A";
	public static final String ESTADO_ACUSE_NO_ENTREGADO = "N";
	public static final String ESTADO_ACUSE_RECHAZADO = "R";

	public static final String ARBITRAJE_SAINTISO_EQUIDAD = "E";
	public static final String ARBITRAJE_EQUIDAD = "Equidad/Ekitatea";
	public static final String ARBITRAJE_SAINTISO_DERECHO = "D";
	public static final String ARBITRAJE_DERECHO = "Derecho/Zuzenbidea";

	public static final String ARBITRAJE_SAINACUO_PARTICULAR = "P";
	public static final String ARBITRAJE_PARTICULAR = "Particular/Partikularra";
	public static final String ARBITRAJE_SAINACUO_ORGANISMO = "O";

	/**
	 * PArametros
	 */
	public static final String PORCENTAJE_REDUCCION_PRONTO_PAGO = "PORCENTAJE_REDUCCION_PRONTO_PAGO";
	public static final String PORCENTAJE_REDUCCION_RECONOCIMIENTO = "PORCENTAJE_REDUCCION_RECONOCIMIENTO";

	public static final String NOMBRE_PLANTILLA_ARBITRAJE_AUDIENCIAS_RTF = "arb_audiencias.rtf";
	public static final String NOMBRE_PLANTILLA_ARBITRAJE_AUDIENCIAS_XML = "arb_audiencias.xml";

	public static final String NOMBRE_PLANTILLA_ARBITRAJE_PRUEBAS_RTF = "arb_pruebas.rtf";
	public static final String NOMBRE_PLANTILLA_ARBITRAJE_PRUEBAS_XML = "arb_pruebas.xml";

	public static final String MODOTRAMITES_TRAMITE_K91 = "modoARBApertura";
	public static final String MODOTRAMITES_TRAMITE_K91_idTramite = "tramiteARBApertura";

	public static final String MODOTRAMITES_TRAMITE_K52 = "modoARBAsignacionResponsable";
	public static final String MODOTRAMITES_TRAMITE_K52_idTramite = "tramiteARBAsignacionResponsable";

	public static final String MODOTRAMITES_TRAMITE_K53 = "modoARBSubsanacion";
	public static final String MODOTRAMITES_TRAMITE_K53_idTramite = "tramiteARBSubsanacion";

	public static final String MODOTRAMITES_TRAMITE_K54 = "modoARBRecepcionSubsanacion";
	public static final String MODOTRAMITES_TRAMITE_K54_idTramite = "tramiteARBRecepcionSubsanacion";

	public static final String MODOTRAMITES_TRAMITE_K55 = "modoARBAnalisisEmpresa";
	public static final String MODOTRAMITES_TRAMITE_K55_idTramite = "tramiteARBAnalisisEmpresa";

	public static final String MODOTRAMITES_TRAMITE_K56 = "modoARBResultadoAnalisisAdheridaLim";
	public static final String MODOTRAMITES_TRAMITE_K56_idTramite = "tramiteARBResultadoAnalisisAdheridaLim";

	public static final String MODOTRAMITES_TRAMITE_K57 = "modoARBResultadoAnalisisNoAdherida";
	public static final String MODOTRAMITES_TRAMITE_K57_idTramite = "tramiteARBResultadoAnalisisNoAdherida";

	public static final String MODOTRAMITES_TRAMITE_K58 = "modoARBAceptacionArbitraje";
	public static final String MODOTRAMITES_TRAMITE_K58_idTramite = "tramiteARBAceptacionArbitraje";

	public static final String MODOTRAMITES_TRAMITE_K59 = "modoARBConvenioArbitral";
	public static final String MODOTRAMITES_TRAMITE_K59_idTramite = "tramiteARBConvenioArbitral";

	public static final String MODOTRAMITES_TRAMITE_K60 = "modoARBDesignacionColegio";
	public static final String MODOTRAMITES_TRAMITE_K60_idTramite = "tramiteARBDesignacionColegio";

	public static final String MODOTRAMITES_TRAMITE_K61 = "modoARBCitacionAudiencia";
	public static final String MODOTRAMITES_TRAMITE_K61_idTramite = "tramiteARBCitacionAudiencia";

	public static final String MODOTRAMITES_TRAMITE_K62 = "modoARBSuspensionAudiencia";
	public static final String MODOTRAMITES_TRAMITE_K62_idTramite = "tramiteARBSuspensionAudiencia";

	public static final String MODOTRAMITES_TRAMITE_K63 = "modoARBAudiencia";
	public static final String MODOTRAMITES_TRAMITE_K63_idTramite = "tramiteARBAudiencia";

	public static final String MODOTRAMITES_TRAMITE_K64 = "modoARBCitacionAPrueba";
	public static final String MODOTRAMITES_TRAMITE_K64_idTramite = "tramiteARBCitacionAPrueba";

	public static final String MODOTRAMITES_TRAMITE_K65 = "modoARBRecepcionInformePericial";
	public static final String MODOTRAMITES_TRAMITE_K65_idTramite = "tramiteARBRecepcionInformePericial";

	public static final String MODOTRAMITES_TRAMITE_K66 = "modoARBPagoPericial";
	public static final String MODOTRAMITES_TRAMITE_K66_idTramite = "tramiteARBPagoPericial";

	public static final String MODOTRAMITES_TRAMITE_K67 = "modoARBCitacion2Audiencia";
	public static final String MODOTRAMITES_TRAMITE_K67_idTramite = "tramiteARBCitacion2Audiencia";

	public static final String MODOTRAMITES_TRAMITE_K68 = "modoARB2Audiencia";
	public static final String MODOTRAMITES_TRAMITE_K68_idTramite = "tramiteARB2Audiencia";

	public static final String MODOTRAMITES_TRAMITE_K69 = "modoARBResolucion";
	public static final String MODOTRAMITES_TRAMITE_K69_idTramite = "tramiteARBResolucion";

	public static final String MODOTRAMITES_TRAMITE_K70 = "modoARBLaudo";
	public static final String MODOTRAMITES_TRAMITE_K70_idTramite = "tramiteARBLaudo";

	public static final String MODOTRAMITES_TRAMITE_K71 = "modoARBPagoLaudo";
	public static final String MODOTRAMITES_TRAMITE_K71_idTramite = "tramiteARBPagoLaudo";

	public static final String MODOTRAMITES_TRAMITE_K72 = "modoARBRecepcionSolicitudAclaracion";
	public static final String MODOTRAMITES_TRAMITE_K72_idTramite = "tramiteARBRecepcionSolicitudAclaracion";

	public static final String MODOTRAMITES_TRAMITE_K73 = "modoARBAclaracion";
	public static final String MODOTRAMITES_TRAMITE_K73_idTramite = "tramiteARBAclaracion";

	public static final String MODOTRAMITES_TRAMITE_K74 = "modoARBPropuestaSancionador";
	public static final String MODOTRAMITES_TRAMITE_K74_idTramite = "tramiteARBPropuestaSancionador";

	public static final String MODOTRAMITES_TRAMITE_K75 = "modoARBRecepcionSolicitudCopiaExpe";
	public static final String MODOTRAMITES_TRAMITE_K75_idTramite = "tramiteARBRecepcionSolicitudCopiaExpe";

	public static final String MODOTRAMITES_TRAMITE_K83 = "modoARBMediacion";
	public static final String MODOTRAMITES_TRAMITE_K83_idTramite = "tramiteARBMediacion";

	public static final String MODOTRAMITES_TRAMITE_K85 = "modoARBRecepcionAlegaciones";
	public static final String MODOTRAMITES_TRAMITE_K85_idTramite = "tramiteARBRecepcionAlegaciones";

	public static final String MODOTRAMITES_TRAMITE_K86 = "modoARBResultadoAnalisisAdherida";
	public static final String MODOTRAMITES_TRAMITE_K86_idTramite = "tramiteARBResultadoAnalisisAdherida";

	public static final String MODOTRAMITES_TRAMITE_K87 = "modoARBResultadoAnalisisNoAdheridaContrato";
	public static final String MODOTRAMITES_TRAMITE_K87_idTramite = "tramiteARBResultadoAnalisisNoAdheridaContrato";

	public static final String MODOTRAMITES_TRAMITE_K118 = "modoARBComunicaArbitros";
	public static final String MODOTRAMITES_TRAMITE_K118_idTramite = "tramiteARBComunicaArbitros";

	public static final String MODOTRAMITES_TRAMITE_K119 = "modoARBPagoPericialColegio";
	public static final String MODOTRAMITES_TRAMITE_K119_idTramite = "tramiteARBPagoPericialColegio";

	/**
	 * Documentos arbiraje
	 */
	public static final String TIPO_DOC_ARB_SUBSANACION = "1";
	public static final String TIPO_DOC_ARB_RESULTADO_ANALISIS_ADHERIDA = "2";
	public static final String TIPO_DOC_ARB_RESULTADO_ANALISIS_ADHERIDA_LIM = "2";
	public static final String TIPO_DOC_ARB_RESULTADO_ANALISIS_NO_ADHERIDA = "2";
	public static final String TIPO_DOC_ARB_RESULTADO_ANALISIS_NO_ADHERIDA_CONTRATO = "2";
	public static final String TIPO_DOC_ARB_CONVENIO_ARBITRAL = "20";
	public static final String TIPO_DOC_ARB_DESIGNACION_COLEGIO = "5";
	public static final String TIPO_DOC_ARB_CITACION_AUDIENCIA = "6";
	public static final String TIPO_DOC_ARB_SUSPENSION_AUDIENCIA = "7";
	public static final String TIPO_DOC_ARB_CITACION_A_PRUEBA = "8";
	public static final String TIPO_DOC_ARB_PAGO_PERICIAL = "9";
	public static final String TIPO_DOC_ARB_CITACION_2AUDIENCIA = "10";
	public static final String TIPO_DOC_ARB_RESOLUCION = "11";
	public static final String TIPO_DOC_ARB_LAUDO = "12";
	public static final String TIPO_DOC_ARB_PAGO_LAUDO = "13";
	public static final String TIPO_DOC_ARB_ACLARACION = "14";
	public static final String TIPO_DOC_ARB_OTROS = "16";
	public static final String TIPO_DOC_ARB_NOTIFICACION = "17";
	public static final String TIPO_DOC_ARB_ACUSE = "18";
	public static final String TIPO_DOC_ARB_PAGO_PERICIAL_COLEGIO = "19";

	// Entrada
	public static final String TIPO_DOC_ARB_RECEPCION_SOLICITUD_COPIA_EXPE = "15";
	public static final String TIPO_DOC_ARB_SOLICITUD_ACLARACION = "21";
	public static final String TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA = "3";
	public static final String TIPO_DOC_ARB_ACEPTACION_ARBITRAJE = "4";
	public static final String TIPO_DOC_ARB_INFORME_PERICIAL = "19";
	public static final String TIPO_DOC_ARB_APORTACIONDOCUMENTACION = "22";
	public static final String TIPO_DOC_ARB_RECEPCION_ACLARACION = "23";
	public static final String TIPO_DOC_ARB_ALEGACIONES = "24";
	public static final String TIPO_DOC_ARB_SOLICITUD = "25";
	public static final String TIPO_DOC_ARB_ACREDITACION_REPRESENTACION = "32";
	// 0150948 2.1
	public static final String TIPO_DOC_ARB_RECHAZO_ARBITRAJE = "41";
	// 0150948 2.1
	public static final String ORIGEN_ARB_APORTADO_RECLAMANTE = "CO";
	public static final String ORIGEN_ARB_APORTADO_RECLAMANTE2 = "C";
	public static final String ORIGEN_ARB_APORTADO_RECLAMADO = "ES";
	public static final String ORIGEN_ARB_APORTADO_OTROS = "O";
	public static final String ORIGEN_ARB_APORTADO_ADMINISTRACION = "A";
	public static final String ORIGEN_ARB_APORTADO_ESTABLECIMIENTO = "F";
	public static final String ORIGEN_ARB_APORTADO_PERITO = "P";
	public static final String ORIGEN_ARB_APORTADO_ARBITRO = "B";
	public static final String ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO = "RE";
	public static final String ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE = "RC";
	/**
	 * Nombre Plantilla Tramite Arbitraje
	 */
	public static final String NOMBRE_PLANTILLA_XML_TRAMITE_ARB_CASTELLANO = "tramitearbitraje.xml";
	public static final String JUNTA_ARBITRAL_CONSUMO_EUSKADI = "01J001";

	public static final String ID_PROCEDIMIENTO_ARBITRAJE = "Y41B_ARBITRAJE";

	/**
	 * Notificacion o comunicacion al reclamante,reclamado,..
	 */
	public static final String NOTIFICACION = "N";
	public static final String COMUNICACION = "C";

	/**
	 * tipo de notificacion arbitraje
	 */
	public static final String TIPO_NOTIFICACION_ARBITRAJE_SUBSANACION = "REQ_SUB";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_RESULTADO_ANALISIS = "OTROS";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_ALEGACIONES = "RESPALEGACIONES";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_CITACION_AUDIENCIA = "AUDIENCIA";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_CITACION_2AUDIENCIA = "TRAMITEAUDIENCIA";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_RESOLUCION = "RESOL";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_CONVENIO_ARBITRAL = "CONVENIO";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_SUSPENSION_AUDIENCIA = "SUSPENSION_ACT_ADM";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_CITACION_A_PRUEBA = "PRUEBAS";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_LAUDO = "RESOLUCION_RECLAMACION";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_ACLARACION = "RESOL_COMP";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_INFORME_PERICIAL = "EMI_INFORME";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_PAGO_PERICIAL = "REQUERIMIENTO";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION = "SOLICITUDINFORM";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO_ACREDITACION = "REQ_ACREDITA";
	public static final String TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO = "REQUERIMIENTO";

	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.5
	public static final String TIPO_NOTIFICACION_ARBITRAJE_COPIA_COMPULSADA = "NOT_INFORM";

	/**
	 * AVISOS ARBITRAJE
	 */
	public static final String TIPO_AVISO_ARBITRAJE_CONVENIO = "TIPO_AVISO_ARBITRAJE_CONVENIO";
	public static final String TIPO_AVISO_ARBITRAJE_REQ_SUBSANACION = "TIPO_AVISO_ARBITRAJE_REQ_SUBSANACION";
	public static final String TIPO_AVISO_ARBITRAJE_LAUDO_RESO = "TIPO_AVISO_ARBITRAJE_LAUDO_RESO";
	public static final String TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE = "TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE";
	public static final String TIPO_AVISO_ARBITRAJE_ACLARACION = "TIPO_AVISO_ARBITRAJE_ACLARACION";
	public static final String TIPO_AVISO_ARBITRAJE_ALEGACIONES = "TIPO_AVISO_ARBITRAJE_ALEGACIONES";
	public static final String TIPO_AVISO_ARBITRAJE_NULIDAD = "TIPO_AVISO_ARBITRAJE_NULIDAD";
	public static final String TIPO_AVISO_ARBITRAJE_ADMISION = "TIPO_AVISO_ARBITRAJE_ADMISION";

	public static final int TIPO_AVISO_ARBITRAJE_NUMERODIASANTES = 5;

	public static final String VALOR_RESPUESTA_SUBSANA = "S";
	public static final String VALOR_RESPUESTA_NOSUBSANA = "N";
	public static final String VALOR_RESPUESTA_SUBSANAPARCIAL = "P";

	public static final String DECISION_ARBITRAJE_INADMISION = "AR1";
	public static final String DECISION_ARBITRAJE_TRASLADO = "AR2";
	public static final String DECISION_ARBITRAJE_DESISTIMIENTO = "AR3";
	public static final String DECISION_ARBITRAJE_ACUERDO = "AR4";
	public static final String DECISION_ARBITRAJE_ACUMULACION = "AR5";
	public static final String DECISION_ARBITRAJE_NOLOCALIZADO = "AR6";
	public static final String DECISION_ARBITRAJE_LAUDO = "AR7";
	public static final String DECISION_ARBITRAJE_CADUCIDAD = "AR8";
	public static final String DECISION_ARBITRAJE_NOACEPTACION = "AR9";
	public static final String DECISION_ARBITRAJE_NOSUBSANA = "AR10";
	public static final String DECISION_ARBITRAJE_ERROR = "AR11";

	public static final String ARB_ESTADO_ENVIO_NO_ENTREGADO = "N";
	public static final String ARB_ESTADO_ENVIO_ENVIADO = "E";
	public static final String ARB_ESTADO_ENVIO_ERROR = "X";
	public static final String ARB_ESTADO_ENVIO_RECOGIDO = "R";

	public static final String TIPO_DOCUMENTO_ARBITRAJE_ENTRADA = "E";
	public static final String TIPO_DOCUMENTO_ARBITRAJE_SALIDA = "S";

	/** Tipo documental platea */
	public static final String TIPO_DOC_ARB_COMUNICACION = "27";

	public static final String RESULTADO_ANALISIS_EMPRESA_A = "A";
	public static final String RESULTADO_ANALISIS_EMPRESA_B = "B";
	public static final String RESULTADO_ANALISIS_EMPRESA_C = "C";
	public static final String RESULTADO_ANALISIS_EMPRESA_D = "D";

	// public static final String ID_PROCEDIMIENTO_ADHALTA = "ADHALTA";
	public static final String ID_PROCEDIMIENTO_ADHALTA = "Y41B_ALTA_ADHESION";
	public static final String ID_PROCEDIMIENTO_ADHMODIF = "Y41B_MOD_ADHESION";
	public static final String ID_PROCEDIMIENTO_ADHBAJA = "Y41B_BAJA_ADHESION";

	public static final String ID_ORGANISMO_SOLICITUD_ADH = "01J001";
	public static final String ID_ESTADO_SOL_ADH_PENDIENTE = "P";

	public static final String ADH_TIPO_ALTA = "A";
	public static final String ADH_TIPO_BAJA = "B";
	public static final String ADH_TIPO_BAJA_OFICIO = "O";
	public static final String ADH_TIPO_MODIF = "M";

	public static final String TRAMITE_ADHESION_COMUNICACION_MOD = "K88";
	public static final String TRAMITE_ADHESION_COMUNICACION_BAJA = "K89";
	public static final String TRAMITE_ADHESION_COMUNICACION_ALTA = "K90";
	public static final String ESTADO_ARBADHSOL_PENDIENTE = "P";
	public static final String ESTADO_ARBADHSOL_ACEPTADA = "A";
	public static final String ESTADO_ARBADHSOL_RECHAZADA = "X";

	public static final String TIPO_ARB_EXPREL_ORIGEN = "S";
	public static final String TIPO_ARB_EXPREL_ACUMULADO = "A";
	public static final String TIPO_ARB_EXPREL_OTROS = "N";

	public static final String DECISION_ARB_2AUDIENCIA_PRUEBA = "1";
	public static final String DECISION_ARB_NO2AUDIENCIA_TRASPERICIAL = "2";
	public static final String DECISION_ARB_LAUDO = "3";
	public static final String DECISION_ARB_2AUDIENCIA = "4";

	public static final String TIPO_ARBINSTANCIA_RECLAMANTE = "1";
	public static final String TIPO_ARBINSTANCIA_RECLAMADO = "2";
	public static final String TIPO_ARBINSTANCIA_AMBOS = "3";
	public static final String TIPO_ARBINSTANCIA_OFICIO = "4";

	public static final String TIPOPRES_ARB_ORDINARIA = "O";
	public static final String TIPOPRES_ARB_ODR = "E";

	public static final int MENOS_DOS = -2;

	public static final String PRESENTADOPOR_ARB_PARTICULAR = "P";

	public static final String ARB_TIPO_ALEGACION_RECONVENCION = "R";
	public static final String ARB_TIPO_ALEGACION_PRETENSION = "P";

	public static final String ARB_LAUDO_RDO_ESTIMADO = "E";
	public static final String ARB_LAUDO_RDO_DESESTIMADO = "D";
	public static final String ARB_LAUDO_RDO_PARCIAL = "P";

	public static final String ARB_PRUEBA_REALIZADOPOR_PERITO = "P";
	public static final String ARB_PRUEBA_REALIZADOPOR_COLEGIO = "C";

	public static final String ACTIVAR_ARBITRAJE = "ACTIVAR_ARBITRAJE";
	public static final String ACTIVAR_PAGO_PERICIAL_COLEGIO = "ACTIVAR_PAGO_PERICIAL_COLEGIO";
	public static final String ACTIVAR_ADHESIONES = "ACTIVAR_ADHESIONES";
	public static final String ACTIVAR_CONTROLMERCADO = "ACTIVAR_CONTROLMERCADO";
	public static final String ACTIVAR_INSPECCIONES = "ACTIVAR_INSPECCIONES";

	public static final String TRAMITE_ADHESION_APERTURA_MOD = "K112";
	public static final String TRAMITE_ADHESION_APERTURA_BAJA = "K92";
	public static final String TRAMITE_ADHESION_APERTURA_ALTA = "K93";
	public static final String TRAMITE_ADHESION_CIERRE_MOD = "K94";
	public static final String TRAMITE_ADHESION_CIERRE_BAJA = "K95";
	public static final String TRAMITE_ADHESION_CIERRE_ALTA = "K96";
	public static final String TRAMITE_ADHESION_NOTIFICACION_MOD = "K97";
	public static final String TRAMITE_ADHESION_NOTIFICACION_BAJA = "K98";
	public static final String TRAMITE_ADHESION_NOTIFICACION_ALTA = "K99";
	public static final String TRAMITE_ADHESION_ACUSE_MOD = "K100";
	public static final String TRAMITE_ADHESION_ACUSE_BAJA = "K101";
	public static final String TRAMITE_ADHESION_ACUSE_ALTA = "K102";
	public static final String TRAMITE_ADHESION_APORTAR_MOD = "K103";
	public static final String TRAMITE_ADHESION_APORTAR_BAJA = "K104";
	public static final String TRAMITE_ADHESION_APORTAR_ALTA = "K105";
	public static final String TRAMITE_ADHESION_RESOLUCION_MOD = "K106";
	public static final String TRAMITE_ADHESION_RESOLUCION_BAJA = "K107";
	public static final String TRAMITE_ADHESION_RESOLUCION_ALTA = "K108";
	public static final String TRAMITE_ADHESION_GENERICO_MOD = "K109";
	public static final String TRAMITE_ADHESION_GENERICO_BAJA = "K110";
	public static final String TRAMITE_ADHESION_GENERICO_ALTA = "K111";

	public static final String ORIGEN_ADH_APORTADO_ESTABLECIMIENTO = "E";// ESTABLECIMIENTO
	public static final String ORIGEN_ADH_APORTADO_OTROS = "O";
	public static final String TIPO_DOC_ADH_ALTA_APORTACIONDOCUMENTACION = "29";
	public static final String TIPO_DOC_ADH_BAJA_APORTACIONDOCUMENTACION = "28";
	public static final String TIPO_DOC_ADH_MOD_APORTACIONDOCUMENTACION = "30";
	public static final String TIPO_DOC_ADH_ALTA_ACUSE_RECIBO = "38";
	public static final String TIPO_DOC_ADH_BAJA_ACUSE_RECIBO = "39";
	public static final String TIPO_DOC_ADH_MOD_ACUSE_RECIBO = "40";

	public static final String[] DECISIONES_ARBITRAJE_NO_ADMITIDAS = { "ARAV",
			Y41bConstantes.DECISION_AVENENCIA_RECLAMACION,
			Y41bConstantes.DECISION_INADMISION_ARREPENTIM_COMPRA_RECLAMACION,
			Y41bConstantes.DECISION_INADMISION_DANOS_RECLAMACION,
			Y41bConstantes.DECISION_INADMISION_NO_CONSUMO_RECLAMACION,
			Y41bConstantes.DECISION_INADMISION_NO_GARANTIA_RECLAMACION,
			Y41bConstantes.DECISION_INADMISION_OPCION_REPARACION_RECLAMACION, Y41bConstantes.DECISION_INADMISION_TIQUE,
			Y41bConstantes.DECISION_INADMISION_RECLAMACION_DUPLICADA, Y41bConstantes.DECISION_INADMISION_GENERAL, "TR",
			Y41bConstantes.DECISION_TRASLADO_RECLAMACION, "IH", Y41bConstantes.DECISION_INHIBICION_AESA_RECLAMACION,
			Y41bConstantes.DECISION_INHIBICION_OTROS_RECLAMACION,
			Y41bConstantes.DECISION_INHIBICION_SEGUROS_RECLAMACION,
			Y41bConstantes.DECISION_INHIBICION_TRANSPORTE_RECLAMACION, Y41bConstantes.DECISION_INHIBICION_BANCA,
			Y41bConstantes.DECISION_SINDECISION, "ARNI" };

	/* TIPOS CAMPAAS */
	public static final String CAMPANA_TIPO_CONTROLPRODUCTO = "CP";
	public static final String CAMPANA_TIPO_MUESTRAS = "MU";
	public static final String CAMPANA_TIPO_MIXTAS = "MX";

	/* ORIGENES CAMPAAS */
	public static final String CAMPANA_ORIGEN_ESTATAL = "ESTATAL";
	public static final String CAMPANA_ORIGEN_KONTSUMOBIDE = "KONTSUMOBIDE";
	public static final String CAMPANA_ORIGEN_UE = "UE";

	/* ORIGEN ALERTAS */
	public static final String ORIGEN_ALERTA_CE = "CE";
	public static final String ORIGEN_ALERTA_CCAA = "CCAA";
	public static final String ORIGEN_ALERTA_INC = "INC";

	public static final String EMISOR_ALERTA_INC = "AECOSAN";

	/* ORIGEN PRODUCTO ALERTA */
	public static final String ORIGEN_PRODUCTO_CCAA = "1";
	public static final String ORIGEN_PRODUCTO_PAIS = "2";

	public static final String NUM_ACTUALIZACION_ESTABLECIMIENTOS = "NUM_ACTUALIZACION_ESTABLECIMIENTOS";
	public static final String MESES_ACTUALIZACION_ESTABLECIMIENTOS = "MESES_ACTUALIZACION_ESTABLECIMIENTOS";

	public static final String NUM_MAILS_ICONO_WEB = "NUM_MAILS_ICONO_WEB";
	public static final String MESES_MAILS_ICONO_WEB = "MESES_MAILS_ICONO_WEB";

	/* TIPO INSPECCION */
	public static final String TIPO_INSPECCION_TOMA_MUESTRAS = "TM";
	public static final String TIPO_INSPECCION_CONTROL_ESTANDAR = "CE";
	public static final String TIPO_INSPECCION_CONTROL_OTROS = "CO";

	public static final String FASE_INSPECCIONES = "35";

	/* ACCESO A SOLICITUDES */
	public static final String SOLICITUDES_ACCESO_DESDE_SOLICITUD = "S";
	public static final String SOLICITUDES_ACCESO_DESDE_EMPRESA = "E";
	public static final String SOLICITUDES_ACCESO_DESDE_TODOS = "T";

	/* ACCESO A CONSULTAS */
	public static final String CONSULTAS_ACCESO_DESDE_CONSULTAS = "S";
	public static final String CONSULTAS_ACCESO_DESDE_EMPRESA = "E";
	public static final String CONSULTAS_ACCESO_DESDE_TODOS = "T";

	/* TIPO DENUNCIANTE EN SOLICITUDES Y DENUNCIAS AACC */
	public static final String SOLICITUDES_TIPO_DENUNCIA_AACC = "A";
	public static final String SOLICITUDES_TIPO_DENUNCIA_OOEE = "O";
	public static final String SOLICITUDES_TIPO_DENUNCIA_EMPRESAS = "E";
	public static final String SOLICITUDES_TIPO_DENUNCIA_OTRAS = "X";

	public static final String TIPO_RECURSO_ALZADA = "A";

	/* DESTINATARIO NOTIFICACION TITULAR/REPRESENTANTE */
	public static final String SOLICITUDES_NOTIFICACION_REPRESENTANTE = "R";
	public static final String SOLICITUDES_NOTIFICACION_TITULAR = "T";

	/* FORMULARIO DE RECLAMACION TOOLKIT */
	public static final String RECLAMACION_TOOLKIT_TIPODENUNCIA_SOLICITUD = "1";
	public static final String RECLAMACION_TOOLKIT_TIPODENUNCIA_EMPRESA = "2";
	public static final String RECLAMACION_TOOLKIT_ESEXTRANJERO_NO = "1";
	public static final String RECLAMACION_TOOLKIT_ESEXTRANJERO_SI = "2";
	public static final String RECLAMACION_TOOLKIT_ESEXTRANJERO_OTROSDATOS = "3";
	public static final String RECLAMACION_TOOLKIT_CANALNOTIFICACION_EMAIL = "1";
	public static final String RECLAMACION_TOOLKIT_CANALNOTIFICACION_TELEFONO = "2";
	public static final String RECLAMACION_TOOLKIT_TIPODOCUMENTAL_FORMULARIO = "ejgv_d_solicitud.0.0";

	/* FORMULARIO DE ARBITRAJE TOOLKIT */
	public static final String ARBITRAJE_TOOLKIT_CANALNOTIFICACION_EMAIL = "1";
	public static final String ARBITRAJE_TOOLKIT_CANALNOTIFICACION_TELEFONO = "2";
	public static final String ARBITRAJE_TOOLKIT_TIPODOCUMENTAL_FORMULARIO = "ejgv_d_solicitud.0.0";
	public static final String ARBITRAJE_TOOLKIT_ESEXTRANJERO_SI = "2";

	/* ACTAS NUEVAS DE UNA INSPECCION: TIPOS */
	public static final String ACTA_NUEVA_TIPO_DESINMOVILIZACION = "F";
	public static final String ACTA_NUEVA_TIPO_DESTRUCCION = "D";
	public static final String ACTA_NUEVA_TIPO_DEVOLUCION_A_ORIGEN = "O";
	public static final String ACTA_NUEVA_TIPO_INFRACCION = "I";
	public static final String ACTA_NUEVA_TIPO_INMOVILIZACION_CAUTELAR = "C";
	public static final String ACTA_NUEVA_TIPO_LIBRE_COMERCIALIZACION = "L";
	public static final String ACTA_NUEVA_TIPO_RATIFICACION = "A";
	public static final String ACTA_NUEVA_TIPO_REQUERIMIENTO = "R";
	public static final String ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS = "T";
	public static final String ACTA_NUEVA_TIPO_COMPROBACION_SOIVRE = "S";

	/* ACTAS NUEVAS DE UNA INSPECCION: LUGARES DE INMOVILIZACION */
	public static final String ACTA_NUEVA_LUGAR_INMOVILIZACION_INSITU = "I";

	/*
	 * TIPOS DE ORIGEN DE UNA INSPECCION: COMUNICACION EXTERNA O NOTIFICACION DE
	 * PRODUCTORES
	 */
	public static final String INSPECCION_ORIGEN_COMUNICACION_EXTERNA = "C";
	public static final String INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES = "N";

	public static final String INSPECCION_PARAMETRO_COD_ORGANISMO_AECOSAN = "COD_ORGANISMO_AECOSAN";

	public static final String TIPO_RELACION_ORIGEN = "S";
	public static final String TIPO_RELACION_ACUMULADO = "A";

	public static final String NOMBRE_DOCUMENTO_SOLICITUD_DATOS_AVISO_ES = "datos de aviso.html";
	public static final String NOMBRE_DOCUMENTO_SOLICITUD_DATOS_AVISO_EU = "ohar-datuak.html";

	public static final String NOMBRE_DOCUMENTO_SOLICITUD_DATOS_NOTIFICACION_ES = "datos de notificacin.html";
	public static final String NOMBRE_DOCUMENTO_SOLICITUD_DATOS_NOTIFICACION_EU = "jakinarazpen-datuak.html";

	/* PARAMETRO PLAZO ALEGACIONES DE IN ACUERDO INICIO PROCEDIMIENTO */
	public static final String INSPECCIONES_PLAZO_ALEGACIONES = "INSPECCIONES_PLAZO_ALEGACIONES";
	public static final String INSPECCIONES_PLAZO_RECURSO = "INSPECCIONES_PLAZO_RECURSO";

	/* ORIGENES DE UNA INSPECCION EN BANDEJA */
	public static final String INSPECCIONES_ORIGEN_CAMPANHA = "C";
	public static final String INSPECCIONES_ORIGEN_ALERTA = "A";
	public static final String INSPECCIONES_ORIGEN_SOIVRE = "S";
	public static final String INSPECCIONES_ORIGEN_DENUNCIA = "D";
	public static final String INSPECCIONES_ORIGEN_SOLICITUD = "E";
	public static final String INSPECCIONES_ORIGEN_OFICIO = "O";
	public static final String INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES = "N";
	public static final String INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA = "X";

	/* NUMERO EXPEDIENTE ANTES DE ASIGNAR */
	public static final String INSPECCIONES_NUM_EXPEDIENTE_INICIAL = "XXXX";

	/* CARACTER MUESTRA */
	public static final String INSPECCIONES_CARACTERMUESTRA_RECLAMENTARIA = "R";
	public static final String INSPECCIONES_CARACTERMUESTRA_INDICATIVA = "I";
	public static final String INSPECCIONES_CARACTERMUESTRA_OTROS = "O";

	public static final String ESTADO_ACTA_REINICIADA = "X";

	public static final String PREFIFO_ACTA_ELIMINADAMICARPETA = "ERR";

	// EVOLUTIVO 0134898 2.10
	public static final String BUSQUEDA_ARBITRAJE_EXISTE_TRAMITE = "E";
	public static final String BUSQUEDA_ARBITRAJE_ULTIMO_TRAMITE = "U";
	public static final String BUSQUEDA_ARBITRAJE_ACTUAL_TRAMITE = "A";

	// EVOLUTIVO 0134898 2.10

	/**
	 * Los valores recibidos desde el toolkit para los contactos
	 * 
	 *  
	 * 
	 */
	public static final class CONTACT_TOOLKIT {
		public static final String EMAIL = "EMAIL";
		public static final String SMS = "SMS";

		/**
		 * Metodo constructor.
		 */
		private CONTACT_TOOLKIT() {
			super();
		}
	}

	// METADATOS DOKUSI
	public static final String METADATO_CODIGO_VERIFICACION = "ejgv_codigo_verificacion";
	public static final String METADATO_ORIGEN = "ejgv_origen";
	public static final String METADATO_PROCEDIMIENTO_INFRAESTRUCTURA = "ejgv_proc_infraestructura";

	// Caracter campanha
	public static final String CAMPANHA_CARACTER_PROSPECTIVA = "P";
	public static final String CAMPANHA_CARACTER_INFORMATIVA = "I";

	// parametro cuenta bancaria
	public static final String CUENTA_BANCARIA = "CUENTA_BANCARIA";

	// portafirmas arbitro
	public static final Boolean PORTAFIRMAS_ARBITROS_HABILITADO = true;

	public static final String EXCEL_CARGATRABAJO = "cargaTrabajo";

	public static final String PLATEA_LITERAL_GENERAL = "error.platea.invocation";

	// Acciones telematicas
	public static final String ACCION_TELEMATICA_SOLICITUD = "PRESENTACION DE SOLICITUD";

	public static final String ACCION_TELEMATICA_NOTIFICACION = "R02_NOTIFICATION";

	public static final String ACCION_TELEMATICA_APORTACION = "APORTACION DE DOCUMENTOS";

	public static final String LITERAL_NOT_IMPLEMENT = "error.notimplement";
	public static final String LITERAL_GENERAL = "error.invocation";

	/**
	 * LITERAL PROCEDIMIENTOS
	 */
	public static final String PROCEDURE_LITERAL_NOEXISTE = "error.procedure.noexiste";
	public static final String PROCEDURE_LITERAL_NODESARROLLADO = "error.procedure.nodesarrollado";
	// MENSAJES DE ERROR
	public static final String ERROR_PROCEDURE_NOEXISTE = "No existe el tipo de procedimiento";
	public static final String ERROR_PROCEDURE_NODESARROLLADO = "No desarrollado el tipo de procedimiento para ese codigo de aplicacion";

	// notificacion (acuse)
	public static final String MANAGE_NOTIFICATION_EXPIRATION = "MANAGE_NOTIFICATION_EXPIRATION";
	public static final String PUBLISH_NOTIFICATION_DELIVERY = "PUBLISH_NOTIFICATION_DELIVERY";

	/**
	 * Identificativos de los procedimientos de PLATEA
	 */
	public static final String COD_PROCEDIMIENTO_SOLICITUDES = "00037"; // Y41B_RECLAMACION
	public static final String COD_PROCEDIMIENTO_SANCIONES = "01545"; // Y41B_SANCIONES
	public static final String COD_PROCEDIMIENTO_INSPECCIONES = "10596"; // Y41B_INSPECCIONES
	public static final String COD_PROCEDIMIENTO_ARBITRAJE = "01380"; // Y41B_ARBITRAJE
	public static final String COD_PROCEDIMIENTO_ADHALTA = "01541";// Y41B_ALTA_ADHESION
	public static final String COD_PROCEDIMIENTO_ADHMODIF = "01541";// Y41B_MOD_ADHESION
	public static final String COD_PROCEDIMIENTO_ADHBAJA = "01541";// Y41B_BAJA_ADHESION

	// texto SIR
	public static final String TEXTO_SIR = "SIR";

	/**
	 * EIKA
	 */
	public static final String EIKA_RESULTADO_CORRECTO = "000";
	public static final String EIKA_SITUACION_APROBADO = "Aprobado";
	public static final String EIKA_ESTADO_OPERATIVO = "OPERATIVO";
	public static final String EIKA_TIPO_ID_ES1 = "ES1";

	// Mail aportacion expediente cerrado
	public static final String PARAMETRO_GENERAL_FROMGENERICO = "GENERAL_FROMGENERICO_EMAIL";

	// VIA APREMIO-EXCLUIR,INCLUIR
	public static final String NOMBRE_TRAMITE_GENERICO_EXCLUIR = "Via de apremio excluida";
	public static final String NOMBRE_TRAMITE_GENERICO_INCLUIR = "Via de apremio incluida";

	// aaccEuskadi
	public static final String TIPO_ORG_ASOCIACION = "A";
	public static final String TIPO_ORG_COOPERATIVA = "C";
	public static final String TIPO_ORG_FEDERACION = "F";
	public static final String TIPO_ORG_CONFEDERACION = "D";

	public static final String CARGO_RESPONSABLE_REGISTRO = "RESPONSABLE DEL REGISTRO";
	public static final String CENSO_AACC_EUSKADI = "AaccEuskadi";

	public static final String CODORG_PERMITIDO = "01A107";

	/**
	 * Plantillas Word Justificante Levantamiento Acta
	 */
	public static final String NOMBRE_PLANTILLA_PUBLICACION_LEVANTAMIENTO_RTF = "levantamientodocument.rtf";

	public static final String NOMBRE_PLANTILLA_PUBLICACION_LEVANTAMIENTO_XML = "levantamientodocument.xml";

	public static final String TIPO_DOC_PROTOCOLO = "ejgv_d_protocolo";

	// UnitCode y Sender para wsNewSIROutputRegister en desarrollo
	public static final String UNIDAD_ORGANICA_DESARROLLO = "2259";

	// PersonName para wsNewSIROutputRegister
	public static final String PERSON_NAME_SIR = "KONTSUMOBIDE";

}
