package com.ejie.y41b.constantes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Fichero de constantes para la generacion de fichero ADO
 * 
 *  
 */
public class Y41bADOConstantes {

	/**
	 * Constructor privado
	 */
	private Y41bADOConstantes() {
	};

	/** longitudes de campo **/

	public static final int LONG_ADO_TIPRGT_CABECERA = 1;
	public static final int LONG_ADO_CODINS = 5;
	public static final int LONG_ADO_EJER = 4;
	public static final int LONG_ADO_SECCION = 2;
	public static final int LONG_ADO_ORIMAQ = 3;
	public static final int LONG_ADO_CORREL = 3;
	public static final int LONG_ADO_USUARIO = 8;
	public static final int LONG_ADO_IDIOMA = 1;
	public static final int LONG_ADO_TIPRGT = 1;
	public static final int LONG_ADO_TIPDOC = 4;
	public static final int LONG_ADO_NUMXPE = 25;
	public static final int LONG_ADO_REFCOMICENCTR = 20;
	public static final int LONG_ADO_PARTIDAPRESU = 29;
	public static final int LONG_ADO_CTAPCP = 8;
	public static final int LONG_ADO_ELEMEN = 14;
	public static final int LONG_ADO_EJERREFINT = 4;
	public static final int LONG_ADO_ANOORIGREFINT = 4;
	public static final int LONG_ADO_NUMREFINT = 6;
	public static final int LONG_ADO_SUFDIS = 4;
	public static final int LONG_ADO_SUFOBL = 4;
	public static final int LONG_ADO_NUMORD = 4;
	public static final int LONG_ADO_COPPRY = 10;
	public static final int LONG_ADO_NUMFAC = 10;
	public static final int LONG_ADO_FECFAC = 8;
	public static final int LONG_ADO_CONRME = 80;
	public static final int LONG_ADO_CONRME_PAGPERCOLEGIO = 80;
	public static final int LONG_ADO_CODDTIPCNTR = 2;
	public static final int LONG_ADO_TIPTER = 1;
	public static final int LONG_ADO_CODTER = 10;
	public static final int LONG_ADO_VERTER = 2;
	public static final int LONG_ADO_IMPORTE = 13;
	public static final int LONG_ADO_IMPORTE_PAGPERCOLEGIO = 13;
	public static final int LONG_ADO_TIPOTRPEC = 1;
	public static final int LONG_ADO_CODOTRPEC = 10;
	public static final int LONG_ADO_VEROTRPEC = 2;
	public static final int LONG_ADO_FECVEN = 8;
	public static final int LONG_ADO_CODRETIVA = 3;
	public static final int LONG_ADO_IMPBASRET = 13;
	public static final int LONG_ADO_IMPBASRET_PAGPERCOLEGIO = 13;

	public static final int LONG_ADO_INDFORPAG = 1;
	public static final int LONG_ADO_CTAFIN = 10;
	public static final int LONG_ADO_EJERMAQTER = 4;
	public static final int LONG_ADO_NUMMAQTER = 6;
	public static final int LONG_ADO_EJERMAQOTRPEC = 4;
	public static final int LONG_ADO_NUMMAQOTRPEC = 6;

	public static final int LONG_ADO_FECINIPERPAG = 8;
	public static final int LONG_ADO_CODCNTR = 30;
	public static final int LONG_ADO_NUMRGTCPL = 10;
	public static final int LONG_ADO_FECRESOL = 8;

	public static final String NAME_ADO_TIPRGT_CABECERA = "ADO_TIPRGT_CABECERA";
	public static final String NAME_ADO_CODINS = "ADO_CODINS";
	public static final String NAME_ADO_EJER = "ADO_EJER";
	public static final String NAME_ADO_SECCION = "ADO_SECCION";
	public static final String NAME_ADO_ORIMAQ = "ADO_ORIMAQ";
	public static final String NAME_ADO_CORREL = "ADO_CORREL";
	public static final String NAME_ADO_USUARIO = "ADO_USUARIO";
	public static final String NAME_ADO_IDIOMA = "ADO_IDIOMA";
	public static final String NAME_ADO_TIPRGT = "ADO_TIPRGT";
	public static final String NAME_ADO_TIPDOC = "ADO_TIPDOC";
	public static final String NAME_ADO_NUMXPE = "ADO_NUMXPE";
	public static final String NAME_ADO_REFCOMICENCTR = "ADO_REFCOMICENCTR";
	public static final String NAME_ADO_PARTIDAPRESU = "ADO_PARTIDAPRESU";
	public static final String NAME_ADO_CTAPCP = "ADO_CTAPCP";
	public static final String NAME_ADO_ELEMEN = "ADO_ELEMEN";
	public static final String NAME_ADO_EJERREFINT = "ADO_EJERREFINT";
	public static final String NAME_ADO_ANOORIGREFINT = "ADO_ANOORIGREFINT";
	public static final String NAME_ADO_NUMREFINT = "ADO_NUMREFINT";
	public static final String NAME_ADO_SUFDIS = "ADO_SUFDIS";
	public static final String NAME_ADO_SUFOBL = "ADO_SUFOBL";
	public static final String NAME_ADO_NUMORD = "ADO_NUMORD";
	public static final String NAME_ADO_COPPRY = "ADO_COPPRY";
	public static final String NAME_ADO_NUMFAC = "ADO_NUMFAC";
	public static final String NAME_ADO_FECFAC = "ADO_FECFAC";
	public static final String NAME_ADO_CONRME = "ADO_CONRME";
	public static final String NAME_ADO_CODDTIPCNTR = "ADO_CODDTIPCNTR";
	public static final String NAME_ADO_TIPTER = "ADO_TIPTER";
	public static final String NAME_ADO_CODTER = "ADO_CODTER";
	public static final String NAME_ADO_VERTER = "ADO_VERTER";
	public static final String NAME_ADO_IMPORTE = "ADO_IMPORTE";
	public static final String NAME_ADO_TIPOTRPEC = "ADO_TIPOTRPEC";
	public static final String NAME_ADO_CODOTRPEC = "ADO_CODOTRPEC";
	public static final String NAME_ADO_VEROTRPEC = "ADO_VEROTRPEC";
	public static final String NAME_ADO_FECVEN = "ADO_FECVEN";
	public static final String NAME_ADO_CODRETIVA = "ADO_CODRETIVA";
	public static final String NAME_ADO_IMPBASRET = "ADO_IMPBASRET";

	// Datos del Pago Pericial Colegio
	public static final String NAME_ADO_IMPORTE_PAGPERCOLEGIO = "ADO_IMPORTE_PAGPERCOLEGIO";
	public static final String NAME_ADO_IMPBASRET_PAGPERCOLEGIO = "ADO_IMPBASRET_PAGPERCOLEGIO";
	public static final String NAME_ADO_CONRME_PAGPERCOLEGIO = "ADO_CONRME_PAGPERCOLEGIO";

	public static final String NAME_ADO_INDFORPAG = "ADO_INDFORPAG";
	public static final String NAME_ADO_CTAFIN = "ADO_CTAFIN";
	public static final String NAME_ADO_EJERMAQTER = "ADO_EJERMAQTER";
	public static final String NAME_ADO_NUMMAQTER = "ADO_NUMMAQTER";
	public static final String NAME_ADO_EJERMAQOTRPEC = "ADO_EJERMAQOTRPEC";
	public static final String NAME_ADO_NUMMAQOTRPEC = "ADO_NUMMAQOTRPEC";

	public static final String NAME_ADO_FECINIPERPAG = "ADO_FECINIPERPAG";
	public static final String NAME_ADO_CODCNTR = "ADO_CODCNTR";
	public static final String NAME_ADO_NUMRGTCPL = "ADO_NUMRGTCPL";
	public static final String NAME_ADO_FECRESOL = "ADO_FECRESOL";

	public static final String NAME_ADO_EMAIL = "ADO_EMAIL";

	public static final String NAME_ADO2_NUMEXP = "ADO2_NUMEXP";
	public static final String NAME_ADO2_FECLAUDO = "ADO2_FECLAUDO";
	public static final String NAME_ADO2_NOMBREARB = "ADO2_NOMBREARB";
	public static final String NAME_ADO2_NIFARB = "ADO2_NIFARB";

	public static final int LONG_ADO2_NUMEXP = 20;
	public static final int LONG_ADO2_FECLAUDO = 12;
	public static final int LONG_ADO2_NOMBREARB = 50;
	public static final int LONG_ADO2_NIFARB = 9;

	public static final String CRITERIO_FECHA_LAUDO = "LAU";
	public static final String CRITERIO_FECHA_AUDIENCIA = "AUD";

	public static final String TIPO_NUMBER = "NUMBER";
	public static final String TIPO_EMAIL = "EMAIL";

	public static final String CERO = "0";
	public static final String BLANCO = " ";
	public static final String IZQDA = "I";
	public static final String DCHA = "D";

	public static final String TITULO_CAB_RDO_NUMEXP = "NRO. EXPEDIENTE";
	public static final String TITULO_CAB_RDO_FECLAUDO = "F. LAUDO";
	public static final String TITULO_CAB_RDO_NOMBREARB = "NOMBRE ARBITRO";
	public static final String TITULO_CAB_RDO_NIFARB = "NIF ARBITRO";

	// EIKA
	public static final String NAME_ADO_EIKA_INDCONTDEF = "ADO_EIKA_INDCONTDEF";
	public static final String NAME_ADO_EIKA_CENTROGESTOR = "ADO_EIKA_CENTROGESTOR";
	public static final String NAME_ADO_EIKA_TERRITORIO = "ADO_EIKA_TERRITORIO";
	public static final String NAME_ADO_EIKA_VIAPAGO = "ADO_EIKA_VIAPAGO";
	public static final String NAME_ADO_EIKA_INDRETENCION = "ADO_EIKA_INDRETENCION";
	public static final String NAME_ADO_EIKA_TIPORETENCION = "ADO_EIKA_TIPORETENCION";
	public static final String NAME_ADO_EIKA_ELEMPEP = "ADO_EIKA_ELEMPEP";

	public static final String NAME_ADO_EIKA_CODDTIPCNTR = "ADO_EIKA_CODDTIPCNTR";
	public static final String NAME_ADO_EIKA_PARTIDAPRESU = "ADO_EIKA_PARTIDAPRESU";
	public static final String NAME_ADO_EIKA_TIPDOC = "ADO_EIKA_TIPDOC";

	private static final int LONG_ADO_EIKA_INDCONTDEF = 1;
	private static final int LONG_ADO_EIKA_CENTROGESTOR = 10;
	private static final int LONG_ADO_EIKA_TERRITORIO = 5;
	private static final int LONG_ADO_EIKA_VIAPAGO = 1;
	private static final int LONG_ADO_EIKA_INDRETENCION = 2;
	private static final int LONG_ADO_EIKA_TIPORETENCION = 1;
	private static final int LONG_ADO_EIKA_ELEMPEP = 24;

	private static final int LONG_ADO_EIKA_CODDTIPCNTR = 5;
	private static final int LONG_ADO_EIKA_PARTIDAPRESU = 13;
	private static final int LONG_ADO_EIKA_TIPDOC = 3;

	/**
	 * 
	 * 
	 * @return Map<String, BigDecimal> mapa
	 */
	public static Map<String, BigDecimal> mapeoLongitudesParam() {
		Map<String, BigDecimal> mapa = new HashMap<String, BigDecimal>();

		mapa.put(Y41bADOConstantes.NAME_ADO_TIPRGT_CABECERA,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_TIPRGT_CABECERA));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODINS, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODINS));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJER, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJER));
		mapa.put(Y41bADOConstantes.NAME_ADO_SECCION, new BigDecimal(Y41bADOConstantes.LONG_ADO_SECCION));
		mapa.put(Y41bADOConstantes.NAME_ADO_ORIMAQ, new BigDecimal(Y41bADOConstantes.LONG_ADO_ORIMAQ));
		mapa.put(Y41bADOConstantes.NAME_ADO_CORREL, new BigDecimal(Y41bADOConstantes.LONG_ADO_CORREL));
		mapa.put(Y41bADOConstantes.NAME_ADO_USUARIO, new BigDecimal(Y41bADOConstantes.LONG_ADO_USUARIO));
		mapa.put(Y41bADOConstantes.NAME_ADO_IDIOMA, new BigDecimal(Y41bADOConstantes.LONG_ADO_IDIOMA));
		mapa.put(Y41bADOConstantes.NAME_ADO_TIPRGT, new BigDecimal(Y41bADOConstantes.LONG_ADO_TIPRGT));
		mapa.put(Y41bADOConstantes.NAME_ADO_TIPDOC, new BigDecimal(Y41bADOConstantes.LONG_ADO_TIPDOC));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMXPE, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMXPE));
		mapa.put(Y41bADOConstantes.NAME_ADO_REFCOMICENCTR, new BigDecimal(Y41bADOConstantes.LONG_ADO_REFCOMICENCTR));
		mapa.put(Y41bADOConstantes.NAME_ADO_PARTIDAPRESU, new BigDecimal(Y41bADOConstantes.LONG_ADO_PARTIDAPRESU));
		mapa.put(Y41bADOConstantes.NAME_ADO_CTAPCP, new BigDecimal(Y41bADOConstantes.LONG_ADO_CTAPCP));
		mapa.put(Y41bADOConstantes.NAME_ADO_ELEMEN, new BigDecimal(Y41bADOConstantes.LONG_ADO_ELEMEN));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJERREFINT, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJERREFINT));
		mapa.put(Y41bADOConstantes.NAME_ADO_ANOORIGREFINT, new BigDecimal(Y41bADOConstantes.LONG_ADO_ANOORIGREFINT));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMREFINT, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMREFINT));
		mapa.put(Y41bADOConstantes.NAME_ADO_SUFDIS, new BigDecimal(Y41bADOConstantes.LONG_ADO_SUFDIS));
		mapa.put(Y41bADOConstantes.NAME_ADO_SUFOBL, new BigDecimal(Y41bADOConstantes.LONG_ADO_SUFOBL));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMORD, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMORD));
		mapa.put(Y41bADOConstantes.NAME_ADO_COPPRY, new BigDecimal(Y41bADOConstantes.LONG_ADO_COPPRY));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMFAC, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMFAC));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECFAC, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECFAC));
		mapa.put(Y41bADOConstantes.NAME_ADO_CONRME, new BigDecimal(Y41bADOConstantes.LONG_ADO_CONRME));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODDTIPCNTR, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODDTIPCNTR));
		mapa.put(Y41bADOConstantes.NAME_ADO_TIPTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_TIPTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_VERTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_VERTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE, new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPORTE));
		mapa.put(Y41bADOConstantes.NAME_ADO_TIPOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_TIPOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_VEROTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_VEROTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECVEN, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECVEN));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODRETIVA, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODRETIVA));
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET, new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPBASRET));
		mapa.put(Y41bADOConstantes.NAME_ADO_INDFORPAG, new BigDecimal(Y41bADOConstantes.LONG_ADO_INDFORPAG));
		mapa.put(Y41bADOConstantes.NAME_ADO_CTAFIN, new BigDecimal(Y41bADOConstantes.LONG_ADO_CTAFIN));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJERMAQTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJERMAQTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMMAQTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMMAQTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJERMAQOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJERMAQOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMMAQOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMMAQOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECINIPERPAG, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECINIPERPAG));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODCNTR, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODCNTR));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMRGTCPL, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMRGTCPL));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECRESOL, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECRESOL));

		// Pago Pericial Colegio
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPORTE_PAGPERCOLEGIO));
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET_PAGPERCOLEGIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPBASRET_PAGPERCOLEGIO));
		mapa.put(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_CONRME_PAGPERCOLEGIO));

		mapa.put(Y41bADOConstantes.NAME_ADO2_NUMEXP, new BigDecimal(Y41bADOConstantes.LONG_ADO2_NUMEXP));
		mapa.put(Y41bADOConstantes.NAME_ADO2_FECLAUDO, new BigDecimal(Y41bADOConstantes.LONG_ADO2_FECLAUDO));
		mapa.put(Y41bADOConstantes.NAME_ADO2_NOMBREARB, new BigDecimal(Y41bADOConstantes.LONG_ADO2_NOMBREARB));
		mapa.put(Y41bADOConstantes.NAME_ADO2_NIFARB, new BigDecimal(Y41bADOConstantes.LONG_ADO2_NIFARB));

		return mapa;
	}

	/**
	 * 
	 * 
	 * @return Map<String, BigDecimal> mapa
	 */
	public static Map<String, String> mapeoTiposParam() {
		Map<String, String> mapa = new HashMap<String, String>();

		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE, Y41bADOConstantes.TIPO_NUMBER);

		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET, Y41bADOConstantes.TIPO_NUMBER);
		mapa.put(Y41bADOConstantes.NAME_ADO_EMAIL, Y41bADOConstantes.TIPO_EMAIL);

		return mapa;
	}

	/**
	 * 
	 * 
	 * @return Map<String, BigDecimal> mapa
	 */
	public static Map<String, List<String>> mapeoCaracteresRellenar() {
		Map<String, List<String>> mapa = new HashMap<String, List<String>>();

		List<String> listaRelleno = new ArrayList<String>();

		listaRelleno.add(0, Y41bADOConstantes.CERO);
		listaRelleno.add(1, Y41bADOConstantes.IZQDA);

		List<String> listaRelleno2 = new ArrayList<String>();

		listaRelleno2.add(0, Y41bADOConstantes.BLANCO);
		listaRelleno2.add(1, Y41bADOConstantes.DCHA);

		mapa.put(Y41bADOConstantes.NAME_ADO_CODINS, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_SECCION, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_CORREL, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_CODTER, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_VERTER, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_CODRETIVA, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO, listaRelleno);
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET_PAGPERCOLEGIO, listaRelleno);

		mapa.put(Y41bADOConstantes.NAME_ADO_TIPDOC, listaRelleno2);
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMXPE, listaRelleno2);
		mapa.put(Y41bADOConstantes.NAME_ADO_CONRME, listaRelleno2);
		mapa.put(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO, listaRelleno2);

		mapa.put(Y41bADOConstantes.NAME_ADO_USUARIO, listaRelleno2);

		return mapa;
	}

	/**
	 * CAMPOS en orden tal y como aparecen en la lnea del fichero
	 * 
	 * @return List<String>
	 */
	public static List<String> listaCamposOrdenada() {
		List<String> lista = new ArrayList<String>();

		lista.add(Y41bADOConstantes.NAME_ADO_TIPRGT);
		lista.add(Y41bADOConstantes.NAME_ADO_TIPDOC);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMXPE);
		lista.add(Y41bADOConstantes.NAME_ADO_REFCOMICENCTR);
		lista.add(Y41bADOConstantes.NAME_ADO_PARTIDAPRESU);
		lista.add(Y41bADOConstantes.NAME_ADO_CTAPCP);
		lista.add(Y41bADOConstantes.NAME_ADO_ELEMEN);
		lista.add(Y41bADOConstantes.NAME_ADO_EJERREFINT);
		lista.add(Y41bADOConstantes.NAME_ADO_ANOORIGREFINT);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMREFINT);
		lista.add(Y41bADOConstantes.NAME_ADO_SUFDIS);
		lista.add(Y41bADOConstantes.NAME_ADO_SUFOBL);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMORD);
		lista.add(Y41bADOConstantes.NAME_ADO_COPPRY);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMFAC);
		lista.add(Y41bADOConstantes.NAME_ADO_FECFAC);
		lista.add(Y41bADOConstantes.NAME_ADO_CONRME);
		lista.add(Y41bADOConstantes.NAME_ADO_CODDTIPCNTR);
		lista.add(Y41bADOConstantes.NAME_ADO_TIPTER);
		lista.add(Y41bADOConstantes.NAME_ADO_CODTER);
		lista.add(Y41bADOConstantes.NAME_ADO_VERTER);
		lista.add(Y41bADOConstantes.NAME_ADO_IMPORTE);
		lista.add(Y41bADOConstantes.NAME_ADO_TIPOTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_CODOTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_VEROTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_FECVEN);
		lista.add(Y41bADOConstantes.NAME_ADO_CODRETIVA);
		lista.add(Y41bADOConstantes.NAME_ADO_IMPBASRET);

		lista.add(Y41bADOConstantes.NAME_ADO_INDFORPAG);
		lista.add(Y41bADOConstantes.NAME_ADO_CTAFIN);
		lista.add(Y41bADOConstantes.NAME_ADO_EJERMAQTER);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMMAQTER);
		lista.add(Y41bADOConstantes.NAME_ADO_EJERMAQOTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMMAQOTRPEC);

		lista.add(Y41bADOConstantes.NAME_ADO_FECINIPERPAG);
		lista.add(Y41bADOConstantes.NAME_ADO_CODCNTR);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMRGTCPL);
		lista.add(Y41bADOConstantes.NAME_ADO_FECRESOL);

		return lista;
	}

	/**
	 * CAMPOS en orden tal y como aparecen en la lnea del fichero
	 * 
	 * @return List<String>
	 */
	public static List<String> listaCamposOrdenadaPagPerColegio() {
		List<String> lista = new ArrayList<String>();

		lista.add(Y41bADOConstantes.NAME_ADO_TIPRGT);
		lista.add(Y41bADOConstantes.NAME_ADO_TIPDOC);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMXPE);
		lista.add(Y41bADOConstantes.NAME_ADO_REFCOMICENCTR);
		lista.add(Y41bADOConstantes.NAME_ADO_PARTIDAPRESU);
		lista.add(Y41bADOConstantes.NAME_ADO_CTAPCP);
		lista.add(Y41bADOConstantes.NAME_ADO_ELEMEN);
		lista.add(Y41bADOConstantes.NAME_ADO_EJERREFINT);
		lista.add(Y41bADOConstantes.NAME_ADO_ANOORIGREFINT);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMREFINT);
		lista.add(Y41bADOConstantes.NAME_ADO_SUFDIS);
		lista.add(Y41bADOConstantes.NAME_ADO_SUFOBL);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMORD);
		lista.add(Y41bADOConstantes.NAME_ADO_COPPRY);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMFAC);
		lista.add(Y41bADOConstantes.NAME_ADO_FECFAC);
		lista.add(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO);
		lista.add(Y41bADOConstantes.NAME_ADO_CODDTIPCNTR);
		lista.add(Y41bADOConstantes.NAME_ADO_TIPTER);
		lista.add(Y41bADOConstantes.NAME_ADO_CODTER);
		lista.add(Y41bADOConstantes.NAME_ADO_VERTER);
		lista.add(Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO);
		lista.add(Y41bADOConstantes.NAME_ADO_TIPOTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_CODOTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_VEROTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_FECVEN);
		lista.add(Y41bADOConstantes.NAME_ADO_CODRETIVA);
		lista.add(Y41bADOConstantes.NAME_ADO_IMPBASRET_PAGPERCOLEGIO);

		lista.add(Y41bADOConstantes.NAME_ADO_INDFORPAG);
		lista.add(Y41bADOConstantes.NAME_ADO_CTAFIN);
		lista.add(Y41bADOConstantes.NAME_ADO_EJERMAQTER);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMMAQTER);
		lista.add(Y41bADOConstantes.NAME_ADO_EJERMAQOTRPEC);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMMAQOTRPEC);

		lista.add(Y41bADOConstantes.NAME_ADO_FECINIPERPAG);
		lista.add(Y41bADOConstantes.NAME_ADO_CODCNTR);
		lista.add(Y41bADOConstantes.NAME_ADO_NUMRGTCPL);
		lista.add(Y41bADOConstantes.NAME_ADO_FECRESOL);

		return lista;
	}

	/**
	 * CAMPOS en orden tal y como aparecen en la lnea del fichero
	 * 
	 * @return List<String>
	 */
	public static List<String> listaCamposOrdenadaFichResult() {
		List<String> lista = new ArrayList<String>();

		lista.add(Y41bADOConstantes.NAME_ADO2_NUMEXP);
		lista.add(Y41bADOConstantes.NAME_ADO2_FECLAUDO);
		lista.add(Y41bADOConstantes.NAME_ADO2_NOMBREARB);
		lista.add(Y41bADOConstantes.NAME_ADO2_NIFARB);

		return lista;
	}

	/**
	 * 
	 * 
	 * @return Map<String, BigDecimal> mapa
	 */
	public static Map<String, BigDecimal> mapeoLongitudesParam_nuevo() {
		Map<String, BigDecimal> mapa = new HashMap<String, BigDecimal>();

		// mapa.put(Y41bADOConstantes.NAME_ADO_TIPRGT_CABECERA, new BigDecimal(
		// Y41bADOConstantes.LONG_ADO_TIPRGT_CABECERA));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODINS, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODINS));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJER, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJER));
		// mapa.put(Y41bADOConstantes.NAME_ADO_SECCION, new BigDecimal(
		// Y41bADOConstantes.LONG_ADO_SECCION));
		// mapa.put(Y41bADOConstantes.NAME_ADO_ORIMAQ, new BigDecimal(
		// Y41bADOConstantes.LONG_ADO_ORIMAQ));
		mapa.put(Y41bADOConstantes.NAME_ADO_CORREL, new BigDecimal(Y41bADOConstantes.LONG_ADO_CORREL));
		mapa.put(Y41bADOConstantes.NAME_ADO_USUARIO, new BigDecimal(Y41bADOConstantes.LONG_ADO_USUARIO));
		// mapa.put(Y41bADOConstantes.NAME_ADO_IDIOMA, new
		// BigDecimal(Y41bADOConstantes.LONG_ADO_IDIOMA));
		// mapa.put(Y41bADOConstantes.NAME_ADO_TIPRGT, new BigDecimal(
		// Y41bADOConstantes.LONG_ADO_TIPRGT));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_TIPDOC, new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_TIPDOC));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMXPE, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMXPE));
		mapa.put(Y41bADOConstantes.NAME_ADO_REFCOMICENCTR, new BigDecimal(Y41bADOConstantes.LONG_ADO_REFCOMICENCTR));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_PARTIDAPRESU,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_PARTIDAPRESU));
		mapa.put(Y41bADOConstantes.NAME_ADO_CTAPCP, new BigDecimal(Y41bADOConstantes.LONG_ADO_CTAPCP));
		mapa.put(Y41bADOConstantes.NAME_ADO_ELEMEN, new BigDecimal(Y41bADOConstantes.LONG_ADO_ELEMEN));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJERREFINT, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJERREFINT));
		mapa.put(Y41bADOConstantes.NAME_ADO_ANOORIGREFINT, new BigDecimal(Y41bADOConstantes.LONG_ADO_ANOORIGREFINT));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMREFINT, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMREFINT));
		mapa.put(Y41bADOConstantes.NAME_ADO_SUFDIS, new BigDecimal(Y41bADOConstantes.LONG_ADO_SUFDIS));
		mapa.put(Y41bADOConstantes.NAME_ADO_SUFOBL, new BigDecimal(Y41bADOConstantes.LONG_ADO_SUFOBL));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMORD, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMORD));
		mapa.put(Y41bADOConstantes.NAME_ADO_COPPRY, new BigDecimal(Y41bADOConstantes.LONG_ADO_COPPRY));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMFAC, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMFAC));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECFAC, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECFAC));
		mapa.put(Y41bADOConstantes.NAME_ADO_CONRME, new BigDecimal(Y41bADOConstantes.LONG_ADO_CONRME));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_CODDTIPCNTR,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_CODDTIPCNTR));
		// mapa.put(Y41bADOConstantes.NAME_ADO_TIPTER, new BigDecimal(
		// Y41bADOConstantes.LONG_ADO_TIPTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODTER));
		// mapa.put(Y41bADOConstantes.NAME_ADO_VERTER, new BigDecimal(
		// Y41bADOConstantes.LONG_ADO_VERTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE, new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPORTE));
		mapa.put(Y41bADOConstantes.NAME_ADO_TIPOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_TIPOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_VEROTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_VEROTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECVEN, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECVEN));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODRETIVA, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODRETIVA));
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET, new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPBASRET));
		mapa.put(Y41bADOConstantes.NAME_ADO_INDFORPAG, new BigDecimal(Y41bADOConstantes.LONG_ADO_INDFORPAG));
		mapa.put(Y41bADOConstantes.NAME_ADO_CTAFIN, new BigDecimal(Y41bADOConstantes.LONG_ADO_CTAFIN));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJERMAQTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJERMAQTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMMAQTER, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMMAQTER));
		mapa.put(Y41bADOConstantes.NAME_ADO_EJERMAQOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_EJERMAQOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMMAQOTRPEC, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMMAQOTRPEC));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECINIPERPAG, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECINIPERPAG));
		mapa.put(Y41bADOConstantes.NAME_ADO_CODCNTR, new BigDecimal(Y41bADOConstantes.LONG_ADO_CODCNTR));
		mapa.put(Y41bADOConstantes.NAME_ADO_NUMRGTCPL, new BigDecimal(Y41bADOConstantes.LONG_ADO_NUMRGTCPL));
		mapa.put(Y41bADOConstantes.NAME_ADO_FECRESOL, new BigDecimal(Y41bADOConstantes.LONG_ADO_FECRESOL));

		// Pago Pericial Colegio
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPORTE_PAGPERCOLEGIO));
		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET_PAGPERCOLEGIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_IMPBASRET_PAGPERCOLEGIO));
		mapa.put(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_CONRME_PAGPERCOLEGIO));

		mapa.put(Y41bADOConstantes.NAME_ADO2_NUMEXP, new BigDecimal(Y41bADOConstantes.LONG_ADO2_NUMEXP));
		mapa.put(Y41bADOConstantes.NAME_ADO2_FECLAUDO, new BigDecimal(Y41bADOConstantes.LONG_ADO2_FECLAUDO));
		mapa.put(Y41bADOConstantes.NAME_ADO2_NOMBREARB, new BigDecimal(Y41bADOConstantes.LONG_ADO2_NOMBREARB));
		mapa.put(Y41bADOConstantes.NAME_ADO2_NIFARB, new BigDecimal(Y41bADOConstantes.LONG_ADO2_NIFARB));

		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_INDCONTDEF,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_INDCONTDEF));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_CENTROGESTOR,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_CENTROGESTOR));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_TERRITORIO,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_TERRITORIO));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_VIAPAGO, new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_VIAPAGO));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_INDRETENCION,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_INDRETENCION));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_TIPORETENCION,
				new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_TIPORETENCION));
		mapa.put(Y41bADOConstantes.NAME_ADO_EIKA_ELEMPEP, new BigDecimal(Y41bADOConstantes.LONG_ADO_EIKA_ELEMPEP));

		return mapa;
	}

	/**
	 * 
	 * 
	 * @return Map<String, BigDecimal> mapa
	 */
	public static Map<String, String> mapeoTiposParam_nuevo() {
		Map<String, String> mapa = new HashMap<String, String>();

		mapa.put(Y41bADOConstantes.NAME_ADO_IMPORTE, Y41bADOConstantes.TIPO_NUMBER);

		mapa.put(Y41bADOConstantes.NAME_ADO_IMPBASRET, Y41bADOConstantes.TIPO_NUMBER);
		mapa.put(Y41bADOConstantes.NAME_ADO_EMAIL, Y41bADOConstantes.TIPO_EMAIL);

		return mapa;
	}
}
