package com.ejie.y41b.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

import com.ejie.y41b.utils.exception.Y41bUDAException;

@Aspect
public class Y41bExceptionAspect {

	@Around("execution(* com.ejie.y41b.service.*.*(..) )")
	public Object exceptionServiceHandle(ProceedingJoinPoint joinPoint)
			throws Throwable {
		try {
			Object retVal = joinPoint.proceed();
			return retVal;
		} catch (Y41bUDAException e) {
			e.printStackTrace();
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}