package com.ejie.y41b.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Proxy de metodos de la clase Connection. Se controla la llamada de cierre de
 * conexion para limpiar la informacion de usuario de la conexion
 * 
 *  
 * 
 */
public class ConnectionMethodProxy implements InvocationHandler {

	/**
	 * Logger.
	 */
	private static final Logger LOGGER = LoggerFactory
			.getLogger(ConnectionMethodProxy.class);

	private Connection connection;

	/**
	 * Nueva instancia.
	 * 
	 * @param connection
	 *            conexion
	 * @return conexion
	 */
	public static Connection newInstance(Connection connection) {
		return (Connection) Proxy.newProxyInstance(connection.getClass()
				.getClassLoader(), new Class[] { Connection.class },
				new ConnectionMethodProxy(connection));
	}

	/**
	 * Constructor.
	 * 
	 * @param connection
	 *            conexion
	 */
	private ConnectionMethodProxy(Connection connection) {
		this.connection = connection;
	}

	@Override()
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {

		String methodName = method.getName();

		if ("close".equals(methodName)) {
			this.terminaUsuario(this.connection);
		}

		return method.invoke(this.connection, args);
	}

	/**
	 * Limpieza del usuario en la conexion de base de datos
	 * 
	 * @param conn
	 *            conexion
	 */
	private void terminaUsuario(Connection conn) {
		PreparedStatement pstmt2 = null;
		try {
			pstmt2 = conn
					.prepareStatement("CALL DBMS_SESSION.CLEAR_IDENTIFIER()");
			pstmt2.execute();

		} catch (SQLException e) {
			ConnectionMethodProxy.LOGGER.error(
					"ConnectionMethodProxy.terminaUsuario", e);
		} finally {
			try {
				if (pstmt2 != null) {
					pstmt2.close();
				}
			} catch (SQLException ex) {
				ConnectionMethodProxy.LOGGER.error(
						"ConnectionMethodProxy.terminaUsuario", ex);
			}
		}
	}

}
