package com.ejie.y41b.aop;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.security.CensoMonitorThreadLocal;

/**
 * Clase interceptora de llamadas de la clase Connection
 * 
 *  
 * 
 */
public class ConnectionCallInterceptor implements MethodInterceptor {

	/**
	 * Logger.
	 */
	private static final Logger LOGGER = LoggerFactory
			.getLogger(ConnectionCallInterceptor.class);

	@Override()
	public Object invoke(MethodInvocation methodInvocation) throws Throwable {

		String methodName = methodInvocation.getMethod().getName();
		if ("getConnection".equals(methodName)) {
			// return proxied connection
			Connection connection = (Connection) methodInvocation.proceed();
			this.inicializaUsuario(connection);
			return ConnectionMethodProxy.newInstance(connection);
		} else {
			// simply return methodcall result
			return methodInvocation.proceed();
		}
	}

	/**
	 * Inicializacion del usuario en la conexion de base de datos
	 * 
	 * @param conn
	 *            conexion
	 */
	private void inicializaUsuario(Connection conn) {
		String usuario = "y41b";
		PreparedStatement pstmt2 = null;
		try {
			if (CensoMonitorThreadLocal.get() != null) {
				usuario = CensoMonitorThreadLocal.get().getMocodigo();
			}
			pstmt2 = conn
					.prepareStatement("CALL DBMS_SESSION.SET_IDENTIFIER(?)");
			pstmt2.setString(1, usuario);
			pstmt2.execute();

		} catch (SQLException e) {
			ConnectionCallInterceptor.LOGGER.error(
					"error en ConnectionCallInterceptor.inicializaUsuario", e);
		} finally {
			try {
				if (pstmt2 != null) {
					pstmt2.close();
				}
			} catch (SQLException ex) {
				ConnectionCallInterceptor.LOGGER.error(
						"error en ConnectionCallInterceptor.inicializaUsuario",
						ex);
			}
		}
	}
}
