package com.ejie.y41b.adapter.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.ejie.ainit.xml.StoredAdminInitInfoDocument;
import com.ejie.cp.xml.ProcedureDocument;
import com.ejie.ct.xml.EjgvDocumentDocument1;
import com.ejie.folderManagement.xml.ContextRegistryDocument;
import com.ejie.folderManagement.xml.ContextRegistryDocument.ContextRegistry;
import com.ejie.folderManagement.xml.PropertyDocument.Property;
import com.ejie.folderManagement.xml.RequestReturnDocument;
import com.ejie.folderManagement.xml.RequestReturnDocument.RequestReturn;
import com.ejie.horizontalSystemOfNotification.xml.ExitRegistryCreationInfoDocument;
import com.ejie.horizontalSystemOfNotification.xml.ExitRegistryCreationInfoDocument.ExitRegistryCreationInfo;
import com.ejie.horizontalSystemOfNotification.xml.R02GDocumentInfoDocument;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.DatosCertificado;
import com.ejie.y41b.model.platea.ExpedienteOficio;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentSolicitud;
import com.ejie.y41b.model.platea.RespuestaSolicitudPresencial;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * <p>
 * Titulo: Y41bPlateaTransformer
 * </p>
 * <p>
 * Descripcion: Contiene metodos para devolver el resultado en las llamadas a
 * los WebServices de Platea
 * </p>
 * <p>
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
public final class Y41bPlateaTransformer {

	/**
	 * Constructor
	 */
	private Y41bPlateaTransformer() {
		super();
	}

	/**
	 * @param xml
	 *            Procedure xmlns="com/ejie/cp/xml" de Platea
	 * @param solicitudPresencial
	 *            SolicitudPresencial
	 * @return RespuestaSolicitudPresencial respuestaSolicitudPresencial
	 * @throws XmlException
	 *             XmlException
	 */
	public static RespuestaSolicitudPresencial transformCrearSolicitudPresencial(
			String xml, SolicitudPresencial solicitudPresencial)
			throws XmlException {
		RespuestaSolicitudPresencial respuestaSolicitudPresencial = new RespuestaSolicitudPresencial();

		RequestReturnDocument requestReturnDocument = RequestReturnDocument.Factory
				.parse(xml);

		RequestReturn requestReturn = requestReturnDocument.getRequestReturn();

		respuestaSolicitudPresencial.setCodigoRespuesta(requestReturn
				.getReturnCode());
		respuestaSolicitudPresencial.setErrorDescripcion(requestReturn
				.getErrorDescription());

		for (Property pr : requestReturn.getPropertyArray()) {
			XmlObject valor = pr.getXmlValueArray(0);

			if (valor.xmlText().indexOf("StoredApplicationInfo") > 0) {
				String StoredApplicationInfo = valor.xmlText();
				String folderID = StoredApplicationInfo.substring(
						StoredApplicationInfo.indexOf("<folderID>") + 10,
						StoredApplicationInfo.indexOf("</folderID>"));
				respuestaSolicitudPresencial.setFolderID(folderID);
				String estado = StoredApplicationInfo
						.substring(StoredApplicationInfo
								.indexOf("<processingStatus>") + 18,
								StoredApplicationInfo
										.indexOf("</processingStatus>"));
				respuestaSolicitudPresencial.setEstadoExpediente(estado);
			}
		}

		List<Documento> listaDocumentosDokusi = new ArrayList<Documento>();
		Documento documentoAux = null;
		if (null != solicitudPresencial.getDocumentosAdjuntos()
				&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
			for (Documento documento : solicitudPresencial
					.getDocumentosAdjuntos()) {
				documentoAux = new Documento();
				documentoAux.setIdDocumento(documento.getIdDocumento());
				documentoAux.setOidDokusi(documento.getOidDokusi());

				listaDocumentosDokusi.add(documentoAux);
			}
		}

		respuestaSolicitudPresencial.setIdExpediente(solicitudPresencial
				.getIdExpediente());

		respuestaSolicitudPresencial
				.setDocumentosAdjuntos(listaDocumentosDokusi);

		return respuestaSolicitudPresencial;
	}

	/**
	 * @param xml
	 *            Procedure xmlns="com/ejie/cp/xml" de Platea
	 * @return ProcedureDocument procedureDocument
	 * @throws XmlException
	 *             XmlException
	 */
	public static ProcedureDocument transformObtenerDatosCatalogoProcedimientos(
			String xml) throws XmlException {
		ProcedureDocument procedureDocument = ProcedureDocument.Factory
				.parse(xml);

		return procedureDocument;
	}

	/**
	 * @param xml
	 *            xml
	 * @return RegistroEntrada registroEntrada
	 * @throws XmlException
	 *             XmlException
	 */
	public static RegistroEntrada transformObtenerRegistroEntrada(String xml)
			throws XmlException {
		ContextRegistryDocument contextRegistryDocument = ContextRegistryDocument.Factory
				.parse(xml);

		ContextRegistry contextRegistry = contextRegistryDocument
				.getContextRegistry();

		RegistroEntrada registroEntrada = new RegistroEntrada();
		registroEntrada.setRegistryNumber(contextRegistry.getRegistryNumber());
		registroEntrada.setRegistryTimestamp(contextRegistry
				.getRegistryTimestamp());

		return registroEntrada;
	}

	/**
	 * @param xml
	 *            xml
	 * @return RegistroSalida registroSalida
	 * @throws XmlException
	 *             XmlException
	 */
	public static RegistroSalida transformObtenerRegistroSalida(String xml)
			throws XmlException {
		ExitRegistryCreationInfoDocument exitRegistryCreationInfoDocument = ExitRegistryCreationInfoDocument.Factory
				.parse(xml);

		ExitRegistryCreationInfo exitRegistryCreationInfo = exitRegistryCreationInfoDocument
				.getExitRegistryCreationInfo();

		RegistroSalida registroSalida = new RegistroSalida();
		registroSalida.setRegistryNumber(exitRegistryCreationInfo
				.getRegistryNumber());
		registroSalida.setRegistryTimestamp(exitRegistryCreationInfo
				.getRegistryTimestamp());

		return registroSalida;
	}

	/**
	 * transformAbrirExpedienteOficio
	 * 
	 * @param xml
	 *            String
	 * @param expediente
	 *            ExpedienteOficio
	 * @return ExpedienteOficio expediente
	 * @throws XmlException
	 *             XmlException
	 */
	public static ExpedienteOficio transformAbrirExpedienteOficio(String xml,
			ExpedienteOficio expediente) throws XmlException {
		RequestReturnDocument requestReturnDocument = RequestReturnDocument.Factory
				.parse(xml);
		Property pr = requestReturnDocument.getRequestReturn()
				.getPropertyArray(0);
		XmlObject valor = pr.getXmlValueArray(0);
		if (valor.xmlText().indexOf("storedAdminInitInfo") > 0) {
			String cambio = valor.toString().replaceAll(
					"com/ejie/folderManagement/xml", "com/ejie/ainit/xml");
			StoredAdminInitInfoDocument stored = StoredAdminInitInfoDocument.Factory
					.parse(cambio);
			expediente.setFolderId(stored.getStoredAdminInitInfo()
					.getFolderID());
		} else if (valor.xmlText().indexOf("StoredApplicationInfo") > 0) {
			String StoredApplicationInfo = valor.xmlText();
			String folderID = StoredApplicationInfo.substring(
					StoredApplicationInfo.indexOf("<folderID>") + 10,
					StoredApplicationInfo.indexOf("</folderID>"));
			expediente.setFolderId(folderID);
			String estado = StoredApplicationInfo.substring(
					StoredApplicationInfo.indexOf("<processingStatus>") + 18,
					StoredApplicationInfo.indexOf("</processingStatus>"));
			expediente.setEstadoExpediente(estado);
		}
		return expediente;
	}

	/**
	 * @param xml
	 *            xml
	 * @return DatosCertificado DatosCertificado
	 * @throws Exception
	 *             Exception
	 */
	public static DatosCertificado transformObtenerDatosCertificadoFirma(
			String xml) throws Exception {

		DatosCertificado datosCertificado = new DatosCertificado();
		datosCertificado.setXml(xml);

		Document docu;
		docu = fncCrearDoc(xml);

		NodeList listaElementoPerfil = docu.getElementsByTagName("keyUsage");
		Element elementoIndividualPerfil = (Element) listaElementoPerfil
				.item(0);

		NodeList nodoPerfil = elementoIndividualPerfil.getChildNodes();
		if (nodoPerfil.item(0) != null) {
			datosCertificado.setPolitica(nodoPerfil.item(0).getNodeValue()
					.trim());
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		if (StringUtils.isNotBlank(datosCertificado.getXml())) {
			// Dependiendo de si firma con txartela de entidad, obtenemos el dni
			// del firmante.
			EjgvDocumentDocument1 ejgvDocumentDoc = EjgvDocumentDocument1.Factory
					.parse(datosCertificado.getXml().replaceFirst(
							"<ejgvDocument>",
							"<ejgvDocument xmlns=\"com/ejie/ct/xml\">"));

			if (null != ejgvDocumentDoc.getEjgvDocument()
					&& null != ejgvDocumentDoc.getEjgvDocument().getBody()) {
				datosCertificado.setDni(ejgvDocumentDoc.getEjgvDocument()
						.getBody().getIdPersona());
				datosCertificado.setFirmante(datosCertificado.getDni());

				// el SIGNER_ID es el CIF de la empresa
				if (prop.getProperty("politica.empresa").equals(
						datosCertificado.getPolitica())
						|| prop.getProperty("politica.empresa.cb").equals(
								datosCertificado.getPolitica())
						|| prop.getProperty("politica.empresa.fnmt").equals(
								datosCertificado.getPolitica())) {
					// Obtener CIF empresa (SIGNER_ID obtenido anteriormente
					// ///antes habia datosCertificado.getDni()
					datosCertificado.setCif(ejgvDocumentDoc.getEjgvDocument()
							.getBody().getIdentidad());
					// Obtener DNI apoderado
					datosCertificado.setDni(ejgvDocumentDoc.getEjgvDocument()
							.getBody().getIdPersona());
					// Obtener Nombre apoderado
					datosCertificado.setNombre(ejgvDocumentDoc
							.getEjgvDocument().getBody().getNombre());
					// Obtener Apellidos apoderado
					datosCertificado.setApellidos(ejgvDocumentDoc
							.getEjgvDocument().getBody().getApellidos());
					// Obtener Nombre empresa
					datosCertificado.setNombre_empresa(ejgvDocumentDoc
							.getEjgvDocument().getBody().getEntidad());
					datosCertificado.setFirmante(ejgvDocumentDoc
							.getEjgvDocument().getBody().getIdentidad());
				} else if (prop.getProperty("politica.ciudadano").equals(
						datosCertificado.getPolitica())
						|| prop.getProperty("politica.dni.e").equals(
								datosCertificado.getPolitica())
						|| prop.getProperty("politica.dni.e.firma").equals(
								datosCertificado.getPolitica())) {
					// Obtener Nombre apoderado
					datosCertificado.setNombre(ejgvDocumentDoc
							.getEjgvDocument().getBody().getNombre());
					// Obtener Apellidos apoderado
					datosCertificado.setApellidos(ejgvDocumentDoc
							.getEjgvDocument().getBody().getApellidos());
					// Obtener TIS
					datosCertificado.setTis(ejgvDocumentDoc.getEjgvDocument()
							.getBody().getDnQualifier());
				} else if (prop.getProperty("politica.funcionario").equals(
						datosCertificado.getPolitica())) {
					// Obtener Nombre funcionario
					datosCertificado.setNombre(ejgvDocumentDoc
							.getEjgvDocument().getBody().getNombre());
					// Obtener Apellidos funcionario
					datosCertificado.setApellidos(ejgvDocumentDoc
							.getEjgvDocument().getBody().getApellidos());
					// Obtener Organizacion
					datosCertificado.setNombre_empresa(ejgvDocumentDoc
							.getEjgvDocument().getBody().getEntidad());
				}
			}
		}

		return datosCertificado;
	}

	/**
	 * @param ejgvDocument
	 *            String
	 * @param listaDocumentosAdjuntos
	 *            List<Documento>
	 * @return RespuestaSolicitudPresencial respuestaSolicitudPresencial
	 */
	public static RespuestaCrearEJGVDocumentSolicitud transformCrearEJGVDocumentSolicitud(
			String ejgvDocument, List<Documento> listaDocumentosAdjuntos) {
		RespuestaCrearEJGVDocumentSolicitud respuestaCrearEJGVDocumentSolicitud = new RespuestaCrearEJGVDocumentSolicitud();
		respuestaCrearEJGVDocumentSolicitud.setEjgvDocument(ejgvDocument);
		respuestaCrearEJGVDocumentSolicitud.setTextoPlano(Y41bUtils
				.fncExtaerTextoFirmado(ejgvDocument));
		// Actualizamos los OIDs de Dokusi
		respuestaCrearEJGVDocumentSolicitud
				.setDocumentosAdjuntos(listaDocumentosAdjuntos);
		return respuestaCrearEJGVDocumentSolicitud;
	}

	/**
	 * @param ejgvDocument
	 *            String
	 * @param listaDocumentosAdjuntos
	 *            List<Documento>
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 *         respuestaCrearEJGVDocumentNotificacion
	 */
	public static RespuestaCrearEJGVDocumentNotificacion transformCrearEJGVDocumentNotificacion(
			String ejgvDocument, List<Documento> listaDocumentosAdjuntos) {
		RespuestaCrearEJGVDocumentNotificacion respuestaCrearEJGVDocumentNotificacion = new RespuestaCrearEJGVDocumentNotificacion();
		respuestaCrearEJGVDocumentNotificacion.setEjgvDocument(ejgvDocument);
		// Preparamos Texto Plano
		String textoPlanoPreparado = Y41bUtils
				.fncExtaerTextoFirmado(ejgvDocument);
		textoPlanoPreparado = textoPlanoPreparado.trim();
		StringBuffer sbTextoPlano = new StringBuffer(50);
		sbTextoPlano.append("\r\n");
		sbTextoPlano.append(textoPlanoPreparado);
		sbTextoPlano.append("\r\n");
		textoPlanoPreparado = sbTextoPlano.toString();
		respuestaCrearEJGVDocumentNotificacion
				.setTextoPlano(textoPlanoPreparado);
		// Actualizamos los OIDs de Dokusi
		respuestaCrearEJGVDocumentNotificacion
				.setDocumentosAdjuntos(listaDocumentosAdjuntos);
		return respuestaCrearEJGVDocumentNotificacion;
	}

	/**
	 * @param ejgvDocument
	 *            String
	 * @return RegistroSalida
	 */
	public static RegistroSalida transformGetRegistroSalidaFromIdNotificacion(
			String ejgvDocument) throws Exception {
		String registryNumberStr = ejgvDocument.substring(
				ejgvDocument.indexOf("<registryNumber>")
						+ Y41bConstantes.NUM_16,
				ejgvDocument.indexOf("</registryNumber>"));

		String registryTimestampStr = ejgvDocument.substring(
				ejgvDocument.indexOf("<registryTimestamp>")
						+ Y41bConstantes.NUM_19,
				ejgvDocument.indexOf("</registryTimestamp>"));

		RegistroSalida registroSalida = new RegistroSalida();
		registroSalida.setRegistryNumber(registryNumberStr);
		registroSalida.setRegistryTimestamp(registryTimestampStr);

		return registroSalida;
	}

	/**
	 * Crea un objeto de la clase Document a partir del String XML que recibe
	 * como parametro.
	 * 
	 * @param xml
	 *            String xml
	 * 
	 * @return Document objeto de la clase Document.
	 * 
	 * @throws Exception
	 *             the exception
	 */

	private static Document fncCrearDoc(String xml) throws Exception {
		Document doc = null;
		DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory
				.newInstance();
		DocumentBuilder documentBuilder = documentBuilderFactory
				.newDocumentBuilder();

		doc = documentBuilder.parse((InputStream) new ByteArrayInputStream(xml
				.getBytes("8859_1")));

		return doc;
	}

	/**
	 * @param xml
	 * @return String
	 * @throws XmlException
	 *             XmlException
	 */
	public static String transformJustificanteNotificacion(String xml)
			throws XmlException {

		R02GDocumentInfoDocument r02GDocumentInfoDocument = R02GDocumentInfoDocument.Factory
				.parse(xml);

		return r02GDocumentInfoDocument.getR02GDocumentInfo()
				.getContentBase64();
	}

	/**
	 * @param xml
	 * @return String
	 * @throws XmlException
	 *             XmlException
	 */
	public static String transformJustificanteAcuse(String xml)
			throws XmlException {

		R02GDocumentInfoDocument r02GDocumentInfoDocument = R02GDocumentInfoDocument.Factory
				.parse(xml);

		return r02GDocumentInfoDocument.getR02GDocumentInfo()
				.getContentBase64();
	}
}
