package com.ejie.y41b.adapter.services;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

import com.ejie.cp.xml.ProcedureDocument;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Estadopago;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Metodopago;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteSANLiquidacion;
import com.ejie.y41b.model.pasarela.ConceptosPago;
import com.ejie.y41b.model.pasarela.ConstPasarela;
import com.ejie.y41b.model.pasarela.ObjPasarela;
import com.ejie.y41b.pasarela.Pasarela;
import com.ejie.y41b.service.ConceptopagoService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.PagosService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.T17CalleService;
import com.ejie.y41b.service.T17LocalidadService;
import com.ejie.y41b.service.T17MunicipioService;
import com.ejie.y41b.service.T17PaisService;
import com.ejie.y41b.service.T17PortalService;
import com.ejie.y41b.service.T17ProvinciaService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.sipca.Y41bFuncionesSipca;

/**
 * <p>
 * Titulo: Y41bSipcaServiceImpl
 * </p>
 * <p>
 * Descipcion: Prepara los datos para la llamada a Sipca
 * </p>
 * <p>
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Empresa: ODEI
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "Y41bSipcaServiceImpl")
public class Y41bSipcaServiceImpl implements Y41bSipcaService {

	private static final String CODIGO_SIPCA_ARABA = "1";
	private static final String CODIGO_SIPCA_GIPUZKOA = "2";
	private static final String CODIGO_SIPCA_BIZKAIA = "3";
	private static final String CODIGO_SIPCA_SIN_TERRITORIALIZAR = "4";

	private static final Logger logger = LoggerFactory.getLogger(Y41bSipcaServiceImpl.class);

	@Autowired()
	private SantramexpService sanTramExpService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private ConceptopagoService conceptopagoService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private PagosService pagosService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17ProvinciaService t17ProvinciaService;

	@Autowired()
	private T17CalleService t17CalleService;

	@Autowired()
	private T17PortalService t17PortalService;

	@Autowired()
	private T17LocalidadService t17LocalidadService;

	@Autowired()
	private T17PaisService t17PaisService;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private ParametrosDao parametrosDao;

	/**
	 * Objeto pasarela de prueba.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param conceptoPago
	 *            the concepto pago
	 * @param pago
	 *            the pago
	 * @param appPresupuestaria
	 *            the app presupuestaria
	 * @param sancionado
	 *            the sancionado
	 * @param fechaResolucion
	 *            the fecha resolucion
	 * @param numReferencia
	 *            the num referencia
	 * @param entidadEmisoraMunicipio
	 *            the entidad emisora municipio
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @return ObjPasarela
	 * @throws ParseException
	 *             the parse exception
	 */
	public ObjPasarela crearObjetoPasarela(TramiteSANLiquidacion tramite, Conceptopago conceptoPago, Pagos pago,
			String appPresupuestaria, Saninterv sancionado, Date fechaResolucion, Long numReferencia,
			String entidadEmisoraMunicipio, String tipoDevengo) throws ParseException {
		ObjPasarela objetoPasarela = new ObjPasarela();

		Locale locale_castellano = new Locale(Y41bConstantes.CASTELLANO);
		Locale locale_euskera = new Locale(Y41bConstantes.EUSKERA);

		objetoPasarela.setCodsubvencion(pago.getSgcodsubvencion());
		objetoPasarela.setFechareintegro(
				Y41bUtils.formatearDateToString(pago.getSgfechareintegro(), Y41bConstantes.FORMATO_FECHA_PASARELA));
		objetoPasarela.setCausareintegro(pago.getSgcausareintegro());

		objetoPasarela.setEntidadEmisoraNombCast(
				this.appMessageSource.getMessage("pasarela.entidad", null, locale_castellano));
		objetoPasarela
				.setEntidadEmisoraNombEusk(this.appMessageSource.getMessage("pasarela.entidad", null, locale_euskera));
		objetoPasarela.setEntidadEmisoraMunicipio(entidadEmisoraMunicipio);
		objetoPasarela.setTipoAcceso(null); // 1-recibo Bancario 2- banca
											// electronica
		objetoPasarela.setIdioma(null); // 1-castellano 2- euskera
		objetoPasarela
				.setCodTasaCast(this.appMessageSource.getMessage("pasarela.descSancion", null, locale_castellano)); // (73.03)
																													// Tasa
																													// de
																													// ...
		objetoPasarela.setCodTasaEusk(this.appMessageSource.getMessage("pasarela.descSancion", null, locale_euskera)); // (73.03)Tasa
																														// de
																														// ...
		objetoPasarela.setReferencia(
				(new StringBuffer("").append(pago.getSgreferencia()).append(pago.getSgdigitocontrol())).toString()); // 9104000000112
		objetoPasarela.setIdentificacion(""); // 011204 ddMMyy
		objetoPasarela.setFechaIncioPago(
				Y41bUtils.formatearDateToString(pago.getSgfechaemision(), Y41bConstantes.FORMATO_FECHA_PASARELA)); // 311204
		// ddMMyy
		objetoPasarela.setFechaLimitePago(
				Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_PASARELA)); // 311204
		// ddMMyy
		objetoPasarela.setImporte(Y41bUtils.formatDouble2decimalesYcoma(pago.getSgimporte().doubleValue())); // 12,50
		objetoPasarela.setSufijo(conceptoPago.getSdsufijo().toString()); // 909
		objetoPasarela.setNumExpFactura(Y41bUtils.upToNCharacters(pago.getSgexpediente(), Y41bConstantes.NUM_25));
		objetoPasarela.setNumFactura("");
		objetoPasarela.setFamiliaID(null);
		objetoPasarela.setFormato(Y41bConstantes.FORMATO_PASARELA);
		objetoPasarela.setTipoDevengo(tipoDevengo); // PeticionPago.DEVENGO_EMISION
		objetoPasarela.setTerritorioHist(null);
		objetoPasarela.setFechaLimiteAnul(null); // Fecha limite de anulacin
													// del pago
		objetoPasarela.setImporteIVA("");
		objetoPasarela.setTipoIVA("");
		objetoPasarela.setBaseImponible(Y41bUtils.formatDouble2decimalesYcoma(pago.getSgimporte().doubleValue()));
		objetoPasarela.setCodigoConceptoIVA("");

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			objetoPasarela.setFechaIncioPagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechaemision(), Y41bConstantes.FORMATO_FECHA_EU));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimitePagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_EU));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimiteAnulLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_EU));

		} else {
			objetoPasarela.setFechaIncioPagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechaemision(), Y41bConstantes.FORMATO_FECHA_ES));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimitePagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_ES));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimiteAnulLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_ES));
		}

		objetoPasarela.setCodigoRecaudacion(Y41bConstantes.CPR); // 9050794

		objetoPasarela.setExentoPago(false); // true - exento de pago false - no
												// exento

		objetoPasarela.setEntidadEmisora(conceptoPago.getSdentemisora()); // 04833001

		objetoPasarela.setEntidadEmisoraNombCast(
				this.appMessageSource.getMessage("pasarela.entidadEmisora", null, locale_castellano)); // "KontsumoBIDE"
		objetoPasarela.setEntidadEmisoraNombEusk(
				this.appMessageSource.getMessage("pasarela.entidadEmisora", null, locale_euskera)); // "Gazteria
																									// Zuzendaritza";

		objetoPasarela.setConceptoAplicPresupuestaria(appPresupuestaria); // 2001020914000043126232220000J

		objetoPasarela.setConceptoCodigoIngreso(Y41bUtils.zeroPad(conceptoPago.getSdconceptoing().toString(), 2)); // 622

		objetoPasarela.setDatosTerceroTipoIdentificacion(
				this.appMessageSource.getMessage("pasarela.tipoIdentificacion", null, locale_castellano));
		objetoPasarela.setDatosTerceroDni(sancionado.getUanif()); // 14611614J
																	// 44100101Q
		// 72739383C
		objetoPasarela.setDatosTerceroNombreCompleto((sancionado.getUanombre() == null ? ""
				: sancionado.getUanombre().concat(" ")
						.concat(sancionado.getUaapellido1() == null ? "" : sancionado.getUaapellido1()).concat(" ")
						.concat(sancionado.getUaapellido2() == null ? "" : sancionado.getUaapellido2())).trim()); // Areizaga
																													// Sanchez,
		// Jorge

		objetoPasarela.setDatosTerceroDireccion(sancionado.getDireccionCompleta()); // avda
		// madariaga
		objetoPasarela.setDatosTerceroMunicipio(sancionado.getNombreMunicipio()); // bilbao
		objetoPasarela.setDatosTerceroLocalidad(sancionado.getNombreLocalidad()); // Bilbao
		objetoPasarela.setDatosTerceroProvincia(sancionado.getNombreProvincia()); // Bizkaia
		objetoPasarela.setDatosTerceroPais(sancionado.getNombrePais()); // Espaa
		objetoPasarela.setDatosTerceroCodigoPostal(sancionado.getCp()); // 48014
		objetoPasarela.setDatosTerceroCodMunicipio(sancionado.getUamunId());
		objetoPasarela.setDatosTerceroCodLocalidad(sancionado.getUalocId());
		objetoPasarela.setDatosTerceroCodProvincia(sancionado.getUaprovId());

		objetoPasarela.setDatosTerceroTelefono(sancionado.getUanrtel()); // 94125412
		objetoPasarela.setDatosTerceroTextoCastTelefono(
				this.appMessageSource.getMessage("pasarela.telefono", null, locale_castellano)); // "Tfnoa."
		objetoPasarela.setDatosTerceroTextoEuskTelefono(
				this.appMessageSource.getMessage("pasarela.telefono", null, locale_euskera)); // "Tfno."
		objetoPasarela.setDatosTerceroEmail(sancionado.getUacoem()); // jaraizaga@bilbomatica.es
		objetoPasarela.setDatosTerceroTextoCastEmail(
				this.appMessageSource.getMessage("pasarela.email", null, locale_castellano)); // "e-mail"
		objetoPasarela.setDatosTerceroTextoEuskEmail(
				this.appMessageSource.getMessage("pasarela.email", null, locale_euskera)); // "e-mail"
		objetoPasarela.setDatosTerceroTextoCastNumFactura(
				this.appMessageSource.getMessage("pasarela.factura", null, locale_castellano));
		objetoPasarela.setDatosTerceroTextoCastNumExp(
				this.appMessageSource.getMessage("pasarela.expediente", null, locale_castellano));
		objetoPasarela.setDatosTerceroTextoEuskNumFactura(
				this.appMessageSource.getMessage("pasarela.factura", null, locale_euskera));
		objetoPasarela.setDatosTerceroTextoEuskNumExp(
				this.appMessageSource.getMessage("pasarela.expediente", null, locale_euskera));
		objetoPasarela.setDatosTerceroApellido1(sancionado.getUaapellido1());
		objetoPasarela.setDatosTerceroApellido2(sancionado.getUaapellido2());
		objetoPasarela.setDatosTerceroNombre(sancionado.getUanombre());
		objetoPasarela.setDatosTerceroDeudorApremiable(null);
		objetoPasarela.setDatosTerceroResidente(null);

		// objetoPasarela.setMensajeCastCabecera(this.appMessageSource.getMessage(
		// "pasarela.mensajeCabecera", null, locale_castellano));
		// objetoPasarela.setMensajeEuskCabecera(this.appMessageSource.getMessage(
		// "pasarela.mensajeCabecera", null, locale_euskera));
		// objetoPasarela.setMensajeCastMedio(this.appMessageSource.getMessage(
		// "pasarela.mensajeMedio", null, locale_castellano));
		// objetoPasarela.setMensajeEuskMedio(this.appMessageSource.getMessage(
		// "pasarela.mensajeMedio", null, locale_euskera));
		// objetoPasarela.setMensajeCastPie(this.appMessageSource.getMessage(
		// "pasarela.mensajePie", null, locale_castellano));
		// objetoPasarela.setMensajeEuskPie(this.appMessageSource.getMessage(
		// "pasarela.mensajePie", null, locale_euskera));

		// Mensajes
		Map<String, Map<String, String>> listamensajes = new HashMap<String, Map<String, String>>();
		Map<String, String> maptextos1 = new HashMap<String, String>();
		maptextos1.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje1", null, locale_castellano));
		maptextos1.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje1", null, locale_euskera));
		listamensajes.put("1", maptextos1);

		Map<String, String> maptextos2 = new HashMap<String, String>();
		maptextos2.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje2", null, locale_castellano));
		maptextos2.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje2", null, locale_euskera));
		listamensajes.put("2", maptextos2);

		Map<String, String> maptextos3 = new HashMap<String, String>();
		maptextos3.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje3", null, locale_castellano));
		maptextos3.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje3", null, locale_euskera));
		listamensajes.put("3", maptextos3);

		Map<String, String> maptextos4 = new HashMap<String, String>();
		maptextos4.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje4", null, locale_castellano));
		maptextos4.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje4", null, locale_euskera));
		listamensajes.put("4", maptextos4);

		Map<String, String> maptextos5 = new HashMap<String, String>();
		maptextos5.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje5", null, locale_castellano));
		maptextos5.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje5", null, locale_euskera));
		listamensajes.put("5", maptextos5);
		// Fecha de resolucion del expediente
		Map<String, String> maptextos6 = new HashMap<String, String>();
		maptextos6.put(Y41bConstantes.CASTELLANO,
				Y41bUtils.formatearDateToString(fechaResolucion, Y41bConstantes.FORMATO_FECHA_ES));
		maptextos6.put(Y41bConstantes.EUSKERA,
				Y41bUtils.formatearDateToString(fechaResolucion, Y41bConstantes.FORMATO_FECHA_EU));
		listamensajes.put("6", maptextos6);
		Map<String, String> maptextos7 = new HashMap<String, String>();
		maptextos7.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje7", null, locale_castellano));
		maptextos7.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje7", null, locale_euskera));
		listamensajes.put("7", maptextos7);
		Map<String, String> maptextos8 = new HashMap<String, String>();
		String numLiquidacion = Y41bUtils.zeroPad(numReferencia.toString(), Y41bConstantes.NUM_11);
		maptextos8.put(Y41bConstantes.CASTELLANO, numLiquidacion);
		maptextos8.put(Y41bConstantes.EUSKERA, numLiquidacion);
		listamensajes.put("8", maptextos8);
		objetoPasarela.setListamensajes(listamensajes);

		// 1254-04 . Para nosotros puede que no sea obligatorio.
		objetoPasarela.setNumeroLiquidacion(numLiquidacion);// Lo
															// hemos
															// puesto
															// como
															// mensaje
															// generico
															// para
															// la
															// plantilla

		objetoPasarela.setCodAplicacion(Y41bConstantes.COD_APLICACION_PASARELA); // q92b
		objetoPasarela.setNombreCastAplicacion(
				this.appMessageSource.getMessage("pasarela.nombreAplicacion", null, locale_castellano)); // "Gestion
																											// de
																											// Expedientes
																											// KontsumoBIDE"
		objetoPasarela.setNombreEuskAplicacion(
				this.appMessageSource.getMessage("pasarela.nombreAplicacion", null, locale_euskera)); // "Gestion
																										// de
																										// Expedientes
																										// KontsumoBIDE"
		objetoPasarela.setResponsableAplicacion(Y41bConstantes.RESPONSABLE_APLICACION); // ejie
		objetoPasarela.setSessionID(null); // session id
		// numero de tercero de IKUS
		objetoPasarela.setTercero(null);

		/**
		 * Numero de cuenta
		 */
		objetoPasarela.setNumCuenta(null);
		/**
		 * Ejercicio contable
		 */
		objetoPasarela.setEjercicioContable(
				conceptoPago.getSdejercicio() == null ? null : conceptoPago.getSdejercicio().toString());

		/**
		 * Numero de referencia de la fianzas para la ejecucion
		 */
		objetoPasarela.setNumReferenciaAnticipoCuenta(null);

		return objetoPasarela;
	}

	/**
	 * Objeto pasarela de prueba.
	 * 
	 * @param conceptoPago
	 *            the concepto pago
	 * @param pago
	 *            the pago
	 * @param sancionado
	 *            the sancionado
	 * @param appPresupuestaria
	 *            the app presupuestaria
	 * @param fechaResolucion
	 *            the fecha resolucion
	 * @param numReferencia
	 *            the num referencia
	 * @param entidadEmisoraMunicipio
	 *            the entidad emisora municipio
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @return ObjPasarela
	 * @throws ParseException
	 *             the parse exception
	 */
	public ObjPasarela crearObjetoPasarelaOtrosIngresos(Conceptopago conceptoPago, Pagos pago, Saninterv sancionado,
			String appPresupuestaria, Date fechaResolucion, Long numReferencia, String entidadEmisoraMunicipio,
			String tipoDevengo) throws ParseException {
		ObjPasarela objetoPasarela = new ObjPasarela();

		Locale locale_castellano = new Locale(Y41bConstantes.CASTELLANO);
		Locale locale_euskera = new Locale(Y41bConstantes.EUSKERA);

		objetoPasarela.setCodsubvencion(pago.getSgcodsubvencion());
		objetoPasarela.setFechareintegro(
				Y41bUtils.formatearDateToString(pago.getSgfechareintegro(), Y41bConstantes.FORMATO_FECHA_PASARELA));
		objetoPasarela.setCausareintegro(pago.getSgcausareintegro());

		objetoPasarela.setEntidadEmisoraNombCast(
				this.appMessageSource.getMessage("pasarela.entidad", null, locale_castellano));
		objetoPasarela
				.setEntidadEmisoraNombEusk(this.appMessageSource.getMessage("pasarela.entidad", null, locale_euskera));
		objetoPasarela.setEntidadEmisoraMunicipio(entidadEmisoraMunicipio);
		objetoPasarela.setTipoAcceso(null); // 1-recibo Bancario 2- banca
											// electronica
		objetoPasarela.setIdioma(null); // 1-castellano 2- euskera
		objetoPasarela
				.setCodTasaCast(this.appMessageSource.getMessage("pasarela.descReintegro", null, locale_castellano)); // (73.03)
																														// Tasa
																														// de
																														// ...
		objetoPasarela.setCodTasaEusk(this.appMessageSource.getMessage("pasarela.descReintegro", null, locale_euskera)); // (73.03)Tasa
																															// de
																															// ...
		objetoPasarela.setReferencia(
				(new StringBuffer("").append(pago.getSgreferencia()).append(pago.getSgdigitocontrol())).toString()); // 9104000000112
		objetoPasarela.setIdentificacion(""); // 011204 ddMMyy
		objetoPasarela.setFechaIncioPago(
				Y41bUtils.formatearDateToString(pago.getSgfechaemision(), Y41bConstantes.FORMATO_FECHA_PASARELA)); // 311204
		// ddMMyy
		objetoPasarela.setFechaLimitePago(
				Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_PASARELA)); // 311204
		// ddMMyy
		objetoPasarela.setImporte(Y41bUtils.formatDouble2decimalesYcoma(pago.getSgimporte().doubleValue())); // 12,50
		objetoPasarela.setSufijo(conceptoPago.getSdsufijo().toString()); // 909
		objetoPasarela.setNumExpFactura(Y41bUtils.upToNCharacters(pago.getSgexpediente(), Y41bConstantes.NUM_25));
		objetoPasarela.setNumFactura("");
		objetoPasarela.setFamiliaID(null);
		objetoPasarela.setFormato(Y41bConstantes.FORMATO_PASARELA);
		objetoPasarela.setTipoDevengo(tipoDevengo); // PeticionPago.DEVENGO_EMISION
		objetoPasarela.setTerritorioHist(null);
		objetoPasarela.setFechaLimiteAnul(null); // Fecha limite de anulacin
													// del pago
		objetoPasarela.setImporteIVA("");
		objetoPasarela.setTipoIVA("");
		objetoPasarela.setBaseImponible(Y41bUtils.formatDouble2decimalesYcoma(pago.getSgimporte().doubleValue()));
		objetoPasarela.setCodigoConceptoIVA("");

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			objetoPasarela.setFechaIncioPagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechaemision(), Y41bConstantes.FORMATO_FECHA_EU));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimitePagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_EU));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimiteAnulLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_EU));

		} else {
			objetoPasarela.setFechaIncioPagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechaemision(), Y41bConstantes.FORMATO_FECHA_ES));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimitePagoLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_ES));
			// dd/MM/yyyy - esla que se guarda en BD
			objetoPasarela.setFechaLimiteAnulLiq(
					Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_ES));
		}

		objetoPasarela.setCodigoRecaudacion(Y41bConstantes.CPR); // 9050794

		objetoPasarela.setExentoPago(false); // true - exento de pago false - no
												// exento

		objetoPasarela.setEntidadEmisora(conceptoPago.getSdentemisora()); // 04833001

		objetoPasarela.setEntidadEmisoraNombCast(
				this.appMessageSource.getMessage("pasarela.entidadEmisora", null, locale_castellano)); // "KontsumoBIDE"
		objetoPasarela.setEntidadEmisoraNombEusk(
				this.appMessageSource.getMessage("pasarela.entidadEmisora", null, locale_euskera)); // "Gazteria
																									// Zuzendaritza";

		objetoPasarela.setConceptoAplicPresupuestaria(appPresupuestaria); // 2001020914000043126232220000J

		objetoPasarela.setConceptoCodigoIngreso(Y41bUtils.zeroPad(conceptoPago.getSdconceptoing().toString(), 2)); // 622

		objetoPasarela.setDatosTerceroTipoIdentificacion(
				this.appMessageSource.getMessage("pasarela.tipoIdentificacion", null, locale_castellano));
		objetoPasarela.setDatosTerceroDni(sancionado.getUanif()); // 14611614J
																	// 44100101Q
		// 72739383C
		objetoPasarela.setDatosTerceroNombreCompleto(sancionado.getUanombre()); // Areizaga
																				// Sanchez,
		// Jorge

		objetoPasarela.setDatosTerceroDireccion(sancionado.getDireccionCompleta()); // avda
		// madariaga
		objetoPasarela.setDatosTerceroMunicipio(sancionado.getNombreMunicipio()); // bilbao
		objetoPasarela.setDatosTerceroLocalidad(sancionado.getNombreLocalidad()); // Bilbao
		objetoPasarela.setDatosTerceroProvincia(sancionado.getNombreProvincia()); // Bizkaia
		objetoPasarela.setDatosTerceroPais(sancionado.getNombrePais()); // Espaa
		objetoPasarela.setDatosTerceroCodigoPostal(sancionado.getCp()); // 48014
		objetoPasarela.setDatosTerceroCodMunicipio(sancionado.getUamunId());
		objetoPasarela.setDatosTerceroCodLocalidad(sancionado.getUalocId());
		objetoPasarela.setDatosTerceroCodProvincia(sancionado.getUaprovId());

		objetoPasarela.setDatosTerceroTelefono(sancionado.getUanrtel()); // 94125412
		objetoPasarela.setDatosTerceroTextoCastTelefono(
				this.appMessageSource.getMessage("pasarela.telefono", null, locale_castellano)); // "Tfnoa."
		objetoPasarela.setDatosTerceroTextoEuskTelefono(
				this.appMessageSource.getMessage("pasarela.telefono", null, locale_euskera)); // "Tfno."
		objetoPasarela.setDatosTerceroEmail(sancionado.getUacoem()); // jaraizaga@bilbomatica.es
		objetoPasarela.setDatosTerceroTextoCastEmail(
				this.appMessageSource.getMessage("pasarela.email", null, locale_castellano)); // "e-mail"
		objetoPasarela.setDatosTerceroTextoEuskEmail(
				this.appMessageSource.getMessage("pasarela.email", null, locale_euskera)); // "e-mail"
		objetoPasarela.setDatosTerceroTextoCastNumFactura(
				this.appMessageSource.getMessage("pasarela.factura", null, locale_castellano));
		objetoPasarela.setDatosTerceroTextoCastNumExp(
				this.appMessageSource.getMessage("pasarela.expediente", null, locale_castellano));
		objetoPasarela.setDatosTerceroTextoEuskNumFactura(
				this.appMessageSource.getMessage("pasarela.factura", null, locale_euskera));
		objetoPasarela.setDatosTerceroTextoEuskNumExp(
				this.appMessageSource.getMessage("pasarela.expediente", null, locale_euskera));
		objetoPasarela.setDatosTerceroApellido1(null);
		objetoPasarela.setDatosTerceroApellido2(null);
		objetoPasarela.setDatosTerceroNombre(sancionado.getUanombre());
		objetoPasarela.setDatosTerceroDeudorApremiable(null);
		objetoPasarela.setDatosTerceroResidente(null);

		// objetoPasarela.setMensajeCastCabecera(this.appMessageSource.getMessage(
		// "pasarela.mensajeCabecera", null, locale_castellano));
		// objetoPasarela.setMensajeEuskCabecera(this.appMessageSource.getMessage(
		// "pasarela.mensajeCabecera", null, locale_euskera));
		// objetoPasarela.setMensajeCastMedio(this.appMessageSource.getMessage(
		// "pasarela.mensajeMedio", null, locale_castellano));
		// objetoPasarela.setMensajeEuskMedio(this.appMessageSource.getMessage(
		// "pasarela.mensajeMedio", null, locale_euskera));
		// objetoPasarela.setMensajeCastPie(this.appMessageSource.getMessage(
		// "pasarela.mensajePie", null, locale_castellano));
		// objetoPasarela.setMensajeEuskPie(this.appMessageSource.getMessage(
		// "pasarela.mensajePie", null, locale_euskera));

		// Mensajes
		Map<String, Map<String, String>> listamensajes = new HashMap<String, Map<String, String>>();
		Map<String, String> maptextos1 = new HashMap<String, String>();
		maptextos1.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje1", null, locale_castellano));
		maptextos1.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje1", null, locale_euskera));
		listamensajes.put("1", maptextos1);

		// Map<String, String> maptextos2 = new HashMap<String, String>();
		// maptextos2.put(Y41bConstantes.CASTELLANO, this.appMessageSource
		// .getMessage("pasarela.mensaje2", null, locale_castellano));
		// maptextos2.put(Y41bConstantes.EUSKERA, this.appMessageSource
		// .getMessage("pasarela.mensaje2", null, locale_euskera));
		// listamensajes.put("2", maptextos2);

		Map<String, String> maptextos2 = new HashMap<String, String>();
		maptextos2.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje2bis", null, locale_castellano));
		maptextos2.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje2bis", null, locale_euskera));
		listamensajes.put("2", maptextos2);

		// Map<String, String> maptextos3 = new HashMap<String, String>();
		// maptextos3.put(Y41bConstantes.CASTELLANO, this.appMessageSource
		// .getMessage("pasarela.mensaje3", null, locale_castellano));
		// maptextos3.put(Y41bConstantes.EUSKERA, this.appMessageSource
		// .getMessage("pasarela.mensaje3", null, locale_euskera));
		// listamensajes.put("3", maptextos3);
		//
		// Map<String, String> maptextos4 = new HashMap<String, String>();
		// maptextos4.put(Y41bConstantes.CASTELLANO, this.appMessageSource
		// .getMessage("pasarela.mensaje4", null, locale_castellano));
		// maptextos4.put(Y41bConstantes.EUSKERA, this.appMessageSource
		// .getMessage("pasarela.mensaje4", null, locale_euskera));
		// listamensajes.put("4", maptextos4);

		listamensajes.put("3", null);
		listamensajes.put("4", null);

		Map<String, String> maptextos5 = new HashMap<String, String>();
		maptextos5.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje5", null, locale_castellano));
		maptextos5.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje5", null, locale_euskera));
		listamensajes.put("5", maptextos5);
		// Fecha de resolucion del expediente
		Map<String, String> maptextos6 = new HashMap<String, String>();
		maptextos6.put(Y41bConstantes.CASTELLANO,
				Y41bUtils.formatearDateToString(fechaResolucion, Y41bConstantes.FORMATO_FECHA_ES));
		maptextos6.put(Y41bConstantes.EUSKERA,
				Y41bUtils.formatearDateToString(fechaResolucion, Y41bConstantes.FORMATO_FECHA_EU));
		listamensajes.put("6", maptextos6);
		Map<String, String> maptextos7 = new HashMap<String, String>();
		maptextos7.put(Y41bConstantes.CASTELLANO,
				this.appMessageSource.getMessage("pasarela.mensaje7", null, locale_castellano));
		maptextos7.put(Y41bConstantes.EUSKERA,
				this.appMessageSource.getMessage("pasarela.mensaje7", null, locale_euskera));
		listamensajes.put("7", maptextos7);
		Map<String, String> maptextos8 = new HashMap<String, String>();
		String numLiquidacion = Y41bUtils.zeroPad(numReferencia.toString(), Y41bConstantes.NUM_11);
		maptextos8.put(Y41bConstantes.CASTELLANO, numLiquidacion);
		maptextos8.put(Y41bConstantes.EUSKERA, numLiquidacion);
		listamensajes.put("8", maptextos8);
		objetoPasarela.setListamensajes(listamensajes);

		// 1254-04 . Para nosotros puede que no sea obligatorio.
		objetoPasarela.setNumeroLiquidacion(numLiquidacion);// Lo
															// hemos
															// puesto
															// como
															// mensaje
															// generico
															// para
															// la
															// plantilla

		objetoPasarela.setCodAplicacion(Y41bConstantes.COD_APLICACION_PASARELA); // q92b
		objetoPasarela.setNombreCastAplicacion(
				this.appMessageSource.getMessage("pasarela.nombreAplicacion", null, locale_castellano)); // "Gestion
																											// de
																											// Expedientes
																											// KontsumoBIDE"
		objetoPasarela.setNombreEuskAplicacion(
				this.appMessageSource.getMessage("pasarela.nombreAplicacion", null, locale_euskera)); // "Gestion
																										// de
																										// Expedientes
																										// KontsumoBIDE"
		objetoPasarela.setResponsableAplicacion(Y41bConstantes.RESPONSABLE_APLICACION); // ejie
		objetoPasarela.setSessionID(null); // session id
		// numero de tercero de IKUS
		objetoPasarela.setTercero(null);

		/**
		 * Numero de cuenta
		 */
		objetoPasarela.setNumCuenta(null);
		/**
		 * Ejercicio contable
		 */
		objetoPasarela.setEjercicioContable(
				conceptoPago.getSdejercicio() == null ? null : conceptoPago.getSdejercicio().toString());

		/**
		 * Numero de referencia de la fianzas para la ejecucion
		 */
		objetoPasarela.setNumReferenciaAnticipoCuenta(null);

		return objetoPasarela;
	}

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param tramiteComun
	 *            the tramite comun
	 * @param request
	 *            the request
	 * @param fecha
	 *            the fecha
	 * @param concepto
	 *            the concepto
	 * @param response
	 *            the response
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	public void generarDocLiquidacion(TramiteComun tramiteComun, HttpServletRequest request, String fecha,
			String concepto, HttpServletResponse response, String tipoDevengo, String nombre, String apellido1,
			String apellido2) throws Exception {

		this.generarDocumentoPasarelaPagos(tramiteComun, request, fecha, concepto, response, tipoDevengo, nombre,
				apellido1, apellido2);
	}

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param saninterv
	 *            Saninterv
	 * @param request
	 *            the request
	 * @param response
	 *            the response
	 * @throws Exception
	 *             the exception
	 */
	public void generarDocOtrosIngresos(Pagos pagos, Saninterv saninterv, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		this.generarDocumentoPasarelaPagosOtrosIngresos(pagos, saninterv, request, response);
	}

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param tramiteComun
	 *            the tramite comun
	 * @param request
	 *            the request
	 * @param fecha
	 *            the fecha
	 * @param concepto
	 *            the concepto
	 * @param response
	 *            the response
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	public void generarDocResolucionComplementaria(TramiteComun tramiteComun, HttpServletRequest request, String fecha,
			String concepto, HttpServletResponse response, String tipoDevengo, String nombre, String apellido1,
			String apellido2) throws Exception {

		this.generarDocumentoPasarelaPagos(tramiteComun, request, fecha, concepto, response, tipoDevengo, nombre,
				apellido1, apellido2);
	}

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param tramiteComun
	 *            the tramite comun
	 * @param request
	 *            the request
	 * @param fecha
	 *            the fecha
	 * @param concepto
	 *            the concepto
	 * @param response
	 *            the response
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	private void generarDocumentoPasarelaPagos(TramiteComun tramiteComun, HttpServletRequest request, String fecha,
			String concepto, HttpServletResponse response, String tipoDevengo, String nombre, String apellido1,
			String apellido2) throws Exception {

		try {
			Y41bSipcaServiceImpl.logger.info("Inicio. generarDocumentoPasarelaPagos().");

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteSANLiquidacion tramite = new TramiteSANLiquidacion();
			tramite.setIdTramite(tramiteComun.getIdTramite());

			tramite = this.sanTramExpService.findTramiteLiquidacion(tramite, censoMonitor);

			Pasarela pasarela = new Pasarela();
			ConstPasarela constPasarela = new ConstPasarela(null, null, null);
			constPasarela.setUrlImagenCabecera(this.appConfiguration.getProperty("URL_IMAGEN_CABECERA"));
			constPasarela.setUrlImagenMedio(this.appConfiguration.getProperty("URL_IMAGEN_MEDIO"));
			constPasarela.setUrlVueltaApp(this.appConfiguration.getProperty("URL_VUELTA"));
			String tipoCanal = Y41bConstantes.PASARELA_CANAL_NOTIFICACION_POSTAL;
			List<PeticionPago> peticionPagoList = new ArrayList<PeticionPago>();

			com.ejie.y41b.model.platea.Procedure procedure = new com.ejie.y41b.model.platea.Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Antes de obtenerDatosCatalogoProcedimientos");
			ProcedureDocument procedureDocument = null;

			if (Y41bUtils.interactuarConDokusi()) {
				procedureDocument = this.y41bPlateaAdapterService.obtenerDatosCatalogoProcedimientos(procedure);
				Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Despues de obtenerDatosCatalogoProcedimientos"
						+ procedureDocument.toString() + ".");
			} else {
				Y41bSipcaServiceImpl.logger.info("****QUITADA LLAMADA A PLATEA");
			}

			List<ConceptosPago> conceptosPagos = new ArrayList<ConceptosPago>();
			Conceptopago conceptoPagoAux = new Conceptopago();
			conceptoPagoAux.setSdcodigo(concepto);
			conceptoPagoAux = this.conceptopagoService.find(conceptoPagoAux);

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Despues de Concepto Pago");

			ConceptosPago conceptosPago = new ConceptosPago();

			Expedien expedien = new Expedien();
			expedien.setExcodigo(tramiteComun.getIdExpediente());
			expedien = this.expedienService.find(expedien);

			Date fechaResolucion = null;
			if (expedien.getExferes() != null) {
				fechaResolucion = expedien.getExferes();
			} else if (expedien.getSanexp().getExfecpropreso() != null) {
				fechaResolucion = expedien.getSanexp().getExfecpropreso();
			} else if (expedien.getExfeacin() != null) {
				fechaResolucion = expedien.getExfeacin();
			}

			String idTerritorio = "";
			if (expedien.getSanexp().getExcooractual().length() > 1) {
				idTerritorio = expedien.getSanexp().getExcooractual().substring(0, 2);
			}
			if (idTerritorio != null) {
				Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Territorio: " + idTerritorio + ".");
			} else {
				Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Territorio: NULL..");
			}

			boolean superadaFechaEIKA = parametrosDao.superadaFechaEIKA();
			if (Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(idTerritorio)) {
				conceptosPago.setAppPresupuestaria(conceptoPagoAux.getSdaplicpresup01());
				if (superadaFechaEIKA) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_ARABA);
					conceptosPago.setElementoPEP(conceptoPagoAux.getSdelementoPEP01());
				}
			} else if (Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA.equals(idTerritorio)) {
				conceptosPago.setAppPresupuestaria(conceptoPagoAux.getSdaplicpresup20());
				if (superadaFechaEIKA) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_GIPUZKOA);
					conceptosPago.setElementoPEP(conceptoPagoAux.getSdelementoPEP20());
				}
			} else if (Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(idTerritorio)) {
				conceptosPago.setAppPresupuestaria(conceptoPagoAux.getSdaplicpresup48());
				if (superadaFechaEIKA) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_BIZKAIA);
					conceptosPago.setElementoPEP(conceptoPagoAux.getSdelementoPEP48());
				}
			} else {
				conceptosPago.setAppPresupuestaria(conceptoPagoAux.getSdaplicpresup());
				if (superadaFechaEIKA) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_SIN_TERRITORIALIZAR);
					conceptosPago.setElementoPEP(conceptoPagoAux.getSdelementoPEP());
				}
			}
			conceptosPago.setNumLinea(1);
			conceptosPago.setBackEndDataID("");
			conceptosPago.setBackEndDataValue("");
			// BigDecimal importe = sanTramExpService
			// .getImporteResolucion(tramiteComun.getIdExpediente());
			String importeString = tramite.getImporteSancion().replace('\u002c', '\u002e');

			BigDecimal importe = new BigDecimal(importeString);

			conceptosPago.setImporteConcepto(importe.toString());
			conceptosPago.setDescConceptoCas(conceptoPagoAux.getSddesces());
			conceptosPago.setDescConceptoEus(conceptoPagoAux.getSddesdeu());
			conceptosPago.setCodigoIngreso(
					Y41bUtils.zeroPad(conceptoPagoAux.getSdconceptoing().toString(), Y41bConstantes.NUM_6));
			conceptosPago.setImporteConceptoIVA("");
			conceptosPago.setTipoIVA("");
			conceptosPagos.add(conceptosPago);

			Saninterv sancionado = this.obtenerSancionado(tramiteComun.getIdExpediente());
			// en pasarela se desglosa el nombrey apellidos, si no es necesario
			// desglosar vienen 0's
			Pagos pago = new Pagos();
			if (!"0".equals(nombre) && !"0".equals(apellido1) && !"0".equals(apellido2)) {
				sancionado.setUanombre(nombre);
				sancionado.setUaapellido1(apellido1);
				sancionado.setUaapellido2(apellido2);
				pago.setSgnombre(nombre);
				pago.setSgapellido1(apellido1);
				pago.setSgapellido2(apellido2);
			}
			// El nombre del sancionado no puede superar 40 caracteres
			if (sancionado.getUanombre().length() > Y41bConstantes.NUM_40) {
				sancionado.setUanombre(sancionado.getUanombre().substring(0, Y41bConstantes.NUM_40));
				pago.setSgnombre(sancionado.getUanombre());
			}

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Antes de getNewReferencia().");

			Long numReferencia = this.pagosService.getNewReferencia();

			Y41bSipcaServiceImpl.logger
					.info("Documento liquidacin. Pasarela getNewReferencia " + numReferencia.toString());
			String referencia = Y41bUtils.zeroPad(numReferencia.toString(), Y41bConstantes.NUM_11);

			pago.setSgcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			pago.setSgreferencia(referencia);
			pago.setSgimporte(importe);
			pago.setSgfechaemision(Y41bUtils.obtenerFechaHoy());
			pago.setSgfechalimitepago(
					Y41bUtils.formatearStringToDateFormato(fecha, Y41bConstantes.FORMATO_FECHA_BASE_PASARELA));
			pago.setSgexpediente(expedien.damecodCompletoPlatea());
			pago.setSgidexpediente(tramiteComun.getIdExpediente());
			pago.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
			pago.setSgestablecimiento(new Establecimiento(sancionado.getUaescodigo()));
			pago.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_PP, null, null));
			pago.setSgfechaestado(Y41bUtils.obtenerFechaHoy());
			pago.setConceptopago(conceptoPagoAux);
			pago.setMetodopago(new Metodopago(Y41bConstantes.PAGO_LIQUIDACION, null, null));
			if (Y41bConstantes.VALOR_SI.equals(tramite.getProntoPago())) {
				pago.setSgprontopago(tramite.getProntoPago());
			}
			// Calcular referencia de 13 digitos
			String importeCent = Y41bUtils.transformarEurosACents(importe);
			String fechaFin = Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(),
					Y41bConstantes.FORMATO_FECHA_PASARELA);
			referencia = Y41bFuncionesSipca.referenciaDigitoControl(referencia, conceptoPagoAux.getSdentemisora(),
					conceptoPagoAux.getSdsufijo().toString(), importeCent, fechaFin);
			String digitoControl = referencia.substring(referencia.length() - 2, referencia.length());
			pago.setSgdigitocontrol(digitoControl);

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. ReferenciaDigitoControl " + referencia);
			String entidadEmisoraMunicipio = censoMonitor.getOrganismo().getNombreMunicipio();

			String resultado = "";
			if (Y41bUtils.interactuarConDokusi()) {

				Y41bSipcaServiceImpl.logger.info(".Antes de crearObjetoPasarela -> OK: " + resultado);

				ObjPasarela objetoPasarela = this.crearObjetoPasarela(tramite, conceptoPagoAux, pago,
						conceptosPago.getAppPresupuestaria(), sancionado, fechaResolucion, numReferencia,
						entidadEmisoraMunicipio, tipoDevengo);
				PeticionPago peticionPago = pasarela.composePeticionPago(objetoPasarela,
						procedureDocument.getProcedure(), conceptosPagos);
				peticionPagoList.add(peticionPago);
				Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Pasarela composePeticionPago");
				resultado = pasarela.enviarPago(constPasarela, request, response, tipoCanal, peticionPagoList);
			} else {
				resultado = "";
			}

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Pasarela EnvioPago -> OK: " + resultado);
			/*
			 * CAmpos que no se envian this.sgcodigo = sgcodigo;
			 * this.sgfechapago = sgfechapago; this.sgfraccionado =
			 * sgfraccionado; this.sgdescripcionpago = sgdescripcionpago;
			 * this.sgobservaciones = sgobservaciones; this.sgdigitocontrol =
			 * sgdigitocontrol; this.sgreferenciafracc = sgreferenciafracc;
			 * this.sgimporteinteres = sgimporteinteres; this.sgnumfraccion =
			 * sgnumfraccion;
			 */

			this.pagosService.emisionLiquidacion(pago);
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(tramite.getIdTramite());
			santramexp.setTrreferencia(referencia);
			this.sanTramExpService.updateReferenciaLiquidacion(santramexp);

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Pasarela EmisionLiquidacion");
		} catch (Exception e) {
			Y41bSipcaServiceImpl.logger.error(".LIQUIDACION. ERROR " + e.getMessage());
			throw (e);
		}
	}

	/**
	 * Obtener sancionado.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return the saninterv
	 */
	private Saninterv obtenerSancionado(String excodigo) {
		Y41bSipcaServiceImpl.logger.info("[GET - getById] : Inicio obtenerSancionado" + excodigo + ".");
		try {
			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(excodigo, null, null, null, null, null, null, null, null));
			saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			List<Saninterv> listaSaninterv = this.sanintervService.findAll(saninterv, null);

			Y41bSipcaServiceImpl.logger.info("[GET - getById] : Inicio obtenerSancionado");

			if (listaSaninterv != null) {
				if (listaSaninterv.size() == 1) {

					saninterv = listaSaninterv.get(0);
					Y41bSipcaServiceImpl.logger.info("[GET - getById] : uaidinterv" + saninterv.getUaidinterv() + ".");
					return this.obtenerSanintervDireccion(saninterv);

				} else {
					Y41bSipcaServiceImpl.logger.info("too much data found");
				}
			} else {
				Y41bSipcaServiceImpl.logger.info("[GET - getById] : No data found");
			}
		} catch (Exception e) {
			Y41bSipcaServiceImpl.logger.error("[GET - getById] : ERROR obtenerSancionado. " + e.getMessage() + ".");
		}
		Y41bSipcaServiceImpl.logger.info("[GET - getById] : Fin obtenerSancionado");
		return null;
	}

	/**
	 * @param saninterv
	 *            Saninterv
	 * 
	 * @return Saninterv
	 */
	private Saninterv obtenerSanintervDireccion(Saninterv saninterv) {
		if (saninterv.getUapaisId() != null) {
			try {
				Y41bSipcaServiceImpl.logger.info("[GET - getById] : PAIS " + saninterv.getUapaisId() + ".");
				saninterv.setNombrePais(this.t17PaisService.find(new T17Pais(saninterv.getUapaisId(), null)).getDsO());
			} catch (Exception e) {
				saninterv.setNombrePais("");
			}
		}
		if (saninterv.getUaprovId() != null) {
			try {
				Y41bSipcaServiceImpl.logger.info("[GET - getById] : PROVINCIA " + saninterv.getUaprovId() + ".");
				saninterv.setNombreProvincia(
						this.t17ProvinciaService.find(new T17Provincia(saninterv.getUaprovId(), null, null)).getDsO());
			} catch (Exception e) {
				saninterv.setNombreProvincia("");
			}
		}
		if (saninterv.getUamunId() != null && saninterv.getUaprovId() != null) {
			try {
				Y41bSipcaServiceImpl.logger.info("[GET - getById] : MUNICIPIO " + saninterv.getUamunId() + ".");
				T17Municipio municipio = this.municipioService
						.find(new T17Municipio(saninterv.getUamunId(), saninterv.getUaprovId(), "", ""));
				saninterv.setNombreMunicipio(municipio.getDsO());
			} catch (Exception e) {
				saninterv.setNombreMunicipio("");
			}
		}
		if (saninterv.getUalocId() != null && saninterv.getUamunId() != null && saninterv.getUaprovId() != null) {
			try {
				Y41bSipcaServiceImpl.logger.info("[GET - getById] : LOCALIDAD " + saninterv.getUalocId() + "."
						+ saninterv.getUamunId() + "." + saninterv.getUaprovId() + ".");
				saninterv.setNombreLocalidad(this.t17LocalidadService.find(new T17Localidad(saninterv.getUalocId(),
						null, saninterv.getUamunId(), saninterv.getUaprovId(), null)).getDsO());
			} catch (Exception e) {
				saninterv.setNombreLocalidad("");
			}
		}
		Y41bSipcaServiceImpl.logger.info("[GET - getById] : ANTES DE DIRECCION ");
		StringBuffer direccion = new StringBuffer();
		T17Portal t17portal = new T17Portal();
		if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUadireNocapv())) {
			Y41bSipcaServiceImpl.logger.info("[GET - getById] : Direccion.1. " + saninterv.getUadireNocapv() + ".");
			direccion.append(saninterv.getUadireNocapv());
		} else if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUacalleId())) {
			Y41bSipcaServiceImpl.logger.info("[GET - getById] : Direccion.2. " + saninterv.getUacalleId() + ".");

			String calle = "";

			calle = this.t17CalleService.find(new T17Calle(Long.parseLong(saninterv.getUacalleId()), null)).getDsO();
			if (saninterv.getUaportalId() != null) {

				t17portal = this.t17PortalService.find(Long.parseLong(saninterv.getUaportalId()));
				if (t17portal != null && t17portal.getPortal() != null) {
					direccion.append(" ")
							.append(Y41bUtils.componerDireccion(calle, t17portal.getBloque(), t17portal.getPortal(),
									t17portal.getNumero(), t17portal.getBis(), saninterv.getUanombrePiso(),
									saninterv.getUanodir()));
				} else if (t17portal != null && t17portal.getNumero() != 0) {
					direccion.append(calle);
					direccion.append(" ");
					direccion.append(t17portal.getNumero());
				} else {
					direccion.append(calle);
				}
			} else {
				if (calle != null && calle.length() > 0) {
					direccion.append(calle);
				}
			}

		} else if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
			Y41bSipcaServiceImpl.logger.info("[GET - getById] : Direccion.3. " + saninterv.getUanodir() + ".");
			direccion.append(saninterv.getUanodir());
		}
		Y41bSipcaServiceImpl.logger.info("[GET - getById] : FIN DE DIRECCION " + direccion + ".");
		saninterv.setDireccionCompleta(direccion.toString());
		if (t17portal != null) {
			Y41bSipcaServiceImpl.logger.info("[GET - getById] : CP: " + t17portal.getCodigoPostal() + ".");
			saninterv.setCp(t17portal.getCodigoPostal());
		}

		return saninterv;
	}

	/**
	 * 
	 * @param pago
	 *            Pagos
	 * @param sanintervAux
	 *            Saninterv
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @throws Exception
	 *             Exception
	 */
	private void generarDocumentoPasarelaPagosOtrosIngresos(Pagos pago, Saninterv sanintervAux,
			HttpServletRequest request, HttpServletResponse response) throws Exception {

		try {
			Y41bSipcaServiceImpl.logger.info("Inicio. generarDocumentoPasarelaPagosOtrosIngresos().");

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Pasarela pasarela = new Pasarela();
			ConstPasarela constPasarela = new ConstPasarela(null, null, null);
			constPasarela.setUrlImagenCabecera(this.appConfiguration.getProperty("URL_IMAGEN_CABECERA"));
			constPasarela.setUrlImagenMedio(this.appConfiguration.getProperty("URL_IMAGEN_MEDIO"));
			constPasarela.setUrlVueltaApp(this.appConfiguration.getProperty("URL_VUELTA"));
			String tipoCanal = Y41bConstantes.PASARELA_CANAL_NOTIFICACION_POSTAL;
			List<PeticionPago> peticionPagoList = new ArrayList<PeticionPago>();

			com.ejie.y41b.model.platea.Procedure procedure = new com.ejie.y41b.model.platea.Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Antes de obtenerDatosCatalogoProcedimientos");
			ProcedureDocument procedureDocument = null;

			if (Y41bUtils.interactuarConDokusi()) {
				procedureDocument = this.y41bPlateaAdapterService.obtenerDatosCatalogoProcedimientos(procedure);
				Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Despues de obtenerDatosCatalogoProcedimientos"
						+ procedureDocument.toString() + ".");
			} else {
				Y41bSipcaServiceImpl.logger.info("****QUITADA LLAMADA A PLATEA");
			}

			List<ConceptosPago> conceptosPagos = new ArrayList<ConceptosPago>();
			Conceptopago conceptoPagoAux = new Conceptopago();
			conceptoPagoAux.setSdcodigo(pago.getConceptopago().getSdcodigo());
			conceptoPagoAux = this.conceptopagoService.find(conceptoPagoAux);

			Conceptopago conceptoPagoInteresAux = new Conceptopago();
			if (pago.getConceptopagoInteres() != null && pago.getConceptopagoInteres().getSdcodigo() != null) {
				conceptoPagoInteresAux.setSdcodigo(pago.getConceptopagoInteres().getSdcodigo());
				conceptoPagoInteresAux = this.conceptopagoService.find(conceptoPagoInteresAux);
			}

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Despues de Concepto Pago");

			ConceptosPago conceptosPago = new ConceptosPago();
			conceptosPago.setAppPresupuestaria(pago.getSgaplicpresupuestaria());
			boolean superadaFechaEIKA = parametrosDao.superadaFechaEIKA();
			if (superadaFechaEIKA) {
				if (pago.getSgaplicpresupuestaria().equalsIgnoreCase(conceptoPagoAux.getSdaplicpresup01())) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_ARABA);
					conceptosPago.setElementoPEP(pago.getConceptopago().getSdelementoPEP01());
				} else if (pago.getSgaplicpresupuestaria().equalsIgnoreCase(conceptoPagoAux.getSdaplicpresup20())) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_GIPUZKOA);
					conceptosPago.setElementoPEP(pago.getConceptopago().getSdelementoPEP20());
				} else if (pago.getSgaplicpresupuestaria().equalsIgnoreCase(conceptoPagoAux.getSdaplicpresup48())) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_BIZKAIA);
					conceptosPago.setElementoPEP(pago.getConceptopago().getSdelementoPEP48());
				} else if (pago.getSgaplicpresupuestaria().equalsIgnoreCase(conceptoPagoAux.getSdaplicpresup())) {
					conceptosPago.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_SIN_TERRITORIALIZAR);
					conceptosPago.setElementoPEP(pago.getConceptopago().getSdelementoPEP());
				}
			}
			conceptosPago.setNumLinea(1);
			conceptosPago.setBackEndDataID("");
			conceptosPago.setBackEndDataValue("");

			BigDecimal importe = pago.getSgimporte();

			if (importe == null) {
				conceptosPago.setImporteConcepto(null);
			} else {
				conceptosPago.setImporteConcepto(importe.toString());
			}
			conceptosPago.setDescConceptoCas(conceptoPagoAux.getSddesces());
			conceptosPago.setDescConceptoEus(conceptoPagoAux.getSddesdeu());
			conceptosPago.setCodigoIngreso(
					Y41bUtils.zeroPad(conceptoPagoAux.getSdconceptoing().toString(), Y41bConstantes.NUM_6));
			conceptosPago.setImporteConceptoIVA("");
			conceptosPago.setTipoIVA("");
			conceptosPagos.add(conceptosPago);

			BigDecimal importeinteres = pago.getSgimporteinteres();
			if (pago.getSgaplicpresupinteres() != null && conceptoPagoInteresAux != null
					&& conceptoPagoInteresAux.getSdconceptoing() != null) {
				ConceptosPago conceptosPagoInteres = new ConceptosPago();
				conceptosPagoInteres.setAppPresupuestaria(pago.getSgaplicpresupinteres());
				if (superadaFechaEIKA) {
					if (pago.getSgaplicpresupinteres().equalsIgnoreCase(conceptoPagoInteresAux.getSdaplicpresup01())) {
						conceptosPagoInteres.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_ARABA);
						conceptosPagoInteres.setElementoPEP(pago.getConceptopago().getSdelementoPEP01());
					} else if (pago.getSgaplicpresupinteres()
							.equalsIgnoreCase(conceptoPagoInteresAux.getSdaplicpresup20())) {
						conceptosPagoInteres.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_GIPUZKOA);
						conceptosPagoInteres.setElementoPEP(pago.getConceptopago().getSdelementoPEP20());
					} else if (pago.getSgaplicpresupinteres()
							.equalsIgnoreCase(conceptoPagoInteresAux.getSdaplicpresup48())) {
						conceptosPagoInteres.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_BIZKAIA);
						conceptosPagoInteres.setElementoPEP(pago.getConceptopago().getSdelementoPEP48());
					} else if (pago.getSgaplicpresupinteres()
							.equalsIgnoreCase(conceptoPagoInteresAux.getSdaplicpresup())) {
						conceptosPagoInteres
								.setTerritorioAppPresupuestaria(Y41bSipcaServiceImpl.CODIGO_SIPCA_SIN_TERRITORIALIZAR);
						conceptosPagoInteres.setElementoPEP(pago.getConceptopago().getSdelementoPEP());
					}
				}
				conceptosPagoInteres.setNumLinea(2);
				conceptosPagoInteres.setBackEndDataID("");
				conceptosPagoInteres.setBackEndDataValue("");

				if (importeinteres == null) {
					conceptosPagoInteres.setImporteConcepto(null);
				} else {
					conceptosPagoInteres.setImporteConcepto(importeinteres.toString());
				}
				conceptosPagoInteres.setDescConceptoCas(conceptoPagoInteresAux.getSddesces());
				conceptosPagoInteres.setDescConceptoEus(conceptoPagoInteresAux.getSddesdeu());
				conceptosPagoInteres.setCodigoIngreso(
						Y41bUtils.zeroPad(conceptoPagoInteresAux.getSdconceptoing().toString(), Y41bConstantes.NUM_6));
				conceptosPagoInteres.setImporteConceptoIVA("");
				conceptosPagoInteres.setTipoIVA("");
				conceptosPagos.add(conceptosPagoInteres);
			}
			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Antes de getNewReferencia().");

			Long numReferencia = this.pagosService.getNewReferencia();

			Y41bSipcaServiceImpl.logger
					.info("Documento liquidacin. Pasarela getNewReferencia " + numReferencia.toString());
			String referencia = Y41bUtils.zeroPad(numReferencia.toString(), Y41bConstantes.NUM_11);

			pago.setSgcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			pago.setSgreferencia(referencia);
			pago.setSgimporte(importeinteres == null ? importe : importe.add(importeinteres));
			pago.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
			pago.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_PP, null, null));
			pago.setSgfechaestado(Y41bUtils.obtenerFechaHoy());
			pago.setConceptopago(conceptoPagoAux);
			pago.setMetodopago(new Metodopago(Y41bConstantes.PAGO_LIQUIDACION, null, null));
			// Calcular referencia de 13 digitos
			// Sumamos el importe ms los intereses si no son null
			String importeCent = Y41bUtils.transformarEurosACents(pago.getSgimporte());

			String fechaFin = Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(),
					Y41bConstantes.FORMATO_FECHA_PASARELA);
			referencia = Y41bFuncionesSipca.referenciaDigitoControl(referencia, conceptoPagoAux.getSdentemisora(),
					conceptoPagoAux.getSdsufijo().toString(), importeCent, fechaFin);
			String digitoControl = referencia.substring(referencia.length() - 2, referencia.length());
			pago.setSgdigitocontrol(digitoControl);

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. ReferenciaDigitoControl " + referencia);
			String entidadEmisoraMunicipio = censoMonitor.getOrganismo().getNombreMunicipio();

			Saninterv saninterv = this.obtenerSanintervDireccion(sanintervAux);
			String resultado = "";
			if (Y41bUtils.interactuarConDokusi()) {

				Y41bSipcaServiceImpl.logger.info(".Antes de crearObjetoPasarela -> OK: " + resultado);

				ObjPasarela objetoPasarela = this.crearObjetoPasarelaOtrosIngresos(conceptoPagoAux, pago, saninterv,
						conceptosPago.getAppPresupuestaria(), pago.getSgfechaemision(), numReferencia,
						entidadEmisoraMunicipio, PeticionPago.DEVENGO_EMISION);
				PeticionPago peticionPago = pasarela.composePeticionPago(objetoPasarela,
						procedureDocument.getProcedure(), conceptosPagos);
				peticionPagoList.add(peticionPago);
				Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Pasarela composePeticionPago");
				resultado = pasarela.enviarPago(constPasarela, request, response, tipoCanal, peticionPagoList);
			} else {
				resultado = "";
			}

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Pasarela EnvioPago -> OK: " + resultado);
			/*
			 * CAmpos que no se envian this.sgcodigo = sgcodigo;
			 * this.sgfechapago = sgfechapago; this.sgfraccionado =
			 * sgfraccionado; this.sgdescripcionpago = sgdescripcionpago;
			 * this.sgobservaciones = sgobservaciones; this.sgdigitocontrol =
			 * sgdigitocontrol; this.sgreferenciafracc = sgreferenciafracc;
			 * this.sgimporteinteres = sgimporteinteres; this.sgnumfraccion =
			 * sgnumfraccion;
			 */

			this.pagosService.emisionLiquidacion(pago);

			Y41bSipcaServiceImpl.logger.info(".LIQUIDACION. Pasarela EmisionLiquidacion");
		} catch (Exception e) {
			Y41bSipcaServiceImpl.logger.error(".LIQUIDACION. ERROR " + e.getMessage());
			throw (e);
		}
	}
}