package com.ejie.y41b.adapter.services;

import java.text.ParseException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.y41b.model.*;
import com.ejie.y41b.model.pasarela.ObjPasarela;

/**
 * Y41bSipcaServiceImpl.
 * 
 *  
 */

public interface Y41bSipcaService {

	/**
	 * Objeto pasarela de prueba.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param conceptoPago
	 *            the concepto pago
	 * @param pago
	 *            the pago
	 * @param appPresupuestaria
	 *            the app presupuestaria
	 * @param sancionado
	 *            the sancionado
	 * @param fechaResolucion
	 *            the fecha resolucion
	 * @param numReferencia
	 *            the num referencia
	 * @param entidadEmisoraMunicipio
	 *            the entidad emisora municipio
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @return ObjPasarela
	 * @throws ParseException
	 *             the parse exception
	 */
	public ObjPasarela crearObjetoPasarela(TramiteSANLiquidacion tramite,
			Conceptopago conceptoPago, Pagos pago, String appPresupuestaria,
			Saninterv sancionado, Date fechaResolucion, Long numReferencia,
			String entidadEmisoraMunicipio, String tipoDevengo)
			throws ParseException;

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param tramiteComun
	 *            the tramite comun
	 * @param request
	 *            the request
	 * @param fecha
	 *            the fecha
	 * @param concepto
	 *            the concepto
	 * @param response
	 *            the response
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @throws Exception
	 *             the exception
	 */
	public void generarDocLiquidacion(TramiteComun tramiteComun,
			HttpServletRequest request, String fecha, String concepto,
			HttpServletResponse response, String tipoDevengo, String nombre,
			String apellido1, String apellido2) throws Exception;

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param tramiteComun
	 *            the tramite comun
	 * @param request
	 *            the request
	 * @param fecha
	 *            the fecha
	 * @param concepto
	 *            the concepto
	 * @param response
	 *            the response
	 * @param tipoDevengo
	 *            the tipo devengo
	 * @throws Exception
	 *             the exception
	 */
	public void generarDocResolucionComplementaria(TramiteComun tramiteComun,
			HttpServletRequest request, String fecha, String concepto,
			HttpServletResponse response, String tipoDevengo, String nombre,
			String apellido1, String apellido2) throws Exception;

	/**
	 * Generar doc liquidacion.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param request
	 *            the request
	 * @param response
	 *            the response
	 * @throws Exception
	 *             the exception
	 */
	public void generarDocOtrosIngresos(Pagos pagos, Saninterv saninterv,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception;
}
