package com.ejie.y41b.adapter.services;

/**
 * Y41bPlateaService.
 * 
 *  
 */

public interface Y41bPlateaService {

	/**
	 * Método que invoca al webService getProcedureDataAsXml de la
	 * administración para obtener los datos del catálogo de Procedimientos
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param procedureId
	 *            String: id del procedimiento en el catálogo de procedimientos
	 * @return String: XML con los datos del procedimiento
	 * @throws Exception
	 *             ex
	 */
	public String obtenerDatosCatalogoProcedimientos(String tokenSesion,
			String procedureId) throws Exception;;

	/**
	 * Método que invoca al webService sendEjgvDocumentPresencial de la
	 * administración para crear la solicitud presencial
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param contextSubmission
	 *            String: Xml que lleva toda los datos necesarios para crear la
	 *            Solicitud presencial
	 * @return String: Xml que representa la respuesta del envío de la
	 *         solicitud.
	 * @throws Exception
	 *             ex
	 */
	public String crearSolicitudPresencial(String tokenSesion,
			String contextSubmission) throws Exception;;

	/**
	 * Metodo que invoca al webService saveOrUpdateExpedientNT de la
	 * administracin para actualizar mis gestiones
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param sXMLExpedient
	 *            String: Xml que lleva toda los datos necesarios para atualizar
	 *            mis gestiones
	 * @return String: Xml que representa la respuesta
	 * @throws Exception
	 *             ex
	 * 
	 */
	public String actualizarMisGestiones(String tokenSesion,
			String sXMLExpedient) throws Exception;

	/**
	 * Metodo que invoca al webService deleteProceedingsNT de la administracin
	 * para eliminar de mis gestiones
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param sXMLExpedient
	 *            String: Xml que lleva toda los datos necesarios para atualizar
	 *            mis gestiones
	 * @return String: Xml que representa la respuesta
	 * @throws Exception
	 * 
	 */
	public String eliminarMisGestiones(String tokenSesion, String sXMLExpedient)
			throws Exception;

	/**
	 * Metodo que invoca al webService saveOrUpdateExpedientNT de la
	 * administracin para actualizar mis gestiones
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param sXMLExpedient
	 *            String: Xml que lleva toda los datos necesarios para atualizar
	 *            mis gestiones
	 * @return String: Xml que representa la respuesta
	 * @throws Exception
	 *             ex
	 * 
	 */
	public String actualizarExpediente(String tokenSesion, String sXMLExpedient)
			throws Exception;

	/**
	 * Método que realiza la apertura de un expediente
	 * 
	 * @param tokenSesion
	 *            String
	 * @param sXMLExpedient
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String abrirExpediente(String tokenSesion, String sXMLExpedient)
			throws Exception;

	/**
	 * Método que realiza la apertura de un expediente de oficio
	 * 
	 * @param tokenSesion
	 *            String
	 * @param sXMLExpedient
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String abrirExpedienteOficio(String tokenSesion, String sXMLExpedient)
			throws Exception;

	/**
	 * Método que realiza el cierre de un expediente en Mis Gestiones
	 * 
	 * @param tokenSesion
	 *            String
	 * @param xmlCierre
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String cerrarExpediente(String tokenSesion, String xmlCierre)
			throws Exception;;

	/**
	 * Método que crea un registro de entrada
	 * 
	 * @param tokenSesion
	 *            String
	 * @param sXmlContextRegistry
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String obtenerRegistroEntrada(String tokenSesion,
			String sXmlContextRegistry) throws Exception;;

	/**
	 * Método que crea un registro de salida
	 * 
	 * @param tokenSesion
	 *            String
	 * @param sXmlExitRegistryCreationInfo
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String obtenerRegistroSalida(String tokenSesion,
			String sXmlExitRegistryCreationInfo) throws Exception;;

	/**
	 * Obtiene un xml con la información contenida en el certificado
	 * 
	 * @param tokenSesion
	 *            el token
	 * @param firmaSimple
	 *            la firma simple
	 * @return String datos del certificado
	 * @throws Exception
	 *             ex
	 */
	public String obtenerDatosCertificadoFirma(String tokenSesion,
			String firmaSimple) throws Exception;;

	/**
	 * Obtiene el ejgvDocument de la solicitud o aportación.
	 * 
	 * @param tokenSesion
	 *            Token de sesión en XLNets
	 * @param xmlDocument
	 *            Documento XML con los datos computables de la solicitud
	 * @param xslDocument
	 *            Documento XSL con la presentación de la solicitud
	 * @param textoPlano
	 *            Texto a firmar por el ciudadano.
	 * @return String Documento de la solicitud, representa el html del
	 *         justificante en base64
	 * @throws Exception
	 *             ex
	 */
	public String crearEJGVDocumentSolicitud(String tokenSesion,
			String xmlDocument, String xslDocument, String textoPlano)
			throws Exception;;

	/**
	 * Obtiene el ejgvDocument de notificacion.
	 * 
	 * @param tokenSesion
	 *            Token de sesión en XLNets
	 * @param xmlDocumentNotif
	 *            Documento XML con los datos de la notificacion
	 * 
	 * @return String Documento de la solicitud, representa el html del
	 *         justificante en base64
	 * @throws Exception
	 *             ex
	 */
	public String crearEJGVDocumentNotificacion(String tokenSesion,
			String xmlDocumentNotif) throws Exception;

	/**
	 * Obtiene el HTML de la Notificacion a partir del Identificador de la
	 * Notificacion
	 * 
	 * @param tokenSesion
	 *            Token de sesión en XLNets
	 * @param sNotifID
	 *            Id de la notificacion
	 * @param sAuditUser
	 *            Usuario
	 * @return String HTML de la Notificacion
	 * @throws Exception
	 */
	public String getNotificacionById(String tokenSesion, String sNotifID,
			String sAuditUser) throws Exception;

	/**
	 * Obtiene el HTML del acuse a partir del Identificador de la Notificacion
	 * 
	 * @param tokenSesion
	 *            Token de sesión en XLNets
	 * @param sNotifID
	 *            Id de la notificacion
	 * @param sAuditUser
	 *            Usuario
	 * @return String HTML de la Notificacion
	 * @throws Exception
	 */
	public String getAcuseById(String tokenSesion, String sNotifID,
			String sAuditUser) throws Exception;

	/**
	 * Añade en el pie de un EJGVDocument los datos de la firma del mismo
	 * 
	 * @param tokenSesion
	 *            String
	 * @param ejgvDocument
	 *            String
	 * @param firma
	 *            String
	 * @return String con el EJGVdocument y la firma
	 * @throws Exception
	 *             ex
	 */
	public String anyadirFirmaEjgvDocumentSolicitud(String tokenSesion,
			String ejgvDocument, String firma) throws Exception;;

	/**
	 * Realiza el envío telemático de una solicitud(EJGVDocument)
	 * 
	 * @param tokenSesion
	 *            String
	 * @param contextSubmission
	 *            String: Xml que lleva toda los datos necesarios para crear la
	 *            Solicitud
	 * @param baEjgvDocument
	 *            String
	 * @return String con el EJGVdocument y la firma
	 * @throws Exception
	 *             ex
	 */
	public String envioSolicitudes(String tokenSesion,
			String contextSubmission, String baEjgvDocument) throws Exception;;

	/**
	 * Realiza el envío de una notificacion
	 * 
	 * @param tokenSesion
	 *            String
	 * @param sUnsignedNotification
	 *            String
	 * @param bytesNotification
	 *            String
	 * @return String con el Numero de Registro
	 * @throws Exception
	 *             ex
	 */
	public String envioNotificaciones(String tokenSesion,
			String sUnsignedNotification, String bytesNotification)
			throws Exception;;

	/**
	 * Método que sirve para procesar las esperas
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param xmlEspera
	 *            String
	 * @param tipoEspera
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String crearMatarEspera(String tokenSesion, String xmlEspera,
			String tipoEspera) throws Exception;

	/**
	 * Método que sirve para registrar en mis gestiones datos del histórico
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param xmlHistorico
	 *            String
	 * @param tipoHistorico
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String registrarHistorico(String tokenSesion, String xmlHistorico,
			String tipoHistorico) throws Exception;

	/**
	 * Método que sirve para eliminar en mis gestiones datos del histórico
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param xmlHistorico
	 *            String
	 * @param tipoHistorico
	 *            String
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String eliminarHistorico(String tokenSesion, String xmlHistorico,
			String tipoHistorico) throws Exception;

	/**
	 * Metodo que invoca al webService saveOrUpdateExpedientNT de la
	 * administracin para actualizar mis gestiones
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param sXMLExpedient
	 *            String: Xml que lleva toda los datos necesarios para atualizar
	 *            mis gestiones
	 * @return String: Xml que representa la respuesta
	 * @throws Exception
	 * 
	 */
	public String actualizarParticipantExpediente(String tokenSesion,
			String sXMLExpedient) throws Exception;

	/**
	 * Metodo que invoca al webService saveOrUpdateExpedientNT de la
	 * administracin para actualizar mis gestiones
	 * 
	 * @param tokenSesion
	 *            String: Token de sesion
	 * @param sXMLExpedient
	 *            String: Xml que lleva toda los datos necesarios para atualizar
	 *            mis gestiones
	 * @return String: Xml que representa la respuesta
	 * @throws Exception
	 *             ex
	 * 
	 */
	public String cancelarCierreExpediente(String tokenSesion,
			String sXMLExpedient) throws Exception;
}
