/**
 * 
 */
package com.ejie.y41b.adapter.services;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 *  
 * 
 */
@Service(value = "Y41bPifServiceImpl")
public class Y41bPifServiceImpl implements Y41bPifService {

	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bPifServiceImpl.class);

	/**
	 * Clase que hara de facade para invocar los servicios de PIF
	 */
	private Y41bPifServiceImpl() {
		super();
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param file
	 *            Stream de datos para acceder al contenido a copiar en el
	 *            repositorio
	 * @param pathTo
	 *            Ruta lógica donde alojar el fichero. Incluirá como carpeta
	 *            principal la aplicación destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @param Ttl
	 *            Número de segundos que se desea mantener el fichero en el
	 *            repositorio. Como máximo se podrá fijar el número de
	 *            segundos de 15 días naturales
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 *             excepcion en el PIF
	 */
	public Y31AttachmentBean putFile(Document sSessionToken, InputStream file,
			String pathTo, boolean preserveName, Long Ttl) throws Exception {

		logger.info("Y41bPifServiceImpl.putFile - Inicio");
		try {
			Y31JanoService service = Y31JanoServiceAbstractFactory
					.getInstance();

			// Preparando los par�metros
			// Document sesion = null;
			// String to = "/r09/dni.doc";

			// Long expirationSecs = new Long(60 * 60 * 2); // 2 horas

			// invocando el metodo
			return service.put(sSessionToken, file, pathTo, preserveName, Ttl);

		} catch (Y31JanoServiceGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceEventJmsException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} finally {
			logger.info("Y41bPifServiceImpl.putFile - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica de donde se va a descargar el fichero. Incluirá
	 *            como carpeta principal la aplicación destino
	 * @return InputStream
	 * @throws Exception
	 */
	public BufferedInputStream getFile(Document sSessionToken, String pathFrom)
			throws Exception {
		logger.info("Y41bPifServiceImpl.getFile - Inicio");
		// obteniendo un objeto service
		Y31JanoService service;
		try {
			service = Y31JanoServiceAbstractFactory.getInstance();

			// invocando el metodo
			return new BufferedInputStream(service.get(sSessionToken, pathFrom));
		} catch (Y31JanoServiceGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceOracleGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} finally {
			logger.info("Y41bPifServiceImpl.getFile - Final");
		}

	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param pathTo
	 *            Ruta lógica donde se va a mover el fichero. Incluirá como
	 *            carpeta principal la aplicación destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean moveFile(Document sSessionToken, String pathFrom,
			String pathTo, boolean preserveName) throws Exception {
		logger.info("Y41bPifServiceImpl.moveFile - Inicio");
		try {
			// obteniendo un objeto service
			Y31JanoService service = Y31JanoServiceAbstractFactory
					.getInstance();

			// Preparando los par�metros
			// Document sesion = null;
			// String from = "/r09/dni.doc";
			// String to = "/r02/dni.doc";

			// invocando el metodo
			return service.move(sSessionToken, pathFrom, pathTo, preserveName);

		} catch (Y31JanoServiceGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceEventJmsException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} finally {
			logger.info("Y41bPifServiceImpl.moveFile - Final");
		}

	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param pathTo
	 *            Ruta lógica donde se va a mover el fichero. Incluirá como
	 *            carpeta principal la aplicación destino
	 * @param boolena
	 *            preserveName preserveName
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean copyFile(Document sSessionToken, String pathFrom,
			String pathTo, boolean preserveName) throws Exception {
		logger.info("Y41bPifServiceImpl.copyFile - Inicio");
		try {
			// obteniendo un objeto service
			Y31JanoService service = Y31JanoServiceAbstractFactory
					.getInstance();

			// Preparando los par�metros
			// Document sesion=null;
			// String from="/r02/dni.doc";
			// String to="/r09/dni_2.doc";

			// boolean preserveName = false;

			// invocando el metodo
			return service.copy(sSessionToken, pathFrom, pathTo, preserveName);

		} catch (Y31JanoServiceGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceEventJmsException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} finally {
			logger.info("Y41bPifServiceImpl.copyFile - Final");
		}

	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @return List<Y31AttachmentBean>
	 * @throws Exception
	 */
	public List<Y31AttachmentBean> listFile(Document sSessionToken,
			String pathFrom) throws Exception {
		logger.info("Y41bPifServiceImpl.listFile - Inicio");
		try {
			// obteniendo un objeto service
			Y31JanoService service = Y31JanoServiceAbstractFactory
					.getInstance();

			// Preparando los par�metros
			// Document sesion=null;
			// String from="/r09/";

			// invocando el metodo
			return (List<Y31AttachmentBean>) service.list(sSessionToken,
					pathFrom);
			// Y31AttachmentBean resul = null;
			// for (int i = 0; i < files.size(); i++) {
			// resul = (Y31AttachmentBean) files.get(i);
			// }
			// return files;
		} catch (Y31JanoServiceGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceMongoDbGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} finally {
			logger.info("Y41bPifServiceImpl.listFile - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @throws Exception
	 */
	public void deleteFile(Document sSessionToken, String pathFrom)
			throws Exception {
		logger.info("Y41bPifServiceImpl.deleteFile - Inicio");
		try {
			// obteniendo un objeto service
			Y31JanoService service = Y31JanoServiceAbstractFactory
					.getInstance();

			// invocando el metodo
			service.delete(sSessionToken, pathFrom);

		} catch (Y31JanoServiceGenericException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} catch (Y31JanoServiceFileNotFoundException e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		} finally {
			logger.info("Y41bPifServiceImpl.deleteFile - Final");
		}

	}
}
